/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors.inference;

import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrOperatorExpression;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyCallReference;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.GrConstraintFormula;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.GroovyInferenceSession;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.MethodCallConstraint;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\b\u0000\u0012\u00020\f0\u000bH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/OperatorExpressionConstraint;", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/GrConstraintFormula;", "expression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrOperatorExpression;", "<init>", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrOperatorExpression;)V", "reduce", "", "session", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/GroovyInferenceSession;", "constraints", "", "Lcom/intellij/psi/impl/source/resolve/graphInference/constraints/ConstraintFormula;", "toString", "", "intellij.groovy.psi"})
public final class OperatorExpressionConstraint
extends GrConstraintFormula {
    @NotNull
    private final GrOperatorExpression expression;

    public OperatorExpressionConstraint(@NotNull GrOperatorExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        this.expression = expression;
    }

    @Override
    public boolean reduce(@NotNull GroovyInferenceSession session, @NotNull List<? super ConstraintFormula> constraints) {
        Intrinsics.checkNotNullParameter((Object)((Object)session), (String)"session");
        Intrinsics.checkNotNullParameter(constraints, (String)"constraints");
        GroovyCallReference reference = this.expression.getReference();
        if (reference != null) {
            GroovyResolveResult groovyResolveResult = reference.advancedResolve();
            Intrinsics.checkNotNullExpressionValue((Object)groovyResolveResult, (String)"advancedResolve(...)");
            GroovyResolveResult result2 = groovyResolveResult;
            if (result2 instanceof GroovyMethodResult) {
                constraints.add(new MethodCallConstraint(null, (GroovyMethodResult)result2, this.expression));
            }
        }
        return true;
    }

    @Override
    @NotNull
    public String toString() {
        return this.expression.getText() + " -> null";
    }
}

