/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator;

import com.intellij.internal.statistic.eventLog.EventLogBuild;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.validator.IEventContext;
import com.intellij.internal.statistic.eventLog.validator.IEventGroupRules;
import com.intellij.internal.statistic.eventLog.validator.IEventGroupsFilterRules;
import com.intellij.internal.statistic.eventLog.validator.IGroupValidators;
import com.intellij.internal.statistic.eventLog.validator.SensitiveDataValidator;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.beans.EventGroupRules;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRuleFactory;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.RecorderDataValidationRule;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.TestModeValidationRule;
import com.intellij.internal.statistic.eventLog.validator.storage.FusComponentProvider;
import com.intellij.internal.statistic.eventLog.validator.storage.IntellijValidationRulesStorage;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.StatisticsRecorderUtil;
import com.intellij.internal.statistic.utils.StatisticsUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.fus.reporting.MessageBus;
import com.jetbrains.fus.reporting.MetadataStorage;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntellijSensitiveDataValidator
extends SensitiveDataValidator<MetadataStorage<EventLogBuild>> {
    private static final ConcurrentMap<String, IntellijSensitiveDataValidator> ourInstances = new ConcurrentHashMap<String, IntellijSensitiveDataValidator>();
    private final FusComponentProvider.FusComponents myFusComponents;
    private final String myRecorderId;

    public static void clearInstances() {
        ourInstances.clear();
    }

    @NotNull
    public static IntellijSensitiveDataValidator getInstance(@NotNull String recorderId) {
        if (recorderId == null) {
            IntellijSensitiveDataValidator.$$$reportNull$$$0(0);
        }
        IntellijSensitiveDataValidator intellijSensitiveDataValidator = ourInstances.computeIfAbsent(recorderId, id -> ApplicationManager.getApplication().isUnitTestMode() ? new BlindSensitiveDataValidator(FusComponentProvider.createBlindFusComponents(id), (String)id) : new IntellijSensitiveDataValidator(FusComponentProvider.createFusComponents(id), (String)id));
        if (intellijSensitiveDataValidator == null) {
            IntellijSensitiveDataValidator.$$$reportNull$$$0(1);
        }
        return intellijSensitiveDataValidator;
    }

    @Nullable
    public static IntellijSensitiveDataValidator getIfInitialized(@NotNull String recorderId) {
        if (recorderId == null) {
            IntellijSensitiveDataValidator.$$$reportNull$$$0(2);
        }
        return (IntellijSensitiveDataValidator)((Object)ourInstances.get(recorderId));
    }

    protected IntellijSensitiveDataValidator(@NotNull FusComponentProvider.FusComponents fusComponents, @NotNull String recorderId) {
        if (fusComponents == null) {
            IntellijSensitiveDataValidator.$$$reportNull$$$0(3);
        }
        if (recorderId == null) {
            IntellijSensitiveDataValidator.$$$reportNull$$$0(4);
        }
        super(fusComponents.getMetadataStorage());
        this.myFusComponents = fusComponents;
        this.myRecorderId = recorderId;
    }

    @Deprecated
    protected IntellijSensitiveDataValidator(@NotNull IntellijValidationRulesStorage storage, @NotNull String recorderId) {
        if (storage == null) {
            IntellijSensitiveDataValidator.$$$reportNull$$$0(5);
        }
        if (recorderId == null) {
            IntellijSensitiveDataValidator.$$$reportNull$$$0(6);
        }
        super((MetadataStorage)new MetadataStorage<EventLogBuild>(){

            @Nullable
            public Object update(@NotNull CoroutineScope scope, @NotNull Continuation<? super Job> continuation) {
                if (scope == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (continuation == null) {
                    1.$$$reportNull$$$0(1);
                }
                return null;
            }

            public boolean update() {
                return false;
            }

            public void reload() {
            }

            @NotNull
            public Set<String> getFieldsToAnonymize(@NotNull String s, @NotNull String s1) {
                if (s == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (s1 == null) {
                    1.$$$reportNull$$$0(3);
                }
                Set<String> set = Set.of();
                if (set == null) {
                    1.$$$reportNull$$$0(4);
                }
                return set;
            }

            @NotNull
            public Set<String> getSkipAnonymizationIds() {
                Set<String> set = Set.of();
                if (set == null) {
                    1.$$$reportNull$$$0(5);
                }
                return set;
            }

            @NotNull
            public IGroupValidators<EventLogBuild> getGroupValidators(@NotNull String s) {
                if (s == null) {
                    1.$$$reportNull$$$0(6);
                }
                return new IGroupValidators<EventLogBuild>(this){

                    @Nullable
                    public IEventGroupRules getEventGroupRules() {
                        return null;
                    }

                    @Nullable
                    public IEventGroupsFilterRules<EventLogBuild> getVersionFilter() {
                        return null;
                    }
                };
            }

            public boolean isUnreachable() {
                return false;
            }

            @NotNull
            public RecorderDataValidationRule getSystemDataRulesRevisions() {
                if (null == null) {
                    1.$$$reportNull$$$0(7);
                }
                return null;
            }

            @NotNull
            public RecorderDataValidationRule getClientDataRulesRevisions() {
                if (null == null) {
                    1.$$$reportNull$$$0(8);
                }
                return null;
            }

            @NotNull
            public RecorderDataValidationRule getIdsRulesRevisions() {
                if (null == null) {
                    1.$$$reportNull$$$0(9);
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 4, 5, 7, 8, 9 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "scope";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "continuation";
                        break;
                    }
                    case 2: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "s";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "s1";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 7: 
                    case 8: 
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/internal/statistic/eventLog/validator/IntellijSensitiveDataValidator$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/internal/statistic/eventLog/validator/IntellijSensitiveDataValidator$1";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFieldsToAnonymize";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSkipAnonymizationIds";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSystemDataRulesRevisions";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getClientDataRulesRevisions";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIdsRulesRevisions";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "getFieldsToAnonymize";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 7: 
                    case 8: 
                    case 9: {
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "getGroupValidators";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 4, 5, 7, 8, 9 -> new IllegalStateException(string);
                };
            }
        });
        this.myFusComponents = null;
        this.myRecorderId = recorderId;
    }

    public MessageBus getMessageBus() {
        return this.myFusComponents.getMessageBus();
    }

    public boolean isGroupAllowed(@NotNull EventLogGroup group) {
        if (group == null) {
            IntellijSensitiveDataValidator.$$$reportNull$$$0(7);
        }
        if (StatisticsRecorderUtil.isTestModeEnabled(this.myRecorderId)) {
            return true;
        }
        MetadataStorage storage = this.getValidationRulesStorage();
        if (storage.isUnreachable()) {
            return true;
        }
        return storage.getGroupValidators(group.getId()).getEventGroupRules() != null;
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="2026.1")
    public String guaranteeCorrectEventId(@NotNull EventContext context, @Nullable EventGroupRules groupRules) {
        if (context == null) {
            IntellijSensitiveDataValidator.$$$reportNull$$$0(8);
        }
        return null;
    }

    @NotNull
    public String guaranteeCorrectEventId(@NotNull IEventContext context, @Nullable IEventGroupRules groupRules) {
        String result;
        if (context == null) {
            IntellijSensitiveDataValidator.$$$reportNull$$$0(9);
        }
        if (context instanceof EventContext && groupRules instanceof EventGroupRules && (result = this.guaranteeCorrectEventId((EventContext)context, (EventGroupRules)groupRules)) != null) {
            String string = result;
            if (string == null) {
                IntellijSensitiveDataValidator.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = super.guaranteeCorrectEventId(context, groupRules);
        if (string == null) {
            IntellijSensitiveDataValidator.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="2026.1")
    public Map<String, Object> guaranteeCorrectEventData(@NotNull EventContext context, EventGroupRules groupRules) {
        if (context == null) {
            IntellijSensitiveDataValidator.$$$reportNull$$$0(12);
        }
        return null;
    }

    @NotNull
    public Map<String, Object> guaranteeCorrectEventData(@NotNull IEventContext context, IEventGroupRules groupRules) {
        Map<String, Object> result;
        if (context == null) {
            IntellijSensitiveDataValidator.$$$reportNull$$$0(13);
        }
        if (context instanceof EventContext && groupRules instanceof EventGroupRules && (result = this.guaranteeCorrectEventData((EventContext)context, (EventGroupRules)groupRules)) != null) {
            Map<String, Object> map = result;
            if (map == null) {
                IntellijSensitiveDataValidator.$$$reportNull$$$0(14);
            }
            return map;
        }
        if (this.isTestModeEnabled(groupRules)) {
            Map map = context.getEventData();
            if (map == null) {
                IntellijSensitiveDataValidator.$$$reportNull$$$0(15);
            }
            return map;
        }
        Map validatedData = super.guaranteeCorrectEventData(context, groupRules);
        boolean containsPluginInfo = validatedData.containsKey("plugin") || validatedData.containsKey("plugin_type") || validatedData.containsKey("plugin_version");
        PluginInfo pluginInfo = (PluginInfo)context.getPayload(CustomValidationRule.PLUGIN_INFO);
        if (pluginInfo != null && !containsPluginInfo) {
            StatisticsUtil.addPluginInfoTo(pluginInfo, validatedData);
        }
        Map map = validatedData;
        if (map == null) {
            IntellijSensitiveDataValidator.$$$reportNull$$$0(16);
        }
        return map;
    }

    private boolean isTestModeEnabled(@Nullable IEventGroupRules rule) {
        return StatisticsRecorderUtil.isTestModeEnabled(this.myRecorderId) && rule != null && ContainerUtil.exists((Object[])rule.getEventIdRules(), r -> r instanceof TestModeValidationRule);
    }

    public void update() {
        this.getValidationRulesStorage().update();
    }

    static {
        CustomValidationRule.EP_NAME.addChangeListener(ourInstances::clear, null);
        CustomValidationRuleFactory.EP_NAME.addChangeListener(ourInstances::clear, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 10, 11, 14, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recorderId";
                break;
            }
            case 1: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/validator/IntellijSensitiveDataValidator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fusComponents";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/validator/IntellijSensitiveDataValidator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "guaranteeCorrectEventId";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "guaranteeCorrectEventData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getIfInitialized";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isGroupAllowed";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "guaranteeCorrectEventId";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "guaranteeCorrectEventData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 10, 11, 14, 15, 16 -> new IllegalStateException(string);
        };
    }

    private static class BlindSensitiveDataValidator
    extends IntellijSensitiveDataValidator {
        protected BlindSensitiveDataValidator(@NotNull FusComponentProvider.FusComponents fusComponents, @NotNull String recorderId) {
            if (fusComponents == null) {
                BlindSensitiveDataValidator.$$$reportNull$$$0(0);
            }
            if (recorderId == null) {
                BlindSensitiveDataValidator.$$$reportNull$$$0(1);
            }
            super(fusComponents, recorderId);
        }

        @Override
        @NotNull
        public String guaranteeCorrectEventId(@NotNull IEventContext context, @Nullable IEventGroupRules groupRules) {
            if (context == null) {
                BlindSensitiveDataValidator.$$$reportNull$$$0(2);
            }
            String string = context.getEventId();
            if (string == null) {
                BlindSensitiveDataValidator.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @NotNull
        public Map<String, Object> guaranteeCorrectEventData(@NotNull IEventContext context, IEventGroupRules groupRules) {
            if (context == null) {
                BlindSensitiveDataValidator.$$$reportNull$$$0(4);
            }
            Map map = context.getEventData();
            if (map == null) {
                BlindSensitiveDataValidator.$$$reportNull$$$0(5);
            }
            return map;
        }

        @Override
        public boolean isGroupAllowed(@NotNull EventLogGroup group) {
            if (group == null) {
                BlindSensitiveDataValidator.$$$reportNull$$$0(6);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fusComponents";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "recorderId";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/eventLog/validator/IntellijSensitiveDataValidator$BlindSensitiveDataValidator";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/eventLog/validator/IntellijSensitiveDataValidator$BlindSensitiveDataValidator";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "guaranteeCorrectEventId";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "guaranteeCorrectEventData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "guaranteeCorrectEventId";
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "guaranteeCorrectEventData";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isGroupAllowed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 5 -> new IllegalStateException(string);
            };
        }
    }
}

