/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public final class ExtendedSentenceRange
implements Comparable<ExtendedSentenceRange> {
    private final int fromPos;
    private final int toPos;
    private final Map<String, Float> languageConfidenceRates;

    ExtendedSentenceRange(int fromPos, int toPos, String languageCode) {
        this(fromPos, toPos, Collections.singletonMap(languageCode, Float.valueOf(1.0f)));
    }

    ExtendedSentenceRange(int fromPos, int toPos, @NotNull Map<String, Float> languageConfidenceRates) {
        this.fromPos = fromPos;
        this.toPos = toPos;
        this.languageConfidenceRates = new LinkedHashMap<String, Float>(languageConfidenceRates);
    }

    public void updateLanguageConfidenceRates(@NotNull Map<String, Float> languageConfidenceRates) {
        this.languageConfidenceRates.clear();
        this.languageConfidenceRates.putAll(languageConfidenceRates);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtendedSentenceRange extendedSentenceRange = (ExtendedSentenceRange)o;
        return this.fromPos == extendedSentenceRange.fromPos && this.toPos == extendedSentenceRange.toPos;
    }

    public int hashCode() {
        int result = this.fromPos;
        result = 31 * result + this.toPos;
        return result;
    }

    public String toString() {
        return this.fromPos + "-" + this.toPos + ":" + String.valueOf(this.languageConfidenceRates);
    }

    @Override
    public int compareTo(@NotNull ExtendedSentenceRange o) {
        return Integer.compare(this.fromPos, o.fromPos);
    }

    @Generated
    public int getFromPos() {
        return this.fromPos;
    }

    @Generated
    public int getToPos() {
        return this.toPos;
    }

    @Generated
    public Map<String, Float> getLanguageConfidenceRates() {
        return this.languageConfidenceRates;
    }
}

