/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.codeInspection.groovy;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.codeInspection.GradleInspectionBundle;
import org.jetbrains.plugins.gradle.codeInspection.groovy.GroovyPluginDslStructureInspectionVisitorKt;
import org.jetbrains.plugins.gradle.config.GradleFileTypeKt;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/gradle/codeInspection/groovy/GroovyPluginDslStructureInspectionVisitor;", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;)V", "getHolder", "()Lcom/intellij/codeInspection/ProblemsHolder;", "visitFile", "", "file", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyFileBase;", "intellij.gradle.java"})
@SourceDebugExtension(value={"SMAP\nGroovyPluginDslStructureInspectionVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GroovyPluginDslStructureInspectionVisitor.kt\norg/jetbrains/plugins/gradle/codeInspection/groovy/GroovyPluginDslStructureInspectionVisitor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,128:1\n1772#2,6:129\n*S KotlinDebug\n*F\n+ 1 GroovyPluginDslStructureInspectionVisitor.kt\norg/jetbrains/plugins/gradle/codeInspection/groovy/GroovyPluginDslStructureInspectionVisitor\n*L\n26#1:129,6\n*E\n"})
public final class GroovyPluginDslStructureInspectionVisitor
extends GroovyElementVisitor {
    @NotNull
    private final ProblemsHolder holder;

    public GroovyPluginDslStructureInspectionVisitor(@NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.holder = holder;
    }

    @NotNull
    public final ProblemsHolder getHolder() {
        return this.holder;
    }

    public void visitFile(@NotNull GroovyFileBase file) {
        int lastPluginsStatement;
        Object[] statements;
        block4: {
            int n;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            if (!GradleFileTypeKt.isGradleFile((PsiFile)file)) {
                return;
            }
            Object[] objectArray = file.getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getStatements(...)");
            Object[] $this$indexOfFirst$iv = statements = objectArray;
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length;
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                GrStatement it = $this$indexOfFirst$iv[index$iv];
                boolean bl = false;
                if (!(it instanceof GrMethodCall && Intrinsics.areEqual((Object)((GrMethodCall)it).getInvokedExpression().getText(), (Object)"plugins"))) continue;
                n = index$iv;
                break block4;
            }
            n = lastPluginsStatement = -1;
        }
        if (lastPluginsStatement == -1) {
            return;
        }
        GrStatement grStatement = statements[lastPluginsStatement];
        Intrinsics.checkNotNull((Object)grStatement, (String)"null cannot be cast to non-null type org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall");
        GrMethodCall pluginsStatement = (GrMethodCall)grStatement;
        GroovyPluginDslStructureInspectionVisitorKt.access$checkPluginsStatement(this.holder, pluginsStatement);
        List statementsToCheck = ArraysKt.asList((Object[])statements).subList(0, lastPluginsStatement);
        for (GrStatement suspiciousStatement : statementsToCheck) {
            PsiElement psiToHighlight;
            Intrinsics.checkNotNull((Object)suspiciousStatement);
            if (GroovyPluginDslStructureInspectionVisitorKt.access$getBadStatementHighlightingElement(suspiciousStatement) == null) continue;
            this.holder.registerProblem(psiToHighlight, GradleInspectionBundle.message("inspection.message.incorrect.buildscript.structure", new Object[0]), ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[0]);
        }
    }
}

