/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import java.util.logging.Level;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public enum LogLevel {
    OFF(Level.OFF),
    ERROR(Level.SEVERE),
    WARNING(Level.WARNING),
    INFO(Level.INFO),
    DEBUG(Level.FINE),
    TRACE(Level.FINER),
    ALL(Level.ALL);

    private final Level myLevel;

    private LogLevel(Level level) {
        this.myLevel = level;
    }

    @ApiStatus.Internal
    public Level getLevel() {
        return this.myLevel;
    }

    public String getLevelName() {
        return this.myLevel.getName();
    }

    @NotNull
    public String getPrettyLevelName() {
        return LogLevel.getPrettyLevelName(this.myLevel);
    }

    @NotNull
    static String getPrettyLevelName(@NotNull Level level) {
        if (level == null) {
            LogLevel.$$$reportNull$$$0(0);
        }
        String string = level == Level.WARNING ? "WARN" : level.getName();
        if (string == null) {
            LogLevel.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diagnostic/LogLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diagnostic/LogLevel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrettyLevelName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPrettyLevelName";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

