/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.elements;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassGenerationSupport;
import org.jetbrains.kotlin.asJava.UtilsKt;
import org.jetbrains.kotlin.asJava.elements.KtLightAnnotationsValuesKt;
import org.jetbrains.kotlin.asJava.elements.KtLightElementBase;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0006H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0015\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/asJava/elements/KtLightPsiLiteral;", "Lorg/jetbrains/kotlin/asJava/elements/KtLightElementBase;", "Lcom/intellij/psi/PsiLiteralExpression;", "kotlinOrigin", "Lorg/jetbrains/kotlin/psi/KtExpression;", "lightParent", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lcom/intellij/psi/PsiElement;)V", "getKotlinOrigin", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "getValue", "", "getType", "Lcom/intellij/psi/PsiType;", "getParent", "isPhysical", "", "replace", "newElement", "getReference", "Lcom/intellij/psi/PsiReference;", "getReferences", "", "()[Lcom/intellij/psi/PsiReference;", "light-classes"})
public class KtLightPsiLiteral
extends KtLightElementBase
implements PsiLiteralExpression {
    @NotNull
    private final KtExpression kotlinOrigin;
    @NotNull
    private final PsiElement lightParent;

    public KtLightPsiLiteral(@NotNull KtExpression kotlinOrigin, @NotNull PsiElement lightParent) {
        Intrinsics.checkNotNullParameter((Object)kotlinOrigin, (String)"kotlinOrigin");
        Intrinsics.checkNotNullParameter((Object)lightParent, (String)"lightParent");
        super(lightParent);
        this.kotlinOrigin = kotlinOrigin;
        this.lightParent = lightParent;
    }

    @NotNull
    public KtExpression getKotlinOrigin() {
        return this.kotlinOrigin;
    }

    @Nullable
    public Object getValue() {
        return UtilsKt.computeExpression((PsiElement)this);
    }

    @Nullable
    public PsiType getType() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        BindingContext bindingContext = LightClassGenerationSupport.Companion.getInstance(project).analyze((KtElement)this.getKotlinOrigin());
        KotlinType kotlinType = (KotlinType)bindingContext.get(BindingContext.EXPECTED_EXPRESSION_TYPE, this.getKotlinOrigin());
        if (kotlinType == null) {
            return null;
        }
        KotlinType kotlinType2 = kotlinType;
        Object object = kotlinType2.getConstructor().getDeclarationDescriptor();
        if (object == null || (object = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)object)) == null || (object = object.asString()) == null) {
            return null;
        }
        Object typeFqName = object;
        return KtLightAnnotationsValuesKt.psiType$default((String)typeFqName, (PsiElement)((PsiElement)this.getKotlinOrigin()), (boolean)false, (int)4, null);
    }

    @NotNull
    public PsiElement getParent() {
        return this.lightParent;
    }

    public boolean isPhysical() {
        return false;
    }

    @NotNull
    public PsiElement replace(@NotNull PsiElement newElement) {
        Intrinsics.checkNotNullParameter((Object)newElement, (String)"newElement");
        PsiLiteral psiLiteral = newElement instanceof PsiLiteral ? (PsiLiteral)newElement : null;
        Object object = psiLiteral != null ? psiLiteral.getValue() : null;
        String string = object instanceof String ? (String)object : null;
        if (string == null) {
            return (PsiElement)this;
        }
        String value = string;
        KtExpression ktExpression = this.getKotlinOrigin();
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ktExpression.replace((PsiElement)new KtPsiFactory(project, false, 2, null).createExpression('\"' + StringUtil.escapeStringCharacters((String)value) + '\"'));
        return (PsiElement)this;
    }

    @Nullable
    public PsiReference getReference() {
        return (PsiReference)ArraysKt.singleOrNull((Object[])this.getReferences());
    }

    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = this.getKotlinOrigin().getReferences();
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
        return psiReferenceArray;
    }
}

