/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.maven.server.workspace;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Properties;
import org.eclipse.aether.artifact.Artifact;
import org.jetbrains.maven.server.IntellijMavenSpy;

public final class MavenModuleMap {
    private static final MavenModuleMap ourInstance = new MavenModuleMap();
    public static final String PATHS_FILE_PROPERTY = "idea.modules.paths.file";
    private final Properties myMap = new Properties();

    private MavenModuleMap() {
        String path = System.getProperty(PATHS_FILE_PROPERTY);
        if (path != null) {
            IntellijMavenSpy.printInternalLogging("reading idea.modules.paths from " + path);
            try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]));){
                this.myMap.load(in);
                IntellijMavenSpy.printInternalLogging("have read " + this.myMap.size() + " records");
            }
            catch (IOException e) {
                IntellijMavenSpy.printInternalLogging(e.getMessage());
            }
        } else {
            IntellijMavenSpy.printInternalLogging("idea.modules.paths.file is not defined");
        }
    }

    public static MavenModuleMap getInstance() {
        return ourInstance;
    }

    public File findArtifact(Artifact artifact) {
        String key = MavenModuleMap.getKey(artifact);
        String value = this.myMap.getProperty(key);
        if (value == null || value.isEmpty()) {
            return null;
        }
        File file = new File(value);
        if (!file.exists()) {
            return null;
        }
        return file;
    }

    private static String getKey(Artifact artifact) {
        String type = MavenModuleMap.getType(artifact);
        return artifact.getGroupId() + ':' + artifact.getArtifactId() + ':' + type + ':' + artifact.getBaseVersion();
    }

    private static String getType(Artifact artifact) {
        String extension = artifact.getExtension();
        String classifier = artifact.getClassifier();
        if ("jar".equals(extension) && classifier != null && !classifier.isEmpty()) {
            if ("tests".equals(classifier) || "test-jar".equals(classifier)) {
                return "test-jar";
            }
            return classifier;
        }
        return extension;
    }
}

