/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.gestures;

import androidx.compose.foundation.gestures.AnchoredDraggableKt;
import androidx.compose.foundation.gestures.DraggableAnchors;
import androidx.compose.foundation.internal.InlineClassHelperKt;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0017\u0010\u0010\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0011\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u0012J\u001f\u0010\u0010\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\nH\u0016J\b\u0010\u0016\u001a\u00020\nH\u0016J\u0017\u0010\u001b\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001c\u001a\u00020\u0018H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u0018H\u0016J\u0013\u0010\u001f\u001a\u00020\u000e2\b\u0010 \u001a\u0004\u0018\u00010!H\u0096\u0002J\b\u0010\"\u001a\u00020\u0018H\u0016J\b\u0010#\u001a\u00020$H\u0016J\f\u0010%\u001a\u00020\n*\u00020\u0006H\u0002J\f\u0010&\u001a\u00020\n*\u00020\u0006H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006'"}, d2={"Landroidx/compose/foundation/gestures/DefaultDraggableAnchors;", "T", "Landroidx/compose/foundation/gestures/DraggableAnchors;", "keys", "", "anchors", "", "<init>", "(Ljava/util/List;[F)V", "positionOf", "", "anchor", "(Ljava/lang/Object;)F", "hasPositionFor", "", "(Ljava/lang/Object;)Z", "closestAnchor", "position", "(F)Ljava/lang/Object;", "searchUpwards", "(FZ)Ljava/lang/Object;", "minPosition", "maxPosition", "size", "", "getSize", "()I", "anchorAt", "index", "(I)Ljava/lang/Object;", "positionAt", "equals", "other", "", "hashCode", "toString", "", "minOrNaN", "maxOrNaN", "foundation"})
@SourceDebugExtension(value={"SMAP\nAnchoredDraggable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnchoredDraggable.kt\nandroidx/compose/foundation/gestures/DefaultDraggableAnchors\n+ 2 InlineClassHelper.kt\nandroidx/compose/foundation/internal/InlineClassHelperKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1788:1\n97#2,4:1789\n13920#3,3:1793\n13920#3,3:1796\n*S KotlinDebug\n*F\n+ 1 AnchoredDraggable.kt\nandroidx/compose/foundation/gestures/DefaultDraggableAnchors\n*L\n1576#1:1789,4\n1592#1:1793,3\n1606#1:1796,3\n*E\n"})
final class DefaultDraggableAnchors<T>
implements DraggableAnchors<T> {
    @NotNull
    private final List<T> keys;
    @NotNull
    private final float[] anchors;
    private final int size;

    public DefaultDraggableAnchors(@NotNull List<? extends T> keys, @NotNull float[] anchors) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Intrinsics.checkNotNullParameter((Object)anchors, (String)"anchors");
        this.keys = keys;
        this.anchors = anchors;
        boolean value$iv = this.keys.size() == this.anchors.length;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("DraggableAnchors were constructed with inconsistent key-value sizes. Keys: " + this.keys + " | Anchors: " + ArraysKt.toList((float[])this.anchors));
        }
        this.size = this.anchors.length;
    }

    @Override
    public float positionOf(T anchor) {
        int index2 = this.keys.indexOf(anchor);
        float[] fArray = this.anchors;
        Function1 function1 = AnchoredDraggableKt.access$getGetOrNan$p();
        return (0 <= index2 ? index2 < fArray.length : false) ? fArray[index2] : ((Number)function1.invoke((Object)index2)).floatValue();
    }

    @Override
    public boolean hasPositionFor(T anchor) {
        return this.keys.indexOf(anchor) != -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public T closestAnchor(float position) {
        int minAnchorIndex = 0;
        minAnchorIndex = -1;
        float minDistance = 0.0f;
        minDistance = Float.POSITIVE_INFINITY;
        float[] $this$forEachIndexed$iv = this.anchors;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (float item$iv : $this$forEachIndexed$iv) {
            void anchorPosition;
            int n = index$iv++;
            float f = item$iv;
            int index2 = n;
            boolean bl = false;
            float distance = Math.abs(position - anchorPosition);
            if (!(distance <= minDistance)) continue;
            minAnchorIndex = index2;
            minDistance = distance;
        }
        if (minAnchorIndex == -1) {
            return null;
        }
        return this.keys.get(minAnchorIndex);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public T closestAnchor(float position, boolean searchUpwards) {
        int minAnchorIndex = 0;
        minAnchorIndex = -1;
        float minDistance = 0.0f;
        minDistance = Float.POSITIVE_INFINITY;
        float[] $this$forEachIndexed$iv = this.anchors;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (float item$iv : $this$forEachIndexed$iv) {
            float distance;
            void anchorPosition;
            int n = index$iv++;
            float f = item$iv;
            int index2 = n;
            boolean bl = false;
            float delta = searchUpwards ? anchorPosition - position : position - anchorPosition;
            float f2 = distance = delta < 0.0f ? Float.POSITIVE_INFINITY : delta;
            if (!(distance <= minDistance)) continue;
            minAnchorIndex = index2;
            minDistance = distance;
        }
        if (minAnchorIndex == -1) {
            return null;
        }
        return this.keys.get(minAnchorIndex);
    }

    @Override
    public float minPosition() {
        return this.minOrNaN(this.anchors);
    }

    @Override
    public float maxPosition() {
        return this.maxOrNaN(this.anchors);
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    @Nullable
    public T anchorAt(int index2) {
        return (T)CollectionsKt.getOrNull(this.keys, (int)index2);
    }

    @Override
    public float positionAt(int index2) {
        float[] fArray = this.anchors;
        Function1 function1 = AnchoredDraggableKt.access$getGetOrNan$p();
        return (0 <= index2 ? index2 < fArray.length : false) ? fArray[index2] : ((Number)function1.invoke((Object)index2)).floatValue();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DefaultDraggableAnchors)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.keys, ((DefaultDraggableAnchors)other).keys)) {
            return false;
        }
        if (!Arrays.equals(this.anchors, ((DefaultDraggableAnchors)other).anchors)) {
            return false;
        }
        return this.getSize() == ((DefaultDraggableAnchors)other).getSize();
    }

    public int hashCode() {
        int result2 = ((Object)this.keys).hashCode();
        result2 = 31 * result2 + Arrays.hashCode(this.anchors);
        result2 = 31 * result2 + this.getSize();
        return result2;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u240.append("DraggableAnchors(anchors={");
        int n = this.getSize();
        for (int i = 0; i < n; ++i) {
            $this$toString_u24lambda_u240.append(this.anchorAt(i) + "=" + this.positionAt(i));
            if (i >= this.getSize() - 1) continue;
            $this$toString_u24lambda_u240.append(", ");
        }
        $this$toString_u24lambda_u240.append("})");
        return stringBuilder.toString();
    }

    private final float minOrNaN(float[] $this$minOrNaN) {
        if ($this$minOrNaN.length == 0) {
            return Float.NaN;
        }
        float min = $this$minOrNaN[0];
        int i = 1;
        int n = ArraysKt.getLastIndex((float[])$this$minOrNaN);
        if (i <= n) {
            while (true) {
                float e = $this$minOrNaN[i];
                min = Math.min(min, e);
                if (i == n) break;
                ++i;
            }
        }
        return min;
    }

    private final float maxOrNaN(float[] $this$maxOrNaN) {
        if ($this$maxOrNaN.length == 0) {
            return Float.NaN;
        }
        float min = $this$maxOrNaN[0];
        int i = 1;
        int n = ArraysKt.getLastIndex((float[])$this$maxOrNaN);
        if (i <= n) {
            while (true) {
                float e = $this$maxOrNaN[i];
                min = Math.max(min, e);
                if (i == n) break;
                ++i;
            }
        }
        return min;
    }
}

