/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrImmediateTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrLiteralClassType;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public abstract class GrTupleType
extends GrLiteralClassType {
    private final NotNullLazyValue<PsiType[]> myParameters;
    private final NotNullLazyValue<List<PsiType>> myComponents;

    public GrTupleType(@NotNull GlobalSearchScope scope, @NotNull JavaPsiFacade facade) {
        if (scope == null) {
            GrTupleType.$$$reportNull$$$0(0);
        }
        if (facade == null) {
            GrTupleType.$$$reportNull$$$0(1);
        }
        this(scope, facade, LanguageLevel.JDK_1_5);
    }

    public GrTupleType(@NotNull GlobalSearchScope scope, @NotNull JavaPsiFacade facade, @NotNull LanguageLevel level) {
        if (scope == null) {
            GrTupleType.$$$reportNull$$$0(2);
        }
        if (facade == null) {
            GrTupleType.$$$reportNull$$$0(3);
        }
        if (level == null) {
            GrTupleType.$$$reportNull$$$0(4);
        }
        super(level, scope, facade);
        this.myParameters = NotNullLazyValue.volatileLazy(() -> {
            List<PsiType> types = this.getComponentTypes();
            if (types.isEmpty()) {
                return PsiType.EMPTY_ARRAY;
            }
            PsiType leastUpperBound = this.getLeastUpperBound(types.toArray(PsiType.EMPTY_ARRAY));
            if (leastUpperBound == PsiTypes.nullType()) {
                return EMPTY_ARRAY;
            }
            return new PsiType[]{leastUpperBound};
        });
        this.myComponents = NotNullLazyValue.volatileLazy(this::inferComponents);
    }

    protected GrTupleType(@NotNull PsiElement context) {
        if (context == null) {
            GrTupleType.$$$reportNull$$$0(5);
        }
        super(LanguageLevel.JDK_1_5, context);
        this.myParameters = NotNullLazyValue.volatileLazy(() -> {
            List<PsiType> types = this.getComponentTypes();
            if (types.isEmpty()) {
                return PsiType.EMPTY_ARRAY;
            }
            PsiType leastUpperBound = this.getLeastUpperBound(types.toArray(PsiType.EMPTY_ARRAY));
            if (leastUpperBound == PsiTypes.nullType()) {
                return EMPTY_ARRAY;
            }
            return new PsiType[]{leastUpperBound};
        });
        this.myComponents = NotNullLazyValue.volatileLazy(this::inferComponents);
    }

    @Override
    @NotNull
    protected String getJavaClassName() {
        return "java.util.List";
    }

    public @Nullable PsiType @NotNull [] getParameters() {
        PsiType[] psiTypeArray = (PsiType[])this.myParameters.getValue();
        if (psiTypeArray == null) {
            GrTupleType.$$$reportNull$$$0(6);
        }
        return psiTypeArray;
    }

    @NotNull
    public String getInternalCanonicalText() {
        List<PsiType> types = this.getComponentTypes();
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (int i2 = 0; i2 < types.size(); ++i2) {
            if (i2 >= 2) {
                builder.append(",...");
                break;
            }
            if (i2 > 0) {
                builder.append(", ");
            }
            builder.append(GrTupleType.getInternalCanonicalText(types.get(i2)));
        }
        builder.append("]");
        String string = builder.toString();
        if (string == null) {
            GrTupleType.$$$reportNull$$$0(7);
        }
        return string;
    }

    public boolean equals(Object obj) {
        if (obj instanceof GrTupleType) {
            List<PsiType> componentTypes = this.getComponentTypes();
            List<PsiType> otherComponents = ((GrTupleType)((Object)obj)).getComponentTypes();
            return componentTypes.size() == otherComponents.size() && componentTypes.equals(otherComponents);
        }
        return super.equals(obj);
    }

    public boolean isAssignableFrom(@NotNull PsiType type) {
        if (type == null) {
            GrTupleType.$$$reportNull$$$0(8);
        }
        if (type instanceof GrTupleType) {
            List<PsiType> otherComponents = ((GrTupleType)type).getComponentTypes();
            List<PsiType> componentTypes = this.getComponentTypes();
            for (int i2 = 0; i2 < Math.min(componentTypes.size(), otherComponents.size()); ++i2) {
                PsiType componentType = componentTypes.get(i2);
                PsiType otherComponent = otherComponents.get(i2);
                if (!(otherComponent == null ? componentType != null && !TypesUtil.isClassType(componentType, "java.lang.Object") : componentType != null && !componentType.isAssignableFrom(otherComponent))) continue;
                return false;
            }
            return true;
        }
        return super.isAssignableFrom(type);
    }

    @NotNull
    public List<PsiType> getComponentTypes() {
        List list = (List)this.myComponents.getValue();
        if (list == null) {
            GrTupleType.$$$reportNull$$$0(9);
        }
        return list;
    }

    public final PsiType @NotNull [] getComponentTypesArray() {
        PsiType[] psiTypeArray = this.getComponentTypes().toArray(PsiType.EMPTY_ARRAY);
        if (psiTypeArray == null) {
            GrTupleType.$$$reportNull$$$0(10);
        }
        return psiTypeArray;
    }

    @NotNull
    protected abstract List<PsiType> inferComponents();

    @NotNull
    public PsiClassType setLanguageLevel(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            GrTupleType.$$$reportNull$$$0(11);
        }
        return new GrImmediateTupleType(this.getComponentTypes(), this.myFacade, this.getResolveScope());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/GrTupleType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/GrTupleType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalCanonicalText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentTypes";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentTypesArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableFrom";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setLanguageLevel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 9, 10 -> new IllegalStateException(string);
        };
    }
}

