/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.impl.UpdatableValueContainer;
import com.intellij.util.indexing.impl.ValueContainerImpl;
import com.intellij.util.indexing.impl.ValueContainerProcessor;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public interface IndexStorage<Key, Value>
extends Flushable,
Closeable {
    public void addValue(Key var1, int var2, Value var3) throws StorageException;

    public void removeAllValues(@NotNull Key var1, int var2) throws StorageException;

    public void updateValue(Key var1, int var2, Value var3) throws StorageException;

    public void clear() throws StorageException;

    @Deprecated
    @NotNull
    default public ValueContainer<Value> read(Key key) throws StorageException {
        ValueContainerImpl defensiveCopy = ValueContainerImpl.createNewValueContainer();
        this.read(key, shardContainer -> {
            UpdatableValueContainer container;
            shardContainer.forEach((id, value) -> {
                defensiveCopy.addValue(id, value);
                return true;
            });
            if (shardContainer instanceof UpdatableValueContainer && (container = (UpdatableValueContainer)shardContainer).needsCompacting()) {
                defensiveCopy.setNeedsCompacting(true);
            }
            return true;
        });
        ValueContainerImpl valueContainerImpl = defensiveCopy;
        if (valueContainerImpl == null) {
            IndexStorage.$$$reportNull$$$0(0);
        }
        return valueContainerImpl;
    }

    public <E extends Exception> boolean read(Key var1, @NotNull ValueContainerProcessor<Value, E> var2) throws StorageException, E;

    public void clearCaches();

    @Override
    public void flush() throws IOException;

    public boolean isDirty();

    @Override
    public void close() throws IOException;

    @ApiStatus.Internal
    public boolean isClosed();

    @ApiStatus.Internal
    default public void invalidateCachedMappings() {
    }

    @ApiStatus.Internal
    public boolean isReadLockHeldByCurrentThread();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/impl/IndexStorage", "read"));
    }
}

