/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.DvcsImplIconsExt;
import com.intellij.dvcs.ui.CustomIconProvider;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.ui.EmptyIcon;
import icons.DvcsImplIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BranchActionGroup
extends ActionGroup
implements DumbAware,
CustomIconProvider {
    private boolean myIsFavorite;
    private LayeredIcon myIcon;
    private LayeredIcon myHoveredIcon;

    public BranchActionGroup() {
        super("", true);
        this.setIcons(AllIcons.Nodes.Favorite, EmptyIcon.ICON_16, AllIcons.Nodes.Favorite, AllIcons.Nodes.NotFavoriteOnHover);
        this.getTemplatePresentation().putClientProperty(ActionUtil.ALWAYS_VISIBLE_GROUP, (Object)true);
    }

    protected void setIcons(@NotNull Icon favorite, @NotNull Icon notFavorite, @NotNull Icon favoriteOnHover, @NotNull Icon notFavoriteOnHover) {
        if (favorite == null) {
            BranchActionGroup.$$$reportNull$$$0(0);
        }
        if (notFavorite == null) {
            BranchActionGroup.$$$reportNull$$$0(1);
        }
        if (favoriteOnHover == null) {
            BranchActionGroup.$$$reportNull$$$0(2);
        }
        if (notFavoriteOnHover == null) {
            BranchActionGroup.$$$reportNull$$$0(3);
        }
        this.myIcon = LayeredIcon.layeredIcon((Icon[])new Icon[]{favorite, notFavorite});
        this.myHoveredIcon = LayeredIcon.layeredIcon((Icon[])new Icon[]{favoriteOnHover, notFavoriteOnHover});
        this.getTemplatePresentation().setIcon((Icon)this.myIcon);
        this.getTemplatePresentation().setSelectedIcon((Icon)this.myHoveredIcon);
        this.updateIcons();
    }

    private void updateIcons() {
        this.myIcon.setLayerEnabled(0, this.myIsFavorite);
        this.myHoveredIcon.setLayerEnabled(0, this.myIsFavorite);
        this.myIcon.setLayerEnabled(1, !this.myIsFavorite);
        this.myHoveredIcon.setLayerEnabled(1, !this.myIsFavorite);
    }

    public boolean isFavorite() {
        return this.myIsFavorite;
    }

    public void setFavorite(boolean favorite) {
        this.myIsFavorite = favorite;
        this.updateIcons();
    }

    public void toggle() {
        this.setFavorite(!this.myIsFavorite);
    }

    public boolean hasIncomingCommits() {
        return false;
    }

    public boolean hasOutgoingCommits() {
        return false;
    }

    @Override
    @Nullable
    public Icon getRightIcon() {
        if (this.hasIncomingCommits()) {
            return this.hasOutgoingCommits() ? DvcsImplIconsExt.getIncomingOutgoingIcon() : DvcsImplIcons.Incoming;
        }
        return this.hasOutgoingCommits() ? DvcsImplIcons.Outgoing : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "favorite";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "notFavorite";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "favoriteOnHover";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "notFavoriteOnHover";
                break;
            }
        }
        objectArray[1] = "com/intellij/dvcs/ui/BranchActionGroup";
        objectArray[2] = "setIcons";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

