/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.editor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerKeys;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.terminal.TerminalTitle;
import com.intellij.terminal.TerminalTitleListener;
import com.intellij.terminal.frontend.editor.TerminalViewVirtualFile;
import com.intellij.terminal.frontend.view.TerminalView;
import com.intellij.terminal.frontend.view.TerminalViewSessionState;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.util.TerminalCoroutineKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u0019\u0010\u0010\u001a\u00130\u0011\u00a2\u0006\u000e\b\u0012\u0012\n\b\u0013\u0012\u0006\b\n0\u00148\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006$"}, d2={"Lcom/intellij/terminal/frontend/editor/TerminalViewFileEditor;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Lcom/intellij/openapi/util/UserDataHolderBase;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/terminal/frontend/editor/TerminalViewVirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/terminal/frontend/editor/TerminalViewVirtualFile;)V", "terminalView", "Lcom/intellij/terminal/frontend/view/TerminalView;", "getTerminalView", "()Lcom/intellij/terminal/frontend/view/TerminalView;", "getComponent", "Ljavax/swing/JComponent;", "getPreferredFocusedComponent", "getName", "", "Lorg/jetbrains/annotations/Nls;", "capitalization", "Lorg/jetbrains/annotations/Nls$Capitalization;", "Title", "getFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isModified", "", "isValid", "dispose", "", "addPropertyChangeListener", "listener", "Ljava/beans/PropertyChangeListener;", "removePropertyChangeListener", "setState", "state", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "intellij.terminal.frontend"})
public final class TerminalViewFileEditor
extends UserDataHolderBase
implements FileEditor {
    @NotNull
    private final Project project;
    @NotNull
    private final TerminalViewVirtualFile file;

    public TerminalViewFileEditor(@NotNull Project project, @NotNull TerminalViewVirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)file), (String)"file");
        this.project = project;
        this.file = file;
        CoroutineScope coroutineScope = CoroutineScopeKt.childScope$default((CoroutineScope)TerminalCoroutineKt.terminalProjectScope(this.project), (String)"TerminalViewFileEditor", null, (boolean)false, (int)6, null);
        Disposer.register((Disposable)((Disposable)this), () -> TerminalViewFileEditor._init_$lambda$0(coroutineScope));
        BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ TerminalViewFileEditor this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0.getTerminalView().getSessionState().collect(new FlowCollector(){

                            public final Object emit(TerminalViewSessionState state, Continuation<? super Unit> $completion) {
                                if (Intrinsics.areEqual((Object)state, (Object)TerminalViewSessionState.Terminated.INSTANCE)) {
                                    CoroutineScope coroutineScope = TerminalCoroutineKt.terminalProjectScope(this$0.project);
                                    CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
                                    ModalityState modalityState = ModalityState.any();
                                    Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
                                    BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
                                        Object L$0;
                                        int I$0;
                                        int label;
                                        final /* synthetic */ TerminalViewFileEditor this$0;
                                        {
                                            this.this$0 = $receiver;
                                            super(2, $completion);
                                        }

                                        /*
                                         * Unable to fully structure code
                                         */
                                        public final Object invokeSuspend(Object $result) {
                                            var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    $this$serviceAsync$iv = (ComponentManager)TerminalViewFileEditor.access$getProject$p(this.this$0);
                                                    $i$f$serviceAsync = 0;
                                                    Intrinsics.checkNotNull((Object)$this$serviceAsync$iv, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
                                                    this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$serviceAsync$iv);
                                                    this.I$0 = $i$f$serviceAsync;
                                                    this.label = 1;
                                                    v0 = ((ComponentManagerEx)$this$serviceAsync$iv).getServiceAsync(FileEditorManager.class, (Continuation)this);
                                                    if (v0 == var4_2) {
                                                        return var4_2;
                                                    }
                                                    ** GOTO lbl21
                                                }
                                                case 1: {
                                                    $i$f$serviceAsync = this.I$0;
                                                    $this$serviceAsync$iv = (ComponentManager)this.L$0;
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    v0 = $result;
lbl21:
                                                    // 2 sources

                                                    ((FileEditorManager)v0).closeFile((VirtualFile)TerminalViewFileEditor.access$getFile$p(this.this$0));
                                                    return Unit.INSTANCE;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                        }

                                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }), (int)2, null);
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 != object) throw new KotlinNothingValueException();
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        this.getTerminalView().getTitle().addTitleListener(new TerminalTitleListener(){

            public void onTitleChanged(TerminalTitle terminalTitle) {
                Intrinsics.checkNotNullParameter((Object)terminalTitle, (String)"terminalTitle");
                file.rename(null, terminalTitle.buildTitle());
                FileEditorManager.getInstance((Project)project).updateFilePresentation((VirtualFile)file);
            }
        }, (Disposable)this);
    }

    private final TerminalView getTerminalView() {
        return this.file.getTerminalView();
    }

    @NotNull
    public JComponent getComponent() {
        return this.getTerminalView().getComponent();
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return this.getTerminalView().getPreferredFocusableComponent();
    }

    @NotNull
    public String getName() {
        String string = this.file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @NotNull
    public VirtualFile getFile() {
        return (VirtualFile)this.file;
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void dispose() {
        if (!Intrinsics.areEqual((Object)this.file.getUserData(FileEditorManagerKeys.CLOSING_TO_REOPEN), (Object)true)) {
            kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)this.getTerminalView().getCoroutineScope(), null, (int)1, null);
        }
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
    }

    public void setState(@NotNull FileEditorState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
    }

    private static final void _init_$lambda$0(CoroutineScope $coroutineScope) {
        kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)$coroutineScope, null, (int)1, null);
    }
}

