/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resources;

import org.gradle.internal.resources.AbstractTrackedResourceLock;
import org.gradle.internal.resources.ResourceLockContainer;
import org.gradle.internal.resources.ResourceLockCoordinationService;
import org.jspecify.annotations.Nullable;

public class ExclusiveAccessResourceLock
extends AbstractTrackedResourceLock {
    private @Nullable Thread owner;

    public ExclusiveAccessResourceLock(String displayName, ResourceLockCoordinationService coordinationService, ResourceLockContainer owner) {
        super(displayName, coordinationService, owner);
    }

    @Override
    protected boolean acquireLock() {
        Thread currentThread = Thread.currentThread();
        if (this.owner == currentThread) {
            return true;
        }
        if (this.owner == null && this.canAcquire()) {
            this.owner = currentThread;
            return true;
        }
        return false;
    }

    protected boolean canAcquire() {
        return true;
    }

    @Override
    protected void releaseLock() {
        this.owner = null;
    }

    @Override
    protected boolean doIsLockedByCurrentThread() {
        return this.owner == Thread.currentThread();
    }

    @Override
    protected boolean doIsLocked() {
        return this.owner != null;
    }
}

