/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.providers.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.resolve.providers.FirCompositeSymbolNamesProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolNamesProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderInternals;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J*\u0010\u0014\u001a\u00020\u00152\u0010\u0010\u0016\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J&\u0010\u0018\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00190\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J&\u0010\u001a\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0011H\u0016J\u0016\u0010\u001f\u001a\b\u0012\u0002\b\u0003\u0018\u00010 2\u0006\u0010!\u001a\u00020\"H\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirCompositeSymbolProvider;", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "providers", "", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Ljava/util/List;)V", "getProviders", "()Ljava/util/List;", "symbolNamesProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolNamesProvider;", "getSymbolNamesProvider", "()Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolNamesProvider;", "getTopLevelCallableSymbols", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "name", "Lorg/jetbrains/kotlin/name/Name;", "getTopLevelCallableSymbolsTo", "", "destination", "", "getTopLevelFunctionSymbolsTo", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "getTopLevelPropertySymbolsTo", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "hasPackage", "", "fqName", "getClassLikeSymbolByClassId", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;"})
@SourceDebugExtension(value={"SMAP\nFirCompositeSymbolProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirCompositeSymbolProvider.kt\norg/jetbrains/kotlin/fir/resolve/providers/impl/FirCompositeSymbolProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,57:1\n1391#2:58\n1480#2,5:59\n1915#2,2:64\n1915#2,2:66\n1807#2,3:68\n1#3:71\n*S KotlinDebug\n*F\n+ 1 FirCompositeSymbolProvider.kt\norg/jetbrains/kotlin/fir/resolve/providers/impl/FirCompositeSymbolProvider\n*L\n27#1:58\n27#1:59,5\n37#1:64,2\n44#1:66,2\n50#1:68,3\n*E\n"})
public final class FirCompositeSymbolProvider
extends FirSymbolProvider {
    @NotNull
    private final List<FirSymbolProvider> providers;
    @NotNull
    private final FirSymbolNamesProvider symbolNamesProvider;

    public FirCompositeSymbolProvider(@NotNull FirSession session, @NotNull List<? extends FirSymbolProvider> providers) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(providers, (String)"providers");
        super(session);
        this.providers = providers;
        this.symbolNamesProvider = FirCompositeSymbolNamesProvider.Companion.fromSymbolProviders(this.providers);
    }

    @NotNull
    public final List<FirSymbolProvider> getProviders() {
        return this.providers;
    }

    @Override
    @NotNull
    public FirSymbolNamesProvider getSymbolNamesProvider() {
        return this.symbolNamesProvider;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<FirCallableSymbol<?>> getTopLevelCallableSymbols(@NotNull FqName packageFqName, @NotNull Name name2) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Iterable $this$flatMap$iv = this.providers;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            FirSymbolProvider it = (FirSymbolProvider)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getTopLevelCallableSymbols(packageFqName, name2);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @FirSymbolProviderInternals
    public void getTopLevelCallableSymbolsTo(@NotNull List<FirCallableSymbol<?>> destination, @NotNull FqName packageFqName, @NotNull Name name2) {
        Intrinsics.checkNotNullParameter(destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        CollectionsKt.addAll((Collection)destination, (Iterable)this.getTopLevelCallableSymbols(packageFqName, name2));
    }

    @Override
    @FirSymbolProviderInternals
    public void getTopLevelFunctionSymbolsTo(@NotNull List<FirNamedFunctionSymbol> destination, @NotNull FqName packageFqName, @NotNull Name name2) {
        Intrinsics.checkNotNullParameter(destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Iterable $this$forEach$iv = this.providers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirSymbolProvider it = (FirSymbolProvider)element$iv;
            boolean bl = false;
            it.getTopLevelFunctionSymbolsTo(destination, packageFqName, name2);
        }
    }

    @Override
    @FirSymbolProviderInternals
    public void getTopLevelPropertySymbolsTo(@NotNull List<FirPropertySymbol> destination, @NotNull FqName packageFqName, @NotNull Name name2) {
        Intrinsics.checkNotNullParameter(destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Iterable $this$forEach$iv = this.providers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirSymbolProvider it = (FirSymbolProvider)element$iv;
            boolean bl = false;
            it.getTopLevelPropertySymbolsTo(destination, packageFqName, name2);
        }
    }

    @Override
    public boolean hasPackage(@NotNull FqName fqName) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
            Iterable $this$any$iv = this.providers;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirSymbolProvider it = (FirSymbolProvider)element$iv;
                    boolean bl2 = false;
                    if (!it.hasPackage(fqName)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @Nullable
    public FirClassLikeSymbol<?> getClassLikeSymbolByClassId(@NotNull ClassId classId) {
        FirClassLikeSymbol<?> firClassLikeSymbol;
        block1: {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            for (FirSymbolProvider it : (Iterable)this.providers) {
                boolean bl = false;
                FirClassLikeSymbol<?> firClassLikeSymbol2 = it.getClassLikeSymbolByClassId(classId);
                if (firClassLikeSymbol2 == null) continue;
                firClassLikeSymbol = firClassLikeSymbol2;
                break block1;
            }
            firClassLikeSymbol = null;
        }
        return firClassLikeSymbol;
    }
}

