/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.type;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.type.FirTypeChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.types.AbbreviatedTypeAttributeKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirMissingDependencyClassInTypeAliasTypeChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirTypeChecker;", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirResolvedTypeRefChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "typeRef", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;)V", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirMissingDependencyClassInTypeAliasTypeChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirMissingDependencyClassInTypeAliasTypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/type/FirMissingDependencyClassInTypeAliasTypeChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,49:1\n1#2:50\n*E\n"})
public final class FirMissingDependencyClassInTypeAliasTypeChecker
extends FirTypeChecker<FirResolvedTypeRef> {
    @NotNull
    public static final FirMissingDependencyClassInTypeAliasTypeChecker INSTANCE = new FirMissingDependencyClassInTypeAliasTypeChecker();

    private FirMissingDependencyClassInTypeAliasTypeChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirResolvedTypeRef typeRef) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
        ConeKotlinType it = coneKotlinType = TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)context2, typeRef.getConeType());
        boolean bl = false;
        ConeKotlinType coneKotlinType2 = !ConeTypeUtilsKt.hasError(it) ? coneKotlinType : null;
        if (coneKotlinType2 == null) {
            return;
        }
        ConeKotlinType fullyExpandedType2 = coneKotlinType2;
        ConeKotlinType coneKotlinType3 = AbbreviatedTypeAttributeKt.getAbbreviatedType(fullyExpandedType2);
        if (coneKotlinType3 == null) {
            return;
        }
        ConeKotlinType abbreviatedType = coneKotlinType3;
        FirClassifierSymbol<?> expandedSymbol = ToSymbolUtilsKt.toSymbol((SessionHolder)context2, fullyExpandedType2);
        if (expandedSymbol == null) {
            if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ForbidTypeAliasWithMissingDependencyType) || !(fullyExpandedType2.getTypeArguments().length == 0)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)typeRef.getSource(), FirErrors.INSTANCE.getMISSING_DEPENDENCY_CLASS(), (Object)fullyExpandedType2, null, 16, null);
            } else {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)typeRef.getSource(), FirErrors.INSTANCE.getMISSING_DEPENDENCY_CLASS_IN_TYPEALIAS(), (Object)fullyExpandedType2, (Object)abbreviatedType, null, 32, null);
            }
        }
    }
}

