/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.intrinsics;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.codegen.BlockInfo;
import org.jetbrains.kotlin.backend.jvm.codegen.BooleanConstant;
import org.jetbrains.kotlin.backend.jvm.codegen.BooleanValue;
import org.jetbrains.kotlin.backend.jvm.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.backend.jvm.codegen.MaterialValue;
import org.jetbrains.kotlin.backend.jvm.codegen.PromisedValue;
import org.jetbrains.kotlin.backend.jvm.codegen.PromisedValueKt;
import org.jetbrains.kotlin.backend.jvm.intrinsics.BooleanComparison;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntegerZeroComparison;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.backend.jvm.intrinsics.NonIEEE754FloatComparison;
import org.jetbrains.kotlin.backend.jvm.intrinsics.PrimitiveToObjectComparison;
import org.jetbrains.kotlin.backend.jvm.mapping.IrTypeMappingKt;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J@\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\u0017\u001a\u00020\u0018*\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0019R\u0018\u0010\u001a\u001a\u00020\u0018*\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0019\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/Equals;", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicMethod;", "operator", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "<init>", "(Lcom/intellij/psi/tree/IElementType;)V", "getOperator", "()Lcom/intellij/psi/tree/IElementType;", "invoke", "Lorg/jetbrains/kotlin/backend/jvm/codegen/PromisedValue;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "codegen", "Lorg/jetbrains/kotlin/backend/jvm/codegen/ExpressionCodegen;", "data", "Lorg/jetbrains/kotlin/backend/jvm/codegen/BlockInfo;", "referenceEquals", "left", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "right", "leftType", "Lorg/jetbrains/org/objectweb/asm/Type;", "rightType", "isEnumValue", "", "(Lorg/jetbrains/kotlin/ir/expressions/IrExpression;)Z", "isClassValue", "BooleanNullCheck", "backend.jvm.codegen"})
@SourceDebugExtension(value={"SMAP\nEquals.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Equals.kt\norg/jetbrains/kotlin/backend/jvm/intrinsics/Equals\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,248:1\n1#2:249\n*E\n"})
public final class Equals
extends IntrinsicMethod {
    @NotNull
    private final IElementType operator;

    public Equals(@NotNull IElementType operator) {
        Intrinsics.checkNotNullParameter((Object)operator, (String)"operator");
        this.operator = operator;
    }

    @NotNull
    public final IElementType getOperator() {
        return this.operator;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PromisedValue invoke(@NotNull IrFunctionAccessExpression expression2, @NotNull ExpressionCodegen codegen, @NotNull BlockInfo data) {
        PromisedValue promisedValue;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)codegen, (String)"codegen");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        List<IrExpression> list = IrUtilsKt.receiverAndArgs(expression2);
        IrExpression a2 = list.get(0);
        IrExpression b2 = list.get(1);
        if (IrUtilsKt.isNullConst(a2) || IrUtilsKt.isNullConst(b2)) {
            PromisedValue promisedValue2;
            IrExpression irValue = IrUtilsKt.isNullConst(a2) ? b2 : a2;
            PromisedValue value2 = (PromisedValue)irValue.accept(codegen, data);
            if (!AsmUtil.isPrimitive(value2.getType())) {
                Object object = IrTypesKt.getClassOrNull(irValue.getType());
                if (!(object != null && (object = (IrClass)object.getOwner()) != null ? IrDeclarationsKt.isSingleFieldValueClass((IrClass)object) : false) || IrTypeUtilsKt.isNullable(irValue.getType())) {
                    promisedValue2 = new BooleanNullCheck(expression2, value2);
                    return promisedValue2;
                }
            }
            value2.discard();
            promisedValue2 = new BooleanConstant(codegen, false);
            return promisedValue2;
        }
        Type leftType = IrTypeMappingKt.mapTypeAsDeclaration(codegen.getTypeMapper(), a2.getType());
        Type rightType = IrTypeMappingKt.mapTypeAsDeclaration(codegen.getTypeMapper(), b2.getType());
        if (Intrinsics.areEqual((Object)expression2.getOrigin(), (Object)IrStatementOrigin.Companion.getEQEQEQ())) return this.referenceEquals(expression2, a2, b2, leftType, rightType, codegen, data);
        if (Intrinsics.areEqual((Object)expression2.getOrigin(), (Object)IrStatementOrigin.Companion.getEXCLEQEQ())) {
            return this.referenceEquals(expression2, a2, b2, leftType, rightType, codegen, data);
        }
        if (AsmUtil.isIntOrLongPrimitive(leftType) && !AsmUtil.isPrimitive(rightType) || AsmUtil.isIntOrLongPrimitive(rightType) && AsmUtil.isBoxedPrimitiveType(leftType)) {
            MaterialValue aValue = PromisedValueKt.materializedAt$default((PromisedValue)a2.accept(codegen, data), leftType, a2.getType(), false, 4, null);
            MaterialValue bValue = PromisedValueKt.materializedAt$default((PromisedValue)b2.accept(codegen, data), rightType, b2.getType(), false, 4, null);
            return new PrimitiveToObjectComparison(expression2, this.operator, AsmUtil.isIntOrLongPrimitive(leftType), aValue, bValue);
        }
        if (AsmUtil.isPrimitive(leftType) && Intrinsics.areEqual((Object)leftType, (Object)rightType)) {
            if (!Intrinsics.areEqual((Object)leftType, (Object)Type.FLOAT_TYPE)) {
                if (!Intrinsics.areEqual((Object)leftType, (Object)Type.DOUBLE_TYPE)) return this.referenceEquals(expression2, a2, b2, leftType, rightType, codegen, data);
            }
            MaterialValue aValue = PromisedValueKt.materializedAt$default((PromisedValue)a2.accept(codegen, data), leftType, a2.getType(), false, 4, null);
            MaterialValue bValue = PromisedValueKt.materializedAt$default((PromisedValue)b2.accept(codegen, data), rightType, b2.getType(), false, 4, null);
            return new NonIEEE754FloatComparison(expression2, this.operator, aValue, bValue);
        }
        if (this.isEnumValue(a2) || this.isEnumValue(b2)) {
            promisedValue = this.referenceEquals(expression2, a2, b2, leftType, rightType, codegen, data);
            return promisedValue;
        }
        if (this.isClassValue(a2) && this.isClassValue(b2)) {
            MaterialValue leftValue = codegen.generateClassLiteralReference(a2, false, true, data);
            MaterialValue rightValue = codegen.generateClassLiteralReference(b2, false, true, data);
            promisedValue = new BooleanComparison(expression2, this.operator, leftValue, rightValue);
            return promisedValue;
        }
        PromisedValue promisedValue3 = (PromisedValue)a2.accept(codegen, data);
        Type type = AsmTypes.OBJECT_TYPE;
        Intrinsics.checkNotNullExpressionValue((Object)type, (String)"OBJECT_TYPE");
        PromisedValueKt.materializeAt(promisedValue3, type, codegen.getContext().getIrBuiltIns().getAnyNType());
        PromisedValue promisedValue4 = (PromisedValue)b2.accept(codegen, data);
        Type type2 = AsmTypes.OBJECT_TYPE;
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"OBJECT_TYPE");
        PromisedValueKt.materializeAt(promisedValue4, type2, codegen.getContext().getIrBuiltIns().getAnyNType());
        ExpressionCodegen $this$invoke_u24lambda_u240 = codegen;
        boolean bl = false;
        $this$invoke_u24lambda_u240.markLineNumber(expression2, true);
        codegen.getMv().invokestatic("kotlin/jvm/internal/Intrinsics", "areEqual", "(Ljava/lang/Object;Ljava/lang/Object;)Z", false);
        Type type3 = Type.BOOLEAN_TYPE;
        Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"BOOLEAN_TYPE");
        promisedValue = new MaterialValue(codegen, type3, codegen.getContext().getIrBuiltIns().getBooleanType());
        return promisedValue;
    }

    private final PromisedValue referenceEquals(IrFunctionAccessExpression expression2, IrExpression left, IrExpression right, Type leftType, Type rightType, ExpressionCodegen codegen, BlockInfo data) {
        PromisedValue promisedValue;
        Type operandType;
        Type type = operandType = !AsmUtil.isPrimitive(leftType) || !AsmUtil.isPrimitive(rightType) ? AsmTypes.OBJECT_TYPE : leftType;
        if (Intrinsics.areEqual((Object)operandType, (Object)Type.INT_TYPE) && (IrUtilsKt.isIntegerConst(left, 0) || IrUtilsKt.isIntegerConst(right, 0))) {
            IrExpression nonZero = IrUtilsKt.isIntegerConst(left, 0) ? right : left;
            IrExpression irExpression = expression2;
            PromisedValue promisedValue2 = (PromisedValue)nonZero.accept(codegen, data);
            Intrinsics.checkNotNull((Object)operandType);
            promisedValue = new IntegerZeroComparison(irExpression, PromisedValueKt.materializedAt$default(promisedValue2, operandType, nonZero.getType(), false, 4, null));
        } else {
            PromisedValue promisedValue3 = (PromisedValue)left.accept(codegen, data);
            Intrinsics.checkNotNull((Object)operandType);
            MaterialValue leftValue = PromisedValueKt.materializedAt$default(promisedValue3, operandType, left.getType(), false, 4, null);
            MaterialValue rightValue = PromisedValueKt.materializedAt$default((PromisedValue)right.accept(codegen, data), operandType, right.getType(), false, 4, null);
            promisedValue = new BooleanComparison(expression2, this.operator, leftValue, rightValue);
        }
        return promisedValue;
    }

    private final boolean isEnumValue(IrExpression $this$isEnumValue) {
        boolean bl;
        Object object = IrTypesKt.getClassOrNull($this$isEnumValue.getType());
        if (object != null && (object = (IrClass)object.getOwner()) != null) {
            Object $this$_get_isEnumValue__u24lambda_u240 = object;
            boolean bl2 = false;
            bl = IrUtilsKt.isEnumClass((IrClass)$this$_get_isEnumValue__u24lambda_u240) || IrUtilsKt.isEnumEntry((IrClass)$this$_get_isEnumValue__u24lambda_u240);
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isClassValue(IrExpression $this$isClassValue) {
        return $this$isClassValue instanceof IrGetClass || $this$isClassValue instanceof IrClassReference;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0011\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/Equals$BooleanNullCheck;", "Lorg/jetbrains/kotlin/backend/jvm/codegen/BooleanValue;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "value", "Lorg/jetbrains/kotlin/backend/jvm/codegen/PromisedValue;", "<init>", "(Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;Lorg/jetbrains/kotlin/backend/jvm/codegen/PromisedValue;)V", "getExpression", "()Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "getValue", "()Lorg/jetbrains/kotlin/backend/jvm/codegen/PromisedValue;", "jumpIfFalse", "", "target", "Lorg/jetbrains/org/objectweb/asm/Label;", "jumpIfTrue", "discard", "backend.jvm.codegen"})
    private static final class BooleanNullCheck
    extends BooleanValue {
        @NotNull
        private final IrFunctionAccessExpression expression;
        @NotNull
        private final PromisedValue value;

        public BooleanNullCheck(@NotNull IrFunctionAccessExpression expression2, @NotNull PromisedValue value2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            super(value2.getCodegen());
            this.expression = expression2;
            this.value = value2;
        }

        @NotNull
        public final IrFunctionAccessExpression getExpression() {
            return this.expression;
        }

        @NotNull
        public final PromisedValue getValue() {
            return this.value;
        }

        @Override
        public void jumpIfFalse(@NotNull Label target) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            PromisedValueKt.materialize(this.value);
            this.markLineNumber(this.expression);
            this.getMv().ifnonnull(target);
        }

        @Override
        public void jumpIfTrue(@NotNull Label target) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            PromisedValueKt.materialize(this.value);
            this.markLineNumber(this.expression);
            this.getMv().ifnull(target);
        }

        @Override
        public void discard() {
            this.markLineNumber(this.expression);
            this.value.discard();
        }
    }
}

