/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.collect;

import java.util.Map;
import java.util.Objects;
import org.gradle.internal.collect.ToString;

final class PersistentMapEntry<K, V>
implements Map.Entry<K, V> {
    private final K key;
    private final V val;

    static <K, V> int hashCodeOf(K k, V v) {
        return Objects.hashCode(k) ^ Objects.hashCode(v);
    }

    public PersistentMapEntry(K key, V val) {
        this.key = key;
        this.val = val;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.val;
    }

    @Override
    public V setValue(V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int hashCode() {
        return PersistentMapEntry.hashCodeOf(this.key, this.val);
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Map.Entry)) {
            return false;
        }
        Map.Entry that = (Map.Entry)other;
        return Objects.equals(this.key, that.getKey()) && Objects.equals(this.val, that.getValue());
    }

    public String toString() {
        return ToString.entry(this.key, this.val);
    }
}

