/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.collect;

import java.util.Arrays;
import org.gradle.internal.collect.ArrayCopy;

final class ChampNode<K> {
    static final int BITS = 5;
    final int dataMap;
    final int nodeMap;
    final Object[] content;

    ChampNode(int dataMap, int nodeMap, Object[] content) {
        this.dataMap = dataMap;
        this.nodeMap = nodeMap;
        this.content = content;
    }

    ChampNode<K> replaceDataWithNode(int index, int mask, int bit, Object newNode, int payload) {
        assert ((this.nodeMap & bit) != bit);
        int newDataMap = this.dataMap & ~bit;
        int newNodeMap = this.nodeMap | bit;
        int newNodeIndex = ChampNode.nodeIndex(this.content, newNodeMap, mask, bit);
        Object[] newContent = ArrayCopy.insertAtPushingLeft(newNodeIndex, this.content, newNode, index, payload);
        return new ChampNode<K>(newDataMap, newNodeMap, newContent);
    }

    ChampNode<K> replaceContentAt(int index, Object newElement) {
        Object[] newContent = ArrayCopy.replaceAt(index, this.content, newElement);
        return new ChampNode<K>(this.dataMap, this.nodeMap, newContent);
    }

    public ChampNode<K> removeDataAt(int index, int bit, int payload) {
        assert ((this.dataMap & bit) == bit);
        int newDataMap = this.dataMap & ~bit;
        Object[] newContent = ArrayCopy.removeAt(index, this.content, 1 + payload);
        return new ChampNode<K>(newDataMap, this.nodeMap, newContent);
    }

    public int hashCode() {
        throw new IllegalStateException("ChampNode should not be used as hash key.");
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ChampNode that = (ChampNode)other;
        return this.dataMap == that.dataMap && this.nodeMap == that.nodeMap && Arrays.equals(this.content, that.content);
    }

    static int nodeIndex(Object[] content, int nodeMap, int mask, int bit) {
        return content.length - 1 - ChampNode.index(nodeMap, mask, bit);
    }

    static int mask(int hash, int shift) {
        return hash >>> shift & 0x1F;
    }

    static int index(int bitmap, int bit) {
        return Integer.bitCount(bitmap & bit - 1);
    }

    static int index(int bitmap, int mask, int bit) {
        return bitmap == -1 ? mask : ChampNode.index(bitmap, bit);
    }
}

