/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import java.util.Map;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphEdge;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.ResolvedGraphDependency;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasonInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasonSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.DetachedFailedResolvedGraphDependency;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.DetachedSuccessfulResolvedGraphDependency;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

public class DependencyResultSerializer {
    private final ComponentSelectionReasonSerializer componentSelectionReasonSerializer;
    private final Serializer<ComponentSelector> componentSelectorSerializer;

    public DependencyResultSerializer(ComponentSelectionReasonSerializer componentSelectionReasonSerializer, Serializer<ComponentSelector> componentSelectorSerializer) {
        this.componentSelectionReasonSerializer = componentSelectionReasonSerializer;
        this.componentSelectorSerializer = componentSelectorSerializer;
    }

    public ResolvedGraphDependency read(Decoder decoder, Map<ComponentSelector, ModuleVersionResolveException> failures) throws Exception {
        ComponentSelector requested = (ComponentSelector)this.componentSelectorSerializer.read(decoder);
        boolean constraint = decoder.readBoolean();
        boolean successful = decoder.readBoolean();
        if (successful) {
            long selectedId = decoder.readSmallLong();
            long selectedVariantId = decoder.readSmallLong();
            return new DetachedSuccessfulResolvedGraphDependency(constraint, requested, selectedId, selectedVariantId);
        }
        ComponentSelectionReasonInternal reason = this.componentSelectionReasonSerializer.read(decoder);
        ModuleVersionResolveException failure = failures.get(requested);
        return new DetachedFailedResolvedGraphDependency(constraint, requested, failure, reason);
    }

    public void write(Encoder encoder, DependencyGraphEdge value) throws Exception {
        this.componentSelectorSerializer.write(encoder, (Object)value.getRequested());
        encoder.writeBoolean(value.isConstraint());
        if (value.getFailure() == null) {
            encoder.writeBoolean(true);
            encoder.writeSmallLong(value.getTargetComponentId());
            encoder.writeSmallLong(value.getTargetVariantId());
        } else {
            encoder.writeBoolean(false);
            this.componentSelectionReasonSerializer.write(encoder, value.getReason());
        }
    }
}

