/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import org.gradle.api.artifacts.result.ComponentSelectionCause;
import org.gradle.api.artifacts.result.ComponentSelectionDescriptor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasonInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.DefaultComponentSelectionDescriptor;

public class ComponentSelectionReasons {
    public static final ComponentSelectionDescriptorInternal REQUESTED = new DefaultComponentSelectionDescriptor(ComponentSelectionCause.REQUESTED);
    public static final ComponentSelectionDescriptorInternal ROOT = new DefaultComponentSelectionDescriptor(ComponentSelectionCause.ROOT);
    public static final ComponentSelectionDescriptorInternal FORCED = new DefaultComponentSelectionDescriptor(ComponentSelectionCause.FORCED);
    public static final ComponentSelectionDescriptorInternal CONFLICT_RESOLUTION = new DefaultComponentSelectionDescriptor(ComponentSelectionCause.CONFLICT_RESOLUTION);
    public static final ComponentSelectionDescriptorInternal SELECTED_BY_RULE = new DefaultComponentSelectionDescriptor(ComponentSelectionCause.SELECTED_BY_RULE);
    public static final ComponentSelectionDescriptorInternal COMPOSITE_BUILD = new DefaultComponentSelectionDescriptor(ComponentSelectionCause.COMPOSITE_BUILD);
    public static final ComponentSelectionDescriptorInternal CONSTRAINT = new DefaultComponentSelectionDescriptor(ComponentSelectionCause.CONSTRAINT);
    public static final ComponentSelectionDescriptorInternal REJECTION = new DefaultComponentSelectionDescriptor(ComponentSelectionCause.REJECTION);
    public static final ComponentSelectionDescriptorInternal BY_ANCESTOR = new DefaultComponentSelectionDescriptor(ComponentSelectionCause.BY_ANCESTOR);

    public static ComponentSelectionReasonInternal requested() {
        return ComponentSelectionReasons.of(REQUESTED);
    }

    public static ComponentSelectionReasonInternal root() {
        return ComponentSelectionReasons.of(ROOT);
    }

    public static ComponentSelectionReasonInternal of(ComponentSelectionDescriptorInternal descriptions) {
        return new DefaultComponentSelectionReason((ImmutableList<ComponentSelectionDescriptorInternal>)ImmutableList.of((Object)descriptions));
    }

    public static ComponentSelectionReasonInternal of(ImmutableSet<ComponentSelectionDescriptorInternal> dependencyReasons) {
        assert (!dependencyReasons.isEmpty());
        return new DefaultComponentSelectionReason((ImmutableList<ComponentSelectionDescriptorInternal>)dependencyReasons.asList());
    }

    public static boolean isCauseExpected(ComponentSelectionDescriptor descriptor) {
        return descriptor.getCause() == ComponentSelectionCause.REQUESTED || descriptor.getCause() == ComponentSelectionCause.ROOT;
    }

    static class DefaultComponentSelectionReason
    implements ComponentSelectionReasonInternal {
        private final ImmutableList<ComponentSelectionDescriptorInternal> descriptions;

        DefaultComponentSelectionReason(ImmutableList<ComponentSelectionDescriptorInternal> descriptions) {
            this.descriptions = descriptions;
        }

        public boolean isForced() {
            return this.hasCause(ComponentSelectionCause.FORCED);
        }

        private boolean hasCause(ComponentSelectionCause cause) {
            for (ComponentSelectionDescriptor description : this.descriptions) {
                if (description.getCause() != cause) continue;
                return true;
            }
            return false;
        }

        public boolean isConflictResolution() {
            return this.hasCause(ComponentSelectionCause.CONFLICT_RESOLUTION);
        }

        public boolean isSelectedByRule() {
            return this.hasCause(ComponentSelectionCause.SELECTED_BY_RULE);
        }

        public boolean isExpected() {
            return this.descriptions.size() == 1 && ComponentSelectionReasons.isCauseExpected(this.getLast());
        }

        public boolean isCompositeSubstitution() {
            return this.hasCause(ComponentSelectionCause.COMPOSITE_BUILD);
        }

        public String toString() {
            return this.getLast().toString();
        }

        @Override
        public List<ComponentSelectionDescriptorInternal> getDescriptions() {
            return this.descriptions;
        }

        public boolean isConstrained() {
            return this.hasCause(ComponentSelectionCause.CONSTRAINT);
        }

        @Override
        public boolean hasCustomDescriptions() {
            for (ComponentSelectionDescriptorInternal description : this.descriptions) {
                if (!description.hasCustomDescription()) continue;
                return true;
            }
            return false;
        }

        private ComponentSelectionDescriptorInternal getLast() {
            return (ComponentSelectionDescriptorInternal)this.descriptions.get(this.descriptions.size() - 1);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultComponentSelectionReason that = (DefaultComponentSelectionReason)o;
            return this.descriptions.equals(that.descriptions);
        }

        public int hashCode() {
            return this.descriptions.hashCode();
        }
    }
}

