/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.catalog;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ConsumableConfiguration;
import org.gradle.api.artifacts.DependencyScopeConfiguration;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.Usage;
import org.gradle.api.component.AdhocComponentWithVariants;
import org.gradle.api.component.SoftwareComponentFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.catalog.CatalogPluginExtension;
import org.gradle.api.plugins.catalog.internal.CatalogExtensionInternal;
import org.gradle.api.plugins.catalog.internal.DefaultVersionCatalogPluginExtension;
import org.gradle.api.plugins.catalog.internal.TomlFileGenerator;
import org.gradle.api.plugins.internal.JavaConfigurationVariantMapping;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;

public abstract class VersionCatalogPlugin
implements Plugin<Project> {
    public static final String GENERATE_CATALOG_FILE_TASKNAME = "generateCatalogAsToml";
    public static final String GRADLE_PLATFORM_DEPENDENCIES = "versionCatalog";
    public static final String VERSION_CATALOG_ELEMENTS = "versionCatalogElements";
    private final SoftwareComponentFactory softwareComponentFactory;

    @Inject
    public VersionCatalogPlugin(SoftwareComponentFactory softwareComponentFactory) {
        this.softwareComponentFactory = softwareComponentFactory;
    }

    public void apply(Project project) {
        ProjectInternal projectInternal = (ProjectInternal)project;
        CatalogExtensionInternal extension = this.createExtension(projectInternal);
        TaskProvider<TomlFileGenerator> generator = this.createGenerator(project, extension);
        this.createPublication((ProjectInternal)project, generator);
    }

    private void createPublication(ProjectInternal project, TaskProvider<TomlFileGenerator> generator) {
        NamedDomainObjectProvider exported = project.getConfigurations().consumable(VERSION_CATALOG_ELEMENTS, cnf -> {
            cnf.setDescription("Artifacts for the version catalog");
            cnf.getOutgoing().artifact((Object)generator);
            cnf.attributes(attrs -> {
                attrs.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)attrs.named(Category.class, "platform")));
                attrs.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)attrs.named(Usage.class, "version-catalog")));
            });
        });
        project.getPlugins().withType(BasePlugin.class, arg_0 -> VersionCatalogPlugin.lambda$createPublication$3(project, (Provider)exported, arg_0));
        AdhocComponentWithVariants versionCatalog = this.softwareComponentFactory.adhoc(GRADLE_PLATFORM_DEPENDENCIES);
        project.getComponents().add((Object)versionCatalog);
        versionCatalog.addVariantsFromConfiguration((Provider)exported, (Action)new JavaConfigurationVariantMapping("compile", true));
    }

    private TaskProvider<TomlFileGenerator> createGenerator(Project project, CatalogExtensionInternal extension) {
        return project.getTasks().register(GENERATE_CATALOG_FILE_TASKNAME, TomlFileGenerator.class, t -> this.configureTask(project, extension, (TomlFileGenerator)((Object)t)));
    }

    private void configureTask(Project project, CatalogExtensionInternal extension, TomlFileGenerator task) {
        task.setGroup("build");
        task.setDescription("Generates a TOML file for a version catalog");
        task.getOutputFile().convention(project.getLayout().getBuildDirectory().file("version-catalog/libs.versions.toml"));
        task.getDependenciesModel().convention(extension.getVersionCatalog());
    }

    private CatalogExtensionInternal createExtension(ProjectInternal project) {
        DependencyScopeConfiguration dependenciesConfiguration = project.getConfigurations().dependencyScopeLocked(GRADLE_PLATFORM_DEPENDENCIES);
        return (CatalogExtensionInternal)project.getExtensions().create(CatalogPluginExtension.class, "catalog", DefaultVersionCatalogPluginExtension.class, new Object[]{dependenciesConfiguration});
    }

    private static /* synthetic */ void lambda$createPublication$3(ProjectInternal project, Provider exported, BasePlugin plugin) {
        project.getTasks().named("assemble").configure(assemble -> assemble.dependsOn(new Object[]{((ConsumableConfiguration)exported.get()).getArtifacts()}));
    }
}

