/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.http.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.utils.URIBuilder;
import org.gradle.caching.BuildCacheEntryReader;
import org.gradle.caching.BuildCacheEntryWriter;
import org.gradle.caching.BuildCacheException;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.BuildCacheService;
import org.gradle.caching.http.internal.HttpBuildCacheRequestCustomizer;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.resource.transport.http.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpBuildCacheService
implements BuildCacheService {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpBuildCacheService.class);
    static final String BUILD_CACHE_CONTENT_TYPE = "application/vnd.gradle.build-cache-artifact.v2";
    private static final Set<Integer> FATAL_HTTP_ERROR_CODES = ImmutableSet.of((Object)305, (Object)400, (Object)401, (Object)403, (Object)407, (Object)405, (Object[])new Integer[]{406, 411, 415, 417, 426, 505, 511});
    private final URI root;
    private final HttpClient client;
    private final ImmutableMap<String, String> defaultLoadHeaders;
    private final ImmutableMap<String, String> defaultStoreHeaders;

    public HttpBuildCacheService(HttpClient client, URI url, HttpBuildCacheRequestCustomizer requestCustomizer, boolean useExpectContinue) {
        this.root = HttpBuildCacheService.withTrailingSlash(url);
        this.client = client;
        this.defaultLoadHeaders = HttpBuildCacheService.getDefaultLoadHeaders(requestCustomizer);
        this.defaultStoreHeaders = HttpBuildCacheService.getDefaultStoreHeaders(requestCustomizer, useExpectContinue);
    }

    private static ImmutableMap<String, String> getDefaultLoadHeaders(HttpBuildCacheRequestCustomizer requestCustomizer) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"Accept", (Object)"application/vnd.gradle.build-cache-artifact.v2, */*");
        requestCustomizer.visitHeaders((arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        return builder.build();
    }

    private static ImmutableMap<String, String> getDefaultStoreHeaders(HttpBuildCacheRequestCustomizer requestCustomizer, boolean useExpectContinue) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (useExpectContinue) {
            builder.put((Object)"Expect", (Object)"100-continue");
        }
        builder.put((Object)"Content-Type", (Object)BUILD_CACHE_CONTENT_TYPE);
        requestCustomizer.visitHeaders((arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        return builder.build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean load(BuildCacheKey key, BuildCacheEntryReader reader) throws BuildCacheException {
        URI uri = this.root.resolve("./" + key.getHashCode());
        try (HttpClient.Response response = this.client.performRawGet(uri, this.defaultLoadHeaders);){
            int statusCode = response.getStatusCode();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Response for GET {}: {}", (Object)HttpBuildCacheService.safeUri(uri), (Object)statusCode);
            }
            if (this.isHttpSuccess(statusCode)) {
                reader.readFrom(response.getContent());
                boolean bl = true;
                return bl;
            }
            if (response.isMissing()) {
                boolean bl = false;
                return bl;
            }
            String defaultMessage = String.format("Loading entry from '%s' response status %d: %s", HttpBuildCacheService.safeUri(uri), statusCode, response.getStatusReason());
            boolean bl = this.throwHttpStatusCodeException(statusCode, defaultMessage);
            return bl;
        }
        catch (IOException e) {
            throw HttpBuildCacheService.wrap(e);
        }
    }

    public void store(BuildCacheKey key, final BuildCacheEntryWriter writer) throws BuildCacheException {
        URI uri = this.root.resolve(key.getHashCode());
        HttpClient.WritableContent putResource = new HttpClient.WritableContent(){

            public void writeTo(OutputStream outputStream) throws IOException {
                writer.writeTo(outputStream);
            }

            public long getSize() {
                return writer.getSize();
            }
        };
        try (HttpClient.Response response = this.client.performRawPut(uri, this.defaultStoreHeaders, putResource);){
            int statusCode = response.getStatusCode();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Response for PUT {}: {}", (Object)HttpBuildCacheService.safeUri(uri), (Object)statusCode);
            }
            if (!this.isHttpSuccess(statusCode)) {
                String defaultMessage = String.format("Storing entry at '%s' response status %d: %s", HttpBuildCacheService.safeUri(uri), statusCode, response.getStatusReason());
                this.throwHttpStatusCodeException(statusCode, defaultMessage);
            }
        }
        catch (ClientProtocolException e) {
            throw HttpBuildCacheService.wrap(e.getCause());
        }
        catch (IOException e) {
            throw HttpBuildCacheService.wrap(e);
        }
    }

    private static BuildCacheException wrap(Throwable e) {
        if (e instanceof Error) {
            throw (Error)e;
        }
        throw new BuildCacheException(e.getMessage(), e);
    }

    private boolean throwHttpStatusCodeException(int statusCode, String message) {
        if (FATAL_HTTP_ERROR_CODES.contains(statusCode)) {
            throw UncheckedException.throwAsUncheckedException((Throwable)new IOException(message), (boolean)true);
        }
        throw new BuildCacheException(message);
    }

    private boolean isHttpSuccess(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }

    public void close() throws IOException {
        this.client.close();
    }

    private static URI safeUri(URI uri) {
        try {
            return new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private static URI withTrailingSlash(URI uri) {
        if (uri.getPath().endsWith("/")) {
            return uri;
        }
        try {
            return new URIBuilder(uri).setPath(uri.getPath() + "/").build();
        }
        catch (URISyntaxException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }
}

