/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.cc.impl;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.internal.artifacts.configurations.ProjectComponentObservationListener;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.execution.plan.Node;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.service.scopes.ParallelListener;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.util.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParallelListener
@ServiceScope(value={Scope.Build.class})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\tH\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0018\u001a\u00020\u0012H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000fH\u0002J\u001a\u0010\u001c\u001a\u00020\u00142\b\u0010\u001d\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001e\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u001e\u0012\t\u0012\u00070\n\u00a2\u0006\u0002\b\u000b \r*\r\u0012\t\u0012\u00070\n\u00a2\u0006\u0002\b\u000b0\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/gradle/internal/cc/impl/RelevantProjectsRegistry;", "Lorg/gradle/api/internal/artifacts/configurations/ProjectComponentObservationListener;", "build", "Lorg/gradle/internal/build/BuildState;", "projectStateRegistry", "Lorg/gradle/api/internal/project/ProjectStateRegistry;", "<init>", "(Lorg/gradle/internal/build/BuildState;Lorg/gradle/api/internal/project/ProjectStateRegistry;)V", "targetProjects", "", "Lorg/gradle/util/Path;", "Lkotlin/jvm/internal/EnhancedNullability;", "", "kotlin.jvm.PlatformType", "relevantProjects", "Lorg/gradle/api/internal/project/ProjectState;", "nodes", "", "Lorg/gradle/execution/plan/Node;", "collect", "", "project", "projects", "projectStateOf", "node", "isLocalProject", "", "projectState", "projectObserved", "consumingProjectPath", "targetProjectPath", "configuration-cache"})
public final class RelevantProjectsRegistry
implements ProjectComponentObservationListener {
    @NotNull
    private final BuildState build;
    @NotNull
    private final ProjectStateRegistry projectStateRegistry;
    @NotNull
    private final Set<Path> targetProjects;

    public RelevantProjectsRegistry(@NotNull BuildState build, @NotNull ProjectStateRegistry projectStateRegistry) {
        Intrinsics.checkNotNullParameter((Object)build, (String)"build");
        Intrinsics.checkNotNullParameter((Object)projectStateRegistry, (String)"projectStateRegistry");
        this.build = build;
        this.projectStateRegistry = projectStateRegistry;
        Set set = Sets.newConcurrentHashSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"newConcurrentHashSet(...)");
        this.targetProjects = set;
    }

    @NotNull
    public final Set<ProjectState> relevantProjects(@NotNull List<? extends Node> nodes) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        Set result2 = new LinkedHashSet();
        for (Path path : this.targetProjects) {
            ProjectState projectState = this.projectStateRegistry.stateFor(path);
            Intrinsics.checkNotNullExpressionValue((Object)projectState, (String)"stateFor(...)");
            this.collect(projectState, result2);
        }
        for (Node node : nodes) {
            ProjectState project = this.projectStateOf(node);
            if (project == null || !this.isLocalProject(project)) continue;
            this.collect(project, result2);
        }
        return result2;
    }

    private final void collect(ProjectState project, Set<ProjectState> projects) {
        if (!projects.add(project)) {
            return;
        }
        ProjectState parent = project.getParent();
        if (parent != null) {
            this.collect(parent, projects);
        }
    }

    private final ProjectState projectStateOf(Node node) {
        ProjectInternal projectInternal = node.getOwningProject();
        return projectInternal != null ? projectInternal.getOwner() : null;
    }

    private final boolean isLocalProject(ProjectState projectState) {
        return projectState.getOwner() == this.build;
    }

    public void projectObserved(@Nullable Path consumingProjectPath, @NotNull Path targetProjectPath) {
        Intrinsics.checkNotNullParameter((Object)targetProjectPath, (String)"targetProjectPath");
        this.targetProjects.add(targetProjectPath);
    }
}

