/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.operations.BuildOperation;
import org.gradle.internal.operations.BuildOperationConstraint;
import org.gradle.internal.operations.BuildOperationExecutionContext;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.BuildOperationQueueFactory;
import org.gradle.internal.operations.BuildOperationQueueFailure;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.BuildOperationWorker;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.operations.MultipleBuildOperationFailures;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.work.WorkerLimits;

public class DefaultBuildOperationExecutor
implements BuildOperationExecutor,
Stoppable {
    public static final int MIN_UNCONSTRAINED_EXECUTOR_PARALLELISM = 64;
    private static final String LINE_SEPARATOR = SystemProperties.getInstance().getLineSeparator();
    private final BuildOperationRunner runner;
    private final BuildOperationQueueFactory buildOperationQueueFactory;
    private final CurrentBuildOperationRef currentBuildOperationRef;
    private final BuildOperationExecutionContext maxWorkersExecutionContext;
    private final BuildOperationExecutionContext unconstrainedExecutionContext;

    public DefaultBuildOperationExecutor(BuildOperationRunner buildOperationRunner, CurrentBuildOperationRef currentBuildOperationRef, BuildOperationQueueFactory buildOperationQueueFactory, ExecutorFactory executorFactory, WorkerLimits workerLimits) {
        this.runner = buildOperationRunner;
        this.currentBuildOperationRef = currentBuildOperationRef;
        this.buildOperationQueueFactory = buildOperationQueueFactory;
        this.maxWorkersExecutionContext = new BuildOperationExecutionContext(executorFactory.create("Build operations", workerLimits.getMaxWorkerCount()), workerLimits.getMaxWorkerCount(), true);
        int unconstrainedExecutorParallelism = Math.max(64, workerLimits.getMaxWorkerCount());
        this.unconstrainedExecutionContext = new BuildOperationExecutionContext(executorFactory.create("Unconstrained build operations", unconstrainedExecutorParallelism), unconstrainedExecutorParallelism, false);
    }

    public <O extends RunnableBuildOperation> void runAll(Action<BuildOperationQueue<O>> schedulingAction) {
        this.runAll(schedulingAction, BuildOperationConstraint.MAX_WORKERS);
    }

    public <O extends RunnableBuildOperation> void runAll(Action<BuildOperationQueue<O>> schedulingAction, BuildOperationConstraint buildOperationConstraint) {
        this.executeInParallel(false, RunnableBuildOperation::run, schedulingAction, buildOperationConstraint);
    }

    public <O extends RunnableBuildOperation> void runAllWithAccessToProjectState(Action<BuildOperationQueue<O>> schedulingAction) {
        this.runAllWithAccessToProjectState(schedulingAction, BuildOperationConstraint.MAX_WORKERS);
    }

    public <O extends RunnableBuildOperation> void runAllWithAccessToProjectState(Action<BuildOperationQueue<O>> schedulingAction, BuildOperationConstraint buildOperationConstraint) {
        this.executeInParallel(true, RunnableBuildOperation::run, schedulingAction, buildOperationConstraint);
    }

    public <O extends BuildOperation> void runAll(BuildOperationWorker<O> worker, Action<BuildOperationQueue<O>> schedulingAction) {
        this.runAll(worker, schedulingAction, BuildOperationConstraint.MAX_WORKERS);
    }

    public <O extends BuildOperation> void runAll(BuildOperationWorker<O> worker, Action<BuildOperationQueue<O>> schedulingAction, BuildOperationConstraint buildOperationConstraint) {
        this.executeInParallel(false, worker, schedulingAction, buildOperationConstraint);
    }

    private <O extends BuildOperation> void executeInParallel(boolean allowAccessToProjectState, BuildOperationWorker<O> worker, Action<BuildOperationQueue<O>> queueAction, BuildOperationConstraint buildOperationConstraint) {
        BuildOperationExecutionContext executionContext = this.getExecutionContextFor(buildOperationConstraint);
        BuildOperationQueue queue = this.buildOperationQueueFactory.create(executionContext, allowAccessToProjectState, operation -> this.runner.execute(operation, worker), this.currentBuildOperationRef.get());
        ArrayList<GradleException> failures = new ArrayList<GradleException>();
        try {
            queueAction.execute(queue);
        }
        catch (Exception e) {
            failures.add((GradleException)new BuildOperationQueueFailure("There was a failure while populating the build operation queue: " + e.getMessage(), (Throwable)e));
            queue.cancel();
        }
        try {
            queue.waitForCompletion();
        }
        catch (MultipleBuildOperationFailures e) {
            failures.add((GradleException)e);
        }
        if (failures.size() == 1) {
            throw (GradleException)failures.get(0);
        }
        if (failures.size() > 1) {
            throw new DefaultMultiCauseException(DefaultBuildOperationExecutor.formatMultipleFailureMessage(failures), failures);
        }
    }

    private BuildOperationExecutionContext getExecutionContextFor(BuildOperationConstraint buildOperationConstraint) {
        switch (buildOperationConstraint) {
            case UNCONSTRAINED: {
                return this.unconstrainedExecutionContext;
            }
            case MAX_WORKERS: {
                return this.maxWorkersExecutionContext;
            }
        }
        throw new IllegalArgumentException("Unknown build operation constraint: " + buildOperationConstraint);
    }

    private static String formatMultipleFailureMessage(List<GradleException> failures) {
        return failures.stream().map(Throwable::getMessage).collect(Collectors.joining(LINE_SEPARATOR + "AND" + LINE_SEPARATOR));
    }

    public void stop() {
        this.maxWorkersExecutionContext.getExecutor().stop();
        this.unconstrainedExecutionContext.getExecutor().stop();
    }
}

