/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.problems.internal.rendering;

import java.util.Arrays;
import java.util.List;
import org.gradle.api.problems.ProblemId;
import org.gradle.problems.internal.rendering.DefaultProblemWriter;
import org.gradle.problems.internal.rendering.JavaCompilationWriter;
import org.gradle.problems.internal.rendering.SelectiveProblemWriter;

class ProblemWriterRegistry {
    public static final ProblemWriterRegistry INSTANCE = new ProblemWriterRegistry();
    private static final List<SelectiveProblemWriter> WRITERS = Arrays.asList(new JavaCompilationWriter(), new DefaultProblemWriter());

    private ProblemWriterRegistry() {
    }

    public SelectiveProblemWriter problemWriterFor(ProblemId problemId) {
        for (SelectiveProblemWriter writer : WRITERS) {
            if (!writer.accepts(problemId)) continue;
            return writer;
        }
        throw new IllegalStateException("No writer found for problem Id: " + problemId);
    }
}

