/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.javac.resolve;

import com.sun.source.tree.CompilationUnitTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.javac.JavaClassWithClassId;
import org.jetbrains.kotlin.javac.JavacWrapper;
import org.jetbrains.kotlin.javac.resolve.ResolveHelperKt;
import org.jetbrains.kotlin.load.java.JavaDescriptorVisibilities;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaClassifier;
import org.jetbrains.kotlin.load.java.structure.JavaClassifierType;
import org.jetbrains.kotlin.load.java.structure.JavaPackage;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0016\u0010\u000e\u001a\u0004\u0018\u00010\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\u0011J2\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0018\b\u0002\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\t0\u0016j\b\u0012\u0004\u0012\u00020\t`\u0017J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\rJ\u0016\u0010\u001b\u001a\u0004\u0018\u00010\t*\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001c\u0010\u0012\u001a\u0004\u0018\u00010\t*\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/javac/resolve/ResolveHelper;", "", "javac", "Lorg/jetbrains/kotlin/javac/JavacWrapper;", "compilationUnit", "Lcom/sun/source/tree/CompilationUnitTree;", "<init>", "(Lorg/jetbrains/kotlin/javac/JavacWrapper;Lcom/sun/source/tree/CompilationUnitTree;)V", "getJavaClassFromPathSegments", "Lorg/jetbrains/kotlin/load/java/structure/JavaClass;", "javaClass", "pathSegments", "", "", "findImport", "findJavaOrKotlinClass", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "findInnerOrNested", "name", "Lorg/jetbrains/kotlin/name/Name;", "checkedSupertypes", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "findPackage", "Lorg/jetbrains/kotlin/name/FqName;", "packageName", "findVisibleInnerOrNestedClass", "javac-wrapper"})
@SourceDebugExtension(value={"SMAP\nResolveHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResolveHelper.kt\norg/jetbrains/kotlin/javac/resolve/ResolveHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n1878#2,3:104\n1617#2,9:107\n1869#2:116\n1870#2:118\n1626#2:119\n1803#2,3:121\n1#3:117\n1#3:120\n*S KotlinDebug\n*F\n+ 1 ResolveHelper.kt\norg/jetbrains/kotlin/javac/resolve/ResolveHelper\n*L\n42#1:104,3\n65#1:107,9\n65#1:116\n65#1:118\n65#1:119\n94#1:121,3\n65#1:117\n*E\n"})
public final class ResolveHelper {
    @NotNull
    private final JavacWrapper javac;
    @NotNull
    private final CompilationUnitTree compilationUnit;

    public ResolveHelper(@NotNull JavacWrapper javac2, @NotNull CompilationUnitTree compilationUnit) {
        Intrinsics.checkNotNullParameter((Object)javac2, (String)"javac");
        Intrinsics.checkNotNullParameter((Object)compilationUnit, (String)"compilationUnit");
        this.javac = javac2;
        this.compilationUnit = compilationUnit;
    }

    @Nullable
    public final JavaClass getJavaClassFromPathSegments(@NotNull JavaClass javaClass, @NotNull List<String> pathSegments) {
        Intrinsics.checkNotNullParameter((Object)javaClass, (String)"javaClass");
        Intrinsics.checkNotNullParameter(pathSegments, (String)"pathSegments");
        return pathSegments.size() == 1 ? javaClass : this.findInnerOrNested(javaClass, CollectionsKt.drop((Iterable)pathSegments, (int)1));
    }

    @Nullable
    public final JavaClass findImport(@NotNull List<String> pathSegments) {
        Intrinsics.checkNotNullParameter(pathSegments, (String)"pathSegments");
        Iterable $this$forEachIndexed$iv = pathSegments;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            JavaClass javaClass;
            int n2;
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String cfr_ignored_0 = (String)item$iv;
            int index = n2;
            boolean bl = false;
            if (index == CollectionsKt.getLastIndex(pathSegments)) {
                return null;
            }
            String packageFqName = CollectionsKt.joinToString$default((Iterable)CollectionsKt.dropLast(pathSegments, (int)(index + 1)), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
            FqName fqName = this.findPackage(packageFqName);
            if (fqName == null) continue;
            FqName pack = fqName;
            boolean bl2 = false;
            List className = CollectionsKt.takeLast(pathSegments, (int)(index + 1));
            Name name2 = Name.identifier((String)CollectionsKt.first((List)className));
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
            JavaClass javaClass2 = this.findJavaOrKotlinClass(new ClassId(pack, name2));
            if (javaClass2 != null) {
                JavaClass javaClass3 = javaClass2;
                boolean bl3 = false;
                javaClass = this.getJavaClassFromPathSegments(javaClass3, className);
            } else {
                javaClass = null;
            }
            return javaClass;
        }
        return null;
    }

    @Nullable
    public final JavaClass findJavaOrKotlinClass(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        JavaClass javaClass = JavacWrapper.findClass$default(this.javac, classId, null, 2, null);
        if (javaClass == null) {
            javaClass = this.javac.getKotlinClassifier(classId);
        }
        return javaClass;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final JavaClass findInnerOrNested(@NotNull JavaClass javaClass, @NotNull Name name2, @NotNull HashSet<JavaClass> checkedSupertypes) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)javaClass, (String)"javaClass");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(checkedSupertypes, (String)"checkedSupertypes");
        Object object = this.findVisibleInnerOrNestedClass(javaClass, name2);
        if (object != null) {
            JavaClass it = object;
            boolean bl = false;
            checkedSupertypes.addAll((Collection<JavaClass>)ResolveHelperKt.collectAllSupertypes(javaClass));
            return it;
        }
        object = javaClass.getSupertypes();
        boolean $i$f$mapNotNull = false;
        void it = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            JavaClass javaClass2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            JavaClassifierType it2 = (JavaClassifierType)element$iv$iv;
            boolean bl2 = false;
            JavaClassifier javaClassifier = it2.getClassifier();
            if ((javaClassifier instanceof JavaClass ? (JavaClass)javaClassifier : null) != null) {
                JavaClass supertype;
                supertype = supertype;
                boolean bl3 = false;
                javaClass2 = !checkedSupertypes.contains(supertype) ? this.findInnerOrNested(supertype, name2, checkedSupertypes) : null;
            } else {
                javaClass2 = null;
            }
            if (javaClass2 == null) continue;
            JavaClass it$iv$iv = javaClass2;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (JavaClass)CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
    }

    public static /* synthetic */ JavaClass findInnerOrNested$default(ResolveHelper resolveHelper, JavaClass javaClass, Name name2, HashSet hashSet, int n2, Object object) {
        if ((n2 & 4) != 0) {
            hashSet = new HashSet<JavaClass>();
        }
        return resolveHelper.findInnerOrNested(javaClass, name2, hashSet);
    }

    @Nullable
    public final FqName findPackage(@NotNull String packageName2) {
        Intrinsics.checkNotNullParameter((Object)packageName2, (String)"packageName");
        FqName fqName = !StringsKt.isBlank((CharSequence)packageName2) ? new FqName(packageName2) : FqName.ROOT;
        FqName fqName2 = this.javac.hasKotlinPackage(fqName);
        if (fqName2 != null) {
            FqName it = fqName2;
            boolean bl = false;
            return it;
        }
        JavaPackage javaPackage = JavacWrapper.findPackage$default(this.javac, fqName, null, 2, null);
        return javaPackage != null ? javaPackage.getFqName() : null;
    }

    private final JavaClass findVisibleInnerOrNestedClass(JavaClass $this$findVisibleInnerOrNestedClass, Name name2) {
        JavaClass javaClass;
        JavaClass javaClass2 = $this$findVisibleInnerOrNestedClass.findInnerClass(name2);
        if (javaClass2 != null) {
            JavaClass innerOrNestedClass = javaClass2;
            boolean bl = false;
            Visibility visibility = innerOrNestedClass.getVisibility();
            if (Intrinsics.areEqual((Object)visibility, (Object)DescriptorVisibilities.PRIVATE)) {
                javaClass = null;
            } else if (Intrinsics.areEqual((Object)visibility, (Object)JavaDescriptorVisibilities.PACKAGE_VISIBILITY)) {
                JavaClassWithClassId javaClassWithClassId = innerOrNestedClass instanceof JavaClassWithClassId ? (JavaClassWithClassId)innerOrNestedClass : null;
                ClassId classId = javaClassWithClassId != null ? javaClassWithClassId.getClassId() : null;
                Object object = classId;
                String string = object != null && (object = ((ClassId)object).getPackageFqName()) != null ? ((FqName)object).asString() : null;
                Object object2 = this.compilationUnit.getPackageName();
                if (object2 == null || (object2 = object2.toString()) == null) {
                    object2 = "";
                }
                javaClass = Intrinsics.areEqual((Object)string, (Object)object2) ? (JavaClassWithClassId)innerOrNestedClass : null;
            } else {
                javaClass = innerOrNestedClass;
            }
        } else {
            javaClass = null;
        }
        return javaClass;
    }

    /*
     * WARNING - void declaration
     */
    private final JavaClass findInnerOrNested(JavaClass $this$findInnerOrNested, List<String> pathSegments) {
        void $this$fold$iv;
        Iterable iterable = pathSegments;
        JavaClass initial$iv = $this$findInnerOrNested;
        boolean $i$f$fold = false;
        JavaClass accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void it;
            String string = (String)element$iv;
            JavaClass javaClass = accumulator$iv;
            boolean bl = false;
            Name name2 = Name.identifier((String)it);
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
            if (ResolveHelper.findInnerOrNested$default(this, javaClass, name2, null, 4, null) != null) continue;
            return null;
        }
        return accumulator$iv;
    }
}

