/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.tools.api.impl;

import java.util.Optional;
import java.util.Set;
import org.gradle.internal.tools.api.ApiMemberWriter;
import org.gradle.internal.tools.api.ApiMemberWriterAdapter;
import org.gradle.internal.tools.api.impl.AnnotationAnnotationValue;
import org.gradle.internal.tools.api.impl.AnnotationMember;
import org.gradle.internal.tools.api.impl.AnnotationValue;
import org.gradle.internal.tools.api.impl.ArrayAnnotationValue;
import org.gradle.internal.tools.api.impl.ClassMember;
import org.gradle.internal.tools.api.impl.EnumAnnotationValue;
import org.gradle.internal.tools.api.impl.FieldMember;
import org.gradle.internal.tools.api.impl.InnerClassMember;
import org.gradle.internal.tools.api.impl.MethodMember;
import org.gradle.internal.tools.api.impl.ParameterAnnotationMember;
import org.gradle.internal.tools.api.impl.SimpleAnnotationValue;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.ModuleVisitor;
import org.objectweb.asm.Type;

public class JavaApiMemberWriter
implements ApiMemberWriter {
    private final ClassVisitor apiMemberAdapter;

    protected JavaApiMemberWriter(ClassVisitor apiMemberAdapter) {
        this.apiMemberAdapter = apiMemberAdapter;
    }

    public static ApiMemberWriterAdapter adapter() {
        return JavaApiMemberWriter::new;
    }

    @Override
    public ModuleVisitor writeModule(String name, int access, String version) {
        return this.apiMemberAdapter.visitModule(name, access, version);
    }

    @Override
    public void writeClass(ClassMember classMember, Set<MethodMember> methods, Set<FieldMember> fields, Set<InnerClassMember> innerClasses) {
        this.apiMemberAdapter.visit(classMember.getVersion(), classMember.getAccess(), classMember.getName(), classMember.getSignature(), classMember.getSuperName(), classMember.getInterfaces());
        this.writeClassAnnotations(classMember.getAnnotations());
        for (String permittedSubclass : classMember.getPermittedSubclasses()) {
            this.apiMemberAdapter.visitPermittedSubclass(permittedSubclass);
        }
        InnerClassMember declaringInnerClass = innerClasses.stream().filter(innerClass -> innerClass.getName().equals(classMember.getName())).findFirst().orElse(null);
        for (MethodMember method : methods) {
            this.writeMethod(classMember, declaringInnerClass, method);
        }
        for (FieldMember field : fields) {
            FieldVisitor fieldVisitor = this.apiMemberAdapter.visitField(field.getAccess(), field.getName(), field.getTypeDesc(), field.getSignature(), field.getValue());
            this.writeFieldAnnotations(fieldVisitor, field.getAnnotations());
            fieldVisitor.visitEnd();
        }
        for (InnerClassMember innerClass2 : innerClasses) {
            this.apiMemberAdapter.visitInnerClass(innerClass2.getName(), innerClass2.getOuterName(), innerClass2.getInnerName(), innerClass2.getAccess());
        }
        this.apiMemberAdapter.visitEnd();
    }

    @Override
    public void writeMethod(ClassMember classMember, InnerClassMember declaringInnerClass, MethodMember method) {
        MethodVisitor mv = this.apiMemberAdapter.visitMethod(method.getAccess(), method.getName(), method.getTypeDesc(), method.getSignature(), method.getExceptions().toArray(new String[0]));
        this.writeMethodAnnotations(mv, method.getAnnotations());
        this.writeMethodAnnotations(mv, method.getParameterAnnotations());
        JavaApiMemberWriter.calculateNonAnnotableParameterCount(classMember, declaringInnerClass, method).ifPresent(nonAnnotableParameterCount -> {
            int totalParameterCount = Type.getArgumentCount((String)method.getTypeDesc());
            int annotableParameterCount = totalParameterCount - nonAnnotableParameterCount;
            mv.visitAnnotableParameterCount(annotableParameterCount, true);
            mv.visitAnnotableParameterCount(annotableParameterCount, false);
        });
        method.getAnnotationDefaultValue().ifPresent(value -> {
            AnnotationVisitor av = mv.visitAnnotationDefault();
            this.writeAnnotationValue(av, (AnnotationValue<?>)value);
            av.visitEnd();
        });
        mv.visitEnd();
    }

    private static Optional<Integer> calculateNonAnnotableParameterCount(ClassMember classMember, InnerClassMember declaringInnerClass, MethodMember method) {
        if (method.getName().equals("<init>")) {
            if ((classMember.getAccess() & 0x4000) == 16384) {
                return Optional.of(2);
            }
            if (declaringInnerClass != null && (declaringInnerClass.getAccess() & 8) != 8) {
                return Optional.of(1);
            }
        }
        return Optional.empty();
    }

    @Override
    public void writeClassAnnotations(Set<AnnotationMember> annotationMembers) {
        for (AnnotationMember annotation : annotationMembers) {
            AnnotationVisitor annotationVisitor = this.apiMemberAdapter.visitAnnotation(annotation.getName(), annotation.isVisible());
            this.writeAnnotationValues(annotation, annotationVisitor);
        }
    }

    @Override
    public void writeMethodAnnotations(MethodVisitor mv, Set<AnnotationMember> annotationMembers) {
        for (AnnotationMember annotation : annotationMembers) {
            AnnotationVisitor annotationVisitor = annotation instanceof ParameterAnnotationMember ? mv.visitParameterAnnotation(((ParameterAnnotationMember)annotation).getParameter(), annotation.getName(), annotation.isVisible()) : mv.visitAnnotation(annotation.getName(), annotation.isVisible());
            this.writeAnnotationValues(annotation, annotationVisitor);
        }
    }

    @Override
    public void writeFieldAnnotations(FieldVisitor fv, Set<AnnotationMember> annotationMembers) {
        for (AnnotationMember annotation : annotationMembers) {
            AnnotationVisitor annotationVisitor = fv.visitAnnotation(annotation.getName(), annotation.isVisible());
            this.writeAnnotationValues(annotation, annotationVisitor);
        }
    }

    @Override
    public void writeAnnotationValues(AnnotationMember annotation, AnnotationVisitor annotationVisitor) {
        for (AnnotationValue annotationValue : annotation.getValues()) {
            this.writeAnnotationValue(annotationVisitor, annotationValue);
        }
        annotationVisitor.visitEnd();
    }

    @Override
    public void writeAnnotationValue(AnnotationVisitor annotationVisitor, AnnotationValue<?> value) {
        String name = value.getName();
        if (value instanceof EnumAnnotationValue) {
            annotationVisitor.visitEnum(name, ((EnumAnnotationValue)value).getTypeDesc(), (String)value.getValue());
        } else if (value instanceof SimpleAnnotationValue) {
            annotationVisitor.visit(name, value.getValue());
        } else if (value instanceof ArrayAnnotationValue) {
            AnnotationValue[] values;
            AnnotationVisitor arrayVisitor = annotationVisitor.visitArray(name);
            for (AnnotationValue annotationValue : values = (AnnotationValue[])((ArrayAnnotationValue)value).getValue()) {
                this.writeAnnotationValue(arrayVisitor, annotationValue);
            }
            arrayVisitor.visitEnd();
        } else if (value instanceof AnnotationAnnotationValue) {
            AnnotationMember annotation = (AnnotationMember)((AnnotationAnnotationValue)value).getValue();
            AnnotationVisitor annVisitor = annotationVisitor.visitAnnotation(name, annotation.getName());
            this.writeAnnotationValues(annotation, annVisitor);
        } else {
            throw new AssertionError((Object)("Unknown annotation value type: " + value.getClass().getName()));
        }
    }
}

