#pragma once

#include "esphome/core/hal.h"

namespace esphome {
namespace sx126x {

static const uint32_t XTAL_FREQ = 32000000;

enum SX126xOpCode : uint8_t {
  RADIO_GET_STATUS = 0xC0,
  RADIO_WRITE_REGISTER = 0x0D,
  RADIO_READ_REGISTER = 0x1D,
  RADIO_WRITE_BUFFER = 0x0E,
  RADIO_READ_BUFFER = 0x1E,
  RADIO_SET_SLEEP = 0x84,
  RADIO_SET_STANDBY = 0x80,
  RADIO_SET_FS = 0xC1,
  RADIO_SET_TX = 0x83,
  RADIO_SET_RX = 0x82,
  RADIO_SET_RXDUTYCYCLE = 0x94,
  RADIO_SET_CAD = 0xC5,
  RADIO_SET_TXCONTINUOUSWAVE = 0xD1,
  RADIO_SET_TXCONTINUOUSPREAMBLE = 0xD2,
  RADIO_SET_PACKETTYPE = 0x8A,
  RADIO_GET_PACKETTYPE = 0x11,
  RADIO_SET_RFFREQUENCY = 0x86,
  RADIO_SET_TXPARAMS = 0x8E,
  RADIO_SET_PACONFIG = 0x95,
  RADIO_SET_CADPARAMS = 0x88,
  RADIO_SET_BUFFERBASEADDRESS = 0x8F,
  RADIO_SET_MODULATIONPARAMS = 0x8B,
  RADIO_SET_PACKETPARAMS = 0x8C,
  RADIO_GET_RXBUFFERSTATUS = 0x13,
  RADIO_GET_PACKETSTATUS = 0x14,
  RADIO_GET_RSSIINST = 0x15,
  RADIO_GET_STATS = 0x10,
  RADIO_RESET_STATS = 0x00,
  RADIO_SET_DIOIRQPARAMS = 0x08,
  RADIO_GET_IRQSTATUS = 0x12,
  RADIO_CLR_IRQSTATUS = 0x02,
  RADIO_CALIBRATE = 0x89,
  RADIO_CALIBRATEIMAGE = 0x98,
  RADIO_SET_REGULATORMODE = 0x96,
  RADIO_GET_ERROR = 0x17,
  RADIO_CLR_ERROR = 0x07,
  RADIO_SET_TCXOMODE = 0x97,
  RADIO_SET_TXFALLBACKMODE = 0x93,
  RADIO_SET_RFSWITCHMODE = 0x9D,
  RADIO_SET_STOPRXTIMERONPREAMBLE = 0x9F,
  RADIO_SET_LORASYMBTIMEOUT = 0xA0,
};

enum SX126xRegister : uint16_t {
  REG_VERSION_STRING = 0x0320,
  REG_CRC_INITIAL = 0x06BC,
  REG_CRC_POLYNOMIAL = 0x06BE,
  REG_GFSK_SYNCWORD = 0x06C0,
  REG_LORA_SYNCWORD = 0x0740,
  REG_OCP = 0x08E7,
};

enum SX126xStandbyMode : uint8_t {
  STDBY_RC = 0x00,
  STDBY_XOSC = 0x01,
};

enum SX126xPacketType : uint8_t {
  PACKET_TYPE_GFSK = 0x00,
  PACKET_TYPE_LORA = 0x01,
  PACKET_TYPE_LRHSS = 0x03,
};

enum SX126xFskBw : uint8_t {
  FSK_BW_4800 = 0x1F,
  FSK_BW_5800 = 0x17,
  FSK_BW_7300 = 0x0F,
  FSK_BW_9700 = 0x1E,
  FSK_BW_11700 = 0x16,
  FSK_BW_14600 = 0x0E,
  FSK_BW_19500 = 0x1D,
  FSK_BW_23400 = 0x15,
  FSK_BW_29300 = 0x0D,
  FSK_BW_39000 = 0x1C,
  FSK_BW_46900 = 0x14,
  FSK_BW_58600 = 0x0C,
  FSK_BW_78200 = 0x1B,
  FSK_BW_93800 = 0x13,
  FSK_BW_117300 = 0x0B,
  FSK_BW_156200 = 0x1A,
  FSK_BW_187200 = 0x12,
  FSK_BW_234300 = 0x0A,
  FSK_BW_312000 = 0x19,
  FSK_BW_373600 = 0x11,
  FSK_BW_467000 = 0x09,
};

enum SX126xLoraBw : uint8_t {
  LORA_BW_7810 = 0x00,
  LORA_BW_10420 = 0x08,
  LORA_BW_15630 = 0x01,
  LORA_BW_20830 = 0x09,
  LORA_BW_31250 = 0x02,
  LORA_BW_41670 = 0x0A,
  LORA_BW_62500 = 0x03,
  LORA_BW_125000 = 0x04,
  LORA_BW_250000 = 0x05,
  LORA_BW_500000 = 0x06,
};

enum SX126xLoraCr : uint8_t {
  LORA_CR_4_5 = 0x01,
  LORA_CR_4_6 = 0x02,
  LORA_CR_4_7 = 0x03,
  LORA_CR_4_8 = 0x04,
};

enum SX126xIrqMasks : uint16_t {
  IRQ_RADIO_NONE = 0x0000,
  IRQ_TX_DONE = 0x0001,
  IRQ_RX_DONE = 0x0002,
  IRQ_PREAMBLE_DETECTED = 0x0004,
  IRQ_SYNCWORD_VALID = 0x0008,
  IRQ_HEADER_VALID = 0x0010,
  IRQ_HEADER_ERROR = 0x0020,
  IRQ_CRC_ERROR = 0x0040,
  IRQ_CAD_DONE = 0x0080,
  IRQ_CAD_ACTIVITY_DETECTED = 0x0100,
  IRQ_RX_TX_TIMEOUT = 0x0200,
  IRQ_RADIO_ALL = 0xFFFF,
};

enum SX126xTcxoCtrl : uint8_t {
  TCXO_CTRL_1_6V = 0x00,
  TCXO_CTRL_1_7V = 0x01,
  TCXO_CTRL_1_8V = 0x02,
  TCXO_CTRL_2_2V = 0x03,
  TCXO_CTRL_2_4V = 0x04,
  TCXO_CTRL_2_7V = 0x05,
  TCXO_CTRL_3_0V = 0x06,
  TCXO_CTRL_3_3V = 0x07,
  TCXO_CTRL_NONE = 0xFF,
};

enum SX126xPulseShape : uint8_t {
  NO_FILTER = 0x00,
  GAUSSIAN_BT_0_3 = 0x08,
  GAUSSIAN_BT_0_5 = 0x09,
  GAUSSIAN_BT_0_7 = 0x0A,
  GAUSSIAN_BT_1_0 = 0x0B,
};

enum SX126xRampTime : uint8_t {
  PA_RAMP_10 = 0x00,
  PA_RAMP_20 = 0x01,
  PA_RAMP_40 = 0x02,
  PA_RAMP_80 = 0x03,
  PA_RAMP_200 = 0x04,
  PA_RAMP_800 = 0x05,
  PA_RAMP_1700 = 0x06,
  PA_RAMP_3400 = 0x07,
};

}  // namespace sx126x
}  // namespace esphome
