const { Open } = require('./unzip');
const unzipper = require('./unzip')
const fs = require('fs');
const ZipOpen = Open;

async function main3() {

  const unzip = await ZipOpen.file('./t/test.zip');
  console.log(unzip.files.length)
  unzip.files.forEach((entry) => {
    console.log(entry.path);
  });
}

async function main() {
  fs.createReadStream('./t/test.zip')
  .pipe(unzipper.Parse())
  .on('entry', function (entry) {
    const fileName = entry.path;
    const type = entry.type; // 'Directory' or 'File'
    const size = entry.vars.uncompressedSize; // There is also compressedSize;
    console.log('using unzipper');
    console.log(fileName);
  });
}


async function main2() {
  const directory = await unzipper.Open.file('./testData/compressed-directory-entry/archive.zip');
  console.log('directory', directory);
  return new Promise( (resolve, reject) => {
    directory.files[0]
      .stream()
      .pipe(fs.createWriteStream('firstFile'))
      .on('error',reject)
      .on('finish',resolve)
  });
}

main();
