﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/backup-gateway/BackupGatewayRequest.h>
#include <aws/backup-gateway/BackupGateway_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace BackupGateway {
namespace Model {

/**
 */
class UpdateGatewayInformationRequest : public BackupGatewayRequest {
 public:
  AWS_BACKUPGATEWAY_API UpdateGatewayInformationRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "UpdateGatewayInformation"; }

  AWS_BACKUPGATEWAY_API Aws::String SerializePayload() const override;

  AWS_BACKUPGATEWAY_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the gateway to update.</p>
   */
  inline const Aws::String& GetGatewayArn() const { return m_gatewayArn; }
  inline bool GatewayArnHasBeenSet() const { return m_gatewayArnHasBeenSet; }
  template <typename GatewayArnT = Aws::String>
  void SetGatewayArn(GatewayArnT&& value) {
    m_gatewayArnHasBeenSet = true;
    m_gatewayArn = std::forward<GatewayArnT>(value);
  }
  template <typename GatewayArnT = Aws::String>
  UpdateGatewayInformationRequest& WithGatewayArn(GatewayArnT&& value) {
    SetGatewayArn(std::forward<GatewayArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The updated display name of the gateway.</p>
   */
  inline const Aws::String& GetGatewayDisplayName() const { return m_gatewayDisplayName; }
  inline bool GatewayDisplayNameHasBeenSet() const { return m_gatewayDisplayNameHasBeenSet; }
  template <typename GatewayDisplayNameT = Aws::String>
  void SetGatewayDisplayName(GatewayDisplayNameT&& value) {
    m_gatewayDisplayNameHasBeenSet = true;
    m_gatewayDisplayName = std::forward<GatewayDisplayNameT>(value);
  }
  template <typename GatewayDisplayNameT = Aws::String>
  UpdateGatewayInformationRequest& WithGatewayDisplayName(GatewayDisplayNameT&& value) {
    SetGatewayDisplayName(std::forward<GatewayDisplayNameT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_gatewayArn;

  Aws::String m_gatewayDisplayName;
  bool m_gatewayArnHasBeenSet = false;
  bool m_gatewayDisplayNameHasBeenSet = false;
};

}  // namespace Model
}  // namespace BackupGateway
}  // namespace Aws
