﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/ivschat/Ivschat_EXPORTS.h>
#include <aws/ivschat/model/MessageReviewHandler.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ivschat {
namespace Model {
class UpdateRoomResult {
 public:
  AWS_IVSCHAT_API UpdateRoomResult() = default;
  AWS_IVSCHAT_API UpdateRoomResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_IVSCHAT_API UpdateRoomResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Room ARN, from the request (if <code>identifier</code> was an ARN).</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  UpdateRoomResult& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Room ID, generated by the system. This is a relative identifier, the part of
   * the ARN that uniquely identifies the room.</p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  UpdateRoomResult& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Room name, from the request (if specified).</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  UpdateRoomResult& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Time when the room was created. This is an ISO 8601 timestamp; <i>note that
   * this is returned as a string</i>.</p>
   */
  inline const Aws::Utils::DateTime& GetCreateTime() const { return m_createTime; }
  template <typename CreateTimeT = Aws::Utils::DateTime>
  void SetCreateTime(CreateTimeT&& value) {
    m_createTimeHasBeenSet = true;
    m_createTime = std::forward<CreateTimeT>(value);
  }
  template <typename CreateTimeT = Aws::Utils::DateTime>
  UpdateRoomResult& WithCreateTime(CreateTimeT&& value) {
    SetCreateTime(std::forward<CreateTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Time of the room’s last update. This is an ISO 8601 timestamp; <i>note that
   * this is returned as a string</i>.</p>
   */
  inline const Aws::Utils::DateTime& GetUpdateTime() const { return m_updateTime; }
  template <typename UpdateTimeT = Aws::Utils::DateTime>
  void SetUpdateTime(UpdateTimeT&& value) {
    m_updateTimeHasBeenSet = true;
    m_updateTime = std::forward<UpdateTimeT>(value);
  }
  template <typename UpdateTimeT = Aws::Utils::DateTime>
  UpdateRoomResult& WithUpdateTime(UpdateTimeT&& value) {
    SetUpdateTime(std::forward<UpdateTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Maximum number of messages per second that can be sent to the room (by all
   * clients), from the request (if specified).</p>
   */
  inline int GetMaximumMessageRatePerSecond() const { return m_maximumMessageRatePerSecond; }
  inline void SetMaximumMessageRatePerSecond(int value) {
    m_maximumMessageRatePerSecondHasBeenSet = true;
    m_maximumMessageRatePerSecond = value;
  }
  inline UpdateRoomResult& WithMaximumMessageRatePerSecond(int value) {
    SetMaximumMessageRatePerSecond(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Maximum number of characters in a single message, from the request (if
   * specified).</p>
   */
  inline int GetMaximumMessageLength() const { return m_maximumMessageLength; }
  inline void SetMaximumMessageLength(int value) {
    m_maximumMessageLengthHasBeenSet = true;
    m_maximumMessageLength = value;
  }
  inline UpdateRoomResult& WithMaximumMessageLength(int value) {
    SetMaximumMessageLength(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Configuration information for optional review of messages.</p>
   */
  inline const MessageReviewHandler& GetMessageReviewHandler() const { return m_messageReviewHandler; }
  template <typename MessageReviewHandlerT = MessageReviewHandler>
  void SetMessageReviewHandler(MessageReviewHandlerT&& value) {
    m_messageReviewHandlerHasBeenSet = true;
    m_messageReviewHandler = std::forward<MessageReviewHandlerT>(value);
  }
  template <typename MessageReviewHandlerT = MessageReviewHandler>
  UpdateRoomResult& WithMessageReviewHandler(MessageReviewHandlerT&& value) {
    SetMessageReviewHandler(std::forward<MessageReviewHandlerT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Tags attached to the resource. Array of maps, each of the form
   * <code>string:string (key:value)</code>.</p>
   */
  inline const Aws::Map<Aws::String, Aws::String>& GetTags() const { return m_tags; }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  void SetTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags = std::forward<TagsT>(value);
  }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  UpdateRoomResult& WithTags(TagsT&& value) {
    SetTags(std::forward<TagsT>(value));
    return *this;
  }
  template <typename TagsKeyT = Aws::String, typename TagsValueT = Aws::String>
  UpdateRoomResult& AddTags(TagsKeyT&& key, TagsValueT&& value) {
    m_tagsHasBeenSet = true;
    m_tags.emplace(std::forward<TagsKeyT>(key), std::forward<TagsValueT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Array of logging configurations attached to the room, from the request (if
   * specified).</p>
   */
  inline const Aws::Vector<Aws::String>& GetLoggingConfigurationIdentifiers() const { return m_loggingConfigurationIdentifiers; }
  template <typename LoggingConfigurationIdentifiersT = Aws::Vector<Aws::String>>
  void SetLoggingConfigurationIdentifiers(LoggingConfigurationIdentifiersT&& value) {
    m_loggingConfigurationIdentifiersHasBeenSet = true;
    m_loggingConfigurationIdentifiers = std::forward<LoggingConfigurationIdentifiersT>(value);
  }
  template <typename LoggingConfigurationIdentifiersT = Aws::Vector<Aws::String>>
  UpdateRoomResult& WithLoggingConfigurationIdentifiers(LoggingConfigurationIdentifiersT&& value) {
    SetLoggingConfigurationIdentifiers(std::forward<LoggingConfigurationIdentifiersT>(value));
    return *this;
  }
  template <typename LoggingConfigurationIdentifiersT = Aws::String>
  UpdateRoomResult& AddLoggingConfigurationIdentifiers(LoggingConfigurationIdentifiersT&& value) {
    m_loggingConfigurationIdentifiersHasBeenSet = true;
    m_loggingConfigurationIdentifiers.emplace_back(std::forward<LoggingConfigurationIdentifiersT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  UpdateRoomResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_arn;

  Aws::String m_id;

  Aws::String m_name;

  Aws::Utils::DateTime m_createTime{};

  Aws::Utils::DateTime m_updateTime{};

  int m_maximumMessageRatePerSecond{0};

  int m_maximumMessageLength{0};

  MessageReviewHandler m_messageReviewHandler;

  Aws::Map<Aws::String, Aws::String> m_tags;

  Aws::Vector<Aws::String> m_loggingConfigurationIdentifiers;

  Aws::String m_requestId;
  bool m_arnHasBeenSet = false;
  bool m_idHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_createTimeHasBeenSet = false;
  bool m_updateTimeHasBeenSet = false;
  bool m_maximumMessageRatePerSecondHasBeenSet = false;
  bool m_maximumMessageLengthHasBeenSet = false;
  bool m_messageReviewHandlerHasBeenSet = false;
  bool m_tagsHasBeenSet = false;
  bool m_loggingConfigurationIdentifiersHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ivschat
}  // namespace Aws
