﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/apigateway/APIGatewayRequest.h>
#include <aws/apigateway/APIGateway_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace APIGateway {
namespace Model {

/**
 * <p>Creates a RequestValidator of a given RestApi.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/apigateway-2015-07-09/CreateRequestValidatorRequest">AWS
 * API Reference</a></p>
 */
class CreateRequestValidatorRequest : public APIGatewayRequest {
 public:
  AWS_APIGATEWAY_API CreateRequestValidatorRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "CreateRequestValidator"; }

  AWS_APIGATEWAY_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The string identifier of the associated RestApi.</p>
   */
  inline const Aws::String& GetRestApiId() const { return m_restApiId; }
  inline bool RestApiIdHasBeenSet() const { return m_restApiIdHasBeenSet; }
  template <typename RestApiIdT = Aws::String>
  void SetRestApiId(RestApiIdT&& value) {
    m_restApiIdHasBeenSet = true;
    m_restApiId = std::forward<RestApiIdT>(value);
  }
  template <typename RestApiIdT = Aws::String>
  CreateRequestValidatorRequest& WithRestApiId(RestApiIdT&& value) {
    SetRestApiId(std::forward<RestApiIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the to-be-created RequestValidator.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  CreateRequestValidatorRequest& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A Boolean flag to indicate whether to validate request body according to the
   * configured model schema for the method (<code>true</code>) or not
   * (<code>false</code>).</p>
   */
  inline bool GetValidateRequestBody() const { return m_validateRequestBody; }
  inline bool ValidateRequestBodyHasBeenSet() const { return m_validateRequestBodyHasBeenSet; }
  inline void SetValidateRequestBody(bool value) {
    m_validateRequestBodyHasBeenSet = true;
    m_validateRequestBody = value;
  }
  inline CreateRequestValidatorRequest& WithValidateRequestBody(bool value) {
    SetValidateRequestBody(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A Boolean flag to indicate whether to validate request parameters,
   * <code>true</code>, or not <code>false</code>.</p>
   */
  inline bool GetValidateRequestParameters() const { return m_validateRequestParameters; }
  inline bool ValidateRequestParametersHasBeenSet() const { return m_validateRequestParametersHasBeenSet; }
  inline void SetValidateRequestParameters(bool value) {
    m_validateRequestParametersHasBeenSet = true;
    m_validateRequestParameters = value;
  }
  inline CreateRequestValidatorRequest& WithValidateRequestParameters(bool value) {
    SetValidateRequestParameters(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_restApiId;
  bool m_restApiIdHasBeenSet = false;

  Aws::String m_name;
  bool m_nameHasBeenSet = false;

  bool m_validateRequestBody{false};
  bool m_validateRequestBodyHasBeenSet = false;

  bool m_validateRequestParameters{false};
  bool m_validateRequestParametersHasBeenSet = false;
};

}  // namespace Model
}  // namespace APIGateway
}  // namespace Aws
