#!/usr/bin/python
from __future__ import absolute_import, division, print_function
# Copyright 2019-2024 Fortinet, Inc.
# GNU General Public License v3.0+ (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

__metaclass__ = type

ANSIBLE_METADATA = {'status': ['preview'],
                    'supported_by': 'community',
                    'metadata_version': '1.1'}

DOCUMENTATION = '''
---
module: fmgr_user_oidc
short_description: User oidc
description:
    - This module is able to configure a FortiManager device (FortiProxy).
    - Examples include all parameters and values which need to be adjusted to data sources before usage.
version_added: "2.12.0"
author:
    - Xinwei Du (@dux-fortinet)
    - Xing Li (@lix-fortinet)
    - Jie Xue (@JieX19)
    - Link Zheng (@chillancezen)
    - Frank Shen (@fshen01)
    - Hongbin Lu (@fgtdev-hblu)
notes:
    - Starting in version 2.4.0, all input arguments are named using the underscore naming convention (snake_case).
      Please change the arguments such as "var-name" to "var_name".
      Old argument names are still available yet you will receive deprecation warnings.
      You can ignore this warning by setting deprecation_warnings=False in ansible.cfg.
    - Running in workspace locking mode is supported in this FortiManager module, the top
      level parameters workspace_locking_adom and workspace_locking_timeout help do the work.
    - To create or update an object, use state present directive.
    - To delete an object, use state absent directive.
    - Normally, running one module can fail when a non-zero rc is returned. you can also override
      the conditions to fail or succeed with parameters rc_failed and rc_succeeded
options:
    access_token:
        description: The token to access FortiManager without using username and password.
        type: str
    bypass_validation:
        description: Only set to True when module schema diffs with FortiManager API structure, module continues to execute without validating parameters.
        type: bool
        default: false
    enable_log:
        description: Enable/Disable logging for task.
        type: bool
        default: false
    forticloud_access_token:
        description: Authenticate Ansible client with forticloud API access token.
        type: str
    proposed_method:
        description: The overridden method for the underlying Json RPC request.
        type: str
        choices:
          - update
          - set
          - add
    rc_succeeded:
        description: The rc codes list with which the conditions to succeed will be overriden.
        type: list
        elements: int
    rc_failed:
        description: The rc codes list with which the conditions to fail will be overriden.
        type: list
        elements: int
    state:
        description: The directive to create, update or delete an object.
        type: str
        required: true
        choices:
          - present
          - absent
    revision_note:
        description: The change note that can be specified when an object is created or updated.
        type: str
    workspace_locking_adom:
        description: The adom to lock for FortiManager running in workspace mode, the value can be global and others including root.
        type: str
    workspace_locking_timeout:
        description: The maximum time in seconds to wait for other user to release the workspace lock.
        type: int
        default: 300
    adom:
        description: The parameter (adom) in requested url.
        type: str
        required: true
    user_oidc:
        description: The top level parameters set.
        required: false
        type: dict
        suboptions:
            auth_method:
                aliases: ['auth-method']
                type: str
                description: Auth method.
                choices:
                    - 'client_secret_basic'
                    - 'client_secret_post'
                    - 'private_key_jwt'
            auth_type:
                aliases: ['auth-type']
                type: str
                description: Auth type.
                choices:
                    - 'client-secret'
                    - 'private-key'
            authorization_url:
                aliases: ['authorization-url']
                type: str
                description: Authorization url.
            client_id:
                aliases: ['client-id']
                type: str
                description: Client id.
            client_secret:
                aliases: ['client-secret']
                type: str
                description: Client secret.
            clock_tolerance:
                aliases: ['clock-tolerance']
                type: int
                description: Clock tolerance.
            discovery_url:
                aliases: ['discovery-url']
                type: str
                description: Discovery url.
            display_name:
                aliases: ['display-name']
                type: str
                description: Display name.
            domain_hint:
                aliases: ['domain-hint']
                type: str
                description: Domain hint.
            group_attr_name:
                aliases: ['group-attr-name']
                type: str
                description: Group attr name.
            icon_url:
                aliases: ['icon-url']
                type: str
                description: Icon url.
            issuer:
                type: str
                description: Issuer.
            jwks_uri:
                aliases: ['jwks-uri']
                type: str
                description: Jwks uri.
            ldap_server:
                aliases: ['ldap-server']
                type: list
                elements: str
                description: Ldap server.
            name:
                type: str
                description: Name.
                required: true
            private_key:
                aliases: ['private-key']
                type: list
                elements: str
                description: Private key.
            token_url:
                aliases: ['token-url']
                type: str
                description: Token url.
            type:
                type: str
                description: Type.
                choices:
                    - 'discovery'
                    - 'manual'
            user_attr_name:
                aliases: ['user-attr-name']
                type: str
                description: User attr name.
                choices:
                    - 'email'
                    - 'sub'
                    - 'preferred_username'
            user_regex:
                aliases: ['user-regex']
                type: str
                description: User regex.
            verify_cert:
                aliases: ['verify-cert']
                type: str
                description: Verify cert.
                choices:
                    - 'disable'
                    - 'enable'
            verify_issuer:
                aliases: ['verify-issuer']
                type: str
                description: Verify issuer.
                choices:
                    - 'disable'
                    - 'enable'
'''

EXAMPLES = '''
- name: Example playbook (generated based on argument schema)
  hosts: fortimanagers
  connection: httpapi
  gather_facts: false
  vars:
    ansible_httpapi_use_ssl: true
    ansible_httpapi_validate_certs: false
    ansible_httpapi_port: 443
  tasks:
    - name: User oidc
      fortinet.fortimanager.fmgr_user_oidc:
        # bypass_validation: false
        # workspace_locking_adom: <global or your adom name>
        # workspace_locking_timeout: 300
        # rc_succeeded: [0, -2, -3, ...]
        # rc_failed: [-2, -3, ...]
        adom: <your own value>
        state: present # <value in [present, absent]>
        user_oidc:
          name: "your value" # Required variable, string
          # auth_method: <value in [client_secret_basic, client_secret_post, private_key_jwt]>
          # auth_type: <value in [client-secret, private-key]>
          # authorization_url: <string>
          # client_id: <string>
          # client_secret: <string>
          # clock_tolerance: <integer>
          # discovery_url: <string>
          # display_name: <string>
          # domain_hint: <string>
          # group_attr_name: <string>
          # icon_url: <string>
          # issuer: <string>
          # jwks_uri: <string>
          # ldap_server: <list or string>
          # private_key: <list or string>
          # token_url: <string>
          # type: <value in [discovery, manual]>
          # user_attr_name: <value in [email, sub, preferred_username]>
          # user_regex: <string>
          # verify_cert: <value in [disable, enable]>
          # verify_issuer: <value in [disable, enable]>
'''

RETURN = '''
meta:
    description: The result of the request.
    type: dict
    returned: always
    contains:
        request_url:
            description: The full url requested.
            returned: always
            type: str
            sample: /sys/login/user
        response_code:
            description: The status of api request.
            returned: always
            type: int
            sample: 0
        response_data:
            description: The api response.
            type: list
            returned: always
        response_message:
            description: The descriptive message of the api response.
            type: str
            returned: always
            sample: OK.
        system_information:
            description: The information of the target system.
            type: dict
            returned: always
rc:
    description: The status the request.
    type: int
    returned: always
    sample: 0
version_check_warning:
    description: Warning if the parameters used in the playbook are not supported by the current FortiManager version.
    type: list
    returned: complex
'''
from ansible.module_utils.basic import AnsibleModule
from ansible.module_utils.connection import Connection
from ansible_collections.fortinet.fortimanager.plugins.module_utils.napi import NAPIManager, check_galaxy_version, check_parameter_bypass
from ansible_collections.fortinet.fortimanager.plugins.module_utils.common import get_module_arg_spec


def main():
    urls_list = [
        '/pm/config/adom/{adom}/obj/user/oidc',
        '/pm/config/global/obj/user/oidc'
    ]
    url_params = ['adom']
    module_primary_key = 'name'
    module_arg_spec = {
        'adom': {'required': True, 'type': 'str'},
        'revision_note': {'type': 'str'},
        'user_oidc': {
            'type': 'dict',
            'v_range': [['7.6.4', '']],
            'options': {
                'auth-method': {'v_range': [['7.6.4', '']], 'choices': ['client_secret_basic', 'client_secret_post', 'private_key_jwt'], 'type': 'str'},
                'auth-type': {'v_range': [['7.6.4', '']], 'choices': ['client-secret', 'private-key'], 'type': 'str'},
                'authorization-url': {'v_range': [['7.6.4', '']], 'type': 'str'},
                'client-id': {'v_range': [['7.6.4', '']], 'type': 'str'},
                'client-secret': {'v_range': [['7.6.4', '']], 'no_log': True, 'type': 'str'},
                'clock-tolerance': {'v_range': [['7.6.4', '']], 'type': 'int'},
                'discovery-url': {'v_range': [['7.6.4', '']], 'type': 'str'},
                'display-name': {'v_range': [['7.6.4', '']], 'type': 'str'},
                'domain-hint': {'v_range': [['7.6.4', '']], 'type': 'str'},
                'group-attr-name': {'v_range': [['7.6.4', '']], 'type': 'str'},
                'icon-url': {'v_range': [['7.6.4', '']], 'type': 'str'},
                'issuer': {'v_range': [['7.6.4', '']], 'type': 'str'},
                'jwks-uri': {'v_range': [['7.6.4', '']], 'type': 'str'},
                'ldap-server': {'v_range': [['7.6.4', '']], 'type': 'list', 'elements': 'str'},
                'name': {'v_range': [['7.6.4', '']], 'required': True, 'type': 'str'},
                'private-key': {'v_range': [['7.6.4', '']], 'no_log': True, 'type': 'list', 'elements': 'str'},
                'token-url': {'v_range': [['7.6.4', '']], 'no_log': True, 'type': 'str'},
                'type': {'v_range': [['7.6.4', '']], 'choices': ['discovery', 'manual'], 'type': 'str'},
                'user-attr-name': {'v_range': [['7.6.4', '']], 'choices': ['email', 'sub', 'preferred_username'], 'type': 'str'},
                'user-regex': {'v_range': [['7.6.4', '']], 'type': 'str'},
                'verify-cert': {'v_range': [['7.6.4', '']], 'choices': ['disable', 'enable'], 'type': 'str'},
                'verify-issuer': {'v_range': [['7.6.4', '']], 'choices': ['disable', 'enable'], 'type': 'str'}
            }
        }
    }

    module_option_spec = get_module_arg_spec('full crud')
    module_arg_spec.update(module_option_spec)
    params_validation_blob = []
    check_galaxy_version(module_arg_spec)
    module = AnsibleModule(argument_spec=check_parameter_bypass(module_arg_spec, 'user_oidc'),
                           supports_check_mode=True)

    if not module._socket_path:
        module.fail_json(msg='MUST RUN IN HTTPAPI MODE')
    connection = Connection(module._socket_path)
    fmgr = NAPIManager('full crud', module_arg_spec, urls_list, module_primary_key, url_params,
                       module, connection, top_level_schema_name='data')
    fmgr.validate_parameters(params_validation_blob)
    fmgr.process_crud()

    module.exit_json(meta=module.params)


if __name__ == '__main__':
    main()
