/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, channels, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_channels_cfo_model = R"doc(channel simulator

This block implements a carrier frequency offset model that can be used to simulate carrier frequency drift typically from mixer LO drift on either transmit or receive hardware.


A clipped gaussian random walk process is used.

Constructor Specific Documentation:

Build the carrier frequency offset model.

Args:
    sample_rate_hz : Sample rate of the input signal in Hz
    std_dev_hz : Desired standard deviation of the random walk process every sample in Hz
    max_dev_hz : Maximum carrier frequency deviation in Hz.
    noise_seed : A random number generator seed for the noise source.)doc";


static const char* __doc_gr_channels_cfo_model_cfo_model_0 = R"doc()doc";


static const char* __doc_gr_channels_cfo_model_cfo_model_1 = R"doc()doc";


static const char* __doc_gr_channels_cfo_model_make = R"doc(channel simulator

This block implements a carrier frequency offset model that can be used to simulate carrier frequency drift typically from mixer LO drift on either transmit or receive hardware.


A clipped gaussian random walk process is used.

Constructor Specific Documentation:

Build the carrier frequency offset model.

Args:
    sample_rate_hz : Sample rate of the input signal in Hz
    std_dev_hz : Desired standard deviation of the random walk process every sample in Hz
    max_dev_hz : Maximum carrier frequency deviation in Hz.
    noise_seed : A random number generator seed for the noise source.)doc";


static const char* __doc_gr_channels_cfo_model_set_std_dev = R"doc()doc";


static const char* __doc_gr_channels_cfo_model_set_max_dev = R"doc()doc";


static const char* __doc_gr_channels_cfo_model_set_samp_rate = R"doc()doc";


static const char* __doc_gr_channels_cfo_model_std_dev = R"doc()doc";


static const char* __doc_gr_channels_cfo_model_max_dev = R"doc()doc";


static const char* __doc_gr_channels_cfo_model_samp_rate = R"doc()doc";
