// FilterUI.h
// generated by Fast Light User Interface Designer (fluid) version 1.0404

#ifndef FilterUI_h
#define FilterUI_h
#include <FL/Fl.H>
// Original ZynAddSubFX author Nasca Octavian Paul
// Copyright (C) 2002-2005 Nasca Octavian Paul
// Copyright 2009-2011, Alan Calvert
// Copyright 2016-2025 Will Godfrey

// This file is part of yoshimi, which is free software: you can redistribute
// it and/or modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either version 2 of
// the License, or (at your option) any later version.

// yoshimi is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.   See the GNU General Public License (version 2 or
// later) for more details.

// You should have received a copy of the GNU General Public License along with
// yoshimi; if not, write to the Free Software Foundation, Inc., 51 Franklin
// Street, Fifth Floor, Boston, MA  02110-1301, USA.

// This file is derivative of ZynAddSubFX original code


#include <iostream>
#include "globals.h"
#include "UI/MiscGui.h"
#include "UI/WidgetCheckButton.h"
#include "UI/WidgetPDial.h"
#include "UI/WidgetMWSlider.h"
#include <FL/Fl_Group.H>
#include <FL/Fl_Box.H>
#include <FL/fl_draw.H>
#include <FL/fl_ask.H>
#include "PresetsUI.h"
#include "Params/FilterParams.h"
#include "Misc/SynthEngine.h"
#include "UI/ScaleTrackedWindow.h"
class FilterUI;

class FormantFilterGraph : public Fl_Box {
public:
  FormantFilterGraph(int x, int y, int w, int h, FilterUI& parent_,
            FilterParams *pars_, int *nvowel_, int *nformant_);
  void draw_freq_line(float freq);
  void draw();
  ~FormantFilterGraph();
private:
  FilterUI& parent;
  FilterParams *pars;
  int const *nvowel, *nformant;
  float *graphpoints;
  int selectedFormant, hoverFormant, yRef, xRef, qRef, ampRef, freqRef, cFreqRef;
  bool qMode;
public:
  int handle(int event);
private:
  void delegate(Fl_Valuator* w, int value);
  inline void update_refs();
};
#include <FL/Fl_Group.H>
#include <FL/Fl_Choice.H>
#include <FL/Fl_Counter.H>
#include <FL/Fl_Text_Display.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Box.H>
#include <FL/Fl_Value_Output.H>

class FilterUI : public Fl_Group,PresetsUI_ {
public:
  FilterUI(int x,int y, int w, int h, const char *label=0);
  ~FilterUI();
  Fl_Group* make_window();
  Fl_Group *filterui;
  Fl_Group *filterparamswindow;
  Fl_Choice *analogfiltertypechoice;
private:
  inline void cb_analogfiltertypechoice_i(Fl_Choice*, void*);
  static void cb_analogfiltertypechoice(Fl_Choice*, void*);
public:
  Fl_Choice *svfiltertypechoice;
private:
  inline void cb_svfiltertypechoice_i(Fl_Choice*, void*);
  static void cb_svfiltertypechoice(Fl_Choice*, void*);
public:
  Fl_Choice *filtertype;
private:
  inline void cb_filtertype_i(Fl_Choice*, void*);
  static void cb_filtertype(Fl_Choice*, void*);
public:
  WidgetPDial *cfreqdial;
private:
  inline void cb_cfreqdial_i(WidgetPDial*, void*);
  static void cb_cfreqdial(WidgetPDial*, void*);
public:
  WidgetPDial *qdial;
private:
  inline void cb_qdial_i(WidgetPDial*, void*);
  static void cb_qdial(WidgetPDial*, void*);
public:
  WidgetPDial *freqtrdial;
private:
  inline void cb_freqtrdial_i(WidgetPDial*, void*);
  static void cb_freqtrdial(WidgetPDial*, void*);
public:
  WidgetPDial *vsnsadial;
private:
  inline void cb_vsnsadial_i(WidgetPDial*, void*);
  static void cb_vsnsadial(WidgetPDial*, void*);
public:
  WidgetPDial *vsnsdial;
private:
  inline void cb_vsnsdial_i(WidgetPDial*, void*);
  static void cb_vsnsdial(WidgetPDial*, void*);
public:
  WidgetPDial *gaindial;
private:
  inline void cb_gaindial_i(WidgetPDial*, void*);
  static void cb_gaindial(WidgetPDial*, void*);
public:
  Fl_Counter *stcounter;
private:
  inline void cb_stcounter_i(Fl_Counter*, void*);
  static void cb_stcounter(Fl_Counter*, void*);
public:
  Fl_Text_Display *filterparamslabel;
  Fl_Button *editbutton;
private:
  inline void cb_editbutton_i(Fl_Button*, void*);
  static void cb_editbutton(Fl_Button*, void*);
public:
  Fl_Button *filtC;
private:
  inline void cb_filtC_i(Fl_Button*, void*);
  static void cb_filtC(Fl_Button*, void*);
public:
  Fl_Button *filtP;
private:
  inline void cb_filtP_i(Fl_Button*, void*);
  static void cb_filtP(Fl_Button*, void*);
public:
  Fl_Check_Button2 *freqtrackoffset;
private:
  inline void cb_freqtrackoffset_i(Fl_Check_Button2*, void*);
  static void cb_freqtrackoffset(Fl_Check_Button2*, void*);
public:
  Fl_Text_Display *freqtracknormal;
  Fl_Text_Display *freqtrackchecked;
  ScaleTrackedWindow* make_formant_window();
  ScaleTrackedWindow *formantparswindow;
private:
  inline void cb_formantparswindow_i(ScaleTrackedWindow*, void*);
  static void cb_formantparswindow(ScaleTrackedWindow*, void*);
public:
  Fl_Counter *formantnumber;
private:
  inline void cb_formantnumber_i(Fl_Counter*, void*);
  static void cb_formantnumber(Fl_Counter*, void*);
public:
  Fl_Counter *vowelnumber;
private:
  inline void cb_vowelnumber_i(Fl_Counter*, void*);
  static void cb_vowelnumber(Fl_Counter*, void*);
public:
  Fl_Box *vowelpatch;
  Fl_Group *formantparsgroup;
  WidgetPDial *formant_freq_dial;
private:
  inline void cb_formant_freq_dial_i(WidgetPDial*, void*);
  static void cb_formant_freq_dial(WidgetPDial*, void*);
public:
  WidgetPDial *formant_q_dial;
private:
  inline void cb_formant_q_dial_i(WidgetPDial*, void*);
  static void cb_formant_q_dial(WidgetPDial*, void*);
public:
  WidgetPDial *formant_amp_dial;
private:
  inline void cb_formant_amp_dial_i(WidgetPDial*, void*);
  static void cb_formant_amp_dial(WidgetPDial*, void*);
public:
  Fl_Counter *seqsize;
private:
  inline void cb_seqsize_i(Fl_Counter*, void*);
  static void cb_seqsize(Fl_Counter*, void*);
public:
  Fl_Counter *seqpos;
private:
  inline void cb_seqpos_i(Fl_Counter*, void*);
  static void cb_seqpos(Fl_Counter*, void*);
public:
  Fl_Counter *vowel_counter;
private:
  inline void cb_vowel_counter_i(Fl_Counter*, void*);
  static void cb_vowel_counter(Fl_Counter*, void*);
public:
  Fl_Check_Button2 *neginput;
private:
  inline void cb_neginput_i(Fl_Check_Button2*, void*);
  static void cb_neginput(Fl_Check_Button2*, void*);
public:
  WidgetPDial *strchdial;
private:
  inline void cb_strchdial_i(WidgetPDial*, void*);
  static void cb_strchdial(WidgetPDial*, void*);
public:
  Fl_Counter *formantcount;
private:
  inline void cb_formantcount_i(Fl_Counter*, void*);
  static void cb_formantcount(Fl_Counter*, void*);
public:
  WidgetPDial *frsldial;
private:
  inline void cb_frsldial_i(WidgetPDial*, void*);
  static void cb_frsldial(WidgetPDial*, void*);
public:
  Fl_Value_Output *centerfreqvo;
private:
  inline void cb_centerfreqvo_i(Fl_Value_Output*, void*);
  static void cb_centerfreqvo(Fl_Value_Output*, void*);
public:
  Fl_Value_Output *octavesfreqvo;
private:
  inline void cb_octavesfreqvo_i(Fl_Value_Output*, void*);
  static void cb_octavesfreqvo(Fl_Value_Output*, void*);
public:
  mwheel_slider_rev *cfknob;
private:
  inline void cb_cfknob_i(mwheel_slider_rev*, void*);
  static void cb_cfknob(mwheel_slider_rev*, void*);
public:
  mwheel_slider_rev *octknob;
private:
  inline void cb_octknob_i(mwheel_slider_rev*, void*);
  static void cb_octknob(mwheel_slider_rev*, void*);
public:
  WidgetPDial *wvknob;
private:
  inline void cb_wvknob_i(WidgetPDial*, void*);
  static void cb_wvknob(WidgetPDial*, void*);
public:
  Fl_Button *formClose;
private:
  inline void cb_formClose_i(Fl_Button*, void*);
  static void cb_formClose(Fl_Button*, void*);
public:
  Fl_Button *formCopy;
private:
  inline void cb_formCopy_i(Fl_Button*, void*);
  static void cb_formCopy(Fl_Button*, void*);
public:
  Fl_Button *formPaste;
private:
  inline void cb_formPaste_i(Fl_Button*, void*);
  static void cb_formPaste(Fl_Button*, void*);
public:
  Fl_Box *formvowel;
  void update_formant_window();
  void check_vowel();
  void refresh();
  void filterRtext(float dScale);
  void theme();
  void formantRtext();
  void send_data(int action, int control, float value, int type, int parameter = UNUSED, int offset = UNUSED);
  float fetchData(float value, int control, int part, int kititem = UNUSED, int engine = UNUSED, int insert = UNUSED, int parameter = UNUSED, int offset = UNUSED, int miscmsg = UNUSED, int request = UNUSED);
  void returns_update(CommandBlock *getData);
  float findDynDef(int type);
  float findDynClearDef();
  void init(FilterParams *filterpars_,unsigned char *velsnsamp_,unsigned char *velsns_, int npart_, int kititem_, int engine_);
  void updateVCforQ();
  FormantFilterGraph *formantfiltergraph;
private:
  FilterParams *pars;
  unsigned char *velsnsamp,*velsns;
  int nvowel,nformant,nseqpos, nseqsize, nVoCount, nFoCount;
  SynthEngine *synth;
  int npart;
  int kititem;
  int engine;
  bool dynFilt;
  int dynPreset;
  int formantDW;
  int formantDH;
  int lastformantX;
  int lastformantY;
  int lastformantW;
  bool formantSeen;
  float formFreqDef;
};
#endif
