// java wrapper for vtkImageTransform object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkImageTransform.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkImageTransform_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkImageTransform",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageTransform_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageTransform* op = static_cast<vtkImageTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageTransform_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageTransform* op = static_cast<vtkImageTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageTransform_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageTransform* op = static_cast<vtkImageTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageTransform_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageTransform* op = static_cast<vtkImageTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageTransform_TransformPointSet_14(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkImageData * temp0;
  vtkPointSet * temp1;
  temp0 = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, id1));

  vtkImageTransform* op = static_cast<vtkImageTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->TransformPointSet(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageTransform_TransformPointSet_15(JNIEnv* env, jobject obj,jobject id0,jobject id1,jboolean id2,jboolean id3)
{
  vtkImageData * temp0;
  vtkPointSet * temp1;
  bool   temp2;
  bool   temp3;
  temp0 = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = (id2 != 0) ? true : false;
  temp3 = (id3 != 0) ? true : false;

  vtkImageTransform* op = static_cast<vtkImageTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->TransformPointSet(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageTransform_TranslatePoints_16(JNIEnv* env, jobject obj,jdoubleArray id0,jobject id1)
{
  double temp0[3];
  vtkDataArray * temp1;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkImageTransform* op = static_cast<vtkImageTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->TranslatePoints(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageTransform_TransformPoints_17(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkMatrix4x4 * temp0;
  vtkDataArray * temp1;
  temp0 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkImageTransform* op = static_cast<vtkImageTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->TransformPoints(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageTransform_TransformNormals_18(JNIEnv* env, jobject obj,jobject id0,jdoubleArray id1,jobject id2)
{
  vtkMatrix3x3 * temp0;
  double temp1[3];
  vtkDataArray * temp2;
  temp0 = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, id0));
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  temp2 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id2));

  vtkImageTransform* op = static_cast<vtkImageTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->TransformNormals(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageTransform_TransformVectors_19(JNIEnv* env, jobject obj,jobject id0,jdoubleArray id1,jobject id2)
{
  vtkMatrix3x3 * temp0;
  double temp1[3];
  vtkDataArray * temp2;
  temp0 = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, id0));
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  temp2 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id2));

  vtkImageTransform* op = static_cast<vtkImageTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->TransformVectors(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkImageTransform_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkImageTransform::New());
}
