/** @file
 * VirtualBox API class wrapper code for IUpdateAgent.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_UPDATEAGENT

#include "UpdateAgentWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(UpdateAgentWrap)

//
// IUpdateAgent properties
//

STDMETHODIMP UpdateAgentWrap::COMGETTER(Name)(BSTR *aName)
{
    LogRelFlow(("{%p} %s: enter aName=%p\n", this, "UpdateAgent::getName", aName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aName);
        BSTROutConverter TmpName(aName);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_NAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getName(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_NAME_RETURN(this, hrc, 0 /*normal*/,TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_NAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_NAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aName=%ls hrc=%Rhrc\n", this, "UpdateAgent::getName", *aName, hrc));
    return hrc;
}

STDMETHODIMP UpdateAgentWrap::COMGETTER(EventSource)(IEventSource **aEventSource)
{
    LogRelFlow(("{%p} %s: enter aEventSource=%p\n", this, "UpdateAgent::getEventSource", aEventSource));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEventSource);
        ComTypeOutConverter<IEventSource> TmpEventSource(aEventSource);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_EVENTSOURCE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEventSource(TmpEventSource.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_EVENTSOURCE_RETURN(this, hrc, 0 /*normal*/,(void *)TmpEventSource.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_EVENTSOURCE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_EVENTSOURCE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEventSource=%p hrc=%Rhrc\n", this, "UpdateAgent::getEventSource", *aEventSource, hrc));
    return hrc;
}

STDMETHODIMP UpdateAgentWrap::COMGETTER(Order)(ULONG *aOrder)
{
    LogRelFlow(("{%p} %s: enter aOrder=%p\n", this, "UpdateAgent::getOrder", aOrder));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aOrder);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_ORDER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getOrder(aOrder);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_ORDER_RETURN(this, hrc, 0 /*normal*/,*aOrder);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_ORDER_RETURN(this, hrc, 1 /*hrc exception*/,*aOrder);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_ORDER_RETURN(this, hrc, 9 /*unhandled exception*/,*aOrder);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aOrder=%RU32 hrc=%Rhrc\n", this, "UpdateAgent::getOrder", *aOrder, hrc));
    return hrc;
}

STDMETHODIMP UpdateAgentWrap::COMGETTER(DependsOn)(ComSafeArrayOut(BSTR, aDependsOn))
{
    LogRelFlow(("{%p} %s: enter aDependsOn=%p\n", this, "UpdateAgent::getDependsOn", aDependsOn));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDependsOn);
        ArrayBSTROutConverter TmpDependsOn(ComSafeArrayOutArg(aDependsOn));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_DEPENDSON_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDependsOn(TmpDependsOn.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_DEPENDSON_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpDependsOn.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_DEPENDSON_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_DEPENDSON_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDependsOn=%zu hrc=%Rhrc\n", this, "UpdateAgent::getDependsOn", ComSafeArraySize(*aDependsOn), hrc));
    return hrc;
}

STDMETHODIMP UpdateAgentWrap::COMGETTER(Version)(BSTR *aVersion)
{
    LogRelFlow(("{%p} %s: enter aVersion=%p\n", this, "UpdateAgent::getVersion", aVersion));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aVersion);
        BSTROutConverter TmpVersion(aVersion);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_VERSION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getVersion(TmpVersion.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_VERSION_RETURN(this, hrc, 0 /*normal*/,TmpVersion.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_VERSION_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_VERSION_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aVersion=%ls hrc=%Rhrc\n", this, "UpdateAgent::getVersion", *aVersion, hrc));
    return hrc;
}

STDMETHODIMP UpdateAgentWrap::COMGETTER(DownloadUrl)(BSTR *aDownloadUrl)
{
    LogRelFlow(("{%p} %s: enter aDownloadUrl=%p\n", this, "UpdateAgent::getDownloadUrl", aDownloadUrl));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDownloadUrl);
        BSTROutConverter TmpDownloadUrl(aDownloadUrl);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_DOWNLOADURL_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDownloadUrl(TmpDownloadUrl.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_DOWNLOADURL_RETURN(this, hrc, 0 /*normal*/,TmpDownloadUrl.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_DOWNLOADURL_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_DOWNLOADURL_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDownloadUrl=%ls hrc=%Rhrc\n", this, "UpdateAgent::getDownloadUrl", *aDownloadUrl, hrc));
    return hrc;
}

STDMETHODIMP UpdateAgentWrap::COMGETTER(WebUrl)(BSTR *aWebUrl)
{
    LogRelFlow(("{%p} %s: enter aWebUrl=%p\n", this, "UpdateAgent::getWebUrl", aWebUrl));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aWebUrl);
        BSTROutConverter TmpWebUrl(aWebUrl);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_WEBURL_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getWebUrl(TmpWebUrl.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_WEBURL_RETURN(this, hrc, 0 /*normal*/,TmpWebUrl.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_WEBURL_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_WEBURL_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aWebUrl=%ls hrc=%Rhrc\n", this, "UpdateAgent::getWebUrl", *aWebUrl, hrc));
    return hrc;
}

STDMETHODIMP UpdateAgentWrap::COMGETTER(ReleaseNotes)(BSTR *aReleaseNotes)
{
    LogRelFlow(("{%p} %s: enter aReleaseNotes=%p\n", this, "UpdateAgent::getReleaseNotes", aReleaseNotes));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aReleaseNotes);
        BSTROutConverter TmpReleaseNotes(aReleaseNotes);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_RELEASENOTES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getReleaseNotes(TmpReleaseNotes.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_RELEASENOTES_RETURN(this, hrc, 0 /*normal*/,TmpReleaseNotes.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_RELEASENOTES_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_RELEASENOTES_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aReleaseNotes=%ls hrc=%Rhrc\n", this, "UpdateAgent::getReleaseNotes", *aReleaseNotes, hrc));
    return hrc;
}

STDMETHODIMP UpdateAgentWrap::COMGETTER(Enabled)(BOOL *aEnabled)
{
    LogRelFlow(("{%p} %s: enter aEnabled=%p\n", this, "UpdateAgent::getEnabled", aEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEnabled);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_ENABLED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEnabled(aEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_ENABLED_RETURN(this, hrc, 0 /*normal*/,*aEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_ENABLED_RETURN(this, hrc, 1 /*hrc exception*/,*aEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_ENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,*aEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEnabled=%RTbool hrc=%Rhrc\n", this, "UpdateAgent::getEnabled", *aEnabled, hrc));
    return hrc;
}

STDMETHODIMP UpdateAgentWrap::COMSETTER(Enabled)(BOOL aEnabled)
{
    LogRelFlow(("{%p} %s: enter aEnabled=%RTbool\n", this, "UpdateAgent::setEnabled", aEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_SET_ENABLED_ENTER(this, aEnabled != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setEnabled(aEnabled != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_SET_ENABLED_RETURN(this, hrc, 0 /*normal*/,aEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_SET_ENABLED_RETURN(this, hrc, 1 /*hrc exception*/,aEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_SET_ENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,aEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "UpdateAgent::setEnabled", hrc));
    return hrc;
}

STDMETHODIMP UpdateAgentWrap::COMGETTER(Hidden)(BOOL *aHidden)
{
    LogRelFlow(("{%p} %s: enter aHidden=%p\n", this, "UpdateAgent::getHidden", aHidden));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aHidden);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_HIDDEN_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getHidden(aHidden);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_HIDDEN_RETURN(this, hrc, 0 /*normal*/,*aHidden != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_HIDDEN_RETURN(this, hrc, 1 /*hrc exception*/,*aHidden != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_HIDDEN_RETURN(this, hrc, 9 /*unhandled exception*/,*aHidden != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aHidden=%RTbool hrc=%Rhrc\n", this, "UpdateAgent::getHidden", *aHidden, hrc));
    return hrc;
}

STDMETHODIMP UpdateAgentWrap::COMGETTER(State)(UpdateState_T *aState)
{
    LogRelFlow(("{%p} %s: enter aState=%p\n", this, "UpdateAgent::getState", aState));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aState);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_STATE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getState(aState);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_STATE_RETURN(this, hrc, 0 /*normal*/,*aState);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_STATE_RETURN(this, hrc, 1 /*hrc exception*/,*aState);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_STATE_RETURN(this, hrc, 9 /*unhandled exception*/,*aState);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aState=%RU32 hrc=%Rhrc\n", this, "UpdateAgent::getState", *aState, hrc));
    return hrc;
}

STDMETHODIMP UpdateAgentWrap::COMGETTER(CheckFrequency)(ULONG *aCheckFrequency)
{
    LogRelFlow(("{%p} %s: enter aCheckFrequency=%p\n", this, "UpdateAgent::getCheckFrequency", aCheckFrequency));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aCheckFrequency);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_CHECKFREQUENCY_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getCheckFrequency(aCheckFrequency);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_CHECKFREQUENCY_RETURN(this, hrc, 0 /*normal*/,*aCheckFrequency);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_CHECKFREQUENCY_RETURN(this, hrc, 1 /*hrc exception*/,*aCheckFrequency);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_CHECKFREQUENCY_RETURN(this, hrc, 9 /*unhandled exception*/,*aCheckFrequency);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aCheckFrequency=%RU32 hrc=%Rhrc\n", this, "UpdateAgent::getCheckFrequency", *aCheckFrequency, hrc));
    return hrc;
}

STDMETHODIMP UpdateAgentWrap::COMSETTER(CheckFrequency)(ULONG aCheckFrequency)
{
    LogRelFlow(("{%p} %s: enter aCheckFrequency=%RU32\n", this, "UpdateAgent::setCheckFrequency", aCheckFrequency));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_SET_CHECKFREQUENCY_ENTER(this, aCheckFrequency);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setCheckFrequency(aCheckFrequency);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_SET_CHECKFREQUENCY_RETURN(this, hrc, 0 /*normal*/,aCheckFrequency);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_SET_CHECKFREQUENCY_RETURN(this, hrc, 1 /*hrc exception*/,aCheckFrequency);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_SET_CHECKFREQUENCY_RETURN(this, hrc, 9 /*unhandled exception*/,aCheckFrequency);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "UpdateAgent::setCheckFrequency", hrc));
    return hrc;
}

STDMETHODIMP UpdateAgentWrap::COMGETTER(Channel)(UpdateChannel_T *aChannel)
{
    LogRelFlow(("{%p} %s: enter aChannel=%p\n", this, "UpdateAgent::getChannel", aChannel));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aChannel);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_CHANNEL_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getChannel(aChannel);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_CHANNEL_RETURN(this, hrc, 0 /*normal*/,*aChannel);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_CHANNEL_RETURN(this, hrc, 1 /*hrc exception*/,*aChannel);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_CHANNEL_RETURN(this, hrc, 9 /*unhandled exception*/,*aChannel);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aChannel=%RU32 hrc=%Rhrc\n", this, "UpdateAgent::getChannel", *aChannel, hrc));
    return hrc;
}

STDMETHODIMP UpdateAgentWrap::COMSETTER(Channel)(UpdateChannel_T aChannel)
{
    LogRelFlow(("{%p} %s: enter aChannel=%RU32\n", this, "UpdateAgent::setChannel", aChannel));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_SET_CHANNEL_ENTER(this, aChannel);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setChannel(aChannel);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_SET_CHANNEL_RETURN(this, hrc, 0 /*normal*/,aChannel);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_SET_CHANNEL_RETURN(this, hrc, 1 /*hrc exception*/,aChannel);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_SET_CHANNEL_RETURN(this, hrc, 9 /*unhandled exception*/,aChannel);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "UpdateAgent::setChannel", hrc));
    return hrc;
}

STDMETHODIMP UpdateAgentWrap::COMGETTER(RepositoryURL)(BSTR *aRepositoryURL)
{
    LogRelFlow(("{%p} %s: enter aRepositoryURL=%p\n", this, "UpdateAgent::getRepositoryURL", aRepositoryURL));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRepositoryURL);
        BSTROutConverter TmpRepositoryURL(aRepositoryURL);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_REPOSITORYURL_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getRepositoryURL(TmpRepositoryURL.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_REPOSITORYURL_RETURN(this, hrc, 0 /*normal*/,TmpRepositoryURL.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_REPOSITORYURL_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_REPOSITORYURL_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aRepositoryURL=%ls hrc=%Rhrc\n", this, "UpdateAgent::getRepositoryURL", *aRepositoryURL, hrc));
    return hrc;
}

STDMETHODIMP UpdateAgentWrap::COMSETTER(RepositoryURL)(IN_BSTR aRepositoryURL)
{
    LogRelFlow(("{%p} %s: enter aRepositoryURL=%ls\n", this, "UpdateAgent::setRepositoryURL", aRepositoryURL));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpRepositoryURL(aRepositoryURL);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_SET_REPOSITORYURL_ENTER(this, TmpRepositoryURL.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setRepositoryURL(TmpRepositoryURL.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_SET_REPOSITORYURL_RETURN(this, hrc, 0 /*normal*/,TmpRepositoryURL.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_SET_REPOSITORYURL_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_SET_REPOSITORYURL_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "UpdateAgent::setRepositoryURL", hrc));
    return hrc;
}

STDMETHODIMP UpdateAgentWrap::COMGETTER(LastCheckDate)(BSTR *aLastCheckDate)
{
    LogRelFlow(("{%p} %s: enter aLastCheckDate=%p\n", this, "UpdateAgent::getLastCheckDate", aLastCheckDate));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLastCheckDate);
        BSTROutConverter TmpLastCheckDate(aLastCheckDate);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_LASTCHECKDATE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getLastCheckDate(TmpLastCheckDate.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_LASTCHECKDATE_RETURN(this, hrc, 0 /*normal*/,TmpLastCheckDate.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_LASTCHECKDATE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_LASTCHECKDATE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aLastCheckDate=%ls hrc=%Rhrc\n", this, "UpdateAgent::getLastCheckDate", *aLastCheckDate, hrc));
    return hrc;
}

STDMETHODIMP UpdateAgentWrap::COMGETTER(CheckCount)(ULONG *aCheckCount)
{
    LogRelFlow(("{%p} %s: enter aCheckCount=%p\n", this, "UpdateAgent::getCheckCount", aCheckCount));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aCheckCount);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_CHECKCOUNT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getCheckCount(aCheckCount);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_CHECKCOUNT_RETURN(this, hrc, 0 /*normal*/,*aCheckCount);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_CHECKCOUNT_RETURN(this, hrc, 1 /*hrc exception*/,*aCheckCount);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_CHECKCOUNT_RETURN(this, hrc, 9 /*unhandled exception*/,*aCheckCount);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aCheckCount=%RU32 hrc=%Rhrc\n", this, "UpdateAgent::getCheckCount", *aCheckCount, hrc));
    return hrc;
}

STDMETHODIMP UpdateAgentWrap::COMGETTER(IsCheckNeeded)(BOOL *aIsCheckNeeded)
{
    LogRelFlow(("{%p} %s: enter aIsCheckNeeded=%p\n", this, "UpdateAgent::getIsCheckNeeded", aIsCheckNeeded));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aIsCheckNeeded);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_ISCHECKNEEDED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getIsCheckNeeded(aIsCheckNeeded);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_ISCHECKNEEDED_RETURN(this, hrc, 0 /*normal*/,*aIsCheckNeeded != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_ISCHECKNEEDED_RETURN(this, hrc, 1 /*hrc exception*/,*aIsCheckNeeded != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_ISCHECKNEEDED_RETURN(this, hrc, 9 /*unhandled exception*/,*aIsCheckNeeded != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aIsCheckNeeded=%RTbool hrc=%Rhrc\n", this, "UpdateAgent::getIsCheckNeeded", *aIsCheckNeeded, hrc));
    return hrc;
}

STDMETHODIMP UpdateAgentWrap::COMGETTER(SupportedChannels)(ComSafeArrayOut(UpdateChannel_T, aSupportedChannels))
{
    LogRelFlow(("{%p} %s: enter aSupportedChannels=%p\n", this, "UpdateAgent::getSupportedChannels", aSupportedChannels));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSupportedChannels);
        ArrayOutConverter<UpdateChannel_T> TmpSupportedChannels(ComSafeArrayOutArg(aSupportedChannels));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_SUPPORTEDCHANNELS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSupportedChannels(TmpSupportedChannels.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_SUPPORTEDCHANNELS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSupportedChannels.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_SUPPORTEDCHANNELS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_GET_SUPPORTEDCHANNELS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSupportedChannels=%zu hrc=%Rhrc\n", this, "UpdateAgent::getSupportedChannels", ComSafeArraySize(*aSupportedChannels), hrc));
    return hrc;
}

STDMETHODIMP UpdateAgentWrap::COMGETTER(InternalAndReservedAttribute1IUpdateAgent)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP UpdateAgentWrap::COMGETTER(InternalAndReservedAttribute2IUpdateAgent)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP UpdateAgentWrap::COMGETTER(InternalAndReservedAttribute3IUpdateAgent)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP UpdateAgentWrap::COMGETTER(InternalAndReservedAttribute4IUpdateAgent)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IUpdateAgent methods
//

STDMETHODIMP UpdateAgentWrap::CheckFor(IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aProgress=%p\n", this, "UpdateAgent::checkFor", aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_CHECKFOR_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = checkFor(TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_CHECKFOR_RETURN(this, hrc, 0 /*normal*/, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_CHECKFOR_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_CHECKFOR_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "UpdateAgent::checkFor", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP UpdateAgentWrap::Download(IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aProgress=%p\n", this, "UpdateAgent::download", aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_DOWNLOAD_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = download(TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_DOWNLOAD_RETURN(this, hrc, 0 /*normal*/, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_DOWNLOAD_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_DOWNLOAD_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "UpdateAgent::download", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP UpdateAgentWrap::Install(IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aProgress=%p\n", this, "UpdateAgent::install", aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_INSTALL_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = install(TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_INSTALL_RETURN(this, hrc, 0 /*normal*/, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_INSTALL_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_INSTALL_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "UpdateAgent::install", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP UpdateAgentWrap::Rollback()
{
    LogRelFlow(("{%p} %s: enter\n", this, "UpdateAgent::rollback"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_ROLLBACK_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = rollback();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_ROLLBACK_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_ROLLBACK_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UPDATEAGENT_ROLLBACK_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "UpdateAgent::rollback", hrc));
    return hrc;
}

STDMETHODIMP UpdateAgentWrap::InternalAndReservedMethod1IUpdateAgent()
{
    return E_NOTIMPL;
}

STDMETHODIMP UpdateAgentWrap::InternalAndReservedMethod2IUpdateAgent()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(UpdateAgentWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(UpdateAgentWrap, IUpdateAgent)
#endif // VBOX_WITH_XPCOM
