/** @file
 * VirtualBox API class wrapper code for IMediumAttachment.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_MEDIUMATTACHMENT

#include "MediumAttachmentWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(MediumAttachmentWrap)

//
// IMediumAttachment properties
//

STDMETHODIMP MediumAttachmentWrap::COMGETTER(Machine)(IMachine **aMachine)
{
    LogRelFlow(("{%p} %s: enter aMachine=%p\n", this, "MediumAttachment::getMachine", aMachine));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMachine);
        ComTypeOutConverter<IMachine> TmpMachine(aMachine);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_MACHINE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMachine(TmpMachine.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_MACHINE_RETURN(this, hrc, 0 /*normal*/,(void *)TmpMachine.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_MACHINE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_MACHINE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMachine=%p hrc=%Rhrc\n", this, "MediumAttachment::getMachine", *aMachine, hrc));
    return hrc;
}

STDMETHODIMP MediumAttachmentWrap::COMGETTER(Medium)(IMedium **aMedium)
{
    LogRelFlow(("{%p} %s: enter aMedium=%p\n", this, "MediumAttachment::getMedium", aMedium));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMedium);
        ComTypeOutConverter<IMedium> TmpMedium(aMedium);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_MEDIUM_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMedium(TmpMedium.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_MEDIUM_RETURN(this, hrc, 0 /*normal*/,(void *)TmpMedium.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_MEDIUM_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_MEDIUM_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMedium=%p hrc=%Rhrc\n", this, "MediumAttachment::getMedium", *aMedium, hrc));
    return hrc;
}

STDMETHODIMP MediumAttachmentWrap::COMGETTER(Controller)(BSTR *aController)
{
    LogRelFlow(("{%p} %s: enter aController=%p\n", this, "MediumAttachment::getController", aController));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aController);
        BSTROutConverter TmpController(aController);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_CONTROLLER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getController(TmpController.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_CONTROLLER_RETURN(this, hrc, 0 /*normal*/,TmpController.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_CONTROLLER_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_CONTROLLER_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aController=%ls hrc=%Rhrc\n", this, "MediumAttachment::getController", *aController, hrc));
    return hrc;
}

STDMETHODIMP MediumAttachmentWrap::COMGETTER(Port)(LONG *aPort)
{
    LogRelFlow(("{%p} %s: enter aPort=%p\n", this, "MediumAttachment::getPort", aPort));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPort);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_PORT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPort(aPort);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_PORT_RETURN(this, hrc, 0 /*normal*/,*aPort);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_PORT_RETURN(this, hrc, 1 /*hrc exception*/,*aPort);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_PORT_RETURN(this, hrc, 9 /*unhandled exception*/,*aPort);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPort=%RI32 hrc=%Rhrc\n", this, "MediumAttachment::getPort", *aPort, hrc));
    return hrc;
}

STDMETHODIMP MediumAttachmentWrap::COMGETTER(Device)(LONG *aDevice)
{
    LogRelFlow(("{%p} %s: enter aDevice=%p\n", this, "MediumAttachment::getDevice", aDevice));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDevice);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_DEVICE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDevice(aDevice);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_DEVICE_RETURN(this, hrc, 0 /*normal*/,*aDevice);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_DEVICE_RETURN(this, hrc, 1 /*hrc exception*/,*aDevice);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_DEVICE_RETURN(this, hrc, 9 /*unhandled exception*/,*aDevice);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDevice=%RI32 hrc=%Rhrc\n", this, "MediumAttachment::getDevice", *aDevice, hrc));
    return hrc;
}

STDMETHODIMP MediumAttachmentWrap::COMGETTER(Type)(DeviceType_T *aType)
{
    LogRelFlow(("{%p} %s: enter aType=%p\n", this, "MediumAttachment::getType", aType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aType);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_TYPE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getType(aType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_TYPE_RETURN(this, hrc, 0 /*normal*/,*aType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_TYPE_RETURN(this, hrc, 1 /*hrc exception*/,*aType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_TYPE_RETURN(this, hrc, 9 /*unhandled exception*/,*aType);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aType=%RU32 hrc=%Rhrc\n", this, "MediumAttachment::getType", *aType, hrc));
    return hrc;
}

STDMETHODIMP MediumAttachmentWrap::COMGETTER(Passthrough)(BOOL *aPassthrough)
{
    LogRelFlow(("{%p} %s: enter aPassthrough=%p\n", this, "MediumAttachment::getPassthrough", aPassthrough));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPassthrough);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_PASSTHROUGH_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPassthrough(aPassthrough);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_PASSTHROUGH_RETURN(this, hrc, 0 /*normal*/,*aPassthrough != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_PASSTHROUGH_RETURN(this, hrc, 1 /*hrc exception*/,*aPassthrough != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_PASSTHROUGH_RETURN(this, hrc, 9 /*unhandled exception*/,*aPassthrough != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPassthrough=%RTbool hrc=%Rhrc\n", this, "MediumAttachment::getPassthrough", *aPassthrough, hrc));
    return hrc;
}

STDMETHODIMP MediumAttachmentWrap::COMGETTER(TemporaryEject)(BOOL *aTemporaryEject)
{
    LogRelFlow(("{%p} %s: enter aTemporaryEject=%p\n", this, "MediumAttachment::getTemporaryEject", aTemporaryEject));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aTemporaryEject);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_TEMPORARYEJECT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getTemporaryEject(aTemporaryEject);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_TEMPORARYEJECT_RETURN(this, hrc, 0 /*normal*/,*aTemporaryEject != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_TEMPORARYEJECT_RETURN(this, hrc, 1 /*hrc exception*/,*aTemporaryEject != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_TEMPORARYEJECT_RETURN(this, hrc, 9 /*unhandled exception*/,*aTemporaryEject != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aTemporaryEject=%RTbool hrc=%Rhrc\n", this, "MediumAttachment::getTemporaryEject", *aTemporaryEject, hrc));
    return hrc;
}

STDMETHODIMP MediumAttachmentWrap::COMGETTER(IsEjected)(BOOL *aIsEjected)
{
    LogRelFlow(("{%p} %s: enter aIsEjected=%p\n", this, "MediumAttachment::getIsEjected", aIsEjected));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aIsEjected);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_ISEJECTED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getIsEjected(aIsEjected);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_ISEJECTED_RETURN(this, hrc, 0 /*normal*/,*aIsEjected != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_ISEJECTED_RETURN(this, hrc, 1 /*hrc exception*/,*aIsEjected != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_ISEJECTED_RETURN(this, hrc, 9 /*unhandled exception*/,*aIsEjected != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aIsEjected=%RTbool hrc=%Rhrc\n", this, "MediumAttachment::getIsEjected", *aIsEjected, hrc));
    return hrc;
}

STDMETHODIMP MediumAttachmentWrap::COMGETTER(NonRotational)(BOOL *aNonRotational)
{
    LogRelFlow(("{%p} %s: enter aNonRotational=%p\n", this, "MediumAttachment::getNonRotational", aNonRotational));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aNonRotational);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_NONROTATIONAL_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getNonRotational(aNonRotational);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_NONROTATIONAL_RETURN(this, hrc, 0 /*normal*/,*aNonRotational != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_NONROTATIONAL_RETURN(this, hrc, 1 /*hrc exception*/,*aNonRotational != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_NONROTATIONAL_RETURN(this, hrc, 9 /*unhandled exception*/,*aNonRotational != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aNonRotational=%RTbool hrc=%Rhrc\n", this, "MediumAttachment::getNonRotational", *aNonRotational, hrc));
    return hrc;
}

STDMETHODIMP MediumAttachmentWrap::COMGETTER(Discard)(BOOL *aDiscard)
{
    LogRelFlow(("{%p} %s: enter aDiscard=%p\n", this, "MediumAttachment::getDiscard", aDiscard));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDiscard);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_DISCARD_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDiscard(aDiscard);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_DISCARD_RETURN(this, hrc, 0 /*normal*/,*aDiscard != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_DISCARD_RETURN(this, hrc, 1 /*hrc exception*/,*aDiscard != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_DISCARD_RETURN(this, hrc, 9 /*unhandled exception*/,*aDiscard != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDiscard=%RTbool hrc=%Rhrc\n", this, "MediumAttachment::getDiscard", *aDiscard, hrc));
    return hrc;
}

STDMETHODIMP MediumAttachmentWrap::COMGETTER(HotPluggable)(BOOL *aHotPluggable)
{
    LogRelFlow(("{%p} %s: enter aHotPluggable=%p\n", this, "MediumAttachment::getHotPluggable", aHotPluggable));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aHotPluggable);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_HOTPLUGGABLE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getHotPluggable(aHotPluggable);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_HOTPLUGGABLE_RETURN(this, hrc, 0 /*normal*/,*aHotPluggable != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_HOTPLUGGABLE_RETURN(this, hrc, 1 /*hrc exception*/,*aHotPluggable != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_HOTPLUGGABLE_RETURN(this, hrc, 9 /*unhandled exception*/,*aHotPluggable != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aHotPluggable=%RTbool hrc=%Rhrc\n", this, "MediumAttachment::getHotPluggable", *aHotPluggable, hrc));
    return hrc;
}

STDMETHODIMP MediumAttachmentWrap::COMGETTER(BandwidthGroup)(IBandwidthGroup **aBandwidthGroup)
{
    LogRelFlow(("{%p} %s: enter aBandwidthGroup=%p\n", this, "MediumAttachment::getBandwidthGroup", aBandwidthGroup));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aBandwidthGroup);
        ComTypeOutConverter<IBandwidthGroup> TmpBandwidthGroup(aBandwidthGroup);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_BANDWIDTHGROUP_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getBandwidthGroup(TmpBandwidthGroup.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_BANDWIDTHGROUP_RETURN(this, hrc, 0 /*normal*/,(void *)TmpBandwidthGroup.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_BANDWIDTHGROUP_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMATTACHMENT_GET_BANDWIDTHGROUP_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aBandwidthGroup=%p hrc=%Rhrc\n", this, "MediumAttachment::getBandwidthGroup", *aBandwidthGroup, hrc));
    return hrc;
}

STDMETHODIMP MediumAttachmentWrap::COMGETTER(InternalAndReservedAttribute1IMediumAttachment)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MediumAttachmentWrap::COMGETTER(InternalAndReservedAttribute2IMediumAttachment)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MediumAttachmentWrap::COMGETTER(InternalAndReservedAttribute3IMediumAttachment)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MediumAttachmentWrap::COMGETTER(InternalAndReservedAttribute4IMediumAttachment)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MediumAttachmentWrap::COMGETTER(InternalAndReservedAttribute5IMediumAttachment)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MediumAttachmentWrap::COMGETTER(InternalAndReservedAttribute6IMediumAttachment)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MediumAttachmentWrap::COMGETTER(InternalAndReservedAttribute7IMediumAttachment)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MediumAttachmentWrap::COMGETTER(InternalAndReservedAttribute8IMediumAttachment)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IMediumAttachment methods
//

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(MediumAttachmentWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(MediumAttachmentWrap, IMediumAttachment)
#endif // VBOX_WITH_XPCOM
