/** @file
 * VirtualBox API class wrapper code for IDisplaySourceBitmap.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_DISPLAYSOURCEBITMAP

#include "DisplaySourceBitmapWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(DisplaySourceBitmapWrap)

//
// IDisplaySourceBitmap properties
//

STDMETHODIMP DisplaySourceBitmapWrap::COMGETTER(ScreenId)(ULONG *aScreenId)
{
    LogRelFlow(("{%p} %s: enter aScreenId=%p\n", this, "DisplaySourceBitmap::getScreenId", aScreenId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aScreenId);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAYSOURCEBITMAP_GET_SCREENID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getScreenId(aScreenId);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAYSOURCEBITMAP_GET_SCREENID_RETURN(this, hrc, 0 /*normal*/,*aScreenId);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAYSOURCEBITMAP_GET_SCREENID_RETURN(this, hrc, 1 /*hrc exception*/,*aScreenId);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAYSOURCEBITMAP_GET_SCREENID_RETURN(this, hrc, 9 /*unhandled exception*/,*aScreenId);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aScreenId=%RU32 hrc=%Rhrc\n", this, "DisplaySourceBitmap::getScreenId", *aScreenId, hrc));
    return hrc;
}


//
// IDisplaySourceBitmap methods
//

STDMETHODIMP DisplaySourceBitmapWrap::QueryBitmapInfo(BYTE **aAddress,
                                                      ULONG *aWidth,
                                                      ULONG *aHeight,
                                                      ULONG *aBitsPerPixel,
                                                      ULONG *aBytesPerLine,
                                                      BitmapFormat_T *aBitmapFormat)
{
    LogRelFlow(("{%p} %s: enter aAddress=%p aWidth=%p aHeight=%p aBitsPerPixel=%p aBytesPerLine=%p aBitmapFormat=%p\n", this, "DisplaySourceBitmap::queryBitmapInfo", aAddress, aWidth, aHeight, aBitsPerPixel, aBytesPerLine, aBitmapFormat));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAddress);
        CheckComArgOutPointerValidThrow(aWidth);
        CheckComArgOutPointerValidThrow(aHeight);
        CheckComArgOutPointerValidThrow(aBitsPerPixel);
        CheckComArgOutPointerValidThrow(aBytesPerLine);
        CheckComArgOutPointerValidThrow(aBitmapFormat);


        
        
        
        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAYSOURCEBITMAP_QUERYBITMAPINFO_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = queryBitmapInfo(aAddress,
                                  aWidth,
                                  aHeight,
                                  aBitsPerPixel,
                                  aBytesPerLine,
                                  aBitmapFormat);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAYSOURCEBITMAP_QUERYBITMAPINFO_RETURN(this, hrc, 0 /*normal*/, *aAddress, *aWidth, *aHeight, *aBitsPerPixel, *aBytesPerLine, *aBitmapFormat);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAYSOURCEBITMAP_QUERYBITMAPINFO_RETURN(this, hrc, 1 /*hrc exception*/, *aAddress, *aWidth, *aHeight, *aBitsPerPixel, *aBytesPerLine, *aBitmapFormat);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAYSOURCEBITMAP_QUERYBITMAPINFO_RETURN(this, hrc, 9 /*unhandled exception*/, *aAddress, *aWidth, *aHeight, *aBitsPerPixel, *aBytesPerLine, *aBitmapFormat);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAddress=%p *aWidth=%RU32 *aHeight=%RU32 *aBitsPerPixel=%RU32 *aBytesPerLine=%RU32 *aBitmapFormat=%RU32 hrc=%Rhrc\n", this, "DisplaySourceBitmap::queryBitmapInfo", *aAddress, *aWidth, *aHeight, *aBitsPerPixel, *aBytesPerLine, *aBitmapFormat, hrc));
    return hrc;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(DisplaySourceBitmapWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(DisplaySourceBitmapWrap, IDisplaySourceBitmap)
#endif // VBOX_WITH_XPCOM
