/** @file
 * VirtualBox API class wrapper code for IAppliance.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_APPLIANCE

#include "ApplianceWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(ApplianceWrap)

//
// IAppliance properties
//

STDMETHODIMP ApplianceWrap::COMGETTER(Path)(BSTR *aPath)
{
    LogRelFlow(("{%p} %s: enter aPath=%p\n", this, "Appliance::getPath", aPath));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPath);
        BSTROutConverter TmpPath(aPath);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_GET_PATH_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPath(TmpPath.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_GET_PATH_RETURN(this, hrc, 0 /*normal*/,TmpPath.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_GET_PATH_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_GET_PATH_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPath=%ls hrc=%Rhrc\n", this, "Appliance::getPath", *aPath, hrc));
    return hrc;
}

STDMETHODIMP ApplianceWrap::COMGETTER(Disks)(ComSafeArrayOut(BSTR, aDisks))
{
    LogRelFlow(("{%p} %s: enter aDisks=%p\n", this, "Appliance::getDisks", aDisks));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDisks);
        ArrayBSTROutConverter TmpDisks(ComSafeArrayOutArg(aDisks));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_GET_DISKS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDisks(TmpDisks.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_GET_DISKS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpDisks.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_GET_DISKS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_GET_DISKS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDisks=%zu hrc=%Rhrc\n", this, "Appliance::getDisks", ComSafeArraySize(*aDisks), hrc));
    return hrc;
}

STDMETHODIMP ApplianceWrap::COMGETTER(VirtualSystemDescriptions)(ComSafeArrayOut(IVirtualSystemDescription *, aVirtualSystemDescriptions))
{
    LogRelFlow(("{%p} %s: enter aVirtualSystemDescriptions=%p\n", this, "Appliance::getVirtualSystemDescriptions", aVirtualSystemDescriptions));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aVirtualSystemDescriptions);
        ArrayComTypeOutConverter<IVirtualSystemDescription> TmpVirtualSystemDescriptions(ComSafeArrayOutArg(aVirtualSystemDescriptions));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_GET_VIRTUALSYSTEMDESCRIPTIONS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getVirtualSystemDescriptions(TmpVirtualSystemDescriptions.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_GET_VIRTUALSYSTEMDESCRIPTIONS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpVirtualSystemDescriptions.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_GET_VIRTUALSYSTEMDESCRIPTIONS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_GET_VIRTUALSYSTEMDESCRIPTIONS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aVirtualSystemDescriptions=%zu hrc=%Rhrc\n", this, "Appliance::getVirtualSystemDescriptions", ComSafeArraySize(*aVirtualSystemDescriptions), hrc));
    return hrc;
}

STDMETHODIMP ApplianceWrap::COMGETTER(Machines)(ComSafeArrayOut(BSTR, aMachines))
{
    LogRelFlow(("{%p} %s: enter aMachines=%p\n", this, "Appliance::getMachines", aMachines));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMachines);
        ArrayBSTROutConverter TmpMachines(ComSafeArrayOutArg(aMachines));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_GET_MACHINES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMachines(TmpMachines.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_GET_MACHINES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpMachines.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_GET_MACHINES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_GET_MACHINES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMachines=%zu hrc=%Rhrc\n", this, "Appliance::getMachines", ComSafeArraySize(*aMachines), hrc));
    return hrc;
}

STDMETHODIMP ApplianceWrap::COMGETTER(Certificate)(ICertificate **aCertificate)
{
    LogRelFlow(("{%p} %s: enter aCertificate=%p\n", this, "Appliance::getCertificate", aCertificate));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aCertificate);
        ComTypeOutConverter<ICertificate> TmpCertificate(aCertificate);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_GET_CERTIFICATE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getCertificate(TmpCertificate.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_GET_CERTIFICATE_RETURN(this, hrc, 0 /*normal*/,(void *)TmpCertificate.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_GET_CERTIFICATE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_GET_CERTIFICATE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aCertificate=%p hrc=%Rhrc\n", this, "Appliance::getCertificate", *aCertificate, hrc));
    return hrc;
}

STDMETHODIMP ApplianceWrap::COMGETTER(InternalAndReservedAttribute1IAppliance)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ApplianceWrap::COMGETTER(InternalAndReservedAttribute2IAppliance)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ApplianceWrap::COMGETTER(InternalAndReservedAttribute3IAppliance)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ApplianceWrap::COMGETTER(InternalAndReservedAttribute4IAppliance)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ApplianceWrap::COMGETTER(InternalAndReservedAttribute5IAppliance)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ApplianceWrap::COMGETTER(InternalAndReservedAttribute6IAppliance)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ApplianceWrap::COMGETTER(InternalAndReservedAttribute7IAppliance)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ApplianceWrap::COMGETTER(InternalAndReservedAttribute8IAppliance)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IAppliance methods
//

STDMETHODIMP ApplianceWrap::Read(IN_BSTR aFile,
                                 IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aFile=%ls aProgress=%p\n", this, "Appliance::read", aFile, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        BSTRInConverter TmpFile(aFile);
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_READ_ENTER(this, TmpFile.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = read(TmpFile.str(),
                       TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_READ_RETURN(this, hrc, 0 /*normal*/, TmpFile.str().c_str(), (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_READ_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_READ_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "Appliance::read", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP ApplianceWrap::Interpret()
{
    LogRelFlow(("{%p} %s: enter\n", this, "Appliance::interpret"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_INTERPRET_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = interpret();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_INTERPRET_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_INTERPRET_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_INTERPRET_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Appliance::interpret", hrc));
    return hrc;
}

STDMETHODIMP ApplianceWrap::ImportMachines(ComSafeArrayIn(ImportOptions_T, aOptions),
                                           IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aOptions=%zu aProgress=%p\n", this, "Appliance::importMachines", aOptions, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        ArrayInConverter<ImportOptions_T> TmpOptions(ComSafeArrayInArg(aOptions));
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_IMPORTMACHINES_ENTER(this, (uint32_t)TmpOptions.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = importMachines(TmpOptions.array(),
                                 TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_IMPORTMACHINES_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpOptions.array().size(), NULL /*for now*/, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_IMPORTMACHINES_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_IMPORTMACHINES_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "Appliance::importMachines", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP ApplianceWrap::CreateVFSExplorer(IN_BSTR aURI,
                                              IVFSExplorer **aExplorer)
{
    LogRelFlow(("{%p} %s: enter aURI=%ls aExplorer=%p\n", this, "Appliance::createVFSExplorer", aURI, aExplorer));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aExplorer);


        BSTRInConverter TmpURI(aURI);
        ComTypeOutConverter<IVFSExplorer> TmpExplorer(aExplorer);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_CREATEVFSEXPLORER_ENTER(this, TmpURI.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = createVFSExplorer(TmpURI.str(),
                                    TmpExplorer.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_CREATEVFSEXPLORER_RETURN(this, hrc, 0 /*normal*/, TmpURI.str().c_str(), (void *)TmpExplorer.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_CREATEVFSEXPLORER_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_CREATEVFSEXPLORER_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aExplorer=%p hrc=%Rhrc\n", this, "Appliance::createVFSExplorer", *aExplorer, hrc));
    return hrc;
}

STDMETHODIMP ApplianceWrap::Write(IN_BSTR aFormat,
                                  ComSafeArrayIn(ExportOptions_T, aOptions),
                                  IN_BSTR aPath,
                                  IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aFormat=%ls aOptions=%zu aPath=%ls aProgress=%p\n", this, "Appliance::write", aFormat, aOptions, aPath, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        BSTRInConverter TmpFormat(aFormat);
        ArrayInConverter<ExportOptions_T> TmpOptions(ComSafeArrayInArg(aOptions));
        BSTRInConverter TmpPath(aPath);
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_WRITE_ENTER(this, TmpFormat.str().c_str(), (uint32_t)TmpOptions.array().size(), NULL /*for now*/, TmpPath.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = write(TmpFormat.str(),
                        TmpOptions.array(),
                        TmpPath.str(),
                        TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_WRITE_RETURN(this, hrc, 0 /*normal*/, TmpFormat.str().c_str(), (uint32_t)TmpOptions.array().size(), NULL /*for now*/, TmpPath.str().c_str(), (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_WRITE_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_WRITE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "Appliance::write", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP ApplianceWrap::GetWarnings(ComSafeArrayOut(BSTR, aWarnings))
{
    LogRelFlow(("{%p} %s: enter aWarnings=%p\n", this, "Appliance::getWarnings", aWarnings));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aWarnings);


        ArrayBSTROutConverter TmpWarnings(ComSafeArrayOutArg(aWarnings));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_GETWARNINGS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getWarnings(TmpWarnings.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_GETWARNINGS_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpWarnings.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_GETWARNINGS_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_GETWARNINGS_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aWarnings=%zu hrc=%Rhrc\n", this, "Appliance::getWarnings", ComSafeArraySize(*aWarnings), hrc));
    return hrc;
}

STDMETHODIMP ApplianceWrap::GetPasswordIds(ComSafeArrayOut(BSTR, aIdentifiers))
{
    LogRelFlow(("{%p} %s: enter aIdentifiers=%p\n", this, "Appliance::getPasswordIds", aIdentifiers));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aIdentifiers);


        ArrayBSTROutConverter TmpIdentifiers(ComSafeArrayOutArg(aIdentifiers));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_GETPASSWORDIDS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPasswordIds(TmpIdentifiers.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_GETPASSWORDIDS_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpIdentifiers.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_GETPASSWORDIDS_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_GETPASSWORDIDS_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aIdentifiers=%zu hrc=%Rhrc\n", this, "Appliance::getPasswordIds", ComSafeArraySize(*aIdentifiers), hrc));
    return hrc;
}

STDMETHODIMP ApplianceWrap::GetMediumIdsForPasswordId(IN_BSTR aPasswordId,
                                                      ComSafeArrayOut(BSTR, aIdentifiers))
{
    LogRelFlow(("{%p} %s: enter aPasswordId=%ls aIdentifiers=%p\n", this, "Appliance::getMediumIdsForPasswordId", aPasswordId, aIdentifiers));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aIdentifiers);


        BSTRInConverter TmpPasswordId(aPasswordId);
        ArrayUuidOutConverter TmpIdentifiers(ComSafeArrayOutArg(aIdentifiers));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_GETMEDIUMIDSFORPASSWORDID_ENTER(this, TmpPasswordId.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMediumIdsForPasswordId(TmpPasswordId.str(),
                                            TmpIdentifiers.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_GETMEDIUMIDSFORPASSWORDID_RETURN(this, hrc, 0 /*normal*/, TmpPasswordId.str().c_str(), (uint32_t)TmpIdentifiers.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_GETMEDIUMIDSFORPASSWORDID_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_GETMEDIUMIDSFORPASSWORDID_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aIdentifiers=%zu hrc=%Rhrc\n", this, "Appliance::getMediumIdsForPasswordId", ComSafeArraySize(*aIdentifiers), hrc));
    return hrc;
}

STDMETHODIMP ApplianceWrap::AddPasswords(ComSafeArrayIn(IN_BSTR, aIdentifiers),
                                         ComSafeArrayIn(IN_BSTR, aPasswords))
{
    LogRelFlow(("{%p} %s: enter aIdentifiers=%zu aPasswords=%zu\n", this, "Appliance::addPasswords", aIdentifiers, aPasswords));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ArrayBSTRInConverter TmpIdentifiers(ComSafeArrayInArg(aIdentifiers));
        ArrayBSTRInConverter TmpPasswords(ComSafeArrayInArg(aPasswords));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_ADDPASSWORDS_ENTER(this, (uint32_t)TmpIdentifiers.array().size(), NULL /*for now*/, (uint32_t)TmpPasswords.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = addPasswords(TmpIdentifiers.array(),
                               TmpPasswords.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_ADDPASSWORDS_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpIdentifiers.array().size(), NULL /*for now*/, (uint32_t)TmpPasswords.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_ADDPASSWORDS_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_ADDPASSWORDS_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Appliance::addPasswords", hrc));
    return hrc;
}

STDMETHODIMP ApplianceWrap::CreateVirtualSystemDescriptions(ULONG aRequested,
                                                            ULONG *aCreated)
{
    LogRelFlow(("{%p} %s: enter aRequested=%RU32 aCreated=%p\n", this, "Appliance::createVirtualSystemDescriptions", aRequested, aCreated));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aCreated);


        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_CREATEVIRTUALSYSTEMDESCRIPTIONS_ENTER(this, aRequested);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = createVirtualSystemDescriptions(aRequested,
                                                  aCreated);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_CREATEVIRTUALSYSTEMDESCRIPTIONS_RETURN(this, hrc, 0 /*normal*/, aRequested, *aCreated);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_CREATEVIRTUALSYSTEMDESCRIPTIONS_RETURN(this, hrc, 1 /*hrc exception*/, aRequested, *aCreated);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_APPLIANCE_CREATEVIRTUALSYSTEMDESCRIPTIONS_RETURN(this, hrc, 9 /*unhandled exception*/, aRequested, *aCreated);
#endif
    }

    LogRelFlow(("{%p} %s: leave aCreated=%RU32 hrc=%Rhrc\n", this, "Appliance::createVirtualSystemDescriptions", *aCreated, hrc));
    return hrc;
}

STDMETHODIMP ApplianceWrap::InternalAndReservedMethod1IAppliance()
{
    return E_NOTIMPL;
}

STDMETHODIMP ApplianceWrap::InternalAndReservedMethod2IAppliance()
{
    return E_NOTIMPL;
}

STDMETHODIMP ApplianceWrap::InternalAndReservedMethod3IAppliance()
{
    return E_NOTIMPL;
}

STDMETHODIMP ApplianceWrap::InternalAndReservedMethod4IAppliance()
{
    return E_NOTIMPL;
}

STDMETHODIMP ApplianceWrap::InternalAndReservedMethod5IAppliance()
{
    return E_NOTIMPL;
}

STDMETHODIMP ApplianceWrap::InternalAndReservedMethod6IAppliance()
{
    return E_NOTIMPL;
}

STDMETHODIMP ApplianceWrap::InternalAndReservedMethod7IAppliance()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(ApplianceWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(ApplianceWrap, IAppliance)
#endif // VBOX_WITH_XPCOM
