// Code generated by go-swagger; DO NOT EDIT.

package vault_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-service/stable/2020-11-25/models"
)

// AddPluginReader is a Reader for the AddPlugin structure.
type AddPluginReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AddPluginReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewAddPluginOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewAddPluginDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewAddPluginOK creates a AddPluginOK with default headers values
func NewAddPluginOK() *AddPluginOK {
	return &AddPluginOK{}
}

/*
AddPluginOK describes a response with status code 200, with default header values.

A successful response.
*/
type AddPluginOK struct {
	Payload models.HashicorpCloudVault20201125AddPluginResponse
}

// IsSuccess returns true when this add plugin o k response has a 2xx status code
func (o *AddPluginOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this add plugin o k response has a 3xx status code
func (o *AddPluginOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this add plugin o k response has a 4xx status code
func (o *AddPluginOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this add plugin o k response has a 5xx status code
func (o *AddPluginOK) IsServerError() bool {
	return false
}

// IsCode returns true when this add plugin o k response a status code equal to that given
func (o *AddPluginOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the add plugin o k response
func (o *AddPluginOK) Code() int {
	return 200
}

func (o *AddPluginOK) Error() string {
	return fmt.Sprintf("[POST /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/plugin/add][%d] addPluginOK  %+v", 200, o.Payload)
}

func (o *AddPluginOK) String() string {
	return fmt.Sprintf("[POST /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/plugin/add][%d] addPluginOK  %+v", 200, o.Payload)
}

func (o *AddPluginOK) GetPayload() models.HashicorpCloudVault20201125AddPluginResponse {
	return o.Payload
}

func (o *AddPluginOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAddPluginDefault creates a AddPluginDefault with default headers values
func NewAddPluginDefault(code int) *AddPluginDefault {
	return &AddPluginDefault{
		_statusCode: code,
	}
}

/*
AddPluginDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type AddPluginDefault struct {
	_statusCode int

	Payload *cloud.GrpcGatewayRuntimeError
}

// IsSuccess returns true when this add plugin default response has a 2xx status code
func (o *AddPluginDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this add plugin default response has a 3xx status code
func (o *AddPluginDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this add plugin default response has a 4xx status code
func (o *AddPluginDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this add plugin default response has a 5xx status code
func (o *AddPluginDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this add plugin default response a status code equal to that given
func (o *AddPluginDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the add plugin default response
func (o *AddPluginDefault) Code() int {
	return o._statusCode
}

func (o *AddPluginDefault) Error() string {
	return fmt.Sprintf("[POST /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/plugin/add][%d] AddPlugin default  %+v", o._statusCode, o.Payload)
}

func (o *AddPluginDefault) String() string {
	return fmt.Sprintf("[POST /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/plugin/add][%d] AddPlugin default  %+v", o._statusCode, o.Payload)
}

func (o *AddPluginDefault) GetPayload() *cloud.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *AddPluginDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
