// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// HashicorpCloudIamAuthConnection AuthConnection represents an authentication connection that may
// be used in multiple message types.
//
// swagger:model hashicorp.cloud.iam.AuthConnection
type HashicorpCloudIamAuthConnection struct {

	// client_id is the ID of the client for the connection
	ClientID string `json:"client_id,omitempty"`

	// created_ at is the time of creation for the connection
	// Format: date-time
	CreatedAt strfmt.DateTime `json:"created_at,omitempty"`

	// default_role is the RBAC role that users signing in to the
	// SSO org will get as the default.
	DefaultRole string `json:"default_role,omitempty"`

	// email_domain of the connection
	EmailDomain string `json:"email_domain,omitempty"`

	// id is the id of the connection
	ID string `json:"id,omitempty"`

	// issuer is the URL of the IDP
	Issuer string `json:"issuer,omitempty"`

	// updated_at is the time of last update of the connection
	// Format: date-time
	UpdatedAt strfmt.DateTime `json:"updated_at,omitempty"`
}

// Validate validates this hashicorp cloud iam auth connection
func (m *HashicorpCloudIamAuthConnection) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCreatedAt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdatedAt(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudIamAuthConnection) validateCreatedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.CreatedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("created_at", "body", "date-time", m.CreatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpCloudIamAuthConnection) validateUpdatedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.UpdatedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("updated_at", "body", "date-time", m.UpdatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this hashicorp cloud iam auth connection based on context it is used
func (m *HashicorpCloudIamAuthConnection) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudIamAuthConnection) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudIamAuthConnection) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudIamAuthConnection
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
