package kms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListApplicationAccessPoints invokes the kms.ListApplicationAccessPoints API synchronously
func (client *Client) ListApplicationAccessPoints(request *ListApplicationAccessPointsRequest) (response *ListApplicationAccessPointsResponse, err error) {
	response = CreateListApplicationAccessPointsResponse()
	err = client.DoAction(request, response)
	return
}

// ListApplicationAccessPointsWithChan invokes the kms.ListApplicationAccessPoints API asynchronously
func (client *Client) ListApplicationAccessPointsWithChan(request *ListApplicationAccessPointsRequest) (<-chan *ListApplicationAccessPointsResponse, <-chan error) {
	responseChan := make(chan *ListApplicationAccessPointsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListApplicationAccessPoints(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListApplicationAccessPointsWithCallback invokes the kms.ListApplicationAccessPoints API asynchronously
func (client *Client) ListApplicationAccessPointsWithCallback(request *ListApplicationAccessPointsRequest, callback func(response *ListApplicationAccessPointsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListApplicationAccessPointsResponse
		var err error
		defer close(result)
		response, err = client.ListApplicationAccessPoints(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListApplicationAccessPointsRequest is the request struct for api ListApplicationAccessPoints
type ListApplicationAccessPointsRequest struct {
	*requests.RpcRequest
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
}

// ListApplicationAccessPointsResponse is the response struct for api ListApplicationAccessPoints
type ListApplicationAccessPointsResponse struct {
	*responses.BaseResponse
	RequestId               string                  `json:"RequestId" xml:"RequestId"`
	PageNumber              int                     `json:"PageNumber" xml:"PageNumber"`
	PageSize                int                     `json:"PageSize" xml:"PageSize"`
	TotalCount              int                     `json:"TotalCount" xml:"TotalCount"`
	ApplicationAccessPoints ApplicationAccessPoints `json:"ApplicationAccessPoints" xml:"ApplicationAccessPoints"`
}

// CreateListApplicationAccessPointsRequest creates a request to invoke ListApplicationAccessPoints API
func CreateListApplicationAccessPointsRequest() (request *ListApplicationAccessPointsRequest) {
	request = &ListApplicationAccessPointsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Kms", "2016-01-20", "ListApplicationAccessPoints", "kms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListApplicationAccessPointsResponse creates a response to parse from ListApplicationAccessPoints response
func CreateListApplicationAccessPointsResponse() (response *ListApplicationAccessPointsResponse) {
	response = &ListApplicationAccessPointsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
