#line 1 "scan.c"
/*-------------------------------------------------------------------------
 *
 * scan.l
 *	  lexical scanner for PostgreSQL
 *
 * NOTE NOTE NOTE:
 *
 * The rules in this file must be kept in sync with src/fe_utils/psqlscan.l
 * and src/interfaces/ecpg/preproc/pgc.l!
 *
 * The rules are designed so that the scanner never has to backtrack,
 * in the sense that there is always a rule that can match the input
 * consumed so far (the rule action may internally throw back some input
 * with yyless(), however).  As explained in the flex manual, this makes
 * for a useful speed increase --- several percent faster when measuring
 * raw parsing (Flex + Bison).  The extra complexity is mostly in the rules
 * for handling float numbers and continued string literals.  If you change
 * the lexical rules, verify that you haven't broken the no-backtrack
 * property by running flex with the "-b" option and checking that the
 * resulting "lex.backup" file says that no backing up is needed.  (As of
 * Postgres 9.2, this check is made automatically by the Makefile.)
 *
 *
 * Portions Copyright (c) 1996-2025, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * IDENTIFICATION
 *	  src/backend/parser/scan.l
 *
 *-------------------------------------------------------------------------
 */
#include "postgres.h"

#include <ctype.h>
#include <unistd.h>

#include "common/string.h"
#include "gramparse.h"
#include "nodes/miscnodes.h"
#include "parser/parser.h"		/* only needed for GUC variables */
#include "parser/scansup.h"
#include "port/pg_bitutils.h"
#include "mb/pg_wchar.h"
#include "utils/builtins.h"

#line 47 "scan.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 4
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

#ifdef yy_create_buffer
#define core_yy_create_buffer_ALREADY_DEFINED
#else
#define yy_create_buffer core_yy_create_buffer
#endif

#ifdef yy_delete_buffer
#define core_yy_delete_buffer_ALREADY_DEFINED
#else
#define yy_delete_buffer core_yy_delete_buffer
#endif

#ifdef yy_scan_buffer
#define core_yy_scan_buffer_ALREADY_DEFINED
#else
#define yy_scan_buffer core_yy_scan_buffer
#endif

#ifdef yy_scan_string
#define core_yy_scan_string_ALREADY_DEFINED
#else
#define yy_scan_string core_yy_scan_string
#endif

#ifdef yy_scan_bytes
#define core_yy_scan_bytes_ALREADY_DEFINED
#else
#define yy_scan_bytes core_yy_scan_bytes
#endif

#ifdef yy_init_buffer
#define core_yy_init_buffer_ALREADY_DEFINED
#else
#define yy_init_buffer core_yy_init_buffer
#endif

#ifdef yy_flush_buffer
#define core_yy_flush_buffer_ALREADY_DEFINED
#else
#define yy_flush_buffer core_yy_flush_buffer
#endif

#ifdef yy_load_buffer_state
#define core_yy_load_buffer_state_ALREADY_DEFINED
#else
#define yy_load_buffer_state core_yy_load_buffer_state
#endif

#ifdef yy_switch_to_buffer
#define core_yy_switch_to_buffer_ALREADY_DEFINED
#else
#define yy_switch_to_buffer core_yy_switch_to_buffer
#endif

#ifdef yypush_buffer_state
#define core_yypush_buffer_state_ALREADY_DEFINED
#else
#define yypush_buffer_state core_yypush_buffer_state
#endif

#ifdef yypop_buffer_state
#define core_yypop_buffer_state_ALREADY_DEFINED
#else
#define yypop_buffer_state core_yypop_buffer_state
#endif

#ifdef yyensure_buffer_stack
#define core_yyensure_buffer_stack_ALREADY_DEFINED
#else
#define yyensure_buffer_stack core_yyensure_buffer_stack
#endif

#ifdef yylex
#define core_yylex_ALREADY_DEFINED
#else
#define yylex core_yylex
#endif

#ifdef yyrestart
#define core_yyrestart_ALREADY_DEFINED
#else
#define yyrestart core_yyrestart
#endif

#ifdef yylex_init
#define core_yylex_init_ALREADY_DEFINED
#else
#define yylex_init core_yylex_init
#endif

#ifdef yylex_init_extra
#define core_yylex_init_extra_ALREADY_DEFINED
#else
#define yylex_init_extra core_yylex_init_extra
#endif

#ifdef yylex_destroy
#define core_yylex_destroy_ALREADY_DEFINED
#else
#define yylex_destroy core_yylex_destroy
#endif

#ifdef yyget_debug
#define core_yyget_debug_ALREADY_DEFINED
#else
#define yyget_debug core_yyget_debug
#endif

#ifdef yyset_debug
#define core_yyset_debug_ALREADY_DEFINED
#else
#define yyset_debug core_yyset_debug
#endif

#ifdef yyget_extra
#define core_yyget_extra_ALREADY_DEFINED
#else
#define yyget_extra core_yyget_extra
#endif

#ifdef yyset_extra
#define core_yyset_extra_ALREADY_DEFINED
#else
#define yyset_extra core_yyset_extra
#endif

#ifdef yyget_in
#define core_yyget_in_ALREADY_DEFINED
#else
#define yyget_in core_yyget_in
#endif

#ifdef yyset_in
#define core_yyset_in_ALREADY_DEFINED
#else
#define yyset_in core_yyset_in
#endif

#ifdef yyget_out
#define core_yyget_out_ALREADY_DEFINED
#else
#define yyget_out core_yyget_out
#endif

#ifdef yyset_out
#define core_yyset_out_ALREADY_DEFINED
#else
#define yyset_out core_yyset_out
#endif

#ifdef yyget_leng
#define core_yyget_leng_ALREADY_DEFINED
#else
#define yyget_leng core_yyget_leng
#endif

#ifdef yyget_text
#define core_yyget_text_ALREADY_DEFINED
#else
#define yyget_text core_yyget_text
#endif

#ifdef yyget_lineno
#define core_yyget_lineno_ALREADY_DEFINED
#else
#define yyget_lineno core_yyget_lineno
#endif

#ifdef yyset_lineno
#define core_yyset_lineno_ALREADY_DEFINED
#else
#define yyset_lineno core_yyset_lineno
#endif

#ifdef yyget_column
#define core_yyget_column_ALREADY_DEFINED
#else
#define yyget_column core_yyget_column
#endif

#ifdef yyset_column
#define core_yyset_column_ALREADY_DEFINED
#else
#define yyset_column core_yyset_column
#endif

#ifdef yywrap
#define core_yywrap_ALREADY_DEFINED
#else
#define yywrap core_yywrap
#endif

#ifdef yyget_lval
#define core_yyget_lval_ALREADY_DEFINED
#else
#define yyget_lval core_yyget_lval
#endif

#ifdef yyset_lval
#define core_yyset_lval_ALREADY_DEFINED
#else
#define yyset_lval core_yyset_lval
#endif

#ifdef yyget_lloc
#define core_yyget_lloc_ALREADY_DEFINED
#else
#define yyget_lloc core_yyget_lloc
#endif

#ifdef yyset_lloc
#define core_yyset_lloc_ALREADY_DEFINED
#else
#define yyset_lloc core_yyset_lloc
#endif

#ifdef yyalloc
#define core_yyalloc_ALREADY_DEFINED
#else
#define yyalloc core_yyalloc
#endif

#ifdef yyrealloc
#define core_yyrealloc_ALREADY_DEFINED
#else
#define yyrealloc core_yyrealloc
#endif

#ifdef yyfree
#define core_yyfree_ALREADY_DEFINED
#else
#define yyfree core_yyfree
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#ifndef SIZE_MAX
#define SIZE_MAX               (~(size_t)0)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* begin standard C++ headers. */

/* TODO: this is always defined, so inline it */
#define yyconst const

#if defined(__GNUC__) && __GNUC__ >= 3
#define yynoreturn __attribute__((__noreturn__))
#else
#define yynoreturn
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an
 *   integer in range [0..255] for use as an array index.
 */
#define YY_SC_TO_UI(c) ((YY_CHAR) (c))

/* An opaque pointer. */
#ifndef YY_TYPEDEF_YY_SCANNER_T
#define YY_TYPEDEF_YY_SCANNER_T
typedef void* yyscan_t;
#endif

/* For convenience, these vars (plus the bison vars far below)
   are macros in the reentrant scanner. */
#define yyin yyg->yyin_r
#define yyout yyg->yyout_r
#define yyextra yyg->yyextra_r
#define yyleng yyg->yyleng_r
#define yytext yyg->yytext_r
#define yylineno (YY_CURRENT_BUFFER_LVALUE->yy_bs_lineno)
#define yycolumn (YY_CURRENT_BUFFER_LVALUE->yy_bs_column)
#define yy_flex_debug yyg->yy_flex_debug_r

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN yyg->yy_start = 1 + 2 *
/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((yyg->yy_start - 1) / 2)
#define YYSTATE YY_START
/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)
/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin , yyscanner )
#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2
    
    #define YY_LESS_LINENO(n)
    #define YY_LINENO_REWIND_TO(ptr)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = yyg->yy_hold_char; \
		YY_RESTORE_YY_MORE_OFFSET \
		yyg->yy_c_buf_p = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )
#define unput(c) yyunput( c, yyg->yytext_ptr , yyscanner )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	int yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( yyg->yy_buffer_stack \
                          ? yyg->yy_buffer_stack[yyg->yy_buffer_stack_top] \
                          : NULL)
/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE yyg->yy_buffer_stack[yyg->yy_buffer_stack_top]

void yyrestart ( FILE *input_file , yyscan_t yyscanner );
void yy_switch_to_buffer ( YY_BUFFER_STATE new_buffer , yyscan_t yyscanner );
YY_BUFFER_STATE yy_create_buffer ( FILE *file, int size , yyscan_t yyscanner );
void yy_delete_buffer ( YY_BUFFER_STATE b , yyscan_t yyscanner );
void yy_flush_buffer ( YY_BUFFER_STATE b , yyscan_t yyscanner );
void yypush_buffer_state ( YY_BUFFER_STATE new_buffer , yyscan_t yyscanner );
void yypop_buffer_state ( yyscan_t yyscanner );

static void yyensure_buffer_stack ( yyscan_t yyscanner );
static void yy_load_buffer_state ( yyscan_t yyscanner );
static void yy_init_buffer ( YY_BUFFER_STATE b, FILE *file , yyscan_t yyscanner );
#define YY_FLUSH_BUFFER yy_flush_buffer( YY_CURRENT_BUFFER , yyscanner)

YY_BUFFER_STATE yy_scan_buffer ( char *base, yy_size_t size , yyscan_t yyscanner );
YY_BUFFER_STATE yy_scan_string ( const char *yy_str , yyscan_t yyscanner );
YY_BUFFER_STATE yy_scan_bytes ( const char *bytes, int len , yyscan_t yyscanner );

void *yyalloc ( yy_size_t , yyscan_t yyscanner );
void *yyrealloc ( void *, yy_size_t , yyscan_t yyscanner );
void yyfree ( void * , yyscan_t yyscanner );

#define yy_new_buffer yy_create_buffer
#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}
#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}
#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define core_yywrap(yyscanner) (/*CONSTCOND*/1)
#define YY_SKIP_YYWRAP
typedef flex_uint8_t YY_CHAR;

typedef const struct yy_trans_info *yy_state_type;

#define yytext_ptr yytext_r

static yy_state_type yy_get_previous_state ( yyscan_t yyscanner );
static yy_state_type yy_try_NUL_trans ( yy_state_type current_state  , yyscan_t yyscanner);
static int yy_get_next_buffer ( yyscan_t yyscanner );
static void yynoreturn yy_fatal_error ( const char* msg , yyscan_t yyscanner );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	yyg->yytext_ptr = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	yyg->yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yyg->yy_c_buf_p = yy_cp;
#define YY_NUM_RULES 73
#define YY_END_OF_BUFFER 74
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static const struct yy_trans_info yy_transition[37182] =
    {
 {   0,   0 }, {   0,36926 }, {   0,   0 }, {   0,36924 }, {   1,6192 },
 {   2,6192 }, {   3,6192 }, {   4,6192 }, {   5,6192 }, {   6,6192 },
 {   7,6192 }, {   8,6192 }, {   9,6194 }, {  10,6199 }, {  11,6194 },
 {  12,6194 }, {  13,6194 }, {  14,6192 }, {  15,6192 }, {  16,6192 },
 {  17,6192 }, {  18,6192 }, {  19,6192 }, {  20,6192 }, {  21,6192 },
 {  22,6192 }, {  23,6192 }, {  24,6192 }, {  25,6192 }, {  26,6192 },
 {  27,6192 }, {  28,6192 }, {  29,6192 }, {  30,6192 }, {  31,6192 },
 {  32,6194 }, {  33,6201 }, {  34,6196 }, {  35,6241 }, {  36,6307 },
 {  37,6564 }, {  38,6241 }, {  39,6214 }, {  40,6216 }, {  41,6216 },
 {  42,6564 }, {  43,6564 }, {  44,6216 }, {  45,6575 }, {  46,6594 },

 {  47,6665 }, {  48,6697 }, {  49,6954 }, {  50,6954 }, {  51,6954 },
 {  52,6954 }, {  53,6954 }, {  54,6954 }, {  55,6954 }, {  56,6954 },
 {  57,6954 }, {  58,6219 }, {  59,6216 }, {  60,7211 }, {  61,7222 },
 {  62,7289 }, {  63,6241 }, {  64,6241 }, {  65,7321 }, {  66,7578 },
 {  67,7321 }, {  68,7321 }, {  69,7835 }, {  70,7321 }, {  71,7321 },
 {  72,7321 }, {  73,7321 }, {  74,7321 }, {  75,7321 }, {  76,7321 },
 {  77,7321 }, {  78,8092 }, {  79,7321 }, {  80,7321 }, {  81,7321 },
 {  82,7321 }, {  83,7321 }, {  84,7321 }, {  85,8349 }, {  86,7321 },
 {  87,7321 }, {  88,8606 }, {  89,7321 }, {  90,7321 }, {  91,6216 },
 {  92,6192 }, {  93,6216 }, {  94,6564 }, {  95,7321 }, {  96,6241 },

 {  97,7321 }, {  98,7578 }, {  99,7321 }, { 100,7321 }, { 101,7835 },
 { 102,7321 }, { 103,7321 }, { 104,7321 }, { 105,7321 }, { 106,7321 },
 { 107,7321 }, { 108,7321 }, { 109,7321 }, { 110,8092 }, { 111,7321 },
 { 112,7321 }, { 113,7321 }, { 114,7321 }, { 115,7321 }, { 116,7321 },
 { 117,8349 }, { 118,7321 }, { 119,7321 }, { 120,8606 }, { 121,7321 },
 { 122,7321 }, { 123,6192 }, { 124,6241 }, { 125,6192 }, { 126,6241 },
 { 127,6192 }, { 128,7321 }, { 129,7321 }, { 130,7321 }, { 131,7321 },
 { 132,7321 }, { 133,7321 }, { 134,7321 }, { 135,7321 }, { 136,7321 },
 { 137,7321 }, { 138,7321 }, { 139,7321 }, { 140,7321 }, { 141,7321 },
 { 142,7321 }, { 143,7321 }, { 144,7321 }, { 145,7321 }, { 146,7321 },

 { 147,7321 }, { 148,7321 }, { 149,7321 }, { 150,7321 }, { 151,7321 },
 { 152,7321 }, { 153,7321 }, { 154,7321 }, { 155,7321 }, { 156,7321 },
 { 157,7321 }, { 158,7321 }, { 159,7321 }, { 160,7321 }, { 161,7321 },
 { 162,7321 }, { 163,7321 }, { 164,7321 }, { 165,7321 }, { 166,7321 },
 { 167,7321 }, { 168,7321 }, { 169,7321 }, { 170,7321 }, { 171,7321 },
 { 172,7321 }, { 173,7321 }, { 174,7321 }, { 175,7321 }, { 176,7321 },
 { 177,7321 }, { 178,7321 }, { 179,7321 }, { 180,7321 }, { 181,7321 },
 { 182,7321 }, { 183,7321 }, { 184,7321 }, { 185,7321 }, { 186,7321 },
 { 187,7321 }, { 188,7321 }, { 189,7321 }, { 190,7321 }, { 191,7321 },
 { 192,7321 }, { 193,7321 }, { 194,7321 }, { 195,7321 }, { 196,7321 },

 { 197,7321 }, { 198,7321 }, { 199,7321 }, { 200,7321 }, { 201,7321 },
 { 202,7321 }, { 203,7321 }, { 204,7321 }, { 205,7321 }, { 206,7321 },
 { 207,7321 }, { 208,7321 }, { 209,7321 }, { 210,7321 }, { 211,7321 },
 { 212,7321 }, { 213,7321 }, { 214,7321 }, { 215,7321 }, { 216,7321 },
 { 217,7321 }, { 218,7321 }, { 219,7321 }, { 220,7321 }, { 221,7321 },
 { 222,7321 }, { 223,7321 }, { 224,7321 }, { 225,7321 }, { 226,7321 },
 { 227,7321 }, { 228,7321 }, { 229,7321 }, { 230,7321 }, { 231,7321 },
 { 232,7321 }, { 233,7321 }, { 234,7321 }, { 235,7321 }, { 236,7321 },
 { 237,7321 }, { 238,7321 }, { 239,7321 }, { 240,7321 }, { 241,7321 },
 { 242,7321 }, { 243,7321 }, { 244,7321 }, { 245,7321 }, { 246,7321 },

 { 247,7321 }, { 248,7321 }, { 249,7321 }, { 250,7321 }, { 251,7321 },
 { 252,7321 }, { 253,7321 }, { 254,7321 }, { 255,7321 }, { 256,6192 },
 {   0,   0 }, {   0,36666 }, {   1,5934 }, {   2,5934 }, {   3,5934 },
 {   4,5934 }, {   5,5934 }, {   6,5934 }, {   7,5934 }, {   8,5934 },
 {   9,5936 }, {  10,5941 }, {  11,5936 }, {  12,5936 }, {  13,5936 },
 {  14,5934 }, {  15,5934 }, {  16,5934 }, {  17,5934 }, {  18,5934 },
 {  19,5934 }, {  20,5934 }, {  21,5934 }, {  22,5934 }, {  23,5934 },
 {  24,5934 }, {  25,5934 }, {  26,5934 }, {  27,5934 }, {  28,5934 },
 {  29,5934 }, {  30,5934 }, {  31,5934 }, {  32,5936 }, {  33,5943 },
 {  34,5938 }, {  35,5983 }, {  36,6049 }, {  37,6306 }, {  38,5983 },

 {  39,5956 }, {  40,5958 }, {  41,5958 }, {  42,6306 }, {  43,6306 },
 {  44,5958 }, {  45,6317 }, {  46,6336 }, {  47,6407 }, {  48,6439 },
 {  49,6696 }, {  50,6696 }, {  51,6696 }, {  52,6696 }, {  53,6696 },
 {  54,6696 }, {  55,6696 }, {  56,6696 }, {  57,6696 }, {  58,5961 },
 {  59,5958 }, {  60,6953 }, {  61,6964 }, {  62,7031 }, {  63,5983 },
 {  64,5983 }, {  65,7063 }, {  66,7320 }, {  67,7063 }, {  68,7063 },
 {  69,7577 }, {  70,7063 }, {  71,7063 }, {  72,7063 }, {  73,7063 },
 {  74,7063 }, {  75,7063 }, {  76,7063 }, {  77,7063 }, {  78,7834 },
 {  79,7063 }, {  80,7063 }, {  81,7063 }, {  82,7063 }, {  83,7063 },
 {  84,7063 }, {  85,8091 }, {  86,7063 }, {  87,7063 }, {  88,8348 },

 {  89,7063 }, {  90,7063 }, {  91,5958 }, {  92,5934 }, {  93,5958 },
 {  94,6306 }, {  95,7063 }, {  96,5983 }, {  97,7063 }, {  98,7320 },
 {  99,7063 }, { 100,7063 }, { 101,7577 }, { 102,7063 }, { 103,7063 },
 { 104,7063 }, { 105,7063 }, { 106,7063 }, { 107,7063 }, { 108,7063 },
 { 109,7063 }, { 110,7834 }, { 111,7063 }, { 112,7063 }, { 113,7063 },
 { 114,7063 }, { 115,7063 }, { 116,7063 }, { 117,8091 }, { 118,7063 },
 { 119,7063 }, { 120,8348 }, { 121,7063 }, { 122,7063 }, { 123,5934 },
 { 124,5983 }, { 125,5934 }, { 126,5983 }, { 127,5934 }, { 128,7063 },
 { 129,7063 }, { 130,7063 }, { 131,7063 }, { 132,7063 }, { 133,7063 },
 { 134,7063 }, { 135,7063 }, { 136,7063 }, { 137,7063 }, { 138,7063 },

 { 139,7063 }, { 140,7063 }, { 141,7063 }, { 142,7063 }, { 143,7063 },
 { 144,7063 }, { 145,7063 }, { 146,7063 }, { 147,7063 }, { 148,7063 },
 { 149,7063 }, { 150,7063 }, { 151,7063 }, { 152,7063 }, { 153,7063 },
 { 154,7063 }, { 155,7063 }, { 156,7063 }, { 157,7063 }, { 158,7063 },
 { 159,7063 }, { 160,7063 }, { 161,7063 }, { 162,7063 }, { 163,7063 },
 { 164,7063 }, { 165,7063 }, { 166,7063 }, { 167,7063 }, { 168,7063 },
 { 169,7063 }, { 170,7063 }, { 171,7063 }, { 172,7063 }, { 173,7063 },
 { 174,7063 }, { 175,7063 }, { 176,7063 }, { 177,7063 }, { 178,7063 },
 { 179,7063 }, { 180,7063 }, { 181,7063 }, { 182,7063 }, { 183,7063 },
 { 184,7063 }, { 185,7063 }, { 186,7063 }, { 187,7063 }, { 188,7063 },

 { 189,7063 }, { 190,7063 }, { 191,7063 }, { 192,7063 }, { 193,7063 },
 { 194,7063 }, { 195,7063 }, { 196,7063 }, { 197,7063 }, { 198,7063 },
 { 199,7063 }, { 200,7063 }, { 201,7063 }, { 202,7063 }, { 203,7063 },
 { 204,7063 }, { 205,7063 }, { 206,7063 }, { 207,7063 }, { 208,7063 },
 { 209,7063 }, { 210,7063 }, { 211,7063 }, { 212,7063 }, { 213,7063 },
 { 214,7063 }, { 215,7063 }, { 216,7063 }, { 217,7063 }, { 218,7063 },
 { 219,7063 }, { 220,7063 }, { 221,7063 }, { 222,7063 }, { 223,7063 },
 { 224,7063 }, { 225,7063 }, { 226,7063 }, { 227,7063 }, { 228,7063 },
 { 229,7063 }, { 230,7063 }, { 231,7063 }, { 232,7063 }, { 233,7063 },
 { 234,7063 }, { 235,7063 }, { 236,7063 }, { 237,7063 }, { 238,7063 },

 { 239,7063 }, { 240,7063 }, { 241,7063 }, { 242,7063 }, { 243,7063 },
 { 244,7063 }, { 245,7063 }, { 246,7063 }, { 247,7063 }, { 248,7063 },
 { 249,7063 }, { 250,7063 }, { 251,7063 }, { 252,7063 }, { 253,7063 },
 { 254,7063 }, { 255,7063 }, { 256,5934 }, {   0,  10 }, {   0,36408 },
 {   1,8347 }, {   2,8347 }, {   3,8347 }, {   4,8347 }, {   5,8347 },
 {   6,8347 }, {   7,8347 }, {   8,8347 }, {   9,8347 }, {  10,8347 },
 {  11,8347 }, {  12,8347 }, {  13,8347 }, {  14,8347 }, {  15,8347 },
 {  16,8347 }, {  17,8347 }, {  18,8347 }, {  19,8347 }, {  20,8347 },
 {  21,8347 }, {  22,8347 }, {  23,8347 }, {  24,8347 }, {  25,8347 },
 {  26,8347 }, {  27,8347 }, {  28,8347 }, {  29,8347 }, {  30,8347 },

 {  31,8347 }, {  32,8347 }, {  33,8347 }, {  34,8347 }, {  35,8347 },
 {  36,8347 }, {  37,8347 }, {  38,8347 }, {  39,5705 }, {  40,8347 },
 {  41,8347 }, {  42,8347 }, {  43,8347 }, {  44,8347 }, {  45,8347 },
 {  46,8347 }, {  47,8347 }, {  48,8347 }, {  49,8347 }, {  50,8347 },
 {  51,8347 }, {  52,8347 }, {  53,8347 }, {  54,8347 }, {  55,8347 },
 {  56,8347 }, {  57,8347 }, {  58,8347 }, {  59,8347 }, {  60,8347 },
 {  61,8347 }, {  62,8347 }, {  63,8347 }, {  64,8347 }, {  65,8347 },
 {  66,8347 }, {  67,8347 }, {  68,8347 }, {  69,8347 }, {  70,8347 },
 {  71,8347 }, {  72,8347 }, {  73,8347 }, {  74,8347 }, {  75,8347 },
 {  76,8347 }, {  77,8347 }, {  78,8347 }, {  79,8347 }, {  80,8347 },

 {  81,8347 }, {  82,8347 }, {  83,8347 }, {  84,8347 }, {  85,8347 },
 {  86,8347 }, {  87,8347 }, {  88,8347 }, {  89,8347 }, {  90,8347 },
 {  91,8347 }, {  92,8347 }, {  93,8347 }, {  94,8347 }, {  95,8347 },
 {  96,8347 }, {  97,8347 }, {  98,8347 }, {  99,8347 }, { 100,8347 },
 { 101,8347 }, { 102,8347 }, { 103,8347 }, { 104,8347 }, { 105,8347 },
 { 106,8347 }, { 107,8347 }, { 108,8347 }, { 109,8347 }, { 110,8347 },
 { 111,8347 }, { 112,8347 }, { 113,8347 }, { 114,8347 }, { 115,8347 },
 { 116,8347 }, { 117,8347 }, { 118,8347 }, { 119,8347 }, { 120,8347 },
 { 121,8347 }, { 122,8347 }, { 123,8347 }, { 124,8347 }, { 125,8347 },
 { 126,8347 }, { 127,8347 }, { 128,8347 }, { 129,8347 }, { 130,8347 },

 { 131,8347 }, { 132,8347 }, { 133,8347 }, { 134,8347 }, { 135,8347 },
 { 136,8347 }, { 137,8347 }, { 138,8347 }, { 139,8347 }, { 140,8347 },
 { 141,8347 }, { 142,8347 }, { 143,8347 }, { 144,8347 }, { 145,8347 },
 { 146,8347 }, { 147,8347 }, { 148,8347 }, { 149,8347 }, { 150,8347 },
 { 151,8347 }, { 152,8347 }, { 153,8347 }, { 154,8347 }, { 155,8347 },
 { 156,8347 }, { 157,8347 }, { 158,8347 }, { 159,8347 }, { 160,8347 },
 { 161,8347 }, { 162,8347 }, { 163,8347 }, { 164,8347 }, { 165,8347 },
 { 166,8347 }, { 167,8347 }, { 168,8347 }, { 169,8347 }, { 170,8347 },
 { 171,8347 }, { 172,8347 }, { 173,8347 }, { 174,8347 }, { 175,8347 },
 { 176,8347 }, { 177,8347 }, { 178,8347 }, { 179,8347 }, { 180,8347 },

 { 181,8347 }, { 182,8347 }, { 183,8347 }, { 184,8347 }, { 185,8347 },
 { 186,8347 }, { 187,8347 }, { 188,8347 }, { 189,8347 }, { 190,8347 },
 { 191,8347 }, { 192,8347 }, { 193,8347 }, { 194,8347 }, { 195,8347 },
 { 196,8347 }, { 197,8347 }, { 198,8347 }, { 199,8347 }, { 200,8347 },
 { 201,8347 }, { 202,8347 }, { 203,8347 }, { 204,8347 }, { 205,8347 },
 { 206,8347 }, { 207,8347 }, { 208,8347 }, { 209,8347 }, { 210,8347 },
 { 211,8347 }, { 212,8347 }, { 213,8347 }, { 214,8347 }, { 215,8347 },
 { 216,8347 }, { 217,8347 }, { 218,8347 }, { 219,8347 }, { 220,8347 },
 { 221,8347 }, { 222,8347 }, { 223,8347 }, { 224,8347 }, { 225,8347 },
 { 226,8347 }, { 227,8347 }, { 228,8347 }, { 229,8347 }, { 230,8347 },

 { 231,8347 }, { 232,8347 }, { 233,8347 }, { 234,8347 }, { 235,8347 },
 { 236,8347 }, { 237,8347 }, { 238,8347 }, { 239,8347 }, { 240,8347 },
 { 241,8347 }, { 242,8347 }, { 243,8347 }, { 244,8347 }, { 245,8347 },
 { 246,8347 }, { 247,8347 }, { 248,8347 }, { 249,8347 }, { 250,8347 },
 { 251,8347 }, { 252,8347 }, { 253,8347 }, { 254,8347 }, { 255,8347 },
 { 256,8347 }, {   0,  10 }, {   0,36150 }, {   1,8089 }, {   2,8089 },
 {   3,8089 }, {   4,8089 }, {   5,8089 }, {   6,8089 }, {   7,8089 },
 {   8,8089 }, {   9,8089 }, {  10,8089 }, {  11,8089 }, {  12,8089 },
 {  13,8089 }, {  14,8089 }, {  15,8089 }, {  16,8089 }, {  17,8089 },
 {  18,8089 }, {  19,8089 }, {  20,8089 }, {  21,8089 }, {  22,8089 },

 {  23,8089 }, {  24,8089 }, {  25,8089 }, {  26,8089 }, {  27,8089 },
 {  28,8089 }, {  29,8089 }, {  30,8089 }, {  31,8089 }, {  32,8089 },
 {  33,8089 }, {  34,8089 }, {  35,8089 }, {  36,8089 }, {  37,8089 },
 {  38,8089 }, {  39,5447 }, {  40,8089 }, {  41,8089 }, {  42,8089 },
 {  43,8089 }, {  44,8089 }, {  45,8089 }, {  46,8089 }, {  47,8089 },
 {  48,8089 }, {  49,8089 }, {  50,8089 }, {  51,8089 }, {  52,8089 },
 {  53,8089 }, {  54,8089 }, {  55,8089 }, {  56,8089 }, {  57,8089 },
 {  58,8089 }, {  59,8089 }, {  60,8089 }, {  61,8089 }, {  62,8089 },
 {  63,8089 }, {  64,8089 }, {  65,8089 }, {  66,8089 }, {  67,8089 },
 {  68,8089 }, {  69,8089 }, {  70,8089 }, {  71,8089 }, {  72,8089 },

 {  73,8089 }, {  74,8089 }, {  75,8089 }, {  76,8089 }, {  77,8089 },
 {  78,8089 }, {  79,8089 }, {  80,8089 }, {  81,8089 }, {  82,8089 },
 {  83,8089 }, {  84,8089 }, {  85,8089 }, {  86,8089 }, {  87,8089 },
 {  88,8089 }, {  89,8089 }, {  90,8089 }, {  91,8089 }, {  92,8089 },
 {  93,8089 }, {  94,8089 }, {  95,8089 }, {  96,8089 }, {  97,8089 },
 {  98,8089 }, {  99,8089 }, { 100,8089 }, { 101,8089 }, { 102,8089 },
 { 103,8089 }, { 104,8089 }, { 105,8089 }, { 106,8089 }, { 107,8089 },
 { 108,8089 }, { 109,8089 }, { 110,8089 }, { 111,8089 }, { 112,8089 },
 { 113,8089 }, { 114,8089 }, { 115,8089 }, { 116,8089 }, { 117,8089 },
 { 118,8089 }, { 119,8089 }, { 120,8089 }, { 121,8089 }, { 122,8089 },

 { 123,8089 }, { 124,8089 }, { 125,8089 }, { 126,8089 }, { 127,8089 },
 { 128,8089 }, { 129,8089 }, { 130,8089 }, { 131,8089 }, { 132,8089 },
 { 133,8089 }, { 134,8089 }, { 135,8089 }, { 136,8089 }, { 137,8089 },
 { 138,8089 }, { 139,8089 }, { 140,8089 }, { 141,8089 }, { 142,8089 },
 { 143,8089 }, { 144,8089 }, { 145,8089 }, { 146,8089 }, { 147,8089 },
 { 148,8089 }, { 149,8089 }, { 150,8089 }, { 151,8089 }, { 152,8089 },
 { 153,8089 }, { 154,8089 }, { 155,8089 }, { 156,8089 }, { 157,8089 },
 { 158,8089 }, { 159,8089 }, { 160,8089 }, { 161,8089 }, { 162,8089 },
 { 163,8089 }, { 164,8089 }, { 165,8089 }, { 166,8089 }, { 167,8089 },
 { 168,8089 }, { 169,8089 }, { 170,8089 }, { 171,8089 }, { 172,8089 },

 { 173,8089 }, { 174,8089 }, { 175,8089 }, { 176,8089 }, { 177,8089 },
 { 178,8089 }, { 179,8089 }, { 180,8089 }, { 181,8089 }, { 182,8089 },
 { 183,8089 }, { 184,8089 }, { 185,8089 }, { 186,8089 }, { 187,8089 },
 { 188,8089 }, { 189,8089 }, { 190,8089 }, { 191,8089 }, { 192,8089 },
 { 193,8089 }, { 194,8089 }, { 195,8089 }, { 196,8089 }, { 197,8089 },
 { 198,8089 }, { 199,8089 }, { 200,8089 }, { 201,8089 }, { 202,8089 },
 { 203,8089 }, { 204,8089 }, { 205,8089 }, { 206,8089 }, { 207,8089 },
 { 208,8089 }, { 209,8089 }, { 210,8089 }, { 211,8089 }, { 212,8089 },
 { 213,8089 }, { 214,8089 }, { 215,8089 }, { 216,8089 }, { 217,8089 },
 { 218,8089 }, { 219,8089 }, { 220,8089 }, { 221,8089 }, { 222,8089 },

 { 223,8089 }, { 224,8089 }, { 225,8089 }, { 226,8089 }, { 227,8089 },
 { 228,8089 }, { 229,8089 }, { 230,8089 }, { 231,8089 }, { 232,8089 },
 { 233,8089 }, { 234,8089 }, { 235,8089 }, { 236,8089 }, { 237,8089 },
 { 238,8089 }, { 239,8089 }, { 240,8089 }, { 241,8089 }, { 242,8089 },
 { 243,8089 }, { 244,8089 }, { 245,8089 }, { 246,8089 }, { 247,8089 },
 { 248,8089 }, { 249,8089 }, { 250,8089 }, { 251,8089 }, { 252,8089 },
 { 253,8089 }, { 254,8089 }, { 255,8089 }, { 256,8089 }, {   0,   0 },
 {   0,35892 }, {   1,8089 }, {   2,8089 }, {   3,8089 }, {   4,8089 },
 {   5,8089 }, {   6,8089 }, {   7,8089 }, {   8,8089 }, {   9,8089 },
 {  10,8089 }, {  11,8089 }, {  12,8089 }, {  13,8089 }, {  14,8089 },

 {  15,8089 }, {  16,8089 }, {  17,8089 }, {  18,8089 }, {  19,8089 },
 {  20,8089 }, {  21,8089 }, {  22,8089 }, {  23,8089 }, {  24,8089 },
 {  25,8089 }, {  26,8089 }, {  27,8089 }, {  28,8089 }, {  29,8089 },
 {  30,8089 }, {  31,8089 }, {  32,8089 }, {  33,8347 }, {  34,8089 },
 {  35,8347 }, {  36,8089 }, {  37,8347 }, {  38,8347 }, {  39,8089 },
 {  40,8089 }, {  41,8089 }, {  42,5192 }, {  43,8347 }, {  44,8089 },
 {  45,8347 }, {  46,8089 }, {  47,5196 }, {  48,8089 }, {  49,8089 },
 {  50,8089 }, {  51,8089 }, {  52,8089 }, {  53,8089 }, {  54,8089 },
 {  55,8089 }, {  56,8089 }, {  57,8089 }, {  58,8089 }, {  59,8089 },
 {  60,8347 }, {  61,8347 }, {  62,8347 }, {  63,8347 }, {  64,8347 },

 {  65,8089 }, {  66,8089 }, {  67,8089 }, {  68,8089 }, {  69,8089 },
 {  70,8089 }, {  71,8089 }, {  72,8089 }, {  73,8089 }, {  74,8089 },
 {  75,8089 }, {  76,8089 }, {  77,8089 }, {  78,8089 }, {  79,8089 },
 {  80,8089 }, {  81,8089 }, {  82,8089 }, {  83,8089 }, {  84,8089 },
 {  85,8089 }, {  86,8089 }, {  87,8089 }, {  88,8089 }, {  89,8089 },
 {  90,8089 }, {  91,8089 }, {  92,8089 }, {  93,8089 }, {  94,8347 },
 {  95,8089 }, {  96,8347 }, {  97,8089 }, {  98,8089 }, {  99,8089 },
 { 100,8089 }, { 101,8089 }, { 102,8089 }, { 103,8089 }, { 104,8089 },
 { 105,8089 }, { 106,8089 }, { 107,8089 }, { 108,8089 }, { 109,8089 },
 { 110,8089 }, { 111,8089 }, { 112,8089 }, { 113,8089 }, { 114,8089 },

 { 115,8089 }, { 116,8089 }, { 117,8089 }, { 118,8089 }, { 119,8089 },
 { 120,8089 }, { 121,8089 }, { 122,8089 }, { 123,8089 }, { 124,8347 },
 { 125,8089 }, { 126,8347 }, { 127,8089 }, { 128,8089 }, { 129,8089 },
 { 130,8089 }, { 131,8089 }, { 132,8089 }, { 133,8089 }, { 134,8089 },
 { 135,8089 }, { 136,8089 }, { 137,8089 }, { 138,8089 }, { 139,8089 },
 { 140,8089 }, { 141,8089 }, { 142,8089 }, { 143,8089 }, { 144,8089 },
 { 145,8089 }, { 146,8089 }, { 147,8089 }, { 148,8089 }, { 149,8089 },
 { 150,8089 }, { 151,8089 }, { 152,8089 }, { 153,8089 }, { 154,8089 },
 { 155,8089 }, { 156,8089 }, { 157,8089 }, { 158,8089 }, { 159,8089 },
 { 160,8089 }, { 161,8089 }, { 162,8089 }, { 163,8089 }, { 164,8089 },

 { 165,8089 }, { 166,8089 }, { 167,8089 }, { 168,8089 }, { 169,8089 },
 { 170,8089 }, { 171,8089 }, { 172,8089 }, { 173,8089 }, { 174,8089 },
 { 175,8089 }, { 176,8089 }, { 177,8089 }, { 178,8089 }, { 179,8089 },
 { 180,8089 }, { 181,8089 }, { 182,8089 }, { 183,8089 }, { 184,8089 },
 { 185,8089 }, { 186,8089 }, { 187,8089 }, { 188,8089 }, { 189,8089 },
 { 190,8089 }, { 191,8089 }, { 192,8089 }, { 193,8089 }, { 194,8089 },
 { 195,8089 }, { 196,8089 }, { 197,8089 }, { 198,8089 }, { 199,8089 },
 { 200,8089 }, { 201,8089 }, { 202,8089 }, { 203,8089 }, { 204,8089 },
 { 205,8089 }, { 206,8089 }, { 207,8089 }, { 208,8089 }, { 209,8089 },
 { 210,8089 }, { 211,8089 }, { 212,8089 }, { 213,8089 }, { 214,8089 },

 { 215,8089 }, { 216,8089 }, { 217,8089 }, { 218,8089 }, { 219,8089 },
 { 220,8089 }, { 221,8089 }, { 222,8089 }, { 223,8089 }, { 224,8089 },
 { 225,8089 }, { 226,8089 }, { 227,8089 }, { 228,8089 }, { 229,8089 },
 { 230,8089 }, { 231,8089 }, { 232,8089 }, { 233,8089 }, { 234,8089 },
 { 235,8089 }, { 236,8089 }, { 237,8089 }, { 238,8089 }, { 239,8089 },
 { 240,8089 }, { 241,8089 }, { 242,8089 }, { 243,8089 }, { 244,8089 },
 { 245,8089 }, { 246,8089 }, { 247,8089 }, { 248,8089 }, { 249,8089 },
 { 250,8089 }, { 251,8089 }, { 252,8089 }, { 253,8089 }, { 254,8089 },
 { 255,8089 }, { 256,8089 }, {   0,   0 }, {   0,35634 }, {   1,7831 },
 {   2,7831 }, {   3,7831 }, {   4,7831 }, {   5,7831 }, {   6,7831 },

 {   7,7831 }, {   8,7831 }, {   9,7831 }, {  10,7831 }, {  11,7831 },
 {  12,7831 }, {  13,7831 }, {  14,7831 }, {  15,7831 }, {  16,7831 },
 {  17,7831 }, {  18,7831 }, {  19,7831 }, {  20,7831 }, {  21,7831 },
 {  22,7831 }, {  23,7831 }, {  24,7831 }, {  25,7831 }, {  26,7831 },
 {  27,7831 }, {  28,7831 }, {  29,7831 }, {  30,7831 }, {  31,7831 },
 {  32,7831 }, {  33,8089 }, {  34,7831 }, {  35,8089 }, {  36,7831 },
 {  37,8089 }, {  38,8089 }, {  39,7831 }, {  40,7831 }, {  41,7831 },
 {  42,4934 }, {  43,8089 }, {  44,7831 }, {  45,8089 }, {  46,7831 },
 {  47,4938 }, {  48,7831 }, {  49,7831 }, {  50,7831 }, {  51,7831 },
 {  52,7831 }, {  53,7831 }, {  54,7831 }, {  55,7831 }, {  56,7831 },

 {  57,7831 }, {  58,7831 }, {  59,7831 }, {  60,8089 }, {  61,8089 },
 {  62,8089 }, {  63,8089 }, {  64,8089 }, {  65,7831 }, {  66,7831 },
 {  67,7831 }, {  68,7831 }, {  69,7831 }, {  70,7831 }, {  71,7831 },
 {  72,7831 }, {  73,7831 }, {  74,7831 }, {  75,7831 }, {  76,7831 },
 {  77,7831 }, {  78,7831 }, {  79,7831 }, {  80,7831 }, {  81,7831 },
 {  82,7831 }, {  83,7831 }, {  84,7831 }, {  85,7831 }, {  86,7831 },
 {  87,7831 }, {  88,7831 }, {  89,7831 }, {  90,7831 }, {  91,7831 },
 {  92,7831 }, {  93,7831 }, {  94,8089 }, {  95,7831 }, {  96,8089 },
 {  97,7831 }, {  98,7831 }, {  99,7831 }, { 100,7831 }, { 101,7831 },
 { 102,7831 }, { 103,7831 }, { 104,7831 }, { 105,7831 }, { 106,7831 },

 { 107,7831 }, { 108,7831 }, { 109,7831 }, { 110,7831 }, { 111,7831 },
 { 112,7831 }, { 113,7831 }, { 114,7831 }, { 115,7831 }, { 116,7831 },
 { 117,7831 }, { 118,7831 }, { 119,7831 }, { 120,7831 }, { 121,7831 },
 { 122,7831 }, { 123,7831 }, { 124,8089 }, { 125,7831 }, { 126,8089 },
 { 127,7831 }, { 128,7831 }, { 129,7831 }, { 130,7831 }, { 131,7831 },
 { 132,7831 }, { 133,7831 }, { 134,7831 }, { 135,7831 }, { 136,7831 },
 { 137,7831 }, { 138,7831 }, { 139,7831 }, { 140,7831 }, { 141,7831 },
 { 142,7831 }, { 143,7831 }, { 144,7831 }, { 145,7831 }, { 146,7831 },
 { 147,7831 }, { 148,7831 }, { 149,7831 }, { 150,7831 }, { 151,7831 },
 { 152,7831 }, { 153,7831 }, { 154,7831 }, { 155,7831 }, { 156,7831 },

 { 157,7831 }, { 158,7831 }, { 159,7831 }, { 160,7831 }, { 161,7831 },
 { 162,7831 }, { 163,7831 }, { 164,7831 }, { 165,7831 }, { 166,7831 },
 { 167,7831 }, { 168,7831 }, { 169,7831 }, { 170,7831 }, { 171,7831 },
 { 172,7831 }, { 173,7831 }, { 174,7831 }, { 175,7831 }, { 176,7831 },
 { 177,7831 }, { 178,7831 }, { 179,7831 }, { 180,7831 }, { 181,7831 },
 { 182,7831 }, { 183,7831 }, { 184,7831 }, { 185,7831 }, { 186,7831 },
 { 187,7831 }, { 188,7831 }, { 189,7831 }, { 190,7831 }, { 191,7831 },
 { 192,7831 }, { 193,7831 }, { 194,7831 }, { 195,7831 }, { 196,7831 },
 { 197,7831 }, { 198,7831 }, { 199,7831 }, { 200,7831 }, { 201,7831 },
 { 202,7831 }, { 203,7831 }, { 204,7831 }, { 205,7831 }, { 206,7831 },

 { 207,7831 }, { 208,7831 }, { 209,7831 }, { 210,7831 }, { 211,7831 },
 { 212,7831 }, { 213,7831 }, { 214,7831 }, { 215,7831 }, { 216,7831 },
 { 217,7831 }, { 218,7831 }, { 219,7831 }, { 220,7831 }, { 221,7831 },
 { 222,7831 }, { 223,7831 }, { 224,7831 }, { 225,7831 }, { 226,7831 },
 { 227,7831 }, { 228,7831 }, { 229,7831 }, { 230,7831 }, { 231,7831 },
 { 232,7831 }, { 233,7831 }, { 234,7831 }, { 235,7831 }, { 236,7831 },
 { 237,7831 }, { 238,7831 }, { 239,7831 }, { 240,7831 }, { 241,7831 },
 { 242,7831 }, { 243,7831 }, { 244,7831 }, { 245,7831 }, { 246,7831 },
 { 247,7831 }, { 248,7831 }, { 249,7831 }, { 250,7831 }, { 251,7831 },
 { 252,7831 }, { 253,7831 }, { 254,7831 }, { 255,7831 }, { 256,7831 },

 {   0,   0 }, {   0,35376 }, {   1,8089 }, {   2,8089 }, {   3,8089 },
 {   4,8089 }, {   5,8089 }, {   6,8089 }, {   7,8089 }, {   8,8089 },
 {   9,8089 }, {  10,8089 }, {  11,8089 }, {  12,8089 }, {  13,8089 },
 {  14,8089 }, {  15,8089 }, {  16,8089 }, {  17,8089 }, {  18,8089 },
 {  19,8089 }, {  20,8089 }, {  21,8089 }, {  22,8089 }, {  23,8089 },
 {  24,8089 }, {  25,8089 }, {  26,8089 }, {  27,8089 }, {  28,8089 },
 {  29,8089 }, {  30,8089 }, {  31,8089 }, {  32,8089 }, {  33,8089 },
 {  34,4685 }, {  35,8089 }, {  36,8089 }, {  37,8089 }, {  38,8089 },
 {  39,8089 }, {  40,8089 }, {  41,8089 }, {  42,8089 }, {  43,8089 },
 {  44,8089 }, {  45,8089 }, {  46,8089 }, {  47,8089 }, {  48,8089 },

 {  49,8089 }, {  50,8089 }, {  51,8089 }, {  52,8089 }, {  53,8089 },
 {  54,8089 }, {  55,8089 }, {  56,8089 }, {  57,8089 }, {  58,8089 },
 {  59,8089 }, {  60,8089 }, {  61,8089 }, {  62,8089 }, {  63,8089 },
 {  64,8089 }, {  65,8089 }, {  66,8089 }, {  67,8089 }, {  68,8089 },
 {  69,8089 }, {  70,8089 }, {  71,8089 }, {  72,8089 }, {  73,8089 },
 {  74,8089 }, {  75,8089 }, {  76,8089 }, {  77,8089 }, {  78,8089 },
 {  79,8089 }, {  80,8089 }, {  81,8089 }, {  82,8089 }, {  83,8089 },
 {  84,8089 }, {  85,8089 }, {  86,8089 }, {  87,8089 }, {  88,8089 },
 {  89,8089 }, {  90,8089 }, {  91,8089 }, {  92,8089 }, {  93,8089 },
 {  94,8089 }, {  95,8089 }, {  96,8089 }, {  97,8089 }, {  98,8089 },

 {  99,8089 }, { 100,8089 }, { 101,8089 }, { 102,8089 }, { 103,8089 },
 { 104,8089 }, { 105,8089 }, { 106,8089 }, { 107,8089 }, { 108,8089 },
 { 109,8089 }, { 110,8089 }, { 111,8089 }, { 112,8089 }, { 113,8089 },
 { 114,8089 }, { 115,8089 }, { 116,8089 }, { 117,8089 }, { 118,8089 },
 { 119,8089 }, { 120,8089 }, { 121,8089 }, { 122,8089 }, { 123,8089 },
 { 124,8089 }, { 125,8089 }, { 126,8089 }, { 127,8089 }, { 128,8089 },
 { 129,8089 }, { 130,8089 }, { 131,8089 }, { 132,8089 }, { 133,8089 },
 { 134,8089 }, { 135,8089 }, { 136,8089 }, { 137,8089 }, { 138,8089 },
 { 139,8089 }, { 140,8089 }, { 141,8089 }, { 142,8089 }, { 143,8089 },
 { 144,8089 }, { 145,8089 }, { 146,8089 }, { 147,8089 }, { 148,8089 },

 { 149,8089 }, { 150,8089 }, { 151,8089 }, { 152,8089 }, { 153,8089 },
 { 154,8089 }, { 155,8089 }, { 156,8089 }, { 157,8089 }, { 158,8089 },
 { 159,8089 }, { 160,8089 }, { 161,8089 }, { 162,8089 }, { 163,8089 },
 { 164,8089 }, { 165,8089 }, { 166,8089 }, { 167,8089 }, { 168,8089 },
 { 169,8089 }, { 170,8089 }, { 171,8089 }, { 172,8089 }, { 173,8089 },
 { 174,8089 }, { 175,8089 }, { 176,8089 }, { 177,8089 }, { 178,8089 },
 { 179,8089 }, { 180,8089 }, { 181,8089 }, { 182,8089 }, { 183,8089 },
 { 184,8089 }, { 185,8089 }, { 186,8089 }, { 187,8089 }, { 188,8089 },
 { 189,8089 }, { 190,8089 }, { 191,8089 }, { 192,8089 }, { 193,8089 },
 { 194,8089 }, { 195,8089 }, { 196,8089 }, { 197,8089 }, { 198,8089 },

 { 199,8089 }, { 200,8089 }, { 201,8089 }, { 202,8089 }, { 203,8089 },
 { 204,8089 }, { 205,8089 }, { 206,8089 }, { 207,8089 }, { 208,8089 },
 { 209,8089 }, { 210,8089 }, { 211,8089 }, { 212,8089 }, { 213,8089 },
 { 214,8089 }, { 215,8089 }, { 216,8089 }, { 217,8089 }, { 218,8089 },
 { 219,8089 }, { 220,8089 }, { 221,8089 }, { 222,8089 }, { 223,8089 },
 { 224,8089 }, { 225,8089 }, { 226,8089 }, { 227,8089 }, { 228,8089 },
 { 229,8089 }, { 230,8089 }, { 231,8089 }, { 232,8089 }, { 233,8089 },
 { 234,8089 }, { 235,8089 }, { 236,8089 }, { 237,8089 }, { 238,8089 },
 { 239,8089 }, { 240,8089 }, { 241,8089 }, { 242,8089 }, { 243,8089 },
 { 244,8089 }, { 245,8089 }, { 246,8089 }, { 247,8089 }, { 248,8089 },

 { 249,8089 }, { 250,8089 }, { 251,8089 }, { 252,8089 }, { 253,8089 },
 { 254,8089 }, { 255,8089 }, { 256,8089 }, {   0,   0 }, {   0,35118 },
 {   1,7831 }, {   2,7831 }, {   3,7831 }, {   4,7831 }, {   5,7831 },
 {   6,7831 }, {   7,7831 }, {   8,7831 }, {   9,7831 }, {  10,7831 },
 {  11,7831 }, {  12,7831 }, {  13,7831 }, {  14,7831 }, {  15,7831 },
 {  16,7831 }, {  17,7831 }, {  18,7831 }, {  19,7831 }, {  20,7831 },
 {  21,7831 }, {  22,7831 }, {  23,7831 }, {  24,7831 }, {  25,7831 },
 {  26,7831 }, {  27,7831 }, {  28,7831 }, {  29,7831 }, {  30,7831 },
 {  31,7831 }, {  32,7831 }, {  33,7831 }, {  34,4427 }, {  35,7831 },
 {  36,7831 }, {  37,7831 }, {  38,7831 }, {  39,7831 }, {  40,7831 },

 {  41,7831 }, {  42,7831 }, {  43,7831 }, {  44,7831 }, {  45,7831 },
 {  46,7831 }, {  47,7831 }, {  48,7831 }, {  49,7831 }, {  50,7831 },
 {  51,7831 }, {  52,7831 }, {  53,7831 }, {  54,7831 }, {  55,7831 },
 {  56,7831 }, {  57,7831 }, {  58,7831 }, {  59,7831 }, {  60,7831 },
 {  61,7831 }, {  62,7831 }, {  63,7831 }, {  64,7831 }, {  65,7831 },
 {  66,7831 }, {  67,7831 }, {  68,7831 }, {  69,7831 }, {  70,7831 },
 {  71,7831 }, {  72,7831 }, {  73,7831 }, {  74,7831 }, {  75,7831 },
 {  76,7831 }, {  77,7831 }, {  78,7831 }, {  79,7831 }, {  80,7831 },
 {  81,7831 }, {  82,7831 }, {  83,7831 }, {  84,7831 }, {  85,7831 },
 {  86,7831 }, {  87,7831 }, {  88,7831 }, {  89,7831 }, {  90,7831 },

 {  91,7831 }, {  92,7831 }, {  93,7831 }, {  94,7831 }, {  95,7831 },
 {  96,7831 }, {  97,7831 }, {  98,7831 }, {  99,7831 }, { 100,7831 },
 { 101,7831 }, { 102,7831 }, { 103,7831 }, { 104,7831 }, { 105,7831 },
 { 106,7831 }, { 107,7831 }, { 108,7831 }, { 109,7831 }, { 110,7831 },
 { 111,7831 }, { 112,7831 }, { 113,7831 }, { 114,7831 }, { 115,7831 },
 { 116,7831 }, { 117,7831 }, { 118,7831 }, { 119,7831 }, { 120,7831 },
 { 121,7831 }, { 122,7831 }, { 123,7831 }, { 124,7831 }, { 125,7831 },
 { 126,7831 }, { 127,7831 }, { 128,7831 }, { 129,7831 }, { 130,7831 },
 { 131,7831 }, { 132,7831 }, { 133,7831 }, { 134,7831 }, { 135,7831 },
 { 136,7831 }, { 137,7831 }, { 138,7831 }, { 139,7831 }, { 140,7831 },

 { 141,7831 }, { 142,7831 }, { 143,7831 }, { 144,7831 }, { 145,7831 },
 { 146,7831 }, { 147,7831 }, { 148,7831 }, { 149,7831 }, { 150,7831 },
 { 151,7831 }, { 152,7831 }, { 153,7831 }, { 154,7831 }, { 155,7831 },
 { 156,7831 }, { 157,7831 }, { 158,7831 }, { 159,7831 }, { 160,7831 },
 { 161,7831 }, { 162,7831 }, { 163,7831 }, { 164,7831 }, { 165,7831 },
 { 166,7831 }, { 167,7831 }, { 168,7831 }, { 169,7831 }, { 170,7831 },
 { 171,7831 }, { 172,7831 }, { 173,7831 }, { 174,7831 }, { 175,7831 },
 { 176,7831 }, { 177,7831 }, { 178,7831 }, { 179,7831 }, { 180,7831 },
 { 181,7831 }, { 182,7831 }, { 183,7831 }, { 184,7831 }, { 185,7831 },
 { 186,7831 }, { 187,7831 }, { 188,7831 }, { 189,7831 }, { 190,7831 },

 { 191,7831 }, { 192,7831 }, { 193,7831 }, { 194,7831 }, { 195,7831 },
 { 196,7831 }, { 197,7831 }, { 198,7831 }, { 199,7831 }, { 200,7831 },
 { 201,7831 }, { 202,7831 }, { 203,7831 }, { 204,7831 }, { 205,7831 },
 { 206,7831 }, { 207,7831 }, { 208,7831 }, { 209,7831 }, { 210,7831 },
 { 211,7831 }, { 212,7831 }, { 213,7831 }, { 214,7831 }, { 215,7831 },
 { 216,7831 }, { 217,7831 }, { 218,7831 }, { 219,7831 }, { 220,7831 },
 { 221,7831 }, { 222,7831 }, { 223,7831 }, { 224,7831 }, { 225,7831 },
 { 226,7831 }, { 227,7831 }, { 228,7831 }, { 229,7831 }, { 230,7831 },
 { 231,7831 }, { 232,7831 }, { 233,7831 }, { 234,7831 }, { 235,7831 },
 { 236,7831 }, { 237,7831 }, { 238,7831 }, { 239,7831 }, { 240,7831 },

 { 241,7831 }, { 242,7831 }, { 243,7831 }, { 244,7831 }, { 245,7831 },
 { 246,7831 }, { 247,7831 }, { 248,7831 }, { 249,7831 }, { 250,7831 },
 { 251,7831 }, { 252,7831 }, { 253,7831 }, { 254,7831 }, { 255,7831 },
 { 256,7831 }, {   0,   9 }, {   0,34860 }, {   1,7831 }, {   2,7831 },
 {   3,7831 }, {   4,7831 }, {   5,7831 }, {   6,7831 }, {   7,7831 },
 {   8,7831 }, {   9,7831 }, {  10,7831 }, {  11,7831 }, {  12,7831 },
 {  13,7831 }, {  14,7831 }, {  15,7831 }, {  16,7831 }, {  17,7831 },
 {  18,7831 }, {  19,7831 }, {  20,7831 }, {  21,7831 }, {  22,7831 },
 {  23,7831 }, {  24,7831 }, {  25,7831 }, {  26,7831 }, {  27,7831 },
 {  28,7831 }, {  29,7831 }, {  30,7831 }, {  31,7831 }, {  32,7831 },

 {  33,7831 }, {  34,7831 }, {  35,7831 }, {  36,7831 }, {  37,7831 },
 {  38,7831 }, {  39,4157 }, {  40,7831 }, {  41,7831 }, {  42,7831 },
 {  43,7831 }, {  44,7831 }, {  45,7831 }, {  46,7831 }, {  47,7831 },
 {  48,7831 }, {  49,7831 }, {  50,7831 }, {  51,7831 }, {  52,7831 },
 {  53,7831 }, {  54,7831 }, {  55,7831 }, {  56,7831 }, {  57,7831 },
 {  58,7831 }, {  59,7831 }, {  60,7831 }, {  61,7831 }, {  62,7831 },
 {  63,7831 }, {  64,7831 }, {  65,7831 }, {  66,7831 }, {  67,7831 },
 {  68,7831 }, {  69,7831 }, {  70,7831 }, {  71,7831 }, {  72,7831 },
 {  73,7831 }, {  74,7831 }, {  75,7831 }, {  76,7831 }, {  77,7831 },
 {  78,7831 }, {  79,7831 }, {  80,7831 }, {  81,7831 }, {  82,7831 },

 {  83,7831 }, {  84,7831 }, {  85,7831 }, {  86,7831 }, {  87,7831 },
 {  88,7831 }, {  89,7831 }, {  90,7831 }, {  91,7831 }, {  92,7831 },
 {  93,7831 }, {  94,7831 }, {  95,7831 }, {  96,7831 }, {  97,7831 },
 {  98,7831 }, {  99,7831 }, { 100,7831 }, { 101,7831 }, { 102,7831 },
 { 103,7831 }, { 104,7831 }, { 105,7831 }, { 106,7831 }, { 107,7831 },
 { 108,7831 }, { 109,7831 }, { 110,7831 }, { 111,7831 }, { 112,7831 },
 { 113,7831 }, { 114,7831 }, { 115,7831 }, { 116,7831 }, { 117,7831 },
 { 118,7831 }, { 119,7831 }, { 120,7831 }, { 121,7831 }, { 122,7831 },
 { 123,7831 }, { 124,7831 }, { 125,7831 }, { 126,7831 }, { 127,7831 },
 { 128,7831 }, { 129,7831 }, { 130,7831 }, { 131,7831 }, { 132,7831 },

 { 133,7831 }, { 134,7831 }, { 135,7831 }, { 136,7831 }, { 137,7831 },
 { 138,7831 }, { 139,7831 }, { 140,7831 }, { 141,7831 }, { 142,7831 },
 { 143,7831 }, { 144,7831 }, { 145,7831 }, { 146,7831 }, { 147,7831 },
 { 148,7831 }, { 149,7831 }, { 150,7831 }, { 151,7831 }, { 152,7831 },
 { 153,7831 }, { 154,7831 }, { 155,7831 }, { 156,7831 }, { 157,7831 },
 { 158,7831 }, { 159,7831 }, { 160,7831 }, { 161,7831 }, { 162,7831 },
 { 163,7831 }, { 164,7831 }, { 165,7831 }, { 166,7831 }, { 167,7831 },
 { 168,7831 }, { 169,7831 }, { 170,7831 }, { 171,7831 }, { 172,7831 },
 { 173,7831 }, { 174,7831 }, { 175,7831 }, { 176,7831 }, { 177,7831 },
 { 178,7831 }, { 179,7831 }, { 180,7831 }, { 181,7831 }, { 182,7831 },

 { 183,7831 }, { 184,7831 }, { 185,7831 }, { 186,7831 }, { 187,7831 },
 { 188,7831 }, { 189,7831 }, { 190,7831 }, { 191,7831 }, { 192,7831 },
 { 193,7831 }, { 194,7831 }, { 195,7831 }, { 196,7831 }, { 197,7831 },
 { 198,7831 }, { 199,7831 }, { 200,7831 }, { 201,7831 }, { 202,7831 },
 { 203,7831 }, { 204,7831 }, { 205,7831 }, { 206,7831 }, { 207,7831 },
 { 208,7831 }, { 209,7831 }, { 210,7831 }, { 211,7831 }, { 212,7831 },
 { 213,7831 }, { 214,7831 }, { 215,7831 }, { 216,7831 }, { 217,7831 },
 { 218,7831 }, { 219,7831 }, { 220,7831 }, { 221,7831 }, { 222,7831 },
 { 223,7831 }, { 224,7831 }, { 225,7831 }, { 226,7831 }, { 227,7831 },
 { 228,7831 }, { 229,7831 }, { 230,7831 }, { 231,7831 }, { 232,7831 },

 { 233,7831 }, { 234,7831 }, { 235,7831 }, { 236,7831 }, { 237,7831 },
 { 238,7831 }, { 239,7831 }, { 240,7831 }, { 241,7831 }, { 242,7831 },
 { 243,7831 }, { 244,7831 }, { 245,7831 }, { 246,7831 }, { 247,7831 },
 { 248,7831 }, { 249,7831 }, { 250,7831 }, { 251,7831 }, { 252,7831 },
 { 253,7831 }, { 254,7831 }, { 255,7831 }, { 256,7831 }, {   0,   9 },
 {   0,34602 }, {   1,7573 }, {   2,7573 }, {   3,7573 }, {   4,7573 },
 {   5,7573 }, {   6,7573 }, {   7,7573 }, {   8,7573 }, {   9,7573 },
 {  10,7573 }, {  11,7573 }, {  12,7573 }, {  13,7573 }, {  14,7573 },
 {  15,7573 }, {  16,7573 }, {  17,7573 }, {  18,7573 }, {  19,7573 },
 {  20,7573 }, {  21,7573 }, {  22,7573 }, {  23,7573 }, {  24,7573 },

 {  25,7573 }, {  26,7573 }, {  27,7573 }, {  28,7573 }, {  29,7573 },
 {  30,7573 }, {  31,7573 }, {  32,7573 }, {  33,7573 }, {  34,7573 },
 {  35,7573 }, {  36,7573 }, {  37,7573 }, {  38,7573 }, {  39,3899 },
 {  40,7573 }, {  41,7573 }, {  42,7573 }, {  43,7573 }, {  44,7573 },
 {  45,7573 }, {  46,7573 }, {  47,7573 }, {  48,7573 }, {  49,7573 },
 {  50,7573 }, {  51,7573 }, {  52,7573 }, {  53,7573 }, {  54,7573 },
 {  55,7573 }, {  56,7573 }, {  57,7573 }, {  58,7573 }, {  59,7573 },
 {  60,7573 }, {  61,7573 }, {  62,7573 }, {  63,7573 }, {  64,7573 },
 {  65,7573 }, {  66,7573 }, {  67,7573 }, {  68,7573 }, {  69,7573 },
 {  70,7573 }, {  71,7573 }, {  72,7573 }, {  73,7573 }, {  74,7573 },

 {  75,7573 }, {  76,7573 }, {  77,7573 }, {  78,7573 }, {  79,7573 },
 {  80,7573 }, {  81,7573 }, {  82,7573 }, {  83,7573 }, {  84,7573 },
 {  85,7573 }, {  86,7573 }, {  87,7573 }, {  88,7573 }, {  89,7573 },
 {  90,7573 }, {  91,7573 }, {  92,7573 }, {  93,7573 }, {  94,7573 },
 {  95,7573 }, {  96,7573 }, {  97,7573 }, {  98,7573 }, {  99,7573 },
 { 100,7573 }, { 101,7573 }, { 102,7573 }, { 103,7573 }, { 104,7573 },
 { 105,7573 }, { 106,7573 }, { 107,7573 }, { 108,7573 }, { 109,7573 },
 { 110,7573 }, { 111,7573 }, { 112,7573 }, { 113,7573 }, { 114,7573 },
 { 115,7573 }, { 116,7573 }, { 117,7573 }, { 118,7573 }, { 119,7573 },
 { 120,7573 }, { 121,7573 }, { 122,7573 }, { 123,7573 }, { 124,7573 },

 { 125,7573 }, { 126,7573 }, { 127,7573 }, { 128,7573 }, { 129,7573 },
 { 130,7573 }, { 131,7573 }, { 132,7573 }, { 133,7573 }, { 134,7573 },
 { 135,7573 }, { 136,7573 }, { 137,7573 }, { 138,7573 }, { 139,7573 },
 { 140,7573 }, { 141,7573 }, { 142,7573 }, { 143,7573 }, { 144,7573 },
 { 145,7573 }, { 146,7573 }, { 147,7573 }, { 148,7573 }, { 149,7573 },
 { 150,7573 }, { 151,7573 }, { 152,7573 }, { 153,7573 }, { 154,7573 },
 { 155,7573 }, { 156,7573 }, { 157,7573 }, { 158,7573 }, { 159,7573 },
 { 160,7573 }, { 161,7573 }, { 162,7573 }, { 163,7573 }, { 164,7573 },
 { 165,7573 }, { 166,7573 }, { 167,7573 }, { 168,7573 }, { 169,7573 },
 { 170,7573 }, { 171,7573 }, { 172,7573 }, { 173,7573 }, { 174,7573 },

 { 175,7573 }, { 176,7573 }, { 177,7573 }, { 178,7573 }, { 179,7573 },
 { 180,7573 }, { 181,7573 }, { 182,7573 }, { 183,7573 }, { 184,7573 },
 { 185,7573 }, { 186,7573 }, { 187,7573 }, { 188,7573 }, { 189,7573 },
 { 190,7573 }, { 191,7573 }, { 192,7573 }, { 193,7573 }, { 194,7573 },
 { 195,7573 }, { 196,7573 }, { 197,7573 }, { 198,7573 }, { 199,7573 },
 { 200,7573 }, { 201,7573 }, { 202,7573 }, { 203,7573 }, { 204,7573 },
 { 205,7573 }, { 206,7573 }, { 207,7573 }, { 208,7573 }, { 209,7573 },
 { 210,7573 }, { 211,7573 }, { 212,7573 }, { 213,7573 }, { 214,7573 },
 { 215,7573 }, { 216,7573 }, { 217,7573 }, { 218,7573 }, { 219,7573 },
 { 220,7573 }, { 221,7573 }, { 222,7573 }, { 223,7573 }, { 224,7573 },

 { 225,7573 }, { 226,7573 }, { 227,7573 }, { 228,7573 }, { 229,7573 },
 { 230,7573 }, { 231,7573 }, { 232,7573 }, { 233,7573 }, { 234,7573 },
 { 235,7573 }, { 236,7573 }, { 237,7573 }, { 238,7573 }, { 239,7573 },
 { 240,7573 }, { 241,7573 }, { 242,7573 }, { 243,7573 }, { 244,7573 },
 { 245,7573 }, { 246,7573 }, { 247,7573 }, { 248,7573 }, { 249,7573 },
 { 250,7573 }, { 251,7573 }, { 252,7573 }, { 253,7573 }, { 254,7573 },
 { 255,7573 }, { 256,7573 }, {   0,   0 }, {   0,34344 }, {   1,7573 },
 {   2,7573 }, {   3,7573 }, {   4,7573 }, {   5,7573 }, {   6,7573 },
 {   7,7573 }, {   8,7573 }, {   9,7573 }, {  10,7573 }, {  11,7573 },
 {  12,7573 }, {  13,7573 }, {  14,7573 }, {  15,7573 }, {  16,7573 },

 {  17,7573 }, {  18,7573 }, {  19,7573 }, {  20,7573 }, {  21,7573 },
 {  22,7573 }, {  23,7573 }, {  24,7573 }, {  25,7573 }, {  26,7573 },
 {  27,7573 }, {  28,7573 }, {  29,7573 }, {  30,7573 }, {  31,7573 },
 {  32,7573 }, {  33,7573 }, {  34,7573 }, {  35,7573 }, {  36,7573 },
 {  37,7573 }, {  38,7573 }, {  39,3670 }, {  40,7573 }, {  41,7573 },
 {  42,7573 }, {  43,7573 }, {  44,7573 }, {  45,7573 }, {  46,7573 },
 {  47,7573 }, {  48,7573 }, {  49,7573 }, {  50,7573 }, {  51,7573 },
 {  52,7573 }, {  53,7573 }, {  54,7573 }, {  55,7573 }, {  56,7573 },
 {  57,7573 }, {  58,7573 }, {  59,7573 }, {  60,7573 }, {  61,7573 },
 {  62,7573 }, {  63,7573 }, {  64,7573 }, {  65,7573 }, {  66,7573 },

 {  67,7573 }, {  68,7573 }, {  69,7573 }, {  70,7573 }, {  71,7573 },
 {  72,7573 }, {  73,7573 }, {  74,7573 }, {  75,7573 }, {  76,7573 },
 {  77,7573 }, {  78,7573 }, {  79,7573 }, {  80,7573 }, {  81,7573 },
 {  82,7573 }, {  83,7573 }, {  84,7573 }, {  85,7573 }, {  86,7573 },
 {  87,7573 }, {  88,7573 }, {  89,7573 }, {  90,7573 }, {  91,7573 },
 {  92,7573 }, {  93,7573 }, {  94,7573 }, {  95,7573 }, {  96,7573 },
 {  97,7573 }, {  98,7573 }, {  99,7573 }, { 100,7573 }, { 101,7573 },
 { 102,7573 }, { 103,7573 }, { 104,7573 }, { 105,7573 }, { 106,7573 },
 { 107,7573 }, { 108,7573 }, { 109,7573 }, { 110,7573 }, { 111,7573 },
 { 112,7573 }, { 113,7573 }, { 114,7573 }, { 115,7573 }, { 116,7573 },

 { 117,7573 }, { 118,7573 }, { 119,7573 }, { 120,7573 }, { 121,7573 },
 { 122,7573 }, { 123,7573 }, { 124,7573 }, { 125,7573 }, { 126,7573 },
 { 127,7573 }, { 128,7573 }, { 129,7573 }, { 130,7573 }, { 131,7573 },
 { 132,7573 }, { 133,7573 }, { 134,7573 }, { 135,7573 }, { 136,7573 },
 { 137,7573 }, { 138,7573 }, { 139,7573 }, { 140,7573 }, { 141,7573 },
 { 142,7573 }, { 143,7573 }, { 144,7573 }, { 145,7573 }, { 146,7573 },
 { 147,7573 }, { 148,7573 }, { 149,7573 }, { 150,7573 }, { 151,7573 },
 { 152,7573 }, { 153,7573 }, { 154,7573 }, { 155,7573 }, { 156,7573 },
 { 157,7573 }, { 158,7573 }, { 159,7573 }, { 160,7573 }, { 161,7573 },
 { 162,7573 }, { 163,7573 }, { 164,7573 }, { 165,7573 }, { 166,7573 },

 { 167,7573 }, { 168,7573 }, { 169,7573 }, { 170,7573 }, { 171,7573 },
 { 172,7573 }, { 173,7573 }, { 174,7573 }, { 175,7573 }, { 176,7573 },
 { 177,7573 }, { 178,7573 }, { 179,7573 }, { 180,7573 }, { 181,7573 },
 { 182,7573 }, { 183,7573 }, { 184,7573 }, { 185,7573 }, { 186,7573 },
 { 187,7573 }, { 188,7573 }, { 189,7573 }, { 190,7573 }, { 191,7573 },
 { 192,7573 }, { 193,7573 }, { 194,7573 }, { 195,7573 }, { 196,7573 },
 { 197,7573 }, { 198,7573 }, { 199,7573 }, { 200,7573 }, { 201,7573 },
 { 202,7573 }, { 203,7573 }, { 204,7573 }, { 205,7573 }, { 206,7573 },
 { 207,7573 }, { 208,7573 }, { 209,7573 }, { 210,7573 }, { 211,7573 },
 { 212,7573 }, { 213,7573 }, { 214,7573 }, { 215,7573 }, { 216,7573 },

 { 217,7573 }, { 218,7573 }, { 219,7573 }, { 220,7573 }, { 221,7573 },
 { 222,7573 }, { 223,7573 }, { 224,7573 }, { 225,7573 }, { 226,7573 },
 { 227,7573 }, { 228,7573 }, { 229,7573 }, { 230,7573 }, { 231,7573 },
 { 232,7573 }, { 233,7573 }, { 234,7573 }, { 235,7573 }, { 236,7573 },
 { 237,7573 }, { 238,7573 }, { 239,7573 }, { 240,7573 }, { 241,7573 },
 { 242,7573 }, { 243,7573 }, { 244,7573 }, { 245,7573 }, { 246,7573 },
 { 247,7573 }, { 248,7573 }, { 249,7573 }, { 250,7573 }, { 251,7573 },
 { 252,7573 }, { 253,7573 }, { 254,7573 }, { 255,7573 }, { 256,7573 },
 {   0,   0 }, {   0,34086 }, {   1,7315 }, {   2,7315 }, {   3,7315 },
 {   4,7315 }, {   5,7315 }, {   6,7315 }, {   7,7315 }, {   8,7315 },

 {   9,7315 }, {  10,7315 }, {  11,7315 }, {  12,7315 }, {  13,7315 },
 {  14,7315 }, {  15,7315 }, {  16,7315 }, {  17,7315 }, {  18,7315 },
 {  19,7315 }, {  20,7315 }, {  21,7315 }, {  22,7315 }, {  23,7315 },
 {  24,7315 }, {  25,7315 }, {  26,7315 }, {  27,7315 }, {  28,7315 },
 {  29,7315 }, {  30,7315 }, {  31,7315 }, {  32,7315 }, {  33,7315 },
 {  34,7315 }, {  35,7315 }, {  36,7315 }, {  37,7315 }, {  38,7315 },
 {  39,3412 }, {  40,7315 }, {  41,7315 }, {  42,7315 }, {  43,7315 },
 {  44,7315 }, {  45,7315 }, {  46,7315 }, {  47,7315 }, {  48,7315 },
 {  49,7315 }, {  50,7315 }, {  51,7315 }, {  52,7315 }, {  53,7315 },
 {  54,7315 }, {  55,7315 }, {  56,7315 }, {  57,7315 }, {  58,7315 },

 {  59,7315 }, {  60,7315 }, {  61,7315 }, {  62,7315 }, {  63,7315 },
 {  64,7315 }, {  65,7315 }, {  66,7315 }, {  67,7315 }, {  68,7315 },
 {  69,7315 }, {  70,7315 }, {  71,7315 }, {  72,7315 }, {  73,7315 },
 {  74,7315 }, {  75,7315 }, {  76,7315 }, {  77,7315 }, {  78,7315 },
 {  79,7315 }, {  80,7315 }, {  81,7315 }, {  82,7315 }, {  83,7315 },
 {  84,7315 }, {  85,7315 }, {  86,7315 }, {  87,7315 }, {  88,7315 },
 {  89,7315 }, {  90,7315 }, {  91,7315 }, {  92,7315 }, {  93,7315 },
 {  94,7315 }, {  95,7315 }, {  96,7315 }, {  97,7315 }, {  98,7315 },
 {  99,7315 }, { 100,7315 }, { 101,7315 }, { 102,7315 }, { 103,7315 },
 { 104,7315 }, { 105,7315 }, { 106,7315 }, { 107,7315 }, { 108,7315 },

 { 109,7315 }, { 110,7315 }, { 111,7315 }, { 112,7315 }, { 113,7315 },
 { 114,7315 }, { 115,7315 }, { 116,7315 }, { 117,7315 }, { 118,7315 },
 { 119,7315 }, { 120,7315 }, { 121,7315 }, { 122,7315 }, { 123,7315 },
 { 124,7315 }, { 125,7315 }, { 126,7315 }, { 127,7315 }, { 128,7315 },
 { 129,7315 }, { 130,7315 }, { 131,7315 }, { 132,7315 }, { 133,7315 },
 { 134,7315 }, { 135,7315 }, { 136,7315 }, { 137,7315 }, { 138,7315 },
 { 139,7315 }, { 140,7315 }, { 141,7315 }, { 142,7315 }, { 143,7315 },
 { 144,7315 }, { 145,7315 }, { 146,7315 }, { 147,7315 }, { 148,7315 },
 { 149,7315 }, { 150,7315 }, { 151,7315 }, { 152,7315 }, { 153,7315 },
 { 154,7315 }, { 155,7315 }, { 156,7315 }, { 157,7315 }, { 158,7315 },

 { 159,7315 }, { 160,7315 }, { 161,7315 }, { 162,7315 }, { 163,7315 },
 { 164,7315 }, { 165,7315 }, { 166,7315 }, { 167,7315 }, { 168,7315 },
 { 169,7315 }, { 170,7315 }, { 171,7315 }, { 172,7315 }, { 173,7315 },
 { 174,7315 }, { 175,7315 }, { 176,7315 }, { 177,7315 }, { 178,7315 },
 { 179,7315 }, { 180,7315 }, { 181,7315 }, { 182,7315 }, { 183,7315 },
 { 184,7315 }, { 185,7315 }, { 186,7315 }, { 187,7315 }, { 188,7315 },
 { 189,7315 }, { 190,7315 }, { 191,7315 }, { 192,7315 }, { 193,7315 },
 { 194,7315 }, { 195,7315 }, { 196,7315 }, { 197,7315 }, { 198,7315 },
 { 199,7315 }, { 200,7315 }, { 201,7315 }, { 202,7315 }, { 203,7315 },
 { 204,7315 }, { 205,7315 }, { 206,7315 }, { 207,7315 }, { 208,7315 },

 { 209,7315 }, { 210,7315 }, { 211,7315 }, { 212,7315 }, { 213,7315 },
 { 214,7315 }, { 215,7315 }, { 216,7315 }, { 217,7315 }, { 218,7315 },
 { 219,7315 }, { 220,7315 }, { 221,7315 }, { 222,7315 }, { 223,7315 },
 { 224,7315 }, { 225,7315 }, { 226,7315 }, { 227,7315 }, { 228,7315 },
 { 229,7315 }, { 230,7315 }, { 231,7315 }, { 232,7315 }, { 233,7315 },
 { 234,7315 }, { 235,7315 }, { 236,7315 }, { 237,7315 }, { 238,7315 },
 { 239,7315 }, { 240,7315 }, { 241,7315 }, { 242,7315 }, { 243,7315 },
 { 244,7315 }, { 245,7315 }, { 246,7315 }, { 247,7315 }, { 248,7315 },
 { 249,7315 }, { 250,7315 }, { 251,7315 }, { 252,7315 }, { 253,7315 },
 { 254,7315 }, { 255,7315 }, { 256,7315 }, {   0,  18 }, {   0,33828 },

 {   1,3156 }, {   2,3156 }, {   3,3156 }, {   4,3156 }, {   5,3156 },
 {   6,3156 }, {   7,3156 }, {   8,3156 }, {   9,7315 }, {  10,7320 },
 {  11,7315 }, {  12,7315 }, {  13,7344 }, {  14,3156 }, {  15,3156 },
 {  16,3156 }, {  17,3156 }, {  18,3156 }, {  19,3156 }, {  20,3156 },
 {  21,3156 }, {  22,3156 }, {  23,3156 }, {  24,3156 }, {  25,3156 },
 {  26,3156 }, {  27,3156 }, {  28,3156 }, {  29,3156 }, {  30,3156 },
 {  31,3156 }, {  32,7315 }, {  33,3156 }, {  34,3156 }, {  35,3156 },
 {  36,3156 }, {  37,3156 }, {  38,3156 }, {  39,3156 }, {  40,3156 },
 {  41,3156 }, {  42,3156 }, {  43,3156 }, {  44,3156 }, {  45,3158 },
 {  46,3156 }, {  47,3156 }, {  48,3156 }, {  49,3156 }, {  50,3156 },

 {  51,3156 }, {  52,3156 }, {  53,3156 }, {  54,3156 }, {  55,3156 },
 {  56,3156 }, {  57,3156 }, {  58,3156 }, {  59,3156 }, {  60,3156 },
 {  61,3156 }, {  62,3156 }, {  63,3156 }, {  64,3156 }, {  65,3156 },
 {  66,3156 }, {  67,3156 }, {  68,3156 }, {  69,3156 }, {  70,3156 },
 {  71,3156 }, {  72,3156 }, {  73,3156 }, {  74,3156 }, {  75,3156 },
 {  76,3156 }, {  77,3156 }, {  78,3156 }, {  79,3156 }, {  80,3156 },
 {  81,3156 }, {  82,3156 }, {  83,3156 }, {  84,3156 }, {  85,3156 },
 {  86,3156 }, {  87,3156 }, {  88,3156 }, {  89,3156 }, {  90,3156 },
 {  91,3156 }, {  92,3156 }, {  93,3156 }, {  94,3156 }, {  95,3156 },
 {  96,3156 }, {  97,3156 }, {  98,3156 }, {  99,3156 }, { 100,3156 },

 { 101,3156 }, { 102,3156 }, { 103,3156 }, { 104,3156 }, { 105,3156 },
 { 106,3156 }, { 107,3156 }, { 108,3156 }, { 109,3156 }, { 110,3156 },
 { 111,3156 }, { 112,3156 }, { 113,3156 }, { 114,3156 }, { 115,3156 },
 { 116,3156 }, { 117,3156 }, { 118,3156 }, { 119,3156 }, { 120,3156 },
 { 121,3156 }, { 122,3156 }, { 123,3156 }, { 124,3156 }, { 125,3156 },
 { 126,3156 }, { 127,3156 }, { 128,3156 }, { 129,3156 }, { 130,3156 },
 { 131,3156 }, { 132,3156 }, { 133,3156 }, { 134,3156 }, { 135,3156 },
 { 136,3156 }, { 137,3156 }, { 138,3156 }, { 139,3156 }, { 140,3156 },
 { 141,3156 }, { 142,3156 }, { 143,3156 }, { 144,3156 }, { 145,3156 },
 { 146,3156 }, { 147,3156 }, { 148,3156 }, { 149,3156 }, { 150,3156 },

 { 151,3156 }, { 152,3156 }, { 153,3156 }, { 154,3156 }, { 155,3156 },
 { 156,3156 }, { 157,3156 }, { 158,3156 }, { 159,3156 }, { 160,3156 },
 { 161,3156 }, { 162,3156 }, { 163,3156 }, { 164,3156 }, { 165,3156 },
 { 166,3156 }, { 167,3156 }, { 168,3156 }, { 169,3156 }, { 170,3156 },
 { 171,3156 }, { 172,3156 }, { 173,3156 }, { 174,3156 }, { 175,3156 },
 { 176,3156 }, { 177,3156 }, { 178,3156 }, { 179,3156 }, { 180,3156 },
 { 181,3156 }, { 182,3156 }, { 183,3156 }, { 184,3156 }, { 185,3156 },
 { 186,3156 }, { 187,3156 }, { 188,3156 }, { 189,3156 }, { 190,3156 },
 { 191,3156 }, { 192,3156 }, { 193,3156 }, { 194,3156 }, { 195,3156 },
 { 196,3156 }, { 197,3156 }, { 198,3156 }, { 199,3156 }, { 200,3156 },

 { 201,3156 }, { 202,3156 }, { 203,3156 }, { 204,3156 }, { 205,3156 },
 { 206,3156 }, { 207,3156 }, { 208,3156 }, { 209,3156 }, { 210,3156 },
 { 211,3156 }, { 212,3156 }, { 213,3156 }, { 214,3156 }, { 215,3156 },
 { 216,3156 }, { 217,3156 }, { 218,3156 }, { 219,3156 }, { 220,3156 },
 { 221,3156 }, { 222,3156 }, { 223,3156 }, { 224,3156 }, { 225,3156 },
 { 226,3156 }, { 227,3156 }, { 228,3156 }, { 229,3156 }, { 230,3156 },
 { 231,3156 }, { 232,3156 }, { 233,3156 }, { 234,3156 }, { 235,3156 },
 { 236,3156 }, { 237,3156 }, { 238,3156 }, { 239,3156 }, { 240,3156 },
 { 241,3156 }, { 242,3156 }, { 243,3156 }, { 244,3156 }, { 245,3156 },
 { 246,3156 }, { 247,3156 }, { 248,3156 }, { 249,3156 }, { 250,3156 },

 { 251,3156 }, { 252,3156 }, { 253,3156 }, { 254,3156 }, { 255,3156 },
 { 256,3156 }, {   0,  18 }, {   0,33570 }, {   1,2898 }, {   2,2898 },
 {   3,2898 }, {   4,2898 }, {   5,2898 }, {   6,2898 }, {   7,2898 },
 {   8,2898 }, {   9,7057 }, {  10,7062 }, {  11,7057 }, {  12,7057 },
 {  13,7086 }, {  14,2898 }, {  15,2898 }, {  16,2898 }, {  17,2898 },
 {  18,2898 }, {  19,2898 }, {  20,2898 }, {  21,2898 }, {  22,2898 },
 {  23,2898 }, {  24,2898 }, {  25,2898 }, {  26,2898 }, {  27,2898 },
 {  28,2898 }, {  29,2898 }, {  30,2898 }, {  31,2898 }, {  32,7057 },
 {  33,2898 }, {  34,2898 }, {  35,2898 }, {  36,2898 }, {  37,2898 },
 {  38,2898 }, {  39,2898 }, {  40,2898 }, {  41,2898 }, {  42,2898 },

 {  43,2898 }, {  44,2898 }, {  45,2900 }, {  46,2898 }, {  47,2898 },
 {  48,2898 }, {  49,2898 }, {  50,2898 }, {  51,2898 }, {  52,2898 },
 {  53,2898 }, {  54,2898 }, {  55,2898 }, {  56,2898 }, {  57,2898 },
 {  58,2898 }, {  59,2898 }, {  60,2898 }, {  61,2898 }, {  62,2898 },
 {  63,2898 }, {  64,2898 }, {  65,2898 }, {  66,2898 }, {  67,2898 },
 {  68,2898 }, {  69,2898 }, {  70,2898 }, {  71,2898 }, {  72,2898 },
 {  73,2898 }, {  74,2898 }, {  75,2898 }, {  76,2898 }, {  77,2898 },
 {  78,2898 }, {  79,2898 }, {  80,2898 }, {  81,2898 }, {  82,2898 },
 {  83,2898 }, {  84,2898 }, {  85,2898 }, {  86,2898 }, {  87,2898 },
 {  88,2898 }, {  89,2898 }, {  90,2898 }, {  91,2898 }, {  92,2898 },

 {  93,2898 }, {  94,2898 }, {  95,2898 }, {  96,2898 }, {  97,2898 },
 {  98,2898 }, {  99,2898 }, { 100,2898 }, { 101,2898 }, { 102,2898 },
 { 103,2898 }, { 104,2898 }, { 105,2898 }, { 106,2898 }, { 107,2898 },
 { 108,2898 }, { 109,2898 }, { 110,2898 }, { 111,2898 }, { 112,2898 },
 { 113,2898 }, { 114,2898 }, { 115,2898 }, { 116,2898 }, { 117,2898 },
 { 118,2898 }, { 119,2898 }, { 120,2898 }, { 121,2898 }, { 122,2898 },
 { 123,2898 }, { 124,2898 }, { 125,2898 }, { 126,2898 }, { 127,2898 },
 { 128,2898 }, { 129,2898 }, { 130,2898 }, { 131,2898 }, { 132,2898 },
 { 133,2898 }, { 134,2898 }, { 135,2898 }, { 136,2898 }, { 137,2898 },
 { 138,2898 }, { 139,2898 }, { 140,2898 }, { 141,2898 }, { 142,2898 },

 { 143,2898 }, { 144,2898 }, { 145,2898 }, { 146,2898 }, { 147,2898 },
 { 148,2898 }, { 149,2898 }, { 150,2898 }, { 151,2898 }, { 152,2898 },
 { 153,2898 }, { 154,2898 }, { 155,2898 }, { 156,2898 }, { 157,2898 },
 { 158,2898 }, { 159,2898 }, { 160,2898 }, { 161,2898 }, { 162,2898 },
 { 163,2898 }, { 164,2898 }, { 165,2898 }, { 166,2898 }, { 167,2898 },
 { 168,2898 }, { 169,2898 }, { 170,2898 }, { 171,2898 }, { 172,2898 },
 { 173,2898 }, { 174,2898 }, { 175,2898 }, { 176,2898 }, { 177,2898 },
 { 178,2898 }, { 179,2898 }, { 180,2898 }, { 181,2898 }, { 182,2898 },
 { 183,2898 }, { 184,2898 }, { 185,2898 }, { 186,2898 }, { 187,2898 },
 { 188,2898 }, { 189,2898 }, { 190,2898 }, { 191,2898 }, { 192,2898 },

 { 193,2898 }, { 194,2898 }, { 195,2898 }, { 196,2898 }, { 197,2898 },
 { 198,2898 }, { 199,2898 }, { 200,2898 }, { 201,2898 }, { 202,2898 },
 { 203,2898 }, { 204,2898 }, { 205,2898 }, { 206,2898 }, { 207,2898 },
 { 208,2898 }, { 209,2898 }, { 210,2898 }, { 211,2898 }, { 212,2898 },
 { 213,2898 }, { 214,2898 }, { 215,2898 }, { 216,2898 }, { 217,2898 },
 { 218,2898 }, { 219,2898 }, { 220,2898 }, { 221,2898 }, { 222,2898 },
 { 223,2898 }, { 224,2898 }, { 225,2898 }, { 226,2898 }, { 227,2898 },
 { 228,2898 }, { 229,2898 }, { 230,2898 }, { 231,2898 }, { 232,2898 },
 { 233,2898 }, { 234,2898 }, { 235,2898 }, { 236,2898 }, { 237,2898 },
 { 238,2898 }, { 239,2898 }, { 240,2898 }, { 241,2898 }, { 242,2898 },

 { 243,2898 }, { 244,2898 }, { 245,2898 }, { 246,2898 }, { 247,2898 },
 { 248,2898 }, { 249,2898 }, { 250,2898 }, { 251,2898 }, { 252,2898 },
 { 253,2898 }, { 254,2898 }, { 255,2898 }, { 256,2898 }, {   0,   0 },
 {   0,33312 }, {   1,6875 }, {   2,6875 }, {   3,6875 }, {   4,6875 },
 {   5,6875 }, {   6,6875 }, {   7,6875 }, {   8,6875 }, {   9,6875 },
 {  10,7133 }, {  11,6875 }, {  12,6875 }, {  13,6875 }, {  14,6875 },
 {  15,6875 }, {  16,6875 }, {  17,6875 }, {  18,6875 }, {  19,6875 },
 {  20,6875 }, {  21,6875 }, {  22,6875 }, {  23,6875 }, {  24,6875 },
 {  25,6875 }, {  26,6875 }, {  27,6875 }, {  28,6875 }, {  29,6875 },
 {  30,6875 }, {  31,6875 }, {  32,6875 }, {  33,6875 }, {  34,6875 },

 {  35,6875 }, {  36,6875 }, {  37,6875 }, {  38,6875 }, {  39,2645 },
 {  40,6875 }, {  41,6875 }, {  42,6875 }, {  43,6875 }, {  44,6875 },
 {  45,6875 }, {  46,6875 }, {  47,6875 }, {  48,6875 }, {  49,6875 },
 {  50,6875 }, {  51,6875 }, {  52,6875 }, {  53,6875 }, {  54,6875 },
 {  55,6875 }, {  56,6875 }, {  57,6875 }, {  58,6875 }, {  59,6875 },
 {  60,6875 }, {  61,6875 }, {  62,6875 }, {  63,6875 }, {  64,6875 },
 {  65,6875 }, {  66,6875 }, {  67,6875 }, {  68,6875 }, {  69,6875 },
 {  70,6875 }, {  71,6875 }, {  72,6875 }, {  73,6875 }, {  74,6875 },
 {  75,6875 }, {  76,6875 }, {  77,6875 }, {  78,6875 }, {  79,6875 },
 {  80,6875 }, {  81,6875 }, {  82,6875 }, {  83,6875 }, {  84,6875 },

 {  85,6875 }, {  86,6875 }, {  87,6875 }, {  88,6875 }, {  89,6875 },
 {  90,6875 }, {  91,6875 }, {  92,7391 }, {  93,6875 }, {  94,6875 },
 {  95,6875 }, {  96,6875 }, {  97,6875 }, {  98,6875 }, {  99,6875 },
 { 100,6875 }, { 101,6875 }, { 102,6875 }, { 103,6875 }, { 104,6875 },
 { 105,6875 }, { 106,6875 }, { 107,6875 }, { 108,6875 }, { 109,6875 },
 { 110,6875 }, { 111,6875 }, { 112,6875 }, { 113,6875 }, { 114,6875 },
 { 115,6875 }, { 116,6875 }, { 117,6875 }, { 118,6875 }, { 119,6875 },
 { 120,6875 }, { 121,6875 }, { 122,6875 }, { 123,6875 }, { 124,6875 },
 { 125,6875 }, { 126,6875 }, { 127,6875 }, { 128,6875 }, { 129,6875 },
 { 130,6875 }, { 131,6875 }, { 132,6875 }, { 133,6875 }, { 134,6875 },

 { 135,6875 }, { 136,6875 }, { 137,6875 }, { 138,6875 }, { 139,6875 },
 { 140,6875 }, { 141,6875 }, { 142,6875 }, { 143,6875 }, { 144,6875 },
 { 145,6875 }, { 146,6875 }, { 147,6875 }, { 148,6875 }, { 149,6875 },
 { 150,6875 }, { 151,6875 }, { 152,6875 }, { 153,6875 }, { 154,6875 },
 { 155,6875 }, { 156,6875 }, { 157,6875 }, { 158,6875 }, { 159,6875 },
 { 160,6875 }, { 161,6875 }, { 162,6875 }, { 163,6875 }, { 164,6875 },
 { 165,6875 }, { 166,6875 }, { 167,6875 }, { 168,6875 }, { 169,6875 },
 { 170,6875 }, { 171,6875 }, { 172,6875 }, { 173,6875 }, { 174,6875 },
 { 175,6875 }, { 176,6875 }, { 177,6875 }, { 178,6875 }, { 179,6875 },
 { 180,6875 }, { 181,6875 }, { 182,6875 }, { 183,6875 }, { 184,6875 },

 { 185,6875 }, { 186,6875 }, { 187,6875 }, { 188,6875 }, { 189,6875 },
 { 190,6875 }, { 191,6875 }, { 192,6875 }, { 193,6875 }, { 194,6875 },
 { 195,6875 }, { 196,6875 }, { 197,6875 }, { 198,6875 }, { 199,6875 },
 { 200,6875 }, { 201,6875 }, { 202,6875 }, { 203,6875 }, { 204,6875 },
 { 205,6875 }, { 206,6875 }, { 207,6875 }, { 208,6875 }, { 209,6875 },
 { 210,6875 }, { 211,6875 }, { 212,6875 }, { 213,6875 }, { 214,6875 },
 { 215,6875 }, { 216,6875 }, { 217,6875 }, { 218,6875 }, { 219,6875 },
 { 220,6875 }, { 221,6875 }, { 222,6875 }, { 223,6875 }, { 224,6875 },
 { 225,6875 }, { 226,6875 }, { 227,6875 }, { 228,6875 }, { 229,6875 },
 { 230,6875 }, { 231,6875 }, { 232,6875 }, { 233,6875 }, { 234,6875 },

 { 235,6875 }, { 236,6875 }, { 237,6875 }, { 238,6875 }, { 239,6875 },
 { 240,6875 }, { 241,6875 }, { 242,6875 }, { 243,6875 }, { 244,6875 },
 { 245,6875 }, { 246,6875 }, { 247,6875 }, { 248,6875 }, { 249,6875 },
 { 250,6875 }, { 251,6875 }, { 252,6875 }, { 253,6875 }, { 254,6875 },
 { 255,6875 }, { 256,6875 }, {   0,   0 }, {   0,33054 }, {   1,6617 },
 {   2,6617 }, {   3,6617 }, {   4,6617 }, {   5,6617 }, {   6,6617 },
 {   7,6617 }, {   8,6617 }, {   9,6617 }, {  10,6875 }, {  11,6617 },
 {  12,6617 }, {  13,6617 }, {  14,6617 }, {  15,6617 }, {  16,6617 },
 {  17,6617 }, {  18,6617 }, {  19,6617 }, {  20,6617 }, {  21,6617 },
 {  22,6617 }, {  23,6617 }, {  24,6617 }, {  25,6617 }, {  26,6617 },

 {  27,6617 }, {  28,6617 }, {  29,6617 }, {  30,6617 }, {  31,6617 },
 {  32,6617 }, {  33,6617 }, {  34,6617 }, {  35,6617 }, {  36,6617 },
 {  37,6617 }, {  38,6617 }, {  39,2387 }, {  40,6617 }, {  41,6617 },
 {  42,6617 }, {  43,6617 }, {  44,6617 }, {  45,6617 }, {  46,6617 },
 {  47,6617 }, {  48,6617 }, {  49,6617 }, {  50,6617 }, {  51,6617 },
 {  52,6617 }, {  53,6617 }, {  54,6617 }, {  55,6617 }, {  56,6617 },
 {  57,6617 }, {  58,6617 }, {  59,6617 }, {  60,6617 }, {  61,6617 },
 {  62,6617 }, {  63,6617 }, {  64,6617 }, {  65,6617 }, {  66,6617 },
 {  67,6617 }, {  68,6617 }, {  69,6617 }, {  70,6617 }, {  71,6617 },
 {  72,6617 }, {  73,6617 }, {  74,6617 }, {  75,6617 }, {  76,6617 },

 {  77,6617 }, {  78,6617 }, {  79,6617 }, {  80,6617 }, {  81,6617 },
 {  82,6617 }, {  83,6617 }, {  84,6617 }, {  85,6617 }, {  86,6617 },
 {  87,6617 }, {  88,6617 }, {  89,6617 }, {  90,6617 }, {  91,6617 },
 {  92,7133 }, {  93,6617 }, {  94,6617 }, {  95,6617 }, {  96,6617 },
 {  97,6617 }, {  98,6617 }, {  99,6617 }, { 100,6617 }, { 101,6617 },
 { 102,6617 }, { 103,6617 }, { 104,6617 }, { 105,6617 }, { 106,6617 },
 { 107,6617 }, { 108,6617 }, { 109,6617 }, { 110,6617 }, { 111,6617 },
 { 112,6617 }, { 113,6617 }, { 114,6617 }, { 115,6617 }, { 116,6617 },
 { 117,6617 }, { 118,6617 }, { 119,6617 }, { 120,6617 }, { 121,6617 },
 { 122,6617 }, { 123,6617 }, { 124,6617 }, { 125,6617 }, { 126,6617 },

 { 127,6617 }, { 128,6617 }, { 129,6617 }, { 130,6617 }, { 131,6617 },
 { 132,6617 }, { 133,6617 }, { 134,6617 }, { 135,6617 }, { 136,6617 },
 { 137,6617 }, { 138,6617 }, { 139,6617 }, { 140,6617 }, { 141,6617 },
 { 142,6617 }, { 143,6617 }, { 144,6617 }, { 145,6617 }, { 146,6617 },
 { 147,6617 }, { 148,6617 }, { 149,6617 }, { 150,6617 }, { 151,6617 },
 { 152,6617 }, { 153,6617 }, { 154,6617 }, { 155,6617 }, { 156,6617 },
 { 157,6617 }, { 158,6617 }, { 159,6617 }, { 160,6617 }, { 161,6617 },
 { 162,6617 }, { 163,6617 }, { 164,6617 }, { 165,6617 }, { 166,6617 },
 { 167,6617 }, { 168,6617 }, { 169,6617 }, { 170,6617 }, { 171,6617 },
 { 172,6617 }, { 173,6617 }, { 174,6617 }, { 175,6617 }, { 176,6617 },

 { 177,6617 }, { 178,6617 }, { 179,6617 }, { 180,6617 }, { 181,6617 },
 { 182,6617 }, { 183,6617 }, { 184,6617 }, { 185,6617 }, { 186,6617 },
 { 187,6617 }, { 188,6617 }, { 189,6617 }, { 190,6617 }, { 191,6617 },
 { 192,6617 }, { 193,6617 }, { 194,6617 }, { 195,6617 }, { 196,6617 },
 { 197,6617 }, { 198,6617 }, { 199,6617 }, { 200,6617 }, { 201,6617 },
 { 202,6617 }, { 203,6617 }, { 204,6617 }, { 205,6617 }, { 206,6617 },
 { 207,6617 }, { 208,6617 }, { 209,6617 }, { 210,6617 }, { 211,6617 },
 { 212,6617 }, { 213,6617 }, { 214,6617 }, { 215,6617 }, { 216,6617 },
 { 217,6617 }, { 218,6617 }, { 219,6617 }, { 220,6617 }, { 221,6617 },
 { 222,6617 }, { 223,6617 }, { 224,6617 }, { 225,6617 }, { 226,6617 },

 { 227,6617 }, { 228,6617 }, { 229,6617 }, { 230,6617 }, { 231,6617 },
 { 232,6617 }, { 233,6617 }, { 234,6617 }, { 235,6617 }, { 236,6617 },
 { 237,6617 }, { 238,6617 }, { 239,6617 }, { 240,6617 }, { 241,6617 },
 { 242,6617 }, { 243,6617 }, { 244,6617 }, { 245,6617 }, { 246,6617 },
 { 247,6617 }, { 248,6617 }, { 249,6617 }, { 250,6617 }, { 251,6617 },
 { 252,6617 }, { 253,6617 }, { 254,6617 }, { 255,6617 }, { 256,6617 },
 {   0,   0 }, {   0,32796 }, {   1,7133 }, {   2,7133 }, {   3,7133 },
 {   4,7133 }, {   5,7133 }, {   6,7133 }, {   7,7133 }, {   8,7133 },
 {   9,7133 }, {  10,7391 }, {  11,7133 }, {  12,7133 }, {  13,7133 },
 {  14,7133 }, {  15,7133 }, {  16,7133 }, {  17,7133 }, {  18,7133 },

 {  19,7133 }, {  20,7133 }, {  21,7133 }, {  22,7133 }, {  23,7133 },
 {  24,7133 }, {  25,7133 }, {  26,7133 }, {  27,7133 }, {  28,7133 },
 {  29,7133 }, {  30,7133 }, {  31,7133 }, {  32,7133 }, {  33,7133 },
 {  34,7133 }, {  35,7133 }, {  36,7649 }, {  37,7133 }, {  38,7133 },
 {  39,7133 }, {  40,7133 }, {  41,7133 }, {  42,7133 }, {  43,7133 },
 {  44,7133 }, {  45,7133 }, {  46,7133 }, {  47,7133 }, {  48,7133 },
 {  49,7133 }, {  50,7133 }, {  51,7133 }, {  52,7133 }, {  53,7133 },
 {  54,7133 }, {  55,7133 }, {  56,7133 }, {  57,7133 }, {  58,7133 },
 {  59,7133 }, {  60,7133 }, {  61,7133 }, {  62,7133 }, {  63,7133 },
 {  64,7133 }, {  65,7133 }, {  66,7133 }, {  67,7133 }, {  68,7133 },

 {  69,7133 }, {  70,7133 }, {  71,7133 }, {  72,7133 }, {  73,7133 },
 {  74,7133 }, {  75,7133 }, {  76,7133 }, {  77,7133 }, {  78,7133 },
 {  79,7133 }, {  80,7133 }, {  81,7133 }, {  82,7133 }, {  83,7133 },
 {  84,7133 }, {  85,7133 }, {  86,7133 }, {  87,7133 }, {  88,7133 },
 {  89,7133 }, {  90,7133 }, {  91,7133 }, {  92,7133 }, {  93,7133 },
 {  94,7133 }, {  95,7133 }, {  96,7133 }, {  97,7133 }, {  98,7133 },
 {  99,7133 }, { 100,7133 }, { 101,7133 }, { 102,7133 }, { 103,7133 },
 { 104,7133 }, { 105,7133 }, { 106,7133 }, { 107,7133 }, { 108,7133 },
 { 109,7133 }, { 110,7133 }, { 111,7133 }, { 112,7133 }, { 113,7133 },
 { 114,7133 }, { 115,7133 }, { 116,7133 }, { 117,7133 }, { 118,7133 },

 { 119,7133 }, { 120,7133 }, { 121,7133 }, { 122,7133 }, { 123,7133 },
 { 124,7133 }, { 125,7133 }, { 126,7133 }, { 127,7133 }, { 128,7133 },
 { 129,7133 }, { 130,7133 }, { 131,7133 }, { 132,7133 }, { 133,7133 },
 { 134,7133 }, { 135,7133 }, { 136,7133 }, { 137,7133 }, { 138,7133 },
 { 139,7133 }, { 140,7133 }, { 141,7133 }, { 142,7133 }, { 143,7133 },
 { 144,7133 }, { 145,7133 }, { 146,7133 }, { 147,7133 }, { 148,7133 },
 { 149,7133 }, { 150,7133 }, { 151,7133 }, { 152,7133 }, { 153,7133 },
 { 154,7133 }, { 155,7133 }, { 156,7133 }, { 157,7133 }, { 158,7133 },
 { 159,7133 }, { 160,7133 }, { 161,7133 }, { 162,7133 }, { 163,7133 },
 { 164,7133 }, { 165,7133 }, { 166,7133 }, { 167,7133 }, { 168,7133 },

 { 169,7133 }, { 170,7133 }, { 171,7133 }, { 172,7133 }, { 173,7133 },
 { 174,7133 }, { 175,7133 }, { 176,7133 }, { 177,7133 }, { 178,7133 },
 { 179,7133 }, { 180,7133 }, { 181,7133 }, { 182,7133 }, { 183,7133 },
 { 184,7133 }, { 185,7133 }, { 186,7133 }, { 187,7133 }, { 188,7133 },
 { 189,7133 }, { 190,7133 }, { 191,7133 }, { 192,7133 }, { 193,7133 },
 { 194,7133 }, { 195,7133 }, { 196,7133 }, { 197,7133 }, { 198,7133 },
 { 199,7133 }, { 200,7133 }, { 201,7133 }, { 202,7133 }, { 203,7133 },
 { 204,7133 }, { 205,7133 }, { 206,7133 }, { 207,7133 }, { 208,7133 },
 { 209,7133 }, { 210,7133 }, { 211,7133 }, { 212,7133 }, { 213,7133 },
 { 214,7133 }, { 215,7133 }, { 216,7133 }, { 217,7133 }, { 218,7133 },

 { 219,7133 }, { 220,7133 }, { 221,7133 }, { 222,7133 }, { 223,7133 },
 { 224,7133 }, { 225,7133 }, { 226,7133 }, { 227,7133 }, { 228,7133 },
 { 229,7133 }, { 230,7133 }, { 231,7133 }, { 232,7133 }, { 233,7133 },
 { 234,7133 }, { 235,7133 }, { 236,7133 }, { 237,7133 }, { 238,7133 },
 { 239,7133 }, { 240,7133 }, { 241,7133 }, { 242,7133 }, { 243,7133 },
 { 244,7133 }, { 245,7133 }, { 246,7133 }, { 247,7133 }, { 248,7133 },
 { 249,7133 }, { 250,7133 }, { 251,7133 }, { 252,7133 }, { 253,7133 },
 { 254,7133 }, { 255,7133 }, { 256,7133 }, {   0,   0 }, {   0,32538 },
 {   1,6875 }, {   2,6875 }, {   3,6875 }, {   4,6875 }, {   5,6875 },
 {   6,6875 }, {   7,6875 }, {   8,6875 }, {   9,6875 }, {  10,7133 },

 {  11,6875 }, {  12,6875 }, {  13,6875 }, {  14,6875 }, {  15,6875 },
 {  16,6875 }, {  17,6875 }, {  18,6875 }, {  19,6875 }, {  20,6875 },
 {  21,6875 }, {  22,6875 }, {  23,6875 }, {  24,6875 }, {  25,6875 },
 {  26,6875 }, {  27,6875 }, {  28,6875 }, {  29,6875 }, {  30,6875 },
 {  31,6875 }, {  32,6875 }, {  33,6875 }, {  34,6875 }, {  35,6875 },
 {  36,7391 }, {  37,6875 }, {  38,6875 }, {  39,6875 }, {  40,6875 },
 {  41,6875 }, {  42,6875 }, {  43,6875 }, {  44,6875 }, {  45,6875 },
 {  46,6875 }, {  47,6875 }, {  48,6875 }, {  49,6875 }, {  50,6875 },
 {  51,6875 }, {  52,6875 }, {  53,6875 }, {  54,6875 }, {  55,6875 },
 {  56,6875 }, {  57,6875 }, {  58,6875 }, {  59,6875 }, {  60,6875 },

 {  61,6875 }, {  62,6875 }, {  63,6875 }, {  64,6875 }, {  65,6875 },
 {  66,6875 }, {  67,6875 }, {  68,6875 }, {  69,6875 }, {  70,6875 },
 {  71,6875 }, {  72,6875 }, {  73,6875 }, {  74,6875 }, {  75,6875 },
 {  76,6875 }, {  77,6875 }, {  78,6875 }, {  79,6875 }, {  80,6875 },
 {  81,6875 }, {  82,6875 }, {  83,6875 }, {  84,6875 }, {  85,6875 },
 {  86,6875 }, {  87,6875 }, {  88,6875 }, {  89,6875 }, {  90,6875 },
 {  91,6875 }, {  92,6875 }, {  93,6875 }, {  94,6875 }, {  95,6875 },
 {  96,6875 }, {  97,6875 }, {  98,6875 }, {  99,6875 }, { 100,6875 },
 { 101,6875 }, { 102,6875 }, { 103,6875 }, { 104,6875 }, { 105,6875 },
 { 106,6875 }, { 107,6875 }, { 108,6875 }, { 109,6875 }, { 110,6875 },

 { 111,6875 }, { 112,6875 }, { 113,6875 }, { 114,6875 }, { 115,6875 },
 { 116,6875 }, { 117,6875 }, { 118,6875 }, { 119,6875 }, { 120,6875 },
 { 121,6875 }, { 122,6875 }, { 123,6875 }, { 124,6875 }, { 125,6875 },
 { 126,6875 }, { 127,6875 }, { 128,6875 }, { 129,6875 }, { 130,6875 },
 { 131,6875 }, { 132,6875 }, { 133,6875 }, { 134,6875 }, { 135,6875 },
 { 136,6875 }, { 137,6875 }, { 138,6875 }, { 139,6875 }, { 140,6875 },
 { 141,6875 }, { 142,6875 }, { 143,6875 }, { 144,6875 }, { 145,6875 },
 { 146,6875 }, { 147,6875 }, { 148,6875 }, { 149,6875 }, { 150,6875 },
 { 151,6875 }, { 152,6875 }, { 153,6875 }, { 154,6875 }, { 155,6875 },
 { 156,6875 }, { 157,6875 }, { 158,6875 }, { 159,6875 }, { 160,6875 },

 { 161,6875 }, { 162,6875 }, { 163,6875 }, { 164,6875 }, { 165,6875 },
 { 166,6875 }, { 167,6875 }, { 168,6875 }, { 169,6875 }, { 170,6875 },
 { 171,6875 }, { 172,6875 }, { 173,6875 }, { 174,6875 }, { 175,6875 },
 { 176,6875 }, { 177,6875 }, { 178,6875 }, { 179,6875 }, { 180,6875 },
 { 181,6875 }, { 182,6875 }, { 183,6875 }, { 184,6875 }, { 185,6875 },
 { 186,6875 }, { 187,6875 }, { 188,6875 }, { 189,6875 }, { 190,6875 },
 { 191,6875 }, { 192,6875 }, { 193,6875 }, { 194,6875 }, { 195,6875 },
 { 196,6875 }, { 197,6875 }, { 198,6875 }, { 199,6875 }, { 200,6875 },
 { 201,6875 }, { 202,6875 }, { 203,6875 }, { 204,6875 }, { 205,6875 },
 { 206,6875 }, { 207,6875 }, { 208,6875 }, { 209,6875 }, { 210,6875 },

 { 211,6875 }, { 212,6875 }, { 213,6875 }, { 214,6875 }, { 215,6875 },
 { 216,6875 }, { 217,6875 }, { 218,6875 }, { 219,6875 }, { 220,6875 },
 { 221,6875 }, { 222,6875 }, { 223,6875 }, { 224,6875 }, { 225,6875 },
 { 226,6875 }, { 227,6875 }, { 228,6875 }, { 229,6875 }, { 230,6875 },
 { 231,6875 }, { 232,6875 }, { 233,6875 }, { 234,6875 }, { 235,6875 },
 { 236,6875 }, { 237,6875 }, { 238,6875 }, { 239,6875 }, { 240,6875 },
 { 241,6875 }, { 242,6875 }, { 243,6875 }, { 244,6875 }, { 245,6875 },
 { 246,6875 }, { 247,6875 }, { 248,6875 }, { 249,6875 }, { 250,6875 },
 { 251,6875 }, { 252,6875 }, { 253,6875 }, { 254,6875 }, { 255,6875 },
 { 256,6875 }, {   0,   0 }, {   0,32280 }, {   1,4993 }, {   2,4993 },

 {   3,4993 }, {   4,4993 }, {   5,4993 }, {   6,4993 }, {   7,4993 },
 {   8,4993 }, {   9,4993 }, {  10,4993 }, {  11,4993 }, {  12,4993 },
 {  13,4993 }, {  14,4993 }, {  15,4993 }, {  16,4993 }, {  17,4993 },
 {  18,4993 }, {  19,4993 }, {  20,4993 }, {  21,4993 }, {  22,4993 },
 {  23,4993 }, {  24,4993 }, {  25,4993 }, {  26,4993 }, {  27,4993 },
 {  28,4993 }, {  29,4993 }, {  30,4993 }, {  31,4993 }, {  32,4993 },
 {  33,4993 }, {  34,1615 }, {  35,4993 }, {  36,4993 }, {  37,4993 },
 {  38,4993 }, {  39,4993 }, {  40,4993 }, {  41,4993 }, {  42,4993 },
 {  43,4993 }, {  44,4993 }, {  45,4993 }, {  46,4993 }, {  47,4993 },
 {  48,4993 }, {  49,4993 }, {  50,4993 }, {  51,4993 }, {  52,4993 },

 {  53,4993 }, {  54,4993 }, {  55,4993 }, {  56,4993 }, {  57,4993 },
 {  58,4993 }, {  59,4993 }, {  60,4993 }, {  61,4993 }, {  62,4993 },
 {  63,4993 }, {  64,4993 }, {  65,4993 }, {  66,4993 }, {  67,4993 },
 {  68,4993 }, {  69,4993 }, {  70,4993 }, {  71,4993 }, {  72,4993 },
 {  73,4993 }, {  74,4993 }, {  75,4993 }, {  76,4993 }, {  77,4993 },
 {  78,4993 }, {  79,4993 }, {  80,4993 }, {  81,4993 }, {  82,4993 },
 {  83,4993 }, {  84,4993 }, {  85,4993 }, {  86,4993 }, {  87,4993 },
 {  88,4993 }, {  89,4993 }, {  90,4993 }, {  91,4993 }, {  92,4993 },
 {  93,4993 }, {  94,4993 }, {  95,4993 }, {  96,4993 }, {  97,4993 },
 {  98,4993 }, {  99,4993 }, { 100,4993 }, { 101,4993 }, { 102,4993 },

 { 103,4993 }, { 104,4993 }, { 105,4993 }, { 106,4993 }, { 107,4993 },
 { 108,4993 }, { 109,4993 }, { 110,4993 }, { 111,4993 }, { 112,4993 },
 { 113,4993 }, { 114,4993 }, { 115,4993 }, { 116,4993 }, { 117,4993 },
 { 118,4993 }, { 119,4993 }, { 120,4993 }, { 121,4993 }, { 122,4993 },
 { 123,4993 }, { 124,4993 }, { 125,4993 }, { 126,4993 }, { 127,4993 },
 { 128,4993 }, { 129,4993 }, { 130,4993 }, { 131,4993 }, { 132,4993 },
 { 133,4993 }, { 134,4993 }, { 135,4993 }, { 136,4993 }, { 137,4993 },
 { 138,4993 }, { 139,4993 }, { 140,4993 }, { 141,4993 }, { 142,4993 },
 { 143,4993 }, { 144,4993 }, { 145,4993 }, { 146,4993 }, { 147,4993 },
 { 148,4993 }, { 149,4993 }, { 150,4993 }, { 151,4993 }, { 152,4993 },

 { 153,4993 }, { 154,4993 }, { 155,4993 }, { 156,4993 }, { 157,4993 },
 { 158,4993 }, { 159,4993 }, { 160,4993 }, { 161,4993 }, { 162,4993 },
 { 163,4993 }, { 164,4993 }, { 165,4993 }, { 166,4993 }, { 167,4993 },
 { 168,4993 }, { 169,4993 }, { 170,4993 }, { 171,4993 }, { 172,4993 },
 { 173,4993 }, { 174,4993 }, { 175,4993 }, { 176,4993 }, { 177,4993 },
 { 178,4993 }, { 179,4993 }, { 180,4993 }, { 181,4993 }, { 182,4993 },
 { 183,4993 }, { 184,4993 }, { 185,4993 }, { 186,4993 }, { 187,4993 },
 { 188,4993 }, { 189,4993 }, { 190,4993 }, { 191,4993 }, { 192,4993 },
 { 193,4993 }, { 194,4993 }, { 195,4993 }, { 196,4993 }, { 197,4993 },
 { 198,4993 }, { 199,4993 }, { 200,4993 }, { 201,4993 }, { 202,4993 },

 { 203,4993 }, { 204,4993 }, { 205,4993 }, { 206,4993 }, { 207,4993 },
 { 208,4993 }, { 209,4993 }, { 210,4993 }, { 211,4993 }, { 212,4993 },
 { 213,4993 }, { 214,4993 }, { 215,4993 }, { 216,4993 }, { 217,4993 },
 { 218,4993 }, { 219,4993 }, { 220,4993 }, { 221,4993 }, { 222,4993 },
 { 223,4993 }, { 224,4993 }, { 225,4993 }, { 226,4993 }, { 227,4993 },
 { 228,4993 }, { 229,4993 }, { 230,4993 }, { 231,4993 }, { 232,4993 },
 { 233,4993 }, { 234,4993 }, { 235,4993 }, { 236,4993 }, { 237,4993 },
 { 238,4993 }, { 239,4993 }, { 240,4993 }, { 241,4993 }, { 242,4993 },
 { 243,4993 }, { 244,4993 }, { 245,4993 }, { 246,4993 }, { 247,4993 },
 { 248,4993 }, { 249,4993 }, { 250,4993 }, { 251,4993 }, { 252,4993 },

 { 253,4993 }, { 254,4993 }, { 255,4993 }, { 256,4993 }, {   0,   0 },
 {   0,32022 }, {   1,4735 }, {   2,4735 }, {   3,4735 }, {   4,4735 },
 {   5,4735 }, {   6,4735 }, {   7,4735 }, {   8,4735 }, {   9,4735 },
 {  10,4735 }, {  11,4735 }, {  12,4735 }, {  13,4735 }, {  14,4735 },
 {  15,4735 }, {  16,4735 }, {  17,4735 }, {  18,4735 }, {  19,4735 },
 {  20,4735 }, {  21,4735 }, {  22,4735 }, {  23,4735 }, {  24,4735 },
 {  25,4735 }, {  26,4735 }, {  27,4735 }, {  28,4735 }, {  29,4735 },
 {  30,4735 }, {  31,4735 }, {  32,4735 }, {  33,4735 }, {  34,1357 },
 {  35,4735 }, {  36,4735 }, {  37,4735 }, {  38,4735 }, {  39,4735 },
 {  40,4735 }, {  41,4735 }, {  42,4735 }, {  43,4735 }, {  44,4735 },

 {  45,4735 }, {  46,4735 }, {  47,4735 }, {  48,4735 }, {  49,4735 },
 {  50,4735 }, {  51,4735 }, {  52,4735 }, {  53,4735 }, {  54,4735 },
 {  55,4735 }, {  56,4735 }, {  57,4735 }, {  58,4735 }, {  59,4735 },
 {  60,4735 }, {  61,4735 }, {  62,4735 }, {  63,4735 }, {  64,4735 },
 {  65,4735 }, {  66,4735 }, {  67,4735 }, {  68,4735 }, {  69,4735 },
 {  70,4735 }, {  71,4735 }, {  72,4735 }, {  73,4735 }, {  74,4735 },
 {  75,4735 }, {  76,4735 }, {  77,4735 }, {  78,4735 }, {  79,4735 },
 {  80,4735 }, {  81,4735 }, {  82,4735 }, {  83,4735 }, {  84,4735 },
 {  85,4735 }, {  86,4735 }, {  87,4735 }, {  88,4735 }, {  89,4735 },
 {  90,4735 }, {  91,4735 }, {  92,4735 }, {  93,4735 }, {  94,4735 },

 {  95,4735 }, {  96,4735 }, {  97,4735 }, {  98,4735 }, {  99,4735 },
 { 100,4735 }, { 101,4735 }, { 102,4735 }, { 103,4735 }, { 104,4735 },
 { 105,4735 }, { 106,4735 }, { 107,4735 }, { 108,4735 }, { 109,4735 },
 { 110,4735 }, { 111,4735 }, { 112,4735 }, { 113,4735 }, { 114,4735 },
 { 115,4735 }, { 116,4735 }, { 117,4735 }, { 118,4735 }, { 119,4735 },
 { 120,4735 }, { 121,4735 }, { 122,4735 }, { 123,4735 }, { 124,4735 },
 { 125,4735 }, { 126,4735 }, { 127,4735 }, { 128,4735 }, { 129,4735 },
 { 130,4735 }, { 131,4735 }, { 132,4735 }, { 133,4735 }, { 134,4735 },
 { 135,4735 }, { 136,4735 }, { 137,4735 }, { 138,4735 }, { 139,4735 },
 { 140,4735 }, { 141,4735 }, { 142,4735 }, { 143,4735 }, { 144,4735 },

 { 145,4735 }, { 146,4735 }, { 147,4735 }, { 148,4735 }, { 149,4735 },
 { 150,4735 }, { 151,4735 }, { 152,4735 }, { 153,4735 }, { 154,4735 },
 { 155,4735 }, { 156,4735 }, { 157,4735 }, { 158,4735 }, { 159,4735 },
 { 160,4735 }, { 161,4735 }, { 162,4735 }, { 163,4735 }, { 164,4735 },
 { 165,4735 }, { 166,4735 }, { 167,4735 }, { 168,4735 }, { 169,4735 },
 { 170,4735 }, { 171,4735 }, { 172,4735 }, { 173,4735 }, { 174,4735 },
 { 175,4735 }, { 176,4735 }, { 177,4735 }, { 178,4735 }, { 179,4735 },
 { 180,4735 }, { 181,4735 }, { 182,4735 }, { 183,4735 }, { 184,4735 },
 { 185,4735 }, { 186,4735 }, { 187,4735 }, { 188,4735 }, { 189,4735 },
 { 190,4735 }, { 191,4735 }, { 192,4735 }, { 193,4735 }, { 194,4735 },

 { 195,4735 }, { 196,4735 }, { 197,4735 }, { 198,4735 }, { 199,4735 },
 { 200,4735 }, { 201,4735 }, { 202,4735 }, { 203,4735 }, { 204,4735 },
 { 205,4735 }, { 206,4735 }, { 207,4735 }, { 208,4735 }, { 209,4735 },
 { 210,4735 }, { 211,4735 }, { 212,4735 }, { 213,4735 }, { 214,4735 },
 { 215,4735 }, { 216,4735 }, { 217,4735 }, { 218,4735 }, { 219,4735 },
 { 220,4735 }, { 221,4735 }, { 222,4735 }, { 223,4735 }, { 224,4735 },
 { 225,4735 }, { 226,4735 }, { 227,4735 }, { 228,4735 }, { 229,4735 },
 { 230,4735 }, { 231,4735 }, { 232,4735 }, { 233,4735 }, { 234,4735 },
 { 235,4735 }, { 236,4735 }, { 237,4735 }, { 238,4735 }, { 239,4735 },
 { 240,4735 }, { 241,4735 }, { 242,4735 }, { 243,4735 }, { 244,4735 },

 { 245,4735 }, { 246,4735 }, { 247,4735 }, { 248,4735 }, { 249,4735 },
 { 250,4735 }, { 251,4735 }, { 252,4735 }, { 253,4735 }, { 254,4735 },
 { 255,4735 }, { 256,4735 }, {   0,   0 }, {   0,31764 }, {   1,4993 },
 {   2,4993 }, {   3,4993 }, {   4,4993 }, {   5,4993 }, {   6,4993 },
 {   7,4993 }, {   8,4993 }, {   9,4993 }, {  10,4993 }, {  11,4993 },
 {  12,4993 }, {  13,4993 }, {  14,4993 }, {  15,4993 }, {  16,4993 },
 {  17,4993 }, {  18,4993 }, {  19,4993 }, {  20,4993 }, {  21,4993 },
 {  22,4993 }, {  23,4993 }, {  24,4993 }, {  25,4993 }, {  26,4993 },
 {  27,4993 }, {  28,4993 }, {  29,4993 }, {  30,4993 }, {  31,4993 },
 {  32,4993 }, {  33,4993 }, {  34,4993 }, {  35,4993 }, {  36,4993 },

 {  37,4993 }, {  38,4993 }, {  39,1090 }, {  40,4993 }, {  41,4993 },
 {  42,4993 }, {  43,4993 }, {  44,4993 }, {  45,4993 }, {  46,4993 },
 {  47,4993 }, {  48,4993 }, {  49,4993 }, {  50,4993 }, {  51,4993 },
 {  52,4993 }, {  53,4993 }, {  54,4993 }, {  55,4993 }, {  56,4993 },
 {  57,4993 }, {  58,4993 }, {  59,4993 }, {  60,4993 }, {  61,4993 },
 {  62,4993 }, {  63,4993 }, {  64,4993 }, {  65,4993 }, {  66,4993 },
 {  67,4993 }, {  68,4993 }, {  69,4993 }, {  70,4993 }, {  71,4993 },
 {  72,4993 }, {  73,4993 }, {  74,4993 }, {  75,4993 }, {  76,4993 },
 {  77,4993 }, {  78,4993 }, {  79,4993 }, {  80,4993 }, {  81,4993 },
 {  82,4993 }, {  83,4993 }, {  84,4993 }, {  85,4993 }, {  86,4993 },

 {  87,4993 }, {  88,4993 }, {  89,4993 }, {  90,4993 }, {  91,4993 },
 {  92,4993 }, {  93,4993 }, {  94,4993 }, {  95,4993 }, {  96,4993 },
 {  97,4993 }, {  98,4993 }, {  99,4993 }, { 100,4993 }, { 101,4993 },
 { 102,4993 }, { 103,4993 }, { 104,4993 }, { 105,4993 }, { 106,4993 },
 { 107,4993 }, { 108,4993 }, { 109,4993 }, { 110,4993 }, { 111,4993 },
 { 112,4993 }, { 113,4993 }, { 114,4993 }, { 115,4993 }, { 116,4993 },
 { 117,4993 }, { 118,4993 }, { 119,4993 }, { 120,4993 }, { 121,4993 },
 { 122,4993 }, { 123,4993 }, { 124,4993 }, { 125,4993 }, { 126,4993 },
 { 127,4993 }, { 128,4993 }, { 129,4993 }, { 130,4993 }, { 131,4993 },
 { 132,4993 }, { 133,4993 }, { 134,4993 }, { 135,4993 }, { 136,4993 },

 { 137,4993 }, { 138,4993 }, { 139,4993 }, { 140,4993 }, { 141,4993 },
 { 142,4993 }, { 143,4993 }, { 144,4993 }, { 145,4993 }, { 146,4993 },
 { 147,4993 }, { 148,4993 }, { 149,4993 }, { 150,4993 }, { 151,4993 },
 { 152,4993 }, { 153,4993 }, { 154,4993 }, { 155,4993 }, { 156,4993 },
 { 157,4993 }, { 158,4993 }, { 159,4993 }, { 160,4993 }, { 161,4993 },
 { 162,4993 }, { 163,4993 }, { 164,4993 }, { 165,4993 }, { 166,4993 },
 { 167,4993 }, { 168,4993 }, { 169,4993 }, { 170,4993 }, { 171,4993 },
 { 172,4993 }, { 173,4993 }, { 174,4993 }, { 175,4993 }, { 176,4993 },
 { 177,4993 }, { 178,4993 }, { 179,4993 }, { 180,4993 }, { 181,4993 },
 { 182,4993 }, { 183,4993 }, { 184,4993 }, { 185,4993 }, { 186,4993 },

 { 187,4993 }, { 188,4993 }, { 189,4993 }, { 190,4993 }, { 191,4993 },
 { 192,4993 }, { 193,4993 }, { 194,4993 }, { 195,4993 }, { 196,4993 },
 { 197,4993 }, { 198,4993 }, { 199,4993 }, { 200,4993 }, { 201,4993 },
 { 202,4993 }, { 203,4993 }, { 204,4993 }, { 205,4993 }, { 206,4993 },
 { 207,4993 }, { 208,4993 }, { 209,4993 }, { 210,4993 }, { 211,4993 },
 { 212,4993 }, { 213,4993 }, { 214,4993 }, { 215,4993 }, { 216,4993 },
 { 217,4993 }, { 218,4993 }, { 219,4993 }, { 220,4993 }, { 221,4993 },
 { 222,4993 }, { 223,4993 }, { 224,4993 }, { 225,4993 }, { 226,4993 },
 { 227,4993 }, { 228,4993 }, { 229,4993 }, { 230,4993 }, { 231,4993 },
 { 232,4993 }, { 233,4993 }, { 234,4993 }, { 235,4993 }, { 236,4993 },

 { 237,4993 }, { 238,4993 }, { 239,4993 }, { 240,4993 }, { 241,4993 },
 { 242,4993 }, { 243,4993 }, { 244,4993 }, { 245,4993 }, { 246,4993 },
 { 247,4993 }, { 248,4993 }, { 249,4993 }, { 250,4993 }, { 251,4993 },
 { 252,4993 }, { 253,4993 }, { 254,4993 }, { 255,4993 }, { 256,4993 },
 {   0,   0 }, {   0,31506 }, {   1,4735 }, {   2,4735 }, {   3,4735 },
 {   4,4735 }, {   5,4735 }, {   6,4735 }, {   7,4735 }, {   8,4735 },
 {   9,4735 }, {  10,4735 }, {  11,4735 }, {  12,4735 }, {  13,4735 },
 {  14,4735 }, {  15,4735 }, {  16,4735 }, {  17,4735 }, {  18,4735 },
 {  19,4735 }, {  20,4735 }, {  21,4735 }, {  22,4735 }, {  23,4735 },
 {  24,4735 }, {  25,4735 }, {  26,4735 }, {  27,4735 }, {  28,4735 },

 {  29,4735 }, {  30,4735 }, {  31,4735 }, {  32,4735 }, {  33,4735 },
 {  34,4735 }, {  35,4735 }, {  36,4735 }, {  37,4735 }, {  38,4735 },
 {  39, 832 }, {  40,4735 }, {  41,4735 }, {  42,4735 }, {  43,4735 },
 {  44,4735 }, {  45,4735 }, {  46,4735 }, {  47,4735 }, {  48,4735 },
 {  49,4735 }, {  50,4735 }, {  51,4735 }, {  52,4735 }, {  53,4735 },
 {  54,4735 }, {  55,4735 }, {  56,4735 }, {  57,4735 }, {  58,4735 },
 {  59,4735 }, {  60,4735 }, {  61,4735 }, {  62,4735 }, {  63,4735 },
 {  64,4735 }, {  65,4735 }, {  66,4735 }, {  67,4735 }, {  68,4735 },
 {  69,4735 }, {  70,4735 }, {  71,4735 }, {  72,4735 }, {  73,4735 },
 {  74,4735 }, {  75,4735 }, {  76,4735 }, {  77,4735 }, {  78,4735 },

 {  79,4735 }, {  80,4735 }, {  81,4735 }, {  82,4735 }, {  83,4735 },
 {  84,4735 }, {  85,4735 }, {  86,4735 }, {  87,4735 }, {  88,4735 },
 {  89,4735 }, {  90,4735 }, {  91,4735 }, {  92,4735 }, {  93,4735 },
 {  94,4735 }, {  95,4735 }, {  96,4735 }, {  97,4735 }, {  98,4735 },
 {  99,4735 }, { 100,4735 }, { 101,4735 }, { 102,4735 }, { 103,4735 },
 { 104,4735 }, { 105,4735 }, { 106,4735 }, { 107,4735 }, { 108,4735 },
 { 109,4735 }, { 110,4735 }, { 111,4735 }, { 112,4735 }, { 113,4735 },
 { 114,4735 }, { 115,4735 }, { 116,4735 }, { 117,4735 }, { 118,4735 },
 { 119,4735 }, { 120,4735 }, { 121,4735 }, { 122,4735 }, { 123,4735 },
 { 124,4735 }, { 125,4735 }, { 126,4735 }, { 127,4735 }, { 128,4735 },

 { 129,4735 }, { 130,4735 }, { 131,4735 }, { 132,4735 }, { 133,4735 },
 { 134,4735 }, { 135,4735 }, { 136,4735 }, { 137,4735 }, { 138,4735 },
 { 139,4735 }, { 140,4735 }, { 141,4735 }, { 142,4735 }, { 143,4735 },
 { 144,4735 }, { 145,4735 }, { 146,4735 }, { 147,4735 }, { 148,4735 },
 { 149,4735 }, { 150,4735 }, { 151,4735 }, { 152,4735 }, { 153,4735 },
 { 154,4735 }, { 155,4735 }, { 156,4735 }, { 157,4735 }, { 158,4735 },
 { 159,4735 }, { 160,4735 }, { 161,4735 }, { 162,4735 }, { 163,4735 },
 { 164,4735 }, { 165,4735 }, { 166,4735 }, { 167,4735 }, { 168,4735 },
 { 169,4735 }, { 170,4735 }, { 171,4735 }, { 172,4735 }, { 173,4735 },
 { 174,4735 }, { 175,4735 }, { 176,4735 }, { 177,4735 }, { 178,4735 },

 { 179,4735 }, { 180,4735 }, { 181,4735 }, { 182,4735 }, { 183,4735 },
 { 184,4735 }, { 185,4735 }, { 186,4735 }, { 187,4735 }, { 188,4735 },
 { 189,4735 }, { 190,4735 }, { 191,4735 }, { 192,4735 }, { 193,4735 },
 { 194,4735 }, { 195,4735 }, { 196,4735 }, { 197,4735 }, { 198,4735 },
 { 199,4735 }, { 200,4735 }, { 201,4735 }, { 202,4735 }, { 203,4735 },
 { 204,4735 }, { 205,4735 }, { 206,4735 }, { 207,4735 }, { 208,4735 },
 { 209,4735 }, { 210,4735 }, { 211,4735 }, { 212,4735 }, { 213,4735 },
 { 214,4735 }, { 215,4735 }, { 216,4735 }, { 217,4735 }, { 218,4735 },
 { 219,4735 }, { 220,4735 }, { 221,4735 }, { 222,4735 }, { 223,4735 },
 { 224,4735 }, { 225,4735 }, { 226,4735 }, { 227,4735 }, { 228,4735 },

 { 229,4735 }, { 230,4735 }, { 231,4735 }, { 232,4735 }, { 233,4735 },
 { 234,4735 }, { 235,4735 }, { 236,4735 }, { 237,4735 }, { 238,4735 },
 { 239,4735 }, { 240,4735 }, { 241,4735 }, { 242,4735 }, { 243,4735 },
 { 244,4735 }, { 245,4735 }, { 246,4735 }, { 247,4735 }, { 248,4735 },
 { 249,4735 }, { 250,4735 }, { 251,4735 }, { 252,4735 }, { 253,4735 },
 { 254,4735 }, { 255,4735 }, { 256,4735 }, {   0,   0 }, {   0,31248 },
 {   1, 593 }, {   2, 593 }, {   3, 593 }, {   4, 593 }, {   5, 593 },
 {   6, 593 }, {   7, 593 }, {   8, 593 }, {   9, 593 }, {  10, 597 },
 {  11, 593 }, {  12, 593 }, {  13, 593 }, {  14, 593 }, {  15, 593 },
 {  16, 593 }, {  17, 593 }, {  18, 593 }, {  19, 593 }, {  20, 593 },

 {  21, 593 }, {  22, 593 }, {  23, 593 }, {  24, 593 }, {  25, 593 },
 {  26, 593 }, {  27, 593 }, {  28, 593 }, {  29, 593 }, {  30, 593 },
 {  31, 593 }, {  32, 593 }, {  33, 593 }, {  34, 593 }, {  35, 593 },
 {  36, 593 }, {  37, 593 }, {  38, 593 }, {  39, 593 }, {  40, 593 },
 {  41, 593 }, {  42, 593 }, {  43, 593 }, {  44, 593 }, {  45, 593 },
 {  46, 593 }, {  47, 593 }, {  48, 593 }, {  49, 593 }, {  50, 593 },
 {  51, 593 }, {  52, 593 }, {  53, 593 }, {  54, 593 }, {  55, 593 },
 {  56, 593 }, {  57, 593 }, {  58, 593 }, {  59, 593 }, {  60, 593 },
 {  61, 593 }, {  62, 593 }, {  63, 593 }, {  64, 593 }, {  65, 593 },
 {  66, 593 }, {  67, 593 }, {  68, 593 }, {  69, 593 }, {  70, 593 },

 {  71, 593 }, {  72, 593 }, {  73, 593 }, {  74, 593 }, {  75, 593 },
 {  76, 593 }, {  77, 593 }, {  78, 593 }, {  79, 593 }, {  80, 593 },
 {  81, 593 }, {  82, 593 }, {  83, 593 }, {  84, 593 }, {  85, 593 },
 {  86, 593 }, {  87, 593 }, {  88, 593 }, {  89, 593 }, {  90, 593 },
 {  91, 593 }, {  92, 637 }, {  93, 593 }, {  94, 593 }, {  95, 593 },
 {  96, 593 }, {  97, 593 }, {  98, 593 }, {  99, 593 }, { 100, 593 },
 { 101, 593 }, { 102, 593 }, { 103, 593 }, { 104, 593 }, { 105, 593 },
 { 106, 593 }, { 107, 593 }, { 108, 593 }, { 109, 593 }, { 110, 593 },
 { 111, 593 }, { 112, 593 }, { 113, 593 }, { 114, 593 }, { 115, 593 },
 { 116, 593 }, { 117, 593 }, { 118, 593 }, { 119, 593 }, { 120, 593 },

 { 121, 593 }, { 122, 593 }, { 123, 593 }, { 124, 593 }, { 125, 593 },
 { 126, 593 }, { 127, 593 }, { 128, 593 }, { 129, 593 }, { 130, 593 },
 { 131, 593 }, { 132, 593 }, { 133, 593 }, { 134, 593 }, { 135, 593 },
 { 136, 593 }, { 137, 593 }, { 138, 593 }, { 139, 593 }, { 140, 593 },
 { 141, 593 }, { 142, 593 }, { 143, 593 }, { 144, 593 }, { 145, 593 },
 { 146, 593 }, { 147, 593 }, { 148, 593 }, { 149, 593 }, { 150, 593 },
 { 151, 593 }, { 152, 593 }, { 153, 593 }, { 154, 593 }, { 155, 593 },
 { 156, 593 }, { 157, 593 }, { 158, 593 }, { 159, 593 }, { 160, 593 },
 { 161, 593 }, { 162, 593 }, { 163, 593 }, { 164, 593 }, { 165, 593 },
 { 166, 593 }, { 167, 593 }, { 168, 593 }, { 169, 593 }, { 170, 593 },

 { 171, 593 }, { 172, 593 }, { 173, 593 }, { 174, 593 }, { 175, 593 },
 { 176, 593 }, { 177, 593 }, { 178, 593 }, { 179, 593 }, { 180, 593 },
 { 181, 593 }, { 182, 593 }, { 183, 593 }, { 184, 593 }, { 185, 593 },
 { 186, 593 }, { 187, 593 }, { 188, 593 }, { 189, 593 }, { 190, 593 },
 { 191, 593 }, { 192, 593 }, { 193, 593 }, { 194, 593 }, { 195, 593 },
 { 196, 593 }, { 197, 593 }, { 198, 593 }, { 199, 593 }, { 200, 593 },
 { 201, 593 }, { 202, 593 }, { 203, 593 }, { 204, 593 }, { 205, 593 },
 { 206, 593 }, { 207, 593 }, { 208, 593 }, { 209, 593 }, { 210, 593 },
 { 211, 593 }, { 212, 593 }, { 213, 593 }, { 214, 593 }, { 215, 593 },
 { 216, 593 }, { 217, 593 }, { 218, 593 }, { 219, 593 }, { 220, 593 },

 { 221, 593 }, { 222, 593 }, { 223, 593 }, { 224, 593 }, { 225, 593 },
 { 226, 593 }, { 227, 593 }, { 228, 593 }, { 229, 593 }, { 230, 593 },
 { 231, 593 }, { 232, 593 }, { 233, 593 }, { 234, 593 }, { 235, 593 },
 { 236, 593 }, { 237, 593 }, { 238, 593 }, { 239, 593 }, { 240, 593 },
 { 241, 593 }, { 242, 593 }, { 243, 593 }, { 244, 593 }, { 245, 593 },
 { 246, 593 }, { 247, 593 }, { 248, 593 }, { 249, 593 }, { 250, 593 },
 { 251, 593 }, { 252, 593 }, { 253, 593 }, { 254, 593 }, { 255, 593 },
 { 256, 593 }, {   0,   0 }, {   0,30990 }, {   1, 335 }, {   2, 335 },
 {   3, 335 }, {   4, 335 }, {   5, 335 }, {   6, 335 }, {   7, 335 },
 {   8, 335 }, {   9, 335 }, {  10, 339 }, {  11, 335 }, {  12, 335 },

 {  13, 335 }, {  14, 335 }, {  15, 335 }, {  16, 335 }, {  17, 335 },
 {  18, 335 }, {  19, 335 }, {  20, 335 }, {  21, 335 }, {  22, 335 },
 {  23, 335 }, {  24, 335 }, {  25, 335 }, {  26, 335 }, {  27, 335 },
 {  28, 335 }, {  29, 335 }, {  30, 335 }, {  31, 335 }, {  32, 335 },
 {  33, 335 }, {  34, 335 }, {  35, 335 }, {  36, 335 }, {  37, 335 },
 {  38, 335 }, {  39, 335 }, {  40, 335 }, {  41, 335 }, {  42, 335 },
 {  43, 335 }, {  44, 335 }, {  45, 335 }, {  46, 335 }, {  47, 335 },
 {  48, 335 }, {  49, 335 }, {  50, 335 }, {  51, 335 }, {  52, 335 },
 {  53, 335 }, {  54, 335 }, {  55, 335 }, {  56, 335 }, {  57, 335 },
 {  58, 335 }, {  59, 335 }, {  60, 335 }, {  61, 335 }, {  62, 335 },

 {  63, 335 }, {  64, 335 }, {  65, 335 }, {  66, 335 }, {  67, 335 },
 {  68, 335 }, {  69, 335 }, {  70, 335 }, {  71, 335 }, {  72, 335 },
 {  73, 335 }, {  74, 335 }, {  75, 335 }, {  76, 335 }, {  77, 335 },
 {  78, 335 }, {  79, 335 }, {  80, 335 }, {  81, 335 }, {  82, 335 },
 {  83, 335 }, {  84, 335 }, {  85, 335 }, {  86, 335 }, {  87, 335 },
 {  88, 335 }, {  89, 335 }, {  90, 335 }, {  91, 335 }, {  92, 379 },
 {  93, 335 }, {  94, 335 }, {  95, 335 }, {  96, 335 }, {  97, 335 },
 {  98, 335 }, {  99, 335 }, { 100, 335 }, { 101, 335 }, { 102, 335 },
 { 103, 335 }, { 104, 335 }, { 105, 335 }, { 106, 335 }, { 107, 335 },
 { 108, 335 }, { 109, 335 }, { 110, 335 }, { 111, 335 }, { 112, 335 },

 { 113, 335 }, { 114, 335 }, { 115, 335 }, { 116, 335 }, { 117, 335 },
 { 118, 335 }, { 119, 335 }, { 120, 335 }, { 121, 335 }, { 122, 335 },
 { 123, 335 }, { 124, 335 }, { 125, 335 }, { 126, 335 }, { 127, 335 },
 { 128, 335 }, { 129, 335 }, { 130, 335 }, { 131, 335 }, { 132, 335 },
 { 133, 335 }, { 134, 335 }, { 135, 335 }, { 136, 335 }, { 137, 335 },
 { 138, 335 }, { 139, 335 }, { 140, 335 }, { 141, 335 }, { 142, 335 },
 { 143, 335 }, { 144, 335 }, { 145, 335 }, { 146, 335 }, { 147, 335 },
 { 148, 335 }, { 149, 335 }, { 150, 335 }, { 151, 335 }, { 152, 335 },
 { 153, 335 }, { 154, 335 }, { 155, 335 }, { 156, 335 }, { 157, 335 },
 { 158, 335 }, { 159, 335 }, { 160, 335 }, { 161, 335 }, { 162, 335 },

 { 163, 335 }, { 164, 335 }, { 165, 335 }, { 166, 335 }, { 167, 335 },
 { 168, 335 }, { 169, 335 }, { 170, 335 }, { 171, 335 }, { 172, 335 },
 { 173, 335 }, { 174, 335 }, { 175, 335 }, { 176, 335 }, { 177, 335 },
 { 178, 335 }, { 179, 335 }, { 180, 335 }, { 181, 335 }, { 182, 335 },
 { 183, 335 }, { 184, 335 }, { 185, 335 }, { 186, 335 }, { 187, 335 },
 { 188, 335 }, { 189, 335 }, { 190, 335 }, { 191, 335 }, { 192, 335 },
 { 193, 335 }, { 194, 335 }, { 195, 335 }, { 196, 335 }, { 197, 335 },
 { 198, 335 }, { 199, 335 }, { 200, 335 }, { 201, 335 }, { 202, 335 },
 { 203, 335 }, { 204, 335 }, { 205, 335 }, { 206, 335 }, { 207, 335 },
 { 208, 335 }, { 209, 335 }, { 210, 335 }, { 211, 335 }, { 212, 335 },

 { 213, 335 }, { 214, 335 }, { 215, 335 }, { 216, 335 }, { 217, 335 },
 { 218, 335 }, { 219, 335 }, { 220, 335 }, { 221, 335 }, { 222, 335 },
 { 223, 335 }, { 224, 335 }, { 225, 335 }, { 226, 335 }, { 227, 335 },
 { 228, 335 }, { 229, 335 }, { 230, 335 }, { 231, 335 }, { 232, 335 },
 { 233, 335 }, { 234, 335 }, { 235, 335 }, { 236, 335 }, { 237, 335 },
 { 238, 335 }, { 239, 335 }, { 240, 335 }, { 241, 335 }, { 242, 335 },
 { 243, 335 }, { 244, 335 }, { 245, 335 }, { 246, 335 }, { 247, 335 },
 { 248, 335 }, { 249, 335 }, { 250, 335 }, { 251, 335 }, { 252, 335 },
 { 253, 335 }, { 254, 335 }, { 255, 335 }, { 256, 335 }, {   0,  72 },
 {   0,30732 }, {   0,   1 }, {   0,30730 }, {   0,  38 }, {   0,30728 },

 {   0,   0 }, {   0,   1 }, {   0,30725 }, {   0,  54 }, {   0,30723 },
 {   0,   0 }, {   9,5585 }, {  10,5585 }, {  11,5585 }, {  12,5585 },
 {  13,5585 }, {   9,5580 }, {  10,5580 }, {  11,5580 }, {  12,5580 },
 {  13,5580 }, {   0,  13 }, {   0,30710 }, {   0,  53 }, {   0,30708 },
 {   0,   0 }, {   0,  53 }, {   0,30705 }, {   0,  16 }, {   0,30703 },
 {   0,   0 }, {   0,   6 }, {   0,30700 }, {   0,   0 }, {  32,5585 },
 {   0,   6 }, {   0,30696 }, {   0,   0 }, {   0,   0 }, {  32,5580 },
 {   0,  40 }, {   0,30691 }, {  33,5833 }, {   0,   0 }, {  35,5833 },
 {   0,   0 }, {  37,5833 }, {  38,5833 }, {   0,  54 }, {   0,30683 },
 {   0,   0 }, {  42,5833 }, {  43,5833 }, {   0,   0 }, {  45,5833 },

 {   0,   0 }, {  47,5833 }, {   0,  16 }, {   0,30674 }, {   0,  19 },
 {   0,30672 }, {   0,  18 }, {   0,30670 }, {   0,   0 }, {   0,  16 },
 {   0,30667 }, {   0,  41 }, {   0,30665 }, {   0,   0 }, {  60,5833 },
 {  61,5844 }, {  62,5833 }, {  63,5833 }, {  64,5833 }, {  42, 348 },
 {  34, 346 }, {   0,  25 }, {   0,30655 }, {  42,9970 }, {  47, 353 },
 {   0,  26 }, {   0,30651 }, {  33,5793 }, {   0,   0 }, {  35,5793 },
 {  58, 100 }, {  37,5793 }, {  38,5793 }, {  61, 102 }, {   0,   0 },
 {   0,   0 }, {  42,5793 }, {  43,5793 }, {   0,   0 }, {  45,5793 },
 {   0,   0 }, {  47,5793 }, {  39, 331 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  34, 320 }, {   0,   0 }, {  94,5833 }, {  39, 324 },

 {  96,5833 }, {   0,   0 }, {  45,10922 }, {   0,   0 }, {  60,5793 },
 {  61,5793 }, {  62,5793 }, {  63,5793 }, {  64,5793 }, {   0,  72 },
 {   0,30617 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,  25 }, {   0,30611 }, {   0,  32 }, {   0,30609 }, {   0,  46 },
 {   0,30607 }, {   0,  45 }, {   0,30605 }, {   0,  47 }, {   0,30603 },
 {   0,   8 }, {   0,30601 }, {   0,   0 }, { 124,5833 }, {   0,   0 },
 { 126,5833 }, {   0,  14 }, {   0,30595 }, {   0,  12 }, {   0,30593 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,5793 }, {   0,   0 },
 {  96,5793 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  36,   8 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,5817 }, {  49,5817 },
 {  50,5817 }, {  51,5817 }, {  52,5817 }, {  53,5817 }, {  54,5817 },
 {  55,5817 }, {  56,5817 }, {  57,5817 }, { 124,5793 }, {   0,   0 },
 { 126,5793 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,6074 }, {  66,6074 }, {  67,6074 }, {  68,6074 }, {  69,6074 },
 {  70,6074 }, {  71,6074 }, {  72,6074 }, {  73,6074 }, {  74,6074 },
 {  75,6074 }, {  76,6074 }, {  77,6074 }, {  78,6074 }, {  79,6074 },
 {  80,6074 }, {  81,6074 }, {  82,6074 }, {  83,6074 }, {  84,6074 },
 {  85,6074 }, {  86,6074 }, {  87,6074 }, {  88,6074 }, {  89,6074 },

 {  90,6074 }, {  85,12067 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,6074 }, {   0,   0 }, {  97,6074 }, {  98,6074 }, {  99,6074 },
 { 100,6074 }, { 101,6074 }, { 102,6074 }, { 103,6074 }, { 104,6074 },
 { 105,6074 }, { 106,6074 }, { 107,6074 }, { 108,6074 }, { 109,6074 },
 { 110,6074 }, { 111,6074 }, { 112,6074 }, { 113,6074 }, { 114,6074 },
 { 115,6074 }, { 116,6074 }, { 117,6074 }, { 118,6074 }, { 119,6074 },
 { 120,6074 }, { 121,6074 }, { 122,6074 }, { 117,12090 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,6074 }, { 129,6074 },
 { 130,6074 }, { 131,6074 }, { 132,6074 }, { 133,6074 }, { 134,6074 },
 { 135,6074 }, { 136,6074 }, { 137,6074 }, { 138,6074 }, { 139,6074 },

 { 140,6074 }, { 141,6074 }, { 142,6074 }, { 143,6074 }, { 144,6074 },
 { 145,6074 }, { 146,6074 }, { 147,6074 }, { 148,6074 }, { 149,6074 },
 { 150,6074 }, { 151,6074 }, { 152,6074 }, { 153,6074 }, { 154,6074 },
 { 155,6074 }, { 156,6074 }, { 157,6074 }, { 158,6074 }, { 159,6074 },
 { 160,6074 }, { 161,6074 }, { 162,6074 }, { 163,6074 }, { 164,6074 },
 { 165,6074 }, { 166,6074 }, { 167,6074 }, { 168,6074 }, { 169,6074 },
 { 170,6074 }, { 171,6074 }, { 172,6074 }, { 173,6074 }, { 174,6074 },
 { 175,6074 }, { 176,6074 }, { 177,6074 }, { 178,6074 }, { 179,6074 },
 { 180,6074 }, { 181,6074 }, { 182,6074 }, { 183,6074 }, { 184,6074 },
 { 185,6074 }, { 186,6074 }, { 187,6074 }, { 188,6074 }, { 189,6074 },

 { 190,6074 }, { 191,6074 }, { 192,6074 }, { 193,6074 }, { 194,6074 },
 { 195,6074 }, { 196,6074 }, { 197,6074 }, { 198,6074 }, { 199,6074 },
 { 200,6074 }, { 201,6074 }, { 202,6074 }, { 203,6074 }, { 204,6074 },
 { 205,6074 }, { 206,6074 }, { 207,6074 }, { 208,6074 }, { 209,6074 },
 { 210,6074 }, { 211,6074 }, { 212,6074 }, { 213,6074 }, { 214,6074 },
 { 215,6074 }, { 216,6074 }, { 217,6074 }, { 218,6074 }, { 219,6074 },
 { 220,6074 }, { 221,6074 }, { 222,6074 }, { 223,6074 }, { 224,6074 },
 { 225,6074 }, { 226,6074 }, { 227,6074 }, { 228,6074 }, { 229,6074 },
 { 230,6074 }, { 231,6074 }, { 232,6074 }, { 233,6074 }, { 234,6074 },
 { 235,6074 }, { 236,6074 }, { 237,6074 }, { 238,6074 }, { 239,6074 },

 { 240,6074 }, { 241,6074 }, { 242,6074 }, { 243,6074 }, { 244,6074 },
 { 245,6074 }, { 246,6074 }, { 247,6074 }, { 248,6074 }, { 249,6074 },
 { 250,6074 }, { 251,6074 }, { 252,6074 }, { 253,6074 }, { 254,6074 },
 { 255,6074 }, {   0,  53 }, {   0,30360 }, {   0,  44 }, {   0,30358 },
 {   0,  11 }, {   0,30356 }, {   0,   0 }, {   0,   0 }, {   0,   7 },
 {   0,30352 }, {   0,   0 }, {   0,  53 }, {   0,30349 }, {   0,   4 },
 {   0,30347 }, {   0,  42 }, {   0,30345 }, {   0,  20 }, {   0,30343 },
 {   0,   0 }, {   0,  18 }, {   0,30340 }, {   0,  17 }, {   0,30338 },
 {   0,  18 }, {   0,30336 }, {   0,  28 }, {   0,30334 }, {   0,  34 },
 {   0,30332 }, {   0,  53 }, {   0,30330 }, {   0,  65 }, {   0,30328 },

 {  33,5470 }, {   0,   0 }, {  35,5470 }, {  34,  38 }, {  37,5470 },
 {  38,5470 }, {   0,  39 }, {   0,30320 }, {  39,  50 }, {  42,5470 },
 {  43,5470 }, {  33,5459 }, {  45,5470 }, {  35,5459 }, {  47,5470 },
 {  37,5459 }, {  38,5459 }, {  42,   0 }, {   0,  15 }, {   0,30308 },
 {  42,5459 }, {  43,5459 }, {  47,   5 }, {  45,6063 }, {   0,   0 },
 {  47,5459 }, {   0,   0 }, {  60,5470 }, {  61,5470 }, {  62,5470 },
 {  63,5470 }, {  64,5470 }, {  45,10592 }, {   0,  29 }, {   0,30293 },
 {   0,   0 }, {  45,16672 }, {   0,   0 }, {  60,5459 }, {  61,5459 },
 {  62,5459 }, {  63,5459 }, {  64,5459 }, {  46,-277 }, {   0,   0 },
 {  48,6302 }, {  49,6302 }, {  50,6302 }, {  51,6302 }, {  52,6302 },

 {  53,6302 }, {  54,6302 }, {  55,6302 }, {  56,6302 }, {  57,6302 },
 {   0,  30 }, {   0,30271 }, {   0,  23 }, {   0,30269 }, {   0,  24 },
 {   0,30267 }, {  94,5470 }, {   0,   0 }, {  96,5470 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,  53 }, {   0,30259 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  94,5459 }, {   0,   0 }, {  96,5459 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 124,5470 }, {   0,   0 }, { 126,5470 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  57 },

 {   0,30227 }, {  33,5369 }, { 124,5459 }, {  35,5369 }, { 126,5459 },
 {  37,5369 }, {  38,5369 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  42,6488 }, {  43,5369 }, {   0,   0 }, {  45,5369 }, {   0,   0 },
 {  47,5369 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  60,5369 }, {  61,5369 },
 {  62,5369 }, {  63,5369 }, {  64,5369 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  46,6488 }, {   0,   0 }, {  48,6745 }, {  49,6745 },

 {  50,6745 }, {  51,6745 }, {  52,6745 }, {  53,6745 }, {  54,6745 },
 {  55,6745 }, {  56,6745 }, {  57,6745 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  94,5369 }, {   0,   0 }, {  96,5369 },
 {  65,7002 }, {  66,7259 }, {  67,7002 }, {  68,7002 }, {  69,7516 },
 {  70,7002 }, {  71,7002 }, {  72,7002 }, {  73,7002 }, {  74,7002 },
 {  75,7002 }, {  76,7002 }, {  77,7002 }, {  78,7002 }, {  79,7773 },
 {  80,7002 }, {  81,7002 }, {  82,7002 }, {  83,7002 }, {  84,7002 },
 {  85,7002 }, {  86,7002 }, {  87,7002 }, {  88,8030 }, {  89,7002 },
 {  90,7002 }, {   0,   0 }, { 124,5369 }, {   0,   0 }, { 126,5369 },
 {  95,8287 }, {   0,   0 }, {  97,7002 }, {  98,7259 }, {  99,7002 },

 { 100,7002 }, { 101,7516 }, { 102,7002 }, { 103,7002 }, { 104,7002 },
 { 105,7002 }, { 106,7002 }, { 107,7002 }, { 108,7002 }, { 109,7002 },
 { 110,7002 }, { 111,7773 }, { 112,7002 }, { 113,7002 }, { 114,7002 },
 { 115,7002 }, { 116,7002 }, { 117,7002 }, { 118,7002 }, { 119,7002 },
 { 120,8030 }, { 121,7002 }, { 122,7002 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,7002 }, { 129,7002 },
 { 130,7002 }, { 131,7002 }, { 132,7002 }, { 133,7002 }, { 134,7002 },
 { 135,7002 }, { 136,7002 }, { 137,7002 }, { 138,7002 }, { 139,7002 },
 { 140,7002 }, { 141,7002 }, { 142,7002 }, { 143,7002 }, { 144,7002 },
 { 145,7002 }, { 146,7002 }, { 147,7002 }, { 148,7002 }, { 149,7002 },

 { 150,7002 }, { 151,7002 }, { 152,7002 }, { 153,7002 }, { 154,7002 },
 { 155,7002 }, { 156,7002 }, { 157,7002 }, { 158,7002 }, { 159,7002 },
 { 160,7002 }, { 161,7002 }, { 162,7002 }, { 163,7002 }, { 164,7002 },
 { 165,7002 }, { 166,7002 }, { 167,7002 }, { 168,7002 }, { 169,7002 },
 { 170,7002 }, { 171,7002 }, { 172,7002 }, { 173,7002 }, { 174,7002 },
 { 175,7002 }, { 176,7002 }, { 177,7002 }, { 178,7002 }, { 179,7002 },
 { 180,7002 }, { 181,7002 }, { 182,7002 }, { 183,7002 }, { 184,7002 },
 { 185,7002 }, { 186,7002 }, { 187,7002 }, { 188,7002 }, { 189,7002 },
 { 190,7002 }, { 191,7002 }, { 192,7002 }, { 193,7002 }, { 194,7002 },
 { 195,7002 }, { 196,7002 }, { 197,7002 }, { 198,7002 }, { 199,7002 },

 { 200,7002 }, { 201,7002 }, { 202,7002 }, { 203,7002 }, { 204,7002 },
 { 205,7002 }, { 206,7002 }, { 207,7002 }, { 208,7002 }, { 209,7002 },
 { 210,7002 }, { 211,7002 }, { 212,7002 }, { 213,7002 }, { 214,7002 },
 { 215,7002 }, { 216,7002 }, { 217,7002 }, { 218,7002 }, { 219,7002 },
 { 220,7002 }, { 221,7002 }, { 222,7002 }, { 223,7002 }, { 224,7002 },
 { 225,7002 }, { 226,7002 }, { 227,7002 }, { 228,7002 }, { 229,7002 },
 { 230,7002 }, { 231,7002 }, { 232,7002 }, { 233,7002 }, { 234,7002 },
 { 235,7002 }, { 236,7002 }, { 237,7002 }, { 238,7002 }, { 239,7002 },
 { 240,7002 }, { 241,7002 }, { 242,7002 }, { 243,7002 }, { 244,7002 },
 { 245,7002 }, { 246,7002 }, { 247,7002 }, { 248,7002 }, { 249,7002 },

 { 250,7002 }, { 251,7002 }, { 252,7002 }, { 253,7002 }, { 254,7002 },
 { 255,7002 }, {   0,  57 }, {   0,29970 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  46,6231 }, {   0,   0 },
 {  48,6488 }, {  49,6488 }, {  50,6488 }, {  51,6488 }, {  52,6488 },
 {  53,6488 }, {  54,6488 }, {  55,6488 }, {  56,6488 }, {  57,6488 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,6745 }, {  66,6745 }, {  67,6745 },
 {  68,6745 }, {  69,7259 }, {  70,6745 }, {  71,6745 }, {  72,6745 },
 {  73,6745 }, {  74,6745 }, {  75,6745 }, {  76,6745 }, {  77,6745 },
 {  78,6745 }, {  79,6745 }, {  80,6745 }, {  81,6745 }, {  82,6745 },
 {  83,6745 }, {  84,6745 }, {  85,6745 }, {  86,6745 }, {  87,6745 },
 {  88,6745 }, {  89,6745 }, {  90,6745 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {  95,8030 }, {   0,   0 }, {  97,6745 },
 {  98,6745 }, {  99,6745 }, { 100,6745 }, { 101,7259 }, { 102,6745 },
 { 103,6745 }, { 104,6745 }, { 105,6745 }, { 106,6745 }, { 107,6745 },
 { 108,6745 }, { 109,6745 }, { 110,6745 }, { 111,6745 }, { 112,6745 },
 { 113,6745 }, { 114,6745 }, { 115,6745 }, { 116,6745 }, { 117,6745 },
 { 118,6745 }, { 119,6745 }, { 120,6745 }, { 121,6745 }, { 122,6745 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,6745 }, { 129,6745 }, { 130,6745 }, { 131,6745 }, { 132,6745 },
 { 133,6745 }, { 134,6745 }, { 135,6745 }, { 136,6745 }, { 137,6745 },
 { 138,6745 }, { 139,6745 }, { 140,6745 }, { 141,6745 }, { 142,6745 },

 { 143,6745 }, { 144,6745 }, { 145,6745 }, { 146,6745 }, { 147,6745 },
 { 148,6745 }, { 149,6745 }, { 150,6745 }, { 151,6745 }, { 152,6745 },
 { 153,6745 }, { 154,6745 }, { 155,6745 }, { 156,6745 }, { 157,6745 },
 { 158,6745 }, { 159,6745 }, { 160,6745 }, { 161,6745 }, { 162,6745 },
 { 163,6745 }, { 164,6745 }, { 165,6745 }, { 166,6745 }, { 167,6745 },
 { 168,6745 }, { 169,6745 }, { 170,6745 }, { 171,6745 }, { 172,6745 },
 { 173,6745 }, { 174,6745 }, { 175,6745 }, { 176,6745 }, { 177,6745 },
 { 178,6745 }, { 179,6745 }, { 180,6745 }, { 181,6745 }, { 182,6745 },
 { 183,6745 }, { 184,6745 }, { 185,6745 }, { 186,6745 }, { 187,6745 },
 { 188,6745 }, { 189,6745 }, { 190,6745 }, { 191,6745 }, { 192,6745 },

 { 193,6745 }, { 194,6745 }, { 195,6745 }, { 196,6745 }, { 197,6745 },
 { 198,6745 }, { 199,6745 }, { 200,6745 }, { 201,6745 }, { 202,6745 },
 { 203,6745 }, { 204,6745 }, { 205,6745 }, { 206,6745 }, { 207,6745 },
 { 208,6745 }, { 209,6745 }, { 210,6745 }, { 211,6745 }, { 212,6745 },
 { 213,6745 }, { 214,6745 }, { 215,6745 }, { 216,6745 }, { 217,6745 },
 { 218,6745 }, { 219,6745 }, { 220,6745 }, { 221,6745 }, { 222,6745 },
 { 223,6745 }, { 224,6745 }, { 225,6745 }, { 226,6745 }, { 227,6745 },
 { 228,6745 }, { 229,6745 }, { 230,6745 }, { 231,6745 }, { 232,6745 },
 { 233,6745 }, { 234,6745 }, { 235,6745 }, { 236,6745 }, { 237,6745 },
 { 238,6745 }, { 239,6745 }, { 240,6745 }, { 241,6745 }, { 242,6745 },

 { 243,6745 }, { 244,6745 }, { 245,6745 }, { 246,6745 }, { 247,6745 },
 { 248,6745 }, { 249,6745 }, { 250,6745 }, { 251,6745 }, { 252,6745 },
 { 253,6745 }, { 254,6745 }, { 255,6745 }, {   0,  53 }, {   0,29713 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  53 },
 {   0,29702 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  33,4823 }, {   0,   0 }, {  35,4823 },

 {   0,   0 }, {  37,4823 }, {  38,4823 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  42,4823 }, {  43,4823 }, {  33,4812 }, {  45,4823 },
 {  35,4812 }, {  47,4823 }, {  37,4812 }, {  38,4812 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  42,4812 }, {  43,4812 }, {   0,   0 },
 {  45,4812 }, {   0,   0 }, {  47,4812 }, {   0,   0 }, {  60,4823 },
 {  61,8030 }, {  62,8041 }, {  63,4823 }, {  64,4823 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  60,4812 }, {  61,4812 }, {  62,8097 }, {  63,4812 }, {  64,4812 },
 {   0,   0 }, {   0,  53 }, {   0,29635 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,4823 }, {   0,   0 },
 {  96,4823 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,4812 },
 {   0,   0 }, {  96,4812 }, {   0,   0 }, {   0,  71 }, {   0,29603 },
 {  33,4745 }, {   0,   0 }, {  35,4745 }, {   0,   0 }, {  37,4745 },
 {  38,4745 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  42,4745 },
 {  43,4745 }, {   0,   0 }, {  45,4745 }, { 124,4823 }, {  47,4745 },
 { 126,4823 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 124,4812 },

 {   0,   0 }, { 126,4812 }, {  60,4745 }, {  61,8070 }, {  62,4745 },
 {  63,4745 }, {  64,4745 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  36,8104 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,8104 }, {  49,8104 }, {  50,8104 },
 {  51,8104 }, {  52,8104 }, {  53,8104 }, {  54,8104 }, {  55,8104 },
 {  56,8104 }, {  57,8104 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  94,4745 }, {   0,   0 }, {  96,4745 }, {  65,8104 },
 {  66,8104 }, {  67,8104 }, {  68,8104 }, {  69,8104 }, {  70,8104 },
 {  71,8104 }, {  72,8104 }, {  73,8104 }, {  74,8104 }, {  75,8104 },

 {  76,8104 }, {  77,8104 }, {  78,8104 }, {  79,8104 }, {  80,8104 },
 {  81,8104 }, {  82,8104 }, {  83,8104 }, {  84,8104 }, {  85,8104 },
 {  86,8104 }, {  87,8104 }, {  88,8104 }, {  89,8104 }, {  90,8104 },
 {   0,   0 }, { 124,4745 }, {   0,   0 }, { 126,4745 }, {  95,8104 },
 {   0,   0 }, {  97,8104 }, {  98,8104 }, {  99,8104 }, { 100,8104 },
 { 101,8104 }, { 102,8104 }, { 103,8104 }, { 104,8104 }, { 105,8104 },
 { 106,8104 }, { 107,8104 }, { 108,8104 }, { 109,8104 }, { 110,8104 },
 { 111,8104 }, { 112,8104 }, { 113,8104 }, { 114,8104 }, { 115,8104 },
 { 116,8104 }, { 117,8104 }, { 118,8104 }, { 119,8104 }, { 120,8104 },
 { 121,8104 }, { 122,8104 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, { 128,8104 }, { 129,8104 }, { 130,8104 },
 { 131,8104 }, { 132,8104 }, { 133,8104 }, { 134,8104 }, { 135,8104 },
 { 136,8104 }, { 137,8104 }, { 138,8104 }, { 139,8104 }, { 140,8104 },
 { 141,8104 }, { 142,8104 }, { 143,8104 }, { 144,8104 }, { 145,8104 },
 { 146,8104 }, { 147,8104 }, { 148,8104 }, { 149,8104 }, { 150,8104 },
 { 151,8104 }, { 152,8104 }, { 153,8104 }, { 154,8104 }, { 155,8104 },
 { 156,8104 }, { 157,8104 }, { 158,8104 }, { 159,8104 }, { 160,8104 },
 { 161,8104 }, { 162,8104 }, { 163,8104 }, { 164,8104 }, { 165,8104 },
 { 166,8104 }, { 167,8104 }, { 168,8104 }, { 169,8104 }, { 170,8104 },
 { 171,8104 }, { 172,8104 }, { 173,8104 }, { 174,8104 }, { 175,8104 },

 { 176,8104 }, { 177,8104 }, { 178,8104 }, { 179,8104 }, { 180,8104 },
 { 181,8104 }, { 182,8104 }, { 183,8104 }, { 184,8104 }, { 185,8104 },
 { 186,8104 }, { 187,8104 }, { 188,8104 }, { 189,8104 }, { 190,8104 },
 { 191,8104 }, { 192,8104 }, { 193,8104 }, { 194,8104 }, { 195,8104 },
 { 196,8104 }, { 197,8104 }, { 198,8104 }, { 199,8104 }, { 200,8104 },
 { 201,8104 }, { 202,8104 }, { 203,8104 }, { 204,8104 }, { 205,8104 },
 { 206,8104 }, { 207,8104 }, { 208,8104 }, { 209,8104 }, { 210,8104 },
 { 211,8104 }, { 212,8104 }, { 213,8104 }, { 214,8104 }, { 215,8104 },
 { 216,8104 }, { 217,8104 }, { 218,8104 }, { 219,8104 }, { 220,8104 },
 { 221,8104 }, { 222,8104 }, { 223,8104 }, { 224,8104 }, { 225,8104 },

 { 226,8104 }, { 227,8104 }, { 228,8104 }, { 229,8104 }, { 230,8104 },
 { 231,8104 }, { 232,8104 }, { 233,8104 }, { 234,8104 }, { 235,8104 },
 { 236,8104 }, { 237,8104 }, { 238,8104 }, { 239,8104 }, { 240,8104 },
 { 241,8104 }, { 242,8104 }, { 243,8104 }, { 244,8104 }, { 245,8104 },
 { 246,8104 }, { 247,8104 }, { 248,8104 }, { 249,8104 }, { 250,8104 },
 { 251,8104 }, { 252,8104 }, { 253,8104 }, { 254,8104 }, { 255,8104 },
 {   0,  71 }, {   0,29346 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  36,7847 }, {   0,   0 }, {   0,   0 },
 {  39,-1255 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,7847 },
 {  49,7847 }, {  50,7847 }, {  51,7847 }, {  52,7847 }, {  53,7847 },
 {  54,7847 }, {  55,7847 }, {  56,7847 }, {  57,7847 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,7847 }, {  66,7847 }, {  67,7847 }, {  68,7847 },

 {  69,7847 }, {  70,7847 }, {  71,7847 }, {  72,7847 }, {  73,7847 },
 {  74,7847 }, {  75,7847 }, {  76,7847 }, {  77,7847 }, {  78,7847 },
 {  79,7847 }, {  80,7847 }, {  81,7847 }, {  82,7847 }, {  83,7847 },
 {  84,7847 }, {  85,7847 }, {  86,7847 }, {  87,7847 }, {  88,7847 },
 {  89,7847 }, {  90,7847 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95,7847 }, {   0,   0 }, {  97,7847 }, {  98,7847 },
 {  99,7847 }, { 100,7847 }, { 101,7847 }, { 102,7847 }, { 103,7847 },
 { 104,7847 }, { 105,7847 }, { 106,7847 }, { 107,7847 }, { 108,7847 },
 { 109,7847 }, { 110,7847 }, { 111,7847 }, { 112,7847 }, { 113,7847 },
 { 114,7847 }, { 115,7847 }, { 116,7847 }, { 117,7847 }, { 118,7847 },

 { 119,7847 }, { 120,7847 }, { 121,7847 }, { 122,7847 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,7847 },
 { 129,7847 }, { 130,7847 }, { 131,7847 }, { 132,7847 }, { 133,7847 },
 { 134,7847 }, { 135,7847 }, { 136,7847 }, { 137,7847 }, { 138,7847 },
 { 139,7847 }, { 140,7847 }, { 141,7847 }, { 142,7847 }, { 143,7847 },
 { 144,7847 }, { 145,7847 }, { 146,7847 }, { 147,7847 }, { 148,7847 },
 { 149,7847 }, { 150,7847 }, { 151,7847 }, { 152,7847 }, { 153,7847 },
 { 154,7847 }, { 155,7847 }, { 156,7847 }, { 157,7847 }, { 158,7847 },
 { 159,7847 }, { 160,7847 }, { 161,7847 }, { 162,7847 }, { 163,7847 },
 { 164,7847 }, { 165,7847 }, { 166,7847 }, { 167,7847 }, { 168,7847 },

 { 169,7847 }, { 170,7847 }, { 171,7847 }, { 172,7847 }, { 173,7847 },
 { 174,7847 }, { 175,7847 }, { 176,7847 }, { 177,7847 }, { 178,7847 },
 { 179,7847 }, { 180,7847 }, { 181,7847 }, { 182,7847 }, { 183,7847 },
 { 184,7847 }, { 185,7847 }, { 186,7847 }, { 187,7847 }, { 188,7847 },
 { 189,7847 }, { 190,7847 }, { 191,7847 }, { 192,7847 }, { 193,7847 },
 { 194,7847 }, { 195,7847 }, { 196,7847 }, { 197,7847 }, { 198,7847 },
 { 199,7847 }, { 200,7847 }, { 201,7847 }, { 202,7847 }, { 203,7847 },
 { 204,7847 }, { 205,7847 }, { 206,7847 }, { 207,7847 }, { 208,7847 },
 { 209,7847 }, { 210,7847 }, { 211,7847 }, { 212,7847 }, { 213,7847 },
 { 214,7847 }, { 215,7847 }, { 216,7847 }, { 217,7847 }, { 218,7847 },

 { 219,7847 }, { 220,7847 }, { 221,7847 }, { 222,7847 }, { 223,7847 },
 { 224,7847 }, { 225,7847 }, { 226,7847 }, { 227,7847 }, { 228,7847 },
 { 229,7847 }, { 230,7847 }, { 231,7847 }, { 232,7847 }, { 233,7847 },
 { 234,7847 }, { 235,7847 }, { 236,7847 }, { 237,7847 }, { 238,7847 },
 { 239,7847 }, { 240,7847 }, { 241,7847 }, { 242,7847 }, { 243,7847 },
 { 244,7847 }, { 245,7847 }, { 246,7847 }, { 247,7847 }, { 248,7847 },
 { 249,7847 }, { 250,7847 }, { 251,7847 }, { 252,7847 }, { 253,7847 },
 { 254,7847 }, { 255,7847 }, {   0,  71 }, {   0,29089 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,7590 },
 {   0,   0 }, {   0,   0 }, {  39,-1506 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,7590 }, {  49,7590 }, {  50,7590 }, {  51,7590 },
 {  52,7590 }, {  53,7590 }, {  54,7590 }, {  55,7590 }, {  56,7590 },
 {  57,7590 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,7590 }, {  66,7590 },
 {  67,7590 }, {  68,7590 }, {  69,7590 }, {  70,7590 }, {  71,7590 },
 {  72,7590 }, {  73,7590 }, {  74,7590 }, {  75,7590 }, {  76,7590 },
 {  77,7590 }, {  78,7590 }, {  79,7590 }, {  80,7590 }, {  81,7590 },
 {  82,7590 }, {  83,7590 }, {  84,7590 }, {  85,7590 }, {  86,7590 },
 {  87,7590 }, {  88,7590 }, {  89,7590 }, {  90,7590 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,7590 }, {   0,   0 },
 {  97,7590 }, {  98,7590 }, {  99,7590 }, { 100,7590 }, { 101,7590 },
 { 102,7590 }, { 103,7590 }, { 104,7590 }, { 105,7590 }, { 106,7590 },
 { 107,7590 }, { 108,7590 }, { 109,7590 }, { 110,7590 }, { 111,7590 },

 { 112,7590 }, { 113,7590 }, { 114,7590 }, { 115,7590 }, { 116,7590 },
 { 117,7590 }, { 118,7590 }, { 119,7590 }, { 120,7590 }, { 121,7590 },
 { 122,7590 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 128,7590 }, { 129,7590 }, { 130,7590 }, { 131,7590 },
 { 132,7590 }, { 133,7590 }, { 134,7590 }, { 135,7590 }, { 136,7590 },
 { 137,7590 }, { 138,7590 }, { 139,7590 }, { 140,7590 }, { 141,7590 },
 { 142,7590 }, { 143,7590 }, { 144,7590 }, { 145,7590 }, { 146,7590 },
 { 147,7590 }, { 148,7590 }, { 149,7590 }, { 150,7590 }, { 151,7590 },
 { 152,7590 }, { 153,7590 }, { 154,7590 }, { 155,7590 }, { 156,7590 },
 { 157,7590 }, { 158,7590 }, { 159,7590 }, { 160,7590 }, { 161,7590 },

 { 162,7590 }, { 163,7590 }, { 164,7590 }, { 165,7590 }, { 166,7590 },
 { 167,7590 }, { 168,7590 }, { 169,7590 }, { 170,7590 }, { 171,7590 },
 { 172,7590 }, { 173,7590 }, { 174,7590 }, { 175,7590 }, { 176,7590 },
 { 177,7590 }, { 178,7590 }, { 179,7590 }, { 180,7590 }, { 181,7590 },
 { 182,7590 }, { 183,7590 }, { 184,7590 }, { 185,7590 }, { 186,7590 },
 { 187,7590 }, { 188,7590 }, { 189,7590 }, { 190,7590 }, { 191,7590 },
 { 192,7590 }, { 193,7590 }, { 194,7590 }, { 195,7590 }, { 196,7590 },
 { 197,7590 }, { 198,7590 }, { 199,7590 }, { 200,7590 }, { 201,7590 },
 { 202,7590 }, { 203,7590 }, { 204,7590 }, { 205,7590 }, { 206,7590 },
 { 207,7590 }, { 208,7590 }, { 209,7590 }, { 210,7590 }, { 211,7590 },

 { 212,7590 }, { 213,7590 }, { 214,7590 }, { 215,7590 }, { 216,7590 },
 { 217,7590 }, { 218,7590 }, { 219,7590 }, { 220,7590 }, { 221,7590 },
 { 222,7590 }, { 223,7590 }, { 224,7590 }, { 225,7590 }, { 226,7590 },
 { 227,7590 }, { 228,7590 }, { 229,7590 }, { 230,7590 }, { 231,7590 },
 { 232,7590 }, { 233,7590 }, { 234,7590 }, { 235,7590 }, { 236,7590 },
 { 237,7590 }, { 238,7590 }, { 239,7590 }, { 240,7590 }, { 241,7590 },
 { 242,7590 }, { 243,7590 }, { 244,7590 }, { 245,7590 }, { 246,7590 },
 { 247,7590 }, { 248,7590 }, { 249,7590 }, { 250,7590 }, { 251,7590 },
 { 252,7590 }, { 253,7590 }, { 254,7590 }, { 255,7590 }, {   0,  71 },
 {   0,28832 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  36,7333 }, {   0,   0 }, {   0,   0 }, {  39,-1761 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,7333 }, {  49,7333 },
 {  50,7333 }, {  51,7333 }, {  52,7333 }, {  53,7333 }, {  54,7333 },

 {  55,7333 }, {  56,7333 }, {  57,7333 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,7333 }, {  66,7333 }, {  67,7333 }, {  68,7333 }, {  69,7333 },
 {  70,7333 }, {  71,7333 }, {  72,7333 }, {  73,7333 }, {  74,7333 },
 {  75,7333 }, {  76,7333 }, {  77,7333 }, {  78,7333 }, {  79,7333 },
 {  80,7333 }, {  81,7333 }, {  82,7333 }, {  83,7333 }, {  84,7333 },
 {  85,7333 }, {  86,7333 }, {  87,7333 }, {  88,7333 }, {  89,7333 },
 {  90,7333 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,7333 }, {   0,   0 }, {  97,7333 }, {  98,7333 }, {  99,7333 },
 { 100,7333 }, { 101,7333 }, { 102,7333 }, { 103,7333 }, { 104,7333 },

 { 105,7333 }, { 106,7333 }, { 107,7333 }, { 108,7333 }, { 109,7333 },
 { 110,7333 }, { 111,7333 }, { 112,7333 }, { 113,7333 }, { 114,7333 },
 { 115,7333 }, { 116,7333 }, { 117,7333 }, { 118,7333 }, { 119,7333 },
 { 120,7333 }, { 121,7333 }, { 122,7333 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,7333 }, { 129,7333 },
 { 130,7333 }, { 131,7333 }, { 132,7333 }, { 133,7333 }, { 134,7333 },
 { 135,7333 }, { 136,7333 }, { 137,7333 }, { 138,7333 }, { 139,7333 },
 { 140,7333 }, { 141,7333 }, { 142,7333 }, { 143,7333 }, { 144,7333 },
 { 145,7333 }, { 146,7333 }, { 147,7333 }, { 148,7333 }, { 149,7333 },
 { 150,7333 }, { 151,7333 }, { 152,7333 }, { 153,7333 }, { 154,7333 },

 { 155,7333 }, { 156,7333 }, { 157,7333 }, { 158,7333 }, { 159,7333 },
 { 160,7333 }, { 161,7333 }, { 162,7333 }, { 163,7333 }, { 164,7333 },
 { 165,7333 }, { 166,7333 }, { 167,7333 }, { 168,7333 }, { 169,7333 },
 { 170,7333 }, { 171,7333 }, { 172,7333 }, { 173,7333 }, { 174,7333 },
 { 175,7333 }, { 176,7333 }, { 177,7333 }, { 178,7333 }, { 179,7333 },
 { 180,7333 }, { 181,7333 }, { 182,7333 }, { 183,7333 }, { 184,7333 },
 { 185,7333 }, { 186,7333 }, { 187,7333 }, { 188,7333 }, { 189,7333 },
 { 190,7333 }, { 191,7333 }, { 192,7333 }, { 193,7333 }, { 194,7333 },
 { 195,7333 }, { 196,7333 }, { 197,7333 }, { 198,7333 }, { 199,7333 },
 { 200,7333 }, { 201,7333 }, { 202,7333 }, { 203,7333 }, { 204,7333 },

 { 205,7333 }, { 206,7333 }, { 207,7333 }, { 208,7333 }, { 209,7333 },
 { 210,7333 }, { 211,7333 }, { 212,7333 }, { 213,7333 }, { 214,7333 },
 { 215,7333 }, { 216,7333 }, { 217,7333 }, { 218,7333 }, { 219,7333 },
 { 220,7333 }, { 221,7333 }, { 222,7333 }, { 223,7333 }, { 224,7333 },
 { 225,7333 }, { 226,7333 }, { 227,7333 }, { 228,7333 }, { 229,7333 },
 { 230,7333 }, { 231,7333 }, { 232,7333 }, { 233,7333 }, { 234,7333 },
 { 235,7333 }, { 236,7333 }, { 237,7333 }, { 238,7333 }, { 239,7333 },
 { 240,7333 }, { 241,7333 }, { 242,7333 }, { 243,7333 }, { 244,7333 },
 { 245,7333 }, { 246,7333 }, { 247,7333 }, { 248,7333 }, { 249,7333 },
 { 250,7333 }, { 251,7333 }, { 252,7333 }, { 253,7333 }, { 254,7333 },

 { 255,7333 }, {   0,  71 }, {   0,28575 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,7076 }, {   0,   0 },
 {  38,-1783 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {  48,7076 }, {  49,7076 }, {  50,7076 }, {  51,7076 }, {  52,7076 },
 {  53,7076 }, {  54,7076 }, {  55,7076 }, {  56,7076 }, {  57,7076 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,7076 }, {  66,7076 }, {  67,7076 },
 {  68,7076 }, {  69,7076 }, {  70,7076 }, {  71,7076 }, {  72,7076 },
 {  73,7076 }, {  74,7076 }, {  75,7076 }, {  76,7076 }, {  77,7076 },
 {  78,7076 }, {  79,7076 }, {  80,7076 }, {  81,7076 }, {  82,7076 },
 {  83,7076 }, {  84,7076 }, {  85,7076 }, {  86,7076 }, {  87,7076 },
 {  88,7076 }, {  89,7076 }, {  90,7076 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,7076 }, {   0,   0 }, {  97,7076 },

 {  98,7076 }, {  99,7076 }, { 100,7076 }, { 101,7076 }, { 102,7076 },
 { 103,7076 }, { 104,7076 }, { 105,7076 }, { 106,7076 }, { 107,7076 },
 { 108,7076 }, { 109,7076 }, { 110,7076 }, { 111,7076 }, { 112,7076 },
 { 113,7076 }, { 114,7076 }, { 115,7076 }, { 116,7076 }, { 117,7076 },
 { 118,7076 }, { 119,7076 }, { 120,7076 }, { 121,7076 }, { 122,7076 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,7076 }, { 129,7076 }, { 130,7076 }, { 131,7076 }, { 132,7076 },
 { 133,7076 }, { 134,7076 }, { 135,7076 }, { 136,7076 }, { 137,7076 },
 { 138,7076 }, { 139,7076 }, { 140,7076 }, { 141,7076 }, { 142,7076 },
 { 143,7076 }, { 144,7076 }, { 145,7076 }, { 146,7076 }, { 147,7076 },

 { 148,7076 }, { 149,7076 }, { 150,7076 }, { 151,7076 }, { 152,7076 },
 { 153,7076 }, { 154,7076 }, { 155,7076 }, { 156,7076 }, { 157,7076 },
 { 158,7076 }, { 159,7076 }, { 160,7076 }, { 161,7076 }, { 162,7076 },
 { 163,7076 }, { 164,7076 }, { 165,7076 }, { 166,7076 }, { 167,7076 },
 { 168,7076 }, { 169,7076 }, { 170,7076 }, { 171,7076 }, { 172,7076 },
 { 173,7076 }, { 174,7076 }, { 175,7076 }, { 176,7076 }, { 177,7076 },
 { 178,7076 }, { 179,7076 }, { 180,7076 }, { 181,7076 }, { 182,7076 },
 { 183,7076 }, { 184,7076 }, { 185,7076 }, { 186,7076 }, { 187,7076 },
 { 188,7076 }, { 189,7076 }, { 190,7076 }, { 191,7076 }, { 192,7076 },
 { 193,7076 }, { 194,7076 }, { 195,7076 }, { 196,7076 }, { 197,7076 },

 { 198,7076 }, { 199,7076 }, { 200,7076 }, { 201,7076 }, { 202,7076 },
 { 203,7076 }, { 204,7076 }, { 205,7076 }, { 206,7076 }, { 207,7076 },
 { 208,7076 }, { 209,7076 }, { 210,7076 }, { 211,7076 }, { 212,7076 },
 { 213,7076 }, { 214,7076 }, { 215,7076 }, { 216,7076 }, { 217,7076 },
 { 218,7076 }, { 219,7076 }, { 220,7076 }, { 221,7076 }, { 222,7076 },
 { 223,7076 }, { 224,7076 }, { 225,7076 }, { 226,7076 }, { 227,7076 },
 { 228,7076 }, { 229,7076 }, { 230,7076 }, { 231,7076 }, { 232,7076 },
 { 233,7076 }, { 234,7076 }, { 235,7076 }, { 236,7076 }, { 237,7076 },
 { 238,7076 }, { 239,7076 }, { 240,7076 }, { 241,7076 }, { 242,7076 },
 { 243,7076 }, { 244,7076 }, { 245,7076 }, { 246,7076 }, { 247,7076 },

 { 248,7076 }, { 249,7076 }, { 250,7076 }, { 251,7076 }, { 252,7076 },
 { 253,7076 }, { 254,7076 }, { 255,7076 }, {   0,  71 }, {   0,28318 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  36,6819 }, {   0,   0 }, {   0,   0 }, {  39,-2038 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,6819 }, {  49,6819 }, {  50,6819 },
 {  51,6819 }, {  52,6819 }, {  53,6819 }, {  54,6819 }, {  55,6819 },
 {  56,6819 }, {  57,6819 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,6819 },
 {  66,6819 }, {  67,6819 }, {  68,6819 }, {  69,6819 }, {  70,6819 },
 {  71,6819 }, {  72,6819 }, {  73,6819 }, {  74,6819 }, {  75,6819 },
 {  76,6819 }, {  77,6819 }, {  78,6819 }, {  79,6819 }, {  80,6819 },
 {  81,6819 }, {  82,6819 }, {  83,6819 }, {  84,6819 }, {  85,6819 },
 {  86,6819 }, {  87,6819 }, {  88,6819 }, {  89,6819 }, {  90,6819 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,6819 },
 {   0,   0 }, {  97,6819 }, {  98,6819 }, {  99,6819 }, { 100,6819 },
 { 101,6819 }, { 102,6819 }, { 103,6819 }, { 104,6819 }, { 105,6819 },
 { 106,6819 }, { 107,6819 }, { 108,6819 }, { 109,6819 }, { 110,6819 },
 { 111,6819 }, { 112,6819 }, { 113,6819 }, { 114,6819 }, { 115,6819 },
 { 116,6819 }, { 117,6819 }, { 118,6819 }, { 119,6819 }, { 120,6819 },
 { 121,6819 }, { 122,6819 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 128,6819 }, { 129,6819 }, { 130,6819 },
 { 131,6819 }, { 132,6819 }, { 133,6819 }, { 134,6819 }, { 135,6819 },
 { 136,6819 }, { 137,6819 }, { 138,6819 }, { 139,6819 }, { 140,6819 },

 { 141,6819 }, { 142,6819 }, { 143,6819 }, { 144,6819 }, { 145,6819 },
 { 146,6819 }, { 147,6819 }, { 148,6819 }, { 149,6819 }, { 150,6819 },
 { 151,6819 }, { 152,6819 }, { 153,6819 }, { 154,6819 }, { 155,6819 },
 { 156,6819 }, { 157,6819 }, { 158,6819 }, { 159,6819 }, { 160,6819 },
 { 161,6819 }, { 162,6819 }, { 163,6819 }, { 164,6819 }, { 165,6819 },
 { 166,6819 }, { 167,6819 }, { 168,6819 }, { 169,6819 }, { 170,6819 },
 { 171,6819 }, { 172,6819 }, { 173,6819 }, { 174,6819 }, { 175,6819 },
 { 176,6819 }, { 177,6819 }, { 178,6819 }, { 179,6819 }, { 180,6819 },
 { 181,6819 }, { 182,6819 }, { 183,6819 }, { 184,6819 }, { 185,6819 },
 { 186,6819 }, { 187,6819 }, { 188,6819 }, { 189,6819 }, { 190,6819 },

 { 191,6819 }, { 192,6819 }, { 193,6819 }, { 194,6819 }, { 195,6819 },
 { 196,6819 }, { 197,6819 }, { 198,6819 }, { 199,6819 }, { 200,6819 },
 { 201,6819 }, { 202,6819 }, { 203,6819 }, { 204,6819 }, { 205,6819 },
 { 206,6819 }, { 207,6819 }, { 208,6819 }, { 209,6819 }, { 210,6819 },
 { 211,6819 }, { 212,6819 }, { 213,6819 }, { 214,6819 }, { 215,6819 },
 { 216,6819 }, { 217,6819 }, { 218,6819 }, { 219,6819 }, { 220,6819 },
 { 221,6819 }, { 222,6819 }, { 223,6819 }, { 224,6819 }, { 225,6819 },
 { 226,6819 }, { 227,6819 }, { 228,6819 }, { 229,6819 }, { 230,6819 },
 { 231,6819 }, { 232,6819 }, { 233,6819 }, { 234,6819 }, { 235,6819 },
 { 236,6819 }, { 237,6819 }, { 238,6819 }, { 239,6819 }, { 240,6819 },

 { 241,6819 }, { 242,6819 }, { 243,6819 }, { 244,6819 }, { 245,6819 },
 { 246,6819 }, { 247,6819 }, { 248,6819 }, { 249,6819 }, { 250,6819 },
 { 251,6819 }, { 252,6819 }, { 253,6819 }, { 254,6819 }, { 255,6819 },
 {   0,  10 }, {   0,28061 }, {   1,6819 }, {   2,6819 }, {   3,6819 },
 {   4,6819 }, {   5,6819 }, {   6,6819 }, {   7,6819 }, {   8,6819 },
 {   9,6819 }, {  10,6819 }, {  11,6819 }, {  12,6819 }, {  13,6819 },
 {  14,6819 }, {  15,6819 }, {  16,6819 }, {  17,6819 }, {  18,6819 },
 {  19,6819 }, {  20,6819 }, {  21,6819 }, {  22,6819 }, {  23,6819 },
 {  24,6819 }, {  25,6819 }, {  26,6819 }, {  27,6819 }, {  28,6819 },
 {  29,6819 }, {  30,6819 }, {  31,6819 }, {  32,6819 }, {  33,6819 },

 {  34,6819 }, {  35,6819 }, {  36,6819 }, {  37,6819 }, {  38,6819 },
 {   0,   0 }, {  40,6819 }, {  41,6819 }, {  42,6819 }, {  43,6819 },
 {  44,6819 }, {  45,6819 }, {  46,6819 }, {  47,6819 }, {  48,6819 },
 {  49,6819 }, {  50,6819 }, {  51,6819 }, {  52,6819 }, {  53,6819 },
 {  54,6819 }, {  55,6819 }, {  56,6819 }, {  57,6819 }, {  58,6819 },
 {  59,6819 }, {  60,6819 }, {  61,6819 }, {  62,6819 }, {  63,6819 },
 {  64,6819 }, {  65,6819 }, {  66,6819 }, {  67,6819 }, {  68,6819 },
 {  69,6819 }, {  70,6819 }, {  71,6819 }, {  72,6819 }, {  73,6819 },
 {  74,6819 }, {  75,6819 }, {  76,6819 }, {  77,6819 }, {  78,6819 },
 {  79,6819 }, {  80,6819 }, {  81,6819 }, {  82,6819 }, {  83,6819 },

 {  84,6819 }, {  85,6819 }, {  86,6819 }, {  87,6819 }, {  88,6819 },
 {  89,6819 }, {  90,6819 }, {  91,6819 }, {  92,6819 }, {  93,6819 },
 {  94,6819 }, {  95,6819 }, {  96,6819 }, {  97,6819 }, {  98,6819 },
 {  99,6819 }, { 100,6819 }, { 101,6819 }, { 102,6819 }, { 103,6819 },
 { 104,6819 }, { 105,6819 }, { 106,6819 }, { 107,6819 }, { 108,6819 },
 { 109,6819 }, { 110,6819 }, { 111,6819 }, { 112,6819 }, { 113,6819 },
 { 114,6819 }, { 115,6819 }, { 116,6819 }, { 117,6819 }, { 118,6819 },
 { 119,6819 }, { 120,6819 }, { 121,6819 }, { 122,6819 }, { 123,6819 },
 { 124,6819 }, { 125,6819 }, { 126,6819 }, { 127,6819 }, { 128,6819 },
 { 129,6819 }, { 130,6819 }, { 131,6819 }, { 132,6819 }, { 133,6819 },

 { 134,6819 }, { 135,6819 }, { 136,6819 }, { 137,6819 }, { 138,6819 },
 { 139,6819 }, { 140,6819 }, { 141,6819 }, { 142,6819 }, { 143,6819 },
 { 144,6819 }, { 145,6819 }, { 146,6819 }, { 147,6819 }, { 148,6819 },
 { 149,6819 }, { 150,6819 }, { 151,6819 }, { 152,6819 }, { 153,6819 },
 { 154,6819 }, { 155,6819 }, { 156,6819 }, { 157,6819 }, { 158,6819 },
 { 159,6819 }, { 160,6819 }, { 161,6819 }, { 162,6819 }, { 163,6819 },
 { 164,6819 }, { 165,6819 }, { 166,6819 }, { 167,6819 }, { 168,6819 },
 { 169,6819 }, { 170,6819 }, { 171,6819 }, { 172,6819 }, { 173,6819 },
 { 174,6819 }, { 175,6819 }, { 176,6819 }, { 177,6819 }, { 178,6819 },
 { 179,6819 }, { 180,6819 }, { 181,6819 }, { 182,6819 }, { 183,6819 },

 { 184,6819 }, { 185,6819 }, { 186,6819 }, { 187,6819 }, { 188,6819 },
 { 189,6819 }, { 190,6819 }, { 191,6819 }, { 192,6819 }, { 193,6819 },
 { 194,6819 }, { 195,6819 }, { 196,6819 }, { 197,6819 }, { 198,6819 },
 { 199,6819 }, { 200,6819 }, { 201,6819 }, { 202,6819 }, { 203,6819 },
 { 204,6819 }, { 205,6819 }, { 206,6819 }, { 207,6819 }, { 208,6819 },
 { 209,6819 }, { 210,6819 }, { 211,6819 }, { 212,6819 }, { 213,6819 },
 { 214,6819 }, { 215,6819 }, { 216,6819 }, { 217,6819 }, { 218,6819 },
 { 219,6819 }, { 220,6819 }, { 221,6819 }, { 222,6819 }, { 223,6819 },
 { 224,6819 }, { 225,6819 }, { 226,6819 }, { 227,6819 }, { 228,6819 },
 { 229,6819 }, { 230,6819 }, { 231,6819 }, { 232,6819 }, { 233,6819 },

 { 234,6819 }, { 235,6819 }, { 236,6819 }, { 237,6819 }, { 238,6819 },
 { 239,6819 }, { 240,6819 }, { 241,6819 }, { 242,6819 }, { 243,6819 },
 { 244,6819 }, { 245,6819 }, { 246,6819 }, { 247,6819 }, { 248,6819 },
 { 249,6819 }, { 250,6819 }, { 251,6819 }, { 252,6819 }, { 253,6819 },
 { 254,6819 }, { 255,6819 }, { 256,6819 }, {   0,   5 }, {   0,27803 },
 {   1,6819 }, {   2,6819 }, {   3,6819 }, {   4,6819 }, {   5,6819 },
 {   6,6819 }, {   7,6819 }, {   8,6819 }, {   9,6819 }, {  10,6819 },
 {  11,6819 }, {  12,6819 }, {  13,6819 }, {  14,6819 }, {  15,6819 },
 {  16,6819 }, {  17,6819 }, {  18,6819 }, {  19,6819 }, {  20,6819 },
 {  21,6819 }, {  22,6819 }, {  23,6819 }, {  24,6819 }, {  25,6819 },

 {  26,6819 }, {  27,6819 }, {  28,6819 }, {  29,6819 }, {  30,6819 },
 {  31,6819 }, {  32,6819 }, {  33,6819 }, {  34,6819 }, {  35,6819 },
 {  36,6819 }, {  37,6819 }, {  38,6819 }, {  39,6819 }, {  40,6819 },
 {  41,6819 }, {   0,   0 }, {  43,6819 }, {  44,6819 }, {  45,6819 },
 {  46,6819 }, {   0,   0 }, {  48,6819 }, {  49,6819 }, {  50,6819 },
 {  51,6819 }, {  52,6819 }, {  53,6819 }, {  54,6819 }, {  55,6819 },
 {  56,6819 }, {  57,6819 }, {  58,6819 }, {  59,6819 }, {  60,6819 },
 {  61,6819 }, {  62,6819 }, {  63,6819 }, {  64,6819 }, {  65,6819 },
 {  66,6819 }, {  67,6819 }, {  68,6819 }, {  69,6819 }, {  70,6819 },
 {  71,6819 }, {  72,6819 }, {  73,6819 }, {  74,6819 }, {  75,6819 },

 {  76,6819 }, {  77,6819 }, {  78,6819 }, {  79,6819 }, {  80,6819 },
 {  81,6819 }, {  82,6819 }, {  83,6819 }, {  84,6819 }, {  85,6819 },
 {  86,6819 }, {  87,6819 }, {  88,6819 }, {  89,6819 }, {  90,6819 },
 {  91,6819 }, {  92,6819 }, {  93,6819 }, {  94,6819 }, {  95,6819 },
 {  96,6819 }, {  97,6819 }, {  98,6819 }, {  99,6819 }, { 100,6819 },
 { 101,6819 }, { 102,6819 }, { 103,6819 }, { 104,6819 }, { 105,6819 },
 { 106,6819 }, { 107,6819 }, { 108,6819 }, { 109,6819 }, { 110,6819 },
 { 111,6819 }, { 112,6819 }, { 113,6819 }, { 114,6819 }, { 115,6819 },
 { 116,6819 }, { 117,6819 }, { 118,6819 }, { 119,6819 }, { 120,6819 },
 { 121,6819 }, { 122,6819 }, { 123,6819 }, { 124,6819 }, { 125,6819 },

 { 126,6819 }, { 127,6819 }, { 128,6819 }, { 129,6819 }, { 130,6819 },
 { 131,6819 }, { 132,6819 }, { 133,6819 }, { 134,6819 }, { 135,6819 },
 { 136,6819 }, { 137,6819 }, { 138,6819 }, { 139,6819 }, { 140,6819 },
 { 141,6819 }, { 142,6819 }, { 143,6819 }, { 144,6819 }, { 145,6819 },
 { 146,6819 }, { 147,6819 }, { 148,6819 }, { 149,6819 }, { 150,6819 },
 { 151,6819 }, { 152,6819 }, { 153,6819 }, { 154,6819 }, { 155,6819 },
 { 156,6819 }, { 157,6819 }, { 158,6819 }, { 159,6819 }, { 160,6819 },
 { 161,6819 }, { 162,6819 }, { 163,6819 }, { 164,6819 }, { 165,6819 },
 { 166,6819 }, { 167,6819 }, { 168,6819 }, { 169,6819 }, { 170,6819 },
 { 171,6819 }, { 172,6819 }, { 173,6819 }, { 174,6819 }, { 175,6819 },

 { 176,6819 }, { 177,6819 }, { 178,6819 }, { 179,6819 }, { 180,6819 },
 { 181,6819 }, { 182,6819 }, { 183,6819 }, { 184,6819 }, { 185,6819 },
 { 186,6819 }, { 187,6819 }, { 188,6819 }, { 189,6819 }, { 190,6819 },
 { 191,6819 }, { 192,6819 }, { 193,6819 }, { 194,6819 }, { 195,6819 },
 { 196,6819 }, { 197,6819 }, { 198,6819 }, { 199,6819 }, { 200,6819 },
 { 201,6819 }, { 202,6819 }, { 203,6819 }, { 204,6819 }, { 205,6819 },
 { 206,6819 }, { 207,6819 }, { 208,6819 }, { 209,6819 }, { 210,6819 },
 { 211,6819 }, { 212,6819 }, { 213,6819 }, { 214,6819 }, { 215,6819 },
 { 216,6819 }, { 217,6819 }, { 218,6819 }, { 219,6819 }, { 220,6819 },
 { 221,6819 }, { 222,6819 }, { 223,6819 }, { 224,6819 }, { 225,6819 },

 { 226,6819 }, { 227,6819 }, { 228,6819 }, { 229,6819 }, { 230,6819 },
 { 231,6819 }, { 232,6819 }, { 233,6819 }, { 234,6819 }, { 235,6819 },
 { 236,6819 }, { 237,6819 }, { 238,6819 }, { 239,6819 }, { 240,6819 },
 { 241,6819 }, { 242,6819 }, { 243,6819 }, { 244,6819 }, { 245,6819 },
 { 246,6819 }, { 247,6819 }, { 248,6819 }, { 249,6819 }, { 250,6819 },
 { 251,6819 }, { 252,6819 }, { 253,6819 }, { 254,6819 }, { 255,6819 },
 { 256,6819 }, {   0,   5 }, {   0,27545 }, {   1,6561 }, {   2,6561 },
 {   3,6561 }, {   4,6561 }, {   5,6561 }, {   6,6561 }, {   7,6561 },
 {   8,6561 }, {   9,6561 }, {  10,6561 }, {  11,6561 }, {  12,6561 },
 {  13,6561 }, {  14,6561 }, {  15,6561 }, {  16,6561 }, {  17,6561 },

 {  18,6561 }, {  19,6561 }, {  20,6561 }, {  21,6561 }, {  22,6561 },
 {  23,6561 }, {  24,6561 }, {  25,6561 }, {  26,6561 }, {  27,6561 },
 {  28,6561 }, {  29,6561 }, {  30,6561 }, {  31,6561 }, {  32,6561 },
 {  33,6561 }, {  34,6561 }, {  35,6561 }, {  36,6561 }, {  37,6561 },
 {  38,6561 }, {  39,6561 }, {  40,6561 }, {  41,6561 }, {   0,   0 },
 {  43,6561 }, {  44,6561 }, {  45,6561 }, {  46,6561 }, {   0,   0 },
 {  48,6561 }, {  49,6561 }, {  50,6561 }, {  51,6561 }, {  52,6561 },
 {  53,6561 }, {  54,6561 }, {  55,6561 }, {  56,6561 }, {  57,6561 },
 {  58,6561 }, {  59,6561 }, {  60,6561 }, {  61,6561 }, {  62,6561 },
 {  63,6561 }, {  64,6561 }, {  65,6561 }, {  66,6561 }, {  67,6561 },

 {  68,6561 }, {  69,6561 }, {  70,6561 }, {  71,6561 }, {  72,6561 },
 {  73,6561 }, {  74,6561 }, {  75,6561 }, {  76,6561 }, {  77,6561 },
 {  78,6561 }, {  79,6561 }, {  80,6561 }, {  81,6561 }, {  82,6561 },
 {  83,6561 }, {  84,6561 }, {  85,6561 }, {  86,6561 }, {  87,6561 },
 {  88,6561 }, {  89,6561 }, {  90,6561 }, {  91,6561 }, {  92,6561 },
 {  93,6561 }, {  94,6561 }, {  95,6561 }, {  96,6561 }, {  97,6561 },
 {  98,6561 }, {  99,6561 }, { 100,6561 }, { 101,6561 }, { 102,6561 },
 { 103,6561 }, { 104,6561 }, { 105,6561 }, { 106,6561 }, { 107,6561 },
 { 108,6561 }, { 109,6561 }, { 110,6561 }, { 111,6561 }, { 112,6561 },
 { 113,6561 }, { 114,6561 }, { 115,6561 }, { 116,6561 }, { 117,6561 },

 { 118,6561 }, { 119,6561 }, { 120,6561 }, { 121,6561 }, { 122,6561 },
 { 123,6561 }, { 124,6561 }, { 125,6561 }, { 126,6561 }, { 127,6561 },
 { 128,6561 }, { 129,6561 }, { 130,6561 }, { 131,6561 }, { 132,6561 },
 { 133,6561 }, { 134,6561 }, { 135,6561 }, { 136,6561 }, { 137,6561 },
 { 138,6561 }, { 139,6561 }, { 140,6561 }, { 141,6561 }, { 142,6561 },
 { 143,6561 }, { 144,6561 }, { 145,6561 }, { 146,6561 }, { 147,6561 },
 { 148,6561 }, { 149,6561 }, { 150,6561 }, { 151,6561 }, { 152,6561 },
 { 153,6561 }, { 154,6561 }, { 155,6561 }, { 156,6561 }, { 157,6561 },
 { 158,6561 }, { 159,6561 }, { 160,6561 }, { 161,6561 }, { 162,6561 },
 { 163,6561 }, { 164,6561 }, { 165,6561 }, { 166,6561 }, { 167,6561 },

 { 168,6561 }, { 169,6561 }, { 170,6561 }, { 171,6561 }, { 172,6561 },
 { 173,6561 }, { 174,6561 }, { 175,6561 }, { 176,6561 }, { 177,6561 },
 { 178,6561 }, { 179,6561 }, { 180,6561 }, { 181,6561 }, { 182,6561 },
 { 183,6561 }, { 184,6561 }, { 185,6561 }, { 186,6561 }, { 187,6561 },
 { 188,6561 }, { 189,6561 }, { 190,6561 }, { 191,6561 }, { 192,6561 },
 { 193,6561 }, { 194,6561 }, { 195,6561 }, { 196,6561 }, { 197,6561 },
 { 198,6561 }, { 199,6561 }, { 200,6561 }, { 201,6561 }, { 202,6561 },
 { 203,6561 }, { 204,6561 }, { 205,6561 }, { 206,6561 }, { 207,6561 },
 { 208,6561 }, { 209,6561 }, { 210,6561 }, { 211,6561 }, { 212,6561 },
 { 213,6561 }, { 214,6561 }, { 215,6561 }, { 216,6561 }, { 217,6561 },

 { 218,6561 }, { 219,6561 }, { 220,6561 }, { 221,6561 }, { 222,6561 },
 { 223,6561 }, { 224,6561 }, { 225,6561 }, { 226,6561 }, { 227,6561 },
 { 228,6561 }, { 229,6561 }, { 230,6561 }, { 231,6561 }, { 232,6561 },
 { 233,6561 }, { 234,6561 }, { 235,6561 }, { 236,6561 }, { 237,6561 },
 { 238,6561 }, { 239,6561 }, { 240,6561 }, { 241,6561 }, { 242,6561 },
 { 243,6561 }, { 244,6561 }, { 245,6561 }, { 246,6561 }, { 247,6561 },
 { 248,6561 }, { 249,6561 }, { 250,6561 }, { 251,6561 }, { 252,6561 },
 { 253,6561 }, { 254,6561 }, { 255,6561 }, { 256,6561 }, {   0,  43 },
 {   0,27287 }, {   1,6689 }, {   2,6689 }, {   3,6689 }, {   4,6689 },
 {   5,6689 }, {   6,6689 }, {   7,6689 }, {   8,6689 }, {   9,6689 },

 {  10,6689 }, {  11,6689 }, {  12,6689 }, {  13,6689 }, {  14,6689 },
 {  15,6689 }, {  16,6689 }, {  17,6689 }, {  18,6689 }, {  19,6689 },
 {  20,6689 }, {  21,6689 }, {  22,6689 }, {  23,6689 }, {  24,6689 },
 {  25,6689 }, {  26,6689 }, {  27,6689 }, {  28,6689 }, {  29,6689 },
 {  30,6689 }, {  31,6689 }, {  32,6689 }, {  33,6689 }, {   0,   0 },
 {  35,6689 }, {  36,6689 }, {  37,6689 }, {  38,6689 }, {  39,6689 },
 {  40,6689 }, {  41,6689 }, {  42,6689 }, {  43,6689 }, {  44,6689 },
 {  45,6689 }, {  46,6689 }, {  47,6689 }, {  48,6689 }, {  49,6689 },
 {  50,6689 }, {  51,6689 }, {  52,6689 }, {  53,6689 }, {  54,6689 },
 {  55,6689 }, {  56,6689 }, {  57,6689 }, {  58,6689 }, {  59,6689 },

 {  60,6689 }, {  61,6689 }, {  62,6689 }, {  63,6689 }, {  64,6689 },
 {  65,6689 }, {  66,6689 }, {  67,6689 }, {  68,6689 }, {  69,6689 },
 {  70,6689 }, {  71,6689 }, {  72,6689 }, {  73,6689 }, {  74,6689 },
 {  75,6689 }, {  76,6689 }, {  77,6689 }, {  78,6689 }, {  79,6689 },
 {  80,6689 }, {  81,6689 }, {  82,6689 }, {  83,6689 }, {  84,6689 },
 {  85,6689 }, {  86,6689 }, {  87,6689 }, {  88,6689 }, {  89,6689 },
 {  90,6689 }, {  91,6689 }, {  92,6689 }, {  93,6689 }, {  94,6689 },
 {  95,6689 }, {  96,6689 }, {  97,6689 }, {  98,6689 }, {  99,6689 },
 { 100,6689 }, { 101,6689 }, { 102,6689 }, { 103,6689 }, { 104,6689 },
 { 105,6689 }, { 106,6689 }, { 107,6689 }, { 108,6689 }, { 109,6689 },

 { 110,6689 }, { 111,6689 }, { 112,6689 }, { 113,6689 }, { 114,6689 },
 { 115,6689 }, { 116,6689 }, { 117,6689 }, { 118,6689 }, { 119,6689 },
 { 120,6689 }, { 121,6689 }, { 122,6689 }, { 123,6689 }, { 124,6689 },
 { 125,6689 }, { 126,6689 }, { 127,6689 }, { 128,6689 }, { 129,6689 },
 { 130,6689 }, { 131,6689 }, { 132,6689 }, { 133,6689 }, { 134,6689 },
 { 135,6689 }, { 136,6689 }, { 137,6689 }, { 138,6689 }, { 139,6689 },
 { 140,6689 }, { 141,6689 }, { 142,6689 }, { 143,6689 }, { 144,6689 },
 { 145,6689 }, { 146,6689 }, { 147,6689 }, { 148,6689 }, { 149,6689 },
 { 150,6689 }, { 151,6689 }, { 152,6689 }, { 153,6689 }, { 154,6689 },
 { 155,6689 }, { 156,6689 }, { 157,6689 }, { 158,6689 }, { 159,6689 },

 { 160,6689 }, { 161,6689 }, { 162,6689 }, { 163,6689 }, { 164,6689 },
 { 165,6689 }, { 166,6689 }, { 167,6689 }, { 168,6689 }, { 169,6689 },
 { 170,6689 }, { 171,6689 }, { 172,6689 }, { 173,6689 }, { 174,6689 },
 { 175,6689 }, { 176,6689 }, { 177,6689 }, { 178,6689 }, { 179,6689 },
 { 180,6689 }, { 181,6689 }, { 182,6689 }, { 183,6689 }, { 184,6689 },
 { 185,6689 }, { 186,6689 }, { 187,6689 }, { 188,6689 }, { 189,6689 },
 { 190,6689 }, { 191,6689 }, { 192,6689 }, { 193,6689 }, { 194,6689 },
 { 195,6689 }, { 196,6689 }, { 197,6689 }, { 198,6689 }, { 199,6689 },
 { 200,6689 }, { 201,6689 }, { 202,6689 }, { 203,6689 }, { 204,6689 },
 { 205,6689 }, { 206,6689 }, { 207,6689 }, { 208,6689 }, { 209,6689 },

 { 210,6689 }, { 211,6689 }, { 212,6689 }, { 213,6689 }, { 214,6689 },
 { 215,6689 }, { 216,6689 }, { 217,6689 }, { 218,6689 }, { 219,6689 },
 { 220,6689 }, { 221,6689 }, { 222,6689 }, { 223,6689 }, { 224,6689 },
 { 225,6689 }, { 226,6689 }, { 227,6689 }, { 228,6689 }, { 229,6689 },
 { 230,6689 }, { 231,6689 }, { 232,6689 }, { 233,6689 }, { 234,6689 },
 { 235,6689 }, { 236,6689 }, { 237,6689 }, { 238,6689 }, { 239,6689 },
 { 240,6689 }, { 241,6689 }, { 242,6689 }, { 243,6689 }, { 244,6689 },
 { 245,6689 }, { 246,6689 }, { 247,6689 }, { 248,6689 }, { 249,6689 },
 { 250,6689 }, { 251,6689 }, { 252,6689 }, { 253,6689 }, { 254,6689 },
 { 255,6689 }, { 256,6689 }, {   0,   9 }, {   0,27029 }, {   1,6689 },

 {   2,6689 }, {   3,6689 }, {   4,6689 }, {   5,6689 }, {   6,6689 },
 {   7,6689 }, {   8,6689 }, {   9,6689 }, {  10,6689 }, {  11,6689 },
 {  12,6689 }, {  13,6689 }, {  14,6689 }, {  15,6689 }, {  16,6689 },
 {  17,6689 }, {  18,6689 }, {  19,6689 }, {  20,6689 }, {  21,6689 },
 {  22,6689 }, {  23,6689 }, {  24,6689 }, {  25,6689 }, {  26,6689 },
 {  27,6689 }, {  28,6689 }, {  29,6689 }, {  30,6689 }, {  31,6689 },
 {  32,6689 }, {  33,6689 }, {  34,6689 }, {  35,6689 }, {  36,6689 },
 {  37,6689 }, {  38,6689 }, {   0,   0 }, {  40,6689 }, {  41,6689 },
 {  42,6689 }, {  43,6689 }, {  44,6689 }, {  45,6689 }, {  46,6689 },
 {  47,6689 }, {  48,6689 }, {  49,6689 }, {  50,6689 }, {  51,6689 },

 {  52,6689 }, {  53,6689 }, {  54,6689 }, {  55,6689 }, {  56,6689 },
 {  57,6689 }, {  58,6689 }, {  59,6689 }, {  60,6689 }, {  61,6689 },
 {  62,6689 }, {  63,6689 }, {  64,6689 }, {  65,6689 }, {  66,6689 },
 {  67,6689 }, {  68,6689 }, {  69,6689 }, {  70,6689 }, {  71,6689 },
 {  72,6689 }, {  73,6689 }, {  74,6689 }, {  75,6689 }, {  76,6689 },
 {  77,6689 }, {  78,6689 }, {  79,6689 }, {  80,6689 }, {  81,6689 },
 {  82,6689 }, {  83,6689 }, {  84,6689 }, {  85,6689 }, {  86,6689 },
 {  87,6689 }, {  88,6689 }, {  89,6689 }, {  90,6689 }, {  91,6689 },
 {  92,6689 }, {  93,6689 }, {  94,6689 }, {  95,6689 }, {  96,6689 },
 {  97,6689 }, {  98,6689 }, {  99,6689 }, { 100,6689 }, { 101,6689 },

 { 102,6689 }, { 103,6689 }, { 104,6689 }, { 105,6689 }, { 106,6689 },
 { 107,6689 }, { 108,6689 }, { 109,6689 }, { 110,6689 }, { 111,6689 },
 { 112,6689 }, { 113,6689 }, { 114,6689 }, { 115,6689 }, { 116,6689 },
 { 117,6689 }, { 118,6689 }, { 119,6689 }, { 120,6689 }, { 121,6689 },
 { 122,6689 }, { 123,6689 }, { 124,6689 }, { 125,6689 }, { 126,6689 },
 { 127,6689 }, { 128,6689 }, { 129,6689 }, { 130,6689 }, { 131,6689 },
 { 132,6689 }, { 133,6689 }, { 134,6689 }, { 135,6689 }, { 136,6689 },
 { 137,6689 }, { 138,6689 }, { 139,6689 }, { 140,6689 }, { 141,6689 },
 { 142,6689 }, { 143,6689 }, { 144,6689 }, { 145,6689 }, { 146,6689 },
 { 147,6689 }, { 148,6689 }, { 149,6689 }, { 150,6689 }, { 151,6689 },

 { 152,6689 }, { 153,6689 }, { 154,6689 }, { 155,6689 }, { 156,6689 },
 { 157,6689 }, { 158,6689 }, { 159,6689 }, { 160,6689 }, { 161,6689 },
 { 162,6689 }, { 163,6689 }, { 164,6689 }, { 165,6689 }, { 166,6689 },
 { 167,6689 }, { 168,6689 }, { 169,6689 }, { 170,6689 }, { 171,6689 },
 { 172,6689 }, { 173,6689 }, { 174,6689 }, { 175,6689 }, { 176,6689 },
 { 177,6689 }, { 178,6689 }, { 179,6689 }, { 180,6689 }, { 181,6689 },
 { 182,6689 }, { 183,6689 }, { 184,6689 }, { 185,6689 }, { 186,6689 },
 { 187,6689 }, { 188,6689 }, { 189,6689 }, { 190,6689 }, { 191,6689 },
 { 192,6689 }, { 193,6689 }, { 194,6689 }, { 195,6689 }, { 196,6689 },
 { 197,6689 }, { 198,6689 }, { 199,6689 }, { 200,6689 }, { 201,6689 },

 { 202,6689 }, { 203,6689 }, { 204,6689 }, { 205,6689 }, { 206,6689 },
 { 207,6689 }, { 208,6689 }, { 209,6689 }, { 210,6689 }, { 211,6689 },
 { 212,6689 }, { 213,6689 }, { 214,6689 }, { 215,6689 }, { 216,6689 },
 { 217,6689 }, { 218,6689 }, { 219,6689 }, { 220,6689 }, { 221,6689 },
 { 222,6689 }, { 223,6689 }, { 224,6689 }, { 225,6689 }, { 226,6689 },
 { 227,6689 }, { 228,6689 }, { 229,6689 }, { 230,6689 }, { 231,6689 },
 { 232,6689 }, { 233,6689 }, { 234,6689 }, { 235,6689 }, { 236,6689 },
 { 237,6689 }, { 238,6689 }, { 239,6689 }, { 240,6689 }, { 241,6689 },
 { 242,6689 }, { 243,6689 }, { 244,6689 }, { 245,6689 }, { 246,6689 },
 { 247,6689 }, { 248,6689 }, { 249,6689 }, { 250,6689 }, { 251,6689 },

 { 252,6689 }, { 253,6689 }, { 254,6689 }, { 255,6689 }, { 256,6689 },
 {   0,  21 }, {   0,26771 }, {   1,6689 }, {   2,6689 }, {   3,6689 },
 {   4,6689 }, {   5,6689 }, {   6,6689 }, {   7,6689 }, {   8,6689 },
 {   9,6689 }, {  10,6689 }, {  11,6689 }, {  12,6689 }, {  13,6689 },
 {  14,6689 }, {  15,6689 }, {  16,6689 }, {  17,6689 }, {  18,6689 },
 {  19,6689 }, {  20,6689 }, {  21,6689 }, {  22,6689 }, {  23,6689 },
 {  24,6689 }, {  25,6689 }, {  26,6689 }, {  27,6689 }, {  28,6689 },
 {  29,6689 }, {  30,6689 }, {  31,6689 }, {  32,6689 }, {  33,6689 },
 {  34,6689 }, {  35,6689 }, {  36,6689 }, {  37,6689 }, {  38,6689 },
 {   0,   0 }, {  40,6689 }, {  41,6689 }, {  42,6689 }, {  43,6689 },

 {  44,6689 }, {  45,6689 }, {  46,6689 }, {  47,6689 }, {  48,6689 },
 {  49,6689 }, {  50,6689 }, {  51,6689 }, {  52,6689 }, {  53,6689 },
 {  54,6689 }, {  55,6689 }, {  56,6689 }, {  57,6689 }, {  58,6689 },
 {  59,6689 }, {  60,6689 }, {  61,6689 }, {  62,6689 }, {  63,6689 },
 {  64,6689 }, {  65,6689 }, {  66,6689 }, {  67,6689 }, {  68,6689 },
 {  69,6689 }, {  70,6689 }, {  71,6689 }, {  72,6689 }, {  73,6689 },
 {  74,6689 }, {  75,6689 }, {  76,6689 }, {  77,6689 }, {  78,6689 },
 {  79,6689 }, {  80,6689 }, {  81,6689 }, {  82,6689 }, {  83,6689 },
 {  84,6689 }, {  85,6689 }, {  86,6689 }, {  87,6689 }, {  88,6689 },
 {  89,6689 }, {  90,6689 }, {  91,6689 }, {  92,6689 }, {  93,6689 },

 {  94,6689 }, {  95,6689 }, {  96,6689 }, {  97,6689 }, {  98,6689 },
 {  99,6689 }, { 100,6689 }, { 101,6689 }, { 102,6689 }, { 103,6689 },
 { 104,6689 }, { 105,6689 }, { 106,6689 }, { 107,6689 }, { 108,6689 },
 { 109,6689 }, { 110,6689 }, { 111,6689 }, { 112,6689 }, { 113,6689 },
 { 114,6689 }, { 115,6689 }, { 116,6689 }, { 117,6689 }, { 118,6689 },
 { 119,6689 }, { 120,6689 }, { 121,6689 }, { 122,6689 }, { 123,6689 },
 { 124,6689 }, { 125,6689 }, { 126,6689 }, { 127,6689 }, { 128,6689 },
 { 129,6689 }, { 130,6689 }, { 131,6689 }, { 132,6689 }, { 133,6689 },
 { 134,6689 }, { 135,6689 }, { 136,6689 }, { 137,6689 }, { 138,6689 },
 { 139,6689 }, { 140,6689 }, { 141,6689 }, { 142,6689 }, { 143,6689 },

 { 144,6689 }, { 145,6689 }, { 146,6689 }, { 147,6689 }, { 148,6689 },
 { 149,6689 }, { 150,6689 }, { 151,6689 }, { 152,6689 }, { 153,6689 },
 { 154,6689 }, { 155,6689 }, { 156,6689 }, { 157,6689 }, { 158,6689 },
 { 159,6689 }, { 160,6689 }, { 161,6689 }, { 162,6689 }, { 163,6689 },
 { 164,6689 }, { 165,6689 }, { 166,6689 }, { 167,6689 }, { 168,6689 },
 { 169,6689 }, { 170,6689 }, { 171,6689 }, { 172,6689 }, { 173,6689 },
 { 174,6689 }, { 175,6689 }, { 176,6689 }, { 177,6689 }, { 178,6689 },
 { 179,6689 }, { 180,6689 }, { 181,6689 }, { 182,6689 }, { 183,6689 },
 { 184,6689 }, { 185,6689 }, { 186,6689 }, { 187,6689 }, { 188,6689 },
 { 189,6689 }, { 190,6689 }, { 191,6689 }, { 192,6689 }, { 193,6689 },

 { 194,6689 }, { 195,6689 }, { 196,6689 }, { 197,6689 }, { 198,6689 },
 { 199,6689 }, { 200,6689 }, { 201,6689 }, { 202,6689 }, { 203,6689 },
 { 204,6689 }, { 205,6689 }, { 206,6689 }, { 207,6689 }, { 208,6689 },
 { 209,6689 }, { 210,6689 }, { 211,6689 }, { 212,6689 }, { 213,6689 },
 { 214,6689 }, { 215,6689 }, { 216,6689 }, { 217,6689 }, { 218,6689 },
 { 219,6689 }, { 220,6689 }, { 221,6689 }, { 222,6689 }, { 223,6689 },
 { 224,6689 }, { 225,6689 }, { 226,6689 }, { 227,6689 }, { 228,6689 },
 { 229,6689 }, { 230,6689 }, { 231,6689 }, { 232,6689 }, { 233,6689 },
 { 234,6689 }, { 235,6689 }, { 236,6689 }, { 237,6689 }, { 238,6689 },
 { 239,6689 }, { 240,6689 }, { 241,6689 }, { 242,6689 }, { 243,6689 },

 { 244,6689 }, { 245,6689 }, { 246,6689 }, { 247,6689 }, { 248,6689 },
 { 249,6689 }, { 250,6689 }, { 251,6689 }, { 252,6689 }, { 253,6689 },
 { 254,6689 }, { 255,6689 }, { 256,6689 }, {   0,  18 }, {   0,26513 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  18 }, {   0,26508 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   9,6689 }, {  10,6694 },
 {  11,6689 }, {  12,6689 }, {  13,6694 }, {   9,6713 }, {  10,6713 },
 {  11,6713 }, {  12,6713 }, {  13,6713 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,  18 }, {   0,26484 }, {   0,   0 },
 {   0,   0 }, {  32,6689 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {  32,6713 }, {   9,6689 }, {  10,6689 }, {  11,6689 },
 {  12,6689 }, {  13,6689 }, {   0,   0 }, {  39,-3830 }, {  45,-3827 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  45,-3828 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  32,6689 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  39,-3854 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  45,-3852 }, {   0,  22 },
 {   0,26437 }, {   1,6947 }, {   2,6947 }, {   3,6947 }, {   4,6947 },
 {   5,6947 }, {   6,6947 }, {   7,6947 }, {   8,6947 }, {   9,6947 },

 {  10,6947 }, {  11,6947 }, {  12,6947 }, {  13,6947 }, {  14,6947 },
 {  15,6947 }, {  16,6947 }, {  17,6947 }, {  18,6947 }, {  19,6947 },
 {  20,6947 }, {  21,6947 }, {  22,6947 }, {  23,6947 }, {  24,6947 },
 {  25,6947 }, {  26,6947 }, {  27,6947 }, {  28,6947 }, {  29,6947 },
 {  30,6947 }, {  31,6947 }, {  32,6947 }, {  33,6947 }, {  34,6947 },
 {  35,6947 }, {  36,6947 }, {  37,6947 }, {  38,6947 }, {   0,   0 },
 {  40,6947 }, {  41,6947 }, {  42,6947 }, {  43,6947 }, {  44,6947 },
 {  45,6947 }, {  46,6947 }, {  47,6947 }, {  48,6947 }, {  49,6947 },
 {  50,6947 }, {  51,6947 }, {  52,6947 }, {  53,6947 }, {  54,6947 },
 {  55,6947 }, {  56,6947 }, {  57,6947 }, {  58,6947 }, {  59,6947 },

 {  60,6947 }, {  61,6947 }, {  62,6947 }, {  63,6947 }, {  64,6947 },
 {  65,6947 }, {  66,6947 }, {  67,6947 }, {  68,6947 }, {  69,6947 },
 {  70,6947 }, {  71,6947 }, {  72,6947 }, {  73,6947 }, {  74,6947 },
 {  75,6947 }, {  76,6947 }, {  77,6947 }, {  78,6947 }, {  79,6947 },
 {  80,6947 }, {  81,6947 }, {  82,6947 }, {  83,6947 }, {  84,6947 },
 {  85,6947 }, {  86,6947 }, {  87,6947 }, {  88,6947 }, {  89,6947 },
 {  90,6947 }, {  91,6947 }, {   0,   0 }, {  93,6947 }, {  94,6947 },
 {  95,6947 }, {  96,6947 }, {  97,6947 }, {  98,6947 }, {  99,6947 },
 { 100,6947 }, { 101,6947 }, { 102,6947 }, { 103,6947 }, { 104,6947 },
 { 105,6947 }, { 106,6947 }, { 107,6947 }, { 108,6947 }, { 109,6947 },

 { 110,6947 }, { 111,6947 }, { 112,6947 }, { 113,6947 }, { 114,6947 },
 { 115,6947 }, { 116,6947 }, { 117,6947 }, { 118,6947 }, { 119,6947 },
 { 120,6947 }, { 121,6947 }, { 122,6947 }, { 123,6947 }, { 124,6947 },
 { 125,6947 }, { 126,6947 }, { 127,6947 }, { 128,6947 }, { 129,6947 },
 { 130,6947 }, { 131,6947 }, { 132,6947 }, { 133,6947 }, { 134,6947 },
 { 135,6947 }, { 136,6947 }, { 137,6947 }, { 138,6947 }, { 139,6947 },
 { 140,6947 }, { 141,6947 }, { 142,6947 }, { 143,6947 }, { 144,6947 },
 { 145,6947 }, { 146,6947 }, { 147,6947 }, { 148,6947 }, { 149,6947 },
 { 150,6947 }, { 151,6947 }, { 152,6947 }, { 153,6947 }, { 154,6947 },
 { 155,6947 }, { 156,6947 }, { 157,6947 }, { 158,6947 }, { 159,6947 },

 { 160,6947 }, { 161,6947 }, { 162,6947 }, { 163,6947 }, { 164,6947 },
 { 165,6947 }, { 166,6947 }, { 167,6947 }, { 168,6947 }, { 169,6947 },
 { 170,6947 }, { 171,6947 }, { 172,6947 }, { 173,6947 }, { 174,6947 },
 { 175,6947 }, { 176,6947 }, { 177,6947 }, { 178,6947 }, { 179,6947 },
 { 180,6947 }, { 181,6947 }, { 182,6947 }, { 183,6947 }, { 184,6947 },
 { 185,6947 }, { 186,6947 }, { 187,6947 }, { 188,6947 }, { 189,6947 },
 { 190,6947 }, { 191,6947 }, { 192,6947 }, { 193,6947 }, { 194,6947 },
 { 195,6947 }, { 196,6947 }, { 197,6947 }, { 198,6947 }, { 199,6947 },
 { 200,6947 }, { 201,6947 }, { 202,6947 }, { 203,6947 }, { 204,6947 },
 { 205,6947 }, { 206,6947 }, { 207,6947 }, { 208,6947 }, { 209,6947 },

 { 210,6947 }, { 211,6947 }, { 212,6947 }, { 213,6947 }, { 214,6947 },
 { 215,6947 }, { 216,6947 }, { 217,6947 }, { 218,6947 }, { 219,6947 },
 { 220,6947 }, { 221,6947 }, { 222,6947 }, { 223,6947 }, { 224,6947 },
 { 225,6947 }, { 226,6947 }, { 227,6947 }, { 228,6947 }, { 229,6947 },
 { 230,6947 }, { 231,6947 }, { 232,6947 }, { 233,6947 }, { 234,6947 },
 { 235,6947 }, { 236,6947 }, { 237,6947 }, { 238,6947 }, { 239,6947 },
 { 240,6947 }, { 241,6947 }, { 242,6947 }, { 243,6947 }, { 244,6947 },
 { 245,6947 }, { 246,6947 }, { 247,6947 }, { 248,6947 }, { 249,6947 },
 { 250,6947 }, { 251,6947 }, { 252,6947 }, { 253,6947 }, { 254,6947 },
 { 255,6947 }, { 256,6947 }, {   0,  22 }, {   0,26179 }, {   1,6689 },

 {   2,6689 }, {   3,6689 }, {   4,6689 }, {   5,6689 }, {   6,6689 },
 {   7,6689 }, {   8,6689 }, {   9,6689 }, {  10,6689 }, {  11,6689 },
 {  12,6689 }, {  13,6689 }, {  14,6689 }, {  15,6689 }, {  16,6689 },
 {  17,6689 }, {  18,6689 }, {  19,6689 }, {  20,6689 }, {  21,6689 },
 {  22,6689 }, {  23,6689 }, {  24,6689 }, {  25,6689 }, {  26,6689 },
 {  27,6689 }, {  28,6689 }, {  29,6689 }, {  30,6689 }, {  31,6689 },
 {  32,6689 }, {  33,6689 }, {  34,6689 }, {  35,6689 }, {  36,6689 },
 {  37,6689 }, {  38,6689 }, {   0,   0 }, {  40,6689 }, {  41,6689 },
 {  42,6689 }, {  43,6689 }, {  44,6689 }, {  45,6689 }, {  46,6689 },
 {  47,6689 }, {  48,6689 }, {  49,6689 }, {  50,6689 }, {  51,6689 },

 {  52,6689 }, {  53,6689 }, {  54,6689 }, {  55,6689 }, {  56,6689 },
 {  57,6689 }, {  58,6689 }, {  59,6689 }, {  60,6689 }, {  61,6689 },
 {  62,6689 }, {  63,6689 }, {  64,6689 }, {  65,6689 }, {  66,6689 },
 {  67,6689 }, {  68,6689 }, {  69,6689 }, {  70,6689 }, {  71,6689 },
 {  72,6689 }, {  73,6689 }, {  74,6689 }, {  75,6689 }, {  76,6689 },
 {  77,6689 }, {  78,6689 }, {  79,6689 }, {  80,6689 }, {  81,6689 },
 {  82,6689 }, {  83,6689 }, {  84,6689 }, {  85,6689 }, {  86,6689 },
 {  87,6689 }, {  88,6689 }, {  89,6689 }, {  90,6689 }, {  91,6689 },
 {   0,   0 }, {  93,6689 }, {  94,6689 }, {  95,6689 }, {  96,6689 },
 {  97,6689 }, {  98,6689 }, {  99,6689 }, { 100,6689 }, { 101,6689 },

 { 102,6689 }, { 103,6689 }, { 104,6689 }, { 105,6689 }, { 106,6689 },
 { 107,6689 }, { 108,6689 }, { 109,6689 }, { 110,6689 }, { 111,6689 },
 { 112,6689 }, { 113,6689 }, { 114,6689 }, { 115,6689 }, { 116,6689 },
 { 117,6689 }, { 118,6689 }, { 119,6689 }, { 120,6689 }, { 121,6689 },
 { 122,6689 }, { 123,6689 }, { 124,6689 }, { 125,6689 }, { 126,6689 },
 { 127,6689 }, { 128,6689 }, { 129,6689 }, { 130,6689 }, { 131,6689 },
 { 132,6689 }, { 133,6689 }, { 134,6689 }, { 135,6689 }, { 136,6689 },
 { 137,6689 }, { 138,6689 }, { 139,6689 }, { 140,6689 }, { 141,6689 },
 { 142,6689 }, { 143,6689 }, { 144,6689 }, { 145,6689 }, { 146,6689 },
 { 147,6689 }, { 148,6689 }, { 149,6689 }, { 150,6689 }, { 151,6689 },

 { 152,6689 }, { 153,6689 }, { 154,6689 }, { 155,6689 }, { 156,6689 },
 { 157,6689 }, { 158,6689 }, { 159,6689 }, { 160,6689 }, { 161,6689 },
 { 162,6689 }, { 163,6689 }, { 164,6689 }, { 165,6689 }, { 166,6689 },
 { 167,6689 }, { 168,6689 }, { 169,6689 }, { 170,6689 }, { 171,6689 },
 { 172,6689 }, { 173,6689 }, { 174,6689 }, { 175,6689 }, { 176,6689 },
 { 177,6689 }, { 178,6689 }, { 179,6689 }, { 180,6689 }, { 181,6689 },
 { 182,6689 }, { 183,6689 }, { 184,6689 }, { 185,6689 }, { 186,6689 },
 { 187,6689 }, { 188,6689 }, { 189,6689 }, { 190,6689 }, { 191,6689 },
 { 192,6689 }, { 193,6689 }, { 194,6689 }, { 195,6689 }, { 196,6689 },
 { 197,6689 }, { 198,6689 }, { 199,6689 }, { 200,6689 }, { 201,6689 },

 { 202,6689 }, { 203,6689 }, { 204,6689 }, { 205,6689 }, { 206,6689 },
 { 207,6689 }, { 208,6689 }, { 209,6689 }, { 210,6689 }, { 211,6689 },
 { 212,6689 }, { 213,6689 }, { 214,6689 }, { 215,6689 }, { 216,6689 },
 { 217,6689 }, { 218,6689 }, { 219,6689 }, { 220,6689 }, { 221,6689 },
 { 222,6689 }, { 223,6689 }, { 224,6689 }, { 225,6689 }, { 226,6689 },
 { 227,6689 }, { 228,6689 }, { 229,6689 }, { 230,6689 }, { 231,6689 },
 { 232,6689 }, { 233,6689 }, { 234,6689 }, { 235,6689 }, { 236,6689 },
 { 237,6689 }, { 238,6689 }, { 239,6689 }, { 240,6689 }, { 241,6689 },
 { 242,6689 }, { 243,6689 }, { 244,6689 }, { 245,6689 }, { 246,6689 },
 { 247,6689 }, { 248,6689 }, { 249,6689 }, { 250,6689 }, { 251,6689 },

 { 252,6689 }, { 253,6689 }, { 254,6689 }, { 255,6689 }, { 256,6689 },
 {   0,  31 }, {   0,25921 }, {   1,-4413 }, {   2,-4413 }, {   3,-4413 },
 {   4,-4413 }, {   5,-4413 }, {   6,-4413 }, {   7,-4413 }, {   8,-4413 },
 {   9,-4413 }, {  10,-4413 }, {  11,-4413 }, {  12,-4413 }, {  13,-4413 },
 {  14,-4413 }, {  15,-4413 }, {  16,-4413 }, {  17,-4413 }, {  18,-4413 },
 {  19,-4413 }, {  20,-4413 }, {  21,-4413 }, {  22,-4413 }, {  23,-4413 },
 {  24,-4413 }, {  25,-4413 }, {  26,-4413 }, {  27,-4413 }, {  28,-4413 },
 {  29,-4413 }, {  30,-4413 }, {  31,-4413 }, {  32,-4413 }, {  33,-4413 },
 {  34,-4413 }, {  35,-4413 }, {  36,-4413 }, {  37,-4413 }, {  38,-4413 },
 {  39,-4413 }, {  40,-4413 }, {  41,-4413 }, {  42,-4413 }, {  43,-4413 },

 {  44,-4413 }, {  45,-4413 }, {  46,-4413 }, {  47,-4413 }, {  48,6689 },
 {  49,6689 }, {  50,6689 }, {  51,6689 }, {  52,6689 }, {  53,6689 },
 {  54,6689 }, {  55,6689 }, {  56,-4413 }, {  57,-4413 }, {  58,-4413 },
 {  59,-4413 }, {  60,-4413 }, {  61,-4413 }, {  62,-4413 }, {  63,-4413 },
 {  64,-4413 }, {  65,-4413 }, {  66,-4413 }, {  67,-4413 }, {  68,-4413 },
 {  69,-4413 }, {  70,-4413 }, {  71,-4413 }, {  72,-4413 }, {  73,-4413 },
 {  74,-4413 }, {  75,-4413 }, {  76,-4413 }, {  77,-4413 }, {  78,-4413 },
 {  79,-4413 }, {  80,-4413 }, {  81,-4413 }, {  82,-4413 }, {  83,-4413 },
 {  84,-4413 }, {  85,6697 }, {  86,-4413 }, {  87,-4413 }, {  88,-4413 },
 {  89,-4413 }, {  90,-4413 }, {  91,-4413 }, {  92,-4413 }, {  93,-4413 },

 {  94,-4413 }, {  95,-4413 }, {  96,-4413 }, {  97,-4413 }, {  98,-4413 },
 {  99,-4413 }, { 100,-4413 }, { 101,-4413 }, { 102,-4413 }, { 103,-4413 },
 { 104,-4413 }, { 105,-4413 }, { 106,-4413 }, { 107,-4413 }, { 108,-4413 },
 { 109,-4413 }, { 110,-4413 }, { 111,-4413 }, { 112,-4413 }, { 113,-4413 },
 { 114,-4413 }, { 115,-4413 }, { 116,-4413 }, { 117,6720 }, { 118,-4413 },
 { 119,-4413 }, { 120,6758 }, { 121,-4413 }, { 122,-4413 }, { 123,-4413 },
 { 124,-4413 }, { 125,-4413 }, { 126,-4413 }, { 127,-4413 }, { 128,-4413 },
 { 129,-4413 }, { 130,-4413 }, { 131,-4413 }, { 132,-4413 }, { 133,-4413 },
 { 134,-4413 }, { 135,-4413 }, { 136,-4413 }, { 137,-4413 }, { 138,-4413 },
 { 139,-4413 }, { 140,-4413 }, { 141,-4413 }, { 142,-4413 }, { 143,-4413 },

 { 144,-4413 }, { 145,-4413 }, { 146,-4413 }, { 147,-4413 }, { 148,-4413 },
 { 149,-4413 }, { 150,-4413 }, { 151,-4413 }, { 152,-4413 }, { 153,-4413 },
 { 154,-4413 }, { 155,-4413 }, { 156,-4413 }, { 157,-4413 }, { 158,-4413 },
 { 159,-4413 }, { 160,-4413 }, { 161,-4413 }, { 162,-4413 }, { 163,-4413 },
 { 164,-4413 }, { 165,-4413 }, { 166,-4413 }, { 167,-4413 }, { 168,-4413 },
 { 169,-4413 }, { 170,-4413 }, { 171,-4413 }, { 172,-4413 }, { 173,-4413 },
 { 174,-4413 }, { 175,-4413 }, { 176,-4413 }, { 177,-4413 }, { 178,-4413 },
 { 179,-4413 }, { 180,-4413 }, { 181,-4413 }, { 182,-4413 }, { 183,-4413 },
 { 184,-4413 }, { 185,-4413 }, { 186,-4413 }, { 187,-4413 }, { 188,-4413 },
 { 189,-4413 }, { 190,-4413 }, { 191,-4413 }, { 192,-4413 }, { 193,-4413 },

 { 194,-4413 }, { 195,-4413 }, { 196,-4413 }, { 197,-4413 }, { 198,-4413 },
 { 199,-4413 }, { 200,-4413 }, { 201,-4413 }, { 202,-4413 }, { 203,-4413 },
 { 204,-4413 }, { 205,-4413 }, { 206,-4413 }, { 207,-4413 }, { 208,-4413 },
 { 209,-4413 }, { 210,-4413 }, { 211,-4413 }, { 212,-4413 }, { 213,-4413 },
 { 214,-4413 }, { 215,-4413 }, { 216,-4413 }, { 217,-4413 }, { 218,-4413 },
 { 219,-4413 }, { 220,-4413 }, { 221,-4413 }, { 222,-4413 }, { 223,-4413 },
 { 224,-4413 }, { 225,-4413 }, { 226,-4413 }, { 227,-4413 }, { 228,-4413 },
 { 229,-4413 }, { 230,-4413 }, { 231,-4413 }, { 232,-4413 }, { 233,-4413 },
 { 234,-4413 }, { 235,-4413 }, { 236,-4413 }, { 237,-4413 }, { 238,-4413 },
 { 239,-4413 }, { 240,-4413 }, { 241,-4413 }, { 242,-4413 }, { 243,-4413 },

 { 244,-4413 }, { 245,-4413 }, { 246,-4413 }, { 247,-4413 }, { 248,-4413 },
 { 249,-4413 }, { 250,-4413 }, { 251,-4413 }, { 252,-4413 }, { 253,-4413 },
 { 254,-4413 }, { 255,-4413 }, { 256,-4413 }, {   0,  35 }, {   0,25663 },
 {   1,6604 }, {   2,6604 }, {   3,6604 }, {   4,6604 }, {   5,6604 },
 {   6,6604 }, {   7,6604 }, {   8,6604 }, {   9,6604 }, {  10,6604 },
 {  11,6604 }, {  12,6604 }, {  13,6604 }, {  14,6604 }, {  15,6604 },
 {  16,6604 }, {  17,6604 }, {  18,6604 }, {  19,6604 }, {  20,6604 },
 {  21,6604 }, {  22,6604 }, {  23,6604 }, {  24,6604 }, {  25,6604 },
 {  26,6604 }, {  27,6604 }, {  28,6604 }, {  29,6604 }, {  30,6604 },
 {  31,6604 }, {  32,6604 }, {  33,6604 }, {  34,6604 }, {  35,6604 },

 {   0,   0 }, {  37,6604 }, {  38,6604 }, {  39,6604 }, {  40,6604 },
 {  41,6604 }, {  42,6604 }, {  43,6604 }, {  44,6604 }, {  45,6604 },
 {  46,6604 }, {  47,6604 }, {  48,6604 }, {  49,6604 }, {  50,6604 },
 {  51,6604 }, {  52,6604 }, {  53,6604 }, {  54,6604 }, {  55,6604 },
 {  56,6604 }, {  57,6604 }, {  58,6604 }, {  59,6604 }, {  60,6604 },
 {  61,6604 }, {  62,6604 }, {  63,6604 }, {  64,6604 }, {  65,6604 },
 {  66,6604 }, {  67,6604 }, {  68,6604 }, {  69,6604 }, {  70,6604 },
 {  71,6604 }, {  72,6604 }, {  73,6604 }, {  74,6604 }, {  75,6604 },
 {  76,6604 }, {  77,6604 }, {  78,6604 }, {  79,6604 }, {  80,6604 },
 {  81,6604 }, {  82,6604 }, {  83,6604 }, {  84,6604 }, {  85,6604 },

 {  86,6604 }, {  87,6604 }, {  88,6604 }, {  89,6604 }, {  90,6604 },
 {  91,6604 }, {  92,6604 }, {  93,6604 }, {  94,6604 }, {  95,6604 },
 {  96,6604 }, {  97,6604 }, {  98,6604 }, {  99,6604 }, { 100,6604 },
 { 101,6604 }, { 102,6604 }, { 103,6604 }, { 104,6604 }, { 105,6604 },
 { 106,6604 }, { 107,6604 }, { 108,6604 }, { 109,6604 }, { 110,6604 },
 { 111,6604 }, { 112,6604 }, { 113,6604 }, { 114,6604 }, { 115,6604 },
 { 116,6604 }, { 117,6604 }, { 118,6604 }, { 119,6604 }, { 120,6604 },
 { 121,6604 }, { 122,6604 }, { 123,6604 }, { 124,6604 }, { 125,6604 },
 { 126,6604 }, { 127,6604 }, { 128,6604 }, { 129,6604 }, { 130,6604 },
 { 131,6604 }, { 132,6604 }, { 133,6604 }, { 134,6604 }, { 135,6604 },

 { 136,6604 }, { 137,6604 }, { 138,6604 }, { 139,6604 }, { 140,6604 },
 { 141,6604 }, { 142,6604 }, { 143,6604 }, { 144,6604 }, { 145,6604 },
 { 146,6604 }, { 147,6604 }, { 148,6604 }, { 149,6604 }, { 150,6604 },
 { 151,6604 }, { 152,6604 }, { 153,6604 }, { 154,6604 }, { 155,6604 },
 { 156,6604 }, { 157,6604 }, { 158,6604 }, { 159,6604 }, { 160,6604 },
 { 161,6604 }, { 162,6604 }, { 163,6604 }, { 164,6604 }, { 165,6604 },
 { 166,6604 }, { 167,6604 }, { 168,6604 }, { 169,6604 }, { 170,6604 },
 { 171,6604 }, { 172,6604 }, { 173,6604 }, { 174,6604 }, { 175,6604 },
 { 176,6604 }, { 177,6604 }, { 178,6604 }, { 179,6604 }, { 180,6604 },
 { 181,6604 }, { 182,6604 }, { 183,6604 }, { 184,6604 }, { 185,6604 },

 { 186,6604 }, { 187,6604 }, { 188,6604 }, { 189,6604 }, { 190,6604 },
 { 191,6604 }, { 192,6604 }, { 193,6604 }, { 194,6604 }, { 195,6604 },
 { 196,6604 }, { 197,6604 }, { 198,6604 }, { 199,6604 }, { 200,6604 },
 { 201,6604 }, { 202,6604 }, { 203,6604 }, { 204,6604 }, { 205,6604 },
 { 206,6604 }, { 207,6604 }, { 208,6604 }, { 209,6604 }, { 210,6604 },
 { 211,6604 }, { 212,6604 }, { 213,6604 }, { 214,6604 }, { 215,6604 },
 { 216,6604 }, { 217,6604 }, { 218,6604 }, { 219,6604 }, { 220,6604 },
 { 221,6604 }, { 222,6604 }, { 223,6604 }, { 224,6604 }, { 225,6604 },
 { 226,6604 }, { 227,6604 }, { 228,6604 }, { 229,6604 }, { 230,6604 },
 { 231,6604 }, { 232,6604 }, { 233,6604 }, { 234,6604 }, { 235,6604 },

 { 236,6604 }, { 237,6604 }, { 238,6604 }, { 239,6604 }, { 240,6604 },
 { 241,6604 }, { 242,6604 }, { 243,6604 }, { 244,6604 }, { 245,6604 },
 { 246,6604 }, { 247,6604 }, { 248,6604 }, { 249,6604 }, { 250,6604 },
 { 251,6604 }, { 252,6604 }, { 253,6604 }, { 254,6604 }, { 255,6604 },
 { 256,6604 }, {   0,  35 }, {   0,25405 }, {   1,6346 }, {   2,6346 },
 {   3,6346 }, {   4,6346 }, {   5,6346 }, {   6,6346 }, {   7,6346 },
 {   8,6346 }, {   9,6346 }, {  10,6346 }, {  11,6346 }, {  12,6346 },
 {  13,6346 }, {  14,6346 }, {  15,6346 }, {  16,6346 }, {  17,6346 },
 {  18,6346 }, {  19,6346 }, {  20,6346 }, {  21,6346 }, {  22,6346 },
 {  23,6346 }, {  24,6346 }, {  25,6346 }, {  26,6346 }, {  27,6346 },

 {  28,6346 }, {  29,6346 }, {  30,6346 }, {  31,6346 }, {  32,6346 },
 {  33,6346 }, {  34,6346 }, {  35,6346 }, {   0,   0 }, {  37,6346 },
 {  38,6346 }, {  39,6346 }, {  40,6346 }, {  41,6346 }, {  42,6346 },
 {  43,6346 }, {  44,6346 }, {  45,6346 }, {  46,6346 }, {  47,6346 },
 {  48,6346 }, {  49,6346 }, {  50,6346 }, {  51,6346 }, {  52,6346 },
 {  53,6346 }, {  54,6346 }, {  55,6346 }, {  56,6346 }, {  57,6346 },
 {  58,6346 }, {  59,6346 }, {  60,6346 }, {  61,6346 }, {  62,6346 },
 {  63,6346 }, {  64,6346 }, {  65,6346 }, {  66,6346 }, {  67,6346 },
 {  68,6346 }, {  69,6346 }, {  70,6346 }, {  71,6346 }, {  72,6346 },
 {  73,6346 }, {  74,6346 }, {  75,6346 }, {  76,6346 }, {  77,6346 },

 {  78,6346 }, {  79,6346 }, {  80,6346 }, {  81,6346 }, {  82,6346 },
 {  83,6346 }, {  84,6346 }, {  85,6346 }, {  86,6346 }, {  87,6346 },
 {  88,6346 }, {  89,6346 }, {  90,6346 }, {  91,6346 }, {  92,6346 },
 {  93,6346 }, {  94,6346 }, {  95,6346 }, {  96,6346 }, {  97,6346 },
 {  98,6346 }, {  99,6346 }, { 100,6346 }, { 101,6346 }, { 102,6346 },
 { 103,6346 }, { 104,6346 }, { 105,6346 }, { 106,6346 }, { 107,6346 },
 { 108,6346 }, { 109,6346 }, { 110,6346 }, { 111,6346 }, { 112,6346 },
 { 113,6346 }, { 114,6346 }, { 115,6346 }, { 116,6346 }, { 117,6346 },
 { 118,6346 }, { 119,6346 }, { 120,6346 }, { 121,6346 }, { 122,6346 },
 { 123,6346 }, { 124,6346 }, { 125,6346 }, { 126,6346 }, { 127,6346 },

 { 128,6346 }, { 129,6346 }, { 130,6346 }, { 131,6346 }, { 132,6346 },
 { 133,6346 }, { 134,6346 }, { 135,6346 }, { 136,6346 }, { 137,6346 },
 { 138,6346 }, { 139,6346 }, { 140,6346 }, { 141,6346 }, { 142,6346 },
 { 143,6346 }, { 144,6346 }, { 145,6346 }, { 146,6346 }, { 147,6346 },
 { 148,6346 }, { 149,6346 }, { 150,6346 }, { 151,6346 }, { 152,6346 },
 { 153,6346 }, { 154,6346 }, { 155,6346 }, { 156,6346 }, { 157,6346 },
 { 158,6346 }, { 159,6346 }, { 160,6346 }, { 161,6346 }, { 162,6346 },
 { 163,6346 }, { 164,6346 }, { 165,6346 }, { 166,6346 }, { 167,6346 },
 { 168,6346 }, { 169,6346 }, { 170,6346 }, { 171,6346 }, { 172,6346 },
 { 173,6346 }, { 174,6346 }, { 175,6346 }, { 176,6346 }, { 177,6346 },

 { 178,6346 }, { 179,6346 }, { 180,6346 }, { 181,6346 }, { 182,6346 },
 { 183,6346 }, { 184,6346 }, { 185,6346 }, { 186,6346 }, { 187,6346 },
 { 188,6346 }, { 189,6346 }, { 190,6346 }, { 191,6346 }, { 192,6346 },
 { 193,6346 }, { 194,6346 }, { 195,6346 }, { 196,6346 }, { 197,6346 },
 { 198,6346 }, { 199,6346 }, { 200,6346 }, { 201,6346 }, { 202,6346 },
 { 203,6346 }, { 204,6346 }, { 205,6346 }, { 206,6346 }, { 207,6346 },
 { 208,6346 }, { 209,6346 }, { 210,6346 }, { 211,6346 }, { 212,6346 },
 { 213,6346 }, { 214,6346 }, { 215,6346 }, { 216,6346 }, { 217,6346 },
 { 218,6346 }, { 219,6346 }, { 220,6346 }, { 221,6346 }, { 222,6346 },
 { 223,6346 }, { 224,6346 }, { 225,6346 }, { 226,6346 }, { 227,6346 },

 { 228,6346 }, { 229,6346 }, { 230,6346 }, { 231,6346 }, { 232,6346 },
 { 233,6346 }, { 234,6346 }, { 235,6346 }, { 236,6346 }, { 237,6346 },
 { 238,6346 }, { 239,6346 }, { 240,6346 }, { 241,6346 }, { 242,6346 },
 { 243,6346 }, { 244,6346 }, { 245,6346 }, { 246,6346 }, { 247,6346 },
 { 248,6346 }, { 249,6346 }, { 250,6346 }, { 251,6346 }, { 252,6346 },
 { 253,6346 }, { 254,6346 }, { 255,6346 }, { 256,6346 }, {   0,  37 },
 {   0,25147 }, {   0,   1 }, {   0,25145 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   9,   0 }, {  10,   0 }, {  11,   0 }, {  12,   0 },
 {  13,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  32,   0 },
 {   0,   0 }, {  36,-5185 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,6346 }, {  66,6346 }, {  67,6346 }, {  68,6346 }, {  69,6346 },

 {  70,6346 }, {  71,6346 }, {  72,6346 }, {  73,6346 }, {  74,6346 },
 {  75,6346 }, {  76,6346 }, {  77,6346 }, {  78,6346 }, {  79,6346 },
 {  80,6346 }, {  81,6346 }, {  82,6346 }, {  83,6346 }, {  84,6346 },
 {  85,6346 }, {  86,6346 }, {  87,6346 }, {  88,6346 }, {  89,6346 },
 {  90,6346 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,6346 }, {   0,   0 }, {  97,6346 }, {  98,6346 }, {  99,6346 },
 { 100,6346 }, { 101,6346 }, { 102,6346 }, { 103,6346 }, { 104,6346 },
 { 105,6346 }, { 106,6346 }, { 107,6346 }, { 108,6346 }, { 109,6346 },
 { 110,6346 }, { 111,6346 }, { 112,6346 }, { 113,6346 }, { 114,6346 },
 { 115,6346 }, { 116,6346 }, { 117,6346 }, { 118,6346 }, { 119,6346 },

 { 120,6346 }, { 121,6346 }, { 122,6346 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,6346 }, { 129,6346 },
 { 130,6346 }, { 131,6346 }, { 132,6346 }, { 133,6346 }, { 134,6346 },
 { 135,6346 }, { 136,6346 }, { 137,6346 }, { 138,6346 }, { 139,6346 },
 { 140,6346 }, { 141,6346 }, { 142,6346 }, { 143,6346 }, { 144,6346 },
 { 145,6346 }, { 146,6346 }, { 147,6346 }, { 148,6346 }, { 149,6346 },
 { 150,6346 }, { 151,6346 }, { 152,6346 }, { 153,6346 }, { 154,6346 },
 { 155,6346 }, { 156,6346 }, { 157,6346 }, { 158,6346 }, { 159,6346 },
 { 160,6346 }, { 161,6346 }, { 162,6346 }, { 163,6346 }, { 164,6346 },
 { 165,6346 }, { 166,6346 }, { 167,6346 }, { 168,6346 }, { 169,6346 },

 { 170,6346 }, { 171,6346 }, { 172,6346 }, { 173,6346 }, { 174,6346 },
 { 175,6346 }, { 176,6346 }, { 177,6346 }, { 178,6346 }, { 179,6346 },
 { 180,6346 }, { 181,6346 }, { 182,6346 }, { 183,6346 }, { 184,6346 },
 { 185,6346 }, { 186,6346 }, { 187,6346 }, { 188,6346 }, { 189,6346 },
 { 190,6346 }, { 191,6346 }, { 192,6346 }, { 193,6346 }, { 194,6346 },
 { 195,6346 }, { 196,6346 }, { 197,6346 }, { 198,6346 }, { 199,6346 },
 { 200,6346 }, { 201,6346 }, { 202,6346 }, { 203,6346 }, { 204,6346 },
 { 205,6346 }, { 206,6346 }, { 207,6346 }, { 208,6346 }, { 209,6346 },
 { 210,6346 }, { 211,6346 }, { 212,6346 }, { 213,6346 }, { 214,6346 },
 { 215,6346 }, { 216,6346 }, { 217,6346 }, { 218,6346 }, { 219,6346 },

 { 220,6346 }, { 221,6346 }, { 222,6346 }, { 223,6346 }, { 224,6346 },
 { 225,6346 }, { 226,6346 }, { 227,6346 }, { 228,6346 }, { 229,6346 },
 { 230,6346 }, { 231,6346 }, { 232,6346 }, { 233,6346 }, { 234,6346 },
 { 235,6346 }, { 236,6346 }, { 237,6346 }, { 238,6346 }, { 239,6346 },
 { 240,6346 }, { 241,6346 }, { 242,6346 }, { 243,6346 }, { 244,6346 },
 { 245,6346 }, { 246,6346 }, { 247,6346 }, { 248,6346 }, { 249,6346 },
 { 250,6346 }, { 251,6346 }, { 252,6346 }, { 253,6346 }, { 254,6346 },
 { 255,6346 }, {   0,  54 }, {   0,24890 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,  52 }, {   0,24879 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  33,   0 }, {   0,   0 }, {  35,   0 }, {   0,   0 }, {  37,   0 },
 {  38,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  42,   0 },
 {  43,   0 }, {  33, -11 }, {  45,   0 }, {  35, -11 }, {  47,   0 },
 {  37, -11 }, {  38, -11 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  42, -11 }, {  43, -11 }, {   0,   0 }, {  45, -11 }, {   0,   0 },
 {  47, -11 }, {   0,   0 }, {  60,   0 }, {  61,   0 }, {  62,   0 },

 {  63,   0 }, {  64,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  60, -11 }, {  61, -11 },
 {  62, -11 }, {  63, -11 }, {  64, -11 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,  55 }, {   0,24800 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  94,   0 }, {   0,   0 }, {  96,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  94, -11 }, {   0,   0 }, {  96, -11 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 124,   0 }, {   0,   0 }, { 126,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 124, -11 }, {   0,   0 }, { 126, -11 },
 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },
 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,6338 }, {  66,6338 }, {  67,6338 },
 {  68,6338 }, {  69,6338 }, {  70,6338 }, {  71,6338 }, {  72,6338 },

 {  73,6338 }, {  74,6338 }, {  75,6338 }, {  76,6338 }, {  77,6338 },
 {  78,6338 }, {  79,6338 }, {  80,6338 }, {  81,6338 }, {  82,6338 },
 {  83,6338 }, {  84,6338 }, {  85,6338 }, {  86,6338 }, {  87,6338 },
 {  88,6338 }, {  89,6338 }, {  90,6338 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,6338 }, {   0,   0 }, {  97,6338 },
 {  98,6338 }, {  99,6338 }, { 100,6338 }, { 101,6338 }, { 102,6338 },
 { 103,6338 }, { 104,6338 }, { 105,6338 }, { 106,6338 }, { 107,6338 },
 { 108,6338 }, { 109,6338 }, { 110,6338 }, { 111,6338 }, { 112,6338 },
 { 113,6338 }, { 114,6338 }, { 115,6338 }, { 116,6338 }, { 117,6338 },
 { 118,6338 }, { 119,6338 }, { 120,6338 }, { 121,6338 }, { 122,6338 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,6338 }, { 129,6338 }, { 130,6338 }, { 131,6338 }, { 132,6338 },
 { 133,6338 }, { 134,6338 }, { 135,6338 }, { 136,6338 }, { 137,6338 },
 { 138,6338 }, { 139,6338 }, { 140,6338 }, { 141,6338 }, { 142,6338 },
 { 143,6338 }, { 144,6338 }, { 145,6338 }, { 146,6338 }, { 147,6338 },
 { 148,6338 }, { 149,6338 }, { 150,6338 }, { 151,6338 }, { 152,6338 },
 { 153,6338 }, { 154,6338 }, { 155,6338 }, { 156,6338 }, { 157,6338 },
 { 158,6338 }, { 159,6338 }, { 160,6338 }, { 161,6338 }, { 162,6338 },
 { 163,6338 }, { 164,6338 }, { 165,6338 }, { 166,6338 }, { 167,6338 },
 { 168,6338 }, { 169,6338 }, { 170,6338 }, { 171,6338 }, { 172,6338 },

 { 173,6338 }, { 174,6338 }, { 175,6338 }, { 176,6338 }, { 177,6338 },
 { 178,6338 }, { 179,6338 }, { 180,6338 }, { 181,6338 }, { 182,6338 },
 { 183,6338 }, { 184,6338 }, { 185,6338 }, { 186,6338 }, { 187,6338 },
 { 188,6338 }, { 189,6338 }, { 190,6338 }, { 191,6338 }, { 192,6338 },
 { 193,6338 }, { 194,6338 }, { 195,6338 }, { 196,6338 }, { 197,6338 },
 { 198,6338 }, { 199,6338 }, { 200,6338 }, { 201,6338 }, { 202,6338 },
 { 203,6338 }, { 204,6338 }, { 205,6338 }, { 206,6338 }, { 207,6338 },
 { 208,6338 }, { 209,6338 }, { 210,6338 }, { 211,6338 }, { 212,6338 },
 { 213,6338 }, { 214,6338 }, { 215,6338 }, { 216,6338 }, { 217,6338 },
 { 218,6338 }, { 219,6338 }, { 220,6338 }, { 221,6338 }, { 222,6338 },

 { 223,6338 }, { 224,6338 }, { 225,6338 }, { 226,6338 }, { 227,6338 },
 { 228,6338 }, { 229,6338 }, { 230,6338 }, { 231,6338 }, { 232,6338 },
 { 233,6338 }, { 234,6338 }, { 235,6338 }, { 236,6338 }, { 237,6338 },
 { 238,6338 }, { 239,6338 }, { 240,6338 }, { 241,6338 }, { 242,6338 },
 { 243,6338 }, { 244,6338 }, { 245,6338 }, { 246,6338 }, { 247,6338 },
 { 248,6338 }, { 249,6338 }, { 250,6338 }, { 251,6338 }, { 252,6338 },
 { 253,6338 }, { 254,6338 }, { 255,6338 }, {   0,  33 }, {   0,24543 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  36,-6066 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,6338 }, {  49,6338 }, {  50,6338 },
 {  51,6338 }, {  52,6338 }, {  53,6338 }, {  54,6338 }, {  55,6338 },
 {  56,6338 }, {  57,6338 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,6338 },

 {  66,6338 }, {  67,6338 }, {  68,6338 }, {  69,6338 }, {  70,6338 },
 {  71,6338 }, {  72,6338 }, {  73,6338 }, {  74,6338 }, {  75,6338 },
 {  76,6338 }, {  77,6338 }, {  78,6338 }, {  79,6338 }, {  80,6338 },
 {  81,6338 }, {  82,6338 }, {  83,6338 }, {  84,6338 }, {  85,6338 },
 {  86,6338 }, {  87,6338 }, {  88,6338 }, {  89,6338 }, {  90,6338 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,6338 },
 {   0,   0 }, {  97,6338 }, {  98,6338 }, {  99,6338 }, { 100,6338 },
 { 101,6338 }, { 102,6338 }, { 103,6338 }, { 104,6338 }, { 105,6338 },
 { 106,6338 }, { 107,6338 }, { 108,6338 }, { 109,6338 }, { 110,6338 },
 { 111,6338 }, { 112,6338 }, { 113,6338 }, { 114,6338 }, { 115,6338 },

 { 116,6338 }, { 117,6338 }, { 118,6338 }, { 119,6338 }, { 120,6338 },
 { 121,6338 }, { 122,6338 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 128,6338 }, { 129,6338 }, { 130,6338 },
 { 131,6338 }, { 132,6338 }, { 133,6338 }, { 134,6338 }, { 135,6338 },
 { 136,6338 }, { 137,6338 }, { 138,6338 }, { 139,6338 }, { 140,6338 },
 { 141,6338 }, { 142,6338 }, { 143,6338 }, { 144,6338 }, { 145,6338 },
 { 146,6338 }, { 147,6338 }, { 148,6338 }, { 149,6338 }, { 150,6338 },
 { 151,6338 }, { 152,6338 }, { 153,6338 }, { 154,6338 }, { 155,6338 },
 { 156,6338 }, { 157,6338 }, { 158,6338 }, { 159,6338 }, { 160,6338 },
 { 161,6338 }, { 162,6338 }, { 163,6338 }, { 164,6338 }, { 165,6338 },

 { 166,6338 }, { 167,6338 }, { 168,6338 }, { 169,6338 }, { 170,6338 },
 { 171,6338 }, { 172,6338 }, { 173,6338 }, { 174,6338 }, { 175,6338 },
 { 176,6338 }, { 177,6338 }, { 178,6338 }, { 179,6338 }, { 180,6338 },
 { 181,6338 }, { 182,6338 }, { 183,6338 }, { 184,6338 }, { 185,6338 },
 { 186,6338 }, { 187,6338 }, { 188,6338 }, { 189,6338 }, { 190,6338 },
 { 191,6338 }, { 192,6338 }, { 193,6338 }, { 194,6338 }, { 195,6338 },
 { 196,6338 }, { 197,6338 }, { 198,6338 }, { 199,6338 }, { 200,6338 },
 { 201,6338 }, { 202,6338 }, { 203,6338 }, { 204,6338 }, { 205,6338 },
 { 206,6338 }, { 207,6338 }, { 208,6338 }, { 209,6338 }, { 210,6338 },
 { 211,6338 }, { 212,6338 }, { 213,6338 }, { 214,6338 }, { 215,6338 },

 { 216,6338 }, { 217,6338 }, { 218,6338 }, { 219,6338 }, { 220,6338 },
 { 221,6338 }, { 222,6338 }, { 223,6338 }, { 224,6338 }, { 225,6338 },
 { 226,6338 }, { 227,6338 }, { 228,6338 }, { 229,6338 }, { 230,6338 },
 { 231,6338 }, { 232,6338 }, { 233,6338 }, { 234,6338 }, { 235,6338 },
 { 236,6338 }, { 237,6338 }, { 238,6338 }, { 239,6338 }, { 240,6338 },
 { 241,6338 }, { 242,6338 }, { 243,6338 }, { 244,6338 }, { 245,6338 },
 { 246,6338 }, { 247,6338 }, { 248,6338 }, { 249,6338 }, { 250,6338 },
 { 251,6338 }, { 252,6338 }, { 253,6338 }, { 254,6338 }, { 255,6338 },
 {   0,   1 }, {   0,24286 }, {   1,6338 }, {   2,6338 }, {   3,6338 },
 {   4,6338 }, {   5,6338 }, {   6,6338 }, {   7,6338 }, {   8,6338 },

 {   9,6338 }, {   0,   0 }, {  11,6338 }, {  12,6338 }, {   0,   0 },
 {  14,6338 }, {  15,6338 }, {  16,6338 }, {  17,6338 }, {  18,6338 },
 {  19,6338 }, {  20,6338 }, {  21,6338 }, {  22,6338 }, {  23,6338 },
 {  24,6338 }, {  25,6338 }, {  26,6338 }, {  27,6338 }, {  28,6338 },
 {  29,6338 }, {  30,6338 }, {  31,6338 }, {  32,6338 }, {  33,6596 },
 {  34,6338 }, {  35,6596 }, {  36,6338 }, {  37,6596 }, {  38,6596 },
 {  39,6338 }, {  40,6338 }, {  41,6338 }, {  42,6596 }, {  43,6596 },
 {  44,6338 }, {  45,6596 }, {  46,6338 }, {  47,6596 }, {  48,6338 },
 {  49,6338 }, {  50,6338 }, {  51,6338 }, {  52,6338 }, {  53,6338 },
 {  54,6338 }, {  55,6338 }, {  56,6338 }, {  57,6338 }, {  58,6338 },

 {  59,6338 }, {  60,6596 }, {  61,6596 }, {  62,6596 }, {  63,6596 },
 {  64,6596 }, {  65,6338 }, {  66,6338 }, {  67,6338 }, {  68,6338 },
 {  69,6338 }, {  70,6338 }, {  71,6338 }, {  72,6338 }, {  73,6338 },
 {  74,6338 }, {  75,6338 }, {  76,6338 }, {  77,6338 }, {  78,6338 },
 {  79,6338 }, {  80,6338 }, {  81,6338 }, {  82,6338 }, {  83,6338 },
 {  84,6338 }, {  85,6338 }, {  86,6338 }, {  87,6338 }, {  88,6338 },
 {  89,6338 }, {  90,6338 }, {  91,6338 }, {  92,6338 }, {  93,6338 },
 {  94,6596 }, {  95,6338 }, {  96,6596 }, {  97,6338 }, {  98,6338 },
 {  99,6338 }, { 100,6338 }, { 101,6338 }, { 102,6338 }, { 103,6338 },
 { 104,6338 }, { 105,6338 }, { 106,6338 }, { 107,6338 }, { 108,6338 },

 { 109,6338 }, { 110,6338 }, { 111,6338 }, { 112,6338 }, { 113,6338 },
 { 114,6338 }, { 115,6338 }, { 116,6338 }, { 117,6338 }, { 118,6338 },
 { 119,6338 }, { 120,6338 }, { 121,6338 }, { 122,6338 }, { 123,6338 },
 { 124,6596 }, { 125,6338 }, { 126,6596 }, { 127,6338 }, { 128,6338 },
 { 129,6338 }, { 130,6338 }, { 131,6338 }, { 132,6338 }, { 133,6338 },
 { 134,6338 }, { 135,6338 }, { 136,6338 }, { 137,6338 }, { 138,6338 },
 { 139,6338 }, { 140,6338 }, { 141,6338 }, { 142,6338 }, { 143,6338 },
 { 144,6338 }, { 145,6338 }, { 146,6338 }, { 147,6338 }, { 148,6338 },
 { 149,6338 }, { 150,6338 }, { 151,6338 }, { 152,6338 }, { 153,6338 },
 { 154,6338 }, { 155,6338 }, { 156,6338 }, { 157,6338 }, { 158,6338 },

 { 159,6338 }, { 160,6338 }, { 161,6338 }, { 162,6338 }, { 163,6338 },
 { 164,6338 }, { 165,6338 }, { 166,6338 }, { 167,6338 }, { 168,6338 },
 { 169,6338 }, { 170,6338 }, { 171,6338 }, { 172,6338 }, { 173,6338 },
 { 174,6338 }, { 175,6338 }, { 176,6338 }, { 177,6338 }, { 178,6338 },
 { 179,6338 }, { 180,6338 }, { 181,6338 }, { 182,6338 }, { 183,6338 },
 { 184,6338 }, { 185,6338 }, { 186,6338 }, { 187,6338 }, { 188,6338 },
 { 189,6338 }, { 190,6338 }, { 191,6338 }, { 192,6338 }, { 193,6338 },
 { 194,6338 }, { 195,6338 }, { 196,6338 }, { 197,6338 }, { 198,6338 },
 { 199,6338 }, { 200,6338 }, { 201,6338 }, { 202,6338 }, { 203,6338 },
 { 204,6338 }, { 205,6338 }, { 206,6338 }, { 207,6338 }, { 208,6338 },

 { 209,6338 }, { 210,6338 }, { 211,6338 }, { 212,6338 }, { 213,6338 },
 { 214,6338 }, { 215,6338 }, { 216,6338 }, { 217,6338 }, { 218,6338 },
 { 219,6338 }, { 220,6338 }, { 221,6338 }, { 222,6338 }, { 223,6338 },
 { 224,6338 }, { 225,6338 }, { 226,6338 }, { 227,6338 }, { 228,6338 },
 { 229,6338 }, { 230,6338 }, { 231,6338 }, { 232,6338 }, { 233,6338 },
 { 234,6338 }, { 235,6338 }, { 236,6338 }, { 237,6338 }, { 238,6338 },
 { 239,6338 }, { 240,6338 }, { 241,6338 }, { 242,6338 }, { 243,6338 },
 { 244,6338 }, { 245,6338 }, { 246,6338 }, { 247,6338 }, { 248,6338 },
 { 249,6338 }, { 250,6338 }, { 251,6338 }, { 252,6338 }, { 253,6338 },
 { 254,6338 }, { 255,6338 }, { 256,6338 }, {   0,  64 }, {   0,24028 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,6596 }, {  49,6596 }, {  50,6596 },

 {  51,6596 }, {  52,6596 }, {  53,6596 }, {  54,6596 }, {  55,6596 },
 {  56,6596 }, {  57,6596 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,6853 },
 {  66,6853 }, {  67,6853 }, {  68,6853 }, {  69,7110 }, {  70,6853 },
 {  71,6853 }, {  72,6853 }, {  73,6853 }, {  74,6853 }, {  75,6853 },
 {  76,6853 }, {  77,6853 }, {  78,6853 }, {  79,6853 }, {  80,6853 },
 {  81,6853 }, {  82,6853 }, {  83,6853 }, {  84,6853 }, {  85,6853 },
 {  86,6853 }, {  87,6853 }, {  88,6853 }, {  89,6853 }, {  90,6853 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,7367 },
 {   0,   0 }, {  97,6853 }, {  98,6853 }, {  99,6853 }, { 100,6853 },

 { 101,7110 }, { 102,6853 }, { 103,6853 }, { 104,6853 }, { 105,6853 },
 { 106,6853 }, { 107,6853 }, { 108,6853 }, { 109,6853 }, { 110,6853 },
 { 111,6853 }, { 112,6853 }, { 113,6853 }, { 114,6853 }, { 115,6853 },
 { 116,6853 }, { 117,6853 }, { 118,6853 }, { 119,6853 }, { 120,6853 },
 { 121,6853 }, { 122,6853 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 128,6853 }, { 129,6853 }, { 130,6853 },
 { 131,6853 }, { 132,6853 }, { 133,6853 }, { 134,6853 }, { 135,6853 },
 { 136,6853 }, { 137,6853 }, { 138,6853 }, { 139,6853 }, { 140,6853 },
 { 141,6853 }, { 142,6853 }, { 143,6853 }, { 144,6853 }, { 145,6853 },
 { 146,6853 }, { 147,6853 }, { 148,6853 }, { 149,6853 }, { 150,6853 },

 { 151,6853 }, { 152,6853 }, { 153,6853 }, { 154,6853 }, { 155,6853 },
 { 156,6853 }, { 157,6853 }, { 158,6853 }, { 159,6853 }, { 160,6853 },
 { 161,6853 }, { 162,6853 }, { 163,6853 }, { 164,6853 }, { 165,6853 },
 { 166,6853 }, { 167,6853 }, { 168,6853 }, { 169,6853 }, { 170,6853 },
 { 171,6853 }, { 172,6853 }, { 173,6853 }, { 174,6853 }, { 175,6853 },
 { 176,6853 }, { 177,6853 }, { 178,6853 }, { 179,6853 }, { 180,6853 },
 { 181,6853 }, { 182,6853 }, { 183,6853 }, { 184,6853 }, { 185,6853 },
 { 186,6853 }, { 187,6853 }, { 188,6853 }, { 189,6853 }, { 190,6853 },
 { 191,6853 }, { 192,6853 }, { 193,6853 }, { 194,6853 }, { 195,6853 },
 { 196,6853 }, { 197,6853 }, { 198,6853 }, { 199,6853 }, { 200,6853 },

 { 201,6853 }, { 202,6853 }, { 203,6853 }, { 204,6853 }, { 205,6853 },
 { 206,6853 }, { 207,6853 }, { 208,6853 }, { 209,6853 }, { 210,6853 },
 { 211,6853 }, { 212,6853 }, { 213,6853 }, { 214,6853 }, { 215,6853 },
 { 216,6853 }, { 217,6853 }, { 218,6853 }, { 219,6853 }, { 220,6853 },
 { 221,6853 }, { 222,6853 }, { 223,6853 }, { 224,6853 }, { 225,6853 },
 { 226,6853 }, { 227,6853 }, { 228,6853 }, { 229,6853 }, { 230,6853 },
 { 231,6853 }, { 232,6853 }, { 233,6853 }, { 234,6853 }, { 235,6853 },
 { 236,6853 }, { 237,6853 }, { 238,6853 }, { 239,6853 }, { 240,6853 },
 { 241,6853 }, { 242,6853 }, { 243,6853 }, { 244,6853 }, { 245,6853 },
 { 246,6853 }, { 247,6853 }, { 248,6853 }, { 249,6853 }, { 250,6853 },

 { 251,6853 }, { 252,6853 }, { 253,6853 }, { 254,6853 }, { 255,6853 },
 {   0,   2 }, {   0,23771 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,  64 }, {   0,23739 }, {  33,7367 },
 {   0,   0 }, {  35,7367 }, {   0,   0 }, {  37,7367 }, {  38,7367 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  42,7367 }, {  43,7367 },

 {   0,   0 }, {  45,7367 }, {   0,   0 }, {  47,7367 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  60,7367 }, {  61,7367 }, {  62,7367 }, {  63,7367 },
 {  64,7367 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  46,-6589 },
 {   0,   0 }, {  48,7367 }, {  49,7367 }, {  50,7367 }, {  51,7367 },
 {  52,7367 }, {  53,7367 }, {  54,7367 }, {  55,7367 }, {  56,7367 },
 {  57,7367 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {  94,7367 }, {   0,   0 }, {  96,7367 }, {  65,6564 }, {  66,6564 },
 {  67,6564 }, {  68,6564 }, {  69,6821 }, {  70,6564 }, {  71,6564 },
 {  72,6564 }, {  73,6564 }, {  74,6564 }, {  75,6564 }, {  76,6564 },
 {  77,6564 }, {  78,6564 }, {  79,6564 }, {  80,6564 }, {  81,6564 },
 {  82,6564 }, {  83,6564 }, {  84,6564 }, {  85,6564 }, {  86,6564 },
 {  87,6564 }, {  88,6564 }, {  89,6564 }, {  90,6564 }, {   0,   0 },
 { 124,7367 }, {   0,   0 }, { 126,7367 }, {  95,6564 }, {   0,   0 },
 {  97,6564 }, {  98,6564 }, {  99,6564 }, { 100,6564 }, { 101,6821 },
 { 102,6564 }, { 103,6564 }, { 104,6564 }, { 105,6564 }, { 106,6564 },
 { 107,6564 }, { 108,6564 }, { 109,6564 }, { 110,6564 }, { 111,6564 },

 { 112,6564 }, { 113,6564 }, { 114,6564 }, { 115,6564 }, { 116,6564 },
 { 117,6564 }, { 118,6564 }, { 119,6564 }, { 120,6564 }, { 121,6564 },
 { 122,6564 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 128,6564 }, { 129,6564 }, { 130,6564 }, { 131,6564 },
 { 132,6564 }, { 133,6564 }, { 134,6564 }, { 135,6564 }, { 136,6564 },
 { 137,6564 }, { 138,6564 }, { 139,6564 }, { 140,6564 }, { 141,6564 },
 { 142,6564 }, { 143,6564 }, { 144,6564 }, { 145,6564 }, { 146,6564 },
 { 147,6564 }, { 148,6564 }, { 149,6564 }, { 150,6564 }, { 151,6564 },
 { 152,6564 }, { 153,6564 }, { 154,6564 }, { 155,6564 }, { 156,6564 },
 { 157,6564 }, { 158,6564 }, { 159,6564 }, { 160,6564 }, { 161,6564 },

 { 162,6564 }, { 163,6564 }, { 164,6564 }, { 165,6564 }, { 166,6564 },
 { 167,6564 }, { 168,6564 }, { 169,6564 }, { 170,6564 }, { 171,6564 },
 { 172,6564 }, { 173,6564 }, { 174,6564 }, { 175,6564 }, { 176,6564 },
 { 177,6564 }, { 178,6564 }, { 179,6564 }, { 180,6564 }, { 181,6564 },
 { 182,6564 }, { 183,6564 }, { 184,6564 }, { 185,6564 }, { 186,6564 },
 { 187,6564 }, { 188,6564 }, { 189,6564 }, { 190,6564 }, { 191,6564 },
 { 192,6564 }, { 193,6564 }, { 194,6564 }, { 195,6564 }, { 196,6564 },
 { 197,6564 }, { 198,6564 }, { 199,6564 }, { 200,6564 }, { 201,6564 },
 { 202,6564 }, { 203,6564 }, { 204,6564 }, { 205,6564 }, { 206,6564 },
 { 207,6564 }, { 208,6564 }, { 209,6564 }, { 210,6564 }, { 211,6564 },

 { 212,6564 }, { 213,6564 }, { 214,6564 }, { 215,6564 }, { 216,6564 },
 { 217,6564 }, { 218,6564 }, { 219,6564 }, { 220,6564 }, { 221,6564 },
 { 222,6564 }, { 223,6564 }, { 224,6564 }, { 225,6564 }, { 226,6564 },
 { 227,6564 }, { 228,6564 }, { 229,6564 }, { 230,6564 }, { 231,6564 },
 { 232,6564 }, { 233,6564 }, { 234,6564 }, { 235,6564 }, { 236,6564 },
 { 237,6564 }, { 238,6564 }, { 239,6564 }, { 240,6564 }, { 241,6564 },
 { 242,6564 }, { 243,6564 }, { 244,6564 }, { 245,6564 }, { 246,6564 },
 { 247,6564 }, { 248,6564 }, { 249,6564 }, { 250,6564 }, { 251,6564 },
 { 252,6564 }, { 253,6564 }, { 254,6564 }, { 255,6564 }, {   0,  57 },
 {   0,23482 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  46,-257 }, {   0,   0 }, {  48,   0 }, {  49,   0 },
 {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 },

 {  55,   0 }, {  56,   0 }, {  57,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65, 257 }, {  66, 257 }, {  67, 257 }, {  68, 257 }, {  69, 771 },
 {  70, 257 }, {  71, 257 }, {  72, 257 }, {  73, 257 }, {  74, 257 },
 {  75, 257 }, {  76, 257 }, {  77, 257 }, {  78, 257 }, {  79, 257 },
 {  80, 257 }, {  81, 257 }, {  82, 257 }, {  83, 257 }, {  84, 257 },
 {  85, 257 }, {  86, 257 }, {  87, 257 }, {  88, 257 }, {  89, 257 },
 {  90, 257 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,1542 }, {   0,   0 }, {  97, 257 }, {  98, 257 }, {  99, 257 },
 { 100, 257 }, { 101, 771 }, { 102, 257 }, { 103, 257 }, { 104, 257 },

 { 105, 257 }, { 106, 257 }, { 107, 257 }, { 108, 257 }, { 109, 257 },
 { 110, 257 }, { 111, 257 }, { 112, 257 }, { 113, 257 }, { 114, 257 },
 { 115, 257 }, { 116, 257 }, { 117, 257 }, { 118, 257 }, { 119, 257 },
 { 120, 257 }, { 121, 257 }, { 122, 257 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128, 257 }, { 129, 257 },
 { 130, 257 }, { 131, 257 }, { 132, 257 }, { 133, 257 }, { 134, 257 },
 { 135, 257 }, { 136, 257 }, { 137, 257 }, { 138, 257 }, { 139, 257 },
 { 140, 257 }, { 141, 257 }, { 142, 257 }, { 143, 257 }, { 144, 257 },
 { 145, 257 }, { 146, 257 }, { 147, 257 }, { 148, 257 }, { 149, 257 },
 { 150, 257 }, { 151, 257 }, { 152, 257 }, { 153, 257 }, { 154, 257 },

 { 155, 257 }, { 156, 257 }, { 157, 257 }, { 158, 257 }, { 159, 257 },
 { 160, 257 }, { 161, 257 }, { 162, 257 }, { 163, 257 }, { 164, 257 },
 { 165, 257 }, { 166, 257 }, { 167, 257 }, { 168, 257 }, { 169, 257 },
 { 170, 257 }, { 171, 257 }, { 172, 257 }, { 173, 257 }, { 174, 257 },
 { 175, 257 }, { 176, 257 }, { 177, 257 }, { 178, 257 }, { 179, 257 },
 { 180, 257 }, { 181, 257 }, { 182, 257 }, { 183, 257 }, { 184, 257 },
 { 185, 257 }, { 186, 257 }, { 187, 257 }, { 188, 257 }, { 189, 257 },
 { 190, 257 }, { 191, 257 }, { 192, 257 }, { 193, 257 }, { 194, 257 },
 { 195, 257 }, { 196, 257 }, { 197, 257 }, { 198, 257 }, { 199, 257 },
 { 200, 257 }, { 201, 257 }, { 202, 257 }, { 203, 257 }, { 204, 257 },

 { 205, 257 }, { 206, 257 }, { 207, 257 }, { 208, 257 }, { 209, 257 },
 { 210, 257 }, { 211, 257 }, { 212, 257 }, { 213, 257 }, { 214, 257 },
 { 215, 257 }, { 216, 257 }, { 217, 257 }, { 218, 257 }, { 219, 257 },
 { 220, 257 }, { 221, 257 }, { 222, 257 }, { 223, 257 }, { 224, 257 },
 { 225, 257 }, { 226, 257 }, { 227, 257 }, { 228, 257 }, { 229, 257 },
 { 230, 257 }, { 231, 257 }, { 232, 257 }, { 233, 257 }, { 234, 257 },
 { 235, 257 }, { 236, 257 }, { 237, 257 }, { 238, 257 }, { 239, 257 },
 { 240, 257 }, { 241, 257 }, { 242, 257 }, { 243, 257 }, { 244, 257 },
 { 245, 257 }, { 246, 257 }, { 247, 257 }, { 248, 257 }, { 249, 257 },
 { 250, 257 }, { 251, 257 }, { 252, 257 }, { 253, 257 }, { 254, 257 },

 { 255, 257 }, {   0,  68 }, {   0,23225 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,7110 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {  48,7110 }, {  49,7110 }, {  50,7110 }, {  51,7110 }, {  52,7110 },
 {  53,7110 }, {  54,7110 }, {  55,7110 }, {  56,7110 }, {  57,7110 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,7110 }, {  66,7110 }, {  67,7110 },
 {  68,7110 }, {  69,7110 }, {  70,7110 }, {  71,7110 }, {  72,7110 },
 {  73,7110 }, {  74,7110 }, {  75,7110 }, {  76,7110 }, {  77,7110 },
 {  78,7110 }, {  79,7110 }, {  80,7110 }, {  81,7110 }, {  82,7110 },
 {  83,7110 }, {  84,7110 }, {  85,7110 }, {  86,7110 }, {  87,7110 },
 {  88,7110 }, {  89,7110 }, {  90,7110 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,7110 }, {   0,   0 }, {  97,7110 },

 {  98,7110 }, {  99,7110 }, { 100,7110 }, { 101,7110 }, { 102,7110 },
 { 103,7110 }, { 104,7110 }, { 105,7110 }, { 106,7110 }, { 107,7110 },
 { 108,7110 }, { 109,7110 }, { 110,7110 }, { 111,7110 }, { 112,7110 },
 { 113,7110 }, { 114,7110 }, { 115,7110 }, { 116,7110 }, { 117,7110 },
 { 118,7110 }, { 119,7110 }, { 120,7110 }, { 121,7110 }, { 122,7110 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,7110 }, { 129,7110 }, { 130,7110 }, { 131,7110 }, { 132,7110 },
 { 133,7110 }, { 134,7110 }, { 135,7110 }, { 136,7110 }, { 137,7110 },
 { 138,7110 }, { 139,7110 }, { 140,7110 }, { 141,7110 }, { 142,7110 },
 { 143,7110 }, { 144,7110 }, { 145,7110 }, { 146,7110 }, { 147,7110 },

 { 148,7110 }, { 149,7110 }, { 150,7110 }, { 151,7110 }, { 152,7110 },
 { 153,7110 }, { 154,7110 }, { 155,7110 }, { 156,7110 }, { 157,7110 },
 { 158,7110 }, { 159,7110 }, { 160,7110 }, { 161,7110 }, { 162,7110 },
 { 163,7110 }, { 164,7110 }, { 165,7110 }, { 166,7110 }, { 167,7110 },
 { 168,7110 }, { 169,7110 }, { 170,7110 }, { 171,7110 }, { 172,7110 },
 { 173,7110 }, { 174,7110 }, { 175,7110 }, { 176,7110 }, { 177,7110 },
 { 178,7110 }, { 179,7110 }, { 180,7110 }, { 181,7110 }, { 182,7110 },
 { 183,7110 }, { 184,7110 }, { 185,7110 }, { 186,7110 }, { 187,7110 },
 { 188,7110 }, { 189,7110 }, { 190,7110 }, { 191,7110 }, { 192,7110 },
 { 193,7110 }, { 194,7110 }, { 195,7110 }, { 196,7110 }, { 197,7110 },

 { 198,7110 }, { 199,7110 }, { 200,7110 }, { 201,7110 }, { 202,7110 },
 { 203,7110 }, { 204,7110 }, { 205,7110 }, { 206,7110 }, { 207,7110 },
 { 208,7110 }, { 209,7110 }, { 210,7110 }, { 211,7110 }, { 212,7110 },
 { 213,7110 }, { 214,7110 }, { 215,7110 }, { 216,7110 }, { 217,7110 },
 { 218,7110 }, { 219,7110 }, { 220,7110 }, { 221,7110 }, { 222,7110 },
 { 223,7110 }, { 224,7110 }, { 225,7110 }, { 226,7110 }, { 227,7110 },
 { 228,7110 }, { 229,7110 }, { 230,7110 }, { 231,7110 }, { 232,7110 },
 { 233,7110 }, { 234,7110 }, { 235,7110 }, { 236,7110 }, { 237,7110 },
 { 238,7110 }, { 239,7110 }, { 240,7110 }, { 241,7110 }, { 242,7110 },
 { 243,7110 }, { 244,7110 }, { 245,7110 }, { 246,7110 }, { 247,7110 },

 { 248,7110 }, { 249,7110 }, { 250,7110 }, { 251,7110 }, { 252,7110 },
 { 253,7110 }, { 254,7110 }, { 255,7110 }, {   0,  63 }, {   0,22968 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  36,6853 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,7110 }, {  49,7110 }, {  50,6853 },
 {  51,6853 }, {  52,6853 }, {  53,6853 }, {  54,6853 }, {  55,6853 },
 {  56,6853 }, {  57,6853 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,6853 },
 {  66,6853 }, {  67,6853 }, {  68,6853 }, {  69,6853 }, {  70,6853 },
 {  71,6853 }, {  72,6853 }, {  73,6853 }, {  74,6853 }, {  75,6853 },
 {  76,6853 }, {  77,6853 }, {  78,6853 }, {  79,6853 }, {  80,6853 },
 {  81,6853 }, {  82,6853 }, {  83,6853 }, {  84,6853 }, {  85,6853 },
 {  86,6853 }, {  87,6853 }, {  88,6853 }, {  89,6853 }, {  90,6853 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,7367 },
 {   0,   0 }, {  97,6853 }, {  98,6853 }, {  99,6853 }, { 100,6853 },
 { 101,6853 }, { 102,6853 }, { 103,6853 }, { 104,6853 }, { 105,6853 },
 { 106,6853 }, { 107,6853 }, { 108,6853 }, { 109,6853 }, { 110,6853 },
 { 111,6853 }, { 112,6853 }, { 113,6853 }, { 114,6853 }, { 115,6853 },
 { 116,6853 }, { 117,6853 }, { 118,6853 }, { 119,6853 }, { 120,6853 },
 { 121,6853 }, { 122,6853 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 128,6853 }, { 129,6853 }, { 130,6853 },
 { 131,6853 }, { 132,6853 }, { 133,6853 }, { 134,6853 }, { 135,6853 },
 { 136,6853 }, { 137,6853 }, { 138,6853 }, { 139,6853 }, { 140,6853 },

 { 141,6853 }, { 142,6853 }, { 143,6853 }, { 144,6853 }, { 145,6853 },
 { 146,6853 }, { 147,6853 }, { 148,6853 }, { 149,6853 }, { 150,6853 },
 { 151,6853 }, { 152,6853 }, { 153,6853 }, { 154,6853 }, { 155,6853 },
 { 156,6853 }, { 157,6853 }, { 158,6853 }, { 159,6853 }, { 160,6853 },
 { 161,6853 }, { 162,6853 }, { 163,6853 }, { 164,6853 }, { 165,6853 },
 { 166,6853 }, { 167,6853 }, { 168,6853 }, { 169,6853 }, { 170,6853 },
 { 171,6853 }, { 172,6853 }, { 173,6853 }, { 174,6853 }, { 175,6853 },
 { 176,6853 }, { 177,6853 }, { 178,6853 }, { 179,6853 }, { 180,6853 },
 { 181,6853 }, { 182,6853 }, { 183,6853 }, { 184,6853 }, { 185,6853 },
 { 186,6853 }, { 187,6853 }, { 188,6853 }, { 189,6853 }, { 190,6853 },

 { 191,6853 }, { 192,6853 }, { 193,6853 }, { 194,6853 }, { 195,6853 },
 { 196,6853 }, { 197,6853 }, { 198,6853 }, { 199,6853 }, { 200,6853 },
 { 201,6853 }, { 202,6853 }, { 203,6853 }, { 204,6853 }, { 205,6853 },
 { 206,6853 }, { 207,6853 }, { 208,6853 }, { 209,6853 }, { 210,6853 },
 { 211,6853 }, { 212,6853 }, { 213,6853 }, { 214,6853 }, { 215,6853 },
 { 216,6853 }, { 217,6853 }, { 218,6853 }, { 219,6853 }, { 220,6853 },
 { 221,6853 }, { 222,6853 }, { 223,6853 }, { 224,6853 }, { 225,6853 },
 { 226,6853 }, { 227,6853 }, { 228,6853 }, { 229,6853 }, { 230,6853 },
 { 231,6853 }, { 232,6853 }, { 233,6853 }, { 234,6853 }, { 235,6853 },
 { 236,6853 }, { 237,6853 }, { 238,6853 }, { 239,6853 }, { 240,6853 },

 { 241,6853 }, { 242,6853 }, { 243,6853 }, { 244,6853 }, { 245,6853 },
 { 246,6853 }, { 247,6853 }, { 248,6853 }, { 249,6853 }, { 250,6853 },
 { 251,6853 }, { 252,6853 }, { 253,6853 }, { 254,6853 }, { 255,6853 },
 {   0,  68 }, {   0,22711 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {  36,6596 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  43,7367 },
 {   0,   0 }, {  45,7367 }, {   0,   0 }, {   0,   0 }, {  48,7377 },
 {  49,7377 }, {  50,7377 }, {  51,7377 }, {  52,7377 }, {  53,7377 },
 {  54,7377 }, {  55,7377 }, {  56,7377 }, {  57,7377 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,6596 }, {  66,6596 }, {  67,6596 }, {  68,6596 },
 {  69,6596 }, {  70,6596 }, {  71,6596 }, {  72,6596 }, {  73,6596 },
 {  74,6596 }, {  75,6596 }, {  76,6596 }, {  77,6596 }, {  78,6596 },
 {  79,6596 }, {  80,6596 }, {  81,6596 }, {  82,6596 }, {  83,6596 },

 {  84,6596 }, {  85,6596 }, {  86,6596 }, {  87,6596 }, {  88,6596 },
 {  89,6596 }, {  90,6596 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95,6596 }, {   0,   0 }, {  97,6596 }, {  98,6596 },
 {  99,6596 }, { 100,6596 }, { 101,6596 }, { 102,6596 }, { 103,6596 },
 { 104,6596 }, { 105,6596 }, { 106,6596 }, { 107,6596 }, { 108,6596 },
 { 109,6596 }, { 110,6596 }, { 111,6596 }, { 112,6596 }, { 113,6596 },
 { 114,6596 }, { 115,6596 }, { 116,6596 }, { 117,6596 }, { 118,6596 },
 { 119,6596 }, { 120,6596 }, { 121,6596 }, { 122,6596 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,6596 },
 { 129,6596 }, { 130,6596 }, { 131,6596 }, { 132,6596 }, { 133,6596 },

 { 134,6596 }, { 135,6596 }, { 136,6596 }, { 137,6596 }, { 138,6596 },
 { 139,6596 }, { 140,6596 }, { 141,6596 }, { 142,6596 }, { 143,6596 },
 { 144,6596 }, { 145,6596 }, { 146,6596 }, { 147,6596 }, { 148,6596 },
 { 149,6596 }, { 150,6596 }, { 151,6596 }, { 152,6596 }, { 153,6596 },
 { 154,6596 }, { 155,6596 }, { 156,6596 }, { 157,6596 }, { 158,6596 },
 { 159,6596 }, { 160,6596 }, { 161,6596 }, { 162,6596 }, { 163,6596 },
 { 164,6596 }, { 165,6596 }, { 166,6596 }, { 167,6596 }, { 168,6596 },
 { 169,6596 }, { 170,6596 }, { 171,6596 }, { 172,6596 }, { 173,6596 },
 { 174,6596 }, { 175,6596 }, { 176,6596 }, { 177,6596 }, { 178,6596 },
 { 179,6596 }, { 180,6596 }, { 181,6596 }, { 182,6596 }, { 183,6596 },

 { 184,6596 }, { 185,6596 }, { 186,6596 }, { 187,6596 }, { 188,6596 },
 { 189,6596 }, { 190,6596 }, { 191,6596 }, { 192,6596 }, { 193,6596 },
 { 194,6596 }, { 195,6596 }, { 196,6596 }, { 197,6596 }, { 198,6596 },
 { 199,6596 }, { 200,6596 }, { 201,6596 }, { 202,6596 }, { 203,6596 },
 { 204,6596 }, { 205,6596 }, { 206,6596 }, { 207,6596 }, { 208,6596 },
 { 209,6596 }, { 210,6596 }, { 211,6596 }, { 212,6596 }, { 213,6596 },
 { 214,6596 }, { 215,6596 }, { 216,6596 }, { 217,6596 }, { 218,6596 },
 { 219,6596 }, { 220,6596 }, { 221,6596 }, { 222,6596 }, { 223,6596 },
 { 224,6596 }, { 225,6596 }, { 226,6596 }, { 227,6596 }, { 228,6596 },
 { 229,6596 }, { 230,6596 }, { 231,6596 }, { 232,6596 }, { 233,6596 },

 { 234,6596 }, { 235,6596 }, { 236,6596 }, { 237,6596 }, { 238,6596 },
 { 239,6596 }, { 240,6596 }, { 241,6596 }, { 242,6596 }, { 243,6596 },
 { 244,6596 }, { 245,6596 }, { 246,6596 }, { 247,6596 }, { 248,6596 },
 { 249,6596 }, { 250,6596 }, { 251,6596 }, { 252,6596 }, { 253,6596 },
 { 254,6596 }, { 255,6596 }, {   0,  62 }, {   0,22454 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,6339 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,7377 }, {  49,7377 }, {  50,7377 }, {  51,7377 },
 {  52,7377 }, {  53,7377 }, {  54,7377 }, {  55,7377 }, {  56,6339 },
 {  57,6339 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,6339 }, {  66,6339 },
 {  67,6339 }, {  68,6339 }, {  69,6339 }, {  70,6339 }, {  71,6339 },
 {  72,6339 }, {  73,6339 }, {  74,6339 }, {  75,6339 }, {  76,6339 },

 {  77,6339 }, {  78,6339 }, {  79,6339 }, {  80,6339 }, {  81,6339 },
 {  82,6339 }, {  83,6339 }, {  84,6339 }, {  85,6339 }, {  86,6339 },
 {  87,6339 }, {  88,6339 }, {  89,6339 }, {  90,6339 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,7634 }, {   0,   0 },
 {  97,6339 }, {  98,6339 }, {  99,6339 }, { 100,6339 }, { 101,6339 },
 { 102,6339 }, { 103,6339 }, { 104,6339 }, { 105,6339 }, { 106,6339 },
 { 107,6339 }, { 108,6339 }, { 109,6339 }, { 110,6339 }, { 111,6339 },
 { 112,6339 }, { 113,6339 }, { 114,6339 }, { 115,6339 }, { 116,6339 },
 { 117,6339 }, { 118,6339 }, { 119,6339 }, { 120,6339 }, { 121,6339 },
 { 122,6339 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, { 128,6339 }, { 129,6339 }, { 130,6339 }, { 131,6339 },
 { 132,6339 }, { 133,6339 }, { 134,6339 }, { 135,6339 }, { 136,6339 },
 { 137,6339 }, { 138,6339 }, { 139,6339 }, { 140,6339 }, { 141,6339 },
 { 142,6339 }, { 143,6339 }, { 144,6339 }, { 145,6339 }, { 146,6339 },
 { 147,6339 }, { 148,6339 }, { 149,6339 }, { 150,6339 }, { 151,6339 },
 { 152,6339 }, { 153,6339 }, { 154,6339 }, { 155,6339 }, { 156,6339 },
 { 157,6339 }, { 158,6339 }, { 159,6339 }, { 160,6339 }, { 161,6339 },
 { 162,6339 }, { 163,6339 }, { 164,6339 }, { 165,6339 }, { 166,6339 },
 { 167,6339 }, { 168,6339 }, { 169,6339 }, { 170,6339 }, { 171,6339 },
 { 172,6339 }, { 173,6339 }, { 174,6339 }, { 175,6339 }, { 176,6339 },

 { 177,6339 }, { 178,6339 }, { 179,6339 }, { 180,6339 }, { 181,6339 },
 { 182,6339 }, { 183,6339 }, { 184,6339 }, { 185,6339 }, { 186,6339 },
 { 187,6339 }, { 188,6339 }, { 189,6339 }, { 190,6339 }, { 191,6339 },
 { 192,6339 }, { 193,6339 }, { 194,6339 }, { 195,6339 }, { 196,6339 },
 { 197,6339 }, { 198,6339 }, { 199,6339 }, { 200,6339 }, { 201,6339 },
 { 202,6339 }, { 203,6339 }, { 204,6339 }, { 205,6339 }, { 206,6339 },
 { 207,6339 }, { 208,6339 }, { 209,6339 }, { 210,6339 }, { 211,6339 },
 { 212,6339 }, { 213,6339 }, { 214,6339 }, { 215,6339 }, { 216,6339 },
 { 217,6339 }, { 218,6339 }, { 219,6339 }, { 220,6339 }, { 221,6339 },
 { 222,6339 }, { 223,6339 }, { 224,6339 }, { 225,6339 }, { 226,6339 },

 { 227,6339 }, { 228,6339 }, { 229,6339 }, { 230,6339 }, { 231,6339 },
 { 232,6339 }, { 233,6339 }, { 234,6339 }, { 235,6339 }, { 236,6339 },
 { 237,6339 }, { 238,6339 }, { 239,6339 }, { 240,6339 }, { 241,6339 },
 { 242,6339 }, { 243,6339 }, { 244,6339 }, { 245,6339 }, { 246,6339 },
 { 247,6339 }, { 248,6339 }, { 249,6339 }, { 250,6339 }, { 251,6339 },
 { 252,6339 }, { 253,6339 }, { 254,6339 }, { 255,6339 }, {   0,  61 },
 {   0,22197 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  36,6082 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,7634 }, {  49,7634 },
 {  50,7634 }, {  51,7634 }, {  52,7634 }, {  53,7634 }, {  54,7634 },
 {  55,7634 }, {  56,7634 }, {  57,7634 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,7634 }, {  66,7634 }, {  67,7634 }, {  68,7634 }, {  69,7634 },

 {  70,7634 }, {  71,6082 }, {  72,6082 }, {  73,6082 }, {  74,6082 },
 {  75,6082 }, {  76,6082 }, {  77,6082 }, {  78,6082 }, {  79,6082 },
 {  80,6082 }, {  81,6082 }, {  82,6082 }, {  83,6082 }, {  84,6082 },
 {  85,6082 }, {  86,6082 }, {  87,6082 }, {  88,6082 }, {  89,6082 },
 {  90,6082 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,7891 }, {   0,   0 }, {  97,7634 }, {  98,7634 }, {  99,7634 },
 { 100,7634 }, { 101,7634 }, { 102,7634 }, { 103,6082 }, { 104,6082 },
 { 105,6082 }, { 106,6082 }, { 107,6082 }, { 108,6082 }, { 109,6082 },
 { 110,6082 }, { 111,6082 }, { 112,6082 }, { 113,6082 }, { 114,6082 },
 { 115,6082 }, { 116,6082 }, { 117,6082 }, { 118,6082 }, { 119,6082 },

 { 120,6082 }, { 121,6082 }, { 122,6082 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,6082 }, { 129,6082 },
 { 130,6082 }, { 131,6082 }, { 132,6082 }, { 133,6082 }, { 134,6082 },
 { 135,6082 }, { 136,6082 }, { 137,6082 }, { 138,6082 }, { 139,6082 },
 { 140,6082 }, { 141,6082 }, { 142,6082 }, { 143,6082 }, { 144,6082 },
 { 145,6082 }, { 146,6082 }, { 147,6082 }, { 148,6082 }, { 149,6082 },
 { 150,6082 }, { 151,6082 }, { 152,6082 }, { 153,6082 }, { 154,6082 },
 { 155,6082 }, { 156,6082 }, { 157,6082 }, { 158,6082 }, { 159,6082 },
 { 160,6082 }, { 161,6082 }, { 162,6082 }, { 163,6082 }, { 164,6082 },
 { 165,6082 }, { 166,6082 }, { 167,6082 }, { 168,6082 }, { 169,6082 },

 { 170,6082 }, { 171,6082 }, { 172,6082 }, { 173,6082 }, { 174,6082 },
 { 175,6082 }, { 176,6082 }, { 177,6082 }, { 178,6082 }, { 179,6082 },
 { 180,6082 }, { 181,6082 }, { 182,6082 }, { 183,6082 }, { 184,6082 },
 { 185,6082 }, { 186,6082 }, { 187,6082 }, { 188,6082 }, { 189,6082 },
 { 190,6082 }, { 191,6082 }, { 192,6082 }, { 193,6082 }, { 194,6082 },
 { 195,6082 }, { 196,6082 }, { 197,6082 }, { 198,6082 }, { 199,6082 },
 { 200,6082 }, { 201,6082 }, { 202,6082 }, { 203,6082 }, { 204,6082 },
 { 205,6082 }, { 206,6082 }, { 207,6082 }, { 208,6082 }, { 209,6082 },
 { 210,6082 }, { 211,6082 }, { 212,6082 }, { 213,6082 }, { 214,6082 },
 { 215,6082 }, { 216,6082 }, { 217,6082 }, { 218,6082 }, { 219,6082 },

 { 220,6082 }, { 221,6082 }, { 222,6082 }, { 223,6082 }, { 224,6082 },
 { 225,6082 }, { 226,6082 }, { 227,6082 }, { 228,6082 }, { 229,6082 },
 { 230,6082 }, { 231,6082 }, { 232,6082 }, { 233,6082 }, { 234,6082 },
 { 235,6082 }, { 236,6082 }, { 237,6082 }, { 238,6082 }, { 239,6082 },
 { 240,6082 }, { 241,6082 }, { 242,6082 }, { 243,6082 }, { 244,6082 },
 { 245,6082 }, { 246,6082 }, { 247,6082 }, { 248,6082 }, { 249,6082 },
 { 250,6082 }, { 251,6082 }, { 252,6082 }, { 253,6082 }, { 254,6082 },
 { 255,6082 }, {   0,  68 }, {   0,21940 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,5825 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,7891 }, {  49,7891 }, {  50,7891 }, {  51,7891 }, {  52,7891 },
 {  53,7891 }, {  54,7891 }, {  55,7891 }, {  56,7891 }, {  57,7891 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {  65,5825 }, {  66,5825 }, {  67,5825 },
 {  68,5825 }, {  69,5825 }, {  70,5825 }, {  71,5825 }, {  72,5825 },
 {  73,5825 }, {  74,5825 }, {  75,5825 }, {  76,5825 }, {  77,5825 },
 {  78,5825 }, {  79,5825 }, {  80,5825 }, {  81,5825 }, {  82,5825 },
 {  83,5825 }, {  84,5825 }, {  85,5825 }, {  86,5825 }, {  87,5825 },
 {  88,5825 }, {  89,5825 }, {  90,5825 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,5825 }, {   0,   0 }, {  97,5825 },
 {  98,5825 }, {  99,5825 }, { 100,5825 }, { 101,5825 }, { 102,5825 },
 { 103,5825 }, { 104,5825 }, { 105,5825 }, { 106,5825 }, { 107,5825 },
 { 108,5825 }, { 109,5825 }, { 110,5825 }, { 111,5825 }, { 112,5825 },

 { 113,5825 }, { 114,5825 }, { 115,5825 }, { 116,5825 }, { 117,5825 },
 { 118,5825 }, { 119,5825 }, { 120,5825 }, { 121,5825 }, { 122,5825 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,5825 }, { 129,5825 }, { 130,5825 }, { 131,5825 }, { 132,5825 },
 { 133,5825 }, { 134,5825 }, { 135,5825 }, { 136,5825 }, { 137,5825 },
 { 138,5825 }, { 139,5825 }, { 140,5825 }, { 141,5825 }, { 142,5825 },
 { 143,5825 }, { 144,5825 }, { 145,5825 }, { 146,5825 }, { 147,5825 },
 { 148,5825 }, { 149,5825 }, { 150,5825 }, { 151,5825 }, { 152,5825 },
 { 153,5825 }, { 154,5825 }, { 155,5825 }, { 156,5825 }, { 157,5825 },
 { 158,5825 }, { 159,5825 }, { 160,5825 }, { 161,5825 }, { 162,5825 },

 { 163,5825 }, { 164,5825 }, { 165,5825 }, { 166,5825 }, { 167,5825 },
 { 168,5825 }, { 169,5825 }, { 170,5825 }, { 171,5825 }, { 172,5825 },
 { 173,5825 }, { 174,5825 }, { 175,5825 }, { 176,5825 }, { 177,5825 },
 { 178,5825 }, { 179,5825 }, { 180,5825 }, { 181,5825 }, { 182,5825 },
 { 183,5825 }, { 184,5825 }, { 185,5825 }, { 186,5825 }, { 187,5825 },
 { 188,5825 }, { 189,5825 }, { 190,5825 }, { 191,5825 }, { 192,5825 },
 { 193,5825 }, { 194,5825 }, { 195,5825 }, { 196,5825 }, { 197,5825 },
 { 198,5825 }, { 199,5825 }, { 200,5825 }, { 201,5825 }, { 202,5825 },
 { 203,5825 }, { 204,5825 }, { 205,5825 }, { 206,5825 }, { 207,5825 },
 { 208,5825 }, { 209,5825 }, { 210,5825 }, { 211,5825 }, { 212,5825 },

 { 213,5825 }, { 214,5825 }, { 215,5825 }, { 216,5825 }, { 217,5825 },
 { 218,5825 }, { 219,5825 }, { 220,5825 }, { 221,5825 }, { 222,5825 },
 { 223,5825 }, { 224,5825 }, { 225,5825 }, { 226,5825 }, { 227,5825 },
 { 228,5825 }, { 229,5825 }, { 230,5825 }, { 231,5825 }, { 232,5825 },
 { 233,5825 }, { 234,5825 }, { 235,5825 }, { 236,5825 }, { 237,5825 },
 { 238,5825 }, { 239,5825 }, { 240,5825 }, { 241,5825 }, { 242,5825 },
 { 243,5825 }, { 244,5825 }, { 245,5825 }, { 246,5825 }, { 247,5825 },
 { 248,5825 }, { 249,5825 }, { 250,5825 }, { 251,5825 }, { 252,5825 },
 { 253,5825 }, { 254,5825 }, { 255,5825 }, {   0,  49 }, {   0,21683 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  51 },
 {   0,21672 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  33,-3207 }, {   0,   0 }, {  35,-3207 },
 {   0,   0 }, {  37,-3207 }, {  38,-3207 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  42,-3207 }, {  43,-3207 }, {  33,-3218 }, {  45,-3207 },
 {  35,-3218 }, {  47,-3207 }, {  37,-3218 }, {  38,-3218 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  42,-3218 }, {  43,-3218 }, {   0,   0 },

 {  45,-3218 }, {   0,   0 }, {  47,-3218 }, {   0,   0 }, {  60,-3207 },
 {  61,-3207 }, {  62,-3207 }, {  63,-3207 }, {  64,-3207 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  60,-3218 }, {  61,-3218 }, {  62,-3218 }, {  63,-3218 }, {  64,-3218 },
 {   0,   0 }, {   0,  48 }, {   0,21605 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,-3207 }, {   0,   0 },
 {  96,-3207 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,-3218 },

 {   0,   0 }, {  96,-3218 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  33,-3285 }, {   0,   0 }, {  35,-3285 }, {   0,   0 }, {  37,-3285 },
 {  38,-3285 }, {   0,  50 }, {   0,21565 }, {   0,   0 }, {  42,-3285 },
 {  43,-3285 }, {   0,   0 }, {  45,-3285 }, { 124,-3207 }, {  47,-3285 },
 { 126,-3207 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 124,-3218 },
 {   0,   0 }, { 126,-3218 }, {  60,-3285 }, {  61,-3285 }, {  62,-3285 },
 {  63,-3285 }, {  64,-3285 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  33,-3325 }, {   0,   0 }, {  35,-3325 }, {   0,   0 }, {  37,-3325 },

 {  38,-3325 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  42,-3325 },
 {  43,-3325 }, {   0,   0 }, {  45,-3325 }, {   0,   0 }, {  47,-3325 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  94,-3285 }, {   0,   0 }, {  96,-3285 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  60,-3325 }, {  61,-3325 }, {  62,-3325 },
 {  63,-3325 }, {  64,-3325 }, {   0,  71 }, {   0,21499 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 124,-3285 }, {   0,   0 }, { 126,-3285 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  94,-3325 }, {   0,   0 }, {  96,-3325 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 },
 {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 },
 {  57,   0 }, { 124,-3325 }, {   0,   0 }, { 126,-3325 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,   0 }, {  66,   0 },
 {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 },

 {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 },
 {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 },
 {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 },
 {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,   0 }, {   0,   0 },
 {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 },
 { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 },
 { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 },
 { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 },
 { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 },

 { 122,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 },
 { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 },
 { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 },
 { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 },
 { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 },
 { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 },
 { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 },
 { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 },
 { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 },

 { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 },
 { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 },
 { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 },
 { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 },
 { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 },
 { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 },
 { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 },
 { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 },
 { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 },
 { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 },

 { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 },
 { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 },
 { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 },
 { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 },
 { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 },
 { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 },
 { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 }, {   0,  10 },
 {   0,21242 }, {   1,   0 }, {   2,   0 }, {   3,   0 }, {   4,   0 },
 {   5,   0 }, {   6,   0 }, {   7,   0 }, {   8,   0 }, {   9,   0 },
 {  10,   0 }, {  11,   0 }, {  12,   0 }, {  13,   0 }, {  14,   0 },

 {  15,   0 }, {  16,   0 }, {  17,   0 }, {  18,   0 }, {  19,   0 },
 {  20,   0 }, {  21,   0 }, {  22,   0 }, {  23,   0 }, {  24,   0 },
 {  25,   0 }, {  26,   0 }, {  27,   0 }, {  28,   0 }, {  29,   0 },
 {  30,   0 }, {  31,   0 }, {  32,   0 }, {  33,   0 }, {  34,   0 },
 {  35,   0 }, {  36,   0 }, {  37,   0 }, {  38,   0 }, {   0,   0 },
 {  40,   0 }, {  41,   0 }, {  42,   0 }, {  43,   0 }, {  44,   0 },
 {  45,   0 }, {  46,   0 }, {  47,   0 }, {  48,   0 }, {  49,   0 },
 {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 },
 {  55,   0 }, {  56,   0 }, {  57,   0 }, {  58,   0 }, {  59,   0 },
 {  60,   0 }, {  61,   0 }, {  62,   0 }, {  63,   0 }, {  64,   0 },

 {  65,   0 }, {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 },
 {  70,   0 }, {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 },
 {  75,   0 }, {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 },
 {  80,   0 }, {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 },
 {  85,   0 }, {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 },
 {  90,   0 }, {  91,   0 }, {  92,   0 }, {  93,   0 }, {  94,   0 },
 {  95,   0 }, {  96,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 },
 { 100,   0 }, { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 },
 { 105,   0 }, { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 },
 { 110,   0 }, { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 },

 { 115,   0 }, { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 },
 { 120,   0 }, { 121,   0 }, { 122,   0 }, { 123,   0 }, { 124,   0 },
 { 125,   0 }, { 126,   0 }, { 127,   0 }, { 128,   0 }, { 129,   0 },
 { 130,   0 }, { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 },
 { 135,   0 }, { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 },
 { 140,   0 }, { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 },
 { 145,   0 }, { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 },
 { 150,   0 }, { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 },
 { 155,   0 }, { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 },
 { 160,   0 }, { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 },

 { 165,   0 }, { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 },
 { 170,   0 }, { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 },
 { 175,   0 }, { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 },
 { 180,   0 }, { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 },
 { 185,   0 }, { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 },
 { 190,   0 }, { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 },
 { 195,   0 }, { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 },
 { 200,   0 }, { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 },
 { 205,   0 }, { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 },
 { 210,   0 }, { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 },

 { 215,   0 }, { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 },
 { 220,   0 }, { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 },
 { 225,   0 }, { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 },
 { 230,   0 }, { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 },
 { 235,   0 }, { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 },
 { 240,   0 }, { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 },
 { 245,   0 }, { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 },
 { 250,   0 }, { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 },
 { 255,   0 }, { 256,   0 }, {   0,   5 }, {   0,20984 }, {   1,   0 },
 {   2,   0 }, {   3,   0 }, {   4,   0 }, {   5,   0 }, {   6,   0 },

 {   7,   0 }, {   8,   0 }, {   9,   0 }, {  10,   0 }, {  11,   0 },
 {  12,   0 }, {  13,   0 }, {  14,   0 }, {  15,   0 }, {  16,   0 },
 {  17,   0 }, {  18,   0 }, {  19,   0 }, {  20,   0 }, {  21,   0 },
 {  22,   0 }, {  23,   0 }, {  24,   0 }, {  25,   0 }, {  26,   0 },
 {  27,   0 }, {  28,   0 }, {  29,   0 }, {  30,   0 }, {  31,   0 },
 {  32,   0 }, {  33,   0 }, {  34,   0 }, {  35,   0 }, {  36,   0 },
 {  37,   0 }, {  38,   0 }, {  39,   0 }, {  40,   0 }, {  41,   0 },
 {   0,   0 }, {  43,   0 }, {  44,   0 }, {  45,   0 }, {  46,   0 },
 {   0,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 },
 {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 },

 {  57,   0 }, {  58,   0 }, {  59,   0 }, {  60,   0 }, {  61,   0 },
 {  62,   0 }, {  63,   0 }, {  64,   0 }, {  65,   0 }, {  66,   0 },
 {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 },
 {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 },
 {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 },
 {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 },
 {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 }, {  91,   0 },
 {  92,   0 }, {  93,   0 }, {  94,   0 }, {  95,   0 }, {  96,   0 },
 {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 },
 { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 },

 { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 },
 { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 },
 { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 },
 { 122,   0 }, { 123,   0 }, { 124,   0 }, { 125,   0 }, { 126,   0 },
 { 127,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 },
 { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 },
 { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 },
 { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 },
 { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 },
 { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 },

 { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 },
 { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 },
 { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 },
 { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 },
 { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 },
 { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 },
 { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 },
 { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 },
 { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 },
 { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 },

 { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 },
 { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 },
 { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 },
 { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 },
 { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 },
 { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 },
 { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 },
 { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 },
 { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 },
 { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 }, { 256,   0 },

 {   0,   3 }, {   0,20726 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  33,6934 },
 {   0,   0 }, {  35,6934 }, {   0,   0 }, {  37,6934 }, {  38,6934 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  42,6934 }, {  43,6934 },
 {   0,   0 }, {  45,6934 }, {   0,   0 }, {  47,6934 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  60,6934 }, {  61,6934 }, {  62,6934 }, {  63,6934 },
 {  64,6934 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  94,6934 }, {   0,   0 }, {  96,6934 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 124,6934 }, {   0,   0 }, { 126,6934 }, {   0,  43 }, {   0,20598 },
 {   1,   0 }, {   2,   0 }, {   3,   0 }, {   4,   0 }, {   5,   0 },
 {   6,   0 }, {   7,   0 }, {   8,   0 }, {   9,   0 }, {  10,   0 },
 {  11,   0 }, {  12,   0 }, {  13,   0 }, {  14,   0 }, {  15,   0 },
 {  16,   0 }, {  17,   0 }, {  18,   0 }, {  19,   0 }, {  20,   0 },

 {  21,   0 }, {  22,   0 }, {  23,   0 }, {  24,   0 }, {  25,   0 },
 {  26,   0 }, {  27,   0 }, {  28,   0 }, {  29,   0 }, {  30,   0 },
 {  31,   0 }, {  32,   0 }, {  33,   0 }, {   0,   0 }, {  35,   0 },
 {  36,   0 }, {  37,   0 }, {  38,   0 }, {  39,   0 }, {  40,   0 },
 {  41,   0 }, {  42,   0 }, {  43,   0 }, {  44,   0 }, {  45,   0 },
 {  46,   0 }, {  47,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 },
 {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 },
 {  56,   0 }, {  57,   0 }, {  58,   0 }, {  59,   0 }, {  60,   0 },
 {  61,   0 }, {  62,   0 }, {  63,   0 }, {  64,   0 }, {  65,   0 },
 {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 },

 {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 },
 {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 },
 {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 },
 {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 },
 {  91,   0 }, {  92,   0 }, {  93,   0 }, {  94,   0 }, {  95,   0 },
 {  96,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 },
 { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 },
 { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 },
 { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 },
 { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 },

 { 121,   0 }, { 122,   0 }, { 123,   0 }, { 124,   0 }, { 125,   0 },
 { 126,   0 }, { 127,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 },
 { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 },
 { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 },
 { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 },
 { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 },
 { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 },
 { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 },
 { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 },
 { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 },

 { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 },
 { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 },
 { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 },
 { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 },
 { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 },
 { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 },
 { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 },
 { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 },
 { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 },
 { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 },

 { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 },
 { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 },
 { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 },
 { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 },
 { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 },
 { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 },
 { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 },
 { 256,   0 }, {   0,   9 }, {   0,20340 }, {   1,   0 }, {   2,   0 },
 {   3,   0 }, {   4,   0 }, {   5,   0 }, {   6,   0 }, {   7,   0 },
 {   8,   0 }, {   9,   0 }, {  10,   0 }, {  11,   0 }, {  12,   0 },

 {  13,   0 }, {  14,   0 }, {  15,   0 }, {  16,   0 }, {  17,   0 },
 {  18,   0 }, {  19,   0 }, {  20,   0 }, {  21,   0 }, {  22,   0 },
 {  23,   0 }, {  24,   0 }, {  25,   0 }, {  26,   0 }, {  27,   0 },
 {  28,   0 }, {  29,   0 }, {  30,   0 }, {  31,   0 }, {  32,   0 },
 {  33,   0 }, {  34,   0 }, {  35,   0 }, {  36,   0 }, {  37,   0 },
 {  38,   0 }, {   0,   0 }, {  40,   0 }, {  41,   0 }, {  42,   0 },
 {  43,   0 }, {  44,   0 }, {  45,   0 }, {  46,   0 }, {  47,   0 },
 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },
 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },
 {  58,   0 }, {  59,   0 }, {  60,   0 }, {  61,   0 }, {  62,   0 },

 {  63,   0 }, {  64,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 },
 {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 },
 {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 },
 {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 },
 {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 },
 {  88,   0 }, {  89,   0 }, {  90,   0 }, {  91,   0 }, {  92,   0 },
 {  93,   0 }, {  94,   0 }, {  95,   0 }, {  96,   0 }, {  97,   0 },
 {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 },
 { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 },
 { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 },

 { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 },
 { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 },
 { 123,   0 }, { 124,   0 }, { 125,   0 }, { 126,   0 }, { 127,   0 },
 { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 },
 { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 },
 { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 },
 { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 },
 { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 },
 { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 },
 { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 },

 { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 },
 { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 },
 { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 },
 { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 },
 { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 },
 { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 },
 { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 },
 { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 },
 { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 },
 { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 },

 { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 },
 { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 },
 { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 },
 { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 },
 { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 },
 { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 },
 { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 },
 { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 },
 { 253,   0 }, { 254,   0 }, { 255,   0 }, { 256,   0 }, {   0,  21 },
 {   0,20082 }, {   1,   0 }, {   2,   0 }, {   3,   0 }, {   4,   0 },

 {   5,   0 }, {   6,   0 }, {   7,   0 }, {   8,   0 }, {   9,   0 },
 {  10,   0 }, {  11,   0 }, {  12,   0 }, {  13,   0 }, {  14,   0 },
 {  15,   0 }, {  16,   0 }, {  17,   0 }, {  18,   0 }, {  19,   0 },
 {  20,   0 }, {  21,   0 }, {  22,   0 }, {  23,   0 }, {  24,   0 },
 {  25,   0 }, {  26,   0 }, {  27,   0 }, {  28,   0 }, {  29,   0 },
 {  30,   0 }, {  31,   0 }, {  32,   0 }, {  33,   0 }, {  34,   0 },
 {  35,   0 }, {  36,   0 }, {  37,   0 }, {  38,   0 }, {   0,   0 },
 {  40,   0 }, {  41,   0 }, {  42,   0 }, {  43,   0 }, {  44,   0 },
 {  45,   0 }, {  46,   0 }, {  47,   0 }, {  48,   0 }, {  49,   0 },
 {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 },

 {  55,   0 }, {  56,   0 }, {  57,   0 }, {  58,   0 }, {  59,   0 },
 {  60,   0 }, {  61,   0 }, {  62,   0 }, {  63,   0 }, {  64,   0 },
 {  65,   0 }, {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 },
 {  70,   0 }, {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 },
 {  75,   0 }, {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 },
 {  80,   0 }, {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 },
 {  85,   0 }, {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 },
 {  90,   0 }, {  91,   0 }, {  92,   0 }, {  93,   0 }, {  94,   0 },
 {  95,   0 }, {  96,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 },
 { 100,   0 }, { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 },

 { 105,   0 }, { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 },
 { 110,   0 }, { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 },
 { 115,   0 }, { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 },
 { 120,   0 }, { 121,   0 }, { 122,   0 }, { 123,   0 }, { 124,   0 },
 { 125,   0 }, { 126,   0 }, { 127,   0 }, { 128,   0 }, { 129,   0 },
 { 130,   0 }, { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 },
 { 135,   0 }, { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 },
 { 140,   0 }, { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 },
 { 145,   0 }, { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 },
 { 150,   0 }, { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 },

 { 155,   0 }, { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 },
 { 160,   0 }, { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 },
 { 165,   0 }, { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 },
 { 170,   0 }, { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 },
 { 175,   0 }, { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 },
 { 180,   0 }, { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 },
 { 185,   0 }, { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 },
 { 190,   0 }, { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 },
 { 195,   0 }, { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 },
 { 200,   0 }, { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 },

 { 205,   0 }, { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 },
 { 210,   0 }, { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 },
 { 215,   0 }, { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 },
 { 220,   0 }, { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 },
 { 225,   0 }, { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 },
 { 230,   0 }, { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 },
 { 235,   0 }, { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 },
 { 240,   0 }, { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 },
 { 245,   0 }, { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 },
 { 250,   0 }, { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 },

 { 255,   0 }, { 256,   0 }, {   0,  18 }, {   0,19824 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,  18 }, {   0,19819 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   9,   0 }, {  10,   5 }, {  11,   0 },
 {  12,   0 }, {  13,   5 }, {   9,  24 }, {  10,  24 }, {  11,  24 },
 {  12,  24 }, {  13,  24 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,  18 }, {   0,19795 }, {   0,   0 }, {   0,   0 },
 {  32,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  32,  24 }, {   9,   0 }, {  10,   0 }, {  11,   0 }, {  12,   0 },
 {  13,   0 }, {   0,   0 }, {  39,-10519 }, {  45,-10516 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  45,-10517 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  32,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  39,-10543 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  45,-10541 }, {   0,  18 }, {   0,19748 },
 {   1,6342 }, {   2,6342 }, {   3,6342 }, {   4,6342 }, {   5,6342 },
 {   6,6342 }, {   7,6342 }, {   8,6342 }, {   9,6600 }, {  10, -71 },
 {  11,6600 }, {  12,6600 }, {  13, -71 }, {  14,6342 }, {  15,6342 },
 {  16,6342 }, {  17,6342 }, {  18,6342 }, {  19,6342 }, {  20,6342 },

 {  21,6342 }, {  22,6342 }, {  23,6342 }, {  24,6342 }, {  25,6342 },
 {  26,6342 }, {  27,6342 }, {  28,6342 }, {  29,6342 }, {  30,6342 },
 {  31,6342 }, {  32,6600 }, {  33,6342 }, {  34,6342 }, {  35,6342 },
 {  36,6342 }, {  37,6342 }, {  38,6342 }, {  39,6342 }, {  40,6342 },
 {  41,6342 }, {  42,6342 }, {  43,6342 }, {  44,6342 }, {  45,6858 },
 {  46,6342 }, {  47,6342 }, {  48,6342 }, {  49,6342 }, {  50,6342 },
 {  51,6342 }, {  52,6342 }, {  53,6342 }, {  54,6342 }, {  55,6342 },
 {  56,6342 }, {  57,6342 }, {  58,6342 }, {  59,6342 }, {  60,6342 },
 {  61,6342 }, {  62,6342 }, {  63,6342 }, {  64,6342 }, {  65,6342 },
 {  66,6342 }, {  67,6342 }, {  68,6342 }, {  69,6342 }, {  70,6342 },

 {  71,6342 }, {  72,6342 }, {  73,6342 }, {  74,6342 }, {  75,6342 },
 {  76,6342 }, {  77,6342 }, {  78,6342 }, {  79,6342 }, {  80,6342 },
 {  81,6342 }, {  82,6342 }, {  83,6342 }, {  84,6342 }, {  85,6342 },
 {  86,6342 }, {  87,6342 }, {  88,6342 }, {  89,6342 }, {  90,6342 },
 {  91,6342 }, {  92,6342 }, {  93,6342 }, {  94,6342 }, {  95,6342 },
 {  96,6342 }, {  97,6342 }, {  98,6342 }, {  99,6342 }, { 100,6342 },
 { 101,6342 }, { 102,6342 }, { 103,6342 }, { 104,6342 }, { 105,6342 },
 { 106,6342 }, { 107,6342 }, { 108,6342 }, { 109,6342 }, { 110,6342 },
 { 111,6342 }, { 112,6342 }, { 113,6342 }, { 114,6342 }, { 115,6342 },
 { 116,6342 }, { 117,6342 }, { 118,6342 }, { 119,6342 }, { 120,6342 },

 { 121,6342 }, { 122,6342 }, { 123,6342 }, { 124,6342 }, { 125,6342 },
 { 126,6342 }, { 127,6342 }, { 128,6342 }, { 129,6342 }, { 130,6342 },
 { 131,6342 }, { 132,6342 }, { 133,6342 }, { 134,6342 }, { 135,6342 },
 { 136,6342 }, { 137,6342 }, { 138,6342 }, { 139,6342 }, { 140,6342 },
 { 141,6342 }, { 142,6342 }, { 143,6342 }, { 144,6342 }, { 145,6342 },
 { 146,6342 }, { 147,6342 }, { 148,6342 }, { 149,6342 }, { 150,6342 },
 { 151,6342 }, { 152,6342 }, { 153,6342 }, { 154,6342 }, { 155,6342 },
 { 156,6342 }, { 157,6342 }, { 158,6342 }, { 159,6342 }, { 160,6342 },
 { 161,6342 }, { 162,6342 }, { 163,6342 }, { 164,6342 }, { 165,6342 },
 { 166,6342 }, { 167,6342 }, { 168,6342 }, { 169,6342 }, { 170,6342 },

 { 171,6342 }, { 172,6342 }, { 173,6342 }, { 174,6342 }, { 175,6342 },
 { 176,6342 }, { 177,6342 }, { 178,6342 }, { 179,6342 }, { 180,6342 },
 { 181,6342 }, { 182,6342 }, { 183,6342 }, { 184,6342 }, { 185,6342 },
 { 186,6342 }, { 187,6342 }, { 188,6342 }, { 189,6342 }, { 190,6342 },
 { 191,6342 }, { 192,6342 }, { 193,6342 }, { 194,6342 }, { 195,6342 },
 { 196,6342 }, { 197,6342 }, { 198,6342 }, { 199,6342 }, { 200,6342 },
 { 201,6342 }, { 202,6342 }, { 203,6342 }, { 204,6342 }, { 205,6342 },
 { 206,6342 }, { 207,6342 }, { 208,6342 }, { 209,6342 }, { 210,6342 },
 { 211,6342 }, { 212,6342 }, { 213,6342 }, { 214,6342 }, { 215,6342 },
 { 216,6342 }, { 217,6342 }, { 218,6342 }, { 219,6342 }, { 220,6342 },

 { 221,6342 }, { 222,6342 }, { 223,6342 }, { 224,6342 }, { 225,6342 },
 { 226,6342 }, { 227,6342 }, { 228,6342 }, { 229,6342 }, { 230,6342 },
 { 231,6342 }, { 232,6342 }, { 233,6342 }, { 234,6342 }, { 235,6342 },
 { 236,6342 }, { 237,6342 }, { 238,6342 }, { 239,6342 }, { 240,6342 },
 { 241,6342 }, { 242,6342 }, { 243,6342 }, { 244,6342 }, { 245,6342 },
 { 246,6342 }, { 247,6342 }, { 248,6342 }, { 249,6342 }, { 250,6342 },
 { 251,6342 }, { 252,6342 }, { 253,6342 }, { 254,6342 }, { 255,6342 },
 { 256,6342 }, {   0,  22 }, {   0,19490 }, {   1,   0 }, {   2,   0 },
 {   3,   0 }, {   4,   0 }, {   5,   0 }, {   6,   0 }, {   7,   0 },
 {   8,   0 }, {   9,   0 }, {  10,   0 }, {  11,   0 }, {  12,   0 },

 {  13,   0 }, {  14,   0 }, {  15,   0 }, {  16,   0 }, {  17,   0 },
 {  18,   0 }, {  19,   0 }, {  20,   0 }, {  21,   0 }, {  22,   0 },
 {  23,   0 }, {  24,   0 }, {  25,   0 }, {  26,   0 }, {  27,   0 },
 {  28,   0 }, {  29,   0 }, {  30,   0 }, {  31,   0 }, {  32,   0 },
 {  33,   0 }, {  34,   0 }, {  35,   0 }, {  36,   0 }, {  37,   0 },
 {  38,   0 }, {   0,   0 }, {  40,   0 }, {  41,   0 }, {  42,   0 },
 {  43,   0 }, {  44,   0 }, {  45,   0 }, {  46,   0 }, {  47,   0 },
 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },
 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },
 {  58,   0 }, {  59,   0 }, {  60,   0 }, {  61,   0 }, {  62,   0 },

 {  63,   0 }, {  64,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 },
 {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 },
 {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 },
 {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 },
 {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 },
 {  88,   0 }, {  89,   0 }, {  90,   0 }, {  91,   0 }, {   0,   0 },
 {  93,   0 }, {  94,   0 }, {  95,   0 }, {  96,   0 }, {  97,   0 },
 {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 },
 { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 },
 { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 },

 { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 },
 { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 },
 { 123,   0 }, { 124,   0 }, { 125,   0 }, { 126,   0 }, { 127,   0 },
 { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 },
 { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 },
 { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 },
 { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 },
 { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 },
 { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 },
 { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 },

 { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 },
 { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 },
 { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 },
 { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 },
 { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 },
 { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 },
 { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 },
 { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 },
 { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 },
 { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 },

 { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 },
 { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 },
 { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 },
 { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 },
 { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 },
 { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 },
 { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 },
 { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 },
 { 253,   0 }, { 254,   0 }, { 255,   0 }, { 256,   0 }, {   0,  29 },
 {   0,19232 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,  27 }, {   0,19224 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,  27 }, {   0,19201 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,6600 }, {  49,6600 },
 {  50,6600 }, {  51,6600 }, {  52,6600 }, {  53,6600 }, {  54,6600 },

 {  55,6600 }, {  48,6600 }, {  49,6600 }, {  50,6600 }, {  51,6600 },
 {  52,6600 }, {  53,6600 }, {  54,6600 }, {  55,6600 }, {  56,6600 },
 {  57,6600 }, {   0,   0 }, {   0,   0 }, {   0,  28 }, {   0,19163 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,6600 }, {  66,6600 },
 {  67,6600 }, {  68,6600 }, {  69,6600 }, {  70,6600 }, {  48,6600 },
 {  49,6600 }, {  50,6600 }, {  51,6600 }, {  52,6600 }, {  53,6600 },
 {  54,6600 }, {  55,6600 }, {  56,6600 }, {  57,6600 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,6600 }, {  66,6600 }, {  67,6600 }, {  68,6600 },
 {  69,6600 }, {  70,6600 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {  97,6600 }, {  98,6600 }, {  99,6600 }, { 100,6600 }, { 101,6600 },
 { 102,6600 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,6600 }, {  49,6600 }, {  50,6600 },
 {  51,6600 }, {  52,6600 }, {  53,6600 }, {  54,6600 }, {  55,6600 },
 {  56,6600 }, {  57,6600 }, {   0,   0 }, {  97,6600 }, {  98,6600 },
 {  99,6600 }, { 100,6600 }, { 101,6600 }, { 102,6600 }, {  65,6600 },
 {  66,6600 }, {  67,6600 }, {  68,6600 }, {  69,6600 }, {  70,6600 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  97,6600 }, {  98,6600 }, {  99,6600 }, { 100,6600 },
 { 101,6600 }, { 102,6600 }, {   0,  35 }, {   0,19059 }, {   1,   0 },
 {   2,   0 }, {   3,   0 }, {   4,   0 }, {   5,   0 }, {   6,   0 },
 {   7,   0 }, {   8,   0 }, {   9,   0 }, {  10,   0 }, {  11,   0 },
 {  12,   0 }, {  13,   0 }, {  14,   0 }, {  15,   0 }, {  16,   0 },
 {  17,   0 }, {  18,   0 }, {  19,   0 }, {  20,   0 }, {  21,   0 },
 {  22,   0 }, {  23,   0 }, {  24,   0 }, {  25,   0 }, {  26,   0 },
 {  27,   0 }, {  28,   0 }, {  29,   0 }, {  30,   0 }, {  31,   0 },

 {  32,   0 }, {  33,   0 }, {  34,   0 }, {  35,   0 }, {   0,   0 },
 {  37,   0 }, {  38,   0 }, {  39,   0 }, {  40,   0 }, {  41,   0 },
 {  42,   0 }, {  43,   0 }, {  44,   0 }, {  45,   0 }, {  46,   0 },
 {  47,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 },
 {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 },
 {  57,   0 }, {  58,   0 }, {  59,   0 }, {  60,   0 }, {  61,   0 },
 {  62,   0 }, {  63,   0 }, {  64,   0 }, {  65,   0 }, {  66,   0 },
 {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 },
 {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 },
 {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 },

 {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 },
 {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 }, {  91,   0 },
 {  92,   0 }, {  93,   0 }, {  94,   0 }, {  95,   0 }, {  96,   0 },
 {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 },
 { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 },
 { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 },
 { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 },
 { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 },
 { 122,   0 }, { 123,   0 }, { 124,   0 }, { 125,   0 }, { 126,   0 },
 { 127,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 },

 { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 },
 { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 },
 { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 },
 { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 },
 { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 },
 { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 },
 { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 },
 { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 },
 { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 },
 { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 },

 { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 },
 { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 },
 { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 },
 { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 },
 { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 },
 { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 },
 { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 },
 { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 },
 { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 },
 { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 },

 { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 },
 { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 },
 { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 },
 { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 },
 { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 }, { 256,   0 },
 {   0,  36 }, {   0,18801 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  36,-11531 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,6310 },
 {  49,6310 }, {  50,6310 }, {  51,6310 }, {  52,6310 }, {  53,6310 },
 {  54,6310 }, {  55,6310 }, {  56,6310 }, {  57,6310 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,6310 }, {  66,6310 }, {  67,6310 }, {  68,6310 },
 {  69,6310 }, {  70,6310 }, {  71,6310 }, {  72,6310 }, {  73,6310 },

 {  74,6310 }, {  75,6310 }, {  76,6310 }, {  77,6310 }, {  78,6310 },
 {  79,6310 }, {  80,6310 }, {  81,6310 }, {  82,6310 }, {  83,6310 },
 {  84,6310 }, {  85,6310 }, {  86,6310 }, {  87,6310 }, {  88,6310 },
 {  89,6310 }, {  90,6310 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95,6310 }, {   0,   0 }, {  97,6310 }, {  98,6310 },
 {  99,6310 }, { 100,6310 }, { 101,6310 }, { 102,6310 }, { 103,6310 },
 { 104,6310 }, { 105,6310 }, { 106,6310 }, { 107,6310 }, { 108,6310 },
 { 109,6310 }, { 110,6310 }, { 111,6310 }, { 112,6310 }, { 113,6310 },
 { 114,6310 }, { 115,6310 }, { 116,6310 }, { 117,6310 }, { 118,6310 },
 { 119,6310 }, { 120,6310 }, { 121,6310 }, { 122,6310 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,6310 },
 { 129,6310 }, { 130,6310 }, { 131,6310 }, { 132,6310 }, { 133,6310 },
 { 134,6310 }, { 135,6310 }, { 136,6310 }, { 137,6310 }, { 138,6310 },
 { 139,6310 }, { 140,6310 }, { 141,6310 }, { 142,6310 }, { 143,6310 },
 { 144,6310 }, { 145,6310 }, { 146,6310 }, { 147,6310 }, { 148,6310 },
 { 149,6310 }, { 150,6310 }, { 151,6310 }, { 152,6310 }, { 153,6310 },
 { 154,6310 }, { 155,6310 }, { 156,6310 }, { 157,6310 }, { 158,6310 },
 { 159,6310 }, { 160,6310 }, { 161,6310 }, { 162,6310 }, { 163,6310 },
 { 164,6310 }, { 165,6310 }, { 166,6310 }, { 167,6310 }, { 168,6310 },
 { 169,6310 }, { 170,6310 }, { 171,6310 }, { 172,6310 }, { 173,6310 },

 { 174,6310 }, { 175,6310 }, { 176,6310 }, { 177,6310 }, { 178,6310 },
 { 179,6310 }, { 180,6310 }, { 181,6310 }, { 182,6310 }, { 183,6310 },
 { 184,6310 }, { 185,6310 }, { 186,6310 }, { 187,6310 }, { 188,6310 },
 { 189,6310 }, { 190,6310 }, { 191,6310 }, { 192,6310 }, { 193,6310 },
 { 194,6310 }, { 195,6310 }, { 196,6310 }, { 197,6310 }, { 198,6310 },
 { 199,6310 }, { 200,6310 }, { 201,6310 }, { 202,6310 }, { 203,6310 },
 { 204,6310 }, { 205,6310 }, { 206,6310 }, { 207,6310 }, { 208,6310 },
 { 209,6310 }, { 210,6310 }, { 211,6310 }, { 212,6310 }, { 213,6310 },
 { 214,6310 }, { 215,6310 }, { 216,6310 }, { 217,6310 }, { 218,6310 },
 { 219,6310 }, { 220,6310 }, { 221,6310 }, { 222,6310 }, { 223,6310 },

 { 224,6310 }, { 225,6310 }, { 226,6310 }, { 227,6310 }, { 228,6310 },
 { 229,6310 }, { 230,6310 }, { 231,6310 }, { 232,6310 }, { 233,6310 },
 { 234,6310 }, { 235,6310 }, { 236,6310 }, { 237,6310 }, { 238,6310 },
 { 239,6310 }, { 240,6310 }, { 241,6310 }, { 242,6310 }, { 243,6310 },
 { 244,6310 }, { 245,6310 }, { 246,6310 }, { 247,6310 }, { 248,6310 },
 { 249,6310 }, { 250,6310 }, { 251,6310 }, { 252,6310 }, { 253,6310 },
 { 254,6310 }, { 255,6310 }, {   0,  27 }, {   0,18544 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,  27 }, {   0,18521 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,6310 }, {  49,6310 }, {  50,6310 }, {  51,6310 },
 {  52,6310 }, {  53,6310 }, {  54,6310 }, {  55,6310 }, {  56,6310 },
 {  57,6310 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,6310 }, {  66,6310 },

 {  67,6310 }, {  68,6310 }, {  69,6310 }, {  70,6310 }, {  48,6310 },
 {  49,6310 }, {  50,6310 }, {  51,6310 }, {  52,6310 }, {  53,6310 },
 {  54,6310 }, {  55,6310 }, {  56,6310 }, {  57,6310 }, {   0,  56 },
 {   0,18462 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,6310 }, {  66,6310 }, {  67,6310 }, {  68,6310 },
 {  69,6310 }, {  70,6310 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  97,6310 }, {  98,6310 }, {  99,6310 }, { 100,6310 }, { 101,6310 },
 { 102,6310 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {  36,6310 }, {   0,   0 }, {  97,6310 }, {  98,6310 },
 {  99,6310 }, { 100,6310 }, { 101,6310 }, { 102,6310 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,6310 }, {  49,6310 },
 {  50,6310 }, {  51,6310 }, {  52,6310 }, {  53,6310 }, {  54,6310 },
 {  55,6310 }, {  56,6310 }, {  57,6310 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,6310 }, {  66,6310 }, {  67,6310 }, {  68,6310 }, {  69,6310 },
 {  70,6310 }, {  71,6310 }, {  72,6310 }, {  73,6310 }, {  74,6310 },
 {  75,6310 }, {  76,6310 }, {  77,6310 }, {  78,6310 }, {  79,6310 },
 {  80,6310 }, {  81,6310 }, {  82,6310 }, {  83,6310 }, {  84,6310 },

 {  85,6310 }, {  86,6310 }, {  87,6310 }, {  88,6310 }, {  89,6310 },
 {  90,6310 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,6310 }, {   0,   0 }, {  97,6310 }, {  98,6310 }, {  99,6310 },
 { 100,6310 }, { 101,6310 }, { 102,6310 }, { 103,6310 }, { 104,6310 },
 { 105,6310 }, { 106,6310 }, { 107,6310 }, { 108,6310 }, { 109,6310 },
 { 110,6310 }, { 111,6310 }, { 112,6310 }, { 113,6310 }, { 114,6310 },
 { 115,6310 }, { 116,6310 }, { 117,6310 }, { 118,6310 }, { 119,6310 },
 { 120,6310 }, { 121,6310 }, { 122,6310 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,6310 }, { 129,6310 },
 { 130,6310 }, { 131,6310 }, { 132,6310 }, { 133,6310 }, { 134,6310 },

 { 135,6310 }, { 136,6310 }, { 137,6310 }, { 138,6310 }, { 139,6310 },
 { 140,6310 }, { 141,6310 }, { 142,6310 }, { 143,6310 }, { 144,6310 },
 { 145,6310 }, { 146,6310 }, { 147,6310 }, { 148,6310 }, { 149,6310 },
 { 150,6310 }, { 151,6310 }, { 152,6310 }, { 153,6310 }, { 154,6310 },
 { 155,6310 }, { 156,6310 }, { 157,6310 }, { 158,6310 }, { 159,6310 },
 { 160,6310 }, { 161,6310 }, { 162,6310 }, { 163,6310 }, { 164,6310 },
 { 165,6310 }, { 166,6310 }, { 167,6310 }, { 168,6310 }, { 169,6310 },
 { 170,6310 }, { 171,6310 }, { 172,6310 }, { 173,6310 }, { 174,6310 },
 { 175,6310 }, { 176,6310 }, { 177,6310 }, { 178,6310 }, { 179,6310 },
 { 180,6310 }, { 181,6310 }, { 182,6310 }, { 183,6310 }, { 184,6310 },

 { 185,6310 }, { 186,6310 }, { 187,6310 }, { 188,6310 }, { 189,6310 },
 { 190,6310 }, { 191,6310 }, { 192,6310 }, { 193,6310 }, { 194,6310 },
 { 195,6310 }, { 196,6310 }, { 197,6310 }, { 198,6310 }, { 199,6310 },
 { 200,6310 }, { 201,6310 }, { 202,6310 }, { 203,6310 }, { 204,6310 },
 { 205,6310 }, { 206,6310 }, { 207,6310 }, { 208,6310 }, { 209,6310 },
 { 210,6310 }, { 211,6310 }, { 212,6310 }, { 213,6310 }, { 214,6310 },
 { 215,6310 }, { 216,6310 }, { 217,6310 }, { 218,6310 }, { 219,6310 },
 { 220,6310 }, { 221,6310 }, { 222,6310 }, { 223,6310 }, { 224,6310 },
 { 225,6310 }, { 226,6310 }, { 227,6310 }, { 228,6310 }, { 229,6310 },
 { 230,6310 }, { 231,6310 }, { 232,6310 }, { 233,6310 }, { 234,6310 },

 { 235,6310 }, { 236,6310 }, { 237,6310 }, { 238,6310 }, { 239,6310 },
 { 240,6310 }, { 241,6310 }, { 242,6310 }, { 243,6310 }, { 244,6310 },
 { 245,6310 }, { 246,6310 }, { 247,6310 }, { 248,6310 }, { 249,6310 },
 { 250,6310 }, { 251,6310 }, { 252,6310 }, { 253,6310 }, { 254,6310 },
 { 255,6310 }, {   0,  33 }, {   0,18205 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,-12404 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },
 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 },
 {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 },
 {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 },

 {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 },
 {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 },
 {  88,   0 }, {  89,   0 }, {  90,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,   0 }, {   0,   0 }, {  97,   0 },
 {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 },
 { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 },
 { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 },
 { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 },
 { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 },
 { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 },
 { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 },
 { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 },
 { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 },
 { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 },
 { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 },
 { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 },
 { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 },
 { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 },

 { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 },
 { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 },
 { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 },
 { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 },
 { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 },
 { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 },
 { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 },
 { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 },
 { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 },
 { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 },

 { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 },
 { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 },
 { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 },
 { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 },
 { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 },
 { 253,   0 }, { 254,   0 }, { 255,   0 }, {   0,   1 }, {   0,17948 },
 {   1,   0 }, {   2,   0 }, {   3,   0 }, {   4,   0 }, {   5,   0 },
 {   6,   0 }, {   7,   0 }, {   8,   0 }, {   9,   0 }, {   0,   0 },
 {  11,   0 }, {  12,   0 }, {   0,   0 }, {  14,   0 }, {  15,   0 },
 {  16,   0 }, {  17,   0 }, {  18,   0 }, {  19,   0 }, {  20,   0 },

 {  21,   0 }, {  22,   0 }, {  23,   0 }, {  24,   0 }, {  25,   0 },
 {  26,   0 }, {  27,   0 }, {  28,   0 }, {  29,   0 }, {  30,   0 },
 {  31,   0 }, {  32,   0 }, {  33,   0 }, {  34,   0 }, {  35,   0 },
 {  36,   0 }, {  37,   0 }, {  38,   0 }, {  39,   0 }, {  40,   0 },
 {  41,   0 }, {  42,   0 }, {  43,   0 }, {  44,   0 }, {  45,   0 },
 {  46,   0 }, {  47,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 },
 {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 },
 {  56,   0 }, {  57,   0 }, {  58,   0 }, {  59,   0 }, {  60,   0 },
 {  61,   0 }, {  62,   0 }, {  63,   0 }, {  64,   0 }, {  65,   0 },
 {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 },

 {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 },
 {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 },
 {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 },
 {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 },
 {  91,   0 }, {  92,   0 }, {  93,   0 }, {  94,   0 }, {  95,   0 },
 {  96,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 },
 { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 },
 { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 },
 { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 },
 { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 },

 { 121,   0 }, { 122,   0 }, { 123,   0 }, { 124,   0 }, { 125,   0 },
 { 126,   0 }, { 127,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 },
 { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 },
 { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 },
 { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 },
 { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 },
 { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 },
 { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 },
 { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 },
 { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 },

 { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 },
 { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 },
 { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 },
 { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 },
 { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 },
 { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 },
 { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 },
 { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 },
 { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 },
 { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 },

 { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 },
 { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 },
 { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 },
 { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 },
 { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 },
 { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 },
 { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 },
 { 256,   0 }, {   0,   1 }, {   0,17690 }, {   1,-258 }, {   2,-258 },
 {   3,-258 }, {   4,-258 }, {   5,-258 }, {   6,-258 }, {   7,-258 },
 {   8,-258 }, {   9,-258 }, {   0,   0 }, {  11,-258 }, {  12,-258 },

 {   0,   0 }, {  14,-258 }, {  15,-258 }, {  16,-258 }, {  17,-258 },
 {  18,-258 }, {  19,-258 }, {  20,-258 }, {  21,-258 }, {  22,-258 },
 {  23,-258 }, {  24,-258 }, {  25,-258 }, {  26,-258 }, {  27,-258 },
 {  28,-258 }, {  29,-258 }, {  30,-258 }, {  31,-258 }, {  32,-258 },
 {  33,   0 }, {  34,-258 }, {  35,   0 }, {  36,-258 }, {  37,   0 },
 {  38,   0 }, {  39,-258 }, {  40,-258 }, {  41,-258 }, {  42,   0 },
 {  43,   0 }, {  44,-258 }, {  45,   0 }, {  46,-258 }, {  47,   0 },
 {  48,-258 }, {  49,-258 }, {  50,-258 }, {  51,-258 }, {  52,-258 },
 {  53,-258 }, {  54,-258 }, {  55,-258 }, {  56,-258 }, {  57,-258 },
 {  58,-258 }, {  59,-258 }, {  60,   0 }, {  61,   0 }, {  62,   0 },

 {  63,   0 }, {  64,   0 }, {  65,-258 }, {  66,-258 }, {  67,-258 },
 {  68,-258 }, {  69,-258 }, {  70,-258 }, {  71,-258 }, {  72,-258 },
 {  73,-258 }, {  74,-258 }, {  75,-258 }, {  76,-258 }, {  77,-258 },
 {  78,-258 }, {  79,-258 }, {  80,-258 }, {  81,-258 }, {  82,-258 },
 {  83,-258 }, {  84,-258 }, {  85,-258 }, {  86,-258 }, {  87,-258 },
 {  88,-258 }, {  89,-258 }, {  90,-258 }, {  91,-258 }, {  92,-258 },
 {  93,-258 }, {  94,   0 }, {  95,-258 }, {  96,   0 }, {  97,-258 },
 {  98,-258 }, {  99,-258 }, { 100,-258 }, { 101,-258 }, { 102,-258 },
 { 103,-258 }, { 104,-258 }, { 105,-258 }, { 106,-258 }, { 107,-258 },
 { 108,-258 }, { 109,-258 }, { 110,-258 }, { 111,-258 }, { 112,-258 },

 { 113,-258 }, { 114,-258 }, { 115,-258 }, { 116,-258 }, { 117,-258 },
 { 118,-258 }, { 119,-258 }, { 120,-258 }, { 121,-258 }, { 122,-258 },
 { 123,-258 }, { 124,   0 }, { 125,-258 }, { 126,   0 }, { 127,-258 },
 { 128,-258 }, { 129,-258 }, { 130,-258 }, { 131,-258 }, { 132,-258 },
 { 133,-258 }, { 134,-258 }, { 135,-258 }, { 136,-258 }, { 137,-258 },
 { 138,-258 }, { 139,-258 }, { 140,-258 }, { 141,-258 }, { 142,-258 },
 { 143,-258 }, { 144,-258 }, { 145,-258 }, { 146,-258 }, { 147,-258 },
 { 148,-258 }, { 149,-258 }, { 150,-258 }, { 151,-258 }, { 152,-258 },
 { 153,-258 }, { 154,-258 }, { 155,-258 }, { 156,-258 }, { 157,-258 },
 { 158,-258 }, { 159,-258 }, { 160,-258 }, { 161,-258 }, { 162,-258 },

 { 163,-258 }, { 164,-258 }, { 165,-258 }, { 166,-258 }, { 167,-258 },
 { 168,-258 }, { 169,-258 }, { 170,-258 }, { 171,-258 }, { 172,-258 },
 { 173,-258 }, { 174,-258 }, { 175,-258 }, { 176,-258 }, { 177,-258 },
 { 178,-258 }, { 179,-258 }, { 180,-258 }, { 181,-258 }, { 182,-258 },
 { 183,-258 }, { 184,-258 }, { 185,-258 }, { 186,-258 }, { 187,-258 },
 { 188,-258 }, { 189,-258 }, { 190,-258 }, { 191,-258 }, { 192,-258 },
 { 193,-258 }, { 194,-258 }, { 195,-258 }, { 196,-258 }, { 197,-258 },
 { 198,-258 }, { 199,-258 }, { 200,-258 }, { 201,-258 }, { 202,-258 },
 { 203,-258 }, { 204,-258 }, { 205,-258 }, { 206,-258 }, { 207,-258 },
 { 208,-258 }, { 209,-258 }, { 210,-258 }, { 211,-258 }, { 212,-258 },

 { 213,-258 }, { 214,-258 }, { 215,-258 }, { 216,-258 }, { 217,-258 },
 { 218,-258 }, { 219,-258 }, { 220,-258 }, { 221,-258 }, { 222,-258 },
 { 223,-258 }, { 224,-258 }, { 225,-258 }, { 226,-258 }, { 227,-258 },
 { 228,-258 }, { 229,-258 }, { 230,-258 }, { 231,-258 }, { 232,-258 },
 { 233,-258 }, { 234,-258 }, { 235,-258 }, { 236,-258 }, { 237,-258 },
 { 238,-258 }, { 239,-258 }, { 240,-258 }, { 241,-258 }, { 242,-258 },
 { 243,-258 }, { 244,-258 }, { 245,-258 }, { 246,-258 }, { 247,-258 },
 { 248,-258 }, { 249,-258 }, { 250,-258 }, { 251,-258 }, { 252,-258 },
 { 253,-258 }, { 254,-258 }, { 255,-258 }, { 256,-258 }, {   0,  64 },
 {   0,17432 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,   0 }, {  49,   0 },
 {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 },

 {  55,   0 }, {  56,   0 }, {  57,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65, 257 }, {  66, 257 }, {  67, 257 }, {  68, 257 }, {  69, 514 },
 {  70, 257 }, {  71, 257 }, {  72, 257 }, {  73, 257 }, {  74, 257 },
 {  75, 257 }, {  76, 257 }, {  77, 257 }, {  78, 257 }, {  79, 257 },
 {  80, 257 }, {  81, 257 }, {  82, 257 }, {  83, 257 }, {  84, 257 },
 {  85, 257 }, {  86, 257 }, {  87, 257 }, {  88, 257 }, {  89, 257 },
 {  90, 257 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95, 771 }, {   0,   0 }, {  97, 257 }, {  98, 257 }, {  99, 257 },
 { 100, 257 }, { 101, 514 }, { 102, 257 }, { 103, 257 }, { 104, 257 },

 { 105, 257 }, { 106, 257 }, { 107, 257 }, { 108, 257 }, { 109, 257 },
 { 110, 257 }, { 111, 257 }, { 112, 257 }, { 113, 257 }, { 114, 257 },
 { 115, 257 }, { 116, 257 }, { 117, 257 }, { 118, 257 }, { 119, 257 },
 { 120, 257 }, { 121, 257 }, { 122, 257 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128, 257 }, { 129, 257 },
 { 130, 257 }, { 131, 257 }, { 132, 257 }, { 133, 257 }, { 134, 257 },
 { 135, 257 }, { 136, 257 }, { 137, 257 }, { 138, 257 }, { 139, 257 },
 { 140, 257 }, { 141, 257 }, { 142, 257 }, { 143, 257 }, { 144, 257 },
 { 145, 257 }, { 146, 257 }, { 147, 257 }, { 148, 257 }, { 149, 257 },
 { 150, 257 }, { 151, 257 }, { 152, 257 }, { 153, 257 }, { 154, 257 },

 { 155, 257 }, { 156, 257 }, { 157, 257 }, { 158, 257 }, { 159, 257 },
 { 160, 257 }, { 161, 257 }, { 162, 257 }, { 163, 257 }, { 164, 257 },
 { 165, 257 }, { 166, 257 }, { 167, 257 }, { 168, 257 }, { 169, 257 },
 { 170, 257 }, { 171, 257 }, { 172, 257 }, { 173, 257 }, { 174, 257 },
 { 175, 257 }, { 176, 257 }, { 177, 257 }, { 178, 257 }, { 179, 257 },
 { 180, 257 }, { 181, 257 }, { 182, 257 }, { 183, 257 }, { 184, 257 },
 { 185, 257 }, { 186, 257 }, { 187, 257 }, { 188, 257 }, { 189, 257 },
 { 190, 257 }, { 191, 257 }, { 192, 257 }, { 193, 257 }, { 194, 257 },
 { 195, 257 }, { 196, 257 }, { 197, 257 }, { 198, 257 }, { 199, 257 },
 { 200, 257 }, { 201, 257 }, { 202, 257 }, { 203, 257 }, { 204, 257 },

 { 205, 257 }, { 206, 257 }, { 207, 257 }, { 208, 257 }, { 209, 257 },
 { 210, 257 }, { 211, 257 }, { 212, 257 }, { 213, 257 }, { 214, 257 },
 { 215, 257 }, { 216, 257 }, { 217, 257 }, { 218, 257 }, { 219, 257 },
 { 220, 257 }, { 221, 257 }, { 222, 257 }, { 223, 257 }, { 224, 257 },
 { 225, 257 }, { 226, 257 }, { 227, 257 }, { 228, 257 }, { 229, 257 },
 { 230, 257 }, { 231, 257 }, { 232, 257 }, { 233, 257 }, { 234, 257 },
 { 235, 257 }, { 236, 257 }, { 237, 257 }, { 238, 257 }, { 239, 257 },
 { 240, 257 }, { 241, 257 }, { 242, 257 }, { 243, 257 }, { 244, 257 },
 { 245, 257 }, { 246, 257 }, { 247, 257 }, { 248, 257 }, { 249, 257 },
 { 250, 257 }, { 251, 257 }, { 252, 257 }, { 253, 257 }, { 254, 257 },

 { 255, 257 }, {   0,  69 }, {   0,17175 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,5280 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {  48,5280 }, {  49,5280 }, {  50,5280 }, {  51,5280 }, {  52,5280 },
 {  53,5280 }, {  54,5280 }, {  55,5280 }, {  56,5280 }, {  57,5280 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,5280 }, {  66,5280 }, {  67,5280 },
 {  68,5280 }, {  69,5280 }, {  70,5280 }, {  71,5280 }, {  72,5280 },
 {  73,5280 }, {  74,5280 }, {  75,5280 }, {  76,5280 }, {  77,5280 },
 {  78,5280 }, {  79,5280 }, {  80,5280 }, {  81,5280 }, {  82,5280 },
 {  83,5280 }, {  84,5280 }, {  85,5280 }, {  86,5280 }, {  87,5280 },
 {  88,5280 }, {  89,5280 }, {  90,5280 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,5280 }, {   0,   0 }, {  97,5280 },

 {  98,5280 }, {  99,5280 }, { 100,5280 }, { 101,5280 }, { 102,5280 },
 { 103,5280 }, { 104,5280 }, { 105,5280 }, { 106,5280 }, { 107,5280 },
 { 108,5280 }, { 109,5280 }, { 110,5280 }, { 111,5280 }, { 112,5280 },
 { 113,5280 }, { 114,5280 }, { 115,5280 }, { 116,5280 }, { 117,5280 },
 { 118,5280 }, { 119,5280 }, { 120,5280 }, { 121,5280 }, { 122,5280 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,5280 }, { 129,5280 }, { 130,5280 }, { 131,5280 }, { 132,5280 },
 { 133,5280 }, { 134,5280 }, { 135,5280 }, { 136,5280 }, { 137,5280 },
 { 138,5280 }, { 139,5280 }, { 140,5280 }, { 141,5280 }, { 142,5280 },
 { 143,5280 }, { 144,5280 }, { 145,5280 }, { 146,5280 }, { 147,5280 },

 { 148,5280 }, { 149,5280 }, { 150,5280 }, { 151,5280 }, { 152,5280 },
 { 153,5280 }, { 154,5280 }, { 155,5280 }, { 156,5280 }, { 157,5280 },
 { 158,5280 }, { 159,5280 }, { 160,5280 }, { 161,5280 }, { 162,5280 },
 { 163,5280 }, { 164,5280 }, { 165,5280 }, { 166,5280 }, { 167,5280 },
 { 168,5280 }, { 169,5280 }, { 170,5280 }, { 171,5280 }, { 172,5280 },
 { 173,5280 }, { 174,5280 }, { 175,5280 }, { 176,5280 }, { 177,5280 },
 { 178,5280 }, { 179,5280 }, { 180,5280 }, { 181,5280 }, { 182,5280 },
 { 183,5280 }, { 184,5280 }, { 185,5280 }, { 186,5280 }, { 187,5280 },
 { 188,5280 }, { 189,5280 }, { 190,5280 }, { 191,5280 }, { 192,5280 },
 { 193,5280 }, { 194,5280 }, { 195,5280 }, { 196,5280 }, { 197,5280 },

 { 198,5280 }, { 199,5280 }, { 200,5280 }, { 201,5280 }, { 202,5280 },
 { 203,5280 }, { 204,5280 }, { 205,5280 }, { 206,5280 }, { 207,5280 },
 { 208,5280 }, { 209,5280 }, { 210,5280 }, { 211,5280 }, { 212,5280 },
 { 213,5280 }, { 214,5280 }, { 215,5280 }, { 216,5280 }, { 217,5280 },
 { 218,5280 }, { 219,5280 }, { 220,5280 }, { 221,5280 }, { 222,5280 },
 { 223,5280 }, { 224,5280 }, { 225,5280 }, { 226,5280 }, { 227,5280 },
 { 228,5280 }, { 229,5280 }, { 230,5280 }, { 231,5280 }, { 232,5280 },
 { 233,5280 }, { 234,5280 }, { 235,5280 }, { 236,5280 }, { 237,5280 },
 { 238,5280 }, { 239,5280 }, { 240,5280 }, { 241,5280 }, { 242,5280 },
 { 243,5280 }, { 244,5280 }, { 245,5280 }, { 246,5280 }, { 247,5280 },

 { 248,5280 }, { 249,5280 }, { 250,5280 }, { 251,5280 }, { 252,5280 },
 { 253,5280 }, { 254,5280 }, { 255,5280 }, {   0,  69 }, {   0,16918 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  36,5023 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {  43,1574 }, {   0,   0 }, {  45,1574 },
 {   0,   0 }, {   0,   0 }, {  48,5280 }, {  49,5280 }, {  50,5280 },
 {  51,5280 }, {  52,5280 }, {  53,5280 }, {  54,5280 }, {  55,5280 },
 {  56,5280 }, {  57,5280 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,5023 },
 {  66,5023 }, {  67,5023 }, {  68,5023 }, {  69,5023 }, {  70,5023 },
 {  71,5023 }, {  72,5023 }, {  73,5023 }, {  74,5023 }, {  75,5023 },
 {  76,5023 }, {  77,5023 }, {  78,5023 }, {  79,5023 }, {  80,5023 },
 {  81,5023 }, {  82,5023 }, {  83,5023 }, {  84,5023 }, {  85,5023 },
 {  86,5023 }, {  87,5023 }, {  88,5023 }, {  89,5023 }, {  90,5023 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,5023 },
 {   0,   0 }, {  97,5023 }, {  98,5023 }, {  99,5023 }, { 100,5023 },
 { 101,5023 }, { 102,5023 }, { 103,5023 }, { 104,5023 }, { 105,5023 },
 { 106,5023 }, { 107,5023 }, { 108,5023 }, { 109,5023 }, { 110,5023 },
 { 111,5023 }, { 112,5023 }, { 113,5023 }, { 114,5023 }, { 115,5023 },
 { 116,5023 }, { 117,5023 }, { 118,5023 }, { 119,5023 }, { 120,5023 },
 { 121,5023 }, { 122,5023 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 128,5023 }, { 129,5023 }, { 130,5023 },
 { 131,5023 }, { 132,5023 }, { 133,5023 }, { 134,5023 }, { 135,5023 },
 { 136,5023 }, { 137,5023 }, { 138,5023 }, { 139,5023 }, { 140,5023 },

 { 141,5023 }, { 142,5023 }, { 143,5023 }, { 144,5023 }, { 145,5023 },
 { 146,5023 }, { 147,5023 }, { 148,5023 }, { 149,5023 }, { 150,5023 },
 { 151,5023 }, { 152,5023 }, { 153,5023 }, { 154,5023 }, { 155,5023 },
 { 156,5023 }, { 157,5023 }, { 158,5023 }, { 159,5023 }, { 160,5023 },
 { 161,5023 }, { 162,5023 }, { 163,5023 }, { 164,5023 }, { 165,5023 },
 { 166,5023 }, { 167,5023 }, { 168,5023 }, { 169,5023 }, { 170,5023 },
 { 171,5023 }, { 172,5023 }, { 173,5023 }, { 174,5023 }, { 175,5023 },
 { 176,5023 }, { 177,5023 }, { 178,5023 }, { 179,5023 }, { 180,5023 },
 { 181,5023 }, { 182,5023 }, { 183,5023 }, { 184,5023 }, { 185,5023 },
 { 186,5023 }, { 187,5023 }, { 188,5023 }, { 189,5023 }, { 190,5023 },

 { 191,5023 }, { 192,5023 }, { 193,5023 }, { 194,5023 }, { 195,5023 },
 { 196,5023 }, { 197,5023 }, { 198,5023 }, { 199,5023 }, { 200,5023 },
 { 201,5023 }, { 202,5023 }, { 203,5023 }, { 204,5023 }, { 205,5023 },
 { 206,5023 }, { 207,5023 }, { 208,5023 }, { 209,5023 }, { 210,5023 },
 { 211,5023 }, { 212,5023 }, { 213,5023 }, { 214,5023 }, { 215,5023 },
 { 216,5023 }, { 217,5023 }, { 218,5023 }, { 219,5023 }, { 220,5023 },
 { 221,5023 }, { 222,5023 }, { 223,5023 }, { 224,5023 }, { 225,5023 },
 { 226,5023 }, { 227,5023 }, { 228,5023 }, { 229,5023 }, { 230,5023 },
 { 231,5023 }, { 232,5023 }, { 233,5023 }, { 234,5023 }, { 235,5023 },
 { 236,5023 }, { 237,5023 }, { 238,5023 }, { 239,5023 }, { 240,5023 },

 { 241,5023 }, { 242,5023 }, { 243,5023 }, { 244,5023 }, { 245,5023 },
 { 246,5023 }, { 247,5023 }, { 248,5023 }, { 249,5023 }, { 250,5023 },
 { 251,5023 }, { 252,5023 }, { 253,5023 }, { 254,5023 }, { 255,5023 },
 {   0,  69 }, {   0,16661 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {  36,4766 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,5280 },
 {  49,5280 }, {  50,5280 }, {  51,5280 }, {  52,5280 }, {  53,5280 },
 {  54,5280 }, {  55,5280 }, {  56,5280 }, {  57,5280 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,4766 }, {  66,4766 }, {  67,4766 }, {  68,4766 },
 {  69,4766 }, {  70,4766 }, {  71,4766 }, {  72,4766 }, {  73,4766 },
 {  74,4766 }, {  75,4766 }, {  76,4766 }, {  77,4766 }, {  78,4766 },
 {  79,4766 }, {  80,4766 }, {  81,4766 }, {  82,4766 }, {  83,4766 },

 {  84,4766 }, {  85,4766 }, {  86,4766 }, {  87,4766 }, {  88,4766 },
 {  89,4766 }, {  90,4766 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95,4766 }, {   0,   0 }, {  97,4766 }, {  98,4766 },
 {  99,4766 }, { 100,4766 }, { 101,4766 }, { 102,4766 }, { 103,4766 },
 { 104,4766 }, { 105,4766 }, { 106,4766 }, { 107,4766 }, { 108,4766 },
 { 109,4766 }, { 110,4766 }, { 111,4766 }, { 112,4766 }, { 113,4766 },
 { 114,4766 }, { 115,4766 }, { 116,4766 }, { 117,4766 }, { 118,4766 },
 { 119,4766 }, { 120,4766 }, { 121,4766 }, { 122,4766 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,4766 },
 { 129,4766 }, { 130,4766 }, { 131,4766 }, { 132,4766 }, { 133,4766 },

 { 134,4766 }, { 135,4766 }, { 136,4766 }, { 137,4766 }, { 138,4766 },
 { 139,4766 }, { 140,4766 }, { 141,4766 }, { 142,4766 }, { 143,4766 },
 { 144,4766 }, { 145,4766 }, { 146,4766 }, { 147,4766 }, { 148,4766 },
 { 149,4766 }, { 150,4766 }, { 151,4766 }, { 152,4766 }, { 153,4766 },
 { 154,4766 }, { 155,4766 }, { 156,4766 }, { 157,4766 }, { 158,4766 },
 { 159,4766 }, { 160,4766 }, { 161,4766 }, { 162,4766 }, { 163,4766 },
 { 164,4766 }, { 165,4766 }, { 166,4766 }, { 167,4766 }, { 168,4766 },
 { 169,4766 }, { 170,4766 }, { 171,4766 }, { 172,4766 }, { 173,4766 },
 { 174,4766 }, { 175,4766 }, { 176,4766 }, { 177,4766 }, { 178,4766 },
 { 179,4766 }, { 180,4766 }, { 181,4766 }, { 182,4766 }, { 183,4766 },

 { 184,4766 }, { 185,4766 }, { 186,4766 }, { 187,4766 }, { 188,4766 },
 { 189,4766 }, { 190,4766 }, { 191,4766 }, { 192,4766 }, { 193,4766 },
 { 194,4766 }, { 195,4766 }, { 196,4766 }, { 197,4766 }, { 198,4766 },
 { 199,4766 }, { 200,4766 }, { 201,4766 }, { 202,4766 }, { 203,4766 },
 { 204,4766 }, { 205,4766 }, { 206,4766 }, { 207,4766 }, { 208,4766 },
 { 209,4766 }, { 210,4766 }, { 211,4766 }, { 212,4766 }, { 213,4766 },
 { 214,4766 }, { 215,4766 }, { 216,4766 }, { 217,4766 }, { 218,4766 },
 { 219,4766 }, { 220,4766 }, { 221,4766 }, { 222,4766 }, { 223,4766 },
 { 224,4766 }, { 225,4766 }, { 226,4766 }, { 227,4766 }, { 228,4766 },
 { 229,4766 }, { 230,4766 }, { 231,4766 }, { 232,4766 }, { 233,4766 },

 { 234,4766 }, { 235,4766 }, { 236,4766 }, { 237,4766 }, { 238,4766 },
 { 239,4766 }, { 240,4766 }, { 241,4766 }, { 242,4766 }, { 243,4766 },
 { 244,4766 }, { 245,4766 }, { 246,4766 }, { 247,4766 }, { 248,4766 },
 { 249,4766 }, { 250,4766 }, { 251,4766 }, { 252,4766 }, { 253,4766 },
 { 254,4766 }, { 255,4766 }, {   0,   2 }, {   0,16404 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  64 },
 {   0,16372 }, {  33,   0 }, {   0,   0 }, {  35,   0 }, {   0,   0 },
 {  37,   0 }, {  38,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  42,   0 }, {  43,   0 }, {   0,   0 }, {  45,   0 }, {   0,   0 },
 {  47,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  60,   0 }, {  61,   0 },
 {  62,   0 }, {  63,   0 }, {  64,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,5248 }, {  49,5248 },
 {  50,5248 }, {  51,5248 }, {  52,5248 }, {  53,5248 }, {  54,5248 },
 {  55,5248 }, {  56,5248 }, {  57,5248 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  94,   0 }, {   0,   0 }, {  96,   0 },
 {  65,-803 }, {  66,-803 }, {  67,-803 }, {  68,-803 }, {  69,-546 },
 {  70,-803 }, {  71,-803 }, {  72,-803 }, {  73,-803 }, {  74,-803 },
 {  75,-803 }, {  76,-803 }, {  77,-803 }, {  78,-803 }, {  79,-803 },
 {  80,-803 }, {  81,-803 }, {  82,-803 }, {  83,-803 }, {  84,-803 },
 {  85,-803 }, {  86,-803 }, {  87,-803 }, {  88,-803 }, {  89,-803 },
 {  90,-803 }, {   0,   0 }, { 124,   0 }, {   0,   0 }, { 126,   0 },

 {  95,5505 }, {   0,   0 }, {  97,-803 }, {  98,-803 }, {  99,-803 },
 { 100,-803 }, { 101,-546 }, { 102,-803 }, { 103,-803 }, { 104,-803 },
 { 105,-803 }, { 106,-803 }, { 107,-803 }, { 108,-803 }, { 109,-803 },
 { 110,-803 }, { 111,-803 }, { 112,-803 }, { 113,-803 }, { 114,-803 },
 { 115,-803 }, { 116,-803 }, { 117,-803 }, { 118,-803 }, { 119,-803 },
 { 120,-803 }, { 121,-803 }, { 122,-803 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,-803 }, { 129,-803 },
 { 130,-803 }, { 131,-803 }, { 132,-803 }, { 133,-803 }, { 134,-803 },
 { 135,-803 }, { 136,-803 }, { 137,-803 }, { 138,-803 }, { 139,-803 },
 { 140,-803 }, { 141,-803 }, { 142,-803 }, { 143,-803 }, { 144,-803 },

 { 145,-803 }, { 146,-803 }, { 147,-803 }, { 148,-803 }, { 149,-803 },
 { 150,-803 }, { 151,-803 }, { 152,-803 }, { 153,-803 }, { 154,-803 },
 { 155,-803 }, { 156,-803 }, { 157,-803 }, { 158,-803 }, { 159,-803 },
 { 160,-803 }, { 161,-803 }, { 162,-803 }, { 163,-803 }, { 164,-803 },
 { 165,-803 }, { 166,-803 }, { 167,-803 }, { 168,-803 }, { 169,-803 },
 { 170,-803 }, { 171,-803 }, { 172,-803 }, { 173,-803 }, { 174,-803 },
 { 175,-803 }, { 176,-803 }, { 177,-803 }, { 178,-803 }, { 179,-803 },
 { 180,-803 }, { 181,-803 }, { 182,-803 }, { 183,-803 }, { 184,-803 },
 { 185,-803 }, { 186,-803 }, { 187,-803 }, { 188,-803 }, { 189,-803 },
 { 190,-803 }, { 191,-803 }, { 192,-803 }, { 193,-803 }, { 194,-803 },

 { 195,-803 }, { 196,-803 }, { 197,-803 }, { 198,-803 }, { 199,-803 },
 { 200,-803 }, { 201,-803 }, { 202,-803 }, { 203,-803 }, { 204,-803 },
 { 205,-803 }, { 206,-803 }, { 207,-803 }, { 208,-803 }, { 209,-803 },
 { 210,-803 }, { 211,-803 }, { 212,-803 }, { 213,-803 }, { 214,-803 },
 { 215,-803 }, { 216,-803 }, { 217,-803 }, { 218,-803 }, { 219,-803 },
 { 220,-803 }, { 221,-803 }, { 222,-803 }, { 223,-803 }, { 224,-803 },
 { 225,-803 }, { 226,-803 }, { 227,-803 }, { 228,-803 }, { 229,-803 },
 { 230,-803 }, { 231,-803 }, { 232,-803 }, { 233,-803 }, { 234,-803 },
 { 235,-803 }, { 236,-803 }, { 237,-803 }, { 238,-803 }, { 239,-803 },
 { 240,-803 }, { 241,-803 }, { 242,-803 }, { 243,-803 }, { 244,-803 },

 { 245,-803 }, { 246,-803 }, { 247,-803 }, { 248,-803 }, { 249,-803 },
 { 250,-803 }, { 251,-803 }, { 252,-803 }, { 253,-803 }, { 254,-803 },
 { 255,-803 }, {   0,  68 }, {   0,16115 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },
 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 },
 {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 },
 {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 },
 {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 },
 {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 },

 {  88,   0 }, {  89,   0 }, {  90,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,   0 }, {   0,   0 }, {  97,   0 },
 {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 },
 { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 },
 { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 },
 { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 },
 { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 },
 { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 },

 { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 },
 { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 },
 { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 },
 { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 },
 { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 },
 { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 },
 { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 },
 { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 },
 { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 },
 { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 },

 { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 },
 { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 },
 { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 },
 { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 },
 { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 },
 { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 },
 { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 },
 { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 },
 { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 },
 { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 },

 { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 },
 { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 },
 { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 },
 { 253,   0 }, { 254,   0 }, { 255,   0 }, {   0,  60 }, {   0,15858 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  36,-257 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,   0 }, {  49,   0 }, {  50,-257 },
 {  51,-257 }, {  52,-257 }, {  53,-257 }, {  54,-257 }, {  55,-257 },
 {  56,-257 }, {  57,-257 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,-257 },
 {  66,-257 }, {  67,-257 }, {  68,-257 }, {  69,-257 }, {  70,-257 },
 {  71,-257 }, {  72,-257 }, {  73,-257 }, {  74,-257 }, {  75,-257 },
 {  76,-257 }, {  77,-257 }, {  78,-257 }, {  79,-257 }, {  80,-257 },

 {  81,-257 }, {  82,-257 }, {  83,-257 }, {  84,-257 }, {  85,-257 },
 {  86,-257 }, {  87,-257 }, {  88,-257 }, {  89,-257 }, {  90,-257 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,5248 },
 {   0,   0 }, {  97,-257 }, {  98,-257 }, {  99,-257 }, { 100,-257 },
 { 101,-257 }, { 102,-257 }, { 103,-257 }, { 104,-257 }, { 105,-257 },
 { 106,-257 }, { 107,-257 }, { 108,-257 }, { 109,-257 }, { 110,-257 },
 { 111,-257 }, { 112,-257 }, { 113,-257 }, { 114,-257 }, { 115,-257 },
 { 116,-257 }, { 117,-257 }, { 118,-257 }, { 119,-257 }, { 120,-257 },
 { 121,-257 }, { 122,-257 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 128,-257 }, { 129,-257 }, { 130,-257 },

 { 131,-257 }, { 132,-257 }, { 133,-257 }, { 134,-257 }, { 135,-257 },
 { 136,-257 }, { 137,-257 }, { 138,-257 }, { 139,-257 }, { 140,-257 },
 { 141,-257 }, { 142,-257 }, { 143,-257 }, { 144,-257 }, { 145,-257 },
 { 146,-257 }, { 147,-257 }, { 148,-257 }, { 149,-257 }, { 150,-257 },
 { 151,-257 }, { 152,-257 }, { 153,-257 }, { 154,-257 }, { 155,-257 },
 { 156,-257 }, { 157,-257 }, { 158,-257 }, { 159,-257 }, { 160,-257 },
 { 161,-257 }, { 162,-257 }, { 163,-257 }, { 164,-257 }, { 165,-257 },
 { 166,-257 }, { 167,-257 }, { 168,-257 }, { 169,-257 }, { 170,-257 },
 { 171,-257 }, { 172,-257 }, { 173,-257 }, { 174,-257 }, { 175,-257 },
 { 176,-257 }, { 177,-257 }, { 178,-257 }, { 179,-257 }, { 180,-257 },

 { 181,-257 }, { 182,-257 }, { 183,-257 }, { 184,-257 }, { 185,-257 },
 { 186,-257 }, { 187,-257 }, { 188,-257 }, { 189,-257 }, { 190,-257 },
 { 191,-257 }, { 192,-257 }, { 193,-257 }, { 194,-257 }, { 195,-257 },
 { 196,-257 }, { 197,-257 }, { 198,-257 }, { 199,-257 }, { 200,-257 },
 { 201,-257 }, { 202,-257 }, { 203,-257 }, { 204,-257 }, { 205,-257 },
 { 206,-257 }, { 207,-257 }, { 208,-257 }, { 209,-257 }, { 210,-257 },
 { 211,-257 }, { 212,-257 }, { 213,-257 }, { 214,-257 }, { 215,-257 },
 { 216,-257 }, { 217,-257 }, { 218,-257 }, { 219,-257 }, { 220,-257 },
 { 221,-257 }, { 222,-257 }, { 223,-257 }, { 224,-257 }, { 225,-257 },
 { 226,-257 }, { 227,-257 }, { 228,-257 }, { 229,-257 }, { 230,-257 },

 { 231,-257 }, { 232,-257 }, { 233,-257 }, { 234,-257 }, { 235,-257 },
 { 236,-257 }, { 237,-257 }, { 238,-257 }, { 239,-257 }, { 240,-257 },
 { 241,-257 }, { 242,-257 }, { 243,-257 }, { 244,-257 }, { 245,-257 },
 { 246,-257 }, { 247,-257 }, { 248,-257 }, { 249,-257 }, { 250,-257 },
 { 251,-257 }, { 252,-257 }, { 253,-257 }, { 254,-257 }, { 255,-257 },
 {   0,  63 }, {   0,15601 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  36,-514 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,-257 },
 {  49,-257 }, {  50,-514 }, {  51,-514 }, {  52,-514 }, {  53,-514 },
 {  54,-514 }, {  55,-514 }, {  56,-514 }, {  57,-514 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,-514 }, {  66,-514 }, {  67,-514 }, {  68,-514 },
 {  69,-514 }, {  70,-514 }, {  71,-514 }, {  72,-514 }, {  73,-514 },

 {  74,-514 }, {  75,-514 }, {  76,-514 }, {  77,-514 }, {  78,-514 },
 {  79,-514 }, {  80,-514 }, {  81,-514 }, {  82,-514 }, {  83,-514 },
 {  84,-514 }, {  85,-514 }, {  86,-514 }, {  87,-514 }, {  88,-514 },
 {  89,-514 }, {  90,-514 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95,-514 }, {   0,   0 }, {  97,-514 }, {  98,-514 },
 {  99,-514 }, { 100,-514 }, { 101,-514 }, { 102,-514 }, { 103,-514 },
 { 104,-514 }, { 105,-514 }, { 106,-514 }, { 107,-514 }, { 108,-514 },
 { 109,-514 }, { 110,-514 }, { 111,-514 }, { 112,-514 }, { 113,-514 },
 { 114,-514 }, { 115,-514 }, { 116,-514 }, { 117,-514 }, { 118,-514 },
 { 119,-514 }, { 120,-514 }, { 121,-514 }, { 122,-514 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,-514 },
 { 129,-514 }, { 130,-514 }, { 131,-514 }, { 132,-514 }, { 133,-514 },
 { 134,-514 }, { 135,-514 }, { 136,-514 }, { 137,-514 }, { 138,-514 },
 { 139,-514 }, { 140,-514 }, { 141,-514 }, { 142,-514 }, { 143,-514 },
 { 144,-514 }, { 145,-514 }, { 146,-514 }, { 147,-514 }, { 148,-514 },
 { 149,-514 }, { 150,-514 }, { 151,-514 }, { 152,-514 }, { 153,-514 },
 { 154,-514 }, { 155,-514 }, { 156,-514 }, { 157,-514 }, { 158,-514 },
 { 159,-514 }, { 160,-514 }, { 161,-514 }, { 162,-514 }, { 163,-514 },
 { 164,-514 }, { 165,-514 }, { 166,-514 }, { 167,-514 }, { 168,-514 },
 { 169,-514 }, { 170,-514 }, { 171,-514 }, { 172,-514 }, { 173,-514 },

 { 174,-514 }, { 175,-514 }, { 176,-514 }, { 177,-514 }, { 178,-514 },
 { 179,-514 }, { 180,-514 }, { 181,-514 }, { 182,-514 }, { 183,-514 },
 { 184,-514 }, { 185,-514 }, { 186,-514 }, { 187,-514 }, { 188,-514 },
 { 189,-514 }, { 190,-514 }, { 191,-514 }, { 192,-514 }, { 193,-514 },
 { 194,-514 }, { 195,-514 }, { 196,-514 }, { 197,-514 }, { 198,-514 },
 { 199,-514 }, { 200,-514 }, { 201,-514 }, { 202,-514 }, { 203,-514 },
 { 204,-514 }, { 205,-514 }, { 206,-514 }, { 207,-514 }, { 208,-514 },
 { 209,-514 }, { 210,-514 }, { 211,-514 }, { 212,-514 }, { 213,-514 },
 { 214,-514 }, { 215,-514 }, { 216,-514 }, { 217,-514 }, { 218,-514 },
 { 219,-514 }, { 220,-514 }, { 221,-514 }, { 222,-514 }, { 223,-514 },

 { 224,-514 }, { 225,-514 }, { 226,-514 }, { 227,-514 }, { 228,-514 },
 { 229,-514 }, { 230,-514 }, { 231,-514 }, { 232,-514 }, { 233,-514 },
 { 234,-514 }, { 235,-514 }, { 236,-514 }, { 237,-514 }, { 238,-514 },
 { 239,-514 }, { 240,-514 }, { 241,-514 }, { 242,-514 }, { 243,-514 },
 { 244,-514 }, { 245,-514 }, { 246,-514 }, { 247,-514 }, { 248,-514 },
 { 249,-514 }, { 250,-514 }, { 251,-514 }, { 252,-514 }, { 253,-514 },
 { 254,-514 }, { 255,-514 }, {   0,  67 }, {   0,15344 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,  66 }, {   0,15334 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,-781 },
 {   0,   0 }, {  48,4991 }, {  49,4991 }, {  50,4991 }, {  51,4991 },
 {  52,4991 }, {  53,4991 }, {  54,4991 }, {  55,4991 }, {  56,4991 },
 {  57,4991 }, {  48,5238 }, {  49,5238 }, {  50,5238 }, {  51,5238 },
 {  52,5238 }, {  53,5238 }, {  54,5238 }, {  55,5238 }, {  56,5238 },

 {  57,5238 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,5495 }, {  66,5495 },
 {  67,5495 }, {  68,5495 }, {  69,5495 }, {  70,5495 }, {  71,5495 },
 {  72,5495 }, {  73,5495 }, {  74,5495 }, {  75,5495 }, {  76,5495 },
 {  77,5495 }, {  78,5495 }, {  79,5495 }, {  80,5495 }, {  81,5495 },
 {  82,5495 }, {  83,5495 }, {  84,5495 }, {  85,5495 }, {  86,5495 },
 {  87,5495 }, {  88,5495 }, {  89,5495 }, {  90,5495 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,5752 }, {   0,   0 },
 {  97,5495 }, {  98,5495 }, {  99,5495 }, { 100,5495 }, { 101,5495 },
 { 102,5495 }, { 103,5495 }, { 104,5495 }, { 105,5495 }, { 106,5495 },

 { 107,5495 }, { 108,5495 }, { 109,5495 }, { 110,5495 }, { 111,5495 },
 { 112,5495 }, { 113,5495 }, { 114,5495 }, { 115,5495 }, { 116,5495 },
 { 117,5495 }, { 118,5495 }, { 119,5495 }, { 120,5495 }, { 121,5495 },
 { 122,5495 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 128,5495 }, { 129,5495 }, { 130,5495 }, { 131,5495 },
 { 132,5495 }, { 133,5495 }, { 134,5495 }, { 135,5495 }, { 136,5495 },
 { 137,5495 }, { 138,5495 }, { 139,5495 }, { 140,5495 }, { 141,5495 },
 { 142,5495 }, { 143,5495 }, { 144,5495 }, { 145,5495 }, { 146,5495 },
 { 147,5495 }, { 148,5495 }, { 149,5495 }, { 150,5495 }, { 151,5495 },
 { 152,5495 }, { 153,5495 }, { 154,5495 }, { 155,5495 }, { 156,5495 },

 { 157,5495 }, { 158,5495 }, { 159,5495 }, { 160,5495 }, { 161,5495 },
 { 162,5495 }, { 163,5495 }, { 164,5495 }, { 165,5495 }, { 166,5495 },
 { 167,5495 }, { 168,5495 }, { 169,5495 }, { 170,5495 }, { 171,5495 },
 { 172,5495 }, { 173,5495 }, { 174,5495 }, { 175,5495 }, { 176,5495 },
 { 177,5495 }, { 178,5495 }, { 179,5495 }, { 180,5495 }, { 181,5495 },
 { 182,5495 }, { 183,5495 }, { 184,5495 }, { 185,5495 }, { 186,5495 },
 { 187,5495 }, { 188,5495 }, { 189,5495 }, { 190,5495 }, { 191,5495 },
 { 192,5495 }, { 193,5495 }, { 194,5495 }, { 195,5495 }, { 196,5495 },
 { 197,5495 }, { 198,5495 }, { 199,5495 }, { 200,5495 }, { 201,5495 },
 { 202,5495 }, { 203,5495 }, { 204,5495 }, { 205,5495 }, { 206,5495 },

 { 207,5495 }, { 208,5495 }, { 209,5495 }, { 210,5495 }, { 211,5495 },
 { 212,5495 }, { 213,5495 }, { 214,5495 }, { 215,5495 }, { 216,5495 },
 { 217,5495 }, { 218,5495 }, { 219,5495 }, { 220,5495 }, { 221,5495 },
 { 222,5495 }, { 223,5495 }, { 224,5495 }, { 225,5495 }, { 226,5495 },
 { 227,5495 }, { 228,5495 }, { 229,5495 }, { 230,5495 }, { 231,5495 },
 { 232,5495 }, { 233,5495 }, { 234,5495 }, { 235,5495 }, { 236,5495 },
 { 237,5495 }, { 238,5495 }, { 239,5495 }, { 240,5495 }, { 241,5495 },
 { 242,5495 }, { 243,5495 }, { 244,5495 }, { 245,5495 }, { 246,5495 },
 { 247,5495 }, { 248,5495 }, { 249,5495 }, { 250,5495 }, { 251,5495 },
 { 252,5495 }, { 253,5495 }, { 254,5495 }, { 255,5495 }, {   0,  59 },

 {   0,15077 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  36,-1038 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,   0 }, {  49,   0 },

 {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 },
 {  55,   0 }, {  56,-1038 }, {  57,-1038 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,-1038 }, {  66,-1038 }, {  67,-1038 }, {  68,-1038 }, {  69,-1038 },
 {  70,-1038 }, {  71,-1038 }, {  72,-1038 }, {  73,-1038 }, {  74,-1038 },
 {  75,-1038 }, {  76,-1038 }, {  77,-1038 }, {  78,-1038 }, {  79,-1038 },
 {  80,-1038 }, {  81,-1038 }, {  82,-1038 }, {  83,-1038 }, {  84,-1038 },
 {  85,-1038 }, {  86,-1038 }, {  87,-1038 }, {  88,-1038 }, {  89,-1038 },
 {  90,-1038 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,5752 }, {   0,   0 }, {  97,-1038 }, {  98,-1038 }, {  99,-1038 },

 { 100,-1038 }, { 101,-1038 }, { 102,-1038 }, { 103,-1038 }, { 104,-1038 },
 { 105,-1038 }, { 106,-1038 }, { 107,-1038 }, { 108,-1038 }, { 109,-1038 },
 { 110,-1038 }, { 111,-1038 }, { 112,-1038 }, { 113,-1038 }, { 114,-1038 },
 { 115,-1038 }, { 116,-1038 }, { 117,-1038 }, { 118,-1038 }, { 119,-1038 },
 { 120,-1038 }, { 121,-1038 }, { 122,-1038 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,-1038 }, { 129,-1038 },
 { 130,-1038 }, { 131,-1038 }, { 132,-1038 }, { 133,-1038 }, { 134,-1038 },
 { 135,-1038 }, { 136,-1038 }, { 137,-1038 }, { 138,-1038 }, { 139,-1038 },
 { 140,-1038 }, { 141,-1038 }, { 142,-1038 }, { 143,-1038 }, { 144,-1038 },
 { 145,-1038 }, { 146,-1038 }, { 147,-1038 }, { 148,-1038 }, { 149,-1038 },

 { 150,-1038 }, { 151,-1038 }, { 152,-1038 }, { 153,-1038 }, { 154,-1038 },
 { 155,-1038 }, { 156,-1038 }, { 157,-1038 }, { 158,-1038 }, { 159,-1038 },
 { 160,-1038 }, { 161,-1038 }, { 162,-1038 }, { 163,-1038 }, { 164,-1038 },
 { 165,-1038 }, { 166,-1038 }, { 167,-1038 }, { 168,-1038 }, { 169,-1038 },
 { 170,-1038 }, { 171,-1038 }, { 172,-1038 }, { 173,-1038 }, { 174,-1038 },
 { 175,-1038 }, { 176,-1038 }, { 177,-1038 }, { 178,-1038 }, { 179,-1038 },
 { 180,-1038 }, { 181,-1038 }, { 182,-1038 }, { 183,-1038 }, { 184,-1038 },
 { 185,-1038 }, { 186,-1038 }, { 187,-1038 }, { 188,-1038 }, { 189,-1038 },
 { 190,-1038 }, { 191,-1038 }, { 192,-1038 }, { 193,-1038 }, { 194,-1038 },
 { 195,-1038 }, { 196,-1038 }, { 197,-1038 }, { 198,-1038 }, { 199,-1038 },

 { 200,-1038 }, { 201,-1038 }, { 202,-1038 }, { 203,-1038 }, { 204,-1038 },
 { 205,-1038 }, { 206,-1038 }, { 207,-1038 }, { 208,-1038 }, { 209,-1038 },
 { 210,-1038 }, { 211,-1038 }, { 212,-1038 }, { 213,-1038 }, { 214,-1038 },
 { 215,-1038 }, { 216,-1038 }, { 217,-1038 }, { 218,-1038 }, { 219,-1038 },
 { 220,-1038 }, { 221,-1038 }, { 222,-1038 }, { 223,-1038 }, { 224,-1038 },
 { 225,-1038 }, { 226,-1038 }, { 227,-1038 }, { 228,-1038 }, { 229,-1038 },
 { 230,-1038 }, { 231,-1038 }, { 232,-1038 }, { 233,-1038 }, { 234,-1038 },
 { 235,-1038 }, { 236,-1038 }, { 237,-1038 }, { 238,-1038 }, { 239,-1038 },
 { 240,-1038 }, { 241,-1038 }, { 242,-1038 }, { 243,-1038 }, { 244,-1038 },
 { 245,-1038 }, { 246,-1038 }, { 247,-1038 }, { 248,-1038 }, { 249,-1038 },

 { 250,-1038 }, { 251,-1038 }, { 252,-1038 }, { 253,-1038 }, { 254,-1038 },
 { 255,-1038 }, {   0,  62 }, {   0,14820 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,-1295 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,-257 }, {  49,-257 }, {  50,-257 }, {  51,-257 }, {  52,-257 },
 {  53,-257 }, {  54,-257 }, {  55,-257 }, {  56,-1295 }, {  57,-1295 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,-1295 }, {  66,-1295 }, {  67,-1295 },
 {  68,-1295 }, {  69,-1295 }, {  70,-1295 }, {  71,-1295 }, {  72,-1295 },
 {  73,-1295 }, {  74,-1295 }, {  75,-1295 }, {  76,-1295 }, {  77,-1295 },
 {  78,-1295 }, {  79,-1295 }, {  80,-1295 }, {  81,-1295 }, {  82,-1295 },
 {  83,-1295 }, {  84,-1295 }, {  85,-1295 }, {  86,-1295 }, {  87,-1295 },
 {  88,-1295 }, {  89,-1295 }, {  90,-1295 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {  95,-1295 }, {   0,   0 }, {  97,-1295 },
 {  98,-1295 }, {  99,-1295 }, { 100,-1295 }, { 101,-1295 }, { 102,-1295 },
 { 103,-1295 }, { 104,-1295 }, { 105,-1295 }, { 106,-1295 }, { 107,-1295 },
 { 108,-1295 }, { 109,-1295 }, { 110,-1295 }, { 111,-1295 }, { 112,-1295 },
 { 113,-1295 }, { 114,-1295 }, { 115,-1295 }, { 116,-1295 }, { 117,-1295 },
 { 118,-1295 }, { 119,-1295 }, { 120,-1295 }, { 121,-1295 }, { 122,-1295 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,-1295 }, { 129,-1295 }, { 130,-1295 }, { 131,-1295 }, { 132,-1295 },
 { 133,-1295 }, { 134,-1295 }, { 135,-1295 }, { 136,-1295 }, { 137,-1295 },
 { 138,-1295 }, { 139,-1295 }, { 140,-1295 }, { 141,-1295 }, { 142,-1295 },

 { 143,-1295 }, { 144,-1295 }, { 145,-1295 }, { 146,-1295 }, { 147,-1295 },
 { 148,-1295 }, { 149,-1295 }, { 150,-1295 }, { 151,-1295 }, { 152,-1295 },
 { 153,-1295 }, { 154,-1295 }, { 155,-1295 }, { 156,-1295 }, { 157,-1295 },
 { 158,-1295 }, { 159,-1295 }, { 160,-1295 }, { 161,-1295 }, { 162,-1295 },
 { 163,-1295 }, { 164,-1295 }, { 165,-1295 }, { 166,-1295 }, { 167,-1295 },
 { 168,-1295 }, { 169,-1295 }, { 170,-1295 }, { 171,-1295 }, { 172,-1295 },
 { 173,-1295 }, { 174,-1295 }, { 175,-1295 }, { 176,-1295 }, { 177,-1295 },
 { 178,-1295 }, { 179,-1295 }, { 180,-1295 }, { 181,-1295 }, { 182,-1295 },
 { 183,-1295 }, { 184,-1295 }, { 185,-1295 }, { 186,-1295 }, { 187,-1295 },
 { 188,-1295 }, { 189,-1295 }, { 190,-1295 }, { 191,-1295 }, { 192,-1295 },

 { 193,-1295 }, { 194,-1295 }, { 195,-1295 }, { 196,-1295 }, { 197,-1295 },
 { 198,-1295 }, { 199,-1295 }, { 200,-1295 }, { 201,-1295 }, { 202,-1295 },
 { 203,-1295 }, { 204,-1295 }, { 205,-1295 }, { 206,-1295 }, { 207,-1295 },
 { 208,-1295 }, { 209,-1295 }, { 210,-1295 }, { 211,-1295 }, { 212,-1295 },
 { 213,-1295 }, { 214,-1295 }, { 215,-1295 }, { 216,-1295 }, { 217,-1295 },
 { 218,-1295 }, { 219,-1295 }, { 220,-1295 }, { 221,-1295 }, { 222,-1295 },
 { 223,-1295 }, { 224,-1295 }, { 225,-1295 }, { 226,-1295 }, { 227,-1295 },
 { 228,-1295 }, { 229,-1295 }, { 230,-1295 }, { 231,-1295 }, { 232,-1295 },
 { 233,-1295 }, { 234,-1295 }, { 235,-1295 }, { 236,-1295 }, { 237,-1295 },
 { 238,-1295 }, { 239,-1295 }, { 240,-1295 }, { 241,-1295 }, { 242,-1295 },

 { 243,-1295 }, { 244,-1295 }, { 245,-1295 }, { 246,-1295 }, { 247,-1295 },
 { 248,-1295 }, { 249,-1295 }, { 250,-1295 }, { 251,-1295 }, { 252,-1295 },
 { 253,-1295 }, { 254,-1295 }, { 255,-1295 }, {   0,  58 }, {   0,14563 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {  36,-1552 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 },
 {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 },
 {  56,   0 }, {  57,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,   0 },
 {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 },
 {  71,-1552 }, {  72,-1552 }, {  73,-1552 }, {  74,-1552 }, {  75,-1552 },
 {  76,-1552 }, {  77,-1552 }, {  78,-1552 }, {  79,-1552 }, {  80,-1552 },
 {  81,-1552 }, {  82,-1552 }, {  83,-1552 }, {  84,-1552 }, {  85,-1552 },

 {  86,-1552 }, {  87,-1552 }, {  88,-1552 }, {  89,-1552 }, {  90,-1552 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,5495 },
 {   0,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 },
 { 101,   0 }, { 102,   0 }, { 103,-1552 }, { 104,-1552 }, { 105,-1552 },
 { 106,-1552 }, { 107,-1552 }, { 108,-1552 }, { 109,-1552 }, { 110,-1552 },
 { 111,-1552 }, { 112,-1552 }, { 113,-1552 }, { 114,-1552 }, { 115,-1552 },
 { 116,-1552 }, { 117,-1552 }, { 118,-1552 }, { 119,-1552 }, { 120,-1552 },
 { 121,-1552 }, { 122,-1552 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 128,-1552 }, { 129,-1552 }, { 130,-1552 },
 { 131,-1552 }, { 132,-1552 }, { 133,-1552 }, { 134,-1552 }, { 135,-1552 },

 { 136,-1552 }, { 137,-1552 }, { 138,-1552 }, { 139,-1552 }, { 140,-1552 },
 { 141,-1552 }, { 142,-1552 }, { 143,-1552 }, { 144,-1552 }, { 145,-1552 },
 { 146,-1552 }, { 147,-1552 }, { 148,-1552 }, { 149,-1552 }, { 150,-1552 },
 { 151,-1552 }, { 152,-1552 }, { 153,-1552 }, { 154,-1552 }, { 155,-1552 },
 { 156,-1552 }, { 157,-1552 }, { 158,-1552 }, { 159,-1552 }, { 160,-1552 },
 { 161,-1552 }, { 162,-1552 }, { 163,-1552 }, { 164,-1552 }, { 165,-1552 },
 { 166,-1552 }, { 167,-1552 }, { 168,-1552 }, { 169,-1552 }, { 170,-1552 },
 { 171,-1552 }, { 172,-1552 }, { 173,-1552 }, { 174,-1552 }, { 175,-1552 },
 { 176,-1552 }, { 177,-1552 }, { 178,-1552 }, { 179,-1552 }, { 180,-1552 },
 { 181,-1552 }, { 182,-1552 }, { 183,-1552 }, { 184,-1552 }, { 185,-1552 },

 { 186,-1552 }, { 187,-1552 }, { 188,-1552 }, { 189,-1552 }, { 190,-1552 },
 { 191,-1552 }, { 192,-1552 }, { 193,-1552 }, { 194,-1552 }, { 195,-1552 },
 { 196,-1552 }, { 197,-1552 }, { 198,-1552 }, { 199,-1552 }, { 200,-1552 },
 { 201,-1552 }, { 202,-1552 }, { 203,-1552 }, { 204,-1552 }, { 205,-1552 },
 { 206,-1552 }, { 207,-1552 }, { 208,-1552 }, { 209,-1552 }, { 210,-1552 },
 { 211,-1552 }, { 212,-1552 }, { 213,-1552 }, { 214,-1552 }, { 215,-1552 },
 { 216,-1552 }, { 217,-1552 }, { 218,-1552 }, { 219,-1552 }, { 220,-1552 },
 { 221,-1552 }, { 222,-1552 }, { 223,-1552 }, { 224,-1552 }, { 225,-1552 },
 { 226,-1552 }, { 227,-1552 }, { 228,-1552 }, { 229,-1552 }, { 230,-1552 },
 { 231,-1552 }, { 232,-1552 }, { 233,-1552 }, { 234,-1552 }, { 235,-1552 },

 { 236,-1552 }, { 237,-1552 }, { 238,-1552 }, { 239,-1552 }, { 240,-1552 },
 { 241,-1552 }, { 242,-1552 }, { 243,-1552 }, { 244,-1552 }, { 245,-1552 },
 { 246,-1552 }, { 247,-1552 }, { 248,-1552 }, { 249,-1552 }, { 250,-1552 },
 { 251,-1552 }, { 252,-1552 }, { 253,-1552 }, { 254,-1552 }, { 255,-1552 },
 {   0,  61 }, {   0,14306 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  36,-1809 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,-257 },
 {  49,-257 }, {  50,-257 }, {  51,-257 }, {  52,-257 }, {  53,-257 },
 {  54,-257 }, {  55,-257 }, {  56,-257 }, {  57,-257 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,-257 }, {  66,-257 }, {  67,-257 }, {  68,-257 },
 {  69,-257 }, {  70,-257 }, {  71,-1809 }, {  72,-1809 }, {  73,-1809 },
 {  74,-1809 }, {  75,-1809 }, {  76,-1809 }, {  77,-1809 }, {  78,-1809 },

 {  79,-1809 }, {  80,-1809 }, {  81,-1809 }, {  82,-1809 }, {  83,-1809 },
 {  84,-1809 }, {  85,-1809 }, {  86,-1809 }, {  87,-1809 }, {  88,-1809 },
 {  89,-1809 }, {  90,-1809 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95,-1809 }, {   0,   0 }, {  97,-257 }, {  98,-257 },
 {  99,-257 }, { 100,-257 }, { 101,-257 }, { 102,-257 }, { 103,-1809 },
 { 104,-1809 }, { 105,-1809 }, { 106,-1809 }, { 107,-1809 }, { 108,-1809 },
 { 109,-1809 }, { 110,-1809 }, { 111,-1809 }, { 112,-1809 }, { 113,-1809 },
 { 114,-1809 }, { 115,-1809 }, { 116,-1809 }, { 117,-1809 }, { 118,-1809 },
 { 119,-1809 }, { 120,-1809 }, { 121,-1809 }, { 122,-1809 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,-1809 },

 { 129,-1809 }, { 130,-1809 }, { 131,-1809 }, { 132,-1809 }, { 133,-1809 },
 { 134,-1809 }, { 135,-1809 }, { 136,-1809 }, { 137,-1809 }, { 138,-1809 },
 { 139,-1809 }, { 140,-1809 }, { 141,-1809 }, { 142,-1809 }, { 143,-1809 },
 { 144,-1809 }, { 145,-1809 }, { 146,-1809 }, { 147,-1809 }, { 148,-1809 },
 { 149,-1809 }, { 150,-1809 }, { 151,-1809 }, { 152,-1809 }, { 153,-1809 },
 { 154,-1809 }, { 155,-1809 }, { 156,-1809 }, { 157,-1809 }, { 158,-1809 },
 { 159,-1809 }, { 160,-1809 }, { 161,-1809 }, { 162,-1809 }, { 163,-1809 },
 { 164,-1809 }, { 165,-1809 }, { 166,-1809 }, { 167,-1809 }, { 168,-1809 },
 { 169,-1809 }, { 170,-1809 }, { 171,-1809 }, { 172,-1809 }, { 173,-1809 },
 { 174,-1809 }, { 175,-1809 }, { 176,-1809 }, { 177,-1809 }, { 178,-1809 },

 { 179,-1809 }, { 180,-1809 }, { 181,-1809 }, { 182,-1809 }, { 183,-1809 },
 { 184,-1809 }, { 185,-1809 }, { 186,-1809 }, { 187,-1809 }, { 188,-1809 },
 { 189,-1809 }, { 190,-1809 }, { 191,-1809 }, { 192,-1809 }, { 193,-1809 },
 { 194,-1809 }, { 195,-1809 }, { 196,-1809 }, { 197,-1809 }, { 198,-1809 },
 { 199,-1809 }, { 200,-1809 }, { 201,-1809 }, { 202,-1809 }, { 203,-1809 },
 { 204,-1809 }, { 205,-1809 }, { 206,-1809 }, { 207,-1809 }, { 208,-1809 },
 { 209,-1809 }, { 210,-1809 }, { 211,-1809 }, { 212,-1809 }, { 213,-1809 },
 { 214,-1809 }, { 215,-1809 }, { 216,-1809 }, { 217,-1809 }, { 218,-1809 },
 { 219,-1809 }, { 220,-1809 }, { 221,-1809 }, { 222,-1809 }, { 223,-1809 },
 { 224,-1809 }, { 225,-1809 }, { 226,-1809 }, { 227,-1809 }, { 228,-1809 },

 { 229,-1809 }, { 230,-1809 }, { 231,-1809 }, { 232,-1809 }, { 233,-1809 },
 { 234,-1809 }, { 235,-1809 }, { 236,-1809 }, { 237,-1809 }, { 238,-1809 },
 { 239,-1809 }, { 240,-1809 }, { 241,-1809 }, { 242,-1809 }, { 243,-1809 },
 { 244,-1809 }, { 245,-1809 }, { 246,-1809 }, { 247,-1809 }, { 248,-1809 },
 { 249,-1809 }, { 250,-1809 }, { 251,-1809 }, { 252,-1809 }, { 253,-1809 },
 { 254,-1809 }, { 255,-1809 }, {   0,  57 }, {   0,14049 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,-2066 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  46,-9690 },
 {   0,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 },
 {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 },
 {  57,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,5238 }, {  66,5238 },
 {  67,5238 }, {  68,5238 }, {  69,5495 }, {  70,5238 }, {  71,5238 },

 {  72,5238 }, {  73,5238 }, {  74,5238 }, {  75,5238 }, {  76,5238 },
 {  77,5238 }, {  78,5238 }, {  79,5238 }, {  80,5238 }, {  81,5238 },
 {  82,5238 }, {  83,5238 }, {  84,5238 }, {  85,5238 }, {  86,5238 },
 {  87,5238 }, {  88,5238 }, {  89,5238 }, {  90,5238 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,5752 }, {   0,   0 },
 {  97,5238 }, {  98,5238 }, {  99,5238 }, { 100,5238 }, { 101,5495 },
 { 102,5238 }, { 103,5238 }, { 104,5238 }, { 105,5238 }, { 106,5238 },
 { 107,5238 }, { 108,5238 }, { 109,5238 }, { 110,5238 }, { 111,5238 },
 { 112,5238 }, { 113,5238 }, { 114,5238 }, { 115,5238 }, { 116,5238 },
 { 117,5238 }, { 118,5238 }, { 119,5238 }, { 120,5238 }, { 121,5238 },

 { 122,5238 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 128,5238 }, { 129,5238 }, { 130,5238 }, { 131,5238 },
 { 132,5238 }, { 133,5238 }, { 134,5238 }, { 135,5238 }, { 136,5238 },
 { 137,5238 }, { 138,5238 }, { 139,5238 }, { 140,5238 }, { 141,5238 },
 { 142,5238 }, { 143,5238 }, { 144,5238 }, { 145,5238 }, { 146,5238 },
 { 147,5238 }, { 148,5238 }, { 149,5238 }, { 150,5238 }, { 151,5238 },
 { 152,5238 }, { 153,5238 }, { 154,5238 }, { 155,5238 }, { 156,5238 },
 { 157,5238 }, { 158,5238 }, { 159,5238 }, { 160,5238 }, { 161,5238 },
 { 162,5238 }, { 163,5238 }, { 164,5238 }, { 165,5238 }, { 166,5238 },
 { 167,5238 }, { 168,5238 }, { 169,5238 }, { 170,5238 }, { 171,5238 },

 { 172,5238 }, { 173,5238 }, { 174,5238 }, { 175,5238 }, { 176,5238 },
 { 177,5238 }, { 178,5238 }, { 179,5238 }, { 180,5238 }, { 181,5238 },
 { 182,5238 }, { 183,5238 }, { 184,5238 }, { 185,5238 }, { 186,5238 },
 { 187,5238 }, { 188,5238 }, { 189,5238 }, { 190,5238 }, { 191,5238 },
 { 192,5238 }, { 193,5238 }, { 194,5238 }, { 195,5238 }, { 196,5238 },
 { 197,5238 }, { 198,5238 }, { 199,5238 }, { 200,5238 }, { 201,5238 },
 { 202,5238 }, { 203,5238 }, { 204,5238 }, { 205,5238 }, { 206,5238 },
 { 207,5238 }, { 208,5238 }, { 209,5238 }, { 210,5238 }, { 211,5238 },
 { 212,5238 }, { 213,5238 }, { 214,5238 }, { 215,5238 }, { 216,5238 },
 { 217,5238 }, { 218,5238 }, { 219,5238 }, { 220,5238 }, { 221,5238 },

 { 222,5238 }, { 223,5238 }, { 224,5238 }, { 225,5238 }, { 226,5238 },
 { 227,5238 }, { 228,5238 }, { 229,5238 }, { 230,5238 }, { 231,5238 },
 { 232,5238 }, { 233,5238 }, { 234,5238 }, { 235,5238 }, { 236,5238 },
 { 237,5238 }, { 238,5238 }, { 239,5238 }, { 240,5238 }, { 241,5238 },
 { 242,5238 }, { 243,5238 }, { 244,5238 }, { 245,5238 }, { 246,5238 },
 { 247,5238 }, { 248,5238 }, { 249,5238 }, { 250,5238 }, { 251,5238 },
 { 252,5238 }, { 253,5238 }, { 254,5238 }, { 255,5238 }, {   0,   3 },
 {   0,13792 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  33,   0 }, {   0,   0 },
 {  35,   0 }, {   0,   0 }, {  37,   0 }, {  38,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  42,   0 }, {  43,   0 }, {   0,   0 },
 {  45,   0 }, {   0,   0 }, {  47,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  60,   0 }, {  61,   0 }, {  62,   0 }, {  63,   0 }, {  64,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,   0 },
 {   0,   0 }, {  96,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 124,   0 },
 {   0,   0 }, { 126,   0 }, {   0,  18 }, {   0,13664 }, {   1,5624 },
 {   2,5624 }, {   3,5624 }, {   4,5624 }, {   5,5624 }, {   6,5624 },
 {   7,5624 }, {   8,5624 }, {   9,5882 }, {  10,6140 }, {  11,5882 },
 {  12,5882 }, {  13,6140 }, {  14,5624 }, {  15,5624 }, {  16,5624 },
 {  17,5624 }, {  18,5624 }, {  19,5624 }, {  20,5624 }, {  21,5624 },
 {  22,5624 }, {  23,5624 }, {  24,5624 }, {  25,5624 }, {  26,5624 },
 {  27,5624 }, {  28,5624 }, {  29,5624 }, {  30,5624 }, {  31,5624 },
 {  32,5882 }, {  33,5624 }, {  34,5624 }, {  35,5624 }, {  36,5624 },

 {  37,5624 }, {  38,5624 }, {  39,5624 }, {  40,5624 }, {  41,5624 },
 {  42,5624 }, {  43,5624 }, {  44,5624 }, {  45,6187 }, {  46,5624 },
 {  47,5624 }, {  48,5624 }, {  49,5624 }, {  50,5624 }, {  51,5624 },
 {  52,5624 }, {  53,5624 }, {  54,5624 }, {  55,5624 }, {  56,5624 },
 {  57,5624 }, {  58,5624 }, {  59,5624 }, {  60,5624 }, {  61,5624 },
 {  62,5624 }, {  63,5624 }, {  64,5624 }, {  65,5624 }, {  66,5624 },
 {  67,5624 }, {  68,5624 }, {  69,5624 }, {  70,5624 }, {  71,5624 },
 {  72,5624 }, {  73,5624 }, {  74,5624 }, {  75,5624 }, {  76,5624 },
 {  77,5624 }, {  78,5624 }, {  79,5624 }, {  80,5624 }, {  81,5624 },
 {  82,5624 }, {  83,5624 }, {  84,5624 }, {  85,5624 }, {  86,5624 },

 {  87,5624 }, {  88,5624 }, {  89,5624 }, {  90,5624 }, {  91,5624 },
 {  92,5624 }, {  93,5624 }, {  94,5624 }, {  95,5624 }, {  96,5624 },
 {  97,5624 }, {  98,5624 }, {  99,5624 }, { 100,5624 }, { 101,5624 },
 { 102,5624 }, { 103,5624 }, { 104,5624 }, { 105,5624 }, { 106,5624 },
 { 107,5624 }, { 108,5624 }, { 109,5624 }, { 110,5624 }, { 111,5624 },
 { 112,5624 }, { 113,5624 }, { 114,5624 }, { 115,5624 }, { 116,5624 },
 { 117,5624 }, { 118,5624 }, { 119,5624 }, { 120,5624 }, { 121,5624 },
 { 122,5624 }, { 123,5624 }, { 124,5624 }, { 125,5624 }, { 126,5624 },
 { 127,5624 }, { 128,5624 }, { 129,5624 }, { 130,5624 }, { 131,5624 },
 { 132,5624 }, { 133,5624 }, { 134,5624 }, { 135,5624 }, { 136,5624 },

 { 137,5624 }, { 138,5624 }, { 139,5624 }, { 140,5624 }, { 141,5624 },
 { 142,5624 }, { 143,5624 }, { 144,5624 }, { 145,5624 }, { 146,5624 },
 { 147,5624 }, { 148,5624 }, { 149,5624 }, { 150,5624 }, { 151,5624 },
 { 152,5624 }, { 153,5624 }, { 154,5624 }, { 155,5624 }, { 156,5624 },
 { 157,5624 }, { 158,5624 }, { 159,5624 }, { 160,5624 }, { 161,5624 },
 { 162,5624 }, { 163,5624 }, { 164,5624 }, { 165,5624 }, { 166,5624 },
 { 167,5624 }, { 168,5624 }, { 169,5624 }, { 170,5624 }, { 171,5624 },
 { 172,5624 }, { 173,5624 }, { 174,5624 }, { 175,5624 }, { 176,5624 },
 { 177,5624 }, { 178,5624 }, { 179,5624 }, { 180,5624 }, { 181,5624 },
 { 182,5624 }, { 183,5624 }, { 184,5624 }, { 185,5624 }, { 186,5624 },

 { 187,5624 }, { 188,5624 }, { 189,5624 }, { 190,5624 }, { 191,5624 },
 { 192,5624 }, { 193,5624 }, { 194,5624 }, { 195,5624 }, { 196,5624 },
 { 197,5624 }, { 198,5624 }, { 199,5624 }, { 200,5624 }, { 201,5624 },
 { 202,5624 }, { 203,5624 }, { 204,5624 }, { 205,5624 }, { 206,5624 },
 { 207,5624 }, { 208,5624 }, { 209,5624 }, { 210,5624 }, { 211,5624 },
 { 212,5624 }, { 213,5624 }, { 214,5624 }, { 215,5624 }, { 216,5624 },
 { 217,5624 }, { 218,5624 }, { 219,5624 }, { 220,5624 }, { 221,5624 },
 { 222,5624 }, { 223,5624 }, { 224,5624 }, { 225,5624 }, { 226,5624 },
 { 227,5624 }, { 228,5624 }, { 229,5624 }, { 230,5624 }, { 231,5624 },
 { 232,5624 }, { 233,5624 }, { 234,5624 }, { 235,5624 }, { 236,5624 },

 { 237,5624 }, { 238,5624 }, { 239,5624 }, { 240,5624 }, { 241,5624 },
 { 242,5624 }, { 243,5624 }, { 244,5624 }, { 245,5624 }, { 246,5624 },
 { 247,5624 }, { 248,5624 }, { 249,5624 }, { 250,5624 }, { 251,5624 },
 { 252,5624 }, { 253,5624 }, { 254,5624 }, { 255,5624 }, { 256,5624 },
 {   0,  18 }, {   0,13406 }, {   1,   0 }, {   2,   0 }, {   3,   0 },
 {   4,   0 }, {   5,   0 }, {   6,   0 }, {   7,   0 }, {   8,   0 },
 {   9, 258 }, {  10,-6413 }, {  11, 258 }, {  12, 258 }, {  13,-6413 },
 {  14,   0 }, {  15,   0 }, {  16,   0 }, {  17,   0 }, {  18,   0 },
 {  19,   0 }, {  20,   0 }, {  21,   0 }, {  22,   0 }, {  23,   0 },
 {  24,   0 }, {  25,   0 }, {  26,   0 }, {  27,   0 }, {  28,   0 },

 {  29,   0 }, {  30,   0 }, {  31,   0 }, {  32, 258 }, {  33,   0 },
 {  34,   0 }, {  35,   0 }, {  36,   0 }, {  37,   0 }, {  38,   0 },
 {  39,   0 }, {  40,   0 }, {  41,   0 }, {  42,   0 }, {  43,   0 },
 {  44,   0 }, {  45, 516 }, {  46,   0 }, {  47,   0 }, {  48,   0 },
 {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 },
 {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 }, {  58,   0 },
 {  59,   0 }, {  60,   0 }, {  61,   0 }, {  62,   0 }, {  63,   0 },
 {  64,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 }, {  68,   0 },
 {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 }, {  73,   0 },
 {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 }, {  78,   0 },

 {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 }, {  83,   0 },
 {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 }, {  88,   0 },
 {  89,   0 }, {  90,   0 }, {  91,   0 }, {  92,   0 }, {  93,   0 },
 {  94,   0 }, {  95,   0 }, {  96,   0 }, {  97,   0 }, {  98,   0 },
 {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 }, { 103,   0 },
 { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 }, { 108,   0 },
 { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 }, { 113,   0 },
 { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 }, { 118,   0 },
 { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 }, { 123,   0 },
 { 124,   0 }, { 125,   0 }, { 126,   0 }, { 127,   0 }, { 128,   0 },

 { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 }, { 133,   0 },
 { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 }, { 138,   0 },
 { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 }, { 143,   0 },
 { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 }, { 148,   0 },
 { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 }, { 153,   0 },
 { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 }, { 158,   0 },
 { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 }, { 163,   0 },
 { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 }, { 168,   0 },
 { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 }, { 173,   0 },
 { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 }, { 178,   0 },

 { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 }, { 183,   0 },
 { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 }, { 188,   0 },
 { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 }, { 193,   0 },
 { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 }, { 198,   0 },
 { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 }, { 203,   0 },
 { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 }, { 208,   0 },
 { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 }, { 213,   0 },
 { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 }, { 218,   0 },
 { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 }, { 223,   0 },
 { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 }, { 228,   0 },

 { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 }, { 233,   0 },
 { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 }, { 238,   0 },
 { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 }, { 243,   0 },
 { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 }, { 248,   0 },
 { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 }, { 253,   0 },
 { 254,   0 }, { 255,   0 }, { 256,   0 }, {   0,  18 }, {   0,13148 },
 {   1,-258 }, {   2,-258 }, {   3,-258 }, {   4,-258 }, {   5,-258 },
 {   6,-258 }, {   7,-258 }, {   8,-258 }, {   9,   0 }, {  10,-6671 },
 {  11,   0 }, {  12,   0 }, {  13,-6671 }, {  14,-258 }, {  15,-258 },
 {  16,-258 }, {  17,-258 }, {  18,-258 }, {  19,-258 }, {  20,-258 },

 {  21,-258 }, {  22,-258 }, {  23,-258 }, {  24,-258 }, {  25,-258 },
 {  26,-258 }, {  27,-258 }, {  28,-258 }, {  29,-258 }, {  30,-258 },
 {  31,-258 }, {  32,   0 }, {  33,-258 }, {  34,-258 }, {  35,-258 },
 {  36,-258 }, {  37,-258 }, {  38,-258 }, {  39,-258 }, {  40,-258 },
 {  41,-258 }, {  42,-258 }, {  43,-258 }, {  44,-258 }, {  45, 258 },
 {  46,-258 }, {  47,-258 }, {  48,-258 }, {  49,-258 }, {  50,-258 },
 {  51,-258 }, {  52,-258 }, {  53,-258 }, {  54,-258 }, {  55,-258 },
 {  56,-258 }, {  57,-258 }, {  58,-258 }, {  59,-258 }, {  60,-258 },
 {  61,-258 }, {  62,-258 }, {  63,-258 }, {  64,-258 }, {  65,-258 },
 {  66,-258 }, {  67,-258 }, {  68,-258 }, {  69,-258 }, {  70,-258 },

 {  71,-258 }, {  72,-258 }, {  73,-258 }, {  74,-258 }, {  75,-258 },
 {  76,-258 }, {  77,-258 }, {  78,-258 }, {  79,-258 }, {  80,-258 },
 {  81,-258 }, {  82,-258 }, {  83,-258 }, {  84,-258 }, {  85,-258 },
 {  86,-258 }, {  87,-258 }, {  88,-258 }, {  89,-258 }, {  90,-258 },
 {  91,-258 }, {  92,-258 }, {  93,-258 }, {  94,-258 }, {  95,-258 },
 {  96,-258 }, {  97,-258 }, {  98,-258 }, {  99,-258 }, { 100,-258 },
 { 101,-258 }, { 102,-258 }, { 103,-258 }, { 104,-258 }, { 105,-258 },
 { 106,-258 }, { 107,-258 }, { 108,-258 }, { 109,-258 }, { 110,-258 },
 { 111,-258 }, { 112,-258 }, { 113,-258 }, { 114,-258 }, { 115,-258 },
 { 116,-258 }, { 117,-258 }, { 118,-258 }, { 119,-258 }, { 120,-258 },

 { 121,-258 }, { 122,-258 }, { 123,-258 }, { 124,-258 }, { 125,-258 },
 { 126,-258 }, { 127,-258 }, { 128,-258 }, { 129,-258 }, { 130,-258 },
 { 131,-258 }, { 132,-258 }, { 133,-258 }, { 134,-258 }, { 135,-258 },
 { 136,-258 }, { 137,-258 }, { 138,-258 }, { 139,-258 }, { 140,-258 },
 { 141,-258 }, { 142,-258 }, { 143,-258 }, { 144,-258 }, { 145,-258 },
 { 146,-258 }, { 147,-258 }, { 148,-258 }, { 149,-258 }, { 150,-258 },
 { 151,-258 }, { 152,-258 }, { 153,-258 }, { 154,-258 }, { 155,-258 },
 { 156,-258 }, { 157,-258 }, { 158,-258 }, { 159,-258 }, { 160,-258 },
 { 161,-258 }, { 162,-258 }, { 163,-258 }, { 164,-258 }, { 165,-258 },
 { 166,-258 }, { 167,-258 }, { 168,-258 }, { 169,-258 }, { 170,-258 },

 { 171,-258 }, { 172,-258 }, { 173,-258 }, { 174,-258 }, { 175,-258 },
 { 176,-258 }, { 177,-258 }, { 178,-258 }, { 179,-258 }, { 180,-258 },
 { 181,-258 }, { 182,-258 }, { 183,-258 }, { 184,-258 }, { 185,-258 },
 { 186,-258 }, { 187,-258 }, { 188,-258 }, { 189,-258 }, { 190,-258 },
 { 191,-258 }, { 192,-258 }, { 193,-258 }, { 194,-258 }, { 195,-258 },
 { 196,-258 }, { 197,-258 }, { 198,-258 }, { 199,-258 }, { 200,-258 },
 { 201,-258 }, { 202,-258 }, { 203,-258 }, { 204,-258 }, { 205,-258 },
 { 206,-258 }, { 207,-258 }, { 208,-258 }, { 209,-258 }, { 210,-258 },
 { 211,-258 }, { 212,-258 }, { 213,-258 }, { 214,-258 }, { 215,-258 },
 { 216,-258 }, { 217,-258 }, { 218,-258 }, { 219,-258 }, { 220,-258 },

 { 221,-258 }, { 222,-258 }, { 223,-258 }, { 224,-258 }, { 225,-258 },
 { 226,-258 }, { 227,-258 }, { 228,-258 }, { 229,-258 }, { 230,-258 },
 { 231,-258 }, { 232,-258 }, { 233,-258 }, { 234,-258 }, { 235,-258 },
 { 236,-258 }, { 237,-258 }, { 238,-258 }, { 239,-258 }, { 240,-258 },
 { 241,-258 }, { 242,-258 }, { 243,-258 }, { 244,-258 }, { 245,-258 },
 { 246,-258 }, { 247,-258 }, { 248,-258 }, { 249,-258 }, { 250,-258 },
 { 251,-258 }, { 252,-258 }, { 253,-258 }, { 254,-258 }, { 255,-258 },
 { 256,-258 }, {   0,  18 }, {   0,12890 }, {   1,-516 }, {   2,-516 },
 {   3,-516 }, {   4,-516 }, {   5,-516 }, {   6,-516 }, {   7,-516 },
 {   8,-516 }, {   9,-258 }, {  10,-6929 }, {  11,-258 }, {  12,-258 },

 {  13,-6929 }, {  14,-516 }, {  15,-516 }, {  16,-516 }, {  17,-516 },
 {  18,-516 }, {  19,-516 }, {  20,-516 }, {  21,-516 }, {  22,-516 },
 {  23,-516 }, {  24,-516 }, {  25,-516 }, {  26,-516 }, {  27,-516 },
 {  28,-516 }, {  29,-516 }, {  30,-516 }, {  31,-516 }, {  32,-258 },
 {  33,-516 }, {  34,-516 }, {  35,-516 }, {  36,-516 }, {  37,-516 },
 {  38,-516 }, {  39,-516 }, {  40,-516 }, {  41,-516 }, {  42,-516 },
 {  43,-516 }, {  44,-516 }, {  45,5671 }, {  46,-516 }, {  47,-516 },
 {  48,-516 }, {  49,-516 }, {  50,-516 }, {  51,-516 }, {  52,-516 },
 {  53,-516 }, {  54,-516 }, {  55,-516 }, {  56,-516 }, {  57,-516 },
 {  58,-516 }, {  59,-516 }, {  60,-516 }, {  61,-516 }, {  62,-516 },

 {  63,-516 }, {  64,-516 }, {  65,-516 }, {  66,-516 }, {  67,-516 },
 {  68,-516 }, {  69,-516 }, {  70,-516 }, {  71,-516 }, {  72,-516 },
 {  73,-516 }, {  74,-516 }, {  75,-516 }, {  76,-516 }, {  77,-516 },
 {  78,-516 }, {  79,-516 }, {  80,-516 }, {  81,-516 }, {  82,-516 },
 {  83,-516 }, {  84,-516 }, {  85,-516 }, {  86,-516 }, {  87,-516 },
 {  88,-516 }, {  89,-516 }, {  90,-516 }, {  91,-516 }, {  92,-516 },
 {  93,-516 }, {  94,-516 }, {  95,-516 }, {  96,-516 }, {  97,-516 },
 {  98,-516 }, {  99,-516 }, { 100,-516 }, { 101,-516 }, { 102,-516 },
 { 103,-516 }, { 104,-516 }, { 105,-516 }, { 106,-516 }, { 107,-516 },
 { 108,-516 }, { 109,-516 }, { 110,-516 }, { 111,-516 }, { 112,-516 },

 { 113,-516 }, { 114,-516 }, { 115,-516 }, { 116,-516 }, { 117,-516 },
 { 118,-516 }, { 119,-516 }, { 120,-516 }, { 121,-516 }, { 122,-516 },
 { 123,-516 }, { 124,-516 }, { 125,-516 }, { 126,-516 }, { 127,-516 },
 { 128,-516 }, { 129,-516 }, { 130,-516 }, { 131,-516 }, { 132,-516 },
 { 133,-516 }, { 134,-516 }, { 135,-516 }, { 136,-516 }, { 137,-516 },
 { 138,-516 }, { 139,-516 }, { 140,-516 }, { 141,-516 }, { 142,-516 },
 { 143,-516 }, { 144,-516 }, { 145,-516 }, { 146,-516 }, { 147,-516 },
 { 148,-516 }, { 149,-516 }, { 150,-516 }, { 151,-516 }, { 152,-516 },
 { 153,-516 }, { 154,-516 }, { 155,-516 }, { 156,-516 }, { 157,-516 },
 { 158,-516 }, { 159,-516 }, { 160,-516 }, { 161,-516 }, { 162,-516 },

 { 163,-516 }, { 164,-516 }, { 165,-516 }, { 166,-516 }, { 167,-516 },
 { 168,-516 }, { 169,-516 }, { 170,-516 }, { 171,-516 }, { 172,-516 },
 { 173,-516 }, { 174,-516 }, { 175,-516 }, { 176,-516 }, { 177,-516 },
 { 178,-516 }, { 179,-516 }, { 180,-516 }, { 181,-516 }, { 182,-516 },
 { 183,-516 }, { 184,-516 }, { 185,-516 }, { 186,-516 }, { 187,-516 },
 { 188,-516 }, { 189,-516 }, { 190,-516 }, { 191,-516 }, { 192,-516 },
 { 193,-516 }, { 194,-516 }, { 195,-516 }, { 196,-516 }, { 197,-516 },
 { 198,-516 }, { 199,-516 }, { 200,-516 }, { 201,-516 }, { 202,-516 },
 { 203,-516 }, { 204,-516 }, { 205,-516 }, { 206,-516 }, { 207,-516 },
 { 208,-516 }, { 209,-516 }, { 210,-516 }, { 211,-516 }, { 212,-516 },

 { 213,-516 }, { 214,-516 }, { 215,-516 }, { 216,-516 }, { 217,-516 },
 { 218,-516 }, { 219,-516 }, { 220,-516 }, { 221,-516 }, { 222,-516 },
 { 223,-516 }, { 224,-516 }, { 225,-516 }, { 226,-516 }, { 227,-516 },
 { 228,-516 }, { 229,-516 }, { 230,-516 }, { 231,-516 }, { 232,-516 },
 { 233,-516 }, { 234,-516 }, { 235,-516 }, { 236,-516 }, { 237,-516 },
 { 238,-516 }, { 239,-516 }, { 240,-516 }, { 241,-516 }, { 242,-516 },
 { 243,-516 }, { 244,-516 }, { 245,-516 }, { 246,-516 }, { 247,-516 },
 { 248,-516 }, { 249,-516 }, { 250,-516 }, { 251,-516 }, { 252,-516 },
 { 253,-516 }, { 254,-516 }, { 255,-516 }, { 256,-516 }, {   0,  29 },
 {   0,12632 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,  27 }, {   0,12624 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,  27 }, {   0,12601 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,-17661 }, {  49,-17661 },
 {  50,-17661 }, {  51,-17661 }, {  52,-17661 }, {  53,-17661 }, {  54,-17661 },

 {  55,-17661 }, {  48,5663 }, {  49,5663 }, {  50,5663 }, {  51,5663 },
 {  52,5663 }, {  53,5663 }, {  54,5663 }, {  55,5663 }, {  56,5663 },
 {  57,5663 }, {   0,   0 }, {   0,   0 }, {   0,  30 }, {   0,12563 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,5663 }, {  66,5663 },
 {  67,5663 }, {  68,5663 }, {  69,5663 }, {  70,5663 }, {  48,5663 },
 {  49,5663 }, {  50,5663 }, {  51,5663 }, {  52,5663 }, {  53,5663 },
 {  54,5663 }, {  55,5663 }, {  56,5663 }, {  57,5663 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,5663 }, {  66,5663 }, {  67,5663 }, {  68,5663 },
 {  69,5663 }, {  70,5663 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {  97,5663 }, {  98,5663 }, {  99,5663 }, { 100,5663 }, { 101,5663 },
 { 102,5663 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,-17708 }, {  49,-17708 }, {  50,-17708 },
 {  51,-17708 }, {  52,-17708 }, {  53,-17708 }, {  54,-17708 }, {  55,-17708 },
 {  56,-17708 }, {  57,-17708 }, {   0,   0 }, {  97,5663 }, {  98,5663 },
 {  99,5663 }, { 100,5663 }, { 101,5663 }, { 102,5663 }, {  65,-17708 },
 {  66,-17708 }, {  67,-17708 }, {  68,-17708 }, {  69,-17708 }, {  70,-17708 },
 {   0,  36 }, {   0,12491 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  97,-17708 }, {  98,-17708 }, {  99,-17708 }, { 100,-17708 },
 { 101,-17708 }, { 102,-17708 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  36,-17841 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,   0 },
 {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 },
 {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 }, {  68,   0 },
 {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 }, {  73,   0 },
 {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 }, {  78,   0 },
 {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 }, {  83,   0 },
 {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 }, {  88,   0 },
 {  89,   0 }, {  90,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95,   0 }, {   0,   0 }, {  97,   0 }, {  98,   0 },
 {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 }, { 103,   0 },
 { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 }, { 108,   0 },
 { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 }, { 113,   0 },

 { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 }, { 118,   0 },
 { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,   0 },
 { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 }, { 133,   0 },
 { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 }, { 138,   0 },
 { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 }, { 143,   0 },
 { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 }, { 148,   0 },
 { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 }, { 153,   0 },
 { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 }, { 158,   0 },
 { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 }, { 163,   0 },

 { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 }, { 168,   0 },
 { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 }, { 173,   0 },
 { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 }, { 178,   0 },
 { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 }, { 183,   0 },
 { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 }, { 188,   0 },
 { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 }, { 193,   0 },
 { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 }, { 198,   0 },
 { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 }, { 203,   0 },
 { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 }, { 208,   0 },
 { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 }, { 213,   0 },

 { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 }, { 218,   0 },
 { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 }, { 223,   0 },
 { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 }, { 228,   0 },
 { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 }, { 233,   0 },
 { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 }, { 238,   0 },
 { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 }, { 243,   0 },
 { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 }, { 248,   0 },
 { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 }, { 253,   0 },
 { 254,   0 }, { 255,   0 }, {   0,  27 }, {   0,12234 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,  27 }, {   0,12211 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,5334 }, {  49,5334 }, {  50,5334 }, {  51,5334 },
 {  52,5334 }, {  53,5334 }, {  54,5334 }, {  55,5334 }, {  56,5334 },

 {  57,5334 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,5334 }, {  66,5334 },
 {  67,5334 }, {  68,5334 }, {  69,5334 }, {  70,5334 }, {  48,5334 },
 {  49,5334 }, {  50,5334 }, {  51,5334 }, {  52,5334 }, {  53,5334 },
 {  54,5334 }, {  55,5334 }, {  56,5334 }, {  57,5334 }, {   0,  56 },
 {   0,12152 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,5334 }, {  66,5334 }, {  67,5334 }, {  68,5334 },
 {  69,5334 }, {  70,5334 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  97,5334 }, {  98,5334 }, {  99,5334 }, { 100,5334 }, { 101,5334 },
 { 102,5334 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  36,   0 }, {   0,   0 }, {  97,5334 }, {  98,5334 },
 {  99,5334 }, { 100,5334 }, { 101,5334 }, { 102,5334 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,   0 }, {  49,   0 },
 {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 },
 {  55,   0 }, {  56,   0 }, {  57,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,   0 }, {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 },
 {  70,   0 }, {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 },

 {  75,   0 }, {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 },
 {  80,   0 }, {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 },
 {  85,   0 }, {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 },
 {  90,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,   0 }, {   0,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 },
 { 100,   0 }, { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 },
 { 105,   0 }, { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 },
 { 110,   0 }, { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 },
 { 115,   0 }, { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 },
 { 120,   0 }, { 121,   0 }, { 122,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,   0 }, { 129,   0 },
 { 130,   0 }, { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 },
 { 135,   0 }, { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 },
 { 140,   0 }, { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 },
 { 145,   0 }, { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 },
 { 150,   0 }, { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 },
 { 155,   0 }, { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 },
 { 160,   0 }, { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 },
 { 165,   0 }, { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 },
 { 170,   0 }, { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 },

 { 175,   0 }, { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 },
 { 180,   0 }, { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 },
 { 185,   0 }, { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 },
 { 190,   0 }, { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 },
 { 195,   0 }, { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 },
 { 200,   0 }, { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 },
 { 205,   0 }, { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 },
 { 210,   0 }, { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 },
 { 215,   0 }, { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 },
 { 220,   0 }, { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 },

 { 225,   0 }, { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 },
 { 230,   0 }, { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 },
 { 235,   0 }, { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 },
 { 240,   0 }, { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 },
 { 245,   0 }, { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 },
 { 250,   0 }, { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 },
 { 255,   0 }, {   0,  69 }, {   0,11895 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },
 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 },

 {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 },
 {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 },
 {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 },
 {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 },
 {  88,   0 }, {  89,   0 }, {  90,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,   0 }, {   0,   0 }, {  97,   0 },
 {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 },
 { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 },
 { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 },
 { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 },

 { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 },
 { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 },
 { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 },
 { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 },
 { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 },
 { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 },
 { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 },
 { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 },

 { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 },
 { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 },
 { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 },
 { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 },
 { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 },
 { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 },
 { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 },
 { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 },
 { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 },
 { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 },

 { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 },
 { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 },
 { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 },
 { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 },
 { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 },
 { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 },
 { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 },
 { 253,   0 }, { 254,   0 }, { 255,   0 }, {   0,  66 }, {   0,11638 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  36,-257 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,4820 }, {  49,4820 }, {  50,4820 },
 {  51,4820 }, {  52,4820 }, {  53,4820 }, {  54,4820 }, {  55,4820 },
 {  56,4820 }, {  57,4820 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,5077 },
 {  66,5077 }, {  67,5077 }, {  68,5077 }, {  69,5077 }, {  70,5077 },
 {  71,5077 }, {  72,5077 }, {  73,5077 }, {  74,5077 }, {  75,5077 },
 {  76,5077 }, {  77,5077 }, {  78,5077 }, {  79,5077 }, {  80,5077 },
 {  81,5077 }, {  82,5077 }, {  83,5077 }, {  84,5077 }, {  85,5077 },
 {  86,5077 }, {  87,5077 }, {  88,5077 }, {  89,5077 }, {  90,5077 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,5334 },
 {   0,   0 }, {  97,5077 }, {  98,5077 }, {  99,5077 }, { 100,5077 },
 { 101,5077 }, { 102,5077 }, { 103,5077 }, { 104,5077 }, { 105,5077 },
 { 106,5077 }, { 107,5077 }, { 108,5077 }, { 109,5077 }, { 110,5077 },

 { 111,5077 }, { 112,5077 }, { 113,5077 }, { 114,5077 }, { 115,5077 },
 { 116,5077 }, { 117,5077 }, { 118,5077 }, { 119,5077 }, { 120,5077 },
 { 121,5077 }, { 122,5077 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 128,5077 }, { 129,5077 }, { 130,5077 },
 { 131,5077 }, { 132,5077 }, { 133,5077 }, { 134,5077 }, { 135,5077 },
 { 136,5077 }, { 137,5077 }, { 138,5077 }, { 139,5077 }, { 140,5077 },
 { 141,5077 }, { 142,5077 }, { 143,5077 }, { 144,5077 }, { 145,5077 },
 { 146,5077 }, { 147,5077 }, { 148,5077 }, { 149,5077 }, { 150,5077 },
 { 151,5077 }, { 152,5077 }, { 153,5077 }, { 154,5077 }, { 155,5077 },
 { 156,5077 }, { 157,5077 }, { 158,5077 }, { 159,5077 }, { 160,5077 },

 { 161,5077 }, { 162,5077 }, { 163,5077 }, { 164,5077 }, { 165,5077 },
 { 166,5077 }, { 167,5077 }, { 168,5077 }, { 169,5077 }, { 170,5077 },
 { 171,5077 }, { 172,5077 }, { 173,5077 }, { 174,5077 }, { 175,5077 },
 { 176,5077 }, { 177,5077 }, { 178,5077 }, { 179,5077 }, { 180,5077 },
 { 181,5077 }, { 182,5077 }, { 183,5077 }, { 184,5077 }, { 185,5077 },
 { 186,5077 }, { 187,5077 }, { 188,5077 }, { 189,5077 }, { 190,5077 },
 { 191,5077 }, { 192,5077 }, { 193,5077 }, { 194,5077 }, { 195,5077 },
 { 196,5077 }, { 197,5077 }, { 198,5077 }, { 199,5077 }, { 200,5077 },
 { 201,5077 }, { 202,5077 }, { 203,5077 }, { 204,5077 }, { 205,5077 },
 { 206,5077 }, { 207,5077 }, { 208,5077 }, { 209,5077 }, { 210,5077 },

 { 211,5077 }, { 212,5077 }, { 213,5077 }, { 214,5077 }, { 215,5077 },
 { 216,5077 }, { 217,5077 }, { 218,5077 }, { 219,5077 }, { 220,5077 },
 { 221,5077 }, { 222,5077 }, { 223,5077 }, { 224,5077 }, { 225,5077 },
 { 226,5077 }, { 227,5077 }, { 228,5077 }, { 229,5077 }, { 230,5077 },
 { 231,5077 }, { 232,5077 }, { 233,5077 }, { 234,5077 }, { 235,5077 },
 { 236,5077 }, { 237,5077 }, { 238,5077 }, { 239,5077 }, { 240,5077 },
 { 241,5077 }, { 242,5077 }, { 243,5077 }, { 244,5077 }, { 245,5077 },
 { 246,5077 }, { 247,5077 }, { 248,5077 }, { 249,5077 }, { 250,5077 },
 { 251,5077 }, { 252,5077 }, { 253,5077 }, { 254,5077 }, { 255,5077 },
 {   0,  64 }, {   0,11381 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  36,-514 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,   0 },
 {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 },

 {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,5334 }, {  66,5334 }, {  67,5334 }, {  68,5334 },
 {  69,5591 }, {  70,5334 }, {  71,5334 }, {  72,5334 }, {  73,5334 },
 {  74,5334 }, {  75,5334 }, {  76,5334 }, {  77,5334 }, {  78,5334 },
 {  79,5334 }, {  80,5334 }, {  81,5334 }, {  82,5334 }, {  83,5334 },
 {  84,5334 }, {  85,5334 }, {  86,5334 }, {  87,5334 }, {  88,5334 },
 {  89,5334 }, {  90,5334 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95,5848 }, {   0,   0 }, {  97,5334 }, {  98,5334 },
 {  99,5334 }, { 100,5334 }, { 101,5591 }, { 102,5334 }, { 103,5334 },

 { 104,5334 }, { 105,5334 }, { 106,5334 }, { 107,5334 }, { 108,5334 },
 { 109,5334 }, { 110,5334 }, { 111,5334 }, { 112,5334 }, { 113,5334 },
 { 114,5334 }, { 115,5334 }, { 116,5334 }, { 117,5334 }, { 118,5334 },
 { 119,5334 }, { 120,5334 }, { 121,5334 }, { 122,5334 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,5334 },
 { 129,5334 }, { 130,5334 }, { 131,5334 }, { 132,5334 }, { 133,5334 },
 { 134,5334 }, { 135,5334 }, { 136,5334 }, { 137,5334 }, { 138,5334 },
 { 139,5334 }, { 140,5334 }, { 141,5334 }, { 142,5334 }, { 143,5334 },
 { 144,5334 }, { 145,5334 }, { 146,5334 }, { 147,5334 }, { 148,5334 },
 { 149,5334 }, { 150,5334 }, { 151,5334 }, { 152,5334 }, { 153,5334 },

 { 154,5334 }, { 155,5334 }, { 156,5334 }, { 157,5334 }, { 158,5334 },
 { 159,5334 }, { 160,5334 }, { 161,5334 }, { 162,5334 }, { 163,5334 },
 { 164,5334 }, { 165,5334 }, { 166,5334 }, { 167,5334 }, { 168,5334 },
 { 169,5334 }, { 170,5334 }, { 171,5334 }, { 172,5334 }, { 173,5334 },
 { 174,5334 }, { 175,5334 }, { 176,5334 }, { 177,5334 }, { 178,5334 },
 { 179,5334 }, { 180,5334 }, { 181,5334 }, { 182,5334 }, { 183,5334 },
 { 184,5334 }, { 185,5334 }, { 186,5334 }, { 187,5334 }, { 188,5334 },
 { 189,5334 }, { 190,5334 }, { 191,5334 }, { 192,5334 }, { 193,5334 },
 { 194,5334 }, { 195,5334 }, { 196,5334 }, { 197,5334 }, { 198,5334 },
 { 199,5334 }, { 200,5334 }, { 201,5334 }, { 202,5334 }, { 203,5334 },

 { 204,5334 }, { 205,5334 }, { 206,5334 }, { 207,5334 }, { 208,5334 },
 { 209,5334 }, { 210,5334 }, { 211,5334 }, { 212,5334 }, { 213,5334 },
 { 214,5334 }, { 215,5334 }, { 216,5334 }, { 217,5334 }, { 218,5334 },
 { 219,5334 }, { 220,5334 }, { 221,5334 }, { 222,5334 }, { 223,5334 },
 { 224,5334 }, { 225,5334 }, { 226,5334 }, { 227,5334 }, { 228,5334 },
 { 229,5334 }, { 230,5334 }, { 231,5334 }, { 232,5334 }, { 233,5334 },
 { 234,5334 }, { 235,5334 }, { 236,5334 }, { 237,5334 }, { 238,5334 },
 { 239,5334 }, { 240,5334 }, { 241,5334 }, { 242,5334 }, { 243,5334 },
 { 244,5334 }, { 245,5334 }, { 246,5334 }, { 247,5334 }, { 248,5334 },
 { 249,5334 }, { 250,5334 }, { 251,5334 }, { 252,5334 }, { 253,5334 },

 { 254,5334 }, { 255,5334 }, {   0,  64 }, {   0,11124 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 },
 {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 },
 {  57,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,-6051 }, {  66,-6051 },
 {  67,-6051 }, {  68,-6051 }, {  69,-5794 }, {  70,-6051 }, {  71,-6051 },
 {  72,-6051 }, {  73,-6051 }, {  74,-6051 }, {  75,-6051 }, {  76,-6051 },
 {  77,-6051 }, {  78,-6051 }, {  79,-6051 }, {  80,-6051 }, {  81,-6051 },
 {  82,-6051 }, {  83,-6051 }, {  84,-6051 }, {  85,-6051 }, {  86,-6051 },
 {  87,-6051 }, {  88,-6051 }, {  89,-6051 }, {  90,-6051 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95, 257 }, {   0,   0 },

 {  97,-6051 }, {  98,-6051 }, {  99,-6051 }, { 100,-6051 }, { 101,-5794 },
 { 102,-6051 }, { 103,-6051 }, { 104,-6051 }, { 105,-6051 }, { 106,-6051 },
 { 107,-6051 }, { 108,-6051 }, { 109,-6051 }, { 110,-6051 }, { 111,-6051 },
 { 112,-6051 }, { 113,-6051 }, { 114,-6051 }, { 115,-6051 }, { 116,-6051 },
 { 117,-6051 }, { 118,-6051 }, { 119,-6051 }, { 120,-6051 }, { 121,-6051 },
 { 122,-6051 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 128,-6051 }, { 129,-6051 }, { 130,-6051 }, { 131,-6051 },
 { 132,-6051 }, { 133,-6051 }, { 134,-6051 }, { 135,-6051 }, { 136,-6051 },
 { 137,-6051 }, { 138,-6051 }, { 139,-6051 }, { 140,-6051 }, { 141,-6051 },
 { 142,-6051 }, { 143,-6051 }, { 144,-6051 }, { 145,-6051 }, { 146,-6051 },

 { 147,-6051 }, { 148,-6051 }, { 149,-6051 }, { 150,-6051 }, { 151,-6051 },
 { 152,-6051 }, { 153,-6051 }, { 154,-6051 }, { 155,-6051 }, { 156,-6051 },
 { 157,-6051 }, { 158,-6051 }, { 159,-6051 }, { 160,-6051 }, { 161,-6051 },
 { 162,-6051 }, { 163,-6051 }, { 164,-6051 }, { 165,-6051 }, { 166,-6051 },
 { 167,-6051 }, { 168,-6051 }, { 169,-6051 }, { 170,-6051 }, { 171,-6051 },
 { 172,-6051 }, { 173,-6051 }, { 174,-6051 }, { 175,-6051 }, { 176,-6051 },
 { 177,-6051 }, { 178,-6051 }, { 179,-6051 }, { 180,-6051 }, { 181,-6051 },
 { 182,-6051 }, { 183,-6051 }, { 184,-6051 }, { 185,-6051 }, { 186,-6051 },
 { 187,-6051 }, { 188,-6051 }, { 189,-6051 }, { 190,-6051 }, { 191,-6051 },
 { 192,-6051 }, { 193,-6051 }, { 194,-6051 }, { 195,-6051 }, { 196,-6051 },

 { 197,-6051 }, { 198,-6051 }, { 199,-6051 }, { 200,-6051 }, { 201,-6051 },
 { 202,-6051 }, { 203,-6051 }, { 204,-6051 }, { 205,-6051 }, { 206,-6051 },
 { 207,-6051 }, { 208,-6051 }, { 209,-6051 }, { 210,-6051 }, { 211,-6051 },
 { 212,-6051 }, { 213,-6051 }, { 214,-6051 }, { 215,-6051 }, { 216,-6051 },
 { 217,-6051 }, { 218,-6051 }, { 219,-6051 }, { 220,-6051 }, { 221,-6051 },
 { 222,-6051 }, { 223,-6051 }, { 224,-6051 }, { 225,-6051 }, { 226,-6051 },
 { 227,-6051 }, { 228,-6051 }, { 229,-6051 }, { 230,-6051 }, { 231,-6051 },
 { 232,-6051 }, { 233,-6051 }, { 234,-6051 }, { 235,-6051 }, { 236,-6051 },
 { 237,-6051 }, { 238,-6051 }, { 239,-6051 }, { 240,-6051 }, { 241,-6051 },
 { 242,-6051 }, { 243,-6051 }, { 244,-6051 }, { 245,-6051 }, { 246,-6051 },

 { 247,-6051 }, { 248,-6051 }, { 249,-6051 }, { 250,-6051 }, { 251,-6051 },
 { 252,-6051 }, { 253,-6051 }, { 254,-6051 }, { 255,-6051 }, {   0,  69 },
 {   0,10867 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  36,-1028 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,5591 }, {  49,5591 },
 {  50,5591 }, {  51,5591 }, {  52,5591 }, {  53,5591 }, {  54,5591 },
 {  55,5591 }, {  56,5591 }, {  57,5591 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,-1028 }, {  66,-1028 }, {  67,-1028 }, {  68,-1028 }, {  69,-1028 },
 {  70,-1028 }, {  71,-1028 }, {  72,-1028 }, {  73,-1028 }, {  74,-1028 },
 {  75,-1028 }, {  76,-1028 }, {  77,-1028 }, {  78,-1028 }, {  79,-1028 },
 {  80,-1028 }, {  81,-1028 }, {  82,-1028 }, {  83,-1028 }, {  84,-1028 },
 {  85,-1028 }, {  86,-1028 }, {  87,-1028 }, {  88,-1028 }, {  89,-1028 },

 {  90,-1028 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,-1028 }, {   0,   0 }, {  97,-1028 }, {  98,-1028 }, {  99,-1028 },
 { 100,-1028 }, { 101,-1028 }, { 102,-1028 }, { 103,-1028 }, { 104,-1028 },
 { 105,-1028 }, { 106,-1028 }, { 107,-1028 }, { 108,-1028 }, { 109,-1028 },
 { 110,-1028 }, { 111,-1028 }, { 112,-1028 }, { 113,-1028 }, { 114,-1028 },
 { 115,-1028 }, { 116,-1028 }, { 117,-1028 }, { 118,-1028 }, { 119,-1028 },
 { 120,-1028 }, { 121,-1028 }, { 122,-1028 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,-1028 }, { 129,-1028 },
 { 130,-1028 }, { 131,-1028 }, { 132,-1028 }, { 133,-1028 }, { 134,-1028 },
 { 135,-1028 }, { 136,-1028 }, { 137,-1028 }, { 138,-1028 }, { 139,-1028 },

 { 140,-1028 }, { 141,-1028 }, { 142,-1028 }, { 143,-1028 }, { 144,-1028 },
 { 145,-1028 }, { 146,-1028 }, { 147,-1028 }, { 148,-1028 }, { 149,-1028 },
 { 150,-1028 }, { 151,-1028 }, { 152,-1028 }, { 153,-1028 }, { 154,-1028 },
 { 155,-1028 }, { 156,-1028 }, { 157,-1028 }, { 158,-1028 }, { 159,-1028 },
 { 160,-1028 }, { 161,-1028 }, { 162,-1028 }, { 163,-1028 }, { 164,-1028 },
 { 165,-1028 }, { 166,-1028 }, { 167,-1028 }, { 168,-1028 }, { 169,-1028 },
 { 170,-1028 }, { 171,-1028 }, { 172,-1028 }, { 173,-1028 }, { 174,-1028 },
 { 175,-1028 }, { 176,-1028 }, { 177,-1028 }, { 178,-1028 }, { 179,-1028 },
 { 180,-1028 }, { 181,-1028 }, { 182,-1028 }, { 183,-1028 }, { 184,-1028 },
 { 185,-1028 }, { 186,-1028 }, { 187,-1028 }, { 188,-1028 }, { 189,-1028 },

 { 190,-1028 }, { 191,-1028 }, { 192,-1028 }, { 193,-1028 }, { 194,-1028 },
 { 195,-1028 }, { 196,-1028 }, { 197,-1028 }, { 198,-1028 }, { 199,-1028 },
 { 200,-1028 }, { 201,-1028 }, { 202,-1028 }, { 203,-1028 }, { 204,-1028 },
 { 205,-1028 }, { 206,-1028 }, { 207,-1028 }, { 208,-1028 }, { 209,-1028 },
 { 210,-1028 }, { 211,-1028 }, { 212,-1028 }, { 213,-1028 }, { 214,-1028 },
 { 215,-1028 }, { 216,-1028 }, { 217,-1028 }, { 218,-1028 }, { 219,-1028 },
 { 220,-1028 }, { 221,-1028 }, { 222,-1028 }, { 223,-1028 }, { 224,-1028 },
 { 225,-1028 }, { 226,-1028 }, { 227,-1028 }, { 228,-1028 }, { 229,-1028 },
 { 230,-1028 }, { 231,-1028 }, { 232,-1028 }, { 233,-1028 }, { 234,-1028 },
 { 235,-1028 }, { 236,-1028 }, { 237,-1028 }, { 238,-1028 }, { 239,-1028 },

 { 240,-1028 }, { 241,-1028 }, { 242,-1028 }, { 243,-1028 }, { 244,-1028 },
 { 245,-1028 }, { 246,-1028 }, { 247,-1028 }, { 248,-1028 }, { 249,-1028 },
 { 250,-1028 }, { 251,-1028 }, { 252,-1028 }, { 253,-1028 }, { 254,-1028 },
 { 255,-1028 }, {   0,  68 }, {   0,10610 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,-5505 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,-5248 }, {  49,-5248 }, {  50,-5505 }, {  51,-5505 }, {  52,-5505 },
 {  53,-5505 }, {  54,-5505 }, {  55,-5505 }, {  56,-5505 }, {  57,-5505 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,-5505 }, {  66,-5505 }, {  67,-5505 },
 {  68,-5505 }, {  69,-5505 }, {  70,-5505 }, {  71,-5505 }, {  72,-5505 },
 {  73,-5505 }, {  74,-5505 }, {  75,-5505 }, {  76,-5505 }, {  77,-5505 },
 {  78,-5505 }, {  79,-5505 }, {  80,-5505 }, {  81,-5505 }, {  82,-5505 },

 {  83,-5505 }, {  84,-5505 }, {  85,-5505 }, {  86,-5505 }, {  87,-5505 },
 {  88,-5505 }, {  89,-5505 }, {  90,-5505 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,-5505 }, {   0,   0 }, {  97,-5505 },
 {  98,-5505 }, {  99,-5505 }, { 100,-5505 }, { 101,-5505 }, { 102,-5505 },
 { 103,-5505 }, { 104,-5505 }, { 105,-5505 }, { 106,-5505 }, { 107,-5505 },
 { 108,-5505 }, { 109,-5505 }, { 110,-5505 }, { 111,-5505 }, { 112,-5505 },
 { 113,-5505 }, { 114,-5505 }, { 115,-5505 }, { 116,-5505 }, { 117,-5505 },
 { 118,-5505 }, { 119,-5505 }, { 120,-5505 }, { 121,-5505 }, { 122,-5505 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,-5505 }, { 129,-5505 }, { 130,-5505 }, { 131,-5505 }, { 132,-5505 },

 { 133,-5505 }, { 134,-5505 }, { 135,-5505 }, { 136,-5505 }, { 137,-5505 },
 { 138,-5505 }, { 139,-5505 }, { 140,-5505 }, { 141,-5505 }, { 142,-5505 },
 { 143,-5505 }, { 144,-5505 }, { 145,-5505 }, { 146,-5505 }, { 147,-5505 },
 { 148,-5505 }, { 149,-5505 }, { 150,-5505 }, { 151,-5505 }, { 152,-5505 },
 { 153,-5505 }, { 154,-5505 }, { 155,-5505 }, { 156,-5505 }, { 157,-5505 },
 { 158,-5505 }, { 159,-5505 }, { 160,-5505 }, { 161,-5505 }, { 162,-5505 },
 { 163,-5505 }, { 164,-5505 }, { 165,-5505 }, { 166,-5505 }, { 167,-5505 },
 { 168,-5505 }, { 169,-5505 }, { 170,-5505 }, { 171,-5505 }, { 172,-5505 },
 { 173,-5505 }, { 174,-5505 }, { 175,-5505 }, { 176,-5505 }, { 177,-5505 },
 { 178,-5505 }, { 179,-5505 }, { 180,-5505 }, { 181,-5505 }, { 182,-5505 },

 { 183,-5505 }, { 184,-5505 }, { 185,-5505 }, { 186,-5505 }, { 187,-5505 },
 { 188,-5505 }, { 189,-5505 }, { 190,-5505 }, { 191,-5505 }, { 192,-5505 },
 { 193,-5505 }, { 194,-5505 }, { 195,-5505 }, { 196,-5505 }, { 197,-5505 },
 { 198,-5505 }, { 199,-5505 }, { 200,-5505 }, { 201,-5505 }, { 202,-5505 },
 { 203,-5505 }, { 204,-5505 }, { 205,-5505 }, { 206,-5505 }, { 207,-5505 },
 { 208,-5505 }, { 209,-5505 }, { 210,-5505 }, { 211,-5505 }, { 212,-5505 },
 { 213,-5505 }, { 214,-5505 }, { 215,-5505 }, { 216,-5505 }, { 217,-5505 },
 { 218,-5505 }, { 219,-5505 }, { 220,-5505 }, { 221,-5505 }, { 222,-5505 },
 { 223,-5505 }, { 224,-5505 }, { 225,-5505 }, { 226,-5505 }, { 227,-5505 },
 { 228,-5505 }, { 229,-5505 }, { 230,-5505 }, { 231,-5505 }, { 232,-5505 },

 { 233,-5505 }, { 234,-5505 }, { 235,-5505 }, { 236,-5505 }, { 237,-5505 },
 { 238,-5505 }, { 239,-5505 }, { 240,-5505 }, { 241,-5505 }, { 242,-5505 },
 { 243,-5505 }, { 244,-5505 }, { 245,-5505 }, { 246,-5505 }, { 247,-5505 },
 { 248,-5505 }, { 249,-5505 }, { 250,-5505 }, { 251,-5505 }, { 252,-5505 },
 { 253,-5505 }, { 254,-5505 }, { 255,-5505 }, {   0,  66 }, {   0,10353 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,5334 }, {  49,5334 }, {  50,5334 },
 {  51,5334 }, {  52,5334 }, {  53,5334 }, {  54,5334 }, {  55,5334 },
 {  56,5334 }, {  57,5334 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,5591 },
 {  66,5591 }, {  67,5591 }, {  68,5591 }, {  69,5591 }, {  70,5591 },
 {  71,5591 }, {  72,5591 }, {  73,5591 }, {  74,5591 }, {  75,5591 },

 {  76,5591 }, {  77,5591 }, {  78,5591 }, {  79,5591 }, {  80,5591 },
 {  81,5591 }, {  82,5591 }, {  83,5591 }, {  84,5591 }, {  85,5591 },
 {  86,5591 }, {  87,5591 }, {  88,5591 }, {  89,5591 }, {  90,5591 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,5848 },
 {   0,   0 }, {  97,5591 }, {  98,5591 }, {  99,5591 }, { 100,5591 },
 { 101,5591 }, { 102,5591 }, { 103,5591 }, { 104,5591 }, { 105,5591 },
 { 106,5591 }, { 107,5591 }, { 108,5591 }, { 109,5591 }, { 110,5591 },
 { 111,5591 }, { 112,5591 }, { 113,5591 }, { 114,5591 }, { 115,5591 },
 { 116,5591 }, { 117,5591 }, { 118,5591 }, { 119,5591 }, { 120,5591 },
 { 121,5591 }, { 122,5591 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, { 128,5591 }, { 129,5591 }, { 130,5591 },
 { 131,5591 }, { 132,5591 }, { 133,5591 }, { 134,5591 }, { 135,5591 },
 { 136,5591 }, { 137,5591 }, { 138,5591 }, { 139,5591 }, { 140,5591 },
 { 141,5591 }, { 142,5591 }, { 143,5591 }, { 144,5591 }, { 145,5591 },
 { 146,5591 }, { 147,5591 }, { 148,5591 }, { 149,5591 }, { 150,5591 },
 { 151,5591 }, { 152,5591 }, { 153,5591 }, { 154,5591 }, { 155,5591 },
 { 156,5591 }, { 157,5591 }, { 158,5591 }, { 159,5591 }, { 160,5591 },
 { 161,5591 }, { 162,5591 }, { 163,5591 }, { 164,5591 }, { 165,5591 },
 { 166,5591 }, { 167,5591 }, { 168,5591 }, { 169,5591 }, { 170,5591 },
 { 171,5591 }, { 172,5591 }, { 173,5591 }, { 174,5591 }, { 175,5591 },

 { 176,5591 }, { 177,5591 }, { 178,5591 }, { 179,5591 }, { 180,5591 },
 { 181,5591 }, { 182,5591 }, { 183,5591 }, { 184,5591 }, { 185,5591 },
 { 186,5591 }, { 187,5591 }, { 188,5591 }, { 189,5591 }, { 190,5591 },
 { 191,5591 }, { 192,5591 }, { 193,5591 }, { 194,5591 }, { 195,5591 },
 { 196,5591 }, { 197,5591 }, { 198,5591 }, { 199,5591 }, { 200,5591 },
 { 201,5591 }, { 202,5591 }, { 203,5591 }, { 204,5591 }, { 205,5591 },
 { 206,5591 }, { 207,5591 }, { 208,5591 }, { 209,5591 }, { 210,5591 },
 { 211,5591 }, { 212,5591 }, { 213,5591 }, { 214,5591 }, { 215,5591 },
 { 216,5591 }, { 217,5591 }, { 218,5591 }, { 219,5591 }, { 220,5591 },
 { 221,5591 }, { 222,5591 }, { 223,5591 }, { 224,5591 }, { 225,5591 },

 { 226,5591 }, { 227,5591 }, { 228,5591 }, { 229,5591 }, { 230,5591 },
 { 231,5591 }, { 232,5591 }, { 233,5591 }, { 234,5591 }, { 235,5591 },
 { 236,5591 }, { 237,5591 }, { 238,5591 }, { 239,5591 }, { 240,5591 },
 { 241,5591 }, { 242,5591 }, { 243,5591 }, { 244,5591 }, { 245,5591 },
 { 246,5591 }, { 247,5591 }, { 248,5591 }, { 249,5591 }, { 250,5591 },
 { 251,5591 }, { 252,5591 }, { 253,5591 }, { 254,5591 }, { 255,5591 },
 {   0,  66 }, {   0,10096 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  36,-6019 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,   0 },
 {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 },
 {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65, 257 }, {  66, 257 }, {  67, 257 }, {  68, 257 },

 {  69, 257 }, {  70, 257 }, {  71, 257 }, {  72, 257 }, {  73, 257 },
 {  74, 257 }, {  75, 257 }, {  76, 257 }, {  77, 257 }, {  78, 257 },
 {  79, 257 }, {  80, 257 }, {  81, 257 }, {  82, 257 }, {  83, 257 },
 {  84, 257 }, {  85, 257 }, {  86, 257 }, {  87, 257 }, {  88, 257 },
 {  89, 257 }, {  90, 257 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95, 514 }, {   0,   0 }, {  97, 257 }, {  98, 257 },
 {  99, 257 }, { 100, 257 }, { 101, 257 }, { 102, 257 }, { 103, 257 },
 { 104, 257 }, { 105, 257 }, { 106, 257 }, { 107, 257 }, { 108, 257 },
 { 109, 257 }, { 110, 257 }, { 111, 257 }, { 112, 257 }, { 113, 257 },
 { 114, 257 }, { 115, 257 }, { 116, 257 }, { 117, 257 }, { 118, 257 },

 { 119, 257 }, { 120, 257 }, { 121, 257 }, { 122, 257 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128, 257 },
 { 129, 257 }, { 130, 257 }, { 131, 257 }, { 132, 257 }, { 133, 257 },
 { 134, 257 }, { 135, 257 }, { 136, 257 }, { 137, 257 }, { 138, 257 },
 { 139, 257 }, { 140, 257 }, { 141, 257 }, { 142, 257 }, { 143, 257 },
 { 144, 257 }, { 145, 257 }, { 146, 257 }, { 147, 257 }, { 148, 257 },
 { 149, 257 }, { 150, 257 }, { 151, 257 }, { 152, 257 }, { 153, 257 },
 { 154, 257 }, { 155, 257 }, { 156, 257 }, { 157, 257 }, { 158, 257 },
 { 159, 257 }, { 160, 257 }, { 161, 257 }, { 162, 257 }, { 163, 257 },
 { 164, 257 }, { 165, 257 }, { 166, 257 }, { 167, 257 }, { 168, 257 },

 { 169, 257 }, { 170, 257 }, { 171, 257 }, { 172, 257 }, { 173, 257 },
 { 174, 257 }, { 175, 257 }, { 176, 257 }, { 177, 257 }, { 178, 257 },
 { 179, 257 }, { 180, 257 }, { 181, 257 }, { 182, 257 }, { 183, 257 },
 { 184, 257 }, { 185, 257 }, { 186, 257 }, { 187, 257 }, { 188, 257 },
 { 189, 257 }, { 190, 257 }, { 191, 257 }, { 192, 257 }, { 193, 257 },
 { 194, 257 }, { 195, 257 }, { 196, 257 }, { 197, 257 }, { 198, 257 },
 { 199, 257 }, { 200, 257 }, { 201, 257 }, { 202, 257 }, { 203, 257 },
 { 204, 257 }, { 205, 257 }, { 206, 257 }, { 207, 257 }, { 208, 257 },
 { 209, 257 }, { 210, 257 }, { 211, 257 }, { 212, 257 }, { 213, 257 },
 { 214, 257 }, { 215, 257 }, { 216, 257 }, { 217, 257 }, { 218, 257 },

 { 219, 257 }, { 220, 257 }, { 221, 257 }, { 222, 257 }, { 223, 257 },
 { 224, 257 }, { 225, 257 }, { 226, 257 }, { 227, 257 }, { 228, 257 },
 { 229, 257 }, { 230, 257 }, { 231, 257 }, { 232, 257 }, { 233, 257 },
 { 234, 257 }, { 235, 257 }, { 236, 257 }, { 237, 257 }, { 238, 257 },
 { 239, 257 }, { 240, 257 }, { 241, 257 }, { 242, 257 }, { 243, 257 },
 { 244, 257 }, { 245, 257 }, { 246, 257 }, { 247, 257 }, { 248, 257 },
 { 249, 257 }, { 250, 257 }, { 251, 257 }, { 252, 257 }, { 253, 257 },
 { 254, 257 }, { 255, 257 }, {   0,  68 }, {   0,9839 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,5591 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,5591 }, {  49,5591 }, {  50,5591 }, {  51,5591 },
 {  52,5591 }, {  53,5591 }, {  54,5591 }, {  55,5591 }, {  56,5591 },
 {  57,5591 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,5591 }, {  66,5591 },
 {  67,5591 }, {  68,5591 }, {  69,5591 }, {  70,5591 }, {  71,5591 },
 {  72,5591 }, {  73,5591 }, {  74,5591 }, {  75,5591 }, {  76,5591 },
 {  77,5591 }, {  78,5591 }, {  79,5591 }, {  80,5591 }, {  81,5591 },
 {  82,5591 }, {  83,5591 }, {  84,5591 }, {  85,5591 }, {  86,5591 },
 {  87,5591 }, {  88,5591 }, {  89,5591 }, {  90,5591 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,5591 }, {   0,   0 },
 {  97,5591 }, {  98,5591 }, {  99,5591 }, { 100,5591 }, { 101,5591 },
 { 102,5591 }, { 103,5591 }, { 104,5591 }, { 105,5591 }, { 106,5591 },
 { 107,5591 }, { 108,5591 }, { 109,5591 }, { 110,5591 }, { 111,5591 },

 { 112,5591 }, { 113,5591 }, { 114,5591 }, { 115,5591 }, { 116,5591 },
 { 117,5591 }, { 118,5591 }, { 119,5591 }, { 120,5591 }, { 121,5591 },
 { 122,5591 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 128,5591 }, { 129,5591 }, { 130,5591 }, { 131,5591 },
 { 132,5591 }, { 133,5591 }, { 134,5591 }, { 135,5591 }, { 136,5591 },
 { 137,5591 }, { 138,5591 }, { 139,5591 }, { 140,5591 }, { 141,5591 },
 { 142,5591 }, { 143,5591 }, { 144,5591 }, { 145,5591 }, { 146,5591 },
 { 147,5591 }, { 148,5591 }, { 149,5591 }, { 150,5591 }, { 151,5591 },
 { 152,5591 }, { 153,5591 }, { 154,5591 }, { 155,5591 }, { 156,5591 },
 { 157,5591 }, { 158,5591 }, { 159,5591 }, { 160,5591 }, { 161,5591 },

 { 162,5591 }, { 163,5591 }, { 164,5591 }, { 165,5591 }, { 166,5591 },
 { 167,5591 }, { 168,5591 }, { 169,5591 }, { 170,5591 }, { 171,5591 },
 { 172,5591 }, { 173,5591 }, { 174,5591 }, { 175,5591 }, { 176,5591 },
 { 177,5591 }, { 178,5591 }, { 179,5591 }, { 180,5591 }, { 181,5591 },
 { 182,5591 }, { 183,5591 }, { 184,5591 }, { 185,5591 }, { 186,5591 },
 { 187,5591 }, { 188,5591 }, { 189,5591 }, { 190,5591 }, { 191,5591 },
 { 192,5591 }, { 193,5591 }, { 194,5591 }, { 195,5591 }, { 196,5591 },
 { 197,5591 }, { 198,5591 }, { 199,5591 }, { 200,5591 }, { 201,5591 },
 { 202,5591 }, { 203,5591 }, { 204,5591 }, { 205,5591 }, { 206,5591 },
 { 207,5591 }, { 208,5591 }, { 209,5591 }, { 210,5591 }, { 211,5591 },

 { 212,5591 }, { 213,5591 }, { 214,5591 }, { 215,5591 }, { 216,5591 },
 { 217,5591 }, { 218,5591 }, { 219,5591 }, { 220,5591 }, { 221,5591 },
 { 222,5591 }, { 223,5591 }, { 224,5591 }, { 225,5591 }, { 226,5591 },
 { 227,5591 }, { 228,5591 }, { 229,5591 }, { 230,5591 }, { 231,5591 },
 { 232,5591 }, { 233,5591 }, { 234,5591 }, { 235,5591 }, { 236,5591 },
 { 237,5591 }, { 238,5591 }, { 239,5591 }, { 240,5591 }, { 241,5591 },
 { 242,5591 }, { 243,5591 }, { 244,5591 }, { 245,5591 }, { 246,5591 },
 { 247,5591 }, { 248,5591 }, { 249,5591 }, { 250,5591 }, { 251,5591 },
 { 252,5591 }, { 253,5591 }, { 254,5591 }, { 255,5591 }, {   0,  68 },
 {   0,9582 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  36,5334 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,5591 }, {  49,5591 },
 {  50,5591 }, {  51,5591 }, {  52,5591 }, {  53,5591 }, {  54,5591 },

 {  55,5591 }, {  56,5591 }, {  57,5591 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,5334 }, {  66,5334 }, {  67,5334 }, {  68,5334 }, {  69,5334 },
 {  70,5334 }, {  71,5334 }, {  72,5334 }, {  73,5334 }, {  74,5334 },
 {  75,5334 }, {  76,5334 }, {  77,5334 }, {  78,5334 }, {  79,5334 },
 {  80,5334 }, {  81,5334 }, {  82,5334 }, {  83,5334 }, {  84,5334 },
 {  85,5334 }, {  86,5334 }, {  87,5334 }, {  88,5334 }, {  89,5334 },
 {  90,5334 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,5334 }, {   0,   0 }, {  97,5334 }, {  98,5334 }, {  99,5334 },
 { 100,5334 }, { 101,5334 }, { 102,5334 }, { 103,5334 }, { 104,5334 },

 { 105,5334 }, { 106,5334 }, { 107,5334 }, { 108,5334 }, { 109,5334 },
 { 110,5334 }, { 111,5334 }, { 112,5334 }, { 113,5334 }, { 114,5334 },
 { 115,5334 }, { 116,5334 }, { 117,5334 }, { 118,5334 }, { 119,5334 },
 { 120,5334 }, { 121,5334 }, { 122,5334 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,5334 }, { 129,5334 },
 { 130,5334 }, { 131,5334 }, { 132,5334 }, { 133,5334 }, { 134,5334 },
 { 135,5334 }, { 136,5334 }, { 137,5334 }, { 138,5334 }, { 139,5334 },
 { 140,5334 }, { 141,5334 }, { 142,5334 }, { 143,5334 }, { 144,5334 },
 { 145,5334 }, { 146,5334 }, { 147,5334 }, { 148,5334 }, { 149,5334 },
 { 150,5334 }, { 151,5334 }, { 152,5334 }, { 153,5334 }, { 154,5334 },

 { 155,5334 }, { 156,5334 }, { 157,5334 }, { 158,5334 }, { 159,5334 },
 { 160,5334 }, { 161,5334 }, { 162,5334 }, { 163,5334 }, { 164,5334 },
 { 165,5334 }, { 166,5334 }, { 167,5334 }, { 168,5334 }, { 169,5334 },
 { 170,5334 }, { 171,5334 }, { 172,5334 }, { 173,5334 }, { 174,5334 },
 { 175,5334 }, { 176,5334 }, { 177,5334 }, { 178,5334 }, { 179,5334 },
 { 180,5334 }, { 181,5334 }, { 182,5334 }, { 183,5334 }, { 184,5334 },
 { 185,5334 }, { 186,5334 }, { 187,5334 }, { 188,5334 }, { 189,5334 },
 { 190,5334 }, { 191,5334 }, { 192,5334 }, { 193,5334 }, { 194,5334 },
 { 195,5334 }, { 196,5334 }, { 197,5334 }, { 198,5334 }, { 199,5334 },
 { 200,5334 }, { 201,5334 }, { 202,5334 }, { 203,5334 }, { 204,5334 },

 { 205,5334 }, { 206,5334 }, { 207,5334 }, { 208,5334 }, { 209,5334 },
 { 210,5334 }, { 211,5334 }, { 212,5334 }, { 213,5334 }, { 214,5334 },
 { 215,5334 }, { 216,5334 }, { 217,5334 }, { 218,5334 }, { 219,5334 },
 { 220,5334 }, { 221,5334 }, { 222,5334 }, { 223,5334 }, { 224,5334 },
 { 225,5334 }, { 226,5334 }, { 227,5334 }, { 228,5334 }, { 229,5334 },
 { 230,5334 }, { 231,5334 }, { 232,5334 }, { 233,5334 }, { 234,5334 },
 { 235,5334 }, { 236,5334 }, { 237,5334 }, { 238,5334 }, { 239,5334 },
 { 240,5334 }, { 241,5334 }, { 242,5334 }, { 243,5334 }, { 244,5334 },
 { 245,5334 }, { 246,5334 }, { 247,5334 }, { 248,5334 }, { 249,5334 },
 { 250,5334 }, { 251,5334 }, { 252,5334 }, { 253,5334 }, { 254,5334 },

 { 255,5334 }, {   0,  68 }, {   0,9325 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,-6790 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {  48,-5752 }, {  49,-5752 }, {  50,-5752 }, {  51,-5752 }, {  52,-5752 },
 {  53,-5752 }, {  54,-5752 }, {  55,-5752 }, {  56,-6790 }, {  57,-6790 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,-6790 }, {  66,-6790 }, {  67,-6790 },
 {  68,-6790 }, {  69,-6790 }, {  70,-6790 }, {  71,-6790 }, {  72,-6790 },
 {  73,-6790 }, {  74,-6790 }, {  75,-6790 }, {  76,-6790 }, {  77,-6790 },
 {  78,-6790 }, {  79,-6790 }, {  80,-6790 }, {  81,-6790 }, {  82,-6790 },
 {  83,-6790 }, {  84,-6790 }, {  85,-6790 }, {  86,-6790 }, {  87,-6790 },
 {  88,-6790 }, {  89,-6790 }, {  90,-6790 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,-6790 }, {   0,   0 }, {  97,-6790 },

 {  98,-6790 }, {  99,-6790 }, { 100,-6790 }, { 101,-6790 }, { 102,-6790 },
 { 103,-6790 }, { 104,-6790 }, { 105,-6790 }, { 106,-6790 }, { 107,-6790 },
 { 108,-6790 }, { 109,-6790 }, { 110,-6790 }, { 111,-6790 }, { 112,-6790 },
 { 113,-6790 }, { 114,-6790 }, { 115,-6790 }, { 116,-6790 }, { 117,-6790 },
 { 118,-6790 }, { 119,-6790 }, { 120,-6790 }, { 121,-6790 }, { 122,-6790 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,-6790 }, { 129,-6790 }, { 130,-6790 }, { 131,-6790 }, { 132,-6790 },
 { 133,-6790 }, { 134,-6790 }, { 135,-6790 }, { 136,-6790 }, { 137,-6790 },
 { 138,-6790 }, { 139,-6790 }, { 140,-6790 }, { 141,-6790 }, { 142,-6790 },
 { 143,-6790 }, { 144,-6790 }, { 145,-6790 }, { 146,-6790 }, { 147,-6790 },

 { 148,-6790 }, { 149,-6790 }, { 150,-6790 }, { 151,-6790 }, { 152,-6790 },
 { 153,-6790 }, { 154,-6790 }, { 155,-6790 }, { 156,-6790 }, { 157,-6790 },
 { 158,-6790 }, { 159,-6790 }, { 160,-6790 }, { 161,-6790 }, { 162,-6790 },
 { 163,-6790 }, { 164,-6790 }, { 165,-6790 }, { 166,-6790 }, { 167,-6790 },
 { 168,-6790 }, { 169,-6790 }, { 170,-6790 }, { 171,-6790 }, { 172,-6790 },
 { 173,-6790 }, { 174,-6790 }, { 175,-6790 }, { 176,-6790 }, { 177,-6790 },
 { 178,-6790 }, { 179,-6790 }, { 180,-6790 }, { 181,-6790 }, { 182,-6790 },
 { 183,-6790 }, { 184,-6790 }, { 185,-6790 }, { 186,-6790 }, { 187,-6790 },
 { 188,-6790 }, { 189,-6790 }, { 190,-6790 }, { 191,-6790 }, { 192,-6790 },
 { 193,-6790 }, { 194,-6790 }, { 195,-6790 }, { 196,-6790 }, { 197,-6790 },

 { 198,-6790 }, { 199,-6790 }, { 200,-6790 }, { 201,-6790 }, { 202,-6790 },
 { 203,-6790 }, { 204,-6790 }, { 205,-6790 }, { 206,-6790 }, { 207,-6790 },
 { 208,-6790 }, { 209,-6790 }, { 210,-6790 }, { 211,-6790 }, { 212,-6790 },
 { 213,-6790 }, { 214,-6790 }, { 215,-6790 }, { 216,-6790 }, { 217,-6790 },
 { 218,-6790 }, { 219,-6790 }, { 220,-6790 }, { 221,-6790 }, { 222,-6790 },
 { 223,-6790 }, { 224,-6790 }, { 225,-6790 }, { 226,-6790 }, { 227,-6790 },
 { 228,-6790 }, { 229,-6790 }, { 230,-6790 }, { 231,-6790 }, { 232,-6790 },
 { 233,-6790 }, { 234,-6790 }, { 235,-6790 }, { 236,-6790 }, { 237,-6790 },
 { 238,-6790 }, { 239,-6790 }, { 240,-6790 }, { 241,-6790 }, { 242,-6790 },
 { 243,-6790 }, { 244,-6790 }, { 245,-6790 }, { 246,-6790 }, { 247,-6790 },

 { 248,-6790 }, { 249,-6790 }, { 250,-6790 }, { 251,-6790 }, { 252,-6790 },
 { 253,-6790 }, { 254,-6790 }, { 255,-6790 }, {   0,  68 }, {   0,9068 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  36,-7047 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,-5495 }, {  49,-5495 }, {  50,-5495 },
 {  51,-5495 }, {  52,-5495 }, {  53,-5495 }, {  54,-5495 }, {  55,-5495 },
 {  56,-5495 }, {  57,-5495 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,-5495 },
 {  66,-5495 }, {  67,-5495 }, {  68,-5495 }, {  69,-5495 }, {  70,-5495 },
 {  71,-7047 }, {  72,-7047 }, {  73,-7047 }, {  74,-7047 }, {  75,-7047 },
 {  76,-7047 }, {  77,-7047 }, {  78,-7047 }, {  79,-7047 }, {  80,-7047 },
 {  81,-7047 }, {  82,-7047 }, {  83,-7047 }, {  84,-7047 }, {  85,-7047 },
 {  86,-7047 }, {  87,-7047 }, {  88,-7047 }, {  89,-7047 }, {  90,-7047 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,-7047 },
 {   0,   0 }, {  97,-5495 }, {  98,-5495 }, {  99,-5495 }, { 100,-5495 },
 { 101,-5495 }, { 102,-5495 }, { 103,-7047 }, { 104,-7047 }, { 105,-7047 },
 { 106,-7047 }, { 107,-7047 }, { 108,-7047 }, { 109,-7047 }, { 110,-7047 },
 { 111,-7047 }, { 112,-7047 }, { 113,-7047 }, { 114,-7047 }, { 115,-7047 },
 { 116,-7047 }, { 117,-7047 }, { 118,-7047 }, { 119,-7047 }, { 120,-7047 },
 { 121,-7047 }, { 122,-7047 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 128,-7047 }, { 129,-7047 }, { 130,-7047 },
 { 131,-7047 }, { 132,-7047 }, { 133,-7047 }, { 134,-7047 }, { 135,-7047 },
 { 136,-7047 }, { 137,-7047 }, { 138,-7047 }, { 139,-7047 }, { 140,-7047 },

 { 141,-7047 }, { 142,-7047 }, { 143,-7047 }, { 144,-7047 }, { 145,-7047 },
 { 146,-7047 }, { 147,-7047 }, { 148,-7047 }, { 149,-7047 }, { 150,-7047 },
 { 151,-7047 }, { 152,-7047 }, { 153,-7047 }, { 154,-7047 }, { 155,-7047 },
 { 156,-7047 }, { 157,-7047 }, { 158,-7047 }, { 159,-7047 }, { 160,-7047 },
 { 161,-7047 }, { 162,-7047 }, { 163,-7047 }, { 164,-7047 }, { 165,-7047 },
 { 166,-7047 }, { 167,-7047 }, { 168,-7047 }, { 169,-7047 }, { 170,-7047 },
 { 171,-7047 }, { 172,-7047 }, { 173,-7047 }, { 174,-7047 }, { 175,-7047 },
 { 176,-7047 }, { 177,-7047 }, { 178,-7047 }, { 179,-7047 }, { 180,-7047 },
 { 181,-7047 }, { 182,-7047 }, { 183,-7047 }, { 184,-7047 }, { 185,-7047 },
 { 186,-7047 }, { 187,-7047 }, { 188,-7047 }, { 189,-7047 }, { 190,-7047 },

 { 191,-7047 }, { 192,-7047 }, { 193,-7047 }, { 194,-7047 }, { 195,-7047 },
 { 196,-7047 }, { 197,-7047 }, { 198,-7047 }, { 199,-7047 }, { 200,-7047 },
 { 201,-7047 }, { 202,-7047 }, { 203,-7047 }, { 204,-7047 }, { 205,-7047 },
 { 206,-7047 }, { 207,-7047 }, { 208,-7047 }, { 209,-7047 }, { 210,-7047 },
 { 211,-7047 }, { 212,-7047 }, { 213,-7047 }, { 214,-7047 }, { 215,-7047 },
 { 216,-7047 }, { 217,-7047 }, { 218,-7047 }, { 219,-7047 }, { 220,-7047 },
 { 221,-7047 }, { 222,-7047 }, { 223,-7047 }, { 224,-7047 }, { 225,-7047 },
 { 226,-7047 }, { 227,-7047 }, { 228,-7047 }, { 229,-7047 }, { 230,-7047 },
 { 231,-7047 }, { 232,-7047 }, { 233,-7047 }, { 234,-7047 }, { 235,-7047 },
 { 236,-7047 }, { 237,-7047 }, { 238,-7047 }, { 239,-7047 }, { 240,-7047 },

 { 241,-7047 }, { 242,-7047 }, { 243,-7047 }, { 244,-7047 }, { 245,-7047 },
 { 246,-7047 }, { 247,-7047 }, { 248,-7047 }, { 249,-7047 }, { 250,-7047 },
 { 251,-7047 }, { 252,-7047 }, { 253,-7047 }, { 254,-7047 }, { 255,-7047 },
 {   0,  68 }, {   0,8811 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {  36,-7304 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,-7304 },
 {  49,-7304 }, {  50,-7304 }, {  51,-7304 }, {  52,-7304 }, {  53,-7304 },
 {  54,-7304 }, {  55,-7304 }, {  56,-7304 }, {  57,-7304 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,-7304 }, {  66,-7304 }, {  67,-7304 }, {  68,-7304 },
 {  69,-7304 }, {  70,-7304 }, {  71,-7304 }, {  72,-7304 }, {  73,-7304 },
 {  74,-7304 }, {  75,-7304 }, {  76,-7304 }, {  77,-7304 }, {  78,-7304 },
 {  79,-7304 }, {  80,-7304 }, {  81,-7304 }, {  82,-7304 }, {  83,-7304 },

 {  84,-7304 }, {  85,-7304 }, {  86,-7304 }, {  87,-7304 }, {  88,-7304 },
 {  89,-7304 }, {  90,-7304 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95,-7304 }, {   0,   0 }, {  97,-7304 }, {  98,-7304 },
 {  99,-7304 }, { 100,-7304 }, { 101,-7304 }, { 102,-7304 }, { 103,-7304 },
 { 104,-7304 }, { 105,-7304 }, { 106,-7304 }, { 107,-7304 }, { 108,-7304 },
 { 109,-7304 }, { 110,-7304 }, { 111,-7304 }, { 112,-7304 }, { 113,-7304 },
 { 114,-7304 }, { 115,-7304 }, { 116,-7304 }, { 117,-7304 }, { 118,-7304 },
 { 119,-7304 }, { 120,-7304 }, { 121,-7304 }, { 122,-7304 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,-7304 },
 { 129,-7304 }, { 130,-7304 }, { 131,-7304 }, { 132,-7304 }, { 133,-7304 },

 { 134,-7304 }, { 135,-7304 }, { 136,-7304 }, { 137,-7304 }, { 138,-7304 },
 { 139,-7304 }, { 140,-7304 }, { 141,-7304 }, { 142,-7304 }, { 143,-7304 },
 { 144,-7304 }, { 145,-7304 }, { 146,-7304 }, { 147,-7304 }, { 148,-7304 },
 { 149,-7304 }, { 150,-7304 }, { 151,-7304 }, { 152,-7304 }, { 153,-7304 },
 { 154,-7304 }, { 155,-7304 }, { 156,-7304 }, { 157,-7304 }, { 158,-7304 },
 { 159,-7304 }, { 160,-7304 }, { 161,-7304 }, { 162,-7304 }, { 163,-7304 },
 { 164,-7304 }, { 165,-7304 }, { 166,-7304 }, { 167,-7304 }, { 168,-7304 },
 { 169,-7304 }, { 170,-7304 }, { 171,-7304 }, { 172,-7304 }, { 173,-7304 },
 { 174,-7304 }, { 175,-7304 }, { 176,-7304 }, { 177,-7304 }, { 178,-7304 },
 { 179,-7304 }, { 180,-7304 }, { 181,-7304 }, { 182,-7304 }, { 183,-7304 },

 { 184,-7304 }, { 185,-7304 }, { 186,-7304 }, { 187,-7304 }, { 188,-7304 },
 { 189,-7304 }, { 190,-7304 }, { 191,-7304 }, { 192,-7304 }, { 193,-7304 },
 { 194,-7304 }, { 195,-7304 }, { 196,-7304 }, { 197,-7304 }, { 198,-7304 },
 { 199,-7304 }, { 200,-7304 }, { 201,-7304 }, { 202,-7304 }, { 203,-7304 },
 { 204,-7304 }, { 205,-7304 }, { 206,-7304 }, { 207,-7304 }, { 208,-7304 },
 { 209,-7304 }, { 210,-7304 }, { 211,-7304 }, { 212,-7304 }, { 213,-7304 },
 { 214,-7304 }, { 215,-7304 }, { 216,-7304 }, { 217,-7304 }, { 218,-7304 },
 { 219,-7304 }, { 220,-7304 }, { 221,-7304 }, { 222,-7304 }, { 223,-7304 },
 { 224,-7304 }, { 225,-7304 }, { 226,-7304 }, { 227,-7304 }, { 228,-7304 },
 { 229,-7304 }, { 230,-7304 }, { 231,-7304 }, { 232,-7304 }, { 233,-7304 },

 { 234,-7304 }, { 235,-7304 }, { 236,-7304 }, { 237,-7304 }, { 238,-7304 },
 { 239,-7304 }, { 240,-7304 }, { 241,-7304 }, { 242,-7304 }, { 243,-7304 },
 { 244,-7304 }, { 245,-7304 }, { 246,-7304 }, { 247,-7304 }, { 248,-7304 },
 { 249,-7304 }, { 250,-7304 }, { 251,-7304 }, { 252,-7304 }, { 253,-7304 },
 { 254,-7304 }, { 255,-7304 }, {   0,  68 }, {   0,8554 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,-7561 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  43,-6790 }, {   0,   0 }, {  45,-6790 }, {   0,   0 },
 {   0,   0 }, {  48,-6780 }, {  49,-6780 }, {  50,-6780 }, {  51,-6780 },
 {  52,-6780 }, {  53,-6780 }, {  54,-6780 }, {  55,-6780 }, {  56,-6780 },
 {  57,-6780 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,-7561 }, {  66,-7561 },
 {  67,-7561 }, {  68,-7561 }, {  69,-7561 }, {  70,-7561 }, {  71,-7561 },
 {  72,-7561 }, {  73,-7561 }, {  74,-7561 }, {  75,-7561 }, {  76,-7561 },

 {  77,-7561 }, {  78,-7561 }, {  79,-7561 }, {  80,-7561 }, {  81,-7561 },
 {  82,-7561 }, {  83,-7561 }, {  84,-7561 }, {  85,-7561 }, {  86,-7561 },
 {  87,-7561 }, {  88,-7561 }, {  89,-7561 }, {  90,-7561 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,-7561 }, {   0,   0 },
 {  97,-7561 }, {  98,-7561 }, {  99,-7561 }, { 100,-7561 }, { 101,-7561 },
 { 102,-7561 }, { 103,-7561 }, { 104,-7561 }, { 105,-7561 }, { 106,-7561 },
 { 107,-7561 }, { 108,-7561 }, { 109,-7561 }, { 110,-7561 }, { 111,-7561 },
 { 112,-7561 }, { 113,-7561 }, { 114,-7561 }, { 115,-7561 }, { 116,-7561 },
 { 117,-7561 }, { 118,-7561 }, { 119,-7561 }, { 120,-7561 }, { 121,-7561 },
 { 122,-7561 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, { 128,-7561 }, { 129,-7561 }, { 130,-7561 }, { 131,-7561 },
 { 132,-7561 }, { 133,-7561 }, { 134,-7561 }, { 135,-7561 }, { 136,-7561 },
 { 137,-7561 }, { 138,-7561 }, { 139,-7561 }, { 140,-7561 }, { 141,-7561 },
 { 142,-7561 }, { 143,-7561 }, { 144,-7561 }, { 145,-7561 }, { 146,-7561 },
 { 147,-7561 }, { 148,-7561 }, { 149,-7561 }, { 150,-7561 }, { 151,-7561 },
 { 152,-7561 }, { 153,-7561 }, { 154,-7561 }, { 155,-7561 }, { 156,-7561 },
 { 157,-7561 }, { 158,-7561 }, { 159,-7561 }, { 160,-7561 }, { 161,-7561 },
 { 162,-7561 }, { 163,-7561 }, { 164,-7561 }, { 165,-7561 }, { 166,-7561 },
 { 167,-7561 }, { 168,-7561 }, { 169,-7561 }, { 170,-7561 }, { 171,-7561 },
 { 172,-7561 }, { 173,-7561 }, { 174,-7561 }, { 175,-7561 }, { 176,-7561 },

 { 177,-7561 }, { 178,-7561 }, { 179,-7561 }, { 180,-7561 }, { 181,-7561 },
 { 182,-7561 }, { 183,-7561 }, { 184,-7561 }, { 185,-7561 }, { 186,-7561 },
 { 187,-7561 }, { 188,-7561 }, { 189,-7561 }, { 190,-7561 }, { 191,-7561 },
 { 192,-7561 }, { 193,-7561 }, { 194,-7561 }, { 195,-7561 }, { 196,-7561 },
 { 197,-7561 }, { 198,-7561 }, { 199,-7561 }, { 200,-7561 }, { 201,-7561 },
 { 202,-7561 }, { 203,-7561 }, { 204,-7561 }, { 205,-7561 }, { 206,-7561 },
 { 207,-7561 }, { 208,-7561 }, { 209,-7561 }, { 210,-7561 }, { 211,-7561 },
 { 212,-7561 }, { 213,-7561 }, { 214,-7561 }, { 215,-7561 }, { 216,-7561 },
 { 217,-7561 }, { 218,-7561 }, { 219,-7561 }, { 220,-7561 }, { 221,-7561 },
 { 222,-7561 }, { 223,-7561 }, { 224,-7561 }, { 225,-7561 }, { 226,-7561 },

 { 227,-7561 }, { 228,-7561 }, { 229,-7561 }, { 230,-7561 }, { 231,-7561 },
 { 232,-7561 }, { 233,-7561 }, { 234,-7561 }, { 235,-7561 }, { 236,-7561 },
 { 237,-7561 }, { 238,-7561 }, { 239,-7561 }, { 240,-7561 }, { 241,-7561 },
 { 242,-7561 }, { 243,-7561 }, { 244,-7561 }, { 245,-7561 }, { 246,-7561 },
 { 247,-7561 }, { 248,-7561 }, { 249,-7561 }, { 250,-7561 }, { 251,-7561 },
 { 252,-7561 }, { 253,-7561 }, { 254,-7561 }, { 255,-7561 }, {   0,  68 },
 {   0,8297 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  36,-7818 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,-5752 }, {  49,-5752 },
 {  50,-5752 }, {  51,-5752 }, {  52,-5752 }, {  53,-5752 }, {  54,-5752 },
 {  55,-5752 }, {  56,-5752 }, {  57,-5752 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,-7818 }, {  66,-7818 }, {  67,-7818 }, {  68,-7818 }, {  69,-7818 },

 {  70,-7818 }, {  71,-7818 }, {  72,-7818 }, {  73,-7818 }, {  74,-7818 },
 {  75,-7818 }, {  76,-7818 }, {  77,-7818 }, {  78,-7818 }, {  79,-7818 },
 {  80,-7818 }, {  81,-7818 }, {  82,-7818 }, {  83,-7818 }, {  84,-7818 },
 {  85,-7818 }, {  86,-7818 }, {  87,-7818 }, {  88,-7818 }, {  89,-7818 },
 {  90,-7818 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,-7818 }, {   0,   0 }, {  97,-7818 }, {  98,-7818 }, {  99,-7818 },
 { 100,-7818 }, { 101,-7818 }, { 102,-7818 }, { 103,-7818 }, { 104,-7818 },
 { 105,-7818 }, { 106,-7818 }, { 107,-7818 }, { 108,-7818 }, { 109,-7818 },
 { 110,-7818 }, { 111,-7818 }, { 112,-7818 }, { 113,-7818 }, { 114,-7818 },
 { 115,-7818 }, { 116,-7818 }, { 117,-7818 }, { 118,-7818 }, { 119,-7818 },

 { 120,-7818 }, { 121,-7818 }, { 122,-7818 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,-7818 }, { 129,-7818 },
 { 130,-7818 }, { 131,-7818 }, { 132,-7818 }, { 133,-7818 }, { 134,-7818 },
 { 135,-7818 }, { 136,-7818 }, { 137,-7818 }, { 138,-7818 }, { 139,-7818 },
 { 140,-7818 }, { 141,-7818 }, { 142,-7818 }, { 143,-7818 }, { 144,-7818 },
 { 145,-7818 }, { 146,-7818 }, { 147,-7818 }, { 148,-7818 }, { 149,-7818 },
 { 150,-7818 }, { 151,-7818 }, { 152,-7818 }, { 153,-7818 }, { 154,-7818 },
 { 155,-7818 }, { 156,-7818 }, { 157,-7818 }, { 158,-7818 }, { 159,-7818 },
 { 160,-7818 }, { 161,-7818 }, { 162,-7818 }, { 163,-7818 }, { 164,-7818 },
 { 165,-7818 }, { 166,-7818 }, { 167,-7818 }, { 168,-7818 }, { 169,-7818 },

 { 170,-7818 }, { 171,-7818 }, { 172,-7818 }, { 173,-7818 }, { 174,-7818 },
 { 175,-7818 }, { 176,-7818 }, { 177,-7818 }, { 178,-7818 }, { 179,-7818 },
 { 180,-7818 }, { 181,-7818 }, { 182,-7818 }, { 183,-7818 }, { 184,-7818 },
 { 185,-7818 }, { 186,-7818 }, { 187,-7818 }, { 188,-7818 }, { 189,-7818 },
 { 190,-7818 }, { 191,-7818 }, { 192,-7818 }, { 193,-7818 }, { 194,-7818 },
 { 195,-7818 }, { 196,-7818 }, { 197,-7818 }, { 198,-7818 }, { 199,-7818 },
 { 200,-7818 }, { 201,-7818 }, { 202,-7818 }, { 203,-7818 }, { 204,-7818 },
 { 205,-7818 }, { 206,-7818 }, { 207,-7818 }, { 208,-7818 }, { 209,-7818 },
 { 210,-7818 }, { 211,-7818 }, { 212,-7818 }, { 213,-7818 }, { 214,-7818 },
 { 215,-7818 }, { 216,-7818 }, { 217,-7818 }, { 218,-7818 }, { 219,-7818 },

 { 220,-7818 }, { 221,-7818 }, { 222,-7818 }, { 223,-7818 }, { 224,-7818 },
 { 225,-7818 }, { 226,-7818 }, { 227,-7818 }, { 228,-7818 }, { 229,-7818 },
 { 230,-7818 }, { 231,-7818 }, { 232,-7818 }, { 233,-7818 }, { 234,-7818 },
 { 235,-7818 }, { 236,-7818 }, { 237,-7818 }, { 238,-7818 }, { 239,-7818 },
 { 240,-7818 }, { 241,-7818 }, { 242,-7818 }, { 243,-7818 }, { 244,-7818 },
 { 245,-7818 }, { 246,-7818 }, { 247,-7818 }, { 248,-7818 }, { 249,-7818 },
 { 250,-7818 }, { 251,-7818 }, { 252,-7818 }, { 253,-7818 }, { 254,-7818 },
 { 255,-7818 }, {   0,  18 }, {   0,8040 }, {   1,   0 }, {   2,   0 },
 {   3,   0 }, {   4,   0 }, {   5,   0 }, {   6,   0 }, {   7,   0 },
 {   8,   0 }, {   9, 258 }, {  10, 516 }, {  11, 258 }, {  12, 258 },

 {  13, 516 }, {  14,   0 }, {  15,   0 }, {  16,   0 }, {  17,   0 },
 {  18,   0 }, {  19,   0 }, {  20,   0 }, {  21,   0 }, {  22,   0 },
 {  23,   0 }, {  24,   0 }, {  25,   0 }, {  26,   0 }, {  27,   0 },
 {  28,   0 }, {  29,   0 }, {  30,   0 }, {  31,   0 }, {  32, 258 },
 {  33,   0 }, {  34,   0 }, {  35,   0 }, {  36,   0 }, {  37,   0 },
 {  38,   0 }, {  39,   0 }, {  40,   0 }, {  41,   0 }, {  42,   0 },
 {  43,   0 }, {  44,   0 }, {  45, 563 }, {  46,   0 }, {  47,   0 },
 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },
 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },
 {  58,   0 }, {  59,   0 }, {  60,   0 }, {  61,   0 }, {  62,   0 },

 {  63,   0 }, {  64,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 },
 {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 },
 {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 },
 {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 },
 {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 },
 {  88,   0 }, {  89,   0 }, {  90,   0 }, {  91,   0 }, {  92,   0 },
 {  93,   0 }, {  94,   0 }, {  95,   0 }, {  96,   0 }, {  97,   0 },
 {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 },
 { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 },
 { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 },

 { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 },
 { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 },
 { 123,   0 }, { 124,   0 }, { 125,   0 }, { 126,   0 }, { 127,   0 },
 { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 },
 { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 },
 { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 },
 { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 },
 { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 },
 { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 },
 { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 },

 { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 },
 { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 },
 { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 },
 { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 },
 { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 },
 { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 },
 { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 },
 { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 },
 { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 },
 { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 },

 { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 },
 { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 },
 { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 },
 { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 },
 { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 },
 { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 },
 { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 },
 { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 },
 { 253,   0 }, { 254,   0 }, { 255,   0 }, { 256,   0 }, {   0,  18 },
 {   0,7782 }, {   1,-258 }, {   2,-258 }, {   3,-258 }, {   4,-258 },

 {   5,-258 }, {   6,-258 }, {   7,-258 }, {   8,-258 }, {   9,   0 },
 {  10, 258 }, {  11,   0 }, {  12,   0 }, {  13, 258 }, {  14,-258 },
 {  15,-258 }, {  16,-258 }, {  17,-258 }, {  18,-258 }, {  19,-258 },
 {  20,-258 }, {  21,-258 }, {  22,-258 }, {  23,-258 }, {  24,-258 },
 {  25,-258 }, {  26,-258 }, {  27,-258 }, {  28,-258 }, {  29,-258 },
 {  30,-258 }, {  31,-258 }, {  32,   0 }, {  33,-258 }, {  34,-258 },
 {  35,-258 }, {  36,-258 }, {  37,-258 }, {  38,-258 }, {  39,-258 },
 {  40,-258 }, {  41,-258 }, {  42,-258 }, {  43,-258 }, {  44,-258 },
 {  45, 305 }, {  46,-258 }, {  47,-258 }, {  48,-258 }, {  49,-258 },
 {  50,-258 }, {  51,-258 }, {  52,-258 }, {  53,-258 }, {  54,-258 },

 {  55,-258 }, {  56,-258 }, {  57,-258 }, {  58,-258 }, {  59,-258 },
 {  60,-258 }, {  61,-258 }, {  62,-258 }, {  63,-258 }, {  64,-258 },
 {  65,-258 }, {  66,-258 }, {  67,-258 }, {  68,-258 }, {  69,-258 },
 {  70,-258 }, {  71,-258 }, {  72,-258 }, {  73,-258 }, {  74,-258 },
 {  75,-258 }, {  76,-258 }, {  77,-258 }, {  78,-258 }, {  79,-258 },
 {  80,-258 }, {  81,-258 }, {  82,-258 }, {  83,-258 }, {  84,-258 },
 {  85,-258 }, {  86,-258 }, {  87,-258 }, {  88,-258 }, {  89,-258 },
 {  90,-258 }, {  91,-258 }, {  92,-258 }, {  93,-258 }, {  94,-258 },
 {  95,-258 }, {  96,-258 }, {  97,-258 }, {  98,-258 }, {  99,-258 },
 { 100,-258 }, { 101,-258 }, { 102,-258 }, { 103,-258 }, { 104,-258 },

 { 105,-258 }, { 106,-258 }, { 107,-258 }, { 108,-258 }, { 109,-258 },
 { 110,-258 }, { 111,-258 }, { 112,-258 }, { 113,-258 }, { 114,-258 },
 { 115,-258 }, { 116,-258 }, { 117,-258 }, { 118,-258 }, { 119,-258 },
 { 120,-258 }, { 121,-258 }, { 122,-258 }, { 123,-258 }, { 124,-258 },
 { 125,-258 }, { 126,-258 }, { 127,-258 }, { 128,-258 }, { 129,-258 },
 { 130,-258 }, { 131,-258 }, { 132,-258 }, { 133,-258 }, { 134,-258 },
 { 135,-258 }, { 136,-258 }, { 137,-258 }, { 138,-258 }, { 139,-258 },
 { 140,-258 }, { 141,-258 }, { 142,-258 }, { 143,-258 }, { 144,-258 },
 { 145,-258 }, { 146,-258 }, { 147,-258 }, { 148,-258 }, { 149,-258 },
 { 150,-258 }, { 151,-258 }, { 152,-258 }, { 153,-258 }, { 154,-258 },

 { 155,-258 }, { 156,-258 }, { 157,-258 }, { 158,-258 }, { 159,-258 },
 { 160,-258 }, { 161,-258 }, { 162,-258 }, { 163,-258 }, { 164,-258 },
 { 165,-258 }, { 166,-258 }, { 167,-258 }, { 168,-258 }, { 169,-258 },
 { 170,-258 }, { 171,-258 }, { 172,-258 }, { 173,-258 }, { 174,-258 },
 { 175,-258 }, { 176,-258 }, { 177,-258 }, { 178,-258 }, { 179,-258 },
 { 180,-258 }, { 181,-258 }, { 182,-258 }, { 183,-258 }, { 184,-258 },
 { 185,-258 }, { 186,-258 }, { 187,-258 }, { 188,-258 }, { 189,-258 },
 { 190,-258 }, { 191,-258 }, { 192,-258 }, { 193,-258 }, { 194,-258 },
 { 195,-258 }, { 196,-258 }, { 197,-258 }, { 198,-258 }, { 199,-258 },
 { 200,-258 }, { 201,-258 }, { 202,-258 }, { 203,-258 }, { 204,-258 },

 { 205,-258 }, { 206,-258 }, { 207,-258 }, { 208,-258 }, { 209,-258 },
 { 210,-258 }, { 211,-258 }, { 212,-258 }, { 213,-258 }, { 214,-258 },
 { 215,-258 }, { 216,-258 }, { 217,-258 }, { 218,-258 }, { 219,-258 },
 { 220,-258 }, { 221,-258 }, { 222,-258 }, { 223,-258 }, { 224,-258 },
 { 225,-258 }, { 226,-258 }, { 227,-258 }, { 228,-258 }, { 229,-258 },
 { 230,-258 }, { 231,-258 }, { 232,-258 }, { 233,-258 }, { 234,-258 },
 { 235,-258 }, { 236,-258 }, { 237,-258 }, { 238,-258 }, { 239,-258 },
 { 240,-258 }, { 241,-258 }, { 242,-258 }, { 243,-258 }, { 244,-258 },
 { 245,-258 }, { 246,-258 }, { 247,-258 }, { 248,-258 }, { 249,-258 },
 { 250,-258 }, { 251,-258 }, { 252,-258 }, { 253,-258 }, { 254,-258 },

 { 255,-258 }, { 256,-258 }, {   0,  18 }, {   0,7524 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   9,-12271 }, {  10,-12271 }, {  11,-12271 },
 {  12,-12271 }, {  13,-12271 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  32,-12271 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  39,-22814 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  45,-22812 }, {   0,  18 },

 {   0,7477 }, {   1,-563 }, {   2,-563 }, {   3,-563 }, {   4,-563 },
 {   5,-563 }, {   6,-563 }, {   7,-563 }, {   8,-563 }, {   9,-305 },
 {  10, -47 }, {  11,-305 }, {  12,-305 }, {  13, -47 }, {  14,-563 },
 {  15,-563 }, {  16,-563 }, {  17,-563 }, {  18,-563 }, {  19,-563 },
 {  20,-563 }, {  21,-563 }, {  22,-563 }, {  23,-563 }, {  24,-563 },
 {  25,-563 }, {  26,-563 }, {  27,-563 }, {  28,-563 }, {  29,-563 },
 {  30,-563 }, {  31,-563 }, {  32,-305 }, {  33,-563 }, {  34,-563 },
 {  35,-563 }, {  36,-563 }, {  37,-563 }, {  38,-563 }, {  39,-563 },
 {  40,-563 }, {  41,-563 }, {  42,-563 }, {  43,-563 }, {  44,-563 },
 {  45,3743 }, {  46,-563 }, {  47,-563 }, {  48,-563 }, {  49,-563 },

 {  50,-563 }, {  51,-563 }, {  52,-563 }, {  53,-563 }, {  54,-563 },
 {  55,-563 }, {  56,-563 }, {  57,-563 }, {  58,-563 }, {  59,-563 },
 {  60,-563 }, {  61,-563 }, {  62,-563 }, {  63,-563 }, {  64,-563 },
 {  65,-563 }, {  66,-563 }, {  67,-563 }, {  68,-563 }, {  69,-563 },
 {  70,-563 }, {  71,-563 }, {  72,-563 }, {  73,-563 }, {  74,-563 },
 {  75,-563 }, {  76,-563 }, {  77,-563 }, {  78,-563 }, {  79,-563 },
 {  80,-563 }, {  81,-563 }, {  82,-563 }, {  83,-563 }, {  84,-563 },
 {  85,-563 }, {  86,-563 }, {  87,-563 }, {  88,-563 }, {  89,-563 },
 {  90,-563 }, {  91,-563 }, {  92,-563 }, {  93,-563 }, {  94,-563 },
 {  95,-563 }, {  96,-563 }, {  97,-563 }, {  98,-563 }, {  99,-563 },

 { 100,-563 }, { 101,-563 }, { 102,-563 }, { 103,-563 }, { 104,-563 },
 { 105,-563 }, { 106,-563 }, { 107,-563 }, { 108,-563 }, { 109,-563 },
 { 110,-563 }, { 111,-563 }, { 112,-563 }, { 113,-563 }, { 114,-563 },
 { 115,-563 }, { 116,-563 }, { 117,-563 }, { 118,-563 }, { 119,-563 },
 { 120,-563 }, { 121,-563 }, { 122,-563 }, { 123,-563 }, { 124,-563 },
 { 125,-563 }, { 126,-563 }, { 127,-563 }, { 128,-563 }, { 129,-563 },
 { 130,-563 }, { 131,-563 }, { 132,-563 }, { 133,-563 }, { 134,-563 },
 { 135,-563 }, { 136,-563 }, { 137,-563 }, { 138,-563 }, { 139,-563 },
 { 140,-563 }, { 141,-563 }, { 142,-563 }, { 143,-563 }, { 144,-563 },
 { 145,-563 }, { 146,-563 }, { 147,-563 }, { 148,-563 }, { 149,-563 },

 { 150,-563 }, { 151,-563 }, { 152,-563 }, { 153,-563 }, { 154,-563 },
 { 155,-563 }, { 156,-563 }, { 157,-563 }, { 158,-563 }, { 159,-563 },
 { 160,-563 }, { 161,-563 }, { 162,-563 }, { 163,-563 }, { 164,-563 },
 { 165,-563 }, { 166,-563 }, { 167,-563 }, { 168,-563 }, { 169,-563 },
 { 170,-563 }, { 171,-563 }, { 172,-563 }, { 173,-563 }, { 174,-563 },
 { 175,-563 }, { 176,-563 }, { 177,-563 }, { 178,-563 }, { 179,-563 },
 { 180,-563 }, { 181,-563 }, { 182,-563 }, { 183,-563 }, { 184,-563 },
 { 185,-563 }, { 186,-563 }, { 187,-563 }, { 188,-563 }, { 189,-563 },
 { 190,-563 }, { 191,-563 }, { 192,-563 }, { 193,-563 }, { 194,-563 },
 { 195,-563 }, { 196,-563 }, { 197,-563 }, { 198,-563 }, { 199,-563 },

 { 200,-563 }, { 201,-563 }, { 202,-563 }, { 203,-563 }, { 204,-563 },
 { 205,-563 }, { 206,-563 }, { 207,-563 }, { 208,-563 }, { 209,-563 },
 { 210,-563 }, { 211,-563 }, { 212,-563 }, { 213,-563 }, { 214,-563 },
 { 215,-563 }, { 216,-563 }, { 217,-563 }, { 218,-563 }, { 219,-563 },
 { 220,-563 }, { 221,-563 }, { 222,-563 }, { 223,-563 }, { 224,-563 },
 { 225,-563 }, { 226,-563 }, { 227,-563 }, { 228,-563 }, { 229,-563 },
 { 230,-563 }, { 231,-563 }, { 232,-563 }, { 233,-563 }, { 234,-563 },
 { 235,-563 }, { 236,-563 }, { 237,-563 }, { 238,-563 }, { 239,-563 },
 { 240,-563 }, { 241,-563 }, { 242,-563 }, { 243,-563 }, { 244,-563 },
 { 245,-563 }, { 246,-563 }, { 247,-563 }, { 248,-563 }, { 249,-563 },

 { 250,-563 }, { 251,-563 }, { 252,-563 }, { 253,-563 }, { 254,-563 },
 { 255,-563 }, { 256,-563 }, {   0,  18 }, {   0,7219 }, {   1,-6187 },
 {   2,-6187 }, {   3,-6187 }, {   4,-6187 }, {   5,-6187 }, {   6,-6187 },
 {   7,-6187 }, {   8,-6187 }, {   9,-5929 }, {  10,-12600 }, {  11,-5929 },
 {  12,-5929 }, {  13,-12600 }, {  14,-6187 }, {  15,-6187 }, {  16,-6187 },
 {  17,-6187 }, {  18,-6187 }, {  19,-6187 }, {  20,-6187 }, {  21,-6187 },
 {  22,-6187 }, {  23,-6187 }, {  24,-6187 }, {  25,-6187 }, {  26,-6187 },
 {  27,-6187 }, {  28,-6187 }, {  29,-6187 }, {  30,-6187 }, {  31,-6187 },
 {  32,-5929 }, {  33,-6187 }, {  34,-6187 }, {  35,-6187 }, {  36,-6187 },
 {  37,-6187 }, {  38,-6187 }, {  39,-6187 }, {  40,-6187 }, {  41,-6187 },

 {  42,-6187 }, {  43,-6187 }, {  44,-6187 }, {  45,   0 }, {  46,-6187 },
 {  47,-6187 }, {  48,-6187 }, {  49,-6187 }, {  50,-6187 }, {  51,-6187 },
 {  52,-6187 }, {  53,-6187 }, {  54,-6187 }, {  55,-6187 }, {  56,-6187 },
 {  57,-6187 }, {  58,-6187 }, {  59,-6187 }, {  60,-6187 }, {  61,-6187 },
 {  62,-6187 }, {  63,-6187 }, {  64,-6187 }, {  65,-6187 }, {  66,-6187 },
 {  67,-6187 }, {  68,-6187 }, {  69,-6187 }, {  70,-6187 }, {  71,-6187 },
 {  72,-6187 }, {  73,-6187 }, {  74,-6187 }, {  75,-6187 }, {  76,-6187 },
 {  77,-6187 }, {  78,-6187 }, {  79,-6187 }, {  80,-6187 }, {  81,-6187 },
 {  82,-6187 }, {  83,-6187 }, {  84,-6187 }, {  85,-6187 }, {  86,-6187 },
 {  87,-6187 }, {  88,-6187 }, {  89,-6187 }, {  90,-6187 }, {  91,-6187 },

 {  92,-6187 }, {  93,-6187 }, {  94,-6187 }, {  95,-6187 }, {  96,-6187 },
 {  97,-6187 }, {  98,-6187 }, {  99,-6187 }, { 100,-6187 }, { 101,-6187 },
 { 102,-6187 }, { 103,-6187 }, { 104,-6187 }, { 105,-6187 }, { 106,-6187 },
 { 107,-6187 }, { 108,-6187 }, { 109,-6187 }, { 110,-6187 }, { 111,-6187 },
 { 112,-6187 }, { 113,-6187 }, { 114,-6187 }, { 115,-6187 }, { 116,-6187 },
 { 117,-6187 }, { 118,-6187 }, { 119,-6187 }, { 120,-6187 }, { 121,-6187 },
 { 122,-6187 }, { 123,-6187 }, { 124,-6187 }, { 125,-6187 }, { 126,-6187 },
 { 127,-6187 }, { 128,-6187 }, { 129,-6187 }, { 130,-6187 }, { 131,-6187 },
 { 132,-6187 }, { 133,-6187 }, { 134,-6187 }, { 135,-6187 }, { 136,-6187 },
 { 137,-6187 }, { 138,-6187 }, { 139,-6187 }, { 140,-6187 }, { 141,-6187 },

 { 142,-6187 }, { 143,-6187 }, { 144,-6187 }, { 145,-6187 }, { 146,-6187 },
 { 147,-6187 }, { 148,-6187 }, { 149,-6187 }, { 150,-6187 }, { 151,-6187 },
 { 152,-6187 }, { 153,-6187 }, { 154,-6187 }, { 155,-6187 }, { 156,-6187 },
 { 157,-6187 }, { 158,-6187 }, { 159,-6187 }, { 160,-6187 }, { 161,-6187 },
 { 162,-6187 }, { 163,-6187 }, { 164,-6187 }, { 165,-6187 }, { 166,-6187 },
 { 167,-6187 }, { 168,-6187 }, { 169,-6187 }, { 170,-6187 }, { 171,-6187 },
 { 172,-6187 }, { 173,-6187 }, { 174,-6187 }, { 175,-6187 }, { 176,-6187 },
 { 177,-6187 }, { 178,-6187 }, { 179,-6187 }, { 180,-6187 }, { 181,-6187 },
 { 182,-6187 }, { 183,-6187 }, { 184,-6187 }, { 185,-6187 }, { 186,-6187 },
 { 187,-6187 }, { 188,-6187 }, { 189,-6187 }, { 190,-6187 }, { 191,-6187 },

 { 192,-6187 }, { 193,-6187 }, { 194,-6187 }, { 195,-6187 }, { 196,-6187 },
 { 197,-6187 }, { 198,-6187 }, { 199,-6187 }, { 200,-6187 }, { 201,-6187 },
 { 202,-6187 }, { 203,-6187 }, { 204,-6187 }, { 205,-6187 }, { 206,-6187 },
 { 207,-6187 }, { 208,-6187 }, { 209,-6187 }, { 210,-6187 }, { 211,-6187 },
 { 212,-6187 }, { 213,-6187 }, { 214,-6187 }, { 215,-6187 }, { 216,-6187 },
 { 217,-6187 }, { 218,-6187 }, { 219,-6187 }, { 220,-6187 }, { 221,-6187 },
 { 222,-6187 }, { 223,-6187 }, { 224,-6187 }, { 225,-6187 }, { 226,-6187 },
 { 227,-6187 }, { 228,-6187 }, { 229,-6187 }, { 230,-6187 }, { 231,-6187 },
 { 232,-6187 }, { 233,-6187 }, { 234,-6187 }, { 235,-6187 }, { 236,-6187 },
 { 237,-6187 }, { 238,-6187 }, { 239,-6187 }, { 240,-6187 }, { 241,-6187 },

 { 242,-6187 }, { 243,-6187 }, { 244,-6187 }, { 245,-6187 }, { 246,-6187 },
 { 247,-6187 }, { 248,-6187 }, { 249,-6187 }, { 250,-6187 }, { 251,-6187 },
 { 252,-6187 }, { 253,-6187 }, { 254,-6187 }, { 255,-6187 }, { 256,-6187 },
 {   0,  27 }, {   0,6961 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  27 }, {   0,6938 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,3485 },
 {  49,3485 }, {  50,3485 }, {  51,3485 }, {  52,3485 }, {  53,3485 },
 {  54,3485 }, {  55,3485 }, {  56,3485 }, {  57,3485 }, {   0,   0 },
 {   0,   0 }, {   0,  27 }, {   0,6900 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,3485 }, {  66,3485 }, {  67,3485 }, {  68,3485 },
 {  69,3485 }, {  70,3485 }, {  48,3485 }, {  49,3485 }, {  50,3485 },
 {  51,3485 }, {  52,3485 }, {  53,3485 }, {  54,3485 }, {  55,3485 },
 {  56,3485 }, {  57,3485 }, {   0,   0 }, {   0,   0 }, {   0,  27 },

 {   0,6877 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,3485 },
 {  66,3485 }, {  67,3485 }, {  68,3485 }, {  69,3485 }, {  70,3485 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97,3485 }, {  98,3485 },
 {  99,3485 }, { 100,3485 }, { 101,3485 }, { 102,3485 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,3485 }, {  49,3485 }, {  50,3485 }, {  51,3485 }, {  52,3485 },
 {  53,3485 }, {  54,3485 }, {  55,3485 }, {  56,3485 }, {  57,3485 },
 {   0,   0 }, {  97,3485 }, {  98,3485 }, {  99,3485 }, { 100,3485 },
 { 101,3485 }, { 102,3485 }, {  65,3485 }, {  66,3485 }, {  67,3485 },
 {  68,3485 }, {  69,3485 }, {  70,3485 }, {  48,3485 }, {  49,3485 },

 {  50,3485 }, {  51,3485 }, {  52,3485 }, {  53,3485 }, {  54,3485 },
 {  55,3485 }, {  56,3485 }, {  57,3485 }, {   0,  66 }, {   0,6818 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,3485 }, {  66,3485 }, {  67,3485 }, {  68,3485 }, {  69,3485 },
 {  70,3485 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97,3485 },
 {  98,3485 }, {  99,3485 }, { 100,3485 }, { 101,3485 }, { 102,3485 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  36,-5077 }, {   0,   0 }, {  97,3485 }, {  98,3485 }, {  99,3485 },

 { 100,3485 }, { 101,3485 }, { 102,3485 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 },
 {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 },
 {  56,   0 }, {  57,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65, 257 },
 {  66, 257 }, {  67, 257 }, {  68, 257 }, {  69, 257 }, {  70, 257 },
 {  71, 257 }, {  72, 257 }, {  73, 257 }, {  74, 257 }, {  75, 257 },
 {  76, 257 }, {  77, 257 }, {  78, 257 }, {  79, 257 }, {  80, 257 },
 {  81, 257 }, {  82, 257 }, {  83, 257 }, {  84, 257 }, {  85, 257 },
 {  86, 257 }, {  87, 257 }, {  88, 257 }, {  89, 257 }, {  90, 257 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95, 514 },
 {   0,   0 }, {  97, 257 }, {  98, 257 }, {  99, 257 }, { 100, 257 },
 { 101, 257 }, { 102, 257 }, { 103, 257 }, { 104, 257 }, { 105, 257 },
 { 106, 257 }, { 107, 257 }, { 108, 257 }, { 109, 257 }, { 110, 257 },
 { 111, 257 }, { 112, 257 }, { 113, 257 }, { 114, 257 }, { 115, 257 },
 { 116, 257 }, { 117, 257 }, { 118, 257 }, { 119, 257 }, { 120, 257 },
 { 121, 257 }, { 122, 257 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 128, 257 }, { 129, 257 }, { 130, 257 },
 { 131, 257 }, { 132, 257 }, { 133, 257 }, { 134, 257 }, { 135, 257 },
 { 136, 257 }, { 137, 257 }, { 138, 257 }, { 139, 257 }, { 140, 257 },

 { 141, 257 }, { 142, 257 }, { 143, 257 }, { 144, 257 }, { 145, 257 },
 { 146, 257 }, { 147, 257 }, { 148, 257 }, { 149, 257 }, { 150, 257 },
 { 151, 257 }, { 152, 257 }, { 153, 257 }, { 154, 257 }, { 155, 257 },
 { 156, 257 }, { 157, 257 }, { 158, 257 }, { 159, 257 }, { 160, 257 },
 { 161, 257 }, { 162, 257 }, { 163, 257 }, { 164, 257 }, { 165, 257 },
 { 166, 257 }, { 167, 257 }, { 168, 257 }, { 169, 257 }, { 170, 257 },
 { 171, 257 }, { 172, 257 }, { 173, 257 }, { 174, 257 }, { 175, 257 },
 { 176, 257 }, { 177, 257 }, { 178, 257 }, { 179, 257 }, { 180, 257 },
 { 181, 257 }, { 182, 257 }, { 183, 257 }, { 184, 257 }, { 185, 257 },
 { 186, 257 }, { 187, 257 }, { 188, 257 }, { 189, 257 }, { 190, 257 },

 { 191, 257 }, { 192, 257 }, { 193, 257 }, { 194, 257 }, { 195, 257 },
 { 196, 257 }, { 197, 257 }, { 198, 257 }, { 199, 257 }, { 200, 257 },
 { 201, 257 }, { 202, 257 }, { 203, 257 }, { 204, 257 }, { 205, 257 },
 { 206, 257 }, { 207, 257 }, { 208, 257 }, { 209, 257 }, { 210, 257 },
 { 211, 257 }, { 212, 257 }, { 213, 257 }, { 214, 257 }, { 215, 257 },
 { 216, 257 }, { 217, 257 }, { 218, 257 }, { 219, 257 }, { 220, 257 },
 { 221, 257 }, { 222, 257 }, { 223, 257 }, { 224, 257 }, { 225, 257 },
 { 226, 257 }, { 227, 257 }, { 228, 257 }, { 229, 257 }, { 230, 257 },
 { 231, 257 }, { 232, 257 }, { 233, 257 }, { 234, 257 }, { 235, 257 },
 { 236, 257 }, { 237, 257 }, { 238, 257 }, { 239, 257 }, { 240, 257 },

 { 241, 257 }, { 242, 257 }, { 243, 257 }, { 244, 257 }, { 245, 257 },
 { 246, 257 }, { 247, 257 }, { 248, 257 }, { 249, 257 }, { 250, 257 },
 { 251, 257 }, { 252, 257 }, { 253, 257 }, { 254, 257 }, { 255, 257 },
 {   0,  69 }, {   0,6561 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {  36,3228 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,3228 },
 {  49,3228 }, {  50,3228 }, {  51,3228 }, {  52,3228 }, {  53,3228 },
 {  54,3228 }, {  55,3228 }, {  56,3228 }, {  57,3228 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,3228 }, {  66,3228 }, {  67,3228 }, {  68,3228 },
 {  69,3228 }, {  70,3228 }, {  71,3228 }, {  72,3228 }, {  73,3228 },
 {  74,3228 }, {  75,3228 }, {  76,3228 }, {  77,3228 }, {  78,3228 },
 {  79,3228 }, {  80,3228 }, {  81,3228 }, {  82,3228 }, {  83,3228 },

 {  84,3228 }, {  85,3228 }, {  86,3228 }, {  87,3228 }, {  88,3228 },
 {  89,3228 }, {  90,3228 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95,3228 }, {   0,   0 }, {  97,3228 }, {  98,3228 },
 {  99,3228 }, { 100,3228 }, { 101,3228 }, { 102,3228 }, { 103,3228 },
 { 104,3228 }, { 105,3228 }, { 106,3228 }, { 107,3228 }, { 108,3228 },
 { 109,3228 }, { 110,3228 }, { 111,3228 }, { 112,3228 }, { 113,3228 },
 { 114,3228 }, { 115,3228 }, { 116,3228 }, { 117,3228 }, { 118,3228 },
 { 119,3228 }, { 120,3228 }, { 121,3228 }, { 122,3228 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,3228 },
 { 129,3228 }, { 130,3228 }, { 131,3228 }, { 132,3228 }, { 133,3228 },

 { 134,3228 }, { 135,3228 }, { 136,3228 }, { 137,3228 }, { 138,3228 },
 { 139,3228 }, { 140,3228 }, { 141,3228 }, { 142,3228 }, { 143,3228 },
 { 144,3228 }, { 145,3228 }, { 146,3228 }, { 147,3228 }, { 148,3228 },
 { 149,3228 }, { 150,3228 }, { 151,3228 }, { 152,3228 }, { 153,3228 },
 { 154,3228 }, { 155,3228 }, { 156,3228 }, { 157,3228 }, { 158,3228 },
 { 159,3228 }, { 160,3228 }, { 161,3228 }, { 162,3228 }, { 163,3228 },
 { 164,3228 }, { 165,3228 }, { 166,3228 }, { 167,3228 }, { 168,3228 },
 { 169,3228 }, { 170,3228 }, { 171,3228 }, { 172,3228 }, { 173,3228 },
 { 174,3228 }, { 175,3228 }, { 176,3228 }, { 177,3228 }, { 178,3228 },
 { 179,3228 }, { 180,3228 }, { 181,3228 }, { 182,3228 }, { 183,3228 },

 { 184,3228 }, { 185,3228 }, { 186,3228 }, { 187,3228 }, { 188,3228 },
 { 189,3228 }, { 190,3228 }, { 191,3228 }, { 192,3228 }, { 193,3228 },
 { 194,3228 }, { 195,3228 }, { 196,3228 }, { 197,3228 }, { 198,3228 },
 { 199,3228 }, { 200,3228 }, { 201,3228 }, { 202,3228 }, { 203,3228 },
 { 204,3228 }, { 205,3228 }, { 206,3228 }, { 207,3228 }, { 208,3228 },
 { 209,3228 }, { 210,3228 }, { 211,3228 }, { 212,3228 }, { 213,3228 },
 { 214,3228 }, { 215,3228 }, { 216,3228 }, { 217,3228 }, { 218,3228 },
 { 219,3228 }, { 220,3228 }, { 221,3228 }, { 222,3228 }, { 223,3228 },
 { 224,3228 }, { 225,3228 }, { 226,3228 }, { 227,3228 }, { 228,3228 },
 { 229,3228 }, { 230,3228 }, { 231,3228 }, { 232,3228 }, { 233,3228 },

 { 234,3228 }, { 235,3228 }, { 236,3228 }, { 237,3228 }, { 238,3228 },
 { 239,3228 }, { 240,3228 }, { 241,3228 }, { 242,3228 }, { 243,3228 },
 { 244,3228 }, { 245,3228 }, { 246,3228 }, { 247,3228 }, { 248,3228 },
 { 249,3228 }, { 250,3228 }, { 251,3228 }, { 252,3228 }, { 253,3228 },
 { 254,3228 }, { 255,3228 }, {   0,  69 }, {   0,6304 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,2971 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,3228 }, {  49,3228 }, {  50,3228 }, {  51,3228 },
 {  52,3228 }, {  53,3228 }, {  54,3228 }, {  55,3228 }, {  56,3228 },
 {  57,3228 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,2971 }, {  66,2971 },
 {  67,2971 }, {  68,2971 }, {  69,2971 }, {  70,2971 }, {  71,2971 },
 {  72,2971 }, {  73,2971 }, {  74,2971 }, {  75,2971 }, {  76,2971 },

 {  77,2971 }, {  78,2971 }, {  79,2971 }, {  80,2971 }, {  81,2971 },
 {  82,2971 }, {  83,2971 }, {  84,2971 }, {  85,2971 }, {  86,2971 },
 {  87,2971 }, {  88,2971 }, {  89,2971 }, {  90,2971 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,2971 }, {   0,   0 },
 {  97,2971 }, {  98,2971 }, {  99,2971 }, { 100,2971 }, { 101,2971 },
 { 102,2971 }, { 103,2971 }, { 104,2971 }, { 105,2971 }, { 106,2971 },
 { 107,2971 }, { 108,2971 }, { 109,2971 }, { 110,2971 }, { 111,2971 },
 { 112,2971 }, { 113,2971 }, { 114,2971 }, { 115,2971 }, { 116,2971 },
 { 117,2971 }, { 118,2971 }, { 119,2971 }, { 120,2971 }, { 121,2971 },
 { 122,2971 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, { 128,2971 }, { 129,2971 }, { 130,2971 }, { 131,2971 },
 { 132,2971 }, { 133,2971 }, { 134,2971 }, { 135,2971 }, { 136,2971 },
 { 137,2971 }, { 138,2971 }, { 139,2971 }, { 140,2971 }, { 141,2971 },
 { 142,2971 }, { 143,2971 }, { 144,2971 }, { 145,2971 }, { 146,2971 },
 { 147,2971 }, { 148,2971 }, { 149,2971 }, { 150,2971 }, { 151,2971 },
 { 152,2971 }, { 153,2971 }, { 154,2971 }, { 155,2971 }, { 156,2971 },
 { 157,2971 }, { 158,2971 }, { 159,2971 }, { 160,2971 }, { 161,2971 },
 { 162,2971 }, { 163,2971 }, { 164,2971 }, { 165,2971 }, { 166,2971 },
 { 167,2971 }, { 168,2971 }, { 169,2971 }, { 170,2971 }, { 171,2971 },
 { 172,2971 }, { 173,2971 }, { 174,2971 }, { 175,2971 }, { 176,2971 },

 { 177,2971 }, { 178,2971 }, { 179,2971 }, { 180,2971 }, { 181,2971 },
 { 182,2971 }, { 183,2971 }, { 184,2971 }, { 185,2971 }, { 186,2971 },
 { 187,2971 }, { 188,2971 }, { 189,2971 }, { 190,2971 }, { 191,2971 },
 { 192,2971 }, { 193,2971 }, { 194,2971 }, { 195,2971 }, { 196,2971 },
 { 197,2971 }, { 198,2971 }, { 199,2971 }, { 200,2971 }, { 201,2971 },
 { 202,2971 }, { 203,2971 }, { 204,2971 }, { 205,2971 }, { 206,2971 },
 { 207,2971 }, { 208,2971 }, { 209,2971 }, { 210,2971 }, { 211,2971 },
 { 212,2971 }, { 213,2971 }, { 214,2971 }, { 215,2971 }, { 216,2971 },
 { 217,2971 }, { 218,2971 }, { 219,2971 }, { 220,2971 }, { 221,2971 },
 { 222,2971 }, { 223,2971 }, { 224,2971 }, { 225,2971 }, { 226,2971 },

 { 227,2971 }, { 228,2971 }, { 229,2971 }, { 230,2971 }, { 231,2971 },
 { 232,2971 }, { 233,2971 }, { 234,2971 }, { 235,2971 }, { 236,2971 },
 { 237,2971 }, { 238,2971 }, { 239,2971 }, { 240,2971 }, { 241,2971 },
 { 242,2971 }, { 243,2971 }, { 244,2971 }, { 245,2971 }, { 246,2971 },
 { 247,2971 }, { 248,2971 }, { 249,2971 }, { 250,2971 }, { 251,2971 },
 { 252,2971 }, { 253,2971 }, { 254,2971 }, { 255,2971 }, {   0,  69 },
 {   0,6047 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  36,-5848 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,-5848 }, {  49,-5848 },
 {  50,-5848 }, {  51,-5848 }, {  52,-5848 }, {  53,-5848 }, {  54,-5848 },
 {  55,-5848 }, {  56,-5848 }, {  57,-5848 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,-5848 }, {  66,-5848 }, {  67,-5848 }, {  68,-5848 }, {  69,-5848 },

 {  70,-5848 }, {  71,-5848 }, {  72,-5848 }, {  73,-5848 }, {  74,-5848 },
 {  75,-5848 }, {  76,-5848 }, {  77,-5848 }, {  78,-5848 }, {  79,-5848 },
 {  80,-5848 }, {  81,-5848 }, {  82,-5848 }, {  83,-5848 }, {  84,-5848 },
 {  85,-5848 }, {  86,-5848 }, {  87,-5848 }, {  88,-5848 }, {  89,-5848 },
 {  90,-5848 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,-5848 }, {   0,   0 }, {  97,-5848 }, {  98,-5848 }, {  99,-5848 },
 { 100,-5848 }, { 101,-5848 }, { 102,-5848 }, { 103,-5848 }, { 104,-5848 },
 { 105,-5848 }, { 106,-5848 }, { 107,-5848 }, { 108,-5848 }, { 109,-5848 },
 { 110,-5848 }, { 111,-5848 }, { 112,-5848 }, { 113,-5848 }, { 114,-5848 },
 { 115,-5848 }, { 116,-5848 }, { 117,-5848 }, { 118,-5848 }, { 119,-5848 },

 { 120,-5848 }, { 121,-5848 }, { 122,-5848 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,-5848 }, { 129,-5848 },
 { 130,-5848 }, { 131,-5848 }, { 132,-5848 }, { 133,-5848 }, { 134,-5848 },
 { 135,-5848 }, { 136,-5848 }, { 137,-5848 }, { 138,-5848 }, { 139,-5848 },
 { 140,-5848 }, { 141,-5848 }, { 142,-5848 }, { 143,-5848 }, { 144,-5848 },
 { 145,-5848 }, { 146,-5848 }, { 147,-5848 }, { 148,-5848 }, { 149,-5848 },
 { 150,-5848 }, { 151,-5848 }, { 152,-5848 }, { 153,-5848 }, { 154,-5848 },
 { 155,-5848 }, { 156,-5848 }, { 157,-5848 }, { 158,-5848 }, { 159,-5848 },
 { 160,-5848 }, { 161,-5848 }, { 162,-5848 }, { 163,-5848 }, { 164,-5848 },
 { 165,-5848 }, { 166,-5848 }, { 167,-5848 }, { 168,-5848 }, { 169,-5848 },

 { 170,-5848 }, { 171,-5848 }, { 172,-5848 }, { 173,-5848 }, { 174,-5848 },
 { 175,-5848 }, { 176,-5848 }, { 177,-5848 }, { 178,-5848 }, { 179,-5848 },
 { 180,-5848 }, { 181,-5848 }, { 182,-5848 }, { 183,-5848 }, { 184,-5848 },
 { 185,-5848 }, { 186,-5848 }, { 187,-5848 }, { 188,-5848 }, { 189,-5848 },
 { 190,-5848 }, { 191,-5848 }, { 192,-5848 }, { 193,-5848 }, { 194,-5848 },
 { 195,-5848 }, { 196,-5848 }, { 197,-5848 }, { 198,-5848 }, { 199,-5848 },
 { 200,-5848 }, { 201,-5848 }, { 202,-5848 }, { 203,-5848 }, { 204,-5848 },
 { 205,-5848 }, { 206,-5848 }, { 207,-5848 }, { 208,-5848 }, { 209,-5848 },
 { 210,-5848 }, { 211,-5848 }, { 212,-5848 }, { 213,-5848 }, { 214,-5848 },
 { 215,-5848 }, { 216,-5848 }, { 217,-5848 }, { 218,-5848 }, { 219,-5848 },

 { 220,-5848 }, { 221,-5848 }, { 222,-5848 }, { 223,-5848 }, { 224,-5848 },
 { 225,-5848 }, { 226,-5848 }, { 227,-5848 }, { 228,-5848 }, { 229,-5848 },
 { 230,-5848 }, { 231,-5848 }, { 232,-5848 }, { 233,-5848 }, { 234,-5848 },
 { 235,-5848 }, { 236,-5848 }, { 237,-5848 }, { 238,-5848 }, { 239,-5848 },
 { 240,-5848 }, { 241,-5848 }, { 242,-5848 }, { 243,-5848 }, { 244,-5848 },
 { 245,-5848 }, { 246,-5848 }, { 247,-5848 }, { 248,-5848 }, { 249,-5848 },
 { 250,-5848 }, { 251,-5848 }, { 252,-5848 }, { 253,-5848 }, { 254,-5848 },
 { 255,-5848 }, {   0,  69 }, {   0,5790 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,-6105 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  43,-9554 }, {   0,   0 }, {  45,-9554 }, {   0,   0 }, {   0,   0 },
 {  48,-5848 }, {  49,-5848 }, {  50,-5848 }, {  51,-5848 }, {  52,-5848 },
 {  53,-5848 }, {  54,-5848 }, {  55,-5848 }, {  56,-5848 }, {  57,-5848 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {  65,-6105 }, {  66,-6105 }, {  67,-6105 },
 {  68,-6105 }, {  69,-6105 }, {  70,-6105 }, {  71,-6105 }, {  72,-6105 },
 {  73,-6105 }, {  74,-6105 }, {  75,-6105 }, {  76,-6105 }, {  77,-6105 },
 {  78,-6105 }, {  79,-6105 }, {  80,-6105 }, {  81,-6105 }, {  82,-6105 },
 {  83,-6105 }, {  84,-6105 }, {  85,-6105 }, {  86,-6105 }, {  87,-6105 },
 {  88,-6105 }, {  89,-6105 }, {  90,-6105 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,-6105 }, {   0,   0 }, {  97,-6105 },
 {  98,-6105 }, {  99,-6105 }, { 100,-6105 }, { 101,-6105 }, { 102,-6105 },
 { 103,-6105 }, { 104,-6105 }, { 105,-6105 }, { 106,-6105 }, { 107,-6105 },
 { 108,-6105 }, { 109,-6105 }, { 110,-6105 }, { 111,-6105 }, { 112,-6105 },

 { 113,-6105 }, { 114,-6105 }, { 115,-6105 }, { 116,-6105 }, { 117,-6105 },
 { 118,-6105 }, { 119,-6105 }, { 120,-6105 }, { 121,-6105 }, { 122,-6105 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,-6105 }, { 129,-6105 }, { 130,-6105 }, { 131,-6105 }, { 132,-6105 },
 { 133,-6105 }, { 134,-6105 }, { 135,-6105 }, { 136,-6105 }, { 137,-6105 },
 { 138,-6105 }, { 139,-6105 }, { 140,-6105 }, { 141,-6105 }, { 142,-6105 },
 { 143,-6105 }, { 144,-6105 }, { 145,-6105 }, { 146,-6105 }, { 147,-6105 },
 { 148,-6105 }, { 149,-6105 }, { 150,-6105 }, { 151,-6105 }, { 152,-6105 },
 { 153,-6105 }, { 154,-6105 }, { 155,-6105 }, { 156,-6105 }, { 157,-6105 },
 { 158,-6105 }, { 159,-6105 }, { 160,-6105 }, { 161,-6105 }, { 162,-6105 },

 { 163,-6105 }, { 164,-6105 }, { 165,-6105 }, { 166,-6105 }, { 167,-6105 },
 { 168,-6105 }, { 169,-6105 }, { 170,-6105 }, { 171,-6105 }, { 172,-6105 },
 { 173,-6105 }, { 174,-6105 }, { 175,-6105 }, { 176,-6105 }, { 177,-6105 },
 { 178,-6105 }, { 179,-6105 }, { 180,-6105 }, { 181,-6105 }, { 182,-6105 },
 { 183,-6105 }, { 184,-6105 }, { 185,-6105 }, { 186,-6105 }, { 187,-6105 },
 { 188,-6105 }, { 189,-6105 }, { 190,-6105 }, { 191,-6105 }, { 192,-6105 },
 { 193,-6105 }, { 194,-6105 }, { 195,-6105 }, { 196,-6105 }, { 197,-6105 },
 { 198,-6105 }, { 199,-6105 }, { 200,-6105 }, { 201,-6105 }, { 202,-6105 },
 { 203,-6105 }, { 204,-6105 }, { 205,-6105 }, { 206,-6105 }, { 207,-6105 },
 { 208,-6105 }, { 209,-6105 }, { 210,-6105 }, { 211,-6105 }, { 212,-6105 },

 { 213,-6105 }, { 214,-6105 }, { 215,-6105 }, { 216,-6105 }, { 217,-6105 },
 { 218,-6105 }, { 219,-6105 }, { 220,-6105 }, { 221,-6105 }, { 222,-6105 },
 { 223,-6105 }, { 224,-6105 }, { 225,-6105 }, { 226,-6105 }, { 227,-6105 },
 { 228,-6105 }, { 229,-6105 }, { 230,-6105 }, { 231,-6105 }, { 232,-6105 },
 { 233,-6105 }, { 234,-6105 }, { 235,-6105 }, { 236,-6105 }, { 237,-6105 },
 { 238,-6105 }, { 239,-6105 }, { 240,-6105 }, { 241,-6105 }, { 242,-6105 },
 { 243,-6105 }, { 244,-6105 }, { 245,-6105 }, { 246,-6105 }, { 247,-6105 },
 { 248,-6105 }, { 249,-6105 }, { 250,-6105 }, { 251,-6105 }, { 252,-6105 },
 { 253,-6105 }, { 254,-6105 }, { 255,-6105 }, {   0,  69 }, {   0,5533 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  36,-6362 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,-5848 }, {  49,-5848 }, {  50,-5848 },
 {  51,-5848 }, {  52,-5848 }, {  53,-5848 }, {  54,-5848 }, {  55,-5848 },

 {  56,-5848 }, {  57,-5848 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,-6362 },
 {  66,-6362 }, {  67,-6362 }, {  68,-6362 }, {  69,-6362 }, {  70,-6362 },
 {  71,-6362 }, {  72,-6362 }, {  73,-6362 }, {  74,-6362 }, {  75,-6362 },
 {  76,-6362 }, {  77,-6362 }, {  78,-6362 }, {  79,-6362 }, {  80,-6362 },
 {  81,-6362 }, {  82,-6362 }, {  83,-6362 }, {  84,-6362 }, {  85,-6362 },
 {  86,-6362 }, {  87,-6362 }, {  88,-6362 }, {  89,-6362 }, {  90,-6362 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,-6362 },
 {   0,   0 }, {  97,-6362 }, {  98,-6362 }, {  99,-6362 }, { 100,-6362 },
 { 101,-6362 }, { 102,-6362 }, { 103,-6362 }, { 104,-6362 }, { 105,-6362 },

 { 106,-6362 }, { 107,-6362 }, { 108,-6362 }, { 109,-6362 }, { 110,-6362 },
 { 111,-6362 }, { 112,-6362 }, { 113,-6362 }, { 114,-6362 }, { 115,-6362 },
 { 116,-6362 }, { 117,-6362 }, { 118,-6362 }, { 119,-6362 }, { 120,-6362 },
 { 121,-6362 }, { 122,-6362 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 128,-6362 }, { 129,-6362 }, { 130,-6362 },
 { 131,-6362 }, { 132,-6362 }, { 133,-6362 }, { 134,-6362 }, { 135,-6362 },
 { 136,-6362 }, { 137,-6362 }, { 138,-6362 }, { 139,-6362 }, { 140,-6362 },
 { 141,-6362 }, { 142,-6362 }, { 143,-6362 }, { 144,-6362 }, { 145,-6362 },
 { 146,-6362 }, { 147,-6362 }, { 148,-6362 }, { 149,-6362 }, { 150,-6362 },
 { 151,-6362 }, { 152,-6362 }, { 153,-6362 }, { 154,-6362 }, { 155,-6362 },

 { 156,-6362 }, { 157,-6362 }, { 158,-6362 }, { 159,-6362 }, { 160,-6362 },
 { 161,-6362 }, { 162,-6362 }, { 163,-6362 }, { 164,-6362 }, { 165,-6362 },
 { 166,-6362 }, { 167,-6362 }, { 168,-6362 }, { 169,-6362 }, { 170,-6362 },
 { 171,-6362 }, { 172,-6362 }, { 173,-6362 }, { 174,-6362 }, { 175,-6362 },
 { 176,-6362 }, { 177,-6362 }, { 178,-6362 }, { 179,-6362 }, { 180,-6362 },
 { 181,-6362 }, { 182,-6362 }, { 183,-6362 }, { 184,-6362 }, { 185,-6362 },
 { 186,-6362 }, { 187,-6362 }, { 188,-6362 }, { 189,-6362 }, { 190,-6362 },
 { 191,-6362 }, { 192,-6362 }, { 193,-6362 }, { 194,-6362 }, { 195,-6362 },
 { 196,-6362 }, { 197,-6362 }, { 198,-6362 }, { 199,-6362 }, { 200,-6362 },
 { 201,-6362 }, { 202,-6362 }, { 203,-6362 }, { 204,-6362 }, { 205,-6362 },

 { 206,-6362 }, { 207,-6362 }, { 208,-6362 }, { 209,-6362 }, { 210,-6362 },
 { 211,-6362 }, { 212,-6362 }, { 213,-6362 }, { 214,-6362 }, { 215,-6362 },
 { 216,-6362 }, { 217,-6362 }, { 218,-6362 }, { 219,-6362 }, { 220,-6362 },
 { 221,-6362 }, { 222,-6362 }, { 223,-6362 }, { 224,-6362 }, { 225,-6362 },
 { 226,-6362 }, { 227,-6362 }, { 228,-6362 }, { 229,-6362 }, { 230,-6362 },
 { 231,-6362 }, { 232,-6362 }, { 233,-6362 }, { 234,-6362 }, { 235,-6362 },
 { 236,-6362 }, { 237,-6362 }, { 238,-6362 }, { 239,-6362 }, { 240,-6362 },
 { 241,-6362 }, { 242,-6362 }, { 243,-6362 }, { 244,-6362 }, { 245,-6362 },
 { 246,-6362 }, { 247,-6362 }, { 248,-6362 }, { 249,-6362 }, { 250,-6362 },
 { 251,-6362 }, { 252,-6362 }, { 253,-6362 }, { 254,-6362 }, { 255,-6362 },

 {   0,  64 }, {   0,5276 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  36,-6619 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,   0 },

 {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 },
 {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,-771 }, {  66,-771 }, {  67,-771 }, {  68,-771 },
 {  69,-514 }, {  70,-771 }, {  71,-771 }, {  72,-771 }, {  73,-771 },
 {  74,-771 }, {  75,-771 }, {  76,-771 }, {  77,-771 }, {  78,-771 },
 {  79,-771 }, {  80,-771 }, {  81,-771 }, {  82,-771 }, {  83,-771 },
 {  84,-771 }, {  85,-771 }, {  86,-771 }, {  87,-771 }, {  88,-771 },
 {  89,-771 }, {  90,-771 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95,2457 }, {   0,   0 }, {  97,-771 }, {  98,-771 },

 {  99,-771 }, { 100,-771 }, { 101,-514 }, { 102,-771 }, { 103,-771 },
 { 104,-771 }, { 105,-771 }, { 106,-771 }, { 107,-771 }, { 108,-771 },
 { 109,-771 }, { 110,-771 }, { 111,-771 }, { 112,-771 }, { 113,-771 },
 { 114,-771 }, { 115,-771 }, { 116,-771 }, { 117,-771 }, { 118,-771 },
 { 119,-771 }, { 120,-771 }, { 121,-771 }, { 122,-771 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,-771 },
 { 129,-771 }, { 130,-771 }, { 131,-771 }, { 132,-771 }, { 133,-771 },
 { 134,-771 }, { 135,-771 }, { 136,-771 }, { 137,-771 }, { 138,-771 },
 { 139,-771 }, { 140,-771 }, { 141,-771 }, { 142,-771 }, { 143,-771 },
 { 144,-771 }, { 145,-771 }, { 146,-771 }, { 147,-771 }, { 148,-771 },

 { 149,-771 }, { 150,-771 }, { 151,-771 }, { 152,-771 }, { 153,-771 },
 { 154,-771 }, { 155,-771 }, { 156,-771 }, { 157,-771 }, { 158,-771 },
 { 159,-771 }, { 160,-771 }, { 161,-771 }, { 162,-771 }, { 163,-771 },
 { 164,-771 }, { 165,-771 }, { 166,-771 }, { 167,-771 }, { 168,-771 },
 { 169,-771 }, { 170,-771 }, { 171,-771 }, { 172,-771 }, { 173,-771 },
 { 174,-771 }, { 175,-771 }, { 176,-771 }, { 177,-771 }, { 178,-771 },
 { 179,-771 }, { 180,-771 }, { 181,-771 }, { 182,-771 }, { 183,-771 },
 { 184,-771 }, { 185,-771 }, { 186,-771 }, { 187,-771 }, { 188,-771 },
 { 189,-771 }, { 190,-771 }, { 191,-771 }, { 192,-771 }, { 193,-771 },
 { 194,-771 }, { 195,-771 }, { 196,-771 }, { 197,-771 }, { 198,-771 },

 { 199,-771 }, { 200,-771 }, { 201,-771 }, { 202,-771 }, { 203,-771 },
 { 204,-771 }, { 205,-771 }, { 206,-771 }, { 207,-771 }, { 208,-771 },
 { 209,-771 }, { 210,-771 }, { 211,-771 }, { 212,-771 }, { 213,-771 },
 { 214,-771 }, { 215,-771 }, { 216,-771 }, { 217,-771 }, { 218,-771 },
 { 219,-771 }, { 220,-771 }, { 221,-771 }, { 222,-771 }, { 223,-771 },
 { 224,-771 }, { 225,-771 }, { 226,-771 }, { 227,-771 }, { 228,-771 },
 { 229,-771 }, { 230,-771 }, { 231,-771 }, { 232,-771 }, { 233,-771 },
 { 234,-771 }, { 235,-771 }, { 236,-771 }, { 237,-771 }, { 238,-771 },
 { 239,-771 }, { 240,-771 }, { 241,-771 }, { 242,-771 }, { 243,-771 },
 { 244,-771 }, { 245,-771 }, { 246,-771 }, { 247,-771 }, { 248,-771 },

 { 249,-771 }, { 250,-771 }, { 251,-771 }, { 252,-771 }, { 253,-771 },
 { 254,-771 }, { 255,-771 }, {   0,  66 }, {   0,5019 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 },
 {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 },
 {  57,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65, 257 }, {  66, 257 },
 {  67, 257 }, {  68, 257 }, {  69, 257 }, {  70, 257 }, {  71, 257 },
 {  72, 257 }, {  73, 257 }, {  74, 257 }, {  75, 257 }, {  76, 257 },
 {  77, 257 }, {  78, 257 }, {  79, 257 }, {  80, 257 }, {  81, 257 },
 {  82, 257 }, {  83, 257 }, {  84, 257 }, {  85, 257 }, {  86, 257 },
 {  87, 257 }, {  88, 257 }, {  89, 257 }, {  90, 257 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95, 514 }, {   0,   0 },
 {  97, 257 }, {  98, 257 }, {  99, 257 }, { 100, 257 }, { 101, 257 },
 { 102, 257 }, { 103, 257 }, { 104, 257 }, { 105, 257 }, { 106, 257 },
 { 107, 257 }, { 108, 257 }, { 109, 257 }, { 110, 257 }, { 111, 257 },
 { 112, 257 }, { 113, 257 }, { 114, 257 }, { 115, 257 }, { 116, 257 },
 { 117, 257 }, { 118, 257 }, { 119, 257 }, { 120, 257 }, { 121, 257 },
 { 122, 257 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 128, 257 }, { 129, 257 }, { 130, 257 }, { 131, 257 },
 { 132, 257 }, { 133, 257 }, { 134, 257 }, { 135, 257 }, { 136, 257 },
 { 137, 257 }, { 138, 257 }, { 139, 257 }, { 140, 257 }, { 141, 257 },

 { 142, 257 }, { 143, 257 }, { 144, 257 }, { 145, 257 }, { 146, 257 },
 { 147, 257 }, { 148, 257 }, { 149, 257 }, { 150, 257 }, { 151, 257 },
 { 152, 257 }, { 153, 257 }, { 154, 257 }, { 155, 257 }, { 156, 257 },
 { 157, 257 }, { 158, 257 }, { 159, 257 }, { 160, 257 }, { 161, 257 },
 { 162, 257 }, { 163, 257 }, { 164, 257 }, { 165, 257 }, { 166, 257 },
 { 167, 257 }, { 168, 257 }, { 169, 257 }, { 170, 257 }, { 171, 257 },
 { 172, 257 }, { 173, 257 }, { 174, 257 }, { 175, 257 }, { 176, 257 },
 { 177, 257 }, { 178, 257 }, { 179, 257 }, { 180, 257 }, { 181, 257 },
 { 182, 257 }, { 183, 257 }, { 184, 257 }, { 185, 257 }, { 186, 257 },
 { 187, 257 }, { 188, 257 }, { 189, 257 }, { 190, 257 }, { 191, 257 },

 { 192, 257 }, { 193, 257 }, { 194, 257 }, { 195, 257 }, { 196, 257 },
 { 197, 257 }, { 198, 257 }, { 199, 257 }, { 200, 257 }, { 201, 257 },
 { 202, 257 }, { 203, 257 }, { 204, 257 }, { 205, 257 }, { 206, 257 },
 { 207, 257 }, { 208, 257 }, { 209, 257 }, { 210, 257 }, { 211, 257 },
 { 212, 257 }, { 213, 257 }, { 214, 257 }, { 215, 257 }, { 216, 257 },
 { 217, 257 }, { 218, 257 }, { 219, 257 }, { 220, 257 }, { 221, 257 },
 { 222, 257 }, { 223, 257 }, { 224, 257 }, { 225, 257 }, { 226, 257 },
 { 227, 257 }, { 228, 257 }, { 229, 257 }, { 230, 257 }, { 231, 257 },
 { 232, 257 }, { 233, 257 }, { 234, 257 }, { 235, 257 }, { 236, 257 },
 { 237, 257 }, { 238, 257 }, { 239, 257 }, { 240, 257 }, { 241, 257 },

 { 242, 257 }, { 243, 257 }, { 244, 257 }, { 245, 257 }, { 246, 257 },
 { 247, 257 }, { 248, 257 }, { 249, 257 }, { 250, 257 }, { 251, 257 },
 { 252, 257 }, { 253, 257 }, { 254, 257 }, { 255, 257 }, {   0,  70 },
 {   0,4762 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {  36,2200 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,2200 }, {  49,2200 },
 {  50,2200 }, {  51,2200 }, {  52,2200 }, {  53,2200 }, {  54,2200 },
 {  55,2200 }, {  56,2200 }, {  57,2200 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,2200 }, {  66,2200 }, {  67,2200 }, {  68,2200 }, {  69,2200 },
 {  70,2200 }, {  71,2200 }, {  72,2200 }, {  73,2200 }, {  74,2200 },
 {  75,2200 }, {  76,2200 }, {  77,2200 }, {  78,2200 }, {  79,2200 },
 {  80,2200 }, {  81,2200 }, {  82,2200 }, {  83,2200 }, {  84,2200 },

 {  85,2200 }, {  86,2200 }, {  87,2200 }, {  88,2200 }, {  89,2200 },
 {  90,2200 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,2200 }, {   0,   0 }, {  97,2200 }, {  98,2200 }, {  99,2200 },
 { 100,2200 }, { 101,2200 }, { 102,2200 }, { 103,2200 }, { 104,2200 },
 { 105,2200 }, { 106,2200 }, { 107,2200 }, { 108,2200 }, { 109,2200 },
 { 110,2200 }, { 111,2200 }, { 112,2200 }, { 113,2200 }, { 114,2200 },
 { 115,2200 }, { 116,2200 }, { 117,2200 }, { 118,2200 }, { 119,2200 },
 { 120,2200 }, { 121,2200 }, { 122,2200 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,2200 }, { 129,2200 },
 { 130,2200 }, { 131,2200 }, { 132,2200 }, { 133,2200 }, { 134,2200 },

 { 135,2200 }, { 136,2200 }, { 137,2200 }, { 138,2200 }, { 139,2200 },
 { 140,2200 }, { 141,2200 }, { 142,2200 }, { 143,2200 }, { 144,2200 },
 { 145,2200 }, { 146,2200 }, { 147,2200 }, { 148,2200 }, { 149,2200 },
 { 150,2200 }, { 151,2200 }, { 152,2200 }, { 153,2200 }, { 154,2200 },
 { 155,2200 }, { 156,2200 }, { 157,2200 }, { 158,2200 }, { 159,2200 },
 { 160,2200 }, { 161,2200 }, { 162,2200 }, { 163,2200 }, { 164,2200 },
 { 165,2200 }, { 166,2200 }, { 167,2200 }, { 168,2200 }, { 169,2200 },
 { 170,2200 }, { 171,2200 }, { 172,2200 }, { 173,2200 }, { 174,2200 },
 { 175,2200 }, { 176,2200 }, { 177,2200 }, { 178,2200 }, { 179,2200 },
 { 180,2200 }, { 181,2200 }, { 182,2200 }, { 183,2200 }, { 184,2200 },

 { 185,2200 }, { 186,2200 }, { 187,2200 }, { 188,2200 }, { 189,2200 },
 { 190,2200 }, { 191,2200 }, { 192,2200 }, { 193,2200 }, { 194,2200 },
 { 195,2200 }, { 196,2200 }, { 197,2200 }, { 198,2200 }, { 199,2200 },
 { 200,2200 }, { 201,2200 }, { 202,2200 }, { 203,2200 }, { 204,2200 },
 { 205,2200 }, { 206,2200 }, { 207,2200 }, { 208,2200 }, { 209,2200 },
 { 210,2200 }, { 211,2200 }, { 212,2200 }, { 213,2200 }, { 214,2200 },
 { 215,2200 }, { 216,2200 }, { 217,2200 }, { 218,2200 }, { 219,2200 },
 { 220,2200 }, { 221,2200 }, { 222,2200 }, { 223,2200 }, { 224,2200 },
 { 225,2200 }, { 226,2200 }, { 227,2200 }, { 228,2200 }, { 229,2200 },
 { 230,2200 }, { 231,2200 }, { 232,2200 }, { 233,2200 }, { 234,2200 },

 { 235,2200 }, { 236,2200 }, { 237,2200 }, { 238,2200 }, { 239,2200 },
 { 240,2200 }, { 241,2200 }, { 242,2200 }, { 243,2200 }, { 244,2200 },
 { 245,2200 }, { 246,2200 }, { 247,2200 }, { 248,2200 }, { 249,2200 },
 { 250,2200 }, { 251,2200 }, { 252,2200 }, { 253,2200 }, { 254,2200 },
 { 255,2200 }, {   0,  70 }, {   0,4505 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,1943 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,2200 }, {  49,2200 }, {  50,2200 }, {  51,2200 }, {  52,2200 },
 {  53,2200 }, {  54,2200 }, {  55,2200 }, {  56,2200 }, {  57,2200 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,1943 }, {  66,1943 }, {  67,1943 },
 {  68,1943 }, {  69,1943 }, {  70,1943 }, {  71,1943 }, {  72,1943 },
 {  73,1943 }, {  74,1943 }, {  75,1943 }, {  76,1943 }, {  77,1943 },

 {  78,1943 }, {  79,1943 }, {  80,1943 }, {  81,1943 }, {  82,1943 },
 {  83,1943 }, {  84,1943 }, {  85,1943 }, {  86,1943 }, {  87,1943 },
 {  88,1943 }, {  89,1943 }, {  90,1943 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,1943 }, {   0,   0 }, {  97,1943 },
 {  98,1943 }, {  99,1943 }, { 100,1943 }, { 101,1943 }, { 102,1943 },
 { 103,1943 }, { 104,1943 }, { 105,1943 }, { 106,1943 }, { 107,1943 },
 { 108,1943 }, { 109,1943 }, { 110,1943 }, { 111,1943 }, { 112,1943 },
 { 113,1943 }, { 114,1943 }, { 115,1943 }, { 116,1943 }, { 117,1943 },
 { 118,1943 }, { 119,1943 }, { 120,1943 }, { 121,1943 }, { 122,1943 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 { 128,1943 }, { 129,1943 }, { 130,1943 }, { 131,1943 }, { 132,1943 },
 { 133,1943 }, { 134,1943 }, { 135,1943 }, { 136,1943 }, { 137,1943 },
 { 138,1943 }, { 139,1943 }, { 140,1943 }, { 141,1943 }, { 142,1943 },
 { 143,1943 }, { 144,1943 }, { 145,1943 }, { 146,1943 }, { 147,1943 },
 { 148,1943 }, { 149,1943 }, { 150,1943 }, { 151,1943 }, { 152,1943 },
 { 153,1943 }, { 154,1943 }, { 155,1943 }, { 156,1943 }, { 157,1943 },
 { 158,1943 }, { 159,1943 }, { 160,1943 }, { 161,1943 }, { 162,1943 },
 { 163,1943 }, { 164,1943 }, { 165,1943 }, { 166,1943 }, { 167,1943 },
 { 168,1943 }, { 169,1943 }, { 170,1943 }, { 171,1943 }, { 172,1943 },
 { 173,1943 }, { 174,1943 }, { 175,1943 }, { 176,1943 }, { 177,1943 },

 { 178,1943 }, { 179,1943 }, { 180,1943 }, { 181,1943 }, { 182,1943 },
 { 183,1943 }, { 184,1943 }, { 185,1943 }, { 186,1943 }, { 187,1943 },
 { 188,1943 }, { 189,1943 }, { 190,1943 }, { 191,1943 }, { 192,1943 },
 { 193,1943 }, { 194,1943 }, { 195,1943 }, { 196,1943 }, { 197,1943 },
 { 198,1943 }, { 199,1943 }, { 200,1943 }, { 201,1943 }, { 202,1943 },
 { 203,1943 }, { 204,1943 }, { 205,1943 }, { 206,1943 }, { 207,1943 },
 { 208,1943 }, { 209,1943 }, { 210,1943 }, { 211,1943 }, { 212,1943 },
 { 213,1943 }, { 214,1943 }, { 215,1943 }, { 216,1943 }, { 217,1943 },
 { 218,1943 }, { 219,1943 }, { 220,1943 }, { 221,1943 }, { 222,1943 },
 { 223,1943 }, { 224,1943 }, { 225,1943 }, { 226,1943 }, { 227,1943 },

 { 228,1943 }, { 229,1943 }, { 230,1943 }, { 231,1943 }, { 232,1943 },
 { 233,1943 }, { 234,1943 }, { 235,1943 }, { 236,1943 }, { 237,1943 },
 { 238,1943 }, { 239,1943 }, { 240,1943 }, { 241,1943 }, { 242,1943 },
 { 243,1943 }, { 244,1943 }, { 245,1943 }, { 246,1943 }, { 247,1943 },
 { 248,1943 }, { 249,1943 }, { 250,1943 }, { 251,1943 }, { 252,1943 },
 { 253,1943 }, { 254,1943 }, { 255,1943 }, {   0,  68 }, {   0,4248 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  36,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 },
 {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 },
 {  56,   0 }, {  57,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,   0 },
 {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 },

 {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 },
 {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 },
 {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 },
 {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,   0 },
 {   0,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 },
 { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 },
 { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 },
 { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 },
 { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 },

 { 121,   0 }, { 122,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 },
 { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 },
 { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 },
 { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 },
 { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 },
 { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 },
 { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 },
 { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 },
 { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 },

 { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 },
 { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 },
 { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 },
 { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 },
 { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 },
 { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 },
 { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 },
 { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 },
 { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 },
 { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 },

 { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 },
 { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 },
 { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 },
 { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 },
 { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 },
 { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 },
 { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 },
 {   0,  66 }, {   0,3991 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  36,-257 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,   0 },
 {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 },
 {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {  65,1943 }, {  66,1943 }, {  67,1943 }, {  68,1943 },
 {  69,1943 }, {  70,1943 }, {  71,1943 }, {  72,1943 }, {  73,1943 },
 {  74,1943 }, {  75,1943 }, {  76,1943 }, {  77,1943 }, {  78,1943 },
 {  79,1943 }, {  80,1943 }, {  81,1943 }, {  82,1943 }, {  83,1943 },
 {  84,1943 }, {  85,1943 }, {  86,1943 }, {  87,1943 }, {  88,1943 },
 {  89,1943 }, {  90,1943 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95,2200 }, {   0,   0 }, {  97,1943 }, {  98,1943 },
 {  99,1943 }, { 100,1943 }, { 101,1943 }, { 102,1943 }, { 103,1943 },
 { 104,1943 }, { 105,1943 }, { 106,1943 }, { 107,1943 }, { 108,1943 },
 { 109,1943 }, { 110,1943 }, { 111,1943 }, { 112,1943 }, { 113,1943 },

 { 114,1943 }, { 115,1943 }, { 116,1943 }, { 117,1943 }, { 118,1943 },
 { 119,1943 }, { 120,1943 }, { 121,1943 }, { 122,1943 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,1943 },
 { 129,1943 }, { 130,1943 }, { 131,1943 }, { 132,1943 }, { 133,1943 },
 { 134,1943 }, { 135,1943 }, { 136,1943 }, { 137,1943 }, { 138,1943 },
 { 139,1943 }, { 140,1943 }, { 141,1943 }, { 142,1943 }, { 143,1943 },
 { 144,1943 }, { 145,1943 }, { 146,1943 }, { 147,1943 }, { 148,1943 },
 { 149,1943 }, { 150,1943 }, { 151,1943 }, { 152,1943 }, { 153,1943 },
 { 154,1943 }, { 155,1943 }, { 156,1943 }, { 157,1943 }, { 158,1943 },
 { 159,1943 }, { 160,1943 }, { 161,1943 }, { 162,1943 }, { 163,1943 },

 { 164,1943 }, { 165,1943 }, { 166,1943 }, { 167,1943 }, { 168,1943 },
 { 169,1943 }, { 170,1943 }, { 171,1943 }, { 172,1943 }, { 173,1943 },
 { 174,1943 }, { 175,1943 }, { 176,1943 }, { 177,1943 }, { 178,1943 },
 { 179,1943 }, { 180,1943 }, { 181,1943 }, { 182,1943 }, { 183,1943 },
 { 184,1943 }, { 185,1943 }, { 186,1943 }, { 187,1943 }, { 188,1943 },
 { 189,1943 }, { 190,1943 }, { 191,1943 }, { 192,1943 }, { 193,1943 },
 { 194,1943 }, { 195,1943 }, { 196,1943 }, { 197,1943 }, { 198,1943 },
 { 199,1943 }, { 200,1943 }, { 201,1943 }, { 202,1943 }, { 203,1943 },
 { 204,1943 }, { 205,1943 }, { 206,1943 }, { 207,1943 }, { 208,1943 },
 { 209,1943 }, { 210,1943 }, { 211,1943 }, { 212,1943 }, { 213,1943 },

 { 214,1943 }, { 215,1943 }, { 216,1943 }, { 217,1943 }, { 218,1943 },
 { 219,1943 }, { 220,1943 }, { 221,1943 }, { 222,1943 }, { 223,1943 },
 { 224,1943 }, { 225,1943 }, { 226,1943 }, { 227,1943 }, { 228,1943 },
 { 229,1943 }, { 230,1943 }, { 231,1943 }, { 232,1943 }, { 233,1943 },
 { 234,1943 }, { 235,1943 }, { 236,1943 }, { 237,1943 }, { 238,1943 },
 { 239,1943 }, { 240,1943 }, { 241,1943 }, { 242,1943 }, { 243,1943 },
 { 244,1943 }, { 245,1943 }, { 246,1943 }, { 247,1943 }, { 248,1943 },
 { 249,1943 }, { 250,1943 }, { 251,1943 }, { 252,1943 }, { 253,1943 },
 { 254,1943 }, { 255,1943 }, {   0,  18 }, {   0,3734 }, {   1,-4306 },
 {   2,-4306 }, {   3,-4306 }, {   4,-4306 }, {   5,-4306 }, {   6,-4306 },

 {   7,-4306 }, {   8,-4306 }, {   9,-4048 }, {  10,-3790 }, {  11,-4048 },
 {  12,-4048 }, {  13,-3790 }, {  14,-4306 }, {  15,-4306 }, {  16,-4306 },
 {  17,-4306 }, {  18,-4306 }, {  19,-4306 }, {  20,-4306 }, {  21,-4306 },
 {  22,-4306 }, {  23,-4306 }, {  24,-4306 }, {  25,-4306 }, {  26,-4306 },
 {  27,-4306 }, {  28,-4306 }, {  29,-4306 }, {  30,-4306 }, {  31,-4306 },
 {  32,-4048 }, {  33,-4306 }, {  34,-4306 }, {  35,-4306 }, {  36,-4306 },
 {  37,-4306 }, {  38,-4306 }, {  39,-4306 }, {  40,-4306 }, {  41,-4306 },
 {  42,-4306 }, {  43,-4306 }, {  44,-4306 }, {  45,   0 }, {  46,-4306 },
 {  47,-4306 }, {  48,-4306 }, {  49,-4306 }, {  50,-4306 }, {  51,-4306 },
 {  52,-4306 }, {  53,-4306 }, {  54,-4306 }, {  55,-4306 }, {  56,-4306 },

 {  57,-4306 }, {  58,-4306 }, {  59,-4306 }, {  60,-4306 }, {  61,-4306 },
 {  62,-4306 }, {  63,-4306 }, {  64,-4306 }, {  65,-4306 }, {  66,-4306 },
 {  67,-4306 }, {  68,-4306 }, {  69,-4306 }, {  70,-4306 }, {  71,-4306 },
 {  72,-4306 }, {  73,-4306 }, {  74,-4306 }, {  75,-4306 }, {  76,-4306 },
 {  77,-4306 }, {  78,-4306 }, {  79,-4306 }, {  80,-4306 }, {  81,-4306 },
 {  82,-4306 }, {  83,-4306 }, {  84,-4306 }, {  85,-4306 }, {  86,-4306 },
 {  87,-4306 }, {  88,-4306 }, {  89,-4306 }, {  90,-4306 }, {  91,-4306 },
 {  92,-4306 }, {  93,-4306 }, {  94,-4306 }, {  95,-4306 }, {  96,-4306 },
 {  97,-4306 }, {  98,-4306 }, {  99,-4306 }, { 100,-4306 }, { 101,-4306 },
 { 102,-4306 }, { 103,-4306 }, { 104,-4306 }, { 105,-4306 }, { 106,-4306 },

 { 107,-4306 }, { 108,-4306 }, { 109,-4306 }, { 110,-4306 }, { 111,-4306 },
 { 112,-4306 }, { 113,-4306 }, { 114,-4306 }, { 115,-4306 }, { 116,-4306 },
 { 117,-4306 }, { 118,-4306 }, { 119,-4306 }, { 120,-4306 }, { 121,-4306 },
 { 122,-4306 }, { 123,-4306 }, { 124,-4306 }, { 125,-4306 }, { 126,-4306 },
 { 127,-4306 }, { 128,-4306 }, { 129,-4306 }, { 130,-4306 }, { 131,-4306 },
 { 132,-4306 }, { 133,-4306 }, { 134,-4306 }, { 135,-4306 }, { 136,-4306 },
 { 137,-4306 }, { 138,-4306 }, { 139,-4306 }, { 140,-4306 }, { 141,-4306 },
 { 142,-4306 }, { 143,-4306 }, { 144,-4306 }, { 145,-4306 }, { 146,-4306 },
 { 147,-4306 }, { 148,-4306 }, { 149,-4306 }, { 150,-4306 }, { 151,-4306 },
 { 152,-4306 }, { 153,-4306 }, { 154,-4306 }, { 155,-4306 }, { 156,-4306 },

 { 157,-4306 }, { 158,-4306 }, { 159,-4306 }, { 160,-4306 }, { 161,-4306 },
 { 162,-4306 }, { 163,-4306 }, { 164,-4306 }, { 165,-4306 }, { 166,-4306 },
 { 167,-4306 }, { 168,-4306 }, { 169,-4306 }, { 170,-4306 }, { 171,-4306 },
 { 172,-4306 }, { 173,-4306 }, { 174,-4306 }, { 175,-4306 }, { 176,-4306 },
 { 177,-4306 }, { 178,-4306 }, { 179,-4306 }, { 180,-4306 }, { 181,-4306 },
 { 182,-4306 }, { 183,-4306 }, { 184,-4306 }, { 185,-4306 }, { 186,-4306 },
 { 187,-4306 }, { 188,-4306 }, { 189,-4306 }, { 190,-4306 }, { 191,-4306 },
 { 192,-4306 }, { 193,-4306 }, { 194,-4306 }, { 195,-4306 }, { 196,-4306 },
 { 197,-4306 }, { 198,-4306 }, { 199,-4306 }, { 200,-4306 }, { 201,-4306 },
 { 202,-4306 }, { 203,-4306 }, { 204,-4306 }, { 205,-4306 }, { 206,-4306 },

 { 207,-4306 }, { 208,-4306 }, { 209,-4306 }, { 210,-4306 }, { 211,-4306 },
 { 212,-4306 }, { 213,-4306 }, { 214,-4306 }, { 215,-4306 }, { 216,-4306 },
 { 217,-4306 }, { 218,-4306 }, { 219,-4306 }, { 220,-4306 }, { 221,-4306 },
 { 222,-4306 }, { 223,-4306 }, { 224,-4306 }, { 225,-4306 }, { 226,-4306 },
 { 227,-4306 }, { 228,-4306 }, { 229,-4306 }, { 230,-4306 }, { 231,-4306 },
 { 232,-4306 }, { 233,-4306 }, { 234,-4306 }, { 235,-4306 }, { 236,-4306 },
 { 237,-4306 }, { 238,-4306 }, { 239,-4306 }, { 240,-4306 }, { 241,-4306 },
 { 242,-4306 }, { 243,-4306 }, { 244,-4306 }, { 245,-4306 }, { 246,-4306 },
 { 247,-4306 }, { 248,-4306 }, { 249,-4306 }, { 250,-4306 }, { 251,-4306 },
 { 252,-4306 }, { 253,-4306 }, { 254,-4306 }, { 255,-4306 }, { 256,-4306 },

 {   0,  27 }, {   0,3476 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  27 }, {   0,3453 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,1942 },

 {  49,1942 }, {  50,1942 }, {  51,1942 }, {  52,1942 }, {  53,1942 },
 {  54,1942 }, {  55,1942 }, {  56,1942 }, {  57,1942 }, {   0,   0 },
 {   0,   0 }, {   0,  27 }, {   0,3415 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,1942 }, {  66,1942 }, {  67,1942 }, {  68,1942 },
 {  69,1942 }, {  70,1942 }, {  48,-26816 }, {  49,-26816 }, {  50,-26816 },
 {  51,-26816 }, {  52,-26816 }, {  53,-26816 }, {  54,-26816 }, {  55,-26816 },
 {  56,-26816 }, {  57,-26816 }, {   0,   0 }, {   0,   0 }, {   0,  27 },
 {   0,3392 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,-26816 },
 {  66,-26816 }, {  67,-26816 }, {  68,-26816 }, {  69,-26816 }, {  70,-26816 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97,1942 }, {  98,1942 },

 {  99,1942 }, { 100,1942 }, { 101,1942 }, { 102,1942 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,1904 }, {  49,1904 }, {  50,1904 }, {  51,1904 }, {  52,1904 },
 {  53,1904 }, {  54,1904 }, {  55,1904 }, {  56,1904 }, {  57,1904 },
 {   0,   0 }, {  97,-26816 }, {  98,-26816 }, {  99,-26816 }, { 100,-26816 },
 { 101,-26816 }, { 102,-26816 }, {  65,1904 }, {  66,1904 }, {  67,1904 },
 {  68,1904 }, {  69,1904 }, {  70,1904 }, {  48,-26875 }, {  49,-26875 },
 {  50,-26875 }, {  51,-26875 }, {  52,-26875 }, {  53,-26875 }, {  54,-26875 },
 {  55,-26875 }, {  56,-26875 }, {  57,-26875 }, {   0,  69 }, {   0,3333 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {  65,-26875 }, {  66,-26875 }, {  67,-26875 }, {  68,-26875 }, {  69,-26875 },
 {  70,-26875 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97,1904 },
 {  98,1904 }, {  99,1904 }, { 100,1904 }, { 101,1904 }, { 102,1904 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  36,   0 }, {   0,   0 }, {  97,-26875 }, {  98,-26875 }, {  99,-26875 },
 { 100,-26875 }, { 101,-26875 }, { 102,-26875 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 },
 {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 },

 {  56,   0 }, {  57,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,   0 },
 {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 },
 {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 },
 {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 },
 {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 },
 {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,   0 },
 {   0,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 },
 { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 },

 { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 },
 { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 },
 { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 },
 { 121,   0 }, { 122,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 },
 { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 },
 { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 },
 { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 },
 { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 },
 { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 },

 { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 },
 { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 },
 { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 },
 { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 },
 { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 },
 { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 },
 { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 },
 { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 },
 { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 },
 { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 },

 { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 },
 { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 },
 { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 },
 { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 },
 { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 },
 { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 },
 { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 },
 { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 },
 { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 },
 { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 },

 {   0,  66 }, {   0,3076 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  36,-257 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,   0 },

 {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 },
 {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,1624 }, {  66,1624 }, {  67,1624 }, {  68,1624 },
 {  69,1624 }, {  70,1624 }, {  71,1624 }, {  72,1624 }, {  73,1624 },
 {  74,1624 }, {  75,1624 }, {  76,1624 }, {  77,1624 }, {  78,1624 },
 {  79,1624 }, {  80,1624 }, {  81,1624 }, {  82,1624 }, {  83,1624 },
 {  84,1624 }, {  85,1624 }, {  86,1624 }, {  87,1624 }, {  88,1624 },
 {  89,1624 }, {  90,1624 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95,1881 }, {   0,   0 }, {  97,1624 }, {  98,1624 },

 {  99,1624 }, { 100,1624 }, { 101,1624 }, { 102,1624 }, { 103,1624 },
 { 104,1624 }, { 105,1624 }, { 106,1624 }, { 107,1624 }, { 108,1624 },
 { 109,1624 }, { 110,1624 }, { 111,1624 }, { 112,1624 }, { 113,1624 },
 { 114,1624 }, { 115,1624 }, { 116,1624 }, { 117,1624 }, { 118,1624 },
 { 119,1624 }, { 120,1624 }, { 121,1624 }, { 122,1624 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,1624 },
 { 129,1624 }, { 130,1624 }, { 131,1624 }, { 132,1624 }, { 133,1624 },
 { 134,1624 }, { 135,1624 }, { 136,1624 }, { 137,1624 }, { 138,1624 },
 { 139,1624 }, { 140,1624 }, { 141,1624 }, { 142,1624 }, { 143,1624 },
 { 144,1624 }, { 145,1624 }, { 146,1624 }, { 147,1624 }, { 148,1624 },

 { 149,1624 }, { 150,1624 }, { 151,1624 }, { 152,1624 }, { 153,1624 },
 { 154,1624 }, { 155,1624 }, { 156,1624 }, { 157,1624 }, { 158,1624 },
 { 159,1624 }, { 160,1624 }, { 161,1624 }, { 162,1624 }, { 163,1624 },
 { 164,1624 }, { 165,1624 }, { 166,1624 }, { 167,1624 }, { 168,1624 },
 { 169,1624 }, { 170,1624 }, { 171,1624 }, { 172,1624 }, { 173,1624 },
 { 174,1624 }, { 175,1624 }, { 176,1624 }, { 177,1624 }, { 178,1624 },
 { 179,1624 }, { 180,1624 }, { 181,1624 }, { 182,1624 }, { 183,1624 },
 { 184,1624 }, { 185,1624 }, { 186,1624 }, { 187,1624 }, { 188,1624 },
 { 189,1624 }, { 190,1624 }, { 191,1624 }, { 192,1624 }, { 193,1624 },
 { 194,1624 }, { 195,1624 }, { 196,1624 }, { 197,1624 }, { 198,1624 },

 { 199,1624 }, { 200,1624 }, { 201,1624 }, { 202,1624 }, { 203,1624 },
 { 204,1624 }, { 205,1624 }, { 206,1624 }, { 207,1624 }, { 208,1624 },
 { 209,1624 }, { 210,1624 }, { 211,1624 }, { 212,1624 }, { 213,1624 },
 { 214,1624 }, { 215,1624 }, { 216,1624 }, { 217,1624 }, { 218,1624 },
 { 219,1624 }, { 220,1624 }, { 221,1624 }, { 222,1624 }, { 223,1624 },
 { 224,1624 }, { 225,1624 }, { 226,1624 }, { 227,1624 }, { 228,1624 },
 { 229,1624 }, { 230,1624 }, { 231,1624 }, { 232,1624 }, { 233,1624 },
 { 234,1624 }, { 235,1624 }, { 236,1624 }, { 237,1624 }, { 238,1624 },
 { 239,1624 }, { 240,1624 }, { 241,1624 }, { 242,1624 }, { 243,1624 },
 { 244,1624 }, { 245,1624 }, { 246,1624 }, { 247,1624 }, { 248,1624 },

 { 249,1624 }, { 250,1624 }, { 251,1624 }, { 252,1624 }, { 253,1624 },
 { 254,1624 }, { 255,1624 }, {   0,  69 }, {   0,2819 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,-9076 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,-2457 }, {  49,-2457 }, {  50,-2457 }, {  51,-2457 },
 {  52,-2457 }, {  53,-2457 }, {  54,-2457 }, {  55,-2457 }, {  56,-2457 },
 {  57,-2457 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,-9076 }, {  66,-9076 },
 {  67,-9076 }, {  68,-9076 }, {  69,-9076 }, {  70,-9076 }, {  71,-9076 },
 {  72,-9076 }, {  73,-9076 }, {  74,-9076 }, {  75,-9076 }, {  76,-9076 },
 {  77,-9076 }, {  78,-9076 }, {  79,-9076 }, {  80,-9076 }, {  81,-9076 },
 {  82,-9076 }, {  83,-9076 }, {  84,-9076 }, {  85,-9076 }, {  86,-9076 },
 {  87,-9076 }, {  88,-9076 }, {  89,-9076 }, {  90,-9076 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,-9076 }, {   0,   0 },
 {  97,-9076 }, {  98,-9076 }, {  99,-9076 }, { 100,-9076 }, { 101,-9076 },
 { 102,-9076 }, { 103,-9076 }, { 104,-9076 }, { 105,-9076 }, { 106,-9076 },
 { 107,-9076 }, { 108,-9076 }, { 109,-9076 }, { 110,-9076 }, { 111,-9076 },
 { 112,-9076 }, { 113,-9076 }, { 114,-9076 }, { 115,-9076 }, { 116,-9076 },
 { 117,-9076 }, { 118,-9076 }, { 119,-9076 }, { 120,-9076 }, { 121,-9076 },
 { 122,-9076 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 128,-9076 }, { 129,-9076 }, { 130,-9076 }, { 131,-9076 },
 { 132,-9076 }, { 133,-9076 }, { 134,-9076 }, { 135,-9076 }, { 136,-9076 },
 { 137,-9076 }, { 138,-9076 }, { 139,-9076 }, { 140,-9076 }, { 141,-9076 },

 { 142,-9076 }, { 143,-9076 }, { 144,-9076 }, { 145,-9076 }, { 146,-9076 },
 { 147,-9076 }, { 148,-9076 }, { 149,-9076 }, { 150,-9076 }, { 151,-9076 },
 { 152,-9076 }, { 153,-9076 }, { 154,-9076 }, { 155,-9076 }, { 156,-9076 },
 { 157,-9076 }, { 158,-9076 }, { 159,-9076 }, { 160,-9076 }, { 161,-9076 },
 { 162,-9076 }, { 163,-9076 }, { 164,-9076 }, { 165,-9076 }, { 166,-9076 },
 { 167,-9076 }, { 168,-9076 }, { 169,-9076 }, { 170,-9076 }, { 171,-9076 },
 { 172,-9076 }, { 173,-9076 }, { 174,-9076 }, { 175,-9076 }, { 176,-9076 },
 { 177,-9076 }, { 178,-9076 }, { 179,-9076 }, { 180,-9076 }, { 181,-9076 },
 { 182,-9076 }, { 183,-9076 }, { 184,-9076 }, { 185,-9076 }, { 186,-9076 },
 { 187,-9076 }, { 188,-9076 }, { 189,-9076 }, { 190,-9076 }, { 191,-9076 },

 { 192,-9076 }, { 193,-9076 }, { 194,-9076 }, { 195,-9076 }, { 196,-9076 },
 { 197,-9076 }, { 198,-9076 }, { 199,-9076 }, { 200,-9076 }, { 201,-9076 },
 { 202,-9076 }, { 203,-9076 }, { 204,-9076 }, { 205,-9076 }, { 206,-9076 },
 { 207,-9076 }, { 208,-9076 }, { 209,-9076 }, { 210,-9076 }, { 211,-9076 },
 { 212,-9076 }, { 213,-9076 }, { 214,-9076 }, { 215,-9076 }, { 216,-9076 },
 { 217,-9076 }, { 218,-9076 }, { 219,-9076 }, { 220,-9076 }, { 221,-9076 },
 { 222,-9076 }, { 223,-9076 }, { 224,-9076 }, { 225,-9076 }, { 226,-9076 },
 { 227,-9076 }, { 228,-9076 }, { 229,-9076 }, { 230,-9076 }, { 231,-9076 },
 { 232,-9076 }, { 233,-9076 }, { 234,-9076 }, { 235,-9076 }, { 236,-9076 },
 { 237,-9076 }, { 238,-9076 }, { 239,-9076 }, { 240,-9076 }, { 241,-9076 },

 { 242,-9076 }, { 243,-9076 }, { 244,-9076 }, { 245,-9076 }, { 246,-9076 },
 { 247,-9076 }, { 248,-9076 }, { 249,-9076 }, { 250,-9076 }, { 251,-9076 },
 { 252,-9076 }, { 253,-9076 }, { 254,-9076 }, { 255,-9076 }, {   0,  70 },
 {   0,2562 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {  36,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,   0 }, {  49,   0 },
 {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 },
 {  55,   0 }, {  56,   0 }, {  57,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,   0 }, {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 },
 {  70,   0 }, {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 },
 {  75,   0 }, {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 },
 {  80,   0 }, {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 },

 {  85,   0 }, {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 },
 {  90,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,   0 }, {   0,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 },
 { 100,   0 }, { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 },
 { 105,   0 }, { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 },
 { 110,   0 }, { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 },
 { 115,   0 }, { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 },
 { 120,   0 }, { 121,   0 }, { 122,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,   0 }, { 129,   0 },
 { 130,   0 }, { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 },

 { 135,   0 }, { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 },
 { 140,   0 }, { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 },
 { 145,   0 }, { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 },
 { 150,   0 }, { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 },
 { 155,   0 }, { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 },
 { 160,   0 }, { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 },
 { 165,   0 }, { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 },
 { 170,   0 }, { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 },
 { 175,   0 }, { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 },
 { 180,   0 }, { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 },

 { 185,   0 }, { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 },
 { 190,   0 }, { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 },
 { 195,   0 }, { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 },
 { 200,   0 }, { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 },
 { 205,   0 }, { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 },
 { 210,   0 }, { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 },
 { 215,   0 }, { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 },
 { 220,   0 }, { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 },
 { 225,   0 }, { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 },
 { 230,   0 }, { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 },

 { 235,   0 }, { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 },
 { 240,   0 }, { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 },
 { 245,   0 }, { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 },
 { 250,   0 }, { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 },
 { 255,   0 }, {   0,  66 }, {   0,2305 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,-257 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },
 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,1367 }, {  66,1367 }, {  67,1367 },
 {  68,1367 }, {  69,1367 }, {  70,1367 }, {  71,1367 }, {  72,1367 },
 {  73,1367 }, {  74,1367 }, {  75,1367 }, {  76,1367 }, {  77,1367 },

 {  78,1367 }, {  79,1367 }, {  80,1367 }, {  81,1367 }, {  82,1367 },
 {  83,1367 }, {  84,1367 }, {  85,1367 }, {  86,1367 }, {  87,1367 },
 {  88,1367 }, {  89,1367 }, {  90,1367 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,1624 }, {   0,   0 }, {  97,1367 },
 {  98,1367 }, {  99,1367 }, { 100,1367 }, { 101,1367 }, { 102,1367 },
 { 103,1367 }, { 104,1367 }, { 105,1367 }, { 106,1367 }, { 107,1367 },
 { 108,1367 }, { 109,1367 }, { 110,1367 }, { 111,1367 }, { 112,1367 },
 { 113,1367 }, { 114,1367 }, { 115,1367 }, { 116,1367 }, { 117,1367 },
 { 118,1367 }, { 119,1367 }, { 120,1367 }, { 121,1367 }, { 122,1367 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 { 128,1367 }, { 129,1367 }, { 130,1367 }, { 131,1367 }, { 132,1367 },
 { 133,1367 }, { 134,1367 }, { 135,1367 }, { 136,1367 }, { 137,1367 },
 { 138,1367 }, { 139,1367 }, { 140,1367 }, { 141,1367 }, { 142,1367 },
 { 143,1367 }, { 144,1367 }, { 145,1367 }, { 146,1367 }, { 147,1367 },
 { 148,1367 }, { 149,1367 }, { 150,1367 }, { 151,1367 }, { 152,1367 },
 { 153,1367 }, { 154,1367 }, { 155,1367 }, { 156,1367 }, { 157,1367 },
 { 158,1367 }, { 159,1367 }, { 160,1367 }, { 161,1367 }, { 162,1367 },
 { 163,1367 }, { 164,1367 }, { 165,1367 }, { 166,1367 }, { 167,1367 },
 { 168,1367 }, { 169,1367 }, { 170,1367 }, { 171,1367 }, { 172,1367 },
 { 173,1367 }, { 174,1367 }, { 175,1367 }, { 176,1367 }, { 177,1367 },

 { 178,1367 }, { 179,1367 }, { 180,1367 }, { 181,1367 }, { 182,1367 },
 { 183,1367 }, { 184,1367 }, { 185,1367 }, { 186,1367 }, { 187,1367 },
 { 188,1367 }, { 189,1367 }, { 190,1367 }, { 191,1367 }, { 192,1367 },
 { 193,1367 }, { 194,1367 }, { 195,1367 }, { 196,1367 }, { 197,1367 },
 { 198,1367 }, { 199,1367 }, { 200,1367 }, { 201,1367 }, { 202,1367 },
 { 203,1367 }, { 204,1367 }, { 205,1367 }, { 206,1367 }, { 207,1367 },
 { 208,1367 }, { 209,1367 }, { 210,1367 }, { 211,1367 }, { 212,1367 },
 { 213,1367 }, { 214,1367 }, { 215,1367 }, { 216,1367 }, { 217,1367 },
 { 218,1367 }, { 219,1367 }, { 220,1367 }, { 221,1367 }, { 222,1367 },
 { 223,1367 }, { 224,1367 }, { 225,1367 }, { 226,1367 }, { 227,1367 },

 { 228,1367 }, { 229,1367 }, { 230,1367 }, { 231,1367 }, { 232,1367 },
 { 233,1367 }, { 234,1367 }, { 235,1367 }, { 236,1367 }, { 237,1367 },
 { 238,1367 }, { 239,1367 }, { 240,1367 }, { 241,1367 }, { 242,1367 },
 { 243,1367 }, { 244,1367 }, { 245,1367 }, { 246,1367 }, { 247,1367 },
 { 248,1367 }, { 249,1367 }, { 250,1367 }, { 251,1367 }, { 252,1367 },
 { 253,1367 }, { 254,1367 }, { 255,1367 }, {   0,  68 }, {   0,2048 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  36,-2200 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,-2200 }, {  49,-2200 }, {  50,-2200 },
 {  51,-2200 }, {  52,-2200 }, {  53,-2200 }, {  54,-2200 }, {  55,-2200 },
 {  56,-2200 }, {  57,-2200 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,-2200 },
 {  66,-2200 }, {  67,-2200 }, {  68,-2200 }, {  69,-2200 }, {  70,-2200 },

 {  71,-2200 }, {  72,-2200 }, {  73,-2200 }, {  74,-2200 }, {  75,-2200 },
 {  76,-2200 }, {  77,-2200 }, {  78,-2200 }, {  79,-2200 }, {  80,-2200 },
 {  81,-2200 }, {  82,-2200 }, {  83,-2200 }, {  84,-2200 }, {  85,-2200 },
 {  86,-2200 }, {  87,-2200 }, {  88,-2200 }, {  89,-2200 }, {  90,-2200 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,-2200 },
 {   0,   0 }, {  97,-2200 }, {  98,-2200 }, {  99,-2200 }, { 100,-2200 },
 { 101,-2200 }, { 102,-2200 }, { 103,-2200 }, { 104,-2200 }, { 105,-2200 },
 { 106,-2200 }, { 107,-2200 }, { 108,-2200 }, { 109,-2200 }, { 110,-2200 },
 { 111,-2200 }, { 112,-2200 }, { 113,-2200 }, { 114,-2200 }, { 115,-2200 },
 { 116,-2200 }, { 117,-2200 }, { 118,-2200 }, { 119,-2200 }, { 120,-2200 },

 { 121,-2200 }, { 122,-2200 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 128,-2200 }, { 129,-2200 }, { 130,-2200 },
 { 131,-2200 }, { 132,-2200 }, { 133,-2200 }, { 134,-2200 }, { 135,-2200 },
 { 136,-2200 }, { 137,-2200 }, { 138,-2200 }, { 139,-2200 }, { 140,-2200 },
 { 141,-2200 }, { 142,-2200 }, { 143,-2200 }, { 144,-2200 }, { 145,-2200 },
 { 146,-2200 }, { 147,-2200 }, { 148,-2200 }, { 149,-2200 }, { 150,-2200 },
 { 151,-2200 }, { 152,-2200 }, { 153,-2200 }, { 154,-2200 }, { 155,-2200 },
 { 156,-2200 }, { 157,-2200 }, { 158,-2200 }, { 159,-2200 }, { 160,-2200 },
 { 161,-2200 }, { 162,-2200 }, { 163,-2200 }, { 164,-2200 }, { 165,-2200 },
 { 166,-2200 }, { 167,-2200 }, { 168,-2200 }, { 169,-2200 }, { 170,-2200 },

 { 171,-2200 }, { 172,-2200 }, { 173,-2200 }, { 174,-2200 }, { 175,-2200 },
 { 176,-2200 }, { 177,-2200 }, { 178,-2200 }, { 179,-2200 }, { 180,-2200 },
 { 181,-2200 }, { 182,-2200 }, { 183,-2200 }, { 184,-2200 }, { 185,-2200 },
 { 186,-2200 }, { 187,-2200 }, { 188,-2200 }, { 189,-2200 }, { 190,-2200 },
 { 191,-2200 }, { 192,-2200 }, { 193,-2200 }, { 194,-2200 }, { 195,-2200 },
 { 196,-2200 }, { 197,-2200 }, { 198,-2200 }, { 199,-2200 }, { 200,-2200 },
 { 201,-2200 }, { 202,-2200 }, { 203,-2200 }, { 204,-2200 }, { 205,-2200 },
 { 206,-2200 }, { 207,-2200 }, { 208,-2200 }, { 209,-2200 }, { 210,-2200 },
 { 211,-2200 }, { 212,-2200 }, { 213,-2200 }, { 214,-2200 }, { 215,-2200 },
 { 216,-2200 }, { 217,-2200 }, { 218,-2200 }, { 219,-2200 }, { 220,-2200 },

 { 221,-2200 }, { 222,-2200 }, { 223,-2200 }, { 224,-2200 }, { 225,-2200 },
 { 226,-2200 }, { 227,-2200 }, { 228,-2200 }, { 229,-2200 }, { 230,-2200 },
 { 231,-2200 }, { 232,-2200 }, { 233,-2200 }, { 234,-2200 }, { 235,-2200 },
 { 236,-2200 }, { 237,-2200 }, { 238,-2200 }, { 239,-2200 }, { 240,-2200 },
 { 241,-2200 }, { 242,-2200 }, { 243,-2200 }, { 244,-2200 }, { 245,-2200 },
 { 246,-2200 }, { 247,-2200 }, { 248,-2200 }, { 249,-2200 }, { 250,-2200 },
 { 251,-2200 }, { 252,-2200 }, { 253,-2200 }, { 254,-2200 }, { 255,-2200 },
 {   0,  68 }, {   0,1791 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  36,-2457 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,-2200 },
 {  49,-2200 }, {  50,-2200 }, {  51,-2200 }, {  52,-2200 }, {  53,-2200 },
 {  54,-2200 }, {  55,-2200 }, {  56,-2200 }, {  57,-2200 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {  65,-2457 }, {  66,-2457 }, {  67,-2457 }, {  68,-2457 },
 {  69,-2457 }, {  70,-2457 }, {  71,-2457 }, {  72,-2457 }, {  73,-2457 },
 {  74,-2457 }, {  75,-2457 }, {  76,-2457 }, {  77,-2457 }, {  78,-2457 },
 {  79,-2457 }, {  80,-2457 }, {  81,-2457 }, {  82,-2457 }, {  83,-2457 },
 {  84,-2457 }, {  85,-2457 }, {  86,-2457 }, {  87,-2457 }, {  88,-2457 },
 {  89,-2457 }, {  90,-2457 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95,-2457 }, {   0,   0 }, {  97,-2457 }, {  98,-2457 },
 {  99,-2457 }, { 100,-2457 }, { 101,-2457 }, { 102,-2457 }, { 103,-2457 },
 { 104,-2457 }, { 105,-2457 }, { 106,-2457 }, { 107,-2457 }, { 108,-2457 },
 { 109,-2457 }, { 110,-2457 }, { 111,-2457 }, { 112,-2457 }, { 113,-2457 },

 { 114,-2457 }, { 115,-2457 }, { 116,-2457 }, { 117,-2457 }, { 118,-2457 },
 { 119,-2457 }, { 120,-2457 }, { 121,-2457 }, { 122,-2457 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,-2457 },
 { 129,-2457 }, { 130,-2457 }, { 131,-2457 }, { 132,-2457 }, { 133,-2457 },
 { 134,-2457 }, { 135,-2457 }, { 136,-2457 }, { 137,-2457 }, { 138,-2457 },
 { 139,-2457 }, { 140,-2457 }, { 141,-2457 }, { 142,-2457 }, { 143,-2457 },
 { 144,-2457 }, { 145,-2457 }, { 146,-2457 }, { 147,-2457 }, { 148,-2457 },
 { 149,-2457 }, { 150,-2457 }, { 151,-2457 }, { 152,-2457 }, { 153,-2457 },
 { 154,-2457 }, { 155,-2457 }, { 156,-2457 }, { 157,-2457 }, { 158,-2457 },
 { 159,-2457 }, { 160,-2457 }, { 161,-2457 }, { 162,-2457 }, { 163,-2457 },

 { 164,-2457 }, { 165,-2457 }, { 166,-2457 }, { 167,-2457 }, { 168,-2457 },
 { 169,-2457 }, { 170,-2457 }, { 171,-2457 }, { 172,-2457 }, { 173,-2457 },
 { 174,-2457 }, { 175,-2457 }, { 176,-2457 }, { 177,-2457 }, { 178,-2457 },
 { 179,-2457 }, { 180,-2457 }, { 181,-2457 }, { 182,-2457 }, { 183,-2457 },
 { 184,-2457 }, { 185,-2457 }, { 186,-2457 }, { 187,-2457 }, { 188,-2457 },
 { 189,-2457 }, { 190,-2457 }, { 191,-2457 }, { 192,-2457 }, { 193,-2457 },
 { 194,-2457 }, { 195,-2457 }, { 196,-2457 }, { 197,-2457 }, { 198,-2457 },
 { 199,-2457 }, { 200,-2457 }, { 201,-2457 }, { 202,-2457 }, { 203,-2457 },
 { 204,-2457 }, { 205,-2457 }, { 206,-2457 }, { 207,-2457 }, { 208,-2457 },
 { 209,-2457 }, { 210,-2457 }, { 211,-2457 }, { 212,-2457 }, { 213,-2457 },

 { 214,-2457 }, { 215,-2457 }, { 216,-2457 }, { 217,-2457 }, { 218,-2457 },
 { 219,-2457 }, { 220,-2457 }, { 221,-2457 }, { 222,-2457 }, { 223,-2457 },
 { 224,-2457 }, { 225,-2457 }, { 226,-2457 }, { 227,-2457 }, { 228,-2457 },
 { 229,-2457 }, { 230,-2457 }, { 231,-2457 }, { 232,-2457 }, { 233,-2457 },
 { 234,-2457 }, { 235,-2457 }, { 236,-2457 }, { 237,-2457 }, { 238,-2457 },
 { 239,-2457 }, { 240,-2457 }, { 241,-2457 }, { 242,-2457 }, { 243,-2457 },
 { 244,-2457 }, { 245,-2457 }, { 246,-2457 }, { 247,-2457 }, { 248,-2457 },
 { 249,-2457 }, { 250,-2457 }, { 251,-2457 }, { 252,-2457 }, { 253,-2457 },
 { 254,-2457 }, { 255,-2457 }, {   0,  27 }, {   0,1534 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,  27 }, {   0,1511 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,1110 }, {  49,1110 }, {  50,1110 }, {  51,1110 },
 {  52,1110 }, {  53,1110 }, {  54,1110 }, {  55,1110 }, {  56,1110 },

 {  57,1110 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,1110 }, {  66,1110 },
 {  67,1110 }, {  68,1110 }, {  69,1110 }, {  70,1110 }, {  48,1110 },
 {  49,1110 }, {  50,1110 }, {  51,1110 }, {  52,1110 }, {  53,1110 },
 {  54,1110 }, {  55,1110 }, {  56,1110 }, {  57,1110 }, {   0,  69 },
 {   0,1452 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,1110 }, {  66,1110 }, {  67,1110 }, {  68,1110 },
 {  69,1110 }, {  70,1110 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  97,1110 }, {  98,1110 }, {  99,1110 }, { 100,1110 }, { 101,1110 },
 { 102,1110 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  36,-1881 }, {   0,   0 }, {  97,1110 }, {  98,1110 },
 {  99,1110 }, { 100,1110 }, { 101,1110 }, { 102,1110 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,-1881 }, {  49,-1881 },
 {  50,-1881 }, {  51,-1881 }, {  52,-1881 }, {  53,-1881 }, {  54,-1881 },
 {  55,-1881 }, {  56,-1881 }, {  57,-1881 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,-1881 }, {  66,-1881 }, {  67,-1881 }, {  68,-1881 }, {  69,-1881 },
 {  70,-1881 }, {  71,-1881 }, {  72,-1881 }, {  73,-1881 }, {  74,-1881 },

 {  75,-1881 }, {  76,-1881 }, {  77,-1881 }, {  78,-1881 }, {  79,-1881 },
 {  80,-1881 }, {  81,-1881 }, {  82,-1881 }, {  83,-1881 }, {  84,-1881 },
 {  85,-1881 }, {  86,-1881 }, {  87,-1881 }, {  88,-1881 }, {  89,-1881 },
 {  90,-1881 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,-1881 }, {   0,   0 }, {  97,-1881 }, {  98,-1881 }, {  99,-1881 },
 { 100,-1881 }, { 101,-1881 }, { 102,-1881 }, { 103,-1881 }, { 104,-1881 },
 { 105,-1881 }, { 106,-1881 }, { 107,-1881 }, { 108,-1881 }, { 109,-1881 },
 { 110,-1881 }, { 111,-1881 }, { 112,-1881 }, { 113,-1881 }, { 114,-1881 },
 { 115,-1881 }, { 116,-1881 }, { 117,-1881 }, { 118,-1881 }, { 119,-1881 },
 { 120,-1881 }, { 121,-1881 }, { 122,-1881 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,-1881 }, { 129,-1881 },
 { 130,-1881 }, { 131,-1881 }, { 132,-1881 }, { 133,-1881 }, { 134,-1881 },
 { 135,-1881 }, { 136,-1881 }, { 137,-1881 }, { 138,-1881 }, { 139,-1881 },
 { 140,-1881 }, { 141,-1881 }, { 142,-1881 }, { 143,-1881 }, { 144,-1881 },
 { 145,-1881 }, { 146,-1881 }, { 147,-1881 }, { 148,-1881 }, { 149,-1881 },
 { 150,-1881 }, { 151,-1881 }, { 152,-1881 }, { 153,-1881 }, { 154,-1881 },
 { 155,-1881 }, { 156,-1881 }, { 157,-1881 }, { 158,-1881 }, { 159,-1881 },
 { 160,-1881 }, { 161,-1881 }, { 162,-1881 }, { 163,-1881 }, { 164,-1881 },
 { 165,-1881 }, { 166,-1881 }, { 167,-1881 }, { 168,-1881 }, { 169,-1881 },
 { 170,-1881 }, { 171,-1881 }, { 172,-1881 }, { 173,-1881 }, { 174,-1881 },

 { 175,-1881 }, { 176,-1881 }, { 177,-1881 }, { 178,-1881 }, { 179,-1881 },
 { 180,-1881 }, { 181,-1881 }, { 182,-1881 }, { 183,-1881 }, { 184,-1881 },
 { 185,-1881 }, { 186,-1881 }, { 187,-1881 }, { 188,-1881 }, { 189,-1881 },
 { 190,-1881 }, { 191,-1881 }, { 192,-1881 }, { 193,-1881 }, { 194,-1881 },
 { 195,-1881 }, { 196,-1881 }, { 197,-1881 }, { 198,-1881 }, { 199,-1881 },
 { 200,-1881 }, { 201,-1881 }, { 202,-1881 }, { 203,-1881 }, { 204,-1881 },
 { 205,-1881 }, { 206,-1881 }, { 207,-1881 }, { 208,-1881 }, { 209,-1881 },
 { 210,-1881 }, { 211,-1881 }, { 212,-1881 }, { 213,-1881 }, { 214,-1881 },
 { 215,-1881 }, { 216,-1881 }, { 217,-1881 }, { 218,-1881 }, { 219,-1881 },
 { 220,-1881 }, { 221,-1881 }, { 222,-1881 }, { 223,-1881 }, { 224,-1881 },

 { 225,-1881 }, { 226,-1881 }, { 227,-1881 }, { 228,-1881 }, { 229,-1881 },
 { 230,-1881 }, { 231,-1881 }, { 232,-1881 }, { 233,-1881 }, { 234,-1881 },
 { 235,-1881 }, { 236,-1881 }, { 237,-1881 }, { 238,-1881 }, { 239,-1881 },
 { 240,-1881 }, { 241,-1881 }, { 242,-1881 }, { 243,-1881 }, { 244,-1881 },
 { 245,-1881 }, { 246,-1881 }, { 247,-1881 }, { 248,-1881 }, { 249,-1881 },
 { 250,-1881 }, { 251,-1881 }, { 252,-1881 }, { 253,-1881 }, { 254,-1881 },
 { 255,-1881 }, {   0,  69 }, {   0,1195 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,-2138 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,-1881 }, {  49,-1881 }, {  50,-1881 }, {  51,-1881 }, {  52,-1881 },
 {  53,-1881 }, {  54,-1881 }, {  55,-1881 }, {  56,-1881 }, {  57,-1881 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,-2138 }, {  66,-2138 }, {  67,-2138 },

 {  68,-2138 }, {  69,-2138 }, {  70,-2138 }, {  71,-2138 }, {  72,-2138 },
 {  73,-2138 }, {  74,-2138 }, {  75,-2138 }, {  76,-2138 }, {  77,-2138 },
 {  78,-2138 }, {  79,-2138 }, {  80,-2138 }, {  81,-2138 }, {  82,-2138 },
 {  83,-2138 }, {  84,-2138 }, {  85,-2138 }, {  86,-2138 }, {  87,-2138 },
 {  88,-2138 }, {  89,-2138 }, {  90,-2138 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,-2138 }, {   0,   0 }, {  97,-2138 },
 {  98,-2138 }, {  99,-2138 }, { 100,-2138 }, { 101,-2138 }, { 102,-2138 },
 { 103,-2138 }, { 104,-2138 }, { 105,-2138 }, { 106,-2138 }, { 107,-2138 },
 { 108,-2138 }, { 109,-2138 }, { 110,-2138 }, { 111,-2138 }, { 112,-2138 },
 { 113,-2138 }, { 114,-2138 }, { 115,-2138 }, { 116,-2138 }, { 117,-2138 },

 { 118,-2138 }, { 119,-2138 }, { 120,-2138 }, { 121,-2138 }, { 122,-2138 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,-2138 }, { 129,-2138 }, { 130,-2138 }, { 131,-2138 }, { 132,-2138 },
 { 133,-2138 }, { 134,-2138 }, { 135,-2138 }, { 136,-2138 }, { 137,-2138 },
 { 138,-2138 }, { 139,-2138 }, { 140,-2138 }, { 141,-2138 }, { 142,-2138 },
 { 143,-2138 }, { 144,-2138 }, { 145,-2138 }, { 146,-2138 }, { 147,-2138 },
 { 148,-2138 }, { 149,-2138 }, { 150,-2138 }, { 151,-2138 }, { 152,-2138 },
 { 153,-2138 }, { 154,-2138 }, { 155,-2138 }, { 156,-2138 }, { 157,-2138 },
 { 158,-2138 }, { 159,-2138 }, { 160,-2138 }, { 161,-2138 }, { 162,-2138 },
 { 163,-2138 }, { 164,-2138 }, { 165,-2138 }, { 166,-2138 }, { 167,-2138 },

 { 168,-2138 }, { 169,-2138 }, { 170,-2138 }, { 171,-2138 }, { 172,-2138 },
 { 173,-2138 }, { 174,-2138 }, { 175,-2138 }, { 176,-2138 }, { 177,-2138 },
 { 178,-2138 }, { 179,-2138 }, { 180,-2138 }, { 181,-2138 }, { 182,-2138 },
 { 183,-2138 }, { 184,-2138 }, { 185,-2138 }, { 186,-2138 }, { 187,-2138 },
 { 188,-2138 }, { 189,-2138 }, { 190,-2138 }, { 191,-2138 }, { 192,-2138 },
 { 193,-2138 }, { 194,-2138 }, { 195,-2138 }, { 196,-2138 }, { 197,-2138 },
 { 198,-2138 }, { 199,-2138 }, { 200,-2138 }, { 201,-2138 }, { 202,-2138 },
 { 203,-2138 }, { 204,-2138 }, { 205,-2138 }, { 206,-2138 }, { 207,-2138 },
 { 208,-2138 }, { 209,-2138 }, { 210,-2138 }, { 211,-2138 }, { 212,-2138 },
 { 213,-2138 }, { 214,-2138 }, { 215,-2138 }, { 216,-2138 }, { 217,-2138 },

 { 218,-2138 }, { 219,-2138 }, { 220,-2138 }, { 221,-2138 }, { 222,-2138 },
 { 223,-2138 }, { 224,-2138 }, { 225,-2138 }, { 226,-2138 }, { 227,-2138 },
 { 228,-2138 }, { 229,-2138 }, { 230,-2138 }, { 231,-2138 }, { 232,-2138 },
 { 233,-2138 }, { 234,-2138 }, { 235,-2138 }, { 236,-2138 }, { 237,-2138 },
 { 238,-2138 }, { 239,-2138 }, { 240,-2138 }, { 241,-2138 }, { 242,-2138 },
 { 243,-2138 }, { 244,-2138 }, { 245,-2138 }, { 246,-2138 }, { 247,-2138 },
 { 248,-2138 }, { 249,-2138 }, { 250,-2138 }, { 251,-2138 }, { 252,-2138 },
 { 253,-2138 }, { 254,-2138 }, { 255,-2138 }, {   0,  70 }, {   0, 938 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  36,-1624 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,-1624 }, {  49,-1624 }, {  50,-1624 },
 {  51,-1624 }, {  52,-1624 }, {  53,-1624 }, {  54,-1624 }, {  55,-1624 },
 {  56,-1624 }, {  57,-1624 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,-1624 },
 {  66,-1624 }, {  67,-1624 }, {  68,-1624 }, {  69,-1624 }, {  70,-1624 },
 {  71,-1624 }, {  72,-1624 }, {  73,-1624 }, {  74,-1624 }, {  75,-1624 },
 {  76,-1624 }, {  77,-1624 }, {  78,-1624 }, {  79,-1624 }, {  80,-1624 },
 {  81,-1624 }, {  82,-1624 }, {  83,-1624 }, {  84,-1624 }, {  85,-1624 },
 {  86,-1624 }, {  87,-1624 }, {  88,-1624 }, {  89,-1624 }, {  90,-1624 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,-1624 },
 {   0,   0 }, {  97,-1624 }, {  98,-1624 }, {  99,-1624 }, { 100,-1624 },
 { 101,-1624 }, { 102,-1624 }, { 103,-1624 }, { 104,-1624 }, { 105,-1624 },
 { 106,-1624 }, { 107,-1624 }, { 108,-1624 }, { 109,-1624 }, { 110,-1624 },

 { 111,-1624 }, { 112,-1624 }, { 113,-1624 }, { 114,-1624 }, { 115,-1624 },
 { 116,-1624 }, { 117,-1624 }, { 118,-1624 }, { 119,-1624 }, { 120,-1624 },
 { 121,-1624 }, { 122,-1624 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 128,-1624 }, { 129,-1624 }, { 130,-1624 },
 { 131,-1624 }, { 132,-1624 }, { 133,-1624 }, { 134,-1624 }, { 135,-1624 },
 { 136,-1624 }, { 137,-1624 }, { 138,-1624 }, { 139,-1624 }, { 140,-1624 },
 { 141,-1624 }, { 142,-1624 }, { 143,-1624 }, { 144,-1624 }, { 145,-1624 },
 { 146,-1624 }, { 147,-1624 }, { 148,-1624 }, { 149,-1624 }, { 150,-1624 },
 { 151,-1624 }, { 152,-1624 }, { 153,-1624 }, { 154,-1624 }, { 155,-1624 },
 { 156,-1624 }, { 157,-1624 }, { 158,-1624 }, { 159,-1624 }, { 160,-1624 },

 { 161,-1624 }, { 162,-1624 }, { 163,-1624 }, { 164,-1624 }, { 165,-1624 },
 { 166,-1624 }, { 167,-1624 }, { 168,-1624 }, { 169,-1624 }, { 170,-1624 },
 { 171,-1624 }, { 172,-1624 }, { 173,-1624 }, { 174,-1624 }, { 175,-1624 },
 { 176,-1624 }, { 177,-1624 }, { 178,-1624 }, { 179,-1624 }, { 180,-1624 },
 { 181,-1624 }, { 182,-1624 }, { 183,-1624 }, { 184,-1624 }, { 185,-1624 },
 { 186,-1624 }, { 187,-1624 }, { 188,-1624 }, { 189,-1624 }, { 190,-1624 },
 { 191,-1624 }, { 192,-1624 }, { 193,-1624 }, { 194,-1624 }, { 195,-1624 },
 { 196,-1624 }, { 197,-1624 }, { 198,-1624 }, { 199,-1624 }, { 200,-1624 },
 { 201,-1624 }, { 202,-1624 }, { 203,-1624 }, { 204,-1624 }, { 205,-1624 },
 { 206,-1624 }, { 207,-1624 }, { 208,-1624 }, { 209,-1624 }, { 210,-1624 },

 { 211,-1624 }, { 212,-1624 }, { 213,-1624 }, { 214,-1624 }, { 215,-1624 },
 { 216,-1624 }, { 217,-1624 }, { 218,-1624 }, { 219,-1624 }, { 220,-1624 },
 { 221,-1624 }, { 222,-1624 }, { 223,-1624 }, { 224,-1624 }, { 225,-1624 },
 { 226,-1624 }, { 227,-1624 }, { 228,-1624 }, { 229,-1624 }, { 230,-1624 },
 { 231,-1624 }, { 232,-1624 }, { 233,-1624 }, { 234,-1624 }, { 235,-1624 },
 { 236,-1624 }, { 237,-1624 }, { 238,-1624 }, { 239,-1624 }, { 240,-1624 },
 { 241,-1624 }, { 242,-1624 }, { 243,-1624 }, { 244,-1624 }, { 245,-1624 },
 { 246,-1624 }, { 247,-1624 }, { 248,-1624 }, { 249,-1624 }, { 250,-1624 },
 { 251,-1624 }, { 252,-1624 }, { 253,-1624 }, { 254,-1624 }, { 255,-1624 },
 {   0,  70 }, {   0, 681 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  36,-1881 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,-1624 },
 {  49,-1624 }, {  50,-1624 }, {  51,-1624 }, {  52,-1624 }, {  53,-1624 },

 {  54,-1624 }, {  55,-1624 }, {  56,-1624 }, {  57,-1624 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,-1881 }, {  66,-1881 }, {  67,-1881 }, {  68,-1881 },
 {  69,-1881 }, {  70,-1881 }, {  71,-1881 }, {  72,-1881 }, {  73,-1881 },
 {  74,-1881 }, {  75,-1881 }, {  76,-1881 }, {  77,-1881 }, {  78,-1881 },
 {  79,-1881 }, {  80,-1881 }, {  81,-1881 }, {  82,-1881 }, {  83,-1881 },
 {  84,-1881 }, {  85,-1881 }, {  86,-1881 }, {  87,-1881 }, {  88,-1881 },
 {  89,-1881 }, {  90,-1881 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95,-1881 }, {   0,   0 }, {  97,-1881 }, {  98,-1881 },
 {  99,-1881 }, { 100,-1881 }, { 101,-1881 }, { 102,-1881 }, { 103,-1881 },

 { 104,-1881 }, { 105,-1881 }, { 106,-1881 }, { 107,-1881 }, { 108,-1881 },
 { 109,-1881 }, { 110,-1881 }, { 111,-1881 }, { 112,-1881 }, { 113,-1881 },
 { 114,-1881 }, { 115,-1881 }, { 116,-1881 }, { 117,-1881 }, { 118,-1881 },
 { 119,-1881 }, { 120,-1881 }, { 121,-1881 }, { 122,-1881 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,-1881 },
 { 129,-1881 }, { 130,-1881 }, { 131,-1881 }, { 132,-1881 }, { 133,-1881 },
 { 134,-1881 }, { 135,-1881 }, { 136,-1881 }, { 137,-1881 }, { 138,-1881 },
 { 139,-1881 }, { 140,-1881 }, { 141,-1881 }, { 142,-1881 }, { 143,-1881 },
 { 144,-1881 }, { 145,-1881 }, { 146,-1881 }, { 147,-1881 }, { 148,-1881 },
 { 149,-1881 }, { 150,-1881 }, { 151,-1881 }, { 152,-1881 }, { 153,-1881 },

 { 154,-1881 }, { 155,-1881 }, { 156,-1881 }, { 157,-1881 }, { 158,-1881 },
 { 159,-1881 }, { 160,-1881 }, { 161,-1881 }, { 162,-1881 }, { 163,-1881 },
 { 164,-1881 }, { 165,-1881 }, { 166,-1881 }, { 167,-1881 }, { 168,-1881 },
 { 169,-1881 }, { 170,-1881 }, { 171,-1881 }, { 172,-1881 }, { 173,-1881 },
 { 174,-1881 }, { 175,-1881 }, { 176,-1881 }, { 177,-1881 }, { 178,-1881 },
 { 179,-1881 }, { 180,-1881 }, { 181,-1881 }, { 182,-1881 }, { 183,-1881 },
 { 184,-1881 }, { 185,-1881 }, { 186,-1881 }, { 187,-1881 }, { 188,-1881 },
 { 189,-1881 }, { 190,-1881 }, { 191,-1881 }, { 192,-1881 }, { 193,-1881 },
 { 194,-1881 }, { 195,-1881 }, { 196,-1881 }, { 197,-1881 }, { 198,-1881 },
 { 199,-1881 }, { 200,-1881 }, { 201,-1881 }, { 202,-1881 }, { 203,-1881 },

 { 204,-1881 }, { 205,-1881 }, { 206,-1881 }, { 207,-1881 }, { 208,-1881 },
 { 209,-1881 }, { 210,-1881 }, { 211,-1881 }, { 212,-1881 }, { 213,-1881 },
 { 214,-1881 }, { 215,-1881 }, { 216,-1881 }, { 217,-1881 }, { 218,-1881 },
 { 219,-1881 }, { 220,-1881 }, { 221,-1881 }, { 222,-1881 }, { 223,-1881 },
 { 224,-1881 }, { 225,-1881 }, { 226,-1881 }, { 227,-1881 }, { 228,-1881 },
 { 229,-1881 }, { 230,-1881 }, { 231,-1881 }, { 232,-1881 }, { 233,-1881 },
 { 234,-1881 }, { 235,-1881 }, { 236,-1881 }, { 237,-1881 }, { 238,-1881 },
 { 239,-1881 }, { 240,-1881 }, { 241,-1881 }, { 242,-1881 }, { 243,-1881 },
 { 244,-1881 }, { 245,-1881 }, { 246,-1881 }, { 247,-1881 }, { 248,-1881 },
 { 249,-1881 }, { 250,-1881 }, { 251,-1881 }, { 252,-1881 }, { 253,-1881 },

 { 254,-1881 }, { 255,-1881 }, {   0,  27 }, {   0, 424 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,  27 }, {   0, 401 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {  48,  61 }, {  49,  61 }, {  50,  61 }, {  51,  61 },
 {  52,  61 }, {  53,  61 }, {  54,  61 }, {  55,  61 }, {  56,  61 },
 {  57,  61 }, {   0,   0 }, {   0,   0 }, {   0,  27 }, {   0, 363 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,  61 }, {  66,  61 },
 {  67,  61 }, {  68,  61 }, {  69,  61 }, {  70,  61 }, {  48,  61 },
 {  49,  61 }, {  50,  61 }, {  51,  61 }, {  52,  61 }, {  53,  61 },
 {  54,  61 }, {  55,  61 }, {  56,  61 }, {  57,  61 }, {   0,   0 },
 {   0,   0 }, {   0,  27 }, {   0, 340 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,  61 }, {  66,  61 }, {  67,  61 }, {  68,  61 },
 {  69,  61 }, {  70,  61 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {  97,  61 }, {  98,  61 }, {  99,  61 }, { 100,  61 }, { 101,  61 },
 { 102,  61 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,  82 }, {  49,  82 }, {  50,  82 },
 {  51,  82 }, {  52,  82 }, {  53,  82 }, {  54,  82 }, {  55,  82 },
 {  56,  82 }, {  57,  82 }, {   0,   0 }, {  97,  61 }, {  98,  61 },
 {  99,  61 }, { 100,  61 }, { 101,  61 }, { 102,  61 }, {  65,  82 },
 {  66,  82 }, {  67,  82 }, {  68,  82 }, {  69,  82 }, {  70,  82 },
 {  48,  82 }, {  49,  82 }, {  50,  82 }, {  51,  82 }, {  52,  82 },
 {  53,  82 }, {  54,  82 }, {  55,  82 }, {  56,  82 }, {  57,  82 },
 {   0,  27 }, {   0, 281 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {  65,  82 }, {  66,  82 }, {  67,  82 },
 {  68,  82 }, {  69,  82 }, {  70,  82 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  97,  82 }, {  98,  82 }, {  99,  82 }, { 100,  82 },
 { 101,  82 }, { 102,  82 }, {   0,   0 }, {   0,  27 }, {   0, 258 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97,  82 },
 {  98,  82 }, {  99,  82 }, { 100,  82 }, { 101,  82 }, { 102,  82 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,-29988 },
 {  49,-29988 }, {  50,-29988 }, {  51,-29988 }, {  52,-29988 }, {  53,-29988 },

 {  54,-29988 }, {  55,-29988 }, {  56,-29988 }, {  57,-29988 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,-29988 }, {  66,-29988 }, {  67,-29988 }, {  68,-29988 },
 {  69,-29988 }, {  70,-29988 }, {  48,-30009 }, {  49,-30009 }, {  50,-30009 },
 {  51,-30009 }, {  52,-30009 }, {  53,-30009 }, {  54,-30009 }, {  55,-30009 },
 {  56,-30009 }, {  57,-30009 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,-30009 },
 {  66,-30009 }, {  67,-30009 }, {  68,-30009 }, {  69,-30009 }, {  70,-30009 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97,-29988 }, {  98,-29988 },
 {  99,-29988 }, { 100,-29988 }, { 101,-29988 }, { 102,-29988 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  97,-30009 }, {  98,-30009 }, {  99,-30009 }, { 100,-30009 },
 { 101,-30009 }, { 102,-30009 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 257,  74 }, {   1,   0 },    };

static const struct yy_trans_info *yy_start_state_list[25] =
    {
    &yy_transition[1],
    &yy_transition[3],
    &yy_transition[261],
    &yy_transition[519],
    &yy_transition[777],
    &yy_transition[1035],
    &yy_transition[1293],
    &yy_transition[1551],
    &yy_transition[1809],
    &yy_transition[2067],
    &yy_transition[2325],
    &yy_transition[2583],
    &yy_transition[2841],
    &yy_transition[3099],
    &yy_transition[3357],
    &yy_transition[3615],
    &yy_transition[3873],
    &yy_transition[4131],
    &yy_transition[4389],
    &yy_transition[4647],
    &yy_transition[4905],
    &yy_transition[5163],
    &yy_transition[5421],
    &yy_transition[5679],
    &yy_transition[5937],

    } ;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
#line 1 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"

#line 49 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"

/* LCOV_EXCL_START */

/* Avoid exit() on fatal scanner errors (a bit ugly -- see yy_fatal_error) */
#undef fprintf
#define fprintf(file, fmt, msg)  fprintf_to_ereport(fmt, msg)

static void
fprintf_to_ereport(const char *fmt, const char *msg)
{
	ereport(ERROR, (errmsg_internal("%s", msg)));
}

/*
 * GUC variables.  This is a DIRECT violation of the warning given at the
 * head of gram.y, ie flex/bison code must not depend on any GUC variables;
 * as such, changing their values can induce very unintuitive behavior.
 * But we shall have to live with it until we can remove these variables.
 */
int			backslash_quote = BACKSLASH_QUOTE_SAFE_ENCODING;
bool		escape_string_warning = true;
bool		standard_conforming_strings = true;

/*
 * Constant data exported from this file.  This array maps from the
 * zero-based keyword numbers returned by ScanKeywordLookup to the
 * Bison token numbers needed by gram.y.  This is exported because
 * callers need to pass it to scanner_init, if they are using the
 * standard keyword list ScanKeywords.
 */
#define PG_KEYWORD(kwname, value, category, collabel) value,

const uint16 ScanKeywordTokens[] = {
#include "parser/kwlist.h"
};

#undef PG_KEYWORD

/*
 * Set the type of YYSTYPE.
 */
#define YYSTYPE core_YYSTYPE

/*
 * Each call to yylex must set yylloc to the location of the found token
 * (expressed as a byte offset from the start of the input text).
 * When we parse a token that requires multiple lexer rules to process,
 * this should be done in the first such rule, else yylloc will point
 * into the middle of the token.
 */
#define SET_YYLLOC()  (*(yylloc) = yytext - yyextra->scanbuf)

/*
 * Advance yylloc by the given number of bytes.
 */
#define ADVANCE_YYLLOC(delta)  ( *(yylloc) += (delta) )

/*
 * Sometimes, we do want yylloc to point into the middle of a token; this is
 * useful for instance to throw an error about an escape sequence within a
 * string literal.  But if we find no error there, we want to revert yylloc
 * to the token start, so that that's the location reported to the parser.
 * Use PUSH_YYLLOC/POP_YYLLOC to save/restore yylloc around such code.
 * (Currently the implied "stack" is just one location, but someday we might
 * need to nest these.)
 */
#define PUSH_YYLLOC()	(yyextra->save_yylloc = *(yylloc))
#define POP_YYLLOC()	(*(yylloc) = yyextra->save_yylloc)

#define startlit()	( yyextra->literallen = 0 )
static void addlit(char *ytext, int yleng, core_yyscan_t yyscanner);
static void addlitchar(unsigned char ychar, core_yyscan_t yyscanner);
static char *litbufdup(core_yyscan_t yyscanner);
static unsigned char unescape_single_char(unsigned char c, core_yyscan_t yyscanner);
static int	process_integer_literal(const char *token, YYSTYPE *lval, int base);
static void addunicode(pg_wchar c, yyscan_t yyscanner);

#define yyerror(msg)  scanner_yyerror(msg, yyscanner)

#define lexer_errposition()  scanner_errposition(*(yylloc), yyscanner)

static void check_string_escape_warning(unsigned char ychar, core_yyscan_t yyscanner);
static void check_escape_warning(core_yyscan_t yyscanner);

#line 8878 "scan.c"
#define YY_NO_INPUT 1
/*
 * OK, here is a short description of lex/flex rules behavior.
 * The longest pattern which matches an input string is always chosen.
 * For equal-length patterns, the first occurring in the rules list is chosen.
 * INITIAL is the starting state, to which all non-conditional rules apply.
 * Exclusive states change parsing rules while the state is active.  When in
 * an exclusive state, only those rules defined for that state apply.
 *
 * We use exclusive states for quoted strings, extended comments,
 * and to eliminate parsing troubles for numeric strings.
 * Exclusive states:
 *  <xb> bit string literal
 *  <xc> extended C-style comments
 *  <xd> delimited identifiers (double-quoted identifiers)
 *  <xh> hexadecimal byte string
 *  <xq> standard quoted strings
 *  <xqs> quote stop (detect continued strings)
 *  <xe> extended quoted strings (support backslash escape sequences)
 *  <xdolq> $foo$ quoted strings
 *  <xui> quoted identifier with Unicode escapes
 *  <xus> quoted string with Unicode escapes
 *  <xeu> Unicode surrogate pair in extended quoted string
 *
 * Remember to add an <<EOF>> case whenever you add a new exclusive state!
 * The default one is probably not the right thing.
 */

/*
 * In order to make the world safe for Windows and Mac clients as well as
 * Unix ones, we accept either \n or \r as a newline.  A DOS-style \r\n
 * sequence will be seen as two successive newlines, but that doesn't cause
 * any problems.  Comments that start with -- and extend to the next
 * newline are treated as equivalent to a single whitespace character.
 *
 * NOTE a fine point: if there is no newline following --, we will absorb
 * everything to the end of the input as a comment.  This is correct.  Older
 * versions of Postgres failed to recognize -- as a comment if the input
 * did not end with a newline.
 *
 * non_newline_space tracks all the other space characters except newlines.
 *
 * XXX if you change the set of whitespace characters, fix scanner_isspace()
 * to agree.
 */
/*
 * SQL requires at least one newline in the whitespace separating
 * string literals that are to be concatenated.  Silly, but who are we
 * to argue?  Note that {whitespace_with_newline} should not have * after
 * it, whereas {whitespace} should generally have a * after it...
 */
/* If we see {quote} then {quotecontinue}, the quoted string continues */
/*
 * {quotecontinuefail} is needed to avoid lexer backup when we fail to match
 * {quotecontinue}.  It might seem that this could just be {whitespace}*,
 * but if there's a dash after {whitespace_with_newline}, it must be consumed
 * to see if there's another dash --- which would start a {comment} and thus
 * allow continuation of the {quotecontinue} token.
 */
/* Bit string
 * It is tempting to scan the string for only those characters
 * which are allowed. However, this leads to silently swallowed
 * characters if illegal characters are included in the string.
 * For example, if xbinside is [01] then B'ABCD' is interpreted
 * as a zero-length string, and the ABCD' is lost!
 * Better to pass the string forward and let the input routines
 * validate the contents.
 */
/* Hexadecimal byte string */
/* National character */
/* Quoted string that allows backslash escapes */
/* Extended quote
 * xqdouble implements embedded quote, ''''
 */
/* $foo$ style quotes ("dollar quoting")
 * The quoted string starts with $foo$ where "foo" is an optional string
 * in the form of an identifier, except that it may not contain "$",
 * and extends to the first occurrence of an identical string.
 * There is *no* processing of the quoted text.
 *
 * {dolqfailed} is an error rule to avoid scanner backup when {dolqdelim}
 * fails to match its trailing "$".
 */
/* Double quote
 * Allows embedded spaces and other special characters into identifiers.
 */
/* Quoted identifier with Unicode escapes */
/* Quoted string with Unicode escapes */
/* error rule to avoid backup */
/* C-style comments
 *
 * The "extended comment" syntax closely resembles allowable operator syntax.
 * The tricky part here is to get lex to recognize a string starting with
 * slash-star as a comment, when interpreting it as an operator would produce
 * a longer match --- remember lex will prefer a longer match!  Also, if we
 * have something like plus-slash-star, lex will think this is a 3-character
 * operator whereas we want to see it as a + operator and a comment start.
 * The solution is two-fold:
 * 1. append {op_chars}* to xcstart so that it matches as much text as
 *    {operator} would. Then the tie-breaker (first matching rule of same
 *    length) ensures xcstart wins.  We put back the extra stuff with yyless()
 *    in case it contains a star-slash that should terminate the comment.
 * 2. In the operator rule, check for slash-star within the operator, and
 *    if found throw it back with yyless().  This handles the plus-slash-star
 *    problem.
 * Dash-dash comments have similar interactions with the operator rule.
 */
/* Assorted special-case operators and operator-like tokens */
/*
 * These operator-like tokens (unlike the above ones) also match the {operator}
 * rule, which means that they might be overridden by a longer match if they
 * are followed by a comment start or a + or - character. Accordingly, if you
 * add to this list, you must also add corresponding code to the {operator}
 * block to return the correct token in such cases. (This is not needed in
 * psqlscan.l since the token value is ignored there.)
 */
/*
 * "self" is the set of chars that should be returned as single-character
 * tokens.  "op_chars" is the set of chars that can make up "Op" tokens,
 * which can be one or more characters long (but if a single-char token
 * appears in the "self" set, it is not to be returned as an Op).  Note
 * that the sets overlap, but each has some chars that are not in the other.
 *
 * If you change either set, adjust the character lists appearing in the
 * rule for "operator"!
 */
/*
 * Numbers
 *
 * Unary minus is not part of a number here.  Instead we pass it separately to
 * the parser, and there it gets coerced via doNegate().
 *
 * {numericfail} is used because we would like "1..10" to lex as 1, dot_dot, 10.
 *
 * {realfail} is added to prevent the need for scanner
 * backup when the {real} rule fails to match completely.
 */
/* Positional parameters don't accept underscores. */
/*
 * An identifier immediately following an integer literal is disallowed because
 * in some cases it's ambiguous what is meant: for example, 0x1234 could be
 * either a hexinteger or a decinteger "0" and an identifier "x1234".  We can
 * detect such problems by seeing if integer_junk matches a longer substring
 * than any of the XXXinteger patterns (decinteger, hexinteger, octinteger,
 * bininteger).  One "junk" pattern is sufficient because
 * {decinteger}{identifier} will match all the same strings we'd match with
 * {hexinteger}{identifier} etc.
 *
 * Note that the rule for integer_junk must appear after the ones for
 * XXXinteger to make this work correctly: 0x1234 will match both hexinteger
 * and integer_junk, and we need hexinteger to be chosen in that case.
 *
 * Also disallow strings matched by numeric_junk, real_junk and param_junk
 * for consistency.
 */
/*
 * Dollar quoted strings are totally opaque, and no escaping is done on them.
 * Other quoted strings must allow some special characters such as single-quote
 *  and newline.
 * Embedded single-quotes are implemented both in the SQL standard
 *  style of two adjacent single quotes "''" and in the Postgres/Java style
 *  of escaped-quote "\'".
 * Other embedded escaped characters are matched explicitly and the leading
 *  backslash is dropped from the string.
 * Note that xcstart must appear before operator, as explained above!
 *  Also whitespace (comment) must appear before operator.
 */
#line 9046 "scan.c"

#define INITIAL 0
#define xb 1
#define xc 2
#define xd 3
#define xh 4
#define xq 5
#define xqs 6
#define xe 7
#define xdolq 8
#define xui 9
#define xus 10
#define xeu 11

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#define YY_EXTRA_TYPE core_yy_extra_type *

/* Holds the entire state of the reentrant scanner. */
struct yyguts_t
    {

    /* User-defined. Not touched by flex. */
    YY_EXTRA_TYPE yyextra_r;

    /* The rest are the same as the globals declared in the non-reentrant scanner. */
    FILE *yyin_r, *yyout_r;
    size_t yy_buffer_stack_top; /**< index of top of stack. */
    size_t yy_buffer_stack_max; /**< capacity of stack. */
    YY_BUFFER_STATE * yy_buffer_stack; /**< Stack as an array. */
    char yy_hold_char;
    int yy_n_chars;
    int yyleng_r;
    char *yy_c_buf_p;
    int yy_init;
    int yy_start;
    int yy_did_buffer_switch_on_eof;
    int yy_start_stack_ptr;
    int yy_start_stack_depth;
    int *yy_start_stack;
    yy_state_type yy_last_accepting_state;
    char* yy_last_accepting_cpos;

    int yylineno_r;
    int yy_flex_debug_r;

    char *yytext_r;
    int yy_more_flag;
    int yy_more_len;

    YYSTYPE * yylval_r;

    YYLTYPE * yylloc_r;

    }; /* end struct yyguts_t */

static int yy_init_globals ( yyscan_t yyscanner );

    /* This must go here because YYSTYPE and YYLTYPE are included
     * from bison output in section 1.*/
    #    define yylval yyg->yylval_r
    
    #    define yylloc yyg->yylloc_r
    
int yylex_init (yyscan_t* scanner);

int yylex_init_extra ( YY_EXTRA_TYPE user_defined, yyscan_t* scanner);

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int yylex_destroy ( yyscan_t yyscanner );

int yyget_debug ( yyscan_t yyscanner );

void yyset_debug ( int debug_flag , yyscan_t yyscanner );

YY_EXTRA_TYPE yyget_extra ( yyscan_t yyscanner );

void yyset_extra ( YY_EXTRA_TYPE user_defined , yyscan_t yyscanner );

FILE *yyget_in ( yyscan_t yyscanner );

void yyset_in  ( FILE * _in_str , yyscan_t yyscanner );

FILE *yyget_out ( yyscan_t yyscanner );

void yyset_out  ( FILE * _out_str , yyscan_t yyscanner );

			int yyget_leng ( yyscan_t yyscanner );

char *yyget_text ( yyscan_t yyscanner );

int yyget_lineno ( yyscan_t yyscanner );

void yyset_lineno ( int _line_number , yyscan_t yyscanner );

int yyget_column  ( yyscan_t yyscanner );

void yyset_column ( int _column_no , yyscan_t yyscanner );

YYSTYPE * yyget_lval ( yyscan_t yyscanner );

void yyset_lval ( YYSTYPE * yylval_param , yyscan_t yyscanner );

       YYLTYPE *yyget_lloc ( yyscan_t yyscanner );
    
        void yyset_lloc ( YYLTYPE * yylloc_param , yyscan_t yyscanner );
    
/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap ( yyscan_t yyscanner );
#else
extern int yywrap ( yyscan_t yyscanner );
#endif
#endif

#ifndef YY_NO_UNPUT
    
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy ( char *, const char *, int , yyscan_t yyscanner);
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen ( const char * , yyscan_t yyscanner);
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput ( yyscan_t yyscanner );
#else
static int input ( yyscan_t yyscanner );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, (size_t) yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		int n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = (int) fread(buf, 1, (yy_size_t) max_size, yyin)) == 0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg , yyscanner)
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int yylex \
               (YYSTYPE * yylval_param, YYLTYPE * yylloc_param , yyscan_t yyscanner);

#define YY_DECL int yylex \
               (YYSTYPE * yylval_param, YYLTYPE * yylloc_param , yyscan_t yyscanner)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    yylval = yylval_param;

    yylloc = yylloc_param;

	if ( !yyg->yy_init )
		{
		yyg->yy_init = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! yyg->yy_start )
			yyg->yy_start = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack (yyscanner);
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner);
		}

		yy_load_buffer_state( yyscanner );
		}

	{
#line 441 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"


#line 9340 "scan.c"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
		yy_cp = yyg->yy_c_buf_p;

		/* Support of yytext. */
		*yy_cp = yyg->yy_hold_char;

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = yy_start_state_list[yyg->yy_start];
yy_match:
		{
		const struct yy_trans_info *yy_trans_info;

		YY_CHAR yy_c;

		for ( yy_c = YY_SC_TO_UI(*yy_cp);
		      (yy_trans_info = &yy_current_state[yy_c])->
		yy_verify == yy_c;
		      yy_c = YY_SC_TO_UI(*++yy_cp) )
			yy_current_state += yy_trans_info->yy_nxt;
		}

yy_find_action:
		yy_act = yy_current_state[-1].yy_nxt;

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 443 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					/* ignore */
				}
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 447 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					/* Set location in case of syntax error in comment */
					SET_YYLLOC();
					yyextra->xcdepth = 0;
					BEGIN(xc);
					/* Put back any characters past slash-star; see above */
					yyless(2);
				}
	YY_BREAK

case 3:
YY_RULE_SETUP
#line 457 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					(yyextra->xcdepth)++;
					/* Put back any characters past slash-star; see above */
					yyless(2);
				}
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 463 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					if (yyextra->xcdepth <= 0)
						BEGIN(INITIAL);
					else
						(yyextra->xcdepth)--;
				}
	YY_BREAK
case 5:
/* rule 5 can match eol */
YY_RULE_SETUP
#line 470 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					/* ignore */
				}
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 474 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					/* ignore */
				}
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 478 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					/* ignore */
				}
	YY_BREAK
case YY_STATE_EOF(xc):
#line 482 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					yyerror("unterminated /* comment");
				}
	YY_BREAK
/* <xc> */
case 8:
YY_RULE_SETUP
#line 487 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					/* Binary bit type.
					 * At some point we should simply pass the string
					 * forward to the parser and label it there.
					 * In the meantime, place a leading "b" on the string
					 * to mark it for the input routine as a binary string.
					 */
					SET_YYLLOC();
					BEGIN(xb);
					startlit();
					addlitchar('b', yyscanner);
				}
	YY_BREAK
case 9:
/* rule 9 can match eol */
#line 500 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
case 10:
/* rule 10 can match eol */
YY_RULE_SETUP
#line 500 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					addlit(yytext, yyleng, yyscanner);
				}
	YY_BREAK
case YY_STATE_EOF(xb):
#line 503 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{ yyerror("unterminated bit string literal"); }
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 505 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					/* Hexadecimal bit type.
					 * At some point we should simply pass the string
					 * forward to the parser and label it there.
					 * In the meantime, place a leading "x" on the string
					 * to mark it for the input routine as a hex string.
					 */
					SET_YYLLOC();
					BEGIN(xh);
					startlit();
					addlitchar('x', yyscanner);
				}
	YY_BREAK
case YY_STATE_EOF(xh):
#line 517 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{ yyerror("unterminated hexadecimal string literal"); }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 519 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					/* National character.
					 * We will pass this along as a normal character string,
					 * but preceded with an internally-generated "NCHAR".
					 */
					int		kwnum;

					SET_YYLLOC();
					yyless(1);	/* eat only 'n' this time */

					kwnum = ScanKeywordLookup("nchar",
											  yyextra->keywordlist);
					if (kwnum >= 0)
					{
						yylval->keyword = GetScanKeyword(kwnum,
														 yyextra->keywordlist);
						return yyextra->keyword_tokens[kwnum];
					}
					else
					{
						/* If NCHAR isn't a keyword, just return "n" */
						yylval->str = pstrdup("n");
						return IDENT;
					}
				}
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 545 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					yyextra->warn_on_first_escape = true;
					yyextra->saw_non_ascii = false;
					SET_YYLLOC();
					if (yyextra->standard_conforming_strings)
						BEGIN(xq);
					else
						BEGIN(xe);
					startlit();
				}
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 555 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					yyextra->warn_on_first_escape = false;
					yyextra->saw_non_ascii = false;
					SET_YYLLOC();
					BEGIN(xe);
					startlit();
				}
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 562 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					SET_YYLLOC();
					if (!yyextra->standard_conforming_strings)
						ereport(ERROR,
								(errcode(ERRCODE_FEATURE_NOT_SUPPORTED),
								 errmsg("unsafe use of string constant with Unicode escapes"),
								 errdetail("String constants with Unicode escapes cannot be used when \"standard_conforming_strings\" is off."),
								 lexer_errposition()));
					BEGIN(xus);
					startlit();
				}
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 574 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					/*
					 * When we are scanning a quoted string and see an end
					 * quote, we must look ahead for a possible continuation.
					 * If we don't see one, we know the end quote was in fact
					 * the end of the string.  To reduce the lexer table size,
					 * we use a single "xqs" state to do the lookahead for all
					 * types of strings.
					 */
					yyextra->state_before_str_stop = YYSTATE;
					BEGIN(xqs);
				}
	YY_BREAK
case 17:
/* rule 17 can match eol */
YY_RULE_SETUP
#line 586 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					/*
					 * Found a quote continuation, so return to the in-quote
					 * state and continue scanning the literal.  Nothing is
					 * added to the literal's contents.
					 */
					BEGIN(yyextra->state_before_str_stop);
				}
	YY_BREAK
case 18:
/* rule 18 can match eol */
#line 595 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
case 19:
/* rule 19 can match eol */
#line 596 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
YY_RULE_SETUP
case YY_STATE_EOF(xqs):
#line 596 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					/*
					 * Failed to see a quote continuation.  Throw back
					 * everything after the end quote, and handle the string
					 * according to the state we were in previously.
					 */
					yyless(0);
					BEGIN(INITIAL);

					switch (yyextra->state_before_str_stop)
					{
						case xb:
							yylval->str = litbufdup(yyscanner);
							return BCONST;
						case xh:
							yylval->str = litbufdup(yyscanner);
							return XCONST;
						case xq:
						case xe:
							/*
							 * Check that the data remains valid, if it might
							 * have been made invalid by unescaping any chars.
							 */
							if (yyextra->saw_non_ascii)
								pg_verifymbstr(yyextra->literalbuf,
											   yyextra->literallen,
											   false);
							yylval->str = litbufdup(yyscanner);
							return SCONST;
						case xus:
							yylval->str = litbufdup(yyscanner);
							return USCONST;
						default:
							yyerror("unhandled previous state in xqs");
					}
				}
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 633 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					addlitchar('\'', yyscanner);
				}
	YY_BREAK
case 21:
/* rule 21 can match eol */
YY_RULE_SETUP
#line 636 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					addlit(yytext, yyleng, yyscanner);
				}
	YY_BREAK
case 22:
/* rule 22 can match eol */
YY_RULE_SETUP
#line 639 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					addlit(yytext, yyleng, yyscanner);
				}
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 642 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					pg_wchar	c = strtoul(yytext + 2, NULL, 16);

					/*
					 * For consistency with other productions, issue any
					 * escape warning with cursor pointing to start of string.
					 * We might want to change that, someday.
					 */
					check_escape_warning(yyscanner);

					/* Remember start of overall string token ... */
					PUSH_YYLLOC();
					/* ... and set the error cursor to point at this esc seq */
					SET_YYLLOC();

					if (is_utf16_surrogate_first(c))
					{
						yyextra->utf16_first_part = c;
						BEGIN(xeu);
					}
					else if (is_utf16_surrogate_second(c))
						yyerror("invalid Unicode surrogate pair");
					else
						addunicode(c, yyscanner);

					/* Restore yylloc to be start of string token */
					POP_YYLLOC();
				}
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 670 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					pg_wchar	c = strtoul(yytext + 2, NULL, 16);

					/* Remember start of overall string token ... */
					PUSH_YYLLOC();
					/* ... and set the error cursor to point at this esc seq */
					SET_YYLLOC();

					if (!is_utf16_surrogate_second(c))
						yyerror("invalid Unicode surrogate pair");

					c = surrogate_pair_to_codepoint(yyextra->utf16_first_part, c);

					addunicode(c, yyscanner);

					/* Restore yylloc to be start of string token */
					POP_YYLLOC();

					BEGIN(xe);
				}
	YY_BREAK
case 25:
#line 691 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
case 26:
/* rule 26 can match eol */
#line 692 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
YY_RULE_SETUP
case YY_STATE_EOF(xeu):
#line 692 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					/* Set the error cursor to point at missing esc seq */
					SET_YYLLOC();
					yyerror("invalid Unicode surrogate pair");
				}
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 697 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					/* Set the error cursor to point at malformed esc seq */
					SET_YYLLOC();
					ereport(ERROR,
							(errcode(ERRCODE_INVALID_ESCAPE_SEQUENCE),
							 errmsg("invalid Unicode escape"),
							 errhint("Unicode escapes must be \\uXXXX or \\UXXXXXXXX."),
							 lexer_errposition()));
				}
	YY_BREAK
case 28:
/* rule 28 can match eol */
YY_RULE_SETUP
#line 706 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					if (yytext[1] == '\'')
					{
						if (yyextra->backslash_quote == BACKSLASH_QUOTE_OFF ||
							(yyextra->backslash_quote == BACKSLASH_QUOTE_SAFE_ENCODING &&
							 PG_ENCODING_IS_CLIENT_ONLY(pg_get_client_encoding())))
							ereport(ERROR,
									(errcode(ERRCODE_NONSTANDARD_USE_OF_ESCAPE_CHARACTER),
									 errmsg("unsafe use of \\' in a string literal"),
									 errhint("Use '' to write quotes in strings. \\' is insecure in client-only encodings."),
									 lexer_errposition()));
					}
					check_string_escape_warning(yytext[1], yyscanner);
					addlitchar(unescape_single_char(yytext[1], yyscanner),
							   yyscanner);
				}
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 722 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					unsigned char c = strtoul(yytext + 1, NULL, 8);

					check_escape_warning(yyscanner);
					addlitchar(c, yyscanner);
					if (c == '\0' || IS_HIGHBIT_SET(c))
						yyextra->saw_non_ascii = true;
				}
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 730 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					unsigned char c = strtoul(yytext + 2, NULL, 16);

					check_escape_warning(yyscanner);
					addlitchar(c, yyscanner);
					if (c == '\0' || IS_HIGHBIT_SET(c))
						yyextra->saw_non_ascii = true;
				}
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 738 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					/* This is only needed for \ just before EOF */
					addlitchar(yytext[0], yyscanner);
				}
	YY_BREAK
case YY_STATE_EOF(xq):
case YY_STATE_EOF(xe):
case YY_STATE_EOF(xus):
#line 742 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{ yyerror("unterminated quoted string"); }
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 744 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					SET_YYLLOC();
					yyextra->dolqstart = pstrdup(yytext);
					BEGIN(xdolq);
					startlit();
				}
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 750 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					SET_YYLLOC();
					/* throw back all but the initial "$" */
					yyless(1);
					/* and treat it as {other} */
					return yytext[0];
				}
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 757 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					if (strcmp(yytext, yyextra->dolqstart) == 0)
					{
						pfree(yyextra->dolqstart);
						yyextra->dolqstart = NULL;
						BEGIN(INITIAL);
						yylval->str = litbufdup(yyscanner);
						return SCONST;
					}
					else
					{
						/*
						 * When we fail to match $...$ to dolqstart, transfer
						 * the $... part to the output, but put back the final
						 * $ for rescanning.  Consider $delim$...$junk$delim$
						 */
						addlit(yytext, yyleng - 1, yyscanner);
						yyless(yyleng - 1);
					}
				}
	YY_BREAK
case 35:
/* rule 35 can match eol */
YY_RULE_SETUP
#line 777 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					addlit(yytext, yyleng, yyscanner);
				}
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 780 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					addlit(yytext, yyleng, yyscanner);
				}
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 783 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					/* This is only needed for $ inside the quoted text */
					addlitchar(yytext[0], yyscanner);
				}
	YY_BREAK
case YY_STATE_EOF(xdolq):
#line 787 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{ yyerror("unterminated dollar-quoted string"); }
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 789 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					SET_YYLLOC();
					BEGIN(xd);
					startlit();
				}
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 794 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					SET_YYLLOC();
					BEGIN(xui);
					startlit();
				}
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 799 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					char	   *ident;

					BEGIN(INITIAL);
					if (yyextra->literallen == 0)
						yyerror("zero-length delimited identifier");
					ident = litbufdup(yyscanner);
					if (yyextra->literallen >= NAMEDATALEN)
						truncate_identifier(ident, yyextra->literallen, true);
					yylval->str = ident;
					return IDENT;
				}
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 811 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					BEGIN(INITIAL);
					if (yyextra->literallen == 0)
						yyerror("zero-length delimited identifier");
					/* can't truncate till after we de-escape the ident */
					yylval->str = litbufdup(yyscanner);
					return UIDENT;
				}
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 819 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					addlitchar('"', yyscanner);
				}
	YY_BREAK
case 43:
/* rule 43 can match eol */
YY_RULE_SETUP
#line 822 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					addlit(yytext, yyleng, yyscanner);
				}
	YY_BREAK
case YY_STATE_EOF(xd):
case YY_STATE_EOF(xui):
#line 825 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{ yyerror("unterminated quoted identifier"); }
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 827 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					char	   *ident;

					SET_YYLLOC();
					/* throw back all but the initial u/U */
					yyless(1);
					/* and treat it as {identifier} */
					ident = downcase_truncate_identifier(yytext, yyleng, true);
					yylval->str = ident;
					return IDENT;
				}
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 839 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					SET_YYLLOC();
					return TYPECAST;
				}
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 844 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					SET_YYLLOC();
					return DOT_DOT;
				}
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 849 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					SET_YYLLOC();
					return COLON_EQUALS;
				}
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 854 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					SET_YYLLOC();
					return EQUALS_GREATER;
				}
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 859 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					SET_YYLLOC();
					return LESS_EQUALS;
				}
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 864 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					SET_YYLLOC();
					return GREATER_EQUALS;
				}
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 869 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					/* We accept both "<>" and "!=" as meaning NOT_EQUALS */
					SET_YYLLOC();
					return NOT_EQUALS;
				}
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 875 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					/* We accept both "<>" and "!=" as meaning NOT_EQUALS */
					SET_YYLLOC();
					return NOT_EQUALS;
				}
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 881 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					SET_YYLLOC();
					return yytext[0];
				}
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 886 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					/*
					 * Check for embedded slash-star or dash-dash; those
					 * are comment starts, so operator must stop there.
					 * Note that slash-star or dash-dash at the first
					 * character will match a prior rule, not this one.
					 */
					int			nchars = yyleng;
					char	   *slashstar = strstr(yytext, "/*");
					char	   *dashdash = strstr(yytext, "--");

					if (slashstar && dashdash)
					{
						/* if both appear, take the first one */
						if (slashstar > dashdash)
							slashstar = dashdash;
					}
					else if (!slashstar)
						slashstar = dashdash;
					if (slashstar)
						nchars = slashstar - yytext;

					/*
					 * For SQL compatibility, '+' and '-' cannot be the
					 * last char of a multi-char operator unless the operator
					 * contains chars that are not in SQL operators.
					 * The idea is to lex '=-' as two operators, but not
					 * to forbid operator names like '?-' that could not be
					 * sequences of SQL operators.
					 */
					if (nchars > 1 &&
						(yytext[nchars - 1] == '+' ||
						 yytext[nchars - 1] == '-'))
					{
						int			ic;

						for (ic = nchars - 2; ic >= 0; ic--)
						{
							char c = yytext[ic];
							if (c == '~' || c == '!' || c == '@' ||
								c == '#' || c == '^' || c == '&' ||
								c == '|' || c == '`' || c == '?' ||
								c == '%')
								break;
						}
						if (ic < 0)
						{
							/*
							 * didn't find a qualifying character, so remove
							 * all trailing [+-]
							 */
							do {
								nchars--;
							} while (nchars > 1 &&
								 (yytext[nchars - 1] == '+' ||
								  yytext[nchars - 1] == '-'));
						}
					}

					SET_YYLLOC();

					if (nchars < yyleng)
					{
						/* Strip the unwanted chars from the token */
						yyless(nchars);
						/*
						 * If what we have left is only one char, and it's
						 * one of the characters matching "self", then
						 * return it as a character token the same way
						 * that the "self" rule would have.
						 */
						if (nchars == 1 &&
							strchr(",()[].;:+-*/%^<>=", yytext[0]))
							return yytext[0];
						/*
						 * Likewise, if what we have left is two chars, and
						 * those match the tokens ">=", "<=", "=>", "<>" or
						 * "!=", then we must return the appropriate token
						 * rather than the generic Op.
						 */
						if (nchars == 2)
						{
							if (yytext[0] == '=' && yytext[1] == '>')
								return EQUALS_GREATER;
							if (yytext[0] == '>' && yytext[1] == '=')
								return GREATER_EQUALS;
							if (yytext[0] == '<' && yytext[1] == '=')
								return LESS_EQUALS;
							if (yytext[0] == '<' && yytext[1] == '>')
								return NOT_EQUALS;
							if (yytext[0] == '!' && yytext[1] == '=')
								return NOT_EQUALS;
						}
					}

					/*
					 * Complain if operator is too long.  Unlike the case
					 * for identifiers, we make this an error not a notice-
					 * and-truncate, because the odds are we are looking at
					 * a syntactic mistake anyway.
					 */
					if (nchars >= NAMEDATALEN)
						yyerror("operator too long");

					yylval->str = pstrdup(yytext);
					return Op;
				}
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 994 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					ErrorSaveContext escontext = {T_ErrorSaveContext};
					int32		val;

					SET_YYLLOC();
					val = pg_strtoint32_safe(yytext + 1, (Node *) &escontext);
					if (escontext.error_occurred)
						yyerror("parameter number too large");
					yylval->ival = val;
					return PARAM;
				}
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 1005 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					SET_YYLLOC();
					yyerror("trailing junk after parameter");
				}
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 1010 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					SET_YYLLOC();
					return process_integer_literal(yytext, yylval, 10);
				}
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 1014 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					SET_YYLLOC();
					return process_integer_literal(yytext, yylval, 16);
				}
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 1018 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					SET_YYLLOC();
					return process_integer_literal(yytext, yylval, 8);
				}
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 1022 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					SET_YYLLOC();
					return process_integer_literal(yytext, yylval, 2);
				}
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 1026 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					SET_YYLLOC();
					yyerror("invalid hexadecimal integer");
				}
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 1030 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					SET_YYLLOC();
					yyerror("invalid octal integer");
				}
	YY_BREAK
case 63:
YY_RULE_SETUP
#line 1034 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					SET_YYLLOC();
					yyerror("invalid binary integer");
				}
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 1038 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					SET_YYLLOC();
					yylval->str = pstrdup(yytext);
					return FCONST;
				}
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 1043 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					/* throw back the .., and treat as integer */
					yyless(yyleng - 2);
					SET_YYLLOC();
					return process_integer_literal(yytext, yylval, 10);
				}
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 1049 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					SET_YYLLOC();
					yylval->str = pstrdup(yytext);
					return FCONST;
				}
	YY_BREAK
case 67:
YY_RULE_SETUP
#line 1054 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					SET_YYLLOC();
					yyerror("trailing junk after numeric literal");
				}
	YY_BREAK
case 68:
YY_RULE_SETUP
#line 1058 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					SET_YYLLOC();
					yyerror("trailing junk after numeric literal");
				}
	YY_BREAK
case 69:
YY_RULE_SETUP
#line 1062 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					SET_YYLLOC();
					yyerror("trailing junk after numeric literal");
				}
	YY_BREAK
case 70:
YY_RULE_SETUP
#line 1066 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					SET_YYLLOC();
					yyerror("trailing junk after numeric literal");
				}
	YY_BREAK
case 71:
YY_RULE_SETUP
#line 1072 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					int			kwnum;
					char	   *ident;

					SET_YYLLOC();

					/* Is it a keyword? */
					kwnum = ScanKeywordLookup(yytext,
											  yyextra->keywordlist);
					if (kwnum >= 0)
					{
						yylval->keyword = GetScanKeyword(kwnum,
														 yyextra->keywordlist);
						return yyextra->keyword_tokens[kwnum];
					}

					/*
					 * No.  Convert the identifier to lower case, and truncate
					 * if necessary.
					 */
					ident = downcase_truncate_identifier(yytext, yyleng, true);
					yylval->str = ident;
					return IDENT;
				}
	YY_BREAK
case 72:
YY_RULE_SETUP
#line 1097 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					SET_YYLLOC();
					return yytext[0];
				}
	YY_BREAK
case YY_STATE_EOF(INITIAL):
#line 1102 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
{
					SET_YYLLOC();
					yyterminate();
				}
	YY_BREAK
case 73:
YY_RULE_SETUP
#line 1107 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"
YY_FATAL_ERROR( "flex scanner jammed" );
	YY_BREAK
#line 10331 "scan.c"

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - yyg->yytext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = yyg->yy_hold_char;
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( yyg->yy_c_buf_p <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			yyg->yy_c_buf_p = yyg->yytext_ptr + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state( yyscanner );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state , yyscanner);

			yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++yyg->yy_c_buf_p;
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = yyg->yy_c_buf_p;
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer( yyscanner ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				yyg->yy_did_buffer_switch_on_eof = 0;

				if ( yywrap( yyscanner ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					yyg->yy_c_buf_p = yyg->yytext_ptr + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				yyg->yy_c_buf_p =
					yyg->yytext_ptr + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				yyg->yy_c_buf_p =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars];

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = yyg->yytext_ptr;
	int number_to_move, i;
	int ret_val;

	if ( yyg->yy_c_buf_p > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( yyg->yy_c_buf_p - yyg->yytext_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (yyg->yy_c_buf_p - yyg->yytext_ptr - 1);

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) (yyg->yy_c_buf_p - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc( (void *) b->yy_ch_buf,
							 (yy_size_t) (b->yy_buf_size + 2) , yyscanner );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = NULL;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			yyg->yy_c_buf_p = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			yyg->yy_n_chars, num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	if ( yyg->yy_n_chars == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin  , yyscanner);
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((yyg->yy_n_chars + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		int new_size = yyg->yy_n_chars + number_to_move + (yyg->yy_n_chars >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc(
			(void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf, (yy_size_t) new_size , yyscanner );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
		/* "- 2" to take care of EOB's */
		YY_CURRENT_BUFFER_LVALUE->yy_buf_size = (int) (new_size - 2);
	}

	yyg->yy_n_chars += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	yyg->yytext_ptr = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (yyscan_t yyscanner)
{
	yy_state_type yy_current_state;
	char *yy_cp;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	yy_current_state = yy_start_state_list[yyg->yy_start];

	for ( yy_cp = yyg->yytext_ptr + YY_MORE_ADJ; yy_cp < yyg->yy_c_buf_p; ++yy_cp )
		{
		yy_current_state += yy_current_state[(*yy_cp ? YY_SC_TO_UI(*yy_cp) : 256)].yy_nxt;
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state , yyscan_t yyscanner)
{
	int yy_is_jam;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner; /* This var may be unused depending upon options. */

	int yy_c = 256;
	const struct yy_trans_info *yy_trans_info;

	yy_trans_info = &yy_current_state[(unsigned int) yy_c];
	yy_current_state += yy_trans_info->yy_nxt;
	yy_is_jam = (yy_trans_info->yy_verify != yy_c);

	(void)yyg;
	return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT

#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (yyscan_t yyscanner)
#else
    static int input  (yyscan_t yyscanner)
#endif

{
	int c;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	*yyg->yy_c_buf_p = yyg->yy_hold_char;

	if ( *yyg->yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( yyg->yy_c_buf_p < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			/* This was really a NUL. */
			*yyg->yy_c_buf_p = '\0';

		else
			{ /* need more input */
			int offset = (int) (yyg->yy_c_buf_p - yyg->yytext_ptr);
			++yyg->yy_c_buf_p;

			switch ( yy_get_next_buffer( yyscanner ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin , yyscanner);

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap( yyscanner ) )
						return 0;

					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput(yyscanner);
#else
					return input(yyscanner);
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					yyg->yy_c_buf_p = yyg->yytext_ptr + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) yyg->yy_c_buf_p;	/* cast for 8-bit char's */
	*yyg->yy_c_buf_p = '\0';	/* preserve yytext */
	yyg->yy_hold_char = *++yyg->yy_c_buf_p;

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * @param yyscanner The scanner object.
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyrestart  (FILE * input_file , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack (yyscanner);
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner);
	}

	yy_init_buffer( YY_CURRENT_BUFFER, input_file , yyscanner);
	yy_load_buffer_state( yyscanner );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * @param yyscanner The scanner object.
 */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack (yyscanner);
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state( yyscanner );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	yyg->yy_did_buffer_switch_on_eof = 1;
}

static void yy_load_buffer_state  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	yyg->yytext_ptr = yyg->yy_c_buf_p = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	yyg->yy_hold_char = *yyg->yy_c_buf_p;
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * @param yyscanner The scanner object.
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state ) , yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc( (yy_size_t) (b->yy_buf_size + 2) , yyscanner );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file , yyscanner);

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * @param yyscanner The scanner object.
 */
    void yy_delete_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree( (void *) b->yy_ch_buf , yyscanner );

	yyfree( (void *) b , yyscanner );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file , yyscan_t yyscanner)

{
	int oerrno = errno;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	yy_flush_buffer( b , yyscanner);

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * @param yyscanner The scanner object.
 */
    void yy_flush_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state( yyscanner );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  @param yyscanner The scanner object.
 */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack(yyscanner);

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		yyg->yy_buffer_stack_top++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state( yyscanner );
	yyg->yy_did_buffer_switch_on_eof = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  @param yyscanner The scanner object.
 */
void yypop_buffer_state (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER , yyscanner);
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if (yyg->yy_buffer_stack_top > 0)
		--yyg->yy_buffer_stack_top;

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state( yyscanner );
		yyg->yy_did_buffer_switch_on_eof = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (yyscan_t yyscanner)
{
	yy_size_t num_to_alloc;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if (!yyg->yy_buffer_stack) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
      num_to_alloc = 1; /* After all that talk, this was set to 1 anyways... */
		yyg->yy_buffer_stack = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		memset(yyg->yy_buffer_stack, 0, num_to_alloc * sizeof(struct yy_buffer_state*));

		yyg->yy_buffer_stack_max = num_to_alloc;
		yyg->yy_buffer_stack_top = 0;
		return;
	}

	if (yyg->yy_buffer_stack_top >= (yyg->yy_buffer_stack_max) - 1){

		/* Increase the buffer to prepare for a possible push. */
		yy_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = yyg->yy_buffer_stack_max + grow_size;
		yyg->yy_buffer_stack = (struct yy_buffer_state**)yyrealloc
								(yyg->yy_buffer_stack,
								num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset(yyg->yy_buffer_stack + yyg->yy_buffer_stack_max, 0, grow_size * sizeof(struct yy_buffer_state*));
		yyg->yy_buffer_stack_max = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return NULL;

	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state ) , yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = (int) (size - 2);	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = NULL;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b , yyscanner );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (const char * yystr , yyscan_t yyscanner)
{
    
	return yy_scan_bytes( yystr, (int) strlen(yystr) , yyscanner);
}

/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (const char * yybytes, int  _yybytes_len , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = (yy_size_t) (_yybytes_len + 2);
	buf = (char *) yyalloc( n , yyscanner );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n , yyscanner);
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yynoreturn yy_fatal_error (const char* msg , yyscan_t yyscanner)
{
	struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	(void)yyg;
	fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = yyg->yy_hold_char; \
		yyg->yy_c_buf_p = yytext + yyless_macro_arg; \
		yyg->yy_hold_char = *yyg->yy_c_buf_p; \
		*yyg->yy_c_buf_p = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the user-defined data for this scanner.
 * @param yyscanner The scanner object.
 */
YY_EXTRA_TYPE yyget_extra  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyextra;
}

/** Get the current line number.
 * @param yyscanner The scanner object.
 */
int yyget_lineno  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        if (! YY_CURRENT_BUFFER)
            return 0;
    
    return yylineno;
}

/** Get the current column number.
 * @param yyscanner The scanner object.
 */
int yyget_column  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        if (! YY_CURRENT_BUFFER)
            return 0;
    
    return yycolumn;
}

/** Get the input stream.
 * @param yyscanner The scanner object.
 */
FILE *yyget_in  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyin;
}

/** Get the output stream.
 * @param yyscanner The scanner object.
 */
FILE *yyget_out  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyout;
}

/** Get the length of the current token.
 * @param yyscanner The scanner object.
 */
int yyget_leng  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyleng;
}

/** Get the current token.
 * @param yyscanner The scanner object.
 */

char *yyget_text  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yytext;
}

/** Set the user-defined data. This data is never touched by the scanner.
 * @param user_defined The data to be associated with this scanner.
 * @param yyscanner The scanner object.
 */
void yyset_extra (YY_EXTRA_TYPE  user_defined , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyextra = user_defined ;
}

/** Set the current line number.
 * @param _line_number line number
 * @param yyscanner The scanner object.
 */
void yyset_lineno (int  _line_number , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        /* lineno is only valid if an input buffer exists. */
        if (! YY_CURRENT_BUFFER )
           YY_FATAL_ERROR( "yyset_lineno called with no buffer" );
    
    yylineno = _line_number;
}

/** Set the current column.
 * @param _column_no column number
 * @param yyscanner The scanner object.
 */
void yyset_column (int  _column_no , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        /* column is only valid if an input buffer exists. */
        if (! YY_CURRENT_BUFFER )
           YY_FATAL_ERROR( "yyset_column called with no buffer" );
    
    yycolumn = _column_no;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * @param yyscanner The scanner object.
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  _in_str , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyin = _in_str ;
}

void yyset_out (FILE *  _out_str , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyout = _out_str ;
}

int yyget_debug  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yy_flex_debug;
}

void yyset_debug (int  _bdebug , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yy_flex_debug = _bdebug ;
}

/* Accessor methods for yylval and yylloc */

YYSTYPE * yyget_lval  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yylval;
}

void yyset_lval (YYSTYPE *  yylval_param , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yylval = yylval_param;
}

YYLTYPE *yyget_lloc  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yylloc;
}
    
void yyset_lloc (YYLTYPE *  yylloc_param , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yylloc = yylloc_param;
}
    
/* User-visible API */

/* yylex_init is special because it creates the scanner itself, so it is
 * the ONLY reentrant function that doesn't take the scanner as the last argument.
 * That's why we explicitly handle the declaration, instead of using our macros.
 */
int yylex_init(yyscan_t* ptr_yy_globals)
{
    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }

    *ptr_yy_globals = (yyscan_t) yyalloc ( sizeof( struct yyguts_t ), NULL );

    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }

    /* By setting to 0xAA, we expose bugs in yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));

    return yy_init_globals ( *ptr_yy_globals );
}

/* yylex_init_extra has the same functionality as yylex_init, but follows the
 * convention of taking the scanner as the last argument. Note however, that
 * this is a *pointer* to a scanner, as it will be allocated by this call (and
 * is the reason, too, why this function also must handle its own declaration).
 * The user defined value in the first argument will be available to yyalloc in
 * the yyextra field.
 */
int yylex_init_extra( YY_EXTRA_TYPE yy_user_defined, yyscan_t* ptr_yy_globals )
{
    struct yyguts_t dummy_yyguts;

    yyset_extra (yy_user_defined, &dummy_yyguts);

    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }

    *ptr_yy_globals = (yyscan_t) yyalloc ( sizeof( struct yyguts_t ), &dummy_yyguts );

    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }

    /* By setting to 0xAA, we expose bugs in
    yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));

    yyset_extra (yy_user_defined, *ptr_yy_globals);

    return yy_init_globals ( *ptr_yy_globals );
}

static int yy_init_globals (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    yyg->yy_buffer_stack = NULL;
    yyg->yy_buffer_stack_top = 0;
    yyg->yy_buffer_stack_max = 0;
    yyg->yy_c_buf_p = NULL;
    yyg->yy_init = 0;
    yyg->yy_start = 0;

    yyg->yy_start_stack_ptr = 0;
    yyg->yy_start_stack_depth = 0;
    yyg->yy_start_stack =  NULL;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = NULL;
    yyout = NULL;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer( YY_CURRENT_BUFFER , yyscanner );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state(yyscanner);
	}

	/* Destroy the stack itself. */
	yyfree(yyg->yy_buffer_stack , yyscanner);
	yyg->yy_buffer_stack = NULL;

    /* Destroy the start condition stack. */
        yyfree( yyg->yy_start_stack , yyscanner );
        yyg->yy_start_stack = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * yylex() is called, initialization will occur. */
    yy_init_globals( yyscanner);

    /* Destroy the main struct (reentrant only). */
    yyfree ( yyscanner , yyscanner );
    yyscanner = NULL;
    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, const char * s2, int n , yyscan_t yyscanner)
{
	struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	(void)yyg;

	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (const char * s , yyscan_t yyscanner)
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

#define YYTABLES_NAME "yytables"

#line 1107 "/build/postgresql/src/build/../postgresql-18.1/src/backend/parser/scan.l"


/* LCOV_EXCL_STOP */

/*
 * Arrange access to yyextra for subroutines of the main yylex() function.
 * We expect each subroutine to have a yyscanner parameter.  Rather than
 * use the yyget_xxx functions, which might or might not get inlined by the
 * compiler, we cheat just a bit and cast yyscanner to the right type.
 */
#undef yyextra
#define yyextra  (((struct yyguts_t *) yyscanner)->yyextra_r)

/* Likewise for a couple of other things we need. */
#undef yylloc
#define yylloc	(((struct yyguts_t *) yyscanner)->yylloc_r)
#undef yyleng
#define yyleng	(((struct yyguts_t *) yyscanner)->yyleng_r)


/*
 * scanner_errposition
 *		Report a lexer or grammar error cursor position, if possible.
 *
 * This is expected to be used within an ereport() call, or via an error
 * callback such as setup_scanner_errposition_callback().  The return value
 * is a dummy (always 0, in fact).
 *
 * Note that this can only be used for messages emitted during raw parsing
 * (essentially, scan.l, parser.c, and gram.y), since it requires the
 * yyscanner struct to still be available.
 */
int
scanner_errposition(int location, core_yyscan_t yyscanner)
{
	int			pos;

	if (location < 0)
		return 0;				/* no-op if location is unknown */

	/* Convert byte offset to character number */
	pos = pg_mbstrlen_with_len(yyextra->scanbuf, location) + 1;
	/* And pass it to the ereport mechanism */
	return errposition(pos);
}

/*
 * Error context callback for inserting scanner error location.
 *
 * Note that this will be called for *any* error occurring while the
 * callback is installed.  We avoid inserting an irrelevant error location
 * if the error is a query cancel --- are there any other important cases?
 */
static void
scb_error_callback(void *arg)
{
	ScannerCallbackState *scbstate = (ScannerCallbackState *) arg;

	if (geterrcode() != ERRCODE_QUERY_CANCELED)
		(void) scanner_errposition(scbstate->location, scbstate->yyscanner);
}

/*
 * setup_scanner_errposition_callback
 *		Arrange for non-scanner errors to report an error position
 *
 * Sometimes the scanner calls functions that aren't part of the scanner
 * subsystem and can't reasonably be passed the yyscanner pointer; yet
 * we would like any errors thrown in those functions to be tagged with an
 * error location.  Use this function to set up an error context stack
 * entry that will accomplish that.  Usage pattern:
 *
 *		declare a local variable "ScannerCallbackState scbstate"
 *		...
 *		setup_scanner_errposition_callback(&scbstate, yyscanner, location);
 *		call function that might throw error;
 *		cancel_scanner_errposition_callback(&scbstate);
 */
void
setup_scanner_errposition_callback(ScannerCallbackState *scbstate,
								   core_yyscan_t yyscanner,
								   int location)
{
	/* Setup error traceback support for ereport() */
	scbstate->yyscanner = yyscanner;
	scbstate->location = location;
	scbstate->errcallback.callback = scb_error_callback;
	scbstate->errcallback.arg = scbstate;
	scbstate->errcallback.previous = error_context_stack;
	error_context_stack = &scbstate->errcallback;
}

/*
 * Cancel a previously-set-up errposition callback.
 */
void
cancel_scanner_errposition_callback(ScannerCallbackState *scbstate)
{
	/* Pop the error context stack */
	error_context_stack = scbstate->errcallback.previous;
}

/*
 * scanner_yyerror
 *		Report a lexer or grammar error.
 *
 * The message's cursor position is whatever YYLLOC was last set to,
 * ie, the start of the current token if called within yylex(), or the
 * most recently lexed token if called from the grammar.
 * This is OK for syntax error messages from the Bison parser, because Bison
 * parsers report error as soon as the first unparsable token is reached.
 * Beware of using yyerror for other purposes, as the cursor position might
 * be misleading!
 */
void
scanner_yyerror(const char *message, core_yyscan_t yyscanner)
{
	const char *loc = yyextra->scanbuf + *yylloc;

	if (*loc == YY_END_OF_BUFFER_CHAR)
	{
		ereport(ERROR,
				(errcode(ERRCODE_SYNTAX_ERROR),
		/* translator: %s is typically the translation of "syntax error" */
				 errmsg("%s at end of input", _(message)),
				 lexer_errposition()));
	}
	else
	{
		ereport(ERROR,
				(errcode(ERRCODE_SYNTAX_ERROR),
		/* translator: first %s is typically the translation of "syntax error" */
				 errmsg("%s at or near \"%s\"", _(message), loc),
				 lexer_errposition()));
	}
}


/*
 * Called before any actual parsing is done
 */
core_yyscan_t
scanner_init(const char *str,
			 core_yy_extra_type *yyext,
			 const ScanKeywordList *keywordlist,
			 const uint16 *keyword_tokens)
{
	Size		slen = strlen(str);
	yyscan_t	scanner;

	if (yylex_init(&scanner) != 0)
		elog(ERROR, "yylex_init() failed: %m");

	core_yyset_extra(yyext, scanner);

	yyext->keywordlist = keywordlist;
	yyext->keyword_tokens = keyword_tokens;

	yyext->backslash_quote = backslash_quote;
	yyext->escape_string_warning = escape_string_warning;
	yyext->standard_conforming_strings = standard_conforming_strings;

	/*
	 * Make a scan buffer with special termination needed by flex.
	 */
	yyext->scanbuf = (char *) palloc(slen + 2);
	yyext->scanbuflen = slen;
	memcpy(yyext->scanbuf, str, slen);
	yyext->scanbuf[slen] = yyext->scanbuf[slen + 1] = YY_END_OF_BUFFER_CHAR;
	yy_scan_buffer(yyext->scanbuf, slen + 2, scanner);

	/* initialize literal buffer to a reasonable but expansible size */
	yyext->literalalloc = 1024;
	yyext->literalbuf = (char *) palloc(yyext->literalalloc);
	yyext->literallen = 0;

	return scanner;
}


/*
 * Called after parsing is done to clean up after scanner_init()
 */
void
scanner_finish(core_yyscan_t yyscanner)
{
	/*
	 * We don't bother to call yylex_destroy(), because all it would do is
	 * pfree a small amount of control storage.  It's cheaper to leak the
	 * storage until the parsing context is destroyed.  The amount of space
	 * involved is usually negligible compared to the output parse tree
	 * anyway.
	 *
	 * We do bother to pfree the scanbuf and literal buffer, but only if they
	 * represent a nontrivial amount of space.  The 8K cutoff is arbitrary.
	 */
	if (yyextra->scanbuflen >= 8192)
		pfree(yyextra->scanbuf);
	if (yyextra->literalalloc >= 8192)
		pfree(yyextra->literalbuf);
}


static void
addlit(char *ytext, int yleng, core_yyscan_t yyscanner)
{
	/* enlarge buffer if needed */
	if ((yyextra->literallen + yleng) >= yyextra->literalalloc)
	{
		yyextra->literalalloc = pg_nextpower2_32(yyextra->literallen + yleng + 1);
		yyextra->literalbuf = (char *) repalloc(yyextra->literalbuf,
												yyextra->literalalloc);
	}
	/* append new data */
	memcpy(yyextra->literalbuf + yyextra->literallen, ytext, yleng);
	yyextra->literallen += yleng;
}


static void
addlitchar(unsigned char ychar, core_yyscan_t yyscanner)
{
	/* enlarge buffer if needed */
	if ((yyextra->literallen + 1) >= yyextra->literalalloc)
	{
		yyextra->literalalloc *= 2;
		yyextra->literalbuf = (char *) repalloc(yyextra->literalbuf,
												yyextra->literalalloc);
	}
	/* append new data */
	yyextra->literalbuf[yyextra->literallen] = ychar;
	yyextra->literallen += 1;
}


/*
 * Create a palloc'd copy of literalbuf, adding a trailing null.
 */
static char *
litbufdup(core_yyscan_t yyscanner)
{
	int			llen = yyextra->literallen;
	char	   *new;

	new = palloc(llen + 1);
	memcpy(new, yyextra->literalbuf, llen);
	new[llen] = '\0';
	return new;
}

/*
 * Process {decinteger}, {hexinteger}, etc.  Note this will also do the right
 * thing with {numeric}, ie digits and a decimal point.
 */
static int
process_integer_literal(const char *token, YYSTYPE *lval, int base)
{
	ErrorSaveContext escontext = {T_ErrorSaveContext};
	int32		val;

	val = pg_strtoint32_safe(token, (Node *) &escontext);
	if (escontext.error_occurred)
	{
		/* integer too large (or contains decimal pt), treat it as a float */
		lval->str = pstrdup(token);
		return FCONST;
	}
	lval->ival = val;
	return ICONST;
}

static void
addunicode(pg_wchar c, core_yyscan_t yyscanner)
{
	ScannerCallbackState scbstate;
	char		buf[MAX_UNICODE_EQUIVALENT_STRING + 1];

	if (!is_valid_unicode_codepoint(c))
		yyerror("invalid Unicode escape value");

	/*
	 * We expect that pg_unicode_to_server() will complain about any
	 * unconvertible code point, so we don't have to set saw_non_ascii.
	 */
	setup_scanner_errposition_callback(&scbstate, yyscanner, *(yylloc));
	pg_unicode_to_server(c, (unsigned char *) buf);
	cancel_scanner_errposition_callback(&scbstate);
	addlit(buf, strlen(buf), yyscanner);
}

static unsigned char
unescape_single_char(unsigned char c, core_yyscan_t yyscanner)
{
	switch (c)
	{
		case 'b':
			return '\b';
		case 'f':
			return '\f';
		case 'n':
			return '\n';
		case 'r':
			return '\r';
		case 't':
			return '\t';
		case 'v':
			return '\v';
		default:
			/* check for backslash followed by non-7-bit-ASCII */
			if (c == '\0' || IS_HIGHBIT_SET(c))
				yyextra->saw_non_ascii = true;

			return c;
	}
}

static void
check_string_escape_warning(unsigned char ychar, core_yyscan_t yyscanner)
{
	if (ychar == '\'')
	{
		if (yyextra->warn_on_first_escape && yyextra->escape_string_warning)
			ereport(WARNING,
					(errcode(ERRCODE_NONSTANDARD_USE_OF_ESCAPE_CHARACTER),
					 errmsg("nonstandard use of \\' in a string literal"),
					 errhint("Use '' to write quotes in strings, or use the escape string syntax (E'...')."),
					 lexer_errposition()));
		yyextra->warn_on_first_escape = false;	/* warn only once per string */
	}
	else if (ychar == '\\')
	{
		if (yyextra->warn_on_first_escape && yyextra->escape_string_warning)
			ereport(WARNING,
					(errcode(ERRCODE_NONSTANDARD_USE_OF_ESCAPE_CHARACTER),
					 errmsg("nonstandard use of \\\\ in a string literal"),
					 errhint("Use the escape string syntax for backslashes, e.g., E'\\\\'."),
					 lexer_errposition()));
		yyextra->warn_on_first_escape = false;	/* warn only once per string */
	}
	else
		check_escape_warning(yyscanner);
}

static void
check_escape_warning(core_yyscan_t yyscanner)
{
	if (yyextra->warn_on_first_escape && yyextra->escape_string_warning)
		ereport(WARNING,
				(errcode(ERRCODE_NONSTANDARD_USE_OF_ESCAPE_CHARACTER),
				 errmsg("nonstandard use of escape in a string literal"),
				 errhint("Use the escape string syntax for escapes, e.g., E'\\r\\n'."),
				 lexer_errposition()));
	yyextra->warn_on_first_escape = false;	/* warn only once per string */
}

/*
 * Interface functions to make flex use palloc() instead of malloc().
 * It'd be better to make these static, but flex insists otherwise.
 */

void *
core_yyalloc(yy_size_t bytes, core_yyscan_t yyscanner)
{
	return palloc(bytes);
}

void *
core_yyrealloc(void *ptr, yy_size_t bytes, core_yyscan_t yyscanner)
{
	if (ptr)
		return repalloc(ptr, bytes);
	else
		return palloc(bytes);
}

void
core_yyfree(void *ptr, core_yyscan_t yyscanner)
{
	if (ptr)
		pfree(ptr);
}

