#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void GLTFSampler_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkAVSucdReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkBYUReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkBYUWriter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkChacoReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkFacetWriter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkFLUENTReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkGAMBITReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkGLTFDocumentLoader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkGLTFReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkGLTFTexture_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkGLTFWriter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkHoudiniPolyDataWriter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkIVWriter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkMCubesReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkMCubesWriter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkMFIXReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkOBJReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkOBJWriter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkOFFReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkOpenFOAMReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkParticleReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkProStarReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPTSReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSTLReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSTLWriter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkTecplotReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkWindBladeReader_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkIOGeometryCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  GLTFSampler_Init(csi);
  vtkAVSucdReader_Init(csi);
  vtkBYUReader_Init(csi);
  vtkBYUWriter_Init(csi);
  vtkChacoReader_Init(csi);
  vtkFacetWriter_Init(csi);
  vtkFLUENTReader_Init(csi);
  vtkGAMBITReader_Init(csi);
  vtkGLTFDocumentLoader_Init(csi);
  vtkGLTFReader_Init(csi);
  vtkGLTFTexture_Init(csi);
  vtkGLTFWriter_Init(csi);
  vtkHoudiniPolyDataWriter_Init(csi);
  vtkIVWriter_Init(csi);
  vtkMCubesReader_Init(csi);
  vtkMCubesWriter_Init(csi);
  vtkMFIXReader_Init(csi);
  vtkOBJReader_Init(csi);
  vtkOBJWriter_Init(csi);
  vtkOFFReader_Init(csi);
  vtkOpenFOAMReader_Init(csi);
  vtkParticleReader_Init(csi);
  vtkProStarReader_Init(csi);
  vtkPTSReader_Init(csi);
  vtkSTLReader_Init(csi);
  vtkSTLWriter_Init(csi);
  vtkTecplotReader_Init(csi);
  vtkWindBladeReader_Init(csi);
}
