/* Automatically generated from ../src/remote/remote_protocol.x by gendispatch.pl.
 * Do not edit this file.  Any changes you make will be lost.
 */
static int remoteDispatchAuthList(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_auth_list_ret *ret);
static int remoteDispatchAuthListHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args G_GNUC_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchAuthList");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchAuthList(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchAuthList body has to be implemented manually */



static int remoteDispatchAuthPolkit(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_auth_polkit_ret *ret);
static int remoteDispatchAuthPolkitHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args G_GNUC_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchAuthPolkit");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchAuthPolkit(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchAuthPolkit body has to be implemented manually */



static int remoteDispatchAuthSaslInit(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_auth_sasl_init_ret *ret);
static int remoteDispatchAuthSaslInitHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args G_GNUC_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchAuthSaslInit");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchAuthSaslInit(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchAuthSaslInit body has to be implemented manually */



static int remoteDispatchAuthSaslStart(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_auth_sasl_start_args *args,
    remote_auth_sasl_start_ret *ret);
static int remoteDispatchAuthSaslStartHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchAuthSaslStart");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchAuthSaslStart(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchAuthSaslStart body has to be implemented manually */



static int remoteDispatchAuthSaslStep(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_auth_sasl_step_args *args,
    remote_auth_sasl_step_ret *ret);
static int remoteDispatchAuthSaslStepHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchAuthSaslStep");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchAuthSaslStep(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchAuthSaslStep body has to be implemented manually */



static int remoteDispatchConnectBaselineCPU(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_baseline_cpu_args *args,
    remote_connect_baseline_cpu_ret *ret);
static int remoteDispatchConnectBaselineCPUHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectBaselineCPU");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectBaselineCPU(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectBaselineCPU(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_connect_baseline_cpu_args *args,
    remote_connect_baseline_cpu_ret *ret)
{
    int rv = -1;
    char *cpu;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if ((cpu = virConnectBaselineCPU(conn, (const char **) args->xmlCPUs.xmlCPUs_val, args->xmlCPUs.xmlCPUs_len, args->flags)) == NULL)
        goto cleanup;

    ret->cpu = cpu;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectBaselineHypervisorCPU(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_baseline_hypervisor_cpu_args *args,
    remote_connect_baseline_hypervisor_cpu_ret *ret);
static int remoteDispatchConnectBaselineHypervisorCPUHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectBaselineHypervisorCPU");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectBaselineHypervisorCPU(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectBaselineHypervisorCPU(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_connect_baseline_hypervisor_cpu_args *args,
    remote_connect_baseline_hypervisor_cpu_ret *ret)
{
    int rv = -1;
    char *emulator;
    char *arch;
    char *machine;
    char *virttype;
    char *cpu;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    emulator = args->emulator ? *args->emulator : NULL;
    arch = args->arch ? *args->arch : NULL;
    machine = args->machine ? *args->machine : NULL;
    virttype = args->virttype ? *args->virttype : NULL;

    if ((cpu = virConnectBaselineHypervisorCPU(conn, emulator, arch, machine, virttype, (const char **) args->xmlCPUs.xmlCPUs_val, args->xmlCPUs.xmlCPUs_len, args->flags)) == NULL)
        goto cleanup;

    ret->cpu = cpu;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectClose(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr);
static int remoteDispatchConnectCloseHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args G_GNUC_UNUSED,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectClose");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectClose(server, client, msg, rerr);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchConnectClose body has to be implemented manually */



static int remoteDispatchConnectCompareCPU(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_compare_cpu_args *args,
    remote_connect_compare_cpu_ret *ret);
static int remoteDispatchConnectCompareCPUHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectCompareCPU");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectCompareCPU(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectCompareCPU(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_connect_compare_cpu_args *args,
    remote_connect_compare_cpu_ret *ret)
{
    int rv = -1;
    int result;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if ((result = virConnectCompareCPU(conn, args->xml, args->flags)) < 0)
        goto cleanup;

    ret->result = result;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectCompareHypervisorCPU(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_compare_hypervisor_cpu_args *args,
    remote_connect_compare_hypervisor_cpu_ret *ret);
static int remoteDispatchConnectCompareHypervisorCPUHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectCompareHypervisorCPU");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectCompareHypervisorCPU(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectCompareHypervisorCPU(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_connect_compare_hypervisor_cpu_args *args,
    remote_connect_compare_hypervisor_cpu_ret *ret)
{
    int rv = -1;
    char *emulator;
    char *arch;
    char *machine;
    char *virttype;
    int result;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    emulator = args->emulator ? *args->emulator : NULL;
    arch = args->arch ? *args->arch : NULL;
    machine = args->machine ? *args->machine : NULL;
    virttype = args->virttype ? *args->virttype : NULL;

    if ((result = virConnectCompareHypervisorCPU(conn, emulator, arch, machine, virttype, args->xmlCPU, args->flags)) < 0)
        goto cleanup;

    ret->result = result;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectDomainEventCallbackDeregisterAny(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_domain_event_callback_deregister_any_args *args);
static int remoteDispatchConnectDomainEventCallbackDeregisterAnyHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectDomainEventCallbackDeregisterAny");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectDomainEventCallbackDeregisterAny(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchConnectDomainEventCallbackDeregisterAny body has to be implemented manually */



static int remoteDispatchConnectDomainEventCallbackRegisterAny(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_domain_event_callback_register_any_args *args,
    remote_connect_domain_event_callback_register_any_ret *ret);
static int remoteDispatchConnectDomainEventCallbackRegisterAnyHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectDomainEventCallbackRegisterAny");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectDomainEventCallbackRegisterAny(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchConnectDomainEventCallbackRegisterAny body has to be implemented manually */



static int remoteDispatchConnectDomainEventDeregister(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_domain_event_deregister_ret *ret);
static int remoteDispatchConnectDomainEventDeregisterHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args G_GNUC_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectDomainEventDeregister");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectDomainEventDeregister(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchConnectDomainEventDeregister body has to be implemented manually */



static int remoteDispatchConnectDomainEventDeregisterAny(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_domain_event_deregister_any_args *args);
static int remoteDispatchConnectDomainEventDeregisterAnyHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectDomainEventDeregisterAny");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectDomainEventDeregisterAny(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchConnectDomainEventDeregisterAny body has to be implemented manually */



static int remoteDispatchConnectDomainEventRegister(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_domain_event_register_ret *ret);
static int remoteDispatchConnectDomainEventRegisterHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args G_GNUC_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectDomainEventRegister");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectDomainEventRegister(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchConnectDomainEventRegister body has to be implemented manually */



static int remoteDispatchConnectDomainEventRegisterAny(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_domain_event_register_any_args *args);
static int remoteDispatchConnectDomainEventRegisterAnyHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectDomainEventRegisterAny");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectDomainEventRegisterAny(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchConnectDomainEventRegisterAny body has to be implemented manually */



static int remoteDispatchConnectDomainXMLFromNative(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_domain_xml_from_native_args *args,
    remote_connect_domain_xml_from_native_ret *ret);
static int remoteDispatchConnectDomainXMLFromNativeHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectDomainXMLFromNative");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectDomainXMLFromNative(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectDomainXMLFromNative(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_connect_domain_xml_from_native_args *args,
    remote_connect_domain_xml_from_native_ret *ret)
{
    int rv = -1;
    char *domainXml;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if ((domainXml = virConnectDomainXMLFromNative(conn, args->nativeFormat, args->nativeConfig, args->flags)) == NULL)
        goto cleanup;

    ret->domainXml = domainXml;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectDomainXMLToNative(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_domain_xml_to_native_args *args,
    remote_connect_domain_xml_to_native_ret *ret);
static int remoteDispatchConnectDomainXMLToNativeHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectDomainXMLToNative");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectDomainXMLToNative(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectDomainXMLToNative(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_connect_domain_xml_to_native_args *args,
    remote_connect_domain_xml_to_native_ret *ret)
{
    int rv = -1;
    char *nativeConfig;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if ((nativeConfig = virConnectDomainXMLToNative(conn, args->nativeFormat, args->domainXml, args->flags)) == NULL)
        goto cleanup;

    ret->nativeConfig = nativeConfig;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectFindStoragePoolSources(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_find_storage_pool_sources_args *args,
    remote_connect_find_storage_pool_sources_ret *ret);
static int remoteDispatchConnectFindStoragePoolSourcesHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectFindStoragePoolSources");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectFindStoragePoolSources(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectFindStoragePoolSources(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_connect_find_storage_pool_sources_args *args,
    remote_connect_find_storage_pool_sources_ret *ret)
{
    int rv = -1;
    char *srcSpec;
    char *xml;

    virConnectPtr conn = remoteGetStorageConn(client);
    if (!conn)
        goto cleanup;

    srcSpec = args->srcSpec ? *args->srcSpec : NULL;

    if ((xml = virConnectFindStoragePoolSources(conn, args->type, srcSpec, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectGetAllDomainStats(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_get_all_domain_stats_args *args,
    remote_connect_get_all_domain_stats_ret *ret);
static int remoteDispatchConnectGetAllDomainStatsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectGetAllDomainStats");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectGetAllDomainStats(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchConnectGetAllDomainStats body has to be implemented manually */



static int remoteDispatchConnectGetCapabilities(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_get_capabilities_ret *ret);
static int remoteDispatchConnectGetCapabilitiesHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args G_GNUC_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectGetCapabilities");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectGetCapabilities(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectGetCapabilities(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_connect_get_capabilities_ret *ret)
{
    int rv = -1;
    char *capabilities;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if ((capabilities = virConnectGetCapabilities(conn)) == NULL)
        goto cleanup;

    ret->capabilities = capabilities;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectGetCPUModelNames(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_get_cpu_model_names_args *args,
    remote_connect_get_cpu_model_names_ret *ret);
static int remoteDispatchConnectGetCPUModelNamesHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectGetCPUModelNames");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectGetCPUModelNames(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchConnectGetCPUModelNames body has to be implemented manually */



static int remoteDispatchConnectGetDomainCapabilities(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_get_domain_capabilities_args *args,
    remote_connect_get_domain_capabilities_ret *ret);
static int remoteDispatchConnectGetDomainCapabilitiesHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectGetDomainCapabilities");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectGetDomainCapabilities(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectGetDomainCapabilities(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_connect_get_domain_capabilities_args *args,
    remote_connect_get_domain_capabilities_ret *ret)
{
    int rv = -1;
    char *emulatorbin;
    char *arch;
    char *machine;
    char *virttype;
    char *capabilities;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    emulatorbin = args->emulatorbin ? *args->emulatorbin : NULL;
    arch = args->arch ? *args->arch : NULL;
    machine = args->machine ? *args->machine : NULL;
    virttype = args->virttype ? *args->virttype : NULL;

    if ((capabilities = virConnectGetDomainCapabilities(conn, emulatorbin, arch, machine, virttype, args->flags)) == NULL)
        goto cleanup;

    ret->capabilities = capabilities;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectGetHostname(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_get_hostname_ret *ret);
static int remoteDispatchConnectGetHostnameHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args G_GNUC_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectGetHostname");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectGetHostname(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectGetHostname(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_connect_get_hostname_ret *ret)
{
    int rv = -1;
    char *hostname;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if ((hostname = virConnectGetHostname(conn)) == NULL)
        goto cleanup;

    ret->hostname = hostname;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectGetLibVersion(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_get_lib_version_ret *ret);
static int remoteDispatchConnectGetLibVersionHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args G_GNUC_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectGetLibVersion");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectGetLibVersion(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectGetLibVersion(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_connect_get_lib_version_ret *ret)
{
    int rv = -1;
    unsigned long lib_ver;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (virConnectGetLibVersion(conn, &lib_ver) < 0)
        goto cleanup;

    HYPER_TO_ULONG(ret->lib_ver, lib_ver);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectGetMaxVcpus(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_get_max_vcpus_args *args,
    remote_connect_get_max_vcpus_ret *ret);
static int remoteDispatchConnectGetMaxVcpusHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectGetMaxVcpus");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectGetMaxVcpus(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectGetMaxVcpus(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_connect_get_max_vcpus_args *args,
    remote_connect_get_max_vcpus_ret *ret)
{
    int rv = -1;
    char *type;
    int max_vcpus;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    type = args->type ? *args->type : NULL;

    if ((max_vcpus = virConnectGetMaxVcpus(conn, type)) < 0)
        goto cleanup;

    ret->max_vcpus = max_vcpus;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectGetStoragePoolCapabilities(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_get_storage_pool_capabilities_args *args,
    remote_connect_get_storage_pool_capabilities_ret *ret);
static int remoteDispatchConnectGetStoragePoolCapabilitiesHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectGetStoragePoolCapabilities");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectGetStoragePoolCapabilities(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectGetStoragePoolCapabilities(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_connect_get_storage_pool_capabilities_args *args,
    remote_connect_get_storage_pool_capabilities_ret *ret)
{
    int rv = -1;
    char *capabilities;

    virConnectPtr conn = remoteGetStorageConn(client);
    if (!conn)
        goto cleanup;

    if ((capabilities = virConnectGetStoragePoolCapabilities(conn, args->flags)) == NULL)
        goto cleanup;

    ret->capabilities = capabilities;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectGetSysinfo(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_get_sysinfo_args *args,
    remote_connect_get_sysinfo_ret *ret);
static int remoteDispatchConnectGetSysinfoHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectGetSysinfo");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectGetSysinfo(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectGetSysinfo(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_connect_get_sysinfo_args *args,
    remote_connect_get_sysinfo_ret *ret)
{
    int rv = -1;
    char *sysinfo;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if ((sysinfo = virConnectGetSysinfo(conn, args->flags)) == NULL)
        goto cleanup;

    ret->sysinfo = sysinfo;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectGetType(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_get_type_ret *ret);
static int remoteDispatchConnectGetTypeHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args G_GNUC_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectGetType");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectGetType(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectGetType(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_connect_get_type_ret *ret)
{
    int rv = -1;
    const char *type;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if ((type = virConnectGetType(conn)) == NULL)
        goto cleanup;

    /* We have to g_strdup because remoteDispatchClientRequest will
     * free this string after it's been serialised. */
    ret->type = g_strdup(type);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectGetURI(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_get_uri_ret *ret);
static int remoteDispatchConnectGetURIHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args G_GNUC_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectGetURI");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectGetURI(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectGetURI(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_connect_get_uri_ret *ret)
{
    int rv = -1;
    char *uri;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if ((uri = virConnectGetURI(conn)) == NULL)
        goto cleanup;

    ret->uri = uri;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectGetVersion(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_get_version_ret *ret);
static int remoteDispatchConnectGetVersionHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args G_GNUC_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectGetVersion");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectGetVersion(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectGetVersion(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_connect_get_version_ret *ret)
{
    int rv = -1;
    unsigned long hv_ver;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (virConnectGetVersion(conn, &hv_ver) < 0)
        goto cleanup;

    HYPER_TO_ULONG(ret->hv_ver, hv_ver);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectIsSecure(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_is_secure_ret *ret);
static int remoteDispatchConnectIsSecureHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args G_GNUC_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectIsSecure");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectIsSecure(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectIsSecure(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_connect_is_secure_ret *ret)
{
    int rv = -1;
    int secure;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if ((secure = virConnectIsSecure(conn)) < 0)
        goto cleanup;

    ret->secure = secure;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectListAllDomains(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_list_all_domains_args *args,
    remote_connect_list_all_domains_ret *ret);
static int remoteDispatchConnectListAllDomainsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectListAllDomains");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectListAllDomains(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectListAllDomains(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_connect_list_all_domains_args *args,
    remote_connect_list_all_domains_ret *ret)
{
    int rv = -1;
    ssize_t i;
    virDomain **result = NULL;
    int nresults = 0;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if ((nresults =
            virConnectListAllDomains(conn,
                                     args->need_results ? &result : NULL,
                                     args->flags)) < 0)
        goto cleanup;

    if (nresults > REMOTE_DOMAIN_LIST_MAX) {
        virReportError(VIR_ERR_INTERNAL_ERROR,
                       _("Too many domains '%1$d' for limit '%2$d'"),
                       nresults, REMOTE_DOMAIN_LIST_MAX);
        goto cleanup;
    }

    if (result && nresults) {
        ret->domains.domains_val =
            g_new0(typeof(*ret->domains.domains_val), nresults);

        ret->domains.domains_len = nresults;
        for (i = 0; i < nresults; i++)
            make_nonnull_domain(ret->domains.domains_val + i, result[i]);
    } else {
        ret->domains.domains_len = 0;
        ret->domains.domains_val = NULL;
    }

    ret->ret = nresults;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (result) {
        for (i = 0; i < nresults; i++)
            virObjectUnref(result[i]);
    }
    VIR_FREE(result);
    return rv;
}



static int remoteDispatchConnectListAllInterfaces(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_list_all_interfaces_args *args,
    remote_connect_list_all_interfaces_ret *ret);
static int remoteDispatchConnectListAllInterfacesHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectListAllInterfaces");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectListAllInterfaces(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectListAllInterfaces(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_connect_list_all_interfaces_args *args,
    remote_connect_list_all_interfaces_ret *ret)
{
    int rv = -1;
    ssize_t i;
    virInterface **result = NULL;
    int nresults = 0;

    virConnectPtr conn = remoteGetInterfaceConn(client);
    if (!conn)
        goto cleanup;

    if ((nresults =
            virConnectListAllInterfaces(conn,
                                        args->need_results ? &result : NULL,
                                        args->flags)) < 0)
        goto cleanup;

    if (nresults > REMOTE_INTERFACE_LIST_MAX) {
        virReportError(VIR_ERR_INTERNAL_ERROR,
                       _("Too many interfaces '%1$d' for limit '%2$d'"),
                       nresults, REMOTE_INTERFACE_LIST_MAX);
        goto cleanup;
    }

    if (result && nresults) {
        ret->ifaces.ifaces_val =
            g_new0(typeof(*ret->ifaces.ifaces_val), nresults);

        ret->ifaces.ifaces_len = nresults;
        for (i = 0; i < nresults; i++)
            make_nonnull_interface(ret->ifaces.ifaces_val + i, result[i]);
    } else {
        ret->ifaces.ifaces_len = 0;
        ret->ifaces.ifaces_val = NULL;
    }

    ret->ret = nresults;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (result) {
        for (i = 0; i < nresults; i++)
            virObjectUnref(result[i]);
    }
    VIR_FREE(result);
    return rv;
}



static int remoteDispatchConnectListAllNetworks(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_list_all_networks_args *args,
    remote_connect_list_all_networks_ret *ret);
static int remoteDispatchConnectListAllNetworksHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectListAllNetworks");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectListAllNetworks(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectListAllNetworks(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_connect_list_all_networks_args *args,
    remote_connect_list_all_networks_ret *ret)
{
    int rv = -1;
    ssize_t i;
    virNetwork **result = NULL;
    int nresults = 0;

    virConnectPtr conn = remoteGetNetworkConn(client);
    if (!conn)
        goto cleanup;

    if ((nresults =
            virConnectListAllNetworks(conn,
                                      args->need_results ? &result : NULL,
                                      args->flags)) < 0)
        goto cleanup;

    if (nresults > REMOTE_NETWORK_LIST_MAX) {
        virReportError(VIR_ERR_INTERNAL_ERROR,
                       _("Too many networks '%1$d' for limit '%2$d'"),
                       nresults, REMOTE_NETWORK_LIST_MAX);
        goto cleanup;
    }

    if (result && nresults) {
        ret->nets.nets_val =
            g_new0(typeof(*ret->nets.nets_val), nresults);

        ret->nets.nets_len = nresults;
        for (i = 0; i < nresults; i++)
            make_nonnull_network(ret->nets.nets_val + i, result[i]);
    } else {
        ret->nets.nets_len = 0;
        ret->nets.nets_val = NULL;
    }

    ret->ret = nresults;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (result) {
        for (i = 0; i < nresults; i++)
            virObjectUnref(result[i]);
    }
    VIR_FREE(result);
    return rv;
}



static int remoteDispatchConnectListAllNodeDevices(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_list_all_node_devices_args *args,
    remote_connect_list_all_node_devices_ret *ret);
static int remoteDispatchConnectListAllNodeDevicesHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectListAllNodeDevices");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectListAllNodeDevices(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectListAllNodeDevices(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_connect_list_all_node_devices_args *args,
    remote_connect_list_all_node_devices_ret *ret)
{
    int rv = -1;
    ssize_t i;
    virNodeDevice **result = NULL;
    int nresults = 0;

    virConnectPtr conn = remoteGetNodeDevConn(client);
    if (!conn)
        goto cleanup;

    if ((nresults =
            virConnectListAllNodeDevices(conn,
                                         args->need_results ? &result : NULL,
                                         args->flags)) < 0)
        goto cleanup;

    if (nresults > REMOTE_NODE_DEVICE_LIST_MAX) {
        virReportError(VIR_ERR_INTERNAL_ERROR,
                       _("Too many node_devices '%1$d' for limit '%2$d'"),
                       nresults, REMOTE_NODE_DEVICE_LIST_MAX);
        goto cleanup;
    }

    if (result && nresults) {
        ret->devices.devices_val =
            g_new0(typeof(*ret->devices.devices_val), nresults);

        ret->devices.devices_len = nresults;
        for (i = 0; i < nresults; i++)
            make_nonnull_node_device(ret->devices.devices_val + i, result[i]);
    } else {
        ret->devices.devices_len = 0;
        ret->devices.devices_val = NULL;
    }

    ret->ret = nresults;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (result) {
        for (i = 0; i < nresults; i++)
            virObjectUnref(result[i]);
    }
    VIR_FREE(result);
    return rv;
}



static int remoteDispatchConnectListAllNWFilterBindings(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_list_all_nwfilter_bindings_args *args,
    remote_connect_list_all_nwfilter_bindings_ret *ret);
static int remoteDispatchConnectListAllNWFilterBindingsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectListAllNWFilterBindings");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectListAllNWFilterBindings(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectListAllNWFilterBindings(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_connect_list_all_nwfilter_bindings_args *args,
    remote_connect_list_all_nwfilter_bindings_ret *ret)
{
    int rv = -1;
    ssize_t i;
    virNWFilterBinding **result = NULL;
    int nresults = 0;

    virConnectPtr conn = remoteGetNWFilterConn(client);
    if (!conn)
        goto cleanup;

    if ((nresults =
            virConnectListAllNWFilterBindings(conn,
                                              args->need_results ? &result : NULL,
                                              args->flags)) < 0)
        goto cleanup;

    if (nresults > REMOTE_NWFILTER_BINDING_LIST_MAX) {
        virReportError(VIR_ERR_INTERNAL_ERROR,
                       _("Too many nwfilter_bindings '%1$d' for limit '%2$d'"),
                       nresults, REMOTE_NWFILTER_BINDING_LIST_MAX);
        goto cleanup;
    }

    if (result && nresults) {
        ret->bindings.bindings_val =
            g_new0(typeof(*ret->bindings.bindings_val), nresults);

        ret->bindings.bindings_len = nresults;
        for (i = 0; i < nresults; i++)
            make_nonnull_nwfilter_binding(ret->bindings.bindings_val + i, result[i]);
    } else {
        ret->bindings.bindings_len = 0;
        ret->bindings.bindings_val = NULL;
    }

    ret->ret = nresults;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (result) {
        for (i = 0; i < nresults; i++)
            virObjectUnref(result[i]);
    }
    VIR_FREE(result);
    return rv;
}



static int remoteDispatchConnectListAllNWFilters(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_list_all_nwfilters_args *args,
    remote_connect_list_all_nwfilters_ret *ret);
static int remoteDispatchConnectListAllNWFiltersHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectListAllNWFilters");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectListAllNWFilters(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectListAllNWFilters(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_connect_list_all_nwfilters_args *args,
    remote_connect_list_all_nwfilters_ret *ret)
{
    int rv = -1;
    ssize_t i;
    virNWFilter **result = NULL;
    int nresults = 0;

    virConnectPtr conn = remoteGetNWFilterConn(client);
    if (!conn)
        goto cleanup;

    if ((nresults =
            virConnectListAllNWFilters(conn,
                                       args->need_results ? &result : NULL,
                                       args->flags)) < 0)
        goto cleanup;

    if (nresults > REMOTE_NWFILTER_LIST_MAX) {
        virReportError(VIR_ERR_INTERNAL_ERROR,
                       _("Too many nwfilters '%1$d' for limit '%2$d'"),
                       nresults, REMOTE_NWFILTER_LIST_MAX);
        goto cleanup;
    }

    if (result && nresults) {
        ret->filters.filters_val =
            g_new0(typeof(*ret->filters.filters_val), nresults);

        ret->filters.filters_len = nresults;
        for (i = 0; i < nresults; i++)
            make_nonnull_nwfilter(ret->filters.filters_val + i, result[i]);
    } else {
        ret->filters.filters_len = 0;
        ret->filters.filters_val = NULL;
    }

    ret->ret = nresults;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (result) {
        for (i = 0; i < nresults; i++)
            virObjectUnref(result[i]);
    }
    VIR_FREE(result);
    return rv;
}



static int remoteDispatchConnectListAllSecrets(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_list_all_secrets_args *args,
    remote_connect_list_all_secrets_ret *ret);
static int remoteDispatchConnectListAllSecretsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectListAllSecrets");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectListAllSecrets(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectListAllSecrets(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_connect_list_all_secrets_args *args,
    remote_connect_list_all_secrets_ret *ret)
{
    int rv = -1;
    ssize_t i;
    virSecret **result = NULL;
    int nresults = 0;

    virConnectPtr conn = remoteGetSecretConn(client);
    if (!conn)
        goto cleanup;

    if ((nresults =
            virConnectListAllSecrets(conn,
                                     args->need_results ? &result : NULL,
                                     args->flags)) < 0)
        goto cleanup;

    if (nresults > REMOTE_SECRET_LIST_MAX) {
        virReportError(VIR_ERR_INTERNAL_ERROR,
                       _("Too many secrets '%1$d' for limit '%2$d'"),
                       nresults, REMOTE_SECRET_LIST_MAX);
        goto cleanup;
    }

    if (result && nresults) {
        ret->secrets.secrets_val =
            g_new0(typeof(*ret->secrets.secrets_val), nresults);

        ret->secrets.secrets_len = nresults;
        for (i = 0; i < nresults; i++)
            make_nonnull_secret(ret->secrets.secrets_val + i, result[i]);
    } else {
        ret->secrets.secrets_len = 0;
        ret->secrets.secrets_val = NULL;
    }

    ret->ret = nresults;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (result) {
        for (i = 0; i < nresults; i++)
            virObjectUnref(result[i]);
    }
    VIR_FREE(result);
    return rv;
}



static int remoteDispatchConnectListAllStoragePools(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_list_all_storage_pools_args *args,
    remote_connect_list_all_storage_pools_ret *ret);
static int remoteDispatchConnectListAllStoragePoolsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectListAllStoragePools");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectListAllStoragePools(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectListAllStoragePools(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_connect_list_all_storage_pools_args *args,
    remote_connect_list_all_storage_pools_ret *ret)
{
    int rv = -1;
    ssize_t i;
    virStoragePool **result = NULL;
    int nresults = 0;

    virConnectPtr conn = remoteGetStorageConn(client);
    if (!conn)
        goto cleanup;

    if ((nresults =
            virConnectListAllStoragePools(conn,
                                          args->need_results ? &result : NULL,
                                          args->flags)) < 0)
        goto cleanup;

    if (nresults > REMOTE_STORAGE_POOL_LIST_MAX) {
        virReportError(VIR_ERR_INTERNAL_ERROR,
                       _("Too many storage_pools '%1$d' for limit '%2$d'"),
                       nresults, REMOTE_STORAGE_POOL_LIST_MAX);
        goto cleanup;
    }

    if (result && nresults) {
        ret->pools.pools_val =
            g_new0(typeof(*ret->pools.pools_val), nresults);

        ret->pools.pools_len = nresults;
        for (i = 0; i < nresults; i++)
            make_nonnull_storage_pool(ret->pools.pools_val + i, result[i]);
    } else {
        ret->pools.pools_len = 0;
        ret->pools.pools_val = NULL;
    }

    ret->ret = nresults;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (result) {
        for (i = 0; i < nresults; i++)
            virObjectUnref(result[i]);
    }
    VIR_FREE(result);
    return rv;
}



static int remoteDispatchConnectListDefinedDomains(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_list_defined_domains_args *args,
    remote_connect_list_defined_domains_ret *ret);
static int remoteDispatchConnectListDefinedDomainsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectListDefinedDomains");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectListDefinedDomains(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectListDefinedDomains(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_connect_list_defined_domains_args *args,
    remote_connect_list_defined_domains_ret *ret)
{
    int rv = -1;
    int len;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (args->maxnames < 0) {
        virReportError(VIR_ERR_RPC,
                       "%s", _("maxnames must be non-negative"));
        goto cleanup;
    }
    if (args->maxnames > REMOTE_DOMAIN_LIST_MAX) {
        virReportError(VIR_ERR_RPC,
                       "%s", _("maxnames > REMOTE_DOMAIN_LIST_MAX"));
        goto cleanup;
    }

    /* Allocate return buffer. */
    ret->names.names_val =
        g_new0(typeof(*ret->names.names_val), args->maxnames);

    if ((len = virConnectListDefinedDomains(conn, ret->names.names_val, args->maxnames)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    return rv;
}



static int remoteDispatchConnectListDefinedInterfaces(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_list_defined_interfaces_args *args,
    remote_connect_list_defined_interfaces_ret *ret);
static int remoteDispatchConnectListDefinedInterfacesHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectListDefinedInterfaces");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectListDefinedInterfaces(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectListDefinedInterfaces(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_connect_list_defined_interfaces_args *args,
    remote_connect_list_defined_interfaces_ret *ret)
{
    int rv = -1;
    int len;

    virConnectPtr conn = remoteGetInterfaceConn(client);
    if (!conn)
        goto cleanup;

    if (args->maxnames < 0) {
        virReportError(VIR_ERR_RPC,
                       "%s", _("maxnames must be non-negative"));
        goto cleanup;
    }
    if (args->maxnames > REMOTE_INTERFACE_LIST_MAX) {
        virReportError(VIR_ERR_RPC,
                       "%s", _("maxnames > REMOTE_INTERFACE_LIST_MAX"));
        goto cleanup;
    }

    /* Allocate return buffer. */
    ret->names.names_val =
        g_new0(typeof(*ret->names.names_val), args->maxnames);

    if ((len = virConnectListDefinedInterfaces(conn, ret->names.names_val, args->maxnames)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    return rv;
}



static int remoteDispatchConnectListDefinedNetworks(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_list_defined_networks_args *args,
    remote_connect_list_defined_networks_ret *ret);
static int remoteDispatchConnectListDefinedNetworksHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectListDefinedNetworks");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectListDefinedNetworks(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectListDefinedNetworks(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_connect_list_defined_networks_args *args,
    remote_connect_list_defined_networks_ret *ret)
{
    int rv = -1;
    int len;

    virConnectPtr conn = remoteGetNetworkConn(client);
    if (!conn)
        goto cleanup;

    if (args->maxnames < 0) {
        virReportError(VIR_ERR_RPC,
                       "%s", _("maxnames must be non-negative"));
        goto cleanup;
    }
    if (args->maxnames > REMOTE_NETWORK_LIST_MAX) {
        virReportError(VIR_ERR_RPC,
                       "%s", _("maxnames > REMOTE_NETWORK_LIST_MAX"));
        goto cleanup;
    }

    /* Allocate return buffer. */
    ret->names.names_val =
        g_new0(typeof(*ret->names.names_val), args->maxnames);

    if ((len = virConnectListDefinedNetworks(conn, ret->names.names_val, args->maxnames)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    return rv;
}



static int remoteDispatchConnectListDefinedStoragePools(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_list_defined_storage_pools_args *args,
    remote_connect_list_defined_storage_pools_ret *ret);
static int remoteDispatchConnectListDefinedStoragePoolsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectListDefinedStoragePools");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectListDefinedStoragePools(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectListDefinedStoragePools(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_connect_list_defined_storage_pools_args *args,
    remote_connect_list_defined_storage_pools_ret *ret)
{
    int rv = -1;
    int len;

    virConnectPtr conn = remoteGetStorageConn(client);
    if (!conn)
        goto cleanup;

    if (args->maxnames < 0) {
        virReportError(VIR_ERR_RPC,
                       "%s", _("maxnames must be non-negative"));
        goto cleanup;
    }
    if (args->maxnames > REMOTE_STORAGE_POOL_LIST_MAX) {
        virReportError(VIR_ERR_RPC,
                       "%s", _("maxnames > REMOTE_STORAGE_POOL_LIST_MAX"));
        goto cleanup;
    }

    /* Allocate return buffer. */
    ret->names.names_val =
        g_new0(typeof(*ret->names.names_val), args->maxnames);

    if ((len = virConnectListDefinedStoragePools(conn, ret->names.names_val, args->maxnames)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    return rv;
}



static int remoteDispatchConnectListDomains(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_list_domains_args *args,
    remote_connect_list_domains_ret *ret);
static int remoteDispatchConnectListDomainsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectListDomains");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectListDomains(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectListDomains(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_connect_list_domains_args *args,
    remote_connect_list_domains_ret *ret)
{
    int rv = -1;
    int len;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (args->maxids < 0) {
        virReportError(VIR_ERR_RPC,
                       "%s", _("maxids must be non-negative"));
        goto cleanup;
    }
    if (args->maxids > REMOTE_DOMAIN_LIST_MAX) {
        virReportError(VIR_ERR_RPC,
                       "%s", _("maxids > REMOTE_DOMAIN_LIST_MAX"));
        goto cleanup;
    }

    /* Allocate return buffer. */
    ret->ids.ids_val =
        g_new0(typeof(*ret->ids.ids_val), args->maxids);

    if ((len = virConnectListDomains(conn, ret->ids.ids_val, args->maxids)) < 0)
        goto cleanup;

    ret->ids.ids_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(ret->ids.ids_val);
    }
    return rv;
}



static int remoteDispatchConnectListInterfaces(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_list_interfaces_args *args,
    remote_connect_list_interfaces_ret *ret);
static int remoteDispatchConnectListInterfacesHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectListInterfaces");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectListInterfaces(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectListInterfaces(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_connect_list_interfaces_args *args,
    remote_connect_list_interfaces_ret *ret)
{
    int rv = -1;
    int len;

    virConnectPtr conn = remoteGetInterfaceConn(client);
    if (!conn)
        goto cleanup;

    if (args->maxnames < 0) {
        virReportError(VIR_ERR_RPC,
                       "%s", _("maxnames must be non-negative"));
        goto cleanup;
    }
    if (args->maxnames > REMOTE_INTERFACE_LIST_MAX) {
        virReportError(VIR_ERR_RPC,
                       "%s", _("maxnames > REMOTE_INTERFACE_LIST_MAX"));
        goto cleanup;
    }

    /* Allocate return buffer. */
    ret->names.names_val =
        g_new0(typeof(*ret->names.names_val), args->maxnames);

    if ((len = virConnectListInterfaces(conn, ret->names.names_val, args->maxnames)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    return rv;
}



static int remoteDispatchConnectListNetworks(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_list_networks_args *args,
    remote_connect_list_networks_ret *ret);
static int remoteDispatchConnectListNetworksHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectListNetworks");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectListNetworks(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectListNetworks(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_connect_list_networks_args *args,
    remote_connect_list_networks_ret *ret)
{
    int rv = -1;
    int len;

    virConnectPtr conn = remoteGetNetworkConn(client);
    if (!conn)
        goto cleanup;

    if (args->maxnames < 0) {
        virReportError(VIR_ERR_RPC,
                       "%s", _("maxnames must be non-negative"));
        goto cleanup;
    }
    if (args->maxnames > REMOTE_NETWORK_LIST_MAX) {
        virReportError(VIR_ERR_RPC,
                       "%s", _("maxnames > REMOTE_NETWORK_LIST_MAX"));
        goto cleanup;
    }

    /* Allocate return buffer. */
    ret->names.names_val =
        g_new0(typeof(*ret->names.names_val), args->maxnames);

    if ((len = virConnectListNetworks(conn, ret->names.names_val, args->maxnames)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    return rv;
}



static int remoteDispatchConnectListNWFilters(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_list_nwfilters_args *args,
    remote_connect_list_nwfilters_ret *ret);
static int remoteDispatchConnectListNWFiltersHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectListNWFilters");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectListNWFilters(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectListNWFilters(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_connect_list_nwfilters_args *args,
    remote_connect_list_nwfilters_ret *ret)
{
    int rv = -1;
    int len;

    virConnectPtr conn = remoteGetNWFilterConn(client);
    if (!conn)
        goto cleanup;

    if (args->maxnames < 0) {
        virReportError(VIR_ERR_RPC,
                       "%s", _("maxnames must be non-negative"));
        goto cleanup;
    }
    if (args->maxnames > REMOTE_NWFILTER_LIST_MAX) {
        virReportError(VIR_ERR_RPC,
                       "%s", _("maxnames > REMOTE_NWFILTER_LIST_MAX"));
        goto cleanup;
    }

    /* Allocate return buffer. */
    ret->names.names_val =
        g_new0(typeof(*ret->names.names_val), args->maxnames);

    if ((len = virConnectListNWFilters(conn, ret->names.names_val, args->maxnames)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    return rv;
}



static int remoteDispatchConnectListSecrets(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_list_secrets_args *args,
    remote_connect_list_secrets_ret *ret);
static int remoteDispatchConnectListSecretsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectListSecrets");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectListSecrets(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectListSecrets(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_connect_list_secrets_args *args,
    remote_connect_list_secrets_ret *ret)
{
    int rv = -1;
    int len;

    virConnectPtr conn = remoteGetSecretConn(client);
    if (!conn)
        goto cleanup;

    if (args->maxuuids < 0) {
        virReportError(VIR_ERR_RPC,
                       "%s", _("maxuuids must be non-negative"));
        goto cleanup;
    }
    if (args->maxuuids > REMOTE_SECRET_LIST_MAX) {
        virReportError(VIR_ERR_RPC,
                       "%s", _("maxuuids > REMOTE_SECRET_LIST_MAX"));
        goto cleanup;
    }

    /* Allocate return buffer. */
    ret->uuids.uuids_val =
        g_new0(typeof(*ret->uuids.uuids_val), args->maxuuids);

    if ((len = virConnectListSecrets(conn, ret->uuids.uuids_val, args->maxuuids)) < 0)
        goto cleanup;

    ret->uuids.uuids_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(ret->uuids.uuids_val);
    }
    return rv;
}



static int remoteDispatchConnectListStoragePools(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_list_storage_pools_args *args,
    remote_connect_list_storage_pools_ret *ret);
static int remoteDispatchConnectListStoragePoolsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectListStoragePools");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectListStoragePools(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectListStoragePools(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_connect_list_storage_pools_args *args,
    remote_connect_list_storage_pools_ret *ret)
{
    int rv = -1;
    int len;

    virConnectPtr conn = remoteGetStorageConn(client);
    if (!conn)
        goto cleanup;

    if (args->maxnames < 0) {
        virReportError(VIR_ERR_RPC,
                       "%s", _("maxnames must be non-negative"));
        goto cleanup;
    }
    if (args->maxnames > REMOTE_STORAGE_POOL_LIST_MAX) {
        virReportError(VIR_ERR_RPC,
                       "%s", _("maxnames > REMOTE_STORAGE_POOL_LIST_MAX"));
        goto cleanup;
    }

    /* Allocate return buffer. */
    ret->names.names_val =
        g_new0(typeof(*ret->names.names_val), args->maxnames);

    if ((len = virConnectListStoragePools(conn, ret->names.names_val, args->maxnames)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    return rv;
}



static int remoteDispatchConnectNetworkEventDeregisterAny(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_network_event_deregister_any_args *args);
static int remoteDispatchConnectNetworkEventDeregisterAnyHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectNetworkEventDeregisterAny");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectNetworkEventDeregisterAny(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchConnectNetworkEventDeregisterAny body has to be implemented manually */



static int remoteDispatchConnectNetworkEventRegisterAny(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_network_event_register_any_args *args,
    remote_connect_network_event_register_any_ret *ret);
static int remoteDispatchConnectNetworkEventRegisterAnyHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectNetworkEventRegisterAny");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectNetworkEventRegisterAny(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchConnectNetworkEventRegisterAny body has to be implemented manually */



static int remoteDispatchConnectNodeDeviceEventDeregisterAny(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_node_device_event_deregister_any_args *args);
static int remoteDispatchConnectNodeDeviceEventDeregisterAnyHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectNodeDeviceEventDeregisterAny");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectNodeDeviceEventDeregisterAny(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchConnectNodeDeviceEventDeregisterAny body has to be implemented manually */



static int remoteDispatchConnectNodeDeviceEventRegisterAny(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_node_device_event_register_any_args *args,
    remote_connect_node_device_event_register_any_ret *ret);
static int remoteDispatchConnectNodeDeviceEventRegisterAnyHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectNodeDeviceEventRegisterAny");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectNodeDeviceEventRegisterAny(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchConnectNodeDeviceEventRegisterAny body has to be implemented manually */



static int remoteDispatchConnectNumOfDefinedDomains(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_num_of_defined_domains_ret *ret);
static int remoteDispatchConnectNumOfDefinedDomainsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args G_GNUC_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectNumOfDefinedDomains");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectNumOfDefinedDomains(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectNumOfDefinedDomains(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_connect_num_of_defined_domains_ret *ret)
{
    int rv = -1;
    int num;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if ((num = virConnectNumOfDefinedDomains(conn)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectNumOfDefinedInterfaces(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_num_of_defined_interfaces_ret *ret);
static int remoteDispatchConnectNumOfDefinedInterfacesHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args G_GNUC_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectNumOfDefinedInterfaces");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectNumOfDefinedInterfaces(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectNumOfDefinedInterfaces(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_connect_num_of_defined_interfaces_ret *ret)
{
    int rv = -1;
    int num;

    virConnectPtr conn = remoteGetInterfaceConn(client);
    if (!conn)
        goto cleanup;

    if ((num = virConnectNumOfDefinedInterfaces(conn)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectNumOfDefinedNetworks(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_num_of_defined_networks_ret *ret);
static int remoteDispatchConnectNumOfDefinedNetworksHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args G_GNUC_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectNumOfDefinedNetworks");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectNumOfDefinedNetworks(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectNumOfDefinedNetworks(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_connect_num_of_defined_networks_ret *ret)
{
    int rv = -1;
    int num;

    virConnectPtr conn = remoteGetNetworkConn(client);
    if (!conn)
        goto cleanup;

    if ((num = virConnectNumOfDefinedNetworks(conn)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectNumOfDefinedStoragePools(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_num_of_defined_storage_pools_ret *ret);
static int remoteDispatchConnectNumOfDefinedStoragePoolsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args G_GNUC_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectNumOfDefinedStoragePools");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectNumOfDefinedStoragePools(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectNumOfDefinedStoragePools(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_connect_num_of_defined_storage_pools_ret *ret)
{
    int rv = -1;
    int num;

    virConnectPtr conn = remoteGetStorageConn(client);
    if (!conn)
        goto cleanup;

    if ((num = virConnectNumOfDefinedStoragePools(conn)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectNumOfDomains(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_num_of_domains_ret *ret);
static int remoteDispatchConnectNumOfDomainsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args G_GNUC_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectNumOfDomains");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectNumOfDomains(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectNumOfDomains(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_connect_num_of_domains_ret *ret)
{
    int rv = -1;
    int num;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if ((num = virConnectNumOfDomains(conn)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectNumOfInterfaces(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_num_of_interfaces_ret *ret);
static int remoteDispatchConnectNumOfInterfacesHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args G_GNUC_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectNumOfInterfaces");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectNumOfInterfaces(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectNumOfInterfaces(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_connect_num_of_interfaces_ret *ret)
{
    int rv = -1;
    int num;

    virConnectPtr conn = remoteGetInterfaceConn(client);
    if (!conn)
        goto cleanup;

    if ((num = virConnectNumOfInterfaces(conn)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectNumOfNetworks(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_num_of_networks_ret *ret);
static int remoteDispatchConnectNumOfNetworksHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args G_GNUC_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectNumOfNetworks");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectNumOfNetworks(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectNumOfNetworks(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_connect_num_of_networks_ret *ret)
{
    int rv = -1;
    int num;

    virConnectPtr conn = remoteGetNetworkConn(client);
    if (!conn)
        goto cleanup;

    if ((num = virConnectNumOfNetworks(conn)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectNumOfNWFilters(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_num_of_nwfilters_ret *ret);
static int remoteDispatchConnectNumOfNWFiltersHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args G_GNUC_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectNumOfNWFilters");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectNumOfNWFilters(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectNumOfNWFilters(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_connect_num_of_nwfilters_ret *ret)
{
    int rv = -1;
    int num;

    virConnectPtr conn = remoteGetNWFilterConn(client);
    if (!conn)
        goto cleanup;

    if ((num = virConnectNumOfNWFilters(conn)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectNumOfSecrets(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_num_of_secrets_ret *ret);
static int remoteDispatchConnectNumOfSecretsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args G_GNUC_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectNumOfSecrets");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectNumOfSecrets(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectNumOfSecrets(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_connect_num_of_secrets_ret *ret)
{
    int rv = -1;
    int num;

    virConnectPtr conn = remoteGetSecretConn(client);
    if (!conn)
        goto cleanup;

    if ((num = virConnectNumOfSecrets(conn)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectNumOfStoragePools(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_num_of_storage_pools_ret *ret);
static int remoteDispatchConnectNumOfStoragePoolsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args G_GNUC_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectNumOfStoragePools");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectNumOfStoragePools(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectNumOfStoragePools(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_connect_num_of_storage_pools_ret *ret)
{
    int rv = -1;
    int num;

    virConnectPtr conn = remoteGetStorageConn(client);
    if (!conn)
        goto cleanup;

    if ((num = virConnectNumOfStoragePools(conn)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectOpen(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_open_args *args);
static int remoteDispatchConnectOpenHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectOpen");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectOpen(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchConnectOpen body has to be implemented manually */



static int remoteDispatchConnectRegisterCloseCallback(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr);
static int remoteDispatchConnectRegisterCloseCallbackHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args G_GNUC_UNUSED,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectRegisterCloseCallback");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectRegisterCloseCallback(server, client, msg, rerr);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchConnectRegisterCloseCallback body has to be implemented manually */



static int remoteDispatchConnectSecretEventDeregisterAny(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_secret_event_deregister_any_args *args);
static int remoteDispatchConnectSecretEventDeregisterAnyHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectSecretEventDeregisterAny");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectSecretEventDeregisterAny(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchConnectSecretEventDeregisterAny body has to be implemented manually */



static int remoteDispatchConnectSecretEventRegisterAny(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_secret_event_register_any_args *args,
    remote_connect_secret_event_register_any_ret *ret);
static int remoteDispatchConnectSecretEventRegisterAnyHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectSecretEventRegisterAny");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectSecretEventRegisterAny(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchConnectSecretEventRegisterAny body has to be implemented manually */



static int remoteDispatchConnectSetIdentity(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_set_identity_args *args);
static int remoteDispatchConnectSetIdentityHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectSetIdentity");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectSetIdentity(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchConnectSetIdentity body has to be implemented manually */



static int remoteDispatchConnectStoragePoolEventDeregisterAny(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_storage_pool_event_deregister_any_args *args);
static int remoteDispatchConnectStoragePoolEventDeregisterAnyHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectStoragePoolEventDeregisterAny");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectStoragePoolEventDeregisterAny(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchConnectStoragePoolEventDeregisterAny body has to be implemented manually */



static int remoteDispatchConnectStoragePoolEventRegisterAny(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_storage_pool_event_register_any_args *args,
    remote_connect_storage_pool_event_register_any_ret *ret);
static int remoteDispatchConnectStoragePoolEventRegisterAnyHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectStoragePoolEventRegisterAny");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectStoragePoolEventRegisterAny(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchConnectStoragePoolEventRegisterAny body has to be implemented manually */



static int remoteDispatchConnectSupportsFeature(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_connect_supports_feature_args *args,
    remote_connect_supports_feature_ret *ret);
static int remoteDispatchConnectSupportsFeatureHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectSupportsFeature");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectSupportsFeature(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchConnectSupportsFeature body has to be implemented manually */



static int remoteDispatchConnectUnregisterCloseCallback(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr);
static int remoteDispatchConnectUnregisterCloseCallbackHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args G_GNUC_UNUSED,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectUnregisterCloseCallback");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectUnregisterCloseCallback(server, client, msg, rerr);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchConnectUnregisterCloseCallback body has to be implemented manually */



static int remoteDispatchDomainAbortJob(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_abort_job_args *args);
static int remoteDispatchDomainAbortJobHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainAbortJob");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainAbortJob(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainAbortJob(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_abort_job_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainAbortJob(dom) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainAbortJobFlags(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_abort_job_flags_args *args);
static int remoteDispatchDomainAbortJobFlagsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainAbortJobFlags");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainAbortJobFlags(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainAbortJobFlags(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_abort_job_flags_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainAbortJobFlags(dom, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainAddIOThread(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_add_iothread_args *args);
static int remoteDispatchDomainAddIOThreadHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainAddIOThread");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainAddIOThread(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainAddIOThread(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_add_iothread_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainAddIOThread(dom, args->iothread_id, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainAgentSetResponseTimeout(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_agent_set_response_timeout_args *args,
    remote_domain_agent_set_response_timeout_ret *ret);
static int remoteDispatchDomainAgentSetResponseTimeoutHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainAgentSetResponseTimeout");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainAgentSetResponseTimeout(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainAgentSetResponseTimeout(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_agent_set_response_timeout_args *args,
    remote_domain_agent_set_response_timeout_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    int result;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if ((result = virDomainAgentSetResponseTimeout(dom, args->timeout, args->flags)) < 0)
        goto cleanup;

    ret->result = result;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainAttachDevice(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_attach_device_args *args);
static int remoteDispatchDomainAttachDeviceHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainAttachDevice");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainAttachDevice(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainAttachDevice(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_attach_device_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainAttachDevice(dom, args->xml) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainAttachDeviceFlags(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_attach_device_flags_args *args);
static int remoteDispatchDomainAttachDeviceFlagsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainAttachDeviceFlags");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainAttachDeviceFlags(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainAttachDeviceFlags(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_attach_device_flags_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainAttachDeviceFlags(dom, args->xml, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainAuthorizedSshKeysGet(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_authorized_ssh_keys_get_args *args,
    remote_domain_authorized_ssh_keys_get_ret *ret);
static int remoteDispatchDomainAuthorizedSshKeysGetHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainAuthorizedSshKeysGet");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainAuthorizedSshKeysGet(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainAuthorizedSshKeysGet body has to be implemented manually */



static int remoteDispatchDomainAuthorizedSshKeysSet(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_authorized_ssh_keys_set_args *args);
static int remoteDispatchDomainAuthorizedSshKeysSetHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainAuthorizedSshKeysSet");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainAuthorizedSshKeysSet(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainAuthorizedSshKeysSet body has to be implemented manually */



static int remoteDispatchDomainBackupBegin(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_backup_begin_args *args);
static int remoteDispatchDomainBackupBeginHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainBackupBegin");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainBackupBegin(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainBackupBegin(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_backup_begin_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    char *checkpoint_xml;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    checkpoint_xml = args->checkpoint_xml ? *args->checkpoint_xml : NULL;

    if (virDomainBackupBegin(dom, args->backup_xml, checkpoint_xml, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainBackupGetXMLDesc(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_backup_get_xml_desc_args *args,
    remote_domain_backup_get_xml_desc_ret *ret);
static int remoteDispatchDomainBackupGetXMLDescHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainBackupGetXMLDesc");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainBackupGetXMLDesc(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainBackupGetXMLDesc(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_backup_get_xml_desc_args *args,
    remote_domain_backup_get_xml_desc_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    char *xml;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if ((xml = virDomainBackupGetXMLDesc(dom, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainBlockCommit(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_block_commit_args *args);
static int remoteDispatchDomainBlockCommitHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainBlockCommit");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainBlockCommit(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainBlockCommit(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_block_commit_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    char *base;
    char *top;
    unsigned long bandwidth;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    HYPER_TO_ULONG(bandwidth, args->bandwidth);

    base = args->base ? *args->base : NULL;
    top = args->top ? *args->top : NULL;

    if (virDomainBlockCommit(dom, args->disk, base, top, bandwidth, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainBlockCopy(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_block_copy_args *args);
static int remoteDispatchDomainBlockCopyHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainBlockCopy");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainBlockCopy(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainBlockCopy(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_block_copy_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virTypedParameterPtr params = NULL;
    int nparams = 0;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virTypedParamsDeserialize((struct _virTypedParameterRemote *) args->params.params_val,
                                  args->params.params_len,
                                  REMOTE_DOMAIN_BLOCK_COPY_PARAMETERS_MAX,
                                  &params,
                                  &nparams) < 0)
        goto cleanup;

    if (virDomainBlockCopy(dom, args->path, args->destxml, params, nparams, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    virTypedParamsFree(params, nparams);
    return rv;
}



static int remoteDispatchDomainBlockJobAbort(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_block_job_abort_args *args);
static int remoteDispatchDomainBlockJobAbortHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainBlockJobAbort");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainBlockJobAbort(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainBlockJobAbort(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_block_job_abort_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainBlockJobAbort(dom, args->path, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainBlockJobSetSpeed(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_block_job_set_speed_args *args);
static int remoteDispatchDomainBlockJobSetSpeedHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainBlockJobSetSpeed");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainBlockJobSetSpeed(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainBlockJobSetSpeed(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_block_job_set_speed_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    unsigned long bandwidth;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    HYPER_TO_ULONG(bandwidth, args->bandwidth);

    if (virDomainBlockJobSetSpeed(dom, args->path, bandwidth, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainBlockPeek(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_block_peek_args *args,
    remote_domain_block_peek_ret *ret);
static int remoteDispatchDomainBlockPeekHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainBlockPeek");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainBlockPeek(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainBlockPeek body has to be implemented manually */



static int remoteDispatchDomainBlockPull(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_block_pull_args *args);
static int remoteDispatchDomainBlockPullHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainBlockPull");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainBlockPull(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainBlockPull(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_block_pull_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    unsigned long bandwidth;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    HYPER_TO_ULONG(bandwidth, args->bandwidth);

    if (virDomainBlockPull(dom, args->path, bandwidth, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainBlockRebase(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_block_rebase_args *args);
static int remoteDispatchDomainBlockRebaseHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainBlockRebase");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainBlockRebase(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainBlockRebase(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_block_rebase_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    char *base;
    unsigned long bandwidth;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    HYPER_TO_ULONG(bandwidth, args->bandwidth);

    base = args->base ? *args->base : NULL;

    if (virDomainBlockRebase(dom, args->path, base, bandwidth, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainBlockResize(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_block_resize_args *args);
static int remoteDispatchDomainBlockResizeHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainBlockResize");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainBlockResize(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainBlockResize(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_block_resize_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainBlockResize(dom, args->disk, args->size, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainBlockStats(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_block_stats_args *args,
    remote_domain_block_stats_ret *ret);
static int remoteDispatchDomainBlockStatsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainBlockStats");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainBlockStats(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainBlockStats(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_block_stats_args *args,
    remote_domain_block_stats_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainBlockStatsStruct tmp;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainBlockStats(dom, args->path, &tmp, sizeof(tmp)) < 0)
        goto cleanup;

    ret->rd_req = tmp.rd_req;
    ret->rd_bytes = tmp.rd_bytes;
    ret->wr_req = tmp.wr_req;
    ret->wr_bytes = tmp.wr_bytes;
    ret->errs = tmp.errs;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainBlockStatsFlags(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_block_stats_flags_args *args,
    remote_domain_block_stats_flags_ret *ret);
static int remoteDispatchDomainBlockStatsFlagsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainBlockStatsFlags");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainBlockStatsFlags(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainBlockStatsFlags body has to be implemented manually */



static int remoteDispatchDomainCheckpointCreateXML(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_checkpoint_create_xml_args *args,
    remote_domain_checkpoint_create_xml_ret *ret);
static int remoteDispatchDomainCheckpointCreateXMLHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainCheckpointCreateXML");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainCheckpointCreateXML(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainCheckpointCreateXML(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_checkpoint_create_xml_args *args,
    remote_domain_checkpoint_create_xml_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainCheckpointPtr checkpoint = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if ((checkpoint = virDomainCheckpointCreateXML(dom, args->xml_desc, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_domain_checkpoint(&ret->checkpoint, checkpoint);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    virObjectUnref(checkpoint);
    return rv;
}



static int remoteDispatchDomainCheckpointDelete(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_checkpoint_delete_args *args);
static int remoteDispatchDomainCheckpointDeleteHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainCheckpointDelete");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainCheckpointDelete(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainCheckpointDelete(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_checkpoint_delete_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainCheckpointPtr checkpoint = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->checkpoint.dom)))
        goto cleanup;

    if (!(checkpoint = get_nonnull_domain_checkpoint(dom, args->checkpoint)))
        goto cleanup;

    if (virDomainCheckpointDelete(checkpoint, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(checkpoint);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainCheckpointGetParent(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_checkpoint_get_parent_args *args,
    remote_domain_checkpoint_get_parent_ret *ret);
static int remoteDispatchDomainCheckpointGetParentHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainCheckpointGetParent");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainCheckpointGetParent(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainCheckpointGetParent(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_checkpoint_get_parent_args *args,
    remote_domain_checkpoint_get_parent_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainCheckpointPtr checkpoint = NULL;
    virDomainCheckpointPtr parent = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->checkpoint.dom)))
        goto cleanup;

    if (!(checkpoint = get_nonnull_domain_checkpoint(dom, args->checkpoint)))
        goto cleanup;

    if ((parent = virDomainCheckpointGetParent(checkpoint, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_domain_checkpoint(&ret->parent, parent);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(checkpoint);
    virObjectUnref(dom);
    virObjectUnref(parent);
    return rv;
}



static int remoteDispatchDomainCheckpointGetXMLDesc(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_checkpoint_get_xml_desc_args *args,
    remote_domain_checkpoint_get_xml_desc_ret *ret);
static int remoteDispatchDomainCheckpointGetXMLDescHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainCheckpointGetXMLDesc");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainCheckpointGetXMLDesc(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainCheckpointGetXMLDesc(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_checkpoint_get_xml_desc_args *args,
    remote_domain_checkpoint_get_xml_desc_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainCheckpointPtr checkpoint = NULL;
    char *xml;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->checkpoint.dom)))
        goto cleanup;

    if (!(checkpoint = get_nonnull_domain_checkpoint(dom, args->checkpoint)))
        goto cleanup;

    if ((xml = virDomainCheckpointGetXMLDesc(checkpoint, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(checkpoint);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainCheckpointListAllChildren(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_checkpoint_list_all_children_args *args,
    remote_domain_checkpoint_list_all_children_ret *ret);
static int remoteDispatchDomainCheckpointListAllChildrenHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainCheckpointListAllChildren");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainCheckpointListAllChildren(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainCheckpointListAllChildren(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_checkpoint_list_all_children_args *args,
    remote_domain_checkpoint_list_all_children_ret *ret)
{
    int rv = -1;
    ssize_t i;
    virDomainPtr dom = NULL;
    virDomainCheckpointPtr checkpoint = NULL;
    virDomainCheckpoint **result = NULL;
    int nresults = 0;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->checkpoint.dom)))
        goto cleanup;

    if (!(checkpoint = get_nonnull_domain_checkpoint(dom, args->checkpoint)))
        goto cleanup;

    if ((nresults =
            virDomainCheckpointListAllChildren(checkpoint,
                                               args->need_results ? &result : NULL,
                                               args->flags)) < 0)
        goto cleanup;

    if (nresults > REMOTE_DOMAIN_CHECKPOINT_LIST_MAX) {
        virReportError(VIR_ERR_INTERNAL_ERROR,
                       _("Too many domain_checkpoints '%1$d' for limit '%2$d'"),
                       nresults, REMOTE_DOMAIN_CHECKPOINT_LIST_MAX);
        goto cleanup;
    }

    if (result && nresults) {
        ret->checkpoints.checkpoints_val =
            g_new0(typeof(*ret->checkpoints.checkpoints_val), nresults);

        ret->checkpoints.checkpoints_len = nresults;
        for (i = 0; i < nresults; i++)
            make_nonnull_domain_checkpoint(ret->checkpoints.checkpoints_val + i, result[i]);
    } else {
        ret->checkpoints.checkpoints_len = 0;
        ret->checkpoints.checkpoints_val = NULL;
    }

    ret->ret = nresults;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(checkpoint);
    virObjectUnref(dom);
    if (result) {
        for (i = 0; i < nresults; i++)
            virObjectUnref(result[i]);
    }
    VIR_FREE(result);
    return rv;
}



static int remoteDispatchDomainCheckpointLookupByName(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_checkpoint_lookup_by_name_args *args,
    remote_domain_checkpoint_lookup_by_name_ret *ret);
static int remoteDispatchDomainCheckpointLookupByNameHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainCheckpointLookupByName");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainCheckpointLookupByName(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainCheckpointLookupByName(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_checkpoint_lookup_by_name_args *args,
    remote_domain_checkpoint_lookup_by_name_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainCheckpointPtr checkpoint = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if ((checkpoint = virDomainCheckpointLookupByName(dom, args->name, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_domain_checkpoint(&ret->checkpoint, checkpoint);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    virObjectUnref(checkpoint);
    return rv;
}



static int remoteDispatchDomainCoreDump(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_core_dump_args *args);
static int remoteDispatchDomainCoreDumpHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainCoreDump");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainCoreDump(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainCoreDump(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_core_dump_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainCoreDump(dom, args->to, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainCoreDumpWithFormat(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_core_dump_with_format_args *args);
static int remoteDispatchDomainCoreDumpWithFormatHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainCoreDumpWithFormat");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainCoreDumpWithFormat(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainCoreDumpWithFormat(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_core_dump_with_format_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainCoreDumpWithFormat(dom, args->to, args->dumpformat, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainCreate(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_create_args *args);
static int remoteDispatchDomainCreateHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainCreate");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainCreate(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainCreate(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_create_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainCreate(dom) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainCreateWithFiles(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_create_with_files_args *args,
    remote_domain_create_with_files_ret *ret);
static int remoteDispatchDomainCreateWithFilesHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainCreateWithFiles");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainCreateWithFiles(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainCreateWithFiles body has to be implemented manually */



static int remoteDispatchDomainCreateWithFlags(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_create_with_flags_args *args,
    remote_domain_create_with_flags_ret *ret);
static int remoteDispatchDomainCreateWithFlagsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainCreateWithFlags");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainCreateWithFlags(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainCreateWithFlags(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_create_with_flags_args *args,
    remote_domain_create_with_flags_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainCreateWithFlags(dom, args->flags) < 0)
        goto cleanup;

    make_nonnull_domain(&ret->dom, dom);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainCreateXML(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_create_xml_args *args,
    remote_domain_create_xml_ret *ret);
static int remoteDispatchDomainCreateXMLHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainCreateXML");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainCreateXML(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainCreateXML(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_create_xml_args *args,
    remote_domain_create_xml_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if ((dom = virDomainCreateXML(conn, args->xml_desc, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_domain(&ret->dom, dom);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainCreateXMLWithFiles(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_create_xml_with_files_args *args,
    remote_domain_create_xml_with_files_ret *ret);
static int remoteDispatchDomainCreateXMLWithFilesHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainCreateXMLWithFiles");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainCreateXMLWithFiles(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainCreateXMLWithFiles body has to be implemented manually */



static int remoteDispatchDomainDefineXML(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_define_xml_args *args,
    remote_domain_define_xml_ret *ret);
static int remoteDispatchDomainDefineXMLHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainDefineXML");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainDefineXML(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainDefineXML(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_define_xml_args *args,
    remote_domain_define_xml_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if ((dom = virDomainDefineXML(conn, args->xml)) == NULL)
        goto cleanup;

    make_nonnull_domain(&ret->dom, dom);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainDefineXMLFlags(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_define_xml_flags_args *args,
    remote_domain_define_xml_flags_ret *ret);
static int remoteDispatchDomainDefineXMLFlagsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainDefineXMLFlags");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainDefineXMLFlags(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainDefineXMLFlags(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_define_xml_flags_args *args,
    remote_domain_define_xml_flags_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if ((dom = virDomainDefineXMLFlags(conn, args->xml, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_domain(&ret->dom, dom);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainDelIOThread(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_del_iothread_args *args);
static int remoteDispatchDomainDelIOThreadHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainDelIOThread");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainDelIOThread(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainDelIOThread(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_del_iothread_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainDelIOThread(dom, args->iothread_id, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainDelThrottleGroup(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_del_throttle_group_args *args);
static int remoteDispatchDomainDelThrottleGroupHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainDelThrottleGroup");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainDelThrottleGroup(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainDelThrottleGroup(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_del_throttle_group_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    char *group;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    group = args->group ? *args->group : NULL;

    if (virDomainDelThrottleGroup(dom, group, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainDestroy(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_destroy_args *args);
static int remoteDispatchDomainDestroyHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainDestroy");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainDestroy(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainDestroy(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_destroy_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainDestroy(dom) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainDestroyFlags(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_destroy_flags_args *args);
static int remoteDispatchDomainDestroyFlagsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainDestroyFlags");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainDestroyFlags(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainDestroyFlags(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_destroy_flags_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainDestroyFlags(dom, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainDetachDevice(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_detach_device_args *args);
static int remoteDispatchDomainDetachDeviceHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainDetachDevice");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainDetachDevice(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainDetachDevice(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_detach_device_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainDetachDevice(dom, args->xml) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainDetachDeviceAlias(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_detach_device_alias_args *args);
static int remoteDispatchDomainDetachDeviceAliasHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainDetachDeviceAlias");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainDetachDeviceAlias(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainDetachDeviceAlias(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_detach_device_alias_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainDetachDeviceAlias(dom, args->alias, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainDetachDeviceFlags(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_detach_device_flags_args *args);
static int remoteDispatchDomainDetachDeviceFlagsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainDetachDeviceFlags");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainDetachDeviceFlags(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainDetachDeviceFlags(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_detach_device_flags_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainDetachDeviceFlags(dom, args->xml, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainFdAssociate(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_fd_associate_args *args);
static int remoteDispatchDomainFdAssociateHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainFdAssociate");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainFdAssociate(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainFdAssociate body has to be implemented manually */



static int remoteDispatchDomainFSFreeze(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_fsfreeze_args *args,
    remote_domain_fsfreeze_ret *ret);
static int remoteDispatchDomainFSFreezeHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainFSFreeze");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainFSFreeze(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainFSFreeze(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_fsfreeze_args *args,
    remote_domain_fsfreeze_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    int filesystems;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if ((filesystems = virDomainFSFreeze(dom, (const char **) args->mountpoints.mountpoints_val, args->mountpoints.mountpoints_len, args->flags)) < 0)
        goto cleanup;

    ret->filesystems = filesystems;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainFSThaw(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_fsthaw_args *args,
    remote_domain_fsthaw_ret *ret);
static int remoteDispatchDomainFSThawHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainFSThaw");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainFSThaw(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainFSThaw(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_fsthaw_args *args,
    remote_domain_fsthaw_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    int filesystems;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if ((filesystems = virDomainFSThaw(dom, (const char **) args->mountpoints.mountpoints_val, args->mountpoints.mountpoints_len, args->flags)) < 0)
        goto cleanup;

    ret->filesystems = filesystems;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainFSTrim(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_fstrim_args *args);
static int remoteDispatchDomainFSTrimHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainFSTrim");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainFSTrim(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainFSTrim(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_fstrim_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    char *mountPoint;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    mountPoint = args->mountPoint ? *args->mountPoint : NULL;

    if (virDomainFSTrim(dom, mountPoint, args->minimum, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainGetAutostart(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_get_autostart_args *args,
    remote_domain_get_autostart_ret *ret);
static int remoteDispatchDomainGetAutostartHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetAutostart");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetAutostart(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainGetAutostart(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_get_autostart_args *args,
    remote_domain_get_autostart_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    int autostart;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainGetAutostart(dom, &autostart) < 0)
        goto cleanup;

    ret->autostart = autostart;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainGetAutostartOnce(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_get_autostart_once_args *args,
    remote_domain_get_autostart_once_ret *ret);
static int remoteDispatchDomainGetAutostartOnceHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetAutostartOnce");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetAutostartOnce(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainGetAutostartOnce(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_get_autostart_once_args *args,
    remote_domain_get_autostart_once_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    int autostart;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainGetAutostartOnce(dom, &autostart) < 0)
        goto cleanup;

    ret->autostart = autostart;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainGetBlkioParameters(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_get_blkio_parameters_args *args,
    remote_domain_get_blkio_parameters_ret *ret);
static int remoteDispatchDomainGetBlkioParametersHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetBlkioParameters");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetBlkioParameters(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainGetBlkioParameters body has to be implemented manually */



static int remoteDispatchDomainGetBlockInfo(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_get_block_info_args *args,
    remote_domain_get_block_info_ret *ret);
static int remoteDispatchDomainGetBlockInfoHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetBlockInfo");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetBlockInfo(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainGetBlockInfo(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_get_block_info_args *args,
    remote_domain_get_block_info_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainBlockInfo tmp;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainGetBlockInfo(dom, args->path, &tmp, args->flags) < 0)
        goto cleanup;

    ret->allocation = tmp.allocation;
    ret->capacity = tmp.capacity;
    ret->physical = tmp.physical;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainGetBlockIoTune(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_get_block_io_tune_args *args,
    remote_domain_get_block_io_tune_ret *ret);
static int remoteDispatchDomainGetBlockIoTuneHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetBlockIoTune");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetBlockIoTune(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainGetBlockIoTune body has to be implemented manually */



static int remoteDispatchDomainGetBlockJobInfo(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_get_block_job_info_args *args,
    remote_domain_get_block_job_info_ret *ret);
static int remoteDispatchDomainGetBlockJobInfoHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetBlockJobInfo");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetBlockJobInfo(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainGetBlockJobInfo body has to be implemented manually */



static int remoteDispatchDomainGetControlInfo(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_get_control_info_args *args,
    remote_domain_get_control_info_ret *ret);
static int remoteDispatchDomainGetControlInfoHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetControlInfo");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetControlInfo(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainGetControlInfo(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_get_control_info_args *args,
    remote_domain_get_control_info_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainControlInfo tmp;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainGetControlInfo(dom, &tmp, args->flags) < 0)
        goto cleanup;

    ret->state = tmp.state;
    ret->details = tmp.details;
    ret->stateTime = tmp.stateTime;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainGetCPUStats(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_get_cpu_stats_args *args,
    remote_domain_get_cpu_stats_ret *ret);
static int remoteDispatchDomainGetCPUStatsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetCPUStats");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetCPUStats(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainGetCPUStats body has to be implemented manually */



static int remoteDispatchDomainGetDiskErrors(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_get_disk_errors_args *args,
    remote_domain_get_disk_errors_ret *ret);
static int remoteDispatchDomainGetDiskErrorsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetDiskErrors");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetDiskErrors(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainGetDiskErrors body has to be implemented manually */



static int remoteDispatchDomainGetEmulatorPinInfo(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_get_emulator_pin_info_args *args,
    remote_domain_get_emulator_pin_info_ret *ret);
static int remoteDispatchDomainGetEmulatorPinInfoHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetEmulatorPinInfo");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetEmulatorPinInfo(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainGetEmulatorPinInfo body has to be implemented manually */



static int remoteDispatchDomainGetFSInfo(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_get_fsinfo_args *args,
    remote_domain_get_fsinfo_ret *ret);
static int remoteDispatchDomainGetFSInfoHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetFSInfo");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetFSInfo(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainGetFSInfo body has to be implemented manually */



static int remoteDispatchDomainGetGuestInfo(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_get_guest_info_args *args,
    remote_domain_get_guest_info_ret *ret);
static int remoteDispatchDomainGetGuestInfoHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetGuestInfo");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetGuestInfo(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainGetGuestInfo body has to be implemented manually */



static int remoteDispatchDomainGetGuestVcpus(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_get_guest_vcpus_args *args,
    remote_domain_get_guest_vcpus_ret *ret);
static int remoteDispatchDomainGetGuestVcpusHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetGuestVcpus");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetGuestVcpus(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainGetGuestVcpus(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_get_guest_vcpus_args *args,
    remote_domain_get_guest_vcpus_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virTypedParameterPtr params = NULL;
    unsigned int params_len = 0;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainGetGuestVcpus(dom, &params, &params_len, args->flags) < 0)
        goto cleanup;

    if (virTypedParamsSerialize(params, params_len,
                                REMOTE_DOMAIN_GUEST_VCPU_PARAMS_MAX,
                                (struct _virTypedParameterRemote **) &ret->params.params_val,
                                &ret->params.params_len,
                                VIR_TYPED_PARAM_STRING_OKAY) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        virTypedParamsRemoteFree((struct _virTypedParameterRemote *) ret->params.params_val,
                                 ret->params.params_len);

    }
    virObjectUnref(dom);
    virTypedParamsFree(params, params_len);
    return rv;
}



static int remoteDispatchDomainGetHostname(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_get_hostname_args *args,
    remote_domain_get_hostname_ret *ret);
static int remoteDispatchDomainGetHostnameHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetHostname");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetHostname(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainGetHostname(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_get_hostname_args *args,
    remote_domain_get_hostname_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    char *hostname;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if ((hostname = virDomainGetHostname(dom, args->flags)) == NULL)
        goto cleanup;

    ret->hostname = hostname;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainGetInfo(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_get_info_args *args,
    remote_domain_get_info_ret *ret);
static int remoteDispatchDomainGetInfoHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetInfo");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetInfo(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainGetInfo(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_get_info_args *args,
    remote_domain_get_info_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainInfo tmp;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainGetInfo(dom, &tmp) < 0)
        goto cleanup;

    ret->state = tmp.state;
    ret->maxMem = tmp.maxMem;
    ret->memory = tmp.memory;
    ret->nrVirtCpu = tmp.nrVirtCpu;
    ret->cpuTime = tmp.cpuTime;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainGetInterfaceParameters(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_get_interface_parameters_args *args,
    remote_domain_get_interface_parameters_ret *ret);
static int remoteDispatchDomainGetInterfaceParametersHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetInterfaceParameters");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetInterfaceParameters(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainGetInterfaceParameters body has to be implemented manually */



static int remoteDispatchDomainGetIOThreadInfo(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_get_iothread_info_args *args,
    remote_domain_get_iothread_info_ret *ret);
static int remoteDispatchDomainGetIOThreadInfoHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetIOThreadInfo");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetIOThreadInfo(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainGetIOThreadInfo body has to be implemented manually */



static int remoteDispatchDomainGetJobInfo(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_get_job_info_args *args,
    remote_domain_get_job_info_ret *ret);
static int remoteDispatchDomainGetJobInfoHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetJobInfo");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetJobInfo(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainGetJobInfo(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_get_job_info_args *args,
    remote_domain_get_job_info_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainJobInfo tmp;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainGetJobInfo(dom, &tmp) < 0)
        goto cleanup;

    ret->type = tmp.type;
    ret->timeElapsed = tmp.timeElapsed;
    ret->timeRemaining = tmp.timeRemaining;
    ret->dataTotal = tmp.dataTotal;
    ret->dataProcessed = tmp.dataProcessed;
    ret->dataRemaining = tmp.dataRemaining;
    ret->memTotal = tmp.memTotal;
    ret->memProcessed = tmp.memProcessed;
    ret->memRemaining = tmp.memRemaining;
    ret->fileTotal = tmp.fileTotal;
    ret->fileProcessed = tmp.fileProcessed;
    ret->fileRemaining = tmp.fileRemaining;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainGetJobStats(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_get_job_stats_args *args,
    remote_domain_get_job_stats_ret *ret);
static int remoteDispatchDomainGetJobStatsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetJobStats");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetJobStats(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainGetJobStats body has to be implemented manually */



static int remoteDispatchDomainGetLaunchSecurityInfo(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_get_launch_security_info_args *args,
    remote_domain_get_launch_security_info_ret *ret);
static int remoteDispatchDomainGetLaunchSecurityInfoHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetLaunchSecurityInfo");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetLaunchSecurityInfo(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainGetLaunchSecurityInfo body has to be implemented manually */



static int remoteDispatchDomainGetMaxMemory(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_get_max_memory_args *args,
    remote_domain_get_max_memory_ret *ret);
static int remoteDispatchDomainGetMaxMemoryHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetMaxMemory");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetMaxMemory(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainGetMaxMemory(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_get_max_memory_args *args,
    remote_domain_get_max_memory_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    unsigned long long memory;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if ((memory = virDomainGetMaxMemory(dom)) == 0)
        goto cleanup;

    ret->memory = memory;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainGetMaxVcpus(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_get_max_vcpus_args *args,
    remote_domain_get_max_vcpus_ret *ret);
static int remoteDispatchDomainGetMaxVcpusHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetMaxVcpus");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetMaxVcpus(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainGetMaxVcpus(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_get_max_vcpus_args *args,
    remote_domain_get_max_vcpus_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    int num;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if ((num = virDomainGetMaxVcpus(dom)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainGetMemoryParameters(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_get_memory_parameters_args *args,
    remote_domain_get_memory_parameters_ret *ret);
static int remoteDispatchDomainGetMemoryParametersHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetMemoryParameters");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetMemoryParameters(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainGetMemoryParameters body has to be implemented manually */



static int remoteDispatchDomainGetMessages(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_get_messages_args *args,
    remote_domain_get_messages_ret *ret);
static int remoteDispatchDomainGetMessagesHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetMessages");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetMessages(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainGetMessages body has to be implemented manually */



static int remoteDispatchDomainGetMetadata(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_get_metadata_args *args,
    remote_domain_get_metadata_ret *ret);
static int remoteDispatchDomainGetMetadataHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetMetadata");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetMetadata(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainGetMetadata(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_get_metadata_args *args,
    remote_domain_get_metadata_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    char *uri;
    char *metadata;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    uri = args->uri ? *args->uri : NULL;

    if ((metadata = virDomainGetMetadata(dom, args->type, uri, args->flags)) == NULL)
        goto cleanup;

    ret->metadata = metadata;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainGetNumaParameters(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_get_numa_parameters_args *args,
    remote_domain_get_numa_parameters_ret *ret);
static int remoteDispatchDomainGetNumaParametersHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetNumaParameters");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetNumaParameters(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainGetNumaParameters body has to be implemented manually */



static int remoteDispatchDomainGetOSType(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_get_os_type_args *args,
    remote_domain_get_os_type_ret *ret);
static int remoteDispatchDomainGetOSTypeHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetOSType");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetOSType(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainGetOSType(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_get_os_type_args *args,
    remote_domain_get_os_type_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    char *type;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if ((type = virDomainGetOSType(dom)) == NULL)
        goto cleanup;

    ret->type = type;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainGetPerfEvents(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_get_perf_events_args *args,
    remote_domain_get_perf_events_ret *ret);
static int remoteDispatchDomainGetPerfEventsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetPerfEvents");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetPerfEvents(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainGetPerfEvents body has to be implemented manually */



static int remoteDispatchDomainGetSchedulerParameters(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_get_scheduler_parameters_args *args,
    remote_domain_get_scheduler_parameters_ret *ret);
static int remoteDispatchDomainGetSchedulerParametersHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetSchedulerParameters");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetSchedulerParameters(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainGetSchedulerParameters body has to be implemented manually */



static int remoteDispatchDomainGetSchedulerParametersFlags(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_get_scheduler_parameters_flags_args *args,
    remote_domain_get_scheduler_parameters_flags_ret *ret);
static int remoteDispatchDomainGetSchedulerParametersFlagsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetSchedulerParametersFlags");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetSchedulerParametersFlags(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainGetSchedulerParametersFlags body has to be implemented manually */



static int remoteDispatchDomainGetSchedulerType(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_get_scheduler_type_args *args,
    remote_domain_get_scheduler_type_ret *ret);
static int remoteDispatchDomainGetSchedulerTypeHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetSchedulerType");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetSchedulerType(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainGetSchedulerType body has to be implemented manually */



static int remoteDispatchDomainGetSecurityLabel(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_get_security_label_args *args,
    remote_domain_get_security_label_ret *ret);
static int remoteDispatchDomainGetSecurityLabelHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetSecurityLabel");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetSecurityLabel(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainGetSecurityLabel body has to be implemented manually */



static int remoteDispatchDomainGetSecurityLabelList(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_get_security_label_list_args *args,
    remote_domain_get_security_label_list_ret *ret);
static int remoteDispatchDomainGetSecurityLabelListHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetSecurityLabelList");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetSecurityLabelList(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainGetSecurityLabelList body has to be implemented manually */



static int remoteDispatchDomainGetState(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_get_state_args *args,
    remote_domain_get_state_ret *ret);
static int remoteDispatchDomainGetStateHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetState");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetState(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainGetState body has to be implemented manually */



static int remoteDispatchDomainGetTime(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_get_time_args *args,
    remote_domain_get_time_ret *ret);
static int remoteDispatchDomainGetTimeHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetTime");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetTime(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainGetTime body has to be implemented manually */



static int remoteDispatchDomainGetVcpuPinInfo(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_get_vcpu_pin_info_args *args,
    remote_domain_get_vcpu_pin_info_ret *ret);
static int remoteDispatchDomainGetVcpuPinInfoHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetVcpuPinInfo");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetVcpuPinInfo(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainGetVcpuPinInfo body has to be implemented manually */



static int remoteDispatchDomainGetVcpus(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_get_vcpus_args *args,
    remote_domain_get_vcpus_ret *ret);
static int remoteDispatchDomainGetVcpusHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetVcpus");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetVcpus(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainGetVcpus body has to be implemented manually */



static int remoteDispatchDomainGetVcpusFlags(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_get_vcpus_flags_args *args,
    remote_domain_get_vcpus_flags_ret *ret);
static int remoteDispatchDomainGetVcpusFlagsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetVcpusFlags");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetVcpusFlags(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainGetVcpusFlags(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_get_vcpus_flags_args *args,
    remote_domain_get_vcpus_flags_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    int num;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if ((num = virDomainGetVcpusFlags(dom, args->flags)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainGetXMLDesc(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_get_xml_desc_args *args,
    remote_domain_get_xml_desc_ret *ret);
static int remoteDispatchDomainGetXMLDescHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetXMLDesc");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetXMLDesc(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainGetXMLDesc(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_get_xml_desc_args *args,
    remote_domain_get_xml_desc_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    char *xml;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if ((xml = virDomainGetXMLDesc(dom, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainGraphicsReload(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_graphics_reload_args *args);
static int remoteDispatchDomainGraphicsReloadHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGraphicsReload");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGraphicsReload(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainGraphicsReload(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_graphics_reload_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainGraphicsReload(dom, args->type, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainHasCurrentSnapshot(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_has_current_snapshot_args *args,
    remote_domain_has_current_snapshot_ret *ret);
static int remoteDispatchDomainHasCurrentSnapshotHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainHasCurrentSnapshot");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainHasCurrentSnapshot(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainHasCurrentSnapshot(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_has_current_snapshot_args *args,
    remote_domain_has_current_snapshot_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    int result;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if ((result = virDomainHasCurrentSnapshot(dom, args->flags)) < 0)
        goto cleanup;

    ret->result = result;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainHasManagedSaveImage(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_has_managed_save_image_args *args,
    remote_domain_has_managed_save_image_ret *ret);
static int remoteDispatchDomainHasManagedSaveImageHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainHasManagedSaveImage");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainHasManagedSaveImage(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainHasManagedSaveImage(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_has_managed_save_image_args *args,
    remote_domain_has_managed_save_image_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    int result;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if ((result = virDomainHasManagedSaveImage(dom, args->flags)) < 0)
        goto cleanup;

    ret->result = result;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainInjectNMI(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_inject_nmi_args *args);
static int remoteDispatchDomainInjectNMIHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainInjectNMI");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainInjectNMI(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainInjectNMI(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_inject_nmi_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainInjectNMI(dom, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainInterfaceAddresses(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_interface_addresses_args *args,
    remote_domain_interface_addresses_ret *ret);
static int remoteDispatchDomainInterfaceAddressesHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainInterfaceAddresses");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainInterfaceAddresses(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainInterfaceAddresses body has to be implemented manually */



static int remoteDispatchDomainInterfaceStats(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_interface_stats_args *args,
    remote_domain_interface_stats_ret *ret);
static int remoteDispatchDomainInterfaceStatsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainInterfaceStats");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainInterfaceStats(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainInterfaceStats(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_interface_stats_args *args,
    remote_domain_interface_stats_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainInterfaceStatsStruct tmp;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainInterfaceStats(dom, args->device, &tmp, sizeof(tmp)) < 0)
        goto cleanup;

    ret->rx_bytes = tmp.rx_bytes;
    ret->rx_packets = tmp.rx_packets;
    ret->rx_errs = tmp.rx_errs;
    ret->rx_drop = tmp.rx_drop;
    ret->tx_bytes = tmp.tx_bytes;
    ret->tx_packets = tmp.tx_packets;
    ret->tx_errs = tmp.tx_errs;
    ret->tx_drop = tmp.tx_drop;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainIsActive(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_is_active_args *args,
    remote_domain_is_active_ret *ret);
static int remoteDispatchDomainIsActiveHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainIsActive");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainIsActive(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainIsActive(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_is_active_args *args,
    remote_domain_is_active_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    int active;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if ((active = virDomainIsActive(dom)) < 0)
        goto cleanup;

    ret->active = active;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainIsPersistent(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_is_persistent_args *args,
    remote_domain_is_persistent_ret *ret);
static int remoteDispatchDomainIsPersistentHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainIsPersistent");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainIsPersistent(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainIsPersistent(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_is_persistent_args *args,
    remote_domain_is_persistent_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    int persistent;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if ((persistent = virDomainIsPersistent(dom)) < 0)
        goto cleanup;

    ret->persistent = persistent;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainIsUpdated(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_is_updated_args *args,
    remote_domain_is_updated_ret *ret);
static int remoteDispatchDomainIsUpdatedHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainIsUpdated");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainIsUpdated(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainIsUpdated(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_is_updated_args *args,
    remote_domain_is_updated_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    int updated;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if ((updated = virDomainIsUpdated(dom)) < 0)
        goto cleanup;

    ret->updated = updated;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainListAllCheckpoints(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_list_all_checkpoints_args *args,
    remote_domain_list_all_checkpoints_ret *ret);
static int remoteDispatchDomainListAllCheckpointsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainListAllCheckpoints");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainListAllCheckpoints(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainListAllCheckpoints(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_list_all_checkpoints_args *args,
    remote_domain_list_all_checkpoints_ret *ret)
{
    int rv = -1;
    ssize_t i;
    virDomainPtr dom = NULL;
    virDomainCheckpoint **result = NULL;
    int nresults = 0;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if ((nresults =
            virDomainListAllCheckpoints(dom,
                                        args->need_results ? &result : NULL,
                                        args->flags)) < 0)
        goto cleanup;

    if (nresults > REMOTE_DOMAIN_CHECKPOINT_LIST_MAX) {
        virReportError(VIR_ERR_INTERNAL_ERROR,
                       _("Too many domain_checkpoints '%1$d' for limit '%2$d'"),
                       nresults, REMOTE_DOMAIN_CHECKPOINT_LIST_MAX);
        goto cleanup;
    }

    if (result && nresults) {
        ret->checkpoints.checkpoints_val =
            g_new0(typeof(*ret->checkpoints.checkpoints_val), nresults);

        ret->checkpoints.checkpoints_len = nresults;
        for (i = 0; i < nresults; i++)
            make_nonnull_domain_checkpoint(ret->checkpoints.checkpoints_val + i, result[i]);
    } else {
        ret->checkpoints.checkpoints_len = 0;
        ret->checkpoints.checkpoints_val = NULL;
    }

    ret->ret = nresults;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    if (result) {
        for (i = 0; i < nresults; i++)
            virObjectUnref(result[i]);
    }
    VIR_FREE(result);
    return rv;
}



static int remoteDispatchDomainListAllSnapshots(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_list_all_snapshots_args *args,
    remote_domain_list_all_snapshots_ret *ret);
static int remoteDispatchDomainListAllSnapshotsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainListAllSnapshots");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainListAllSnapshots(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainListAllSnapshots(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_list_all_snapshots_args *args,
    remote_domain_list_all_snapshots_ret *ret)
{
    int rv = -1;
    ssize_t i;
    virDomainPtr dom = NULL;
    virDomainSnapshot **result = NULL;
    int nresults = 0;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if ((nresults =
            virDomainListAllSnapshots(dom,
                                      args->need_results ? &result : NULL,
                                      args->flags)) < 0)
        goto cleanup;

    if (nresults > REMOTE_DOMAIN_SNAPSHOT_LIST_MAX) {
        virReportError(VIR_ERR_INTERNAL_ERROR,
                       _("Too many domain_snapshots '%1$d' for limit '%2$d'"),
                       nresults, REMOTE_DOMAIN_SNAPSHOT_LIST_MAX);
        goto cleanup;
    }

    if (result && nresults) {
        ret->snapshots.snapshots_val =
            g_new0(typeof(*ret->snapshots.snapshots_val), nresults);

        ret->snapshots.snapshots_len = nresults;
        for (i = 0; i < nresults; i++)
            make_nonnull_domain_snapshot(ret->snapshots.snapshots_val + i, result[i]);
    } else {
        ret->snapshots.snapshots_len = 0;
        ret->snapshots.snapshots_val = NULL;
    }

    ret->ret = nresults;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    if (result) {
        for (i = 0; i < nresults; i++)
            virObjectUnref(result[i]);
    }
    VIR_FREE(result);
    return rv;
}



static int remoteDispatchDomainLookupByID(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_lookup_by_id_args *args,
    remote_domain_lookup_by_id_ret *ret);
static int remoteDispatchDomainLookupByIDHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainLookupByID");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainLookupByID(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainLookupByID(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_lookup_by_id_args *args,
    remote_domain_lookup_by_id_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if ((dom = virDomainLookupByID(conn, args->id)) == NULL)
        goto cleanup;

    make_nonnull_domain(&ret->dom, dom);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainLookupByName(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_lookup_by_name_args *args,
    remote_domain_lookup_by_name_ret *ret);
static int remoteDispatchDomainLookupByNameHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainLookupByName");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainLookupByName(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainLookupByName(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_lookup_by_name_args *args,
    remote_domain_lookup_by_name_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if ((dom = virDomainLookupByName(conn, args->name)) == NULL)
        goto cleanup;

    make_nonnull_domain(&ret->dom, dom);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainLookupByUUID(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_lookup_by_uuid_args *args,
    remote_domain_lookup_by_uuid_ret *ret);
static int remoteDispatchDomainLookupByUUIDHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainLookupByUUID");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainLookupByUUID(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainLookupByUUID(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_lookup_by_uuid_args *args,
    remote_domain_lookup_by_uuid_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if ((dom = virDomainLookupByUUID(conn, (unsigned char *) args->uuid)) == NULL)
        goto cleanup;

    make_nonnull_domain(&ret->dom, dom);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainManagedSave(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_managed_save_args *args);
static int remoteDispatchDomainManagedSaveHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainManagedSave");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainManagedSave(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainManagedSave(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_managed_save_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainManagedSave(dom, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainManagedSaveDefineXML(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_managed_save_define_xml_args *args);
static int remoteDispatchDomainManagedSaveDefineXMLHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainManagedSaveDefineXML");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainManagedSaveDefineXML(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainManagedSaveDefineXML(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_managed_save_define_xml_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    char *dxml;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    dxml = args->dxml ? *args->dxml : NULL;

    if (virDomainManagedSaveDefineXML(dom, dxml, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainManagedSaveGetXMLDesc(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_managed_save_get_xml_desc_args *args,
    remote_domain_managed_save_get_xml_desc_ret *ret);
static int remoteDispatchDomainManagedSaveGetXMLDescHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainManagedSaveGetXMLDesc");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainManagedSaveGetXMLDesc(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainManagedSaveGetXMLDesc(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_managed_save_get_xml_desc_args *args,
    remote_domain_managed_save_get_xml_desc_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    char *xml;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if ((xml = virDomainManagedSaveGetXMLDesc(dom, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainManagedSaveRemove(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_managed_save_remove_args *args);
static int remoteDispatchDomainManagedSaveRemoveHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainManagedSaveRemove");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainManagedSaveRemove(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainManagedSaveRemove(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_managed_save_remove_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainManagedSaveRemove(dom, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainMemoryPeek(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_memory_peek_args *args,
    remote_domain_memory_peek_ret *ret);
static int remoteDispatchDomainMemoryPeekHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMemoryPeek");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMemoryPeek(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainMemoryPeek body has to be implemented manually */



static int remoteDispatchDomainMemoryStats(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_memory_stats_args *args,
    remote_domain_memory_stats_ret *ret);
static int remoteDispatchDomainMemoryStatsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMemoryStats");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMemoryStats(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainMemoryStats body has to be implemented manually */



static int remoteDispatchDomainMigrateBegin3(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_migrate_begin3_args *args,
    remote_domain_migrate_begin3_ret *ret);
static int remoteDispatchDomainMigrateBegin3Helper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigrateBegin3");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigrateBegin3(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainMigrateBegin3 body has to be implemented manually */



static int remoteDispatchDomainMigrateBegin3Params(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_migrate_begin3_params_args *args,
    remote_domain_migrate_begin3_params_ret *ret);
static int remoteDispatchDomainMigrateBegin3ParamsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigrateBegin3Params");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigrateBegin3Params(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainMigrateBegin3Params body has to be implemented manually */



static int remoteDispatchDomainMigrateConfirm3(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_migrate_confirm3_args *args);
static int remoteDispatchDomainMigrateConfirm3Helper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigrateConfirm3");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigrateConfirm3(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainMigrateConfirm3 body has to be implemented manually */



static int remoteDispatchDomainMigrateConfirm3Params(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_migrate_confirm3_params_args *args);
static int remoteDispatchDomainMigrateConfirm3ParamsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigrateConfirm3Params");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigrateConfirm3Params(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainMigrateConfirm3Params body has to be implemented manually */



static int remoteDispatchDomainMigrateFinish(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_migrate_finish_args *args,
    remote_domain_migrate_finish_ret *ret);
static int remoteDispatchDomainMigrateFinishHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigrateFinish");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigrateFinish(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainMigrateFinish(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_migrate_finish_args *args,
    remote_domain_migrate_finish_ret *ret)
{
    int rv = -1;
    unsigned long flags;
    virDomainPtr ddom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    HYPER_TO_ULONG(flags, args->flags);

    if ((ddom = virDomainMigrateFinish(conn, args->dname, args->cookie.cookie_val, args->cookie.cookie_len, args->uri, flags)) == NULL)
        goto cleanup;

    make_nonnull_domain(&ret->ddom, ddom);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(ddom);
    return rv;
}



static int remoteDispatchDomainMigrateFinish2(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_migrate_finish2_args *args,
    remote_domain_migrate_finish2_ret *ret);
static int remoteDispatchDomainMigrateFinish2Helper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigrateFinish2");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigrateFinish2(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainMigrateFinish2(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_migrate_finish2_args *args,
    remote_domain_migrate_finish2_ret *ret)
{
    int rv = -1;
    unsigned long flags;
    virDomainPtr ddom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    HYPER_TO_ULONG(flags, args->flags);

    if ((ddom = virDomainMigrateFinish2(conn, args->dname, args->cookie.cookie_val, args->cookie.cookie_len, args->uri, flags, args->retcode)) == NULL)
        goto cleanup;

    make_nonnull_domain(&ret->ddom, ddom);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(ddom);
    return rv;
}



static int remoteDispatchDomainMigrateFinish3(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_migrate_finish3_args *args,
    remote_domain_migrate_finish3_ret *ret);
static int remoteDispatchDomainMigrateFinish3Helper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigrateFinish3");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigrateFinish3(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainMigrateFinish3 body has to be implemented manually */



static int remoteDispatchDomainMigrateFinish3Params(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_migrate_finish3_params_args *args,
    remote_domain_migrate_finish3_params_ret *ret);
static int remoteDispatchDomainMigrateFinish3ParamsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigrateFinish3Params");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigrateFinish3Params(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainMigrateFinish3Params body has to be implemented manually */



static int remoteDispatchDomainMigrateGetCompressionCache(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_migrate_get_compression_cache_args *args,
    remote_domain_migrate_get_compression_cache_ret *ret);
static int remoteDispatchDomainMigrateGetCompressionCacheHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigrateGetCompressionCache");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigrateGetCompressionCache(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainMigrateGetCompressionCache(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_migrate_get_compression_cache_args *args,
    remote_domain_migrate_get_compression_cache_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    unsigned long long cacheSize;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainMigrateGetCompressionCache(dom, &cacheSize, args->flags) < 0)
        goto cleanup;

    ret->cacheSize = cacheSize;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainMigrateGetMaxDowntime(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_migrate_get_max_downtime_args *args,
    remote_domain_migrate_get_max_downtime_ret *ret);
static int remoteDispatchDomainMigrateGetMaxDowntimeHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigrateGetMaxDowntime");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigrateGetMaxDowntime(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainMigrateGetMaxDowntime(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_migrate_get_max_downtime_args *args,
    remote_domain_migrate_get_max_downtime_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    unsigned long long downtime;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainMigrateGetMaxDowntime(dom, &downtime, args->flags) < 0)
        goto cleanup;

    ret->downtime = downtime;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainMigrateGetMaxSpeed(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_migrate_get_max_speed_args *args,
    remote_domain_migrate_get_max_speed_ret *ret);
static int remoteDispatchDomainMigrateGetMaxSpeedHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigrateGetMaxSpeed");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigrateGetMaxSpeed(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainMigrateGetMaxSpeed(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_migrate_get_max_speed_args *args,
    remote_domain_migrate_get_max_speed_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    unsigned long bandwidth;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainMigrateGetMaxSpeed(dom, &bandwidth, args->flags) < 0)
        goto cleanup;

    HYPER_TO_ULONG(ret->bandwidth, bandwidth);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainMigratePerform(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_migrate_perform_args *args);
static int remoteDispatchDomainMigratePerformHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigratePerform");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigratePerform(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainMigratePerform(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_migrate_perform_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    unsigned long flags;
    char *dname;
    unsigned long bandwidth;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    HYPER_TO_ULONG(flags, args->flags);

    HYPER_TO_ULONG(bandwidth, args->bandwidth);

    dname = args->dname ? *args->dname : NULL;

    if (virDomainMigratePerform(dom, args->cookie.cookie_val, args->cookie.cookie_len, args->uri, flags, dname, bandwidth) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainMigratePerform3(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_migrate_perform3_args *args,
    remote_domain_migrate_perform3_ret *ret);
static int remoteDispatchDomainMigratePerform3Helper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigratePerform3");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigratePerform3(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainMigratePerform3 body has to be implemented manually */



static int remoteDispatchDomainMigratePerform3Params(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_migrate_perform3_params_args *args,
    remote_domain_migrate_perform3_params_ret *ret);
static int remoteDispatchDomainMigratePerform3ParamsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigratePerform3Params");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigratePerform3Params(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainMigratePerform3Params body has to be implemented manually */



static int remoteDispatchDomainMigratePrepare(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_migrate_prepare_args *args,
    remote_domain_migrate_prepare_ret *ret);
static int remoteDispatchDomainMigratePrepareHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigratePrepare");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigratePrepare(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainMigratePrepare body has to be implemented manually */



static int remoteDispatchDomainMigratePrepare2(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_migrate_prepare2_args *args,
    remote_domain_migrate_prepare2_ret *ret);
static int remoteDispatchDomainMigratePrepare2Helper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigratePrepare2");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigratePrepare2(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainMigratePrepare2 body has to be implemented manually */



static int remoteDispatchDomainMigratePrepare3(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_migrate_prepare3_args *args,
    remote_domain_migrate_prepare3_ret *ret);
static int remoteDispatchDomainMigratePrepare3Helper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigratePrepare3");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigratePrepare3(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainMigratePrepare3 body has to be implemented manually */



static int remoteDispatchDomainMigratePrepare3Params(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_migrate_prepare3_params_args *args,
    remote_domain_migrate_prepare3_params_ret *ret);
static int remoteDispatchDomainMigratePrepare3ParamsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigratePrepare3Params");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigratePrepare3Params(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainMigratePrepare3Params body has to be implemented manually */



static int remoteDispatchDomainMigratePrepareTunnel(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_migrate_prepare_tunnel_args *args);
static int remoteDispatchDomainMigratePrepareTunnelHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigratePrepareTunnel");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigratePrepareTunnel(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainMigratePrepareTunnel(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_migrate_prepare_tunnel_args *args)
{
    int rv = -1;
    unsigned long flags;
    char *dname;
    unsigned long bandwidth;
    virStreamPtr st = NULL;
    daemonClientStream *stream = NULL;
    const bool sparse = false;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    HYPER_TO_ULONG(flags, args->flags);

    HYPER_TO_ULONG(bandwidth, args->bandwidth);

    dname = args->dname ? *args->dname : NULL;

    if (!(st = virStreamNew(conn, VIR_STREAM_NONBLOCK)))
        goto cleanup;

    if (!(stream = daemonCreateClientStream(client, st, remoteProgram, &msg->header, sparse)))
        goto cleanup;

    if (virDomainMigratePrepareTunnel(conn, st, flags, dname, bandwidth, args->dom_xml) < 0)
        goto cleanup;

    if (daemonAddClientStream(client, stream, false) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        if (stream) {
            virStreamAbort(st);
            daemonFreeClientStream(client, stream);
        } else {
            virObjectUnref(st);
        }
    }
    return rv;
}



static int remoteDispatchDomainMigratePrepareTunnel3(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_migrate_prepare_tunnel3_args *args,
    remote_domain_migrate_prepare_tunnel3_ret *ret);
static int remoteDispatchDomainMigratePrepareTunnel3Helper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigratePrepareTunnel3");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigratePrepareTunnel3(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainMigratePrepareTunnel3(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_migrate_prepare_tunnel3_args *args,
    remote_domain_migrate_prepare_tunnel3_ret *ret)
{
    int rv = -1;
    unsigned long flags;
    char *dname;
    unsigned long bandwidth;
    char *cookie_out = NULL;
    int cookie_out_len = 0;
    virStreamPtr st = NULL;
    daemonClientStream *stream = NULL;
    const bool sparse = false;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    HYPER_TO_ULONG(flags, args->flags);

    HYPER_TO_ULONG(bandwidth, args->bandwidth);

    dname = args->dname ? *args->dname : NULL;

    if (!(st = virStreamNew(conn, VIR_STREAM_NONBLOCK)))
        goto cleanup;

    if (!(stream = daemonCreateClientStream(client, st, remoteProgram, &msg->header, sparse)))
        goto cleanup;

    if (virDomainMigratePrepareTunnel3(conn, st, args->cookie_in.cookie_in_val, args->cookie_in.cookie_in_len, &cookie_out, &cookie_out_len, flags, dname, bandwidth, args->dom_xml) < 0)
        goto cleanup;

    if (daemonAddClientStream(client, stream, false) < 0)
        goto cleanup;

    ret->cookie_out.cookie_out_val = cookie_out;
    ret->cookie_out.cookie_out_len = cookie_out_len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(cookie_out);
        if (stream) {
            virStreamAbort(st);
            daemonFreeClientStream(client, stream);
        } else {
            virObjectUnref(st);
        }
    }
    return rv;
}



static int remoteDispatchDomainMigratePrepareTunnel3Params(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_migrate_prepare_tunnel3_params_args *args,
    remote_domain_migrate_prepare_tunnel3_params_ret *ret);
static int remoteDispatchDomainMigratePrepareTunnel3ParamsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigratePrepareTunnel3Params");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigratePrepareTunnel3Params(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainMigratePrepareTunnel3Params body has to be implemented manually */



static int remoteDispatchDomainMigrateSetCompressionCache(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_migrate_set_compression_cache_args *args);
static int remoteDispatchDomainMigrateSetCompressionCacheHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigrateSetCompressionCache");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigrateSetCompressionCache(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainMigrateSetCompressionCache(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_migrate_set_compression_cache_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainMigrateSetCompressionCache(dom, args->cacheSize, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainMigrateSetMaxDowntime(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_migrate_set_max_downtime_args *args);
static int remoteDispatchDomainMigrateSetMaxDowntimeHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigrateSetMaxDowntime");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigrateSetMaxDowntime(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainMigrateSetMaxDowntime(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_migrate_set_max_downtime_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainMigrateSetMaxDowntime(dom, args->downtime, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainMigrateSetMaxSpeed(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_migrate_set_max_speed_args *args);
static int remoteDispatchDomainMigrateSetMaxSpeedHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigrateSetMaxSpeed");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigrateSetMaxSpeed(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainMigrateSetMaxSpeed(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_migrate_set_max_speed_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    unsigned long bandwidth;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    HYPER_TO_ULONG(bandwidth, args->bandwidth);

    if (virDomainMigrateSetMaxSpeed(dom, bandwidth, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainMigrateStartPostCopy(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_migrate_start_post_copy_args *args);
static int remoteDispatchDomainMigrateStartPostCopyHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigrateStartPostCopy");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigrateStartPostCopy(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainMigrateStartPostCopy(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_migrate_start_post_copy_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainMigrateStartPostCopy(dom, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainOpenChannel(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_open_channel_args *args);
static int remoteDispatchDomainOpenChannelHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainOpenChannel");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainOpenChannel(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainOpenChannel(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_open_channel_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    char *name;
    virStreamPtr st = NULL;
    daemonClientStream *stream = NULL;
    const bool sparse = false;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    name = args->name ? *args->name : NULL;

    if (!(st = virStreamNew(conn, VIR_STREAM_NONBLOCK)))
        goto cleanup;

    if (!(stream = daemonCreateClientStream(client, st, remoteProgram, &msg->header, sparse)))
        goto cleanup;

    if (virDomainOpenChannel(dom, name, st, args->flags) < 0)
        goto cleanup;

    if (daemonAddClientStream(client, stream, true) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        if (stream) {
            virStreamAbort(st);
            daemonFreeClientStream(client, stream);
        } else {
            virObjectUnref(st);
        }
    }
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainOpenConsole(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_open_console_args *args);
static int remoteDispatchDomainOpenConsoleHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainOpenConsole");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainOpenConsole(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainOpenConsole(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_open_console_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    char *dev_name;
    virStreamPtr st = NULL;
    daemonClientStream *stream = NULL;
    const bool sparse = false;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    dev_name = args->dev_name ? *args->dev_name : NULL;

    if (!(st = virStreamNew(conn, VIR_STREAM_NONBLOCK)))
        goto cleanup;

    if (!(stream = daemonCreateClientStream(client, st, remoteProgram, &msg->header, sparse)))
        goto cleanup;

    if (virDomainOpenConsole(dom, dev_name, st, args->flags) < 0)
        goto cleanup;

    if (daemonAddClientStream(client, stream, true) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        if (stream) {
            virStreamAbort(st);
            daemonFreeClientStream(client, stream);
        } else {
            virObjectUnref(st);
        }
    }
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainOpenGraphics(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_open_graphics_args *args);
static int remoteDispatchDomainOpenGraphicsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainOpenGraphics");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainOpenGraphics(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainOpenGraphics body has to be implemented manually */



static int remoteDispatchDomainOpenGraphicsFd(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_open_graphics_fd_args *args);
static int remoteDispatchDomainOpenGraphicsFdHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainOpenGraphicsFd");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainOpenGraphicsFd(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainOpenGraphicsFd body has to be implemented manually */



static int remoteDispatchDomainPinEmulator(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_pin_emulator_args *args);
static int remoteDispatchDomainPinEmulatorHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainPinEmulator");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainPinEmulator(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainPinEmulator body has to be implemented manually */



static int remoteDispatchDomainPinIOThread(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_pin_iothread_args *args);
static int remoteDispatchDomainPinIOThreadHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainPinIOThread");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainPinIOThread(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainPinIOThread(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_pin_iothread_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainPinIOThread(dom, args->iothreads_id, (unsigned char *) args->cpumap.cpumap_val, args->cpumap.cpumap_len, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainPinVcpu(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_pin_vcpu_args *args);
static int remoteDispatchDomainPinVcpuHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainPinVcpu");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainPinVcpu(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainPinVcpu(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_pin_vcpu_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainPinVcpu(dom, args->vcpu, (unsigned char *) args->cpumap.cpumap_val, args->cpumap.cpumap_len) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainPinVcpuFlags(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_pin_vcpu_flags_args *args);
static int remoteDispatchDomainPinVcpuFlagsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainPinVcpuFlags");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainPinVcpuFlags(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainPinVcpuFlags(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_pin_vcpu_flags_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainPinVcpuFlags(dom, args->vcpu, (unsigned char *) args->cpumap.cpumap_val, args->cpumap.cpumap_len, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainPMSuspendForDuration(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_pm_suspend_for_duration_args *args);
static int remoteDispatchDomainPMSuspendForDurationHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainPMSuspendForDuration");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainPMSuspendForDuration(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainPMSuspendForDuration(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_pm_suspend_for_duration_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainPMSuspendForDuration(dom, args->target, args->duration, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainPMWakeup(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_pm_wakeup_args *args);
static int remoteDispatchDomainPMWakeupHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainPMWakeup");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainPMWakeup(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainPMWakeup(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_pm_wakeup_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainPMWakeup(dom, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainReboot(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_reboot_args *args);
static int remoteDispatchDomainRebootHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainReboot");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainReboot(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainReboot(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_reboot_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainReboot(dom, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainRename(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_rename_args *args,
    remote_domain_rename_ret *ret);
static int remoteDispatchDomainRenameHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainRename");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainRename(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainRename(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_rename_args *args,
    remote_domain_rename_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    char *new_name;
    int retcode;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    new_name = args->new_name ? *args->new_name : NULL;

    if ((retcode = virDomainRename(dom, new_name, args->flags)) < 0)
        goto cleanup;

    ret->retcode = retcode;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainReset(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_reset_args *args);
static int remoteDispatchDomainResetHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainReset");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainReset(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainReset(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_reset_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainReset(dom, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainRestore(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_restore_args *args);
static int remoteDispatchDomainRestoreHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainRestore");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainRestore(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainRestore(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_restore_args *args)
{
    int rv = -1;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (virDomainRestore(conn, args->from) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchDomainRestoreFlags(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_restore_flags_args *args);
static int remoteDispatchDomainRestoreFlagsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainRestoreFlags");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainRestoreFlags(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainRestoreFlags(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_restore_flags_args *args)
{
    int rv = -1;
    char *dxml;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    dxml = args->dxml ? *args->dxml : NULL;

    if (virDomainRestoreFlags(conn, args->from, dxml, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchDomainRestoreParams(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_restore_params_args *args);
static int remoteDispatchDomainRestoreParamsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainRestoreParams");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainRestoreParams(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainRestoreParams(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_restore_params_args *args)
{
    int rv = -1;
    virTypedParameterPtr params = NULL;
    int nparams = 0;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (virTypedParamsDeserialize((struct _virTypedParameterRemote *) args->params.params_val,
                                  args->params.params_len,
                                  REMOTE_DOMAIN_SAVE_PARAMS_MAX,
                                  &params,
                                  &nparams) < 0)
        goto cleanup;

    if (virDomainRestoreParams(conn, params, nparams, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virTypedParamsFree(params, nparams);
    return rv;
}



static int remoteDispatchDomainResume(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_resume_args *args);
static int remoteDispatchDomainResumeHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainResume");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainResume(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainResume(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_resume_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainResume(dom) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainRevertToSnapshot(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_revert_to_snapshot_args *args);
static int remoteDispatchDomainRevertToSnapshotHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainRevertToSnapshot");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainRevertToSnapshot(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainRevertToSnapshot(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_revert_to_snapshot_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainSnapshotPtr snapshot = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->snap.dom)))
        goto cleanup;

    if (!(snapshot = get_nonnull_domain_snapshot(dom, args->snap)))
        goto cleanup;

    if (virDomainRevertToSnapshot(snapshot, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(snapshot);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSave(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_save_args *args);
static int remoteDispatchDomainSaveHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSave");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSave(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSave(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_save_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainSave(dom, args->to) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSaveFlags(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_save_flags_args *args);
static int remoteDispatchDomainSaveFlagsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSaveFlags");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSaveFlags(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSaveFlags(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_save_flags_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    char *dxml;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    dxml = args->dxml ? *args->dxml : NULL;

    if (virDomainSaveFlags(dom, args->to, dxml, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSaveImageDefineXML(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_save_image_define_xml_args *args);
static int remoteDispatchDomainSaveImageDefineXMLHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSaveImageDefineXML");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSaveImageDefineXML(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSaveImageDefineXML(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_save_image_define_xml_args *args)
{
    int rv = -1;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (virDomainSaveImageDefineXML(conn, args->file, args->dxml, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchDomainSaveImageGetXMLDesc(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_save_image_get_xml_desc_args *args,
    remote_domain_save_image_get_xml_desc_ret *ret);
static int remoteDispatchDomainSaveImageGetXMLDescHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSaveImageGetXMLDesc");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSaveImageGetXMLDesc(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSaveImageGetXMLDesc(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_save_image_get_xml_desc_args *args,
    remote_domain_save_image_get_xml_desc_ret *ret)
{
    int rv = -1;
    char *xml;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if ((xml = virDomainSaveImageGetXMLDesc(conn, args->file, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchDomainSaveParams(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_save_params_args *args);
static int remoteDispatchDomainSaveParamsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSaveParams");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSaveParams(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSaveParams(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_save_params_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virTypedParameterPtr params = NULL;
    int nparams = 0;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virTypedParamsDeserialize((struct _virTypedParameterRemote *) args->params.params_val,
                                  args->params.params_len,
                                  REMOTE_DOMAIN_SAVE_PARAMS_MAX,
                                  &params,
                                  &nparams) < 0)
        goto cleanup;

    if (virDomainSaveParams(dom, params, nparams, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    virTypedParamsFree(params, nparams);
    return rv;
}



static int remoteDispatchDomainScreenshot(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_screenshot_args *args,
    remote_domain_screenshot_ret *ret);
static int remoteDispatchDomainScreenshotHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainScreenshot");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainScreenshot(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainScreenshot(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_screenshot_args *args,
    remote_domain_screenshot_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    char *mime = NULL;
    char **mime_p = NULL;
    virStreamPtr st = NULL;
    daemonClientStream *stream = NULL;
    const bool sparse = false;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (!(st = virStreamNew(conn, VIR_STREAM_NONBLOCK)))
        goto cleanup;

    if (!(stream = daemonCreateClientStream(client, st, remoteProgram, &msg->header, sparse)))
        goto cleanup;

    if ((mime = virDomainScreenshot(dom, st, args->screen, args->flags)) == NULL)
        goto cleanup;

    if (daemonAddClientStream(client, stream, true) < 0)
        goto cleanup;

    mime_p = g_new0(char *, 1);

    *mime_p = g_strdup(mime);

    ret->mime = mime_p;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(mime_p);
        if (stream) {
            virStreamAbort(st);
            daemonFreeClientStream(client, stream);
        } else {
            virObjectUnref(st);
        }
    }
    virObjectUnref(dom);
    VIR_FREE(mime);
    return rv;
}



static int remoteDispatchDomainSendKey(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_send_key_args *args);
static int remoteDispatchDomainSendKeyHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSendKey");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSendKey(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSendKey(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_send_key_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainSendKey(dom, args->codeset, args->holdtime, args->keycodes.keycodes_val, args->keycodes.keycodes_len, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSendProcessSignal(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_send_process_signal_args *args);
static int remoteDispatchDomainSendProcessSignalHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSendProcessSignal");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSendProcessSignal(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSendProcessSignal(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_send_process_signal_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainSendProcessSignal(dom, args->pid_value, args->signum, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSetAutostart(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_set_autostart_args *args);
static int remoteDispatchDomainSetAutostartHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSetAutostart");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSetAutostart(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSetAutostart(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_set_autostart_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainSetAutostart(dom, args->autostart) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSetAutostartOnce(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_set_autostart_once_args *args);
static int remoteDispatchDomainSetAutostartOnceHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSetAutostartOnce");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSetAutostartOnce(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSetAutostartOnce(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_set_autostart_once_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainSetAutostartOnce(dom, args->autostart) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSetBlkioParameters(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_set_blkio_parameters_args *args);
static int remoteDispatchDomainSetBlkioParametersHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSetBlkioParameters");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSetBlkioParameters(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSetBlkioParameters(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_set_blkio_parameters_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virTypedParameterPtr params = NULL;
    int nparams = 0;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virTypedParamsDeserialize((struct _virTypedParameterRemote *) args->params.params_val,
                                  args->params.params_len,
                                  REMOTE_DOMAIN_BLKIO_PARAMETERS_MAX,
                                  &params,
                                  &nparams) < 0)
        goto cleanup;

    if (virDomainSetBlkioParameters(dom, params, nparams, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    virTypedParamsFree(params, nparams);
    return rv;
}



static int remoteDispatchDomainSetBlockIoTune(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_set_block_io_tune_args *args);
static int remoteDispatchDomainSetBlockIoTuneHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSetBlockIoTune");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSetBlockIoTune(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSetBlockIoTune(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_set_block_io_tune_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virTypedParameterPtr params = NULL;
    int nparams = 0;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virTypedParamsDeserialize((struct _virTypedParameterRemote *) args->params.params_val,
                                  args->params.params_len,
                                  REMOTE_DOMAIN_BLOCK_IO_TUNE_PARAMETERS_MAX,
                                  &params,
                                  &nparams) < 0)
        goto cleanup;

    if (virDomainSetBlockIoTune(dom, args->disk, params, nparams, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    virTypedParamsFree(params, nparams);
    return rv;
}



static int remoteDispatchDomainSetBlockThreshold(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_set_block_threshold_args *args);
static int remoteDispatchDomainSetBlockThresholdHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSetBlockThreshold");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSetBlockThreshold(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSetBlockThreshold(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_set_block_threshold_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainSetBlockThreshold(dom, args->dev, args->threshold, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSetGuestVcpus(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_set_guest_vcpus_args *args);
static int remoteDispatchDomainSetGuestVcpusHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSetGuestVcpus");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSetGuestVcpus(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSetGuestVcpus(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_set_guest_vcpus_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainSetGuestVcpus(dom, args->cpumap, args->state, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSetInterfaceParameters(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_set_interface_parameters_args *args);
static int remoteDispatchDomainSetInterfaceParametersHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSetInterfaceParameters");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSetInterfaceParameters(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSetInterfaceParameters(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_set_interface_parameters_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virTypedParameterPtr params = NULL;
    int nparams = 0;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virTypedParamsDeserialize((struct _virTypedParameterRemote *) args->params.params_val,
                                  args->params.params_len,
                                  REMOTE_DOMAIN_INTERFACE_PARAMETERS_MAX,
                                  &params,
                                  &nparams) < 0)
        goto cleanup;

    if (virDomainSetInterfaceParameters(dom, args->device, params, nparams, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    virTypedParamsFree(params, nparams);
    return rv;
}



static int remoteDispatchDomainSetIOThreadParams(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_set_iothread_params_args *args);
static int remoteDispatchDomainSetIOThreadParamsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSetIOThreadParams");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSetIOThreadParams(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSetIOThreadParams(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_set_iothread_params_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virTypedParameterPtr params = NULL;
    int nparams = 0;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virTypedParamsDeserialize((struct _virTypedParameterRemote *) args->params.params_val,
                                  args->params.params_len,
                                  REMOTE_DOMAIN_IOTHREAD_PARAMS_MAX,
                                  &params,
                                  &nparams) < 0)
        goto cleanup;

    if (virDomainSetIOThreadParams(dom, args->iothread_id, params, nparams, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    virTypedParamsFree(params, nparams);
    return rv;
}



static int remoteDispatchDomainSetLaunchSecurityState(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_set_launch_security_state_args *args);
static int remoteDispatchDomainSetLaunchSecurityStateHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSetLaunchSecurityState");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSetLaunchSecurityState(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSetLaunchSecurityState(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_set_launch_security_state_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virTypedParameterPtr params = NULL;
    int nparams = 0;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virTypedParamsDeserialize((struct _virTypedParameterRemote *) args->params.params_val,
                                  args->params.params_len,
                                  REMOTE_DOMAIN_LAUNCH_SECURITY_STATE_PARAMS_MAX,
                                  &params,
                                  &nparams) < 0)
        goto cleanup;

    if (virDomainSetLaunchSecurityState(dom, params, nparams, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    virTypedParamsFree(params, nparams);
    return rv;
}



static int remoteDispatchDomainSetLifecycleAction(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_set_lifecycle_action_args *args);
static int remoteDispatchDomainSetLifecycleActionHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSetLifecycleAction");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSetLifecycleAction(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSetLifecycleAction(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_set_lifecycle_action_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainSetLifecycleAction(dom, args->type, args->action, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSetMaxMemory(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_set_max_memory_args *args);
static int remoteDispatchDomainSetMaxMemoryHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSetMaxMemory");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSetMaxMemory(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSetMaxMemory(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_set_max_memory_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    unsigned long memory;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    HYPER_TO_ULONG(memory, args->memory);

    if (virDomainSetMaxMemory(dom, memory) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSetMemory(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_set_memory_args *args);
static int remoteDispatchDomainSetMemoryHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSetMemory");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSetMemory(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSetMemory(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_set_memory_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    unsigned long memory;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    HYPER_TO_ULONG(memory, args->memory);

    if (virDomainSetMemory(dom, memory) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSetMemoryFlags(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_set_memory_flags_args *args);
static int remoteDispatchDomainSetMemoryFlagsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSetMemoryFlags");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSetMemoryFlags(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSetMemoryFlags(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_set_memory_flags_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    unsigned long memory;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    HYPER_TO_ULONG(memory, args->memory);

    if (virDomainSetMemoryFlags(dom, memory, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSetMemoryParameters(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_set_memory_parameters_args *args);
static int remoteDispatchDomainSetMemoryParametersHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSetMemoryParameters");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSetMemoryParameters(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSetMemoryParameters(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_set_memory_parameters_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virTypedParameterPtr params = NULL;
    int nparams = 0;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virTypedParamsDeserialize((struct _virTypedParameterRemote *) args->params.params_val,
                                  args->params.params_len,
                                  REMOTE_DOMAIN_MEMORY_PARAMETERS_MAX,
                                  &params,
                                  &nparams) < 0)
        goto cleanup;

    if (virDomainSetMemoryParameters(dom, params, nparams, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    virTypedParamsFree(params, nparams);
    return rv;
}



static int remoteDispatchDomainSetMemoryStatsPeriod(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_set_memory_stats_period_args *args);
static int remoteDispatchDomainSetMemoryStatsPeriodHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSetMemoryStatsPeriod");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSetMemoryStatsPeriod(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSetMemoryStatsPeriod(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_set_memory_stats_period_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainSetMemoryStatsPeriod(dom, args->period, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSetMetadata(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_set_metadata_args *args);
static int remoteDispatchDomainSetMetadataHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSetMetadata");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSetMetadata(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSetMetadata(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_set_metadata_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    char *metadata;
    char *key;
    char *uri;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    metadata = args->metadata ? *args->metadata : NULL;
    key = args->key ? *args->key : NULL;
    uri = args->uri ? *args->uri : NULL;

    if (virDomainSetMetadata(dom, args->type, metadata, key, uri, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSetNumaParameters(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_set_numa_parameters_args *args);
static int remoteDispatchDomainSetNumaParametersHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSetNumaParameters");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSetNumaParameters(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSetNumaParameters(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_set_numa_parameters_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virTypedParameterPtr params = NULL;
    int nparams = 0;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virTypedParamsDeserialize((struct _virTypedParameterRemote *) args->params.params_val,
                                  args->params.params_len,
                                  REMOTE_DOMAIN_NUMA_PARAMETERS_MAX,
                                  &params,
                                  &nparams) < 0)
        goto cleanup;

    if (virDomainSetNumaParameters(dom, params, nparams, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    virTypedParamsFree(params, nparams);
    return rv;
}



static int remoteDispatchDomainSetPerfEvents(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_set_perf_events_args *args);
static int remoteDispatchDomainSetPerfEventsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSetPerfEvents");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSetPerfEvents(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSetPerfEvents(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_set_perf_events_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virTypedParameterPtr params = NULL;
    int nparams = 0;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virTypedParamsDeserialize((struct _virTypedParameterRemote *) args->params.params_val,
                                  args->params.params_len,
                                  REMOTE_DOMAIN_PERF_EVENTS_MAX,
                                  &params,
                                  &nparams) < 0)
        goto cleanup;

    if (virDomainSetPerfEvents(dom, params, nparams, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    virTypedParamsFree(params, nparams);
    return rv;
}



static int remoteDispatchDomainSetSchedulerParameters(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_set_scheduler_parameters_args *args);
static int remoteDispatchDomainSetSchedulerParametersHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSetSchedulerParameters");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSetSchedulerParameters(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSetSchedulerParameters(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_set_scheduler_parameters_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virTypedParameterPtr params = NULL;
    int nparams = 0;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virTypedParamsDeserialize((struct _virTypedParameterRemote *) args->params.params_val,
                                  args->params.params_len,
                                  REMOTE_DOMAIN_SCHEDULER_PARAMETERS_MAX,
                                  &params,
                                  &nparams) < 0)
        goto cleanup;

    if (virDomainSetSchedulerParameters(dom, params, nparams) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    virTypedParamsFree(params, nparams);
    return rv;
}



static int remoteDispatchDomainSetSchedulerParametersFlags(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_set_scheduler_parameters_flags_args *args);
static int remoteDispatchDomainSetSchedulerParametersFlagsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSetSchedulerParametersFlags");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSetSchedulerParametersFlags(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSetSchedulerParametersFlags(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_set_scheduler_parameters_flags_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virTypedParameterPtr params = NULL;
    int nparams = 0;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virTypedParamsDeserialize((struct _virTypedParameterRemote *) args->params.params_val,
                                  args->params.params_len,
                                  REMOTE_DOMAIN_SCHEDULER_PARAMETERS_MAX,
                                  &params,
                                  &nparams) < 0)
        goto cleanup;

    if (virDomainSetSchedulerParametersFlags(dom, params, nparams, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    virTypedParamsFree(params, nparams);
    return rv;
}



static int remoteDispatchDomainSetThrottleGroup(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_set_throttle_group_args *args);
static int remoteDispatchDomainSetThrottleGroupHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSetThrottleGroup");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSetThrottleGroup(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSetThrottleGroup(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_set_throttle_group_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virTypedParameterPtr params = NULL;
    int nparams = 0;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virTypedParamsDeserialize((struct _virTypedParameterRemote *) args->params.params_val,
                                  args->params.params_len,
                                  REMOTE_DOMAIN_BLOCK_IO_TUNE_PARAMETERS_MAX,
                                  &params,
                                  &nparams) < 0)
        goto cleanup;

    if (virDomainSetThrottleGroup(dom, args->group, params, nparams, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    virTypedParamsFree(params, nparams);
    return rv;
}



static int remoteDispatchDomainSetTime(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_set_time_args *args);
static int remoteDispatchDomainSetTimeHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSetTime");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSetTime(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSetTime(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_set_time_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainSetTime(dom, args->seconds, args->nseconds, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSetUserPassword(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_set_user_password_args *args);
static int remoteDispatchDomainSetUserPasswordHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSetUserPassword");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSetUserPassword(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSetUserPassword(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_set_user_password_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    char *user;
    char *password;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    user = args->user ? *args->user : NULL;
    password = args->password ? *args->password : NULL;

    if (virDomainSetUserPassword(dom, user, password, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSetVcpu(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_set_vcpu_args *args);
static int remoteDispatchDomainSetVcpuHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSetVcpu");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSetVcpu(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSetVcpu(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_set_vcpu_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainSetVcpu(dom, args->cpumap, args->state, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSetVcpus(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_set_vcpus_args *args);
static int remoteDispatchDomainSetVcpusHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSetVcpus");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSetVcpus(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSetVcpus(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_set_vcpus_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainSetVcpus(dom, args->nvcpus) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSetVcpusFlags(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_set_vcpus_flags_args *args);
static int remoteDispatchDomainSetVcpusFlagsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSetVcpusFlags");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSetVcpusFlags(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSetVcpusFlags(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_set_vcpus_flags_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainSetVcpusFlags(dom, args->nvcpus, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainShutdown(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_shutdown_args *args);
static int remoteDispatchDomainShutdownHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainShutdown");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainShutdown(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainShutdown(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_shutdown_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainShutdown(dom) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainShutdownFlags(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_shutdown_flags_args *args);
static int remoteDispatchDomainShutdownFlagsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainShutdownFlags");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainShutdownFlags(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainShutdownFlags(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_shutdown_flags_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainShutdownFlags(dom, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSnapshotCreateXML(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_snapshot_create_xml_args *args,
    remote_domain_snapshot_create_xml_ret *ret);
static int remoteDispatchDomainSnapshotCreateXMLHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSnapshotCreateXML");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSnapshotCreateXML(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSnapshotCreateXML(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_snapshot_create_xml_args *args,
    remote_domain_snapshot_create_xml_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainSnapshotPtr snap = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if ((snap = virDomainSnapshotCreateXML(dom, args->xml_desc, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_domain_snapshot(&ret->snap, snap);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    virObjectUnref(snap);
    return rv;
}



static int remoteDispatchDomainSnapshotCurrent(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_snapshot_current_args *args,
    remote_domain_snapshot_current_ret *ret);
static int remoteDispatchDomainSnapshotCurrentHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSnapshotCurrent");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSnapshotCurrent(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSnapshotCurrent(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_snapshot_current_args *args,
    remote_domain_snapshot_current_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainSnapshotPtr snap = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if ((snap = virDomainSnapshotCurrent(dom, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_domain_snapshot(&ret->snap, snap);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    virObjectUnref(snap);
    return rv;
}



static int remoteDispatchDomainSnapshotDelete(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_snapshot_delete_args *args);
static int remoteDispatchDomainSnapshotDeleteHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSnapshotDelete");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSnapshotDelete(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSnapshotDelete(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_snapshot_delete_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainSnapshotPtr snapshot = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->snap.dom)))
        goto cleanup;

    if (!(snapshot = get_nonnull_domain_snapshot(dom, args->snap)))
        goto cleanup;

    if (virDomainSnapshotDelete(snapshot, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(snapshot);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSnapshotGetParent(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_snapshot_get_parent_args *args,
    remote_domain_snapshot_get_parent_ret *ret);
static int remoteDispatchDomainSnapshotGetParentHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSnapshotGetParent");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSnapshotGetParent(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSnapshotGetParent(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_snapshot_get_parent_args *args,
    remote_domain_snapshot_get_parent_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainSnapshotPtr snapshot = NULL;
    virDomainSnapshotPtr snap = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->snap.dom)))
        goto cleanup;

    if (!(snapshot = get_nonnull_domain_snapshot(dom, args->snap)))
        goto cleanup;

    if ((snap = virDomainSnapshotGetParent(snapshot, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_domain_snapshot(&ret->snap, snap);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(snapshot);
    virObjectUnref(dom);
    virObjectUnref(snap);
    return rv;
}



static int remoteDispatchDomainSnapshotGetXMLDesc(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_snapshot_get_xml_desc_args *args,
    remote_domain_snapshot_get_xml_desc_ret *ret);
static int remoteDispatchDomainSnapshotGetXMLDescHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSnapshotGetXMLDesc");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSnapshotGetXMLDesc(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSnapshotGetXMLDesc(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_snapshot_get_xml_desc_args *args,
    remote_domain_snapshot_get_xml_desc_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainSnapshotPtr snapshot = NULL;
    char *xml;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->snap.dom)))
        goto cleanup;

    if (!(snapshot = get_nonnull_domain_snapshot(dom, args->snap)))
        goto cleanup;

    if ((xml = virDomainSnapshotGetXMLDesc(snapshot, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(snapshot);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSnapshotHasMetadata(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_snapshot_has_metadata_args *args,
    remote_domain_snapshot_has_metadata_ret *ret);
static int remoteDispatchDomainSnapshotHasMetadataHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSnapshotHasMetadata");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSnapshotHasMetadata(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSnapshotHasMetadata(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_snapshot_has_metadata_args *args,
    remote_domain_snapshot_has_metadata_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainSnapshotPtr snapshot = NULL;
    int metadata;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->snap.dom)))
        goto cleanup;

    if (!(snapshot = get_nonnull_domain_snapshot(dom, args->snap)))
        goto cleanup;

    if ((metadata = virDomainSnapshotHasMetadata(snapshot, args->flags)) < 0)
        goto cleanup;

    ret->metadata = metadata;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(snapshot);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSnapshotIsCurrent(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_snapshot_is_current_args *args,
    remote_domain_snapshot_is_current_ret *ret);
static int remoteDispatchDomainSnapshotIsCurrentHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSnapshotIsCurrent");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSnapshotIsCurrent(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSnapshotIsCurrent(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_snapshot_is_current_args *args,
    remote_domain_snapshot_is_current_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainSnapshotPtr snapshot = NULL;
    int current;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->snap.dom)))
        goto cleanup;

    if (!(snapshot = get_nonnull_domain_snapshot(dom, args->snap)))
        goto cleanup;

    if ((current = virDomainSnapshotIsCurrent(snapshot, args->flags)) < 0)
        goto cleanup;

    ret->current = current;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(snapshot);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSnapshotListAllChildren(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_snapshot_list_all_children_args *args,
    remote_domain_snapshot_list_all_children_ret *ret);
static int remoteDispatchDomainSnapshotListAllChildrenHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSnapshotListAllChildren");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSnapshotListAllChildren(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSnapshotListAllChildren(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_snapshot_list_all_children_args *args,
    remote_domain_snapshot_list_all_children_ret *ret)
{
    int rv = -1;
    ssize_t i;
    virDomainPtr dom = NULL;
    virDomainSnapshotPtr snapshot = NULL;
    virDomainSnapshot **result = NULL;
    int nresults = 0;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->snapshot.dom)))
        goto cleanup;

    if (!(snapshot = get_nonnull_domain_snapshot(dom, args->snapshot)))
        goto cleanup;

    if ((nresults =
            virDomainSnapshotListAllChildren(snapshot,
                                             args->need_results ? &result : NULL,
                                             args->flags)) < 0)
        goto cleanup;

    if (nresults > REMOTE_DOMAIN_SNAPSHOT_LIST_MAX) {
        virReportError(VIR_ERR_INTERNAL_ERROR,
                       _("Too many domain_snapshots '%1$d' for limit '%2$d'"),
                       nresults, REMOTE_DOMAIN_SNAPSHOT_LIST_MAX);
        goto cleanup;
    }

    if (result && nresults) {
        ret->snapshots.snapshots_val =
            g_new0(typeof(*ret->snapshots.snapshots_val), nresults);

        ret->snapshots.snapshots_len = nresults;
        for (i = 0; i < nresults; i++)
            make_nonnull_domain_snapshot(ret->snapshots.snapshots_val + i, result[i]);
    } else {
        ret->snapshots.snapshots_len = 0;
        ret->snapshots.snapshots_val = NULL;
    }

    ret->ret = nresults;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(snapshot);
    virObjectUnref(dom);
    if (result) {
        for (i = 0; i < nresults; i++)
            virObjectUnref(result[i]);
    }
    VIR_FREE(result);
    return rv;
}



static int remoteDispatchDomainSnapshotListChildrenNames(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_snapshot_list_children_names_args *args,
    remote_domain_snapshot_list_children_names_ret *ret);
static int remoteDispatchDomainSnapshotListChildrenNamesHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSnapshotListChildrenNames");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSnapshotListChildrenNames(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSnapshotListChildrenNames(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_snapshot_list_children_names_args *args,
    remote_domain_snapshot_list_children_names_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainSnapshotPtr snapshot = NULL;
    int len;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (args->maxnames < 0) {
        virReportError(VIR_ERR_RPC,
                       "%s", _("maxnames must be non-negative"));
        goto cleanup;
    }
    if (args->maxnames > REMOTE_DOMAIN_SNAPSHOT_LIST_MAX) {
        virReportError(VIR_ERR_RPC,
                       "%s", _("maxnames > REMOTE_DOMAIN_SNAPSHOT_LIST_MAX"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->snap.dom)))
        goto cleanup;

    if (!(snapshot = get_nonnull_domain_snapshot(dom, args->snap)))
        goto cleanup;

    /* Allocate return buffer. */
    ret->names.names_val =
        g_new0(typeof(*ret->names.names_val), args->maxnames);

    if ((len = virDomainSnapshotListChildrenNames(snapshot, ret->names.names_val, args->maxnames, args->flags)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    virObjectUnref(snapshot);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSnapshotListNames(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_snapshot_list_names_args *args,
    remote_domain_snapshot_list_names_ret *ret);
static int remoteDispatchDomainSnapshotListNamesHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSnapshotListNames");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSnapshotListNames(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSnapshotListNames(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_snapshot_list_names_args *args,
    remote_domain_snapshot_list_names_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    int len;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (args->maxnames < 0) {
        virReportError(VIR_ERR_RPC,
                       "%s", _("maxnames must be non-negative"));
        goto cleanup;
    }
    if (args->maxnames > REMOTE_DOMAIN_SNAPSHOT_LIST_MAX) {
        virReportError(VIR_ERR_RPC,
                       "%s", _("maxnames > REMOTE_DOMAIN_SNAPSHOT_LIST_MAX"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    /* Allocate return buffer. */
    ret->names.names_val =
        g_new0(typeof(*ret->names.names_val), args->maxnames);

    if ((len = virDomainSnapshotListNames(dom, ret->names.names_val, args->maxnames, args->flags)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSnapshotLookupByName(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_snapshot_lookup_by_name_args *args,
    remote_domain_snapshot_lookup_by_name_ret *ret);
static int remoteDispatchDomainSnapshotLookupByNameHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSnapshotLookupByName");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSnapshotLookupByName(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSnapshotLookupByName(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_snapshot_lookup_by_name_args *args,
    remote_domain_snapshot_lookup_by_name_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainSnapshotPtr snap = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if ((snap = virDomainSnapshotLookupByName(dom, args->name, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_domain_snapshot(&ret->snap, snap);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    virObjectUnref(snap);
    return rv;
}



static int remoteDispatchDomainSnapshotNum(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_snapshot_num_args *args,
    remote_domain_snapshot_num_ret *ret);
static int remoteDispatchDomainSnapshotNumHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSnapshotNum");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSnapshotNum(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSnapshotNum(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_snapshot_num_args *args,
    remote_domain_snapshot_num_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    int num;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if ((num = virDomainSnapshotNum(dom, args->flags)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSnapshotNumChildren(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_snapshot_num_children_args *args,
    remote_domain_snapshot_num_children_ret *ret);
static int remoteDispatchDomainSnapshotNumChildrenHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSnapshotNumChildren");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSnapshotNumChildren(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSnapshotNumChildren(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_snapshot_num_children_args *args,
    remote_domain_snapshot_num_children_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainSnapshotPtr snapshot = NULL;
    int num;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->snap.dom)))
        goto cleanup;

    if (!(snapshot = get_nonnull_domain_snapshot(dom, args->snap)))
        goto cleanup;

    if ((num = virDomainSnapshotNumChildren(snapshot, args->flags)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(snapshot);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainStartDirtyRateCalc(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_start_dirty_rate_calc_args *args);
static int remoteDispatchDomainStartDirtyRateCalcHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainStartDirtyRateCalc");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainStartDirtyRateCalc(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainStartDirtyRateCalc(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_start_dirty_rate_calc_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainStartDirtyRateCalc(dom, args->seconds, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSuspend(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_suspend_args *args);
static int remoteDispatchDomainSuspendHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSuspend");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSuspend(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSuspend(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_suspend_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainSuspend(dom) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainUndefine(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_undefine_args *args);
static int remoteDispatchDomainUndefineHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainUndefine");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainUndefine(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainUndefine(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_undefine_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainUndefine(dom) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainUndefineFlags(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_undefine_flags_args *args);
static int remoteDispatchDomainUndefineFlagsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainUndefineFlags");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainUndefineFlags(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainUndefineFlags(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_undefine_flags_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainUndefineFlags(dom, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainUpdateDeviceFlags(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_domain_update_device_flags_args *args);
static int remoteDispatchDomainUpdateDeviceFlagsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainUpdateDeviceFlags");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainUpdateDeviceFlags(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainUpdateDeviceFlags(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_domain_update_device_flags_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dom = get_nonnull_domain(conn, args->dom)))
        goto cleanup;

    if (virDomainUpdateDeviceFlags(dom, args->xml, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchInterfaceChangeBegin(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_interface_change_begin_args *args);
static int remoteDispatchInterfaceChangeBeginHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchInterfaceChangeBegin");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchInterfaceChangeBegin(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchInterfaceChangeBegin(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_interface_change_begin_args *args)
{
    int rv = -1;

    virConnectPtr conn = remoteGetInterfaceConn(client);
    if (!conn)
        goto cleanup;

    if (virInterfaceChangeBegin(conn, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchInterfaceChangeCommit(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_interface_change_commit_args *args);
static int remoteDispatchInterfaceChangeCommitHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchInterfaceChangeCommit");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchInterfaceChangeCommit(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchInterfaceChangeCommit(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_interface_change_commit_args *args)
{
    int rv = -1;

    virConnectPtr conn = remoteGetInterfaceConn(client);
    if (!conn)
        goto cleanup;

    if (virInterfaceChangeCommit(conn, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchInterfaceChangeRollback(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_interface_change_rollback_args *args);
static int remoteDispatchInterfaceChangeRollbackHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchInterfaceChangeRollback");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchInterfaceChangeRollback(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchInterfaceChangeRollback(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_interface_change_rollback_args *args)
{
    int rv = -1;

    virConnectPtr conn = remoteGetInterfaceConn(client);
    if (!conn)
        goto cleanup;

    if (virInterfaceChangeRollback(conn, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchInterfaceCreate(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_interface_create_args *args);
static int remoteDispatchInterfaceCreateHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchInterfaceCreate");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchInterfaceCreate(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchInterfaceCreate(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_interface_create_args *args)
{
    int rv = -1;
    virInterfacePtr iface = NULL;

    virConnectPtr conn = remoteGetInterfaceConn(client);
    if (!conn)
        goto cleanup;

    if (!(iface = get_nonnull_interface(conn, args->iface)))
        goto cleanup;

    if (virInterfaceCreate(iface, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(iface);
    return rv;
}



static int remoteDispatchInterfaceDefineXML(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_interface_define_xml_args *args,
    remote_interface_define_xml_ret *ret);
static int remoteDispatchInterfaceDefineXMLHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchInterfaceDefineXML");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchInterfaceDefineXML(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchInterfaceDefineXML(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_interface_define_xml_args *args,
    remote_interface_define_xml_ret *ret)
{
    int rv = -1;
    virInterfacePtr iface = NULL;

    virConnectPtr conn = remoteGetInterfaceConn(client);
    if (!conn)
        goto cleanup;

    if ((iface = virInterfaceDefineXML(conn, args->xml, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_interface(&ret->iface, iface);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(iface);
    return rv;
}



static int remoteDispatchInterfaceDestroy(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_interface_destroy_args *args);
static int remoteDispatchInterfaceDestroyHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchInterfaceDestroy");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchInterfaceDestroy(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchInterfaceDestroy(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_interface_destroy_args *args)
{
    int rv = -1;
    virInterfacePtr iface = NULL;

    virConnectPtr conn = remoteGetInterfaceConn(client);
    if (!conn)
        goto cleanup;

    if (!(iface = get_nonnull_interface(conn, args->iface)))
        goto cleanup;

    if (virInterfaceDestroy(iface, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(iface);
    return rv;
}



static int remoteDispatchInterfaceGetXMLDesc(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_interface_get_xml_desc_args *args,
    remote_interface_get_xml_desc_ret *ret);
static int remoteDispatchInterfaceGetXMLDescHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchInterfaceGetXMLDesc");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchInterfaceGetXMLDesc(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchInterfaceGetXMLDesc(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_interface_get_xml_desc_args *args,
    remote_interface_get_xml_desc_ret *ret)
{
    int rv = -1;
    virInterfacePtr iface = NULL;
    char *xml;

    virConnectPtr conn = remoteGetInterfaceConn(client);
    if (!conn)
        goto cleanup;

    if (!(iface = get_nonnull_interface(conn, args->iface)))
        goto cleanup;

    if ((xml = virInterfaceGetXMLDesc(iface, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(iface);
    return rv;
}



static int remoteDispatchInterfaceIsActive(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_interface_is_active_args *args,
    remote_interface_is_active_ret *ret);
static int remoteDispatchInterfaceIsActiveHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchInterfaceIsActive");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchInterfaceIsActive(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchInterfaceIsActive(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_interface_is_active_args *args,
    remote_interface_is_active_ret *ret)
{
    int rv = -1;
    virInterfacePtr iface = NULL;
    int active;

    virConnectPtr conn = remoteGetInterfaceConn(client);
    if (!conn)
        goto cleanup;

    if (!(iface = get_nonnull_interface(conn, args->iface)))
        goto cleanup;

    if ((active = virInterfaceIsActive(iface)) < 0)
        goto cleanup;

    ret->active = active;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(iface);
    return rv;
}



static int remoteDispatchInterfaceLookupByMACString(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_interface_lookup_by_mac_string_args *args,
    remote_interface_lookup_by_mac_string_ret *ret);
static int remoteDispatchInterfaceLookupByMACStringHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchInterfaceLookupByMACString");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchInterfaceLookupByMACString(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchInterfaceLookupByMACString(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_interface_lookup_by_mac_string_args *args,
    remote_interface_lookup_by_mac_string_ret *ret)
{
    int rv = -1;
    virInterfacePtr iface = NULL;

    virConnectPtr conn = remoteGetInterfaceConn(client);
    if (!conn)
        goto cleanup;

    if ((iface = virInterfaceLookupByMACString(conn, args->mac)) == NULL)
        goto cleanup;

    make_nonnull_interface(&ret->iface, iface);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(iface);
    return rv;
}



static int remoteDispatchInterfaceLookupByName(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_interface_lookup_by_name_args *args,
    remote_interface_lookup_by_name_ret *ret);
static int remoteDispatchInterfaceLookupByNameHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchInterfaceLookupByName");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchInterfaceLookupByName(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchInterfaceLookupByName(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_interface_lookup_by_name_args *args,
    remote_interface_lookup_by_name_ret *ret)
{
    int rv = -1;
    virInterfacePtr iface = NULL;

    virConnectPtr conn = remoteGetInterfaceConn(client);
    if (!conn)
        goto cleanup;

    if ((iface = virInterfaceLookupByName(conn, args->name)) == NULL)
        goto cleanup;

    make_nonnull_interface(&ret->iface, iface);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(iface);
    return rv;
}



static int remoteDispatchInterfaceUndefine(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_interface_undefine_args *args);
static int remoteDispatchInterfaceUndefineHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchInterfaceUndefine");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchInterfaceUndefine(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchInterfaceUndefine(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_interface_undefine_args *args)
{
    int rv = -1;
    virInterfacePtr iface = NULL;

    virConnectPtr conn = remoteGetInterfaceConn(client);
    if (!conn)
        goto cleanup;

    if (!(iface = get_nonnull_interface(conn, args->iface)))
        goto cleanup;

    if (virInterfaceUndefine(iface) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(iface);
    return rv;
}



static int remoteDispatchNetworkCreate(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_network_create_args *args);
static int remoteDispatchNetworkCreateHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchNetworkCreate");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNetworkCreate(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNetworkCreate(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_network_create_args *args)
{
    int rv = -1;
    virNetworkPtr net = NULL;

    virConnectPtr conn = remoteGetNetworkConn(client);
    if (!conn)
        goto cleanup;

    if (!(net = get_nonnull_network(conn, args->net)))
        goto cleanup;

    if (virNetworkCreate(net) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(net);
    return rv;
}



static int remoteDispatchNetworkCreateXML(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_network_create_xml_args *args,
    remote_network_create_xml_ret *ret);
static int remoteDispatchNetworkCreateXMLHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNetworkCreateXML");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNetworkCreateXML(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNetworkCreateXML(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_network_create_xml_args *args,
    remote_network_create_xml_ret *ret)
{
    int rv = -1;
    virNetworkPtr net = NULL;

    virConnectPtr conn = remoteGetNetworkConn(client);
    if (!conn)
        goto cleanup;

    if ((net = virNetworkCreateXML(conn, args->xml)) == NULL)
        goto cleanup;

    make_nonnull_network(&ret->net, net);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(net);
    return rv;
}



static int remoteDispatchNetworkCreateXMLFlags(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_network_create_xml_flags_args *args,
    remote_network_create_xml_flags_ret *ret);
static int remoteDispatchNetworkCreateXMLFlagsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNetworkCreateXMLFlags");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNetworkCreateXMLFlags(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNetworkCreateXMLFlags(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_network_create_xml_flags_args *args,
    remote_network_create_xml_flags_ret *ret)
{
    int rv = -1;
    virNetworkPtr net = NULL;

    virConnectPtr conn = remoteGetNetworkConn(client);
    if (!conn)
        goto cleanup;

    if ((net = virNetworkCreateXMLFlags(conn, args->xml, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_network(&ret->net, net);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(net);
    return rv;
}



static int remoteDispatchNetworkDefineXML(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_network_define_xml_args *args,
    remote_network_define_xml_ret *ret);
static int remoteDispatchNetworkDefineXMLHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNetworkDefineXML");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNetworkDefineXML(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNetworkDefineXML(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_network_define_xml_args *args,
    remote_network_define_xml_ret *ret)
{
    int rv = -1;
    virNetworkPtr net = NULL;

    virConnectPtr conn = remoteGetNetworkConn(client);
    if (!conn)
        goto cleanup;

    if ((net = virNetworkDefineXML(conn, args->xml)) == NULL)
        goto cleanup;

    make_nonnull_network(&ret->net, net);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(net);
    return rv;
}



static int remoteDispatchNetworkDefineXMLFlags(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_network_define_xml_flags_args *args,
    remote_network_define_xml_flags_ret *ret);
static int remoteDispatchNetworkDefineXMLFlagsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNetworkDefineXMLFlags");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNetworkDefineXMLFlags(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNetworkDefineXMLFlags(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_network_define_xml_flags_args *args,
    remote_network_define_xml_flags_ret *ret)
{
    int rv = -1;
    virNetworkPtr net = NULL;

    virConnectPtr conn = remoteGetNetworkConn(client);
    if (!conn)
        goto cleanup;

    if ((net = virNetworkDefineXMLFlags(conn, args->xml, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_network(&ret->net, net);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(net);
    return rv;
}



static int remoteDispatchNetworkDestroy(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_network_destroy_args *args);
static int remoteDispatchNetworkDestroyHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchNetworkDestroy");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNetworkDestroy(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNetworkDestroy(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_network_destroy_args *args)
{
    int rv = -1;
    virNetworkPtr net = NULL;

    virConnectPtr conn = remoteGetNetworkConn(client);
    if (!conn)
        goto cleanup;

    if (!(net = get_nonnull_network(conn, args->net)))
        goto cleanup;

    if (virNetworkDestroy(net) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(net);
    return rv;
}



static int remoteDispatchNetworkGetAutostart(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_network_get_autostart_args *args,
    remote_network_get_autostart_ret *ret);
static int remoteDispatchNetworkGetAutostartHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNetworkGetAutostart");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNetworkGetAutostart(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNetworkGetAutostart(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_network_get_autostart_args *args,
    remote_network_get_autostart_ret *ret)
{
    int rv = -1;
    virNetworkPtr net = NULL;
    int autostart;

    virConnectPtr conn = remoteGetNetworkConn(client);
    if (!conn)
        goto cleanup;

    if (!(net = get_nonnull_network(conn, args->net)))
        goto cleanup;

    if (virNetworkGetAutostart(net, &autostart) < 0)
        goto cleanup;

    ret->autostart = autostart;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(net);
    return rv;
}



static int remoteDispatchNetworkGetBridgeName(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_network_get_bridge_name_args *args,
    remote_network_get_bridge_name_ret *ret);
static int remoteDispatchNetworkGetBridgeNameHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNetworkGetBridgeName");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNetworkGetBridgeName(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNetworkGetBridgeName(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_network_get_bridge_name_args *args,
    remote_network_get_bridge_name_ret *ret)
{
    int rv = -1;
    virNetworkPtr net = NULL;
    char *name;

    virConnectPtr conn = remoteGetNetworkConn(client);
    if (!conn)
        goto cleanup;

    if (!(net = get_nonnull_network(conn, args->net)))
        goto cleanup;

    if ((name = virNetworkGetBridgeName(net)) == NULL)
        goto cleanup;

    ret->name = name;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(net);
    return rv;
}



static int remoteDispatchNetworkGetDHCPLeases(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_network_get_dhcp_leases_args *args,
    remote_network_get_dhcp_leases_ret *ret);
static int remoteDispatchNetworkGetDHCPLeasesHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNetworkGetDHCPLeases");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNetworkGetDHCPLeases(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchNetworkGetDHCPLeases body has to be implemented manually */



static int remoteDispatchNetworkGetMetadata(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_network_get_metadata_args *args,
    remote_network_get_metadata_ret *ret);
static int remoteDispatchNetworkGetMetadataHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNetworkGetMetadata");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNetworkGetMetadata(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNetworkGetMetadata(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_network_get_metadata_args *args,
    remote_network_get_metadata_ret *ret)
{
    int rv = -1;
    virNetworkPtr network = NULL;
    char *uri;
    char *metadata;

    virConnectPtr conn = remoteGetNetworkConn(client);
    if (!conn)
        goto cleanup;

    if (!(network = get_nonnull_network(conn, args->network)))
        goto cleanup;

    uri = args->uri ? *args->uri : NULL;

    if ((metadata = virNetworkGetMetadata(network, args->type, uri, args->flags)) == NULL)
        goto cleanup;

    ret->metadata = metadata;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(network);
    return rv;
}



static int remoteDispatchNetworkGetXMLDesc(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_network_get_xml_desc_args *args,
    remote_network_get_xml_desc_ret *ret);
static int remoteDispatchNetworkGetXMLDescHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNetworkGetXMLDesc");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNetworkGetXMLDesc(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNetworkGetXMLDesc(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_network_get_xml_desc_args *args,
    remote_network_get_xml_desc_ret *ret)
{
    int rv = -1;
    virNetworkPtr net = NULL;
    char *xml;

    virConnectPtr conn = remoteGetNetworkConn(client);
    if (!conn)
        goto cleanup;

    if (!(net = get_nonnull_network(conn, args->net)))
        goto cleanup;

    if ((xml = virNetworkGetXMLDesc(net, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(net);
    return rv;
}



static int remoteDispatchNetworkIsActive(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_network_is_active_args *args,
    remote_network_is_active_ret *ret);
static int remoteDispatchNetworkIsActiveHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNetworkIsActive");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNetworkIsActive(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNetworkIsActive(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_network_is_active_args *args,
    remote_network_is_active_ret *ret)
{
    int rv = -1;
    virNetworkPtr net = NULL;
    int active;

    virConnectPtr conn = remoteGetNetworkConn(client);
    if (!conn)
        goto cleanup;

    if (!(net = get_nonnull_network(conn, args->net)))
        goto cleanup;

    if ((active = virNetworkIsActive(net)) < 0)
        goto cleanup;

    ret->active = active;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(net);
    return rv;
}



static int remoteDispatchNetworkIsPersistent(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_network_is_persistent_args *args,
    remote_network_is_persistent_ret *ret);
static int remoteDispatchNetworkIsPersistentHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNetworkIsPersistent");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNetworkIsPersistent(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNetworkIsPersistent(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_network_is_persistent_args *args,
    remote_network_is_persistent_ret *ret)
{
    int rv = -1;
    virNetworkPtr net = NULL;
    int persistent;

    virConnectPtr conn = remoteGetNetworkConn(client);
    if (!conn)
        goto cleanup;

    if (!(net = get_nonnull_network(conn, args->net)))
        goto cleanup;

    if ((persistent = virNetworkIsPersistent(net)) < 0)
        goto cleanup;

    ret->persistent = persistent;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(net);
    return rv;
}



static int remoteDispatchNetworkListAllPorts(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_network_list_all_ports_args *args,
    remote_network_list_all_ports_ret *ret);
static int remoteDispatchNetworkListAllPortsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNetworkListAllPorts");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNetworkListAllPorts(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNetworkListAllPorts(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_network_list_all_ports_args *args,
    remote_network_list_all_ports_ret *ret)
{
    int rv = -1;
    ssize_t i;
    virNetworkPtr network = NULL;
    virNetworkPort **result = NULL;
    int nresults = 0;

    virConnectPtr conn = remoteGetNetworkConn(client);
    if (!conn)
        goto cleanup;

    if (!(network = get_nonnull_network(conn, args->network)))
        goto cleanup;

    if ((nresults =
            virNetworkListAllPorts(network,
                                   args->need_results ? &result : NULL,
                                   args->flags)) < 0)
        goto cleanup;

    if (nresults > REMOTE_NETWORK_PORT_LIST_MAX) {
        virReportError(VIR_ERR_INTERNAL_ERROR,
                       _("Too many network_ports '%1$d' for limit '%2$d'"),
                       nresults, REMOTE_NETWORK_PORT_LIST_MAX);
        goto cleanup;
    }

    if (result && nresults) {
        ret->ports.ports_val =
            g_new0(typeof(*ret->ports.ports_val), nresults);

        ret->ports.ports_len = nresults;
        for (i = 0; i < nresults; i++)
            make_nonnull_network_port(ret->ports.ports_val + i, result[i]);
    } else {
        ret->ports.ports_len = 0;
        ret->ports.ports_val = NULL;
    }

    ret->ret = nresults;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(network);
    if (result) {
        for (i = 0; i < nresults; i++)
            virObjectUnref(result[i]);
    }
    VIR_FREE(result);
    return rv;
}



static int remoteDispatchNetworkLookupByName(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_network_lookup_by_name_args *args,
    remote_network_lookup_by_name_ret *ret);
static int remoteDispatchNetworkLookupByNameHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNetworkLookupByName");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNetworkLookupByName(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNetworkLookupByName(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_network_lookup_by_name_args *args,
    remote_network_lookup_by_name_ret *ret)
{
    int rv = -1;
    virNetworkPtr net = NULL;

    virConnectPtr conn = remoteGetNetworkConn(client);
    if (!conn)
        goto cleanup;

    if ((net = virNetworkLookupByName(conn, args->name)) == NULL)
        goto cleanup;

    make_nonnull_network(&ret->net, net);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(net);
    return rv;
}



static int remoteDispatchNetworkLookupByUUID(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_network_lookup_by_uuid_args *args,
    remote_network_lookup_by_uuid_ret *ret);
static int remoteDispatchNetworkLookupByUUIDHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNetworkLookupByUUID");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNetworkLookupByUUID(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNetworkLookupByUUID(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_network_lookup_by_uuid_args *args,
    remote_network_lookup_by_uuid_ret *ret)
{
    int rv = -1;
    virNetworkPtr net = NULL;

    virConnectPtr conn = remoteGetNetworkConn(client);
    if (!conn)
        goto cleanup;

    if ((net = virNetworkLookupByUUID(conn, (unsigned char *) args->uuid)) == NULL)
        goto cleanup;

    make_nonnull_network(&ret->net, net);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(net);
    return rv;
}



static int remoteDispatchNetworkPortCreateXML(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_network_port_create_xml_args *args,
    remote_network_port_create_xml_ret *ret);
static int remoteDispatchNetworkPortCreateXMLHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNetworkPortCreateXML");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNetworkPortCreateXML(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNetworkPortCreateXML(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_network_port_create_xml_args *args,
    remote_network_port_create_xml_ret *ret)
{
    int rv = -1;
    virNetworkPtr network = NULL;
    virNetworkPortPtr port = NULL;

    virConnectPtr conn = remoteGetNetworkConn(client);
    if (!conn)
        goto cleanup;

    if (!(network = get_nonnull_network(conn, args->network)))
        goto cleanup;

    if ((port = virNetworkPortCreateXML(network, args->xml, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_network_port(&ret->port, port);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(network);
    virObjectUnref(port);
    return rv;
}



static int remoteDispatchNetworkPortDelete(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_network_port_delete_args *args);
static int remoteDispatchNetworkPortDeleteHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchNetworkPortDelete");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNetworkPortDelete(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNetworkPortDelete(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_network_port_delete_args *args)
{
    int rv = -1;
    virNetworkPortPtr port = NULL;

    virConnectPtr conn = remoteGetNetworkConn(client);
    if (!conn)
        goto cleanup;

    if (!(port = get_nonnull_network_port(conn, args->port)))
        goto cleanup;

    if (virNetworkPortDelete(port, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(port);
    return rv;
}



static int remoteDispatchNetworkPortGetParameters(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_network_port_get_parameters_args *args,
    remote_network_port_get_parameters_ret *ret);
static int remoteDispatchNetworkPortGetParametersHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNetworkPortGetParameters");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNetworkPortGetParameters(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchNetworkPortGetParameters body has to be implemented manually */



static int remoteDispatchNetworkPortGetXMLDesc(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_network_port_get_xml_desc_args *args,
    remote_network_port_get_xml_desc_ret *ret);
static int remoteDispatchNetworkPortGetXMLDescHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNetworkPortGetXMLDesc");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNetworkPortGetXMLDesc(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNetworkPortGetXMLDesc(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_network_port_get_xml_desc_args *args,
    remote_network_port_get_xml_desc_ret *ret)
{
    int rv = -1;
    virNetworkPortPtr port = NULL;
    char *xml;

    virConnectPtr conn = remoteGetNetworkConn(client);
    if (!conn)
        goto cleanup;

    if (!(port = get_nonnull_network_port(conn, args->port)))
        goto cleanup;

    if ((xml = virNetworkPortGetXMLDesc(port, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(port);
    return rv;
}



static int remoteDispatchNetworkPortLookupByUUID(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_network_port_lookup_by_uuid_args *args,
    remote_network_port_lookup_by_uuid_ret *ret);
static int remoteDispatchNetworkPortLookupByUUIDHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNetworkPortLookupByUUID");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNetworkPortLookupByUUID(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNetworkPortLookupByUUID(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_network_port_lookup_by_uuid_args *args,
    remote_network_port_lookup_by_uuid_ret *ret)
{
    int rv = -1;
    virNetworkPtr network = NULL;
    virNetworkPortPtr port = NULL;

    virConnectPtr conn = remoteGetNetworkConn(client);
    if (!conn)
        goto cleanup;

    if (!(network = get_nonnull_network(conn, args->network)))
        goto cleanup;

    if ((port = virNetworkPortLookupByUUID(network, (unsigned char *) args->uuid)) == NULL)
        goto cleanup;

    make_nonnull_network_port(&ret->port, port);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(network);
    virObjectUnref(port);
    return rv;
}



static int remoteDispatchNetworkPortSetParameters(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_network_port_set_parameters_args *args);
static int remoteDispatchNetworkPortSetParametersHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchNetworkPortSetParameters");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNetworkPortSetParameters(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNetworkPortSetParameters(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_network_port_set_parameters_args *args)
{
    int rv = -1;
    virNetworkPortPtr port = NULL;
    virTypedParameterPtr params = NULL;
    int nparams = 0;

    virConnectPtr conn = remoteGetNetworkConn(client);
    if (!conn)
        goto cleanup;

    if (!(port = get_nonnull_network_port(conn, args->port)))
        goto cleanup;

    if (virTypedParamsDeserialize((struct _virTypedParameterRemote *) args->params.params_val,
                                  args->params.params_len,
                                  REMOTE_NETWORK_PORT_PARAMETERS_MAX,
                                  &params,
                                  &nparams) < 0)
        goto cleanup;

    if (virNetworkPortSetParameters(port, params, nparams, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(port);
    virTypedParamsFree(params, nparams);
    return rv;
}



static int remoteDispatchNetworkSetAutostart(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_network_set_autostart_args *args);
static int remoteDispatchNetworkSetAutostartHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchNetworkSetAutostart");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNetworkSetAutostart(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNetworkSetAutostart(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_network_set_autostart_args *args)
{
    int rv = -1;
    virNetworkPtr net = NULL;

    virConnectPtr conn = remoteGetNetworkConn(client);
    if (!conn)
        goto cleanup;

    if (!(net = get_nonnull_network(conn, args->net)))
        goto cleanup;

    if (virNetworkSetAutostart(net, args->autostart) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(net);
    return rv;
}



static int remoteDispatchNetworkSetMetadata(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_network_set_metadata_args *args);
static int remoteDispatchNetworkSetMetadataHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchNetworkSetMetadata");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNetworkSetMetadata(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNetworkSetMetadata(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_network_set_metadata_args *args)
{
    int rv = -1;
    virNetworkPtr network = NULL;
    char *metadata;
    char *key;
    char *uri;

    virConnectPtr conn = remoteGetNetworkConn(client);
    if (!conn)
        goto cleanup;

    if (!(network = get_nonnull_network(conn, args->network)))
        goto cleanup;

    metadata = args->metadata ? *args->metadata : NULL;
    key = args->key ? *args->key : NULL;
    uri = args->uri ? *args->uri : NULL;

    if (virNetworkSetMetadata(network, args->type, metadata, key, uri, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(network);
    return rv;
}



static int remoteDispatchNetworkUndefine(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_network_undefine_args *args);
static int remoteDispatchNetworkUndefineHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchNetworkUndefine");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNetworkUndefine(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNetworkUndefine(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_network_undefine_args *args)
{
    int rv = -1;
    virNetworkPtr net = NULL;

    virConnectPtr conn = remoteGetNetworkConn(client);
    if (!conn)
        goto cleanup;

    if (!(net = get_nonnull_network(conn, args->net)))
        goto cleanup;

    if (virNetworkUndefine(net) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(net);
    return rv;
}



static int remoteDispatchNetworkUpdate(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_network_update_args *args);
static int remoteDispatchNetworkUpdateHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchNetworkUpdate");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNetworkUpdate(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNetworkUpdate(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_network_update_args *args)
{
    int rv = -1;
    virNetworkPtr net = NULL;

    virConnectPtr conn = remoteGetNetworkConn(client);
    if (!conn)
        goto cleanup;

    if (!(net = get_nonnull_network(conn, args->net)))
        goto cleanup;

    if (virNetworkUpdate(net, args->command, args->section, args->parentIndex, args->xml, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(net);
    return rv;
}



static int remoteDispatchNodeAllocPages(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_node_alloc_pages_args *args,
    remote_node_alloc_pages_ret *ret);
static int remoteDispatchNodeAllocPagesHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeAllocPages");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeAllocPages(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchNodeAllocPages body has to be implemented manually */



static int remoteDispatchNodeDeviceCreate(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_node_device_create_args *args);
static int remoteDispatchNodeDeviceCreateHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeDeviceCreate");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeDeviceCreate(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNodeDeviceCreate(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_node_device_create_args *args)
{
    int rv = -1;
    virNodeDevicePtr dev = NULL;

    virConnectPtr conn = remoteGetNodeDevConn(client);
    if (!conn)
        goto cleanup;

    if (!(dev = get_nonnull_node_device_name(conn, args->name)))
        goto cleanup;

    if (virNodeDeviceCreate(dev, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dev);
    return rv;
}



static int remoteDispatchNodeDeviceCreateXML(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_node_device_create_xml_args *args,
    remote_node_device_create_xml_ret *ret);
static int remoteDispatchNodeDeviceCreateXMLHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeDeviceCreateXML");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeDeviceCreateXML(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNodeDeviceCreateXML(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_node_device_create_xml_args *args,
    remote_node_device_create_xml_ret *ret)
{
    int rv = -1;
    virNodeDevicePtr dev = NULL;

    virConnectPtr conn = remoteGetNodeDevConn(client);
    if (!conn)
        goto cleanup;

    if ((dev = virNodeDeviceCreateXML(conn, args->xml_desc, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_node_device(&ret->dev, dev);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dev);
    return rv;
}



static int remoteDispatchNodeDeviceDefineXML(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_node_device_define_xml_args *args,
    remote_node_device_define_xml_ret *ret);
static int remoteDispatchNodeDeviceDefineXMLHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeDeviceDefineXML");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeDeviceDefineXML(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNodeDeviceDefineXML(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_node_device_define_xml_args *args,
    remote_node_device_define_xml_ret *ret)
{
    int rv = -1;
    virNodeDevicePtr dev = NULL;

    virConnectPtr conn = remoteGetNodeDevConn(client);
    if (!conn)
        goto cleanup;

    if ((dev = virNodeDeviceDefineXML(conn, args->xml_desc, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_node_device(&ret->dev, dev);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dev);
    return rv;
}



static int remoteDispatchNodeDeviceDestroy(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_node_device_destroy_args *args);
static int remoteDispatchNodeDeviceDestroyHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeDeviceDestroy");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeDeviceDestroy(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNodeDeviceDestroy(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_node_device_destroy_args *args)
{
    int rv = -1;
    virNodeDevicePtr dev = NULL;

    virConnectPtr conn = remoteGetNodeDevConn(client);
    if (!conn)
        goto cleanup;

    if (!(dev = get_nonnull_node_device_name(conn, args->name)))
        goto cleanup;

    if (virNodeDeviceDestroy(dev) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dev);
    return rv;
}



static int remoteDispatchNodeDeviceDetachFlags(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_node_device_detach_flags_args *args);
static int remoteDispatchNodeDeviceDetachFlagsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeDeviceDetachFlags");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeDeviceDetachFlags(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNodeDeviceDetachFlags(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_node_device_detach_flags_args *args)
{
    int rv = -1;
    virNodeDevicePtr dev = NULL;
    char *driverName;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dev = get_nonnull_node_device_name(conn, args->name)))
        goto cleanup;

    driverName = args->driverName ? *args->driverName : NULL;

    if (virNodeDeviceDetachFlags(dev, driverName, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dev);
    return rv;
}



static int remoteDispatchNodeDeviceDettach(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_node_device_dettach_args *args);
static int remoteDispatchNodeDeviceDettachHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeDeviceDettach");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeDeviceDettach(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNodeDeviceDettach(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_node_device_dettach_args *args)
{
    int rv = -1;
    virNodeDevicePtr dev = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dev = get_nonnull_node_device_name(conn, args->name)))
        goto cleanup;

    if (virNodeDeviceDettach(dev) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dev);
    return rv;
}



static int remoteDispatchNodeDeviceGetAutostart(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_node_device_get_autostart_args *args,
    remote_node_device_get_autostart_ret *ret);
static int remoteDispatchNodeDeviceGetAutostartHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeDeviceGetAutostart");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeDeviceGetAutostart(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNodeDeviceGetAutostart(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_node_device_get_autostart_args *args,
    remote_node_device_get_autostart_ret *ret)
{
    int rv = -1;
    virNodeDevicePtr dev = NULL;
    int autostart;

    virConnectPtr conn = remoteGetNodeDevConn(client);
    if (!conn)
        goto cleanup;

    if (!(dev = get_nonnull_node_device_name(conn, args->name)))
        goto cleanup;

    if (virNodeDeviceGetAutostart(dev, &autostart) < 0)
        goto cleanup;

    ret->autostart = autostart;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dev);
    return rv;
}



static int remoteDispatchNodeDeviceGetParent(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_node_device_get_parent_args *args,
    remote_node_device_get_parent_ret *ret);
static int remoteDispatchNodeDeviceGetParentHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeDeviceGetParent");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeDeviceGetParent(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchNodeDeviceGetParent body has to be implemented manually */



static int remoteDispatchNodeDeviceGetXMLDesc(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_node_device_get_xml_desc_args *args,
    remote_node_device_get_xml_desc_ret *ret);
static int remoteDispatchNodeDeviceGetXMLDescHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeDeviceGetXMLDesc");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeDeviceGetXMLDesc(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNodeDeviceGetXMLDesc(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_node_device_get_xml_desc_args *args,
    remote_node_device_get_xml_desc_ret *ret)
{
    int rv = -1;
    virNodeDevicePtr dev = NULL;
    char *xml;

    virConnectPtr conn = remoteGetNodeDevConn(client);
    if (!conn)
        goto cleanup;

    if (!(dev = get_nonnull_node_device_name(conn, args->name)))
        goto cleanup;

    if ((xml = virNodeDeviceGetXMLDesc(dev, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dev);
    return rv;
}



static int remoteDispatchNodeDeviceIsActive(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_node_device_is_active_args *args,
    remote_node_device_is_active_ret *ret);
static int remoteDispatchNodeDeviceIsActiveHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeDeviceIsActive");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeDeviceIsActive(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNodeDeviceIsActive(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_node_device_is_active_args *args,
    remote_node_device_is_active_ret *ret)
{
    int rv = -1;
    virNodeDevicePtr dev = NULL;
    int active;

    virConnectPtr conn = remoteGetNodeDevConn(client);
    if (!conn)
        goto cleanup;

    if (!(dev = get_nonnull_node_device_name(conn, args->name)))
        goto cleanup;

    if ((active = virNodeDeviceIsActive(dev)) < 0)
        goto cleanup;

    ret->active = active;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dev);
    return rv;
}



static int remoteDispatchNodeDeviceIsPersistent(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_node_device_is_persistent_args *args,
    remote_node_device_is_persistent_ret *ret);
static int remoteDispatchNodeDeviceIsPersistentHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeDeviceIsPersistent");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeDeviceIsPersistent(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNodeDeviceIsPersistent(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_node_device_is_persistent_args *args,
    remote_node_device_is_persistent_ret *ret)
{
    int rv = -1;
    virNodeDevicePtr dev = NULL;
    int persistent;

    virConnectPtr conn = remoteGetNodeDevConn(client);
    if (!conn)
        goto cleanup;

    if (!(dev = get_nonnull_node_device_name(conn, args->name)))
        goto cleanup;

    if ((persistent = virNodeDeviceIsPersistent(dev)) < 0)
        goto cleanup;

    ret->persistent = persistent;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dev);
    return rv;
}



static int remoteDispatchNodeDeviceListCaps(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_node_device_list_caps_args *args,
    remote_node_device_list_caps_ret *ret);
static int remoteDispatchNodeDeviceListCapsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeDeviceListCaps");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeDeviceListCaps(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNodeDeviceListCaps(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_node_device_list_caps_args *args,
    remote_node_device_list_caps_ret *ret)
{
    int rv = -1;
    virNodeDevicePtr dev = NULL;
    int len;

    virConnectPtr conn = remoteGetNodeDevConn(client);
    if (!conn)
        goto cleanup;

    if (args->maxnames < 0) {
        virReportError(VIR_ERR_RPC,
                       "%s", _("maxnames must be non-negative"));
        goto cleanup;
    }
    if (args->maxnames > REMOTE_NODE_DEVICE_CAPS_LIST_MAX) {
        virReportError(VIR_ERR_RPC,
                       "%s", _("maxnames > REMOTE_NODE_DEVICE_CAPS_LIST_MAX"));
        goto cleanup;
    }

    if (!(dev = get_nonnull_node_device_name(conn, args->name)))
        goto cleanup;

    /* Allocate return buffer. */
    ret->names.names_val =
        g_new0(typeof(*ret->names.names_val), args->maxnames);

    if ((len = virNodeDeviceListCaps(dev, ret->names.names_val, args->maxnames)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    virObjectUnref(dev);
    return rv;
}



static int remoteDispatchNodeDeviceLookupByName(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_node_device_lookup_by_name_args *args,
    remote_node_device_lookup_by_name_ret *ret);
static int remoteDispatchNodeDeviceLookupByNameHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeDeviceLookupByName");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeDeviceLookupByName(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNodeDeviceLookupByName(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_node_device_lookup_by_name_args *args,
    remote_node_device_lookup_by_name_ret *ret)
{
    int rv = -1;
    virNodeDevicePtr dev = NULL;

    virConnectPtr conn = remoteGetNodeDevConn(client);
    if (!conn)
        goto cleanup;

    if ((dev = virNodeDeviceLookupByName(conn, args->name)) == NULL)
        goto cleanup;

    make_nonnull_node_device(&ret->dev, dev);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dev);
    return rv;
}



static int remoteDispatchNodeDeviceLookupSCSIHostByWWN(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_node_device_lookup_scsi_host_by_wwn_args *args,
    remote_node_device_lookup_scsi_host_by_wwn_ret *ret);
static int remoteDispatchNodeDeviceLookupSCSIHostByWWNHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeDeviceLookupSCSIHostByWWN");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeDeviceLookupSCSIHostByWWN(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNodeDeviceLookupSCSIHostByWWN(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_node_device_lookup_scsi_host_by_wwn_args *args,
    remote_node_device_lookup_scsi_host_by_wwn_ret *ret)
{
    int rv = -1;
    virNodeDevicePtr dev = NULL;

    virConnectPtr conn = remoteGetNodeDevConn(client);
    if (!conn)
        goto cleanup;

    if ((dev = virNodeDeviceLookupSCSIHostByWWN(conn, args->wwnn, args->wwpn, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_node_device(&ret->dev, dev);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dev);
    return rv;
}



static int remoteDispatchNodeDeviceNumOfCaps(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_node_device_num_of_caps_args *args,
    remote_node_device_num_of_caps_ret *ret);
static int remoteDispatchNodeDeviceNumOfCapsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeDeviceNumOfCaps");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeDeviceNumOfCaps(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNodeDeviceNumOfCaps(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_node_device_num_of_caps_args *args,
    remote_node_device_num_of_caps_ret *ret)
{
    int rv = -1;
    virNodeDevicePtr dev = NULL;
    int num;

    virConnectPtr conn = remoteGetNodeDevConn(client);
    if (!conn)
        goto cleanup;

    if (!(dev = get_nonnull_node_device_name(conn, args->name)))
        goto cleanup;

    if ((num = virNodeDeviceNumOfCaps(dev)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dev);
    return rv;
}



static int remoteDispatchNodeDeviceReAttach(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_node_device_re_attach_args *args);
static int remoteDispatchNodeDeviceReAttachHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeDeviceReAttach");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeDeviceReAttach(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNodeDeviceReAttach(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_node_device_re_attach_args *args)
{
    int rv = -1;
    virNodeDevicePtr dev = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dev = get_nonnull_node_device_name(conn, args->name)))
        goto cleanup;

    if (virNodeDeviceReAttach(dev) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dev);
    return rv;
}



static int remoteDispatchNodeDeviceReset(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_node_device_reset_args *args);
static int remoteDispatchNodeDeviceResetHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeDeviceReset");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeDeviceReset(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNodeDeviceReset(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_node_device_reset_args *args)
{
    int rv = -1;
    virNodeDevicePtr dev = NULL;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (!(dev = get_nonnull_node_device_name(conn, args->name)))
        goto cleanup;

    if (virNodeDeviceReset(dev) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dev);
    return rv;
}



static int remoteDispatchNodeDeviceSetAutostart(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_node_device_set_autostart_args *args);
static int remoteDispatchNodeDeviceSetAutostartHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeDeviceSetAutostart");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeDeviceSetAutostart(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNodeDeviceSetAutostart(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_node_device_set_autostart_args *args)
{
    int rv = -1;
    virNodeDevicePtr dev = NULL;

    virConnectPtr conn = remoteGetNodeDevConn(client);
    if (!conn)
        goto cleanup;

    if (!(dev = get_nonnull_node_device_name(conn, args->name)))
        goto cleanup;

    if (virNodeDeviceSetAutostart(dev, args->autostart) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dev);
    return rv;
}



static int remoteDispatchNodeDeviceUndefine(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_node_device_undefine_args *args);
static int remoteDispatchNodeDeviceUndefineHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeDeviceUndefine");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeDeviceUndefine(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNodeDeviceUndefine(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_node_device_undefine_args *args)
{
    int rv = -1;
    virNodeDevicePtr dev = NULL;

    virConnectPtr conn = remoteGetNodeDevConn(client);
    if (!conn)
        goto cleanup;

    if (!(dev = get_nonnull_node_device_name(conn, args->name)))
        goto cleanup;

    if (virNodeDeviceUndefine(dev, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dev);
    return rv;
}



static int remoteDispatchNodeDeviceUpdate(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_node_device_update_args *args);
static int remoteDispatchNodeDeviceUpdateHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeDeviceUpdate");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeDeviceUpdate(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNodeDeviceUpdate(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_node_device_update_args *args)
{
    int rv = -1;
    virNodeDevicePtr dev = NULL;

    virConnectPtr conn = remoteGetNodeDevConn(client);
    if (!conn)
        goto cleanup;

    if (!(dev = get_nonnull_node_device_name(conn, args->name)))
        goto cleanup;

    if (virNodeDeviceUpdate(dev, args->xml_desc, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dev);
    return rv;
}



static int remoteDispatchNodeGetCellsFreeMemory(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_node_get_cells_free_memory_args *args,
    remote_node_get_cells_free_memory_ret *ret);
static int remoteDispatchNodeGetCellsFreeMemoryHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeGetCellsFreeMemory");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeGetCellsFreeMemory(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNodeGetCellsFreeMemory(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_node_get_cells_free_memory_args *args,
    remote_node_get_cells_free_memory_ret *ret)
{
    int rv = -1;
    int len;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (args->maxcells < 0) {
        virReportError(VIR_ERR_RPC,
                       "%s", _("maxcells must be non-negative"));
        goto cleanup;
    }
    if (args->maxcells > REMOTE_NODE_MAX_CELLS) {
        virReportError(VIR_ERR_RPC,
                       "%s", _("maxcells > REMOTE_NODE_MAX_CELLS"));
        goto cleanup;
    }

    /* Allocate return buffer. */
    ret->cells.cells_val =
        g_new0(typeof(*ret->cells.cells_val), args->maxcells);

    if ((len = virNodeGetCellsFreeMemory(conn, (unsigned long long *)ret->cells.cells_val, args->startCell, args->maxcells)) <= 0)
        goto cleanup;

    ret->cells.cells_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(ret->cells.cells_val);
    }
    return rv;
}



static int remoteDispatchNodeGetCPUMap(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_node_get_cpu_map_args *args,
    remote_node_get_cpu_map_ret *ret);
static int remoteDispatchNodeGetCPUMapHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeGetCPUMap");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeGetCPUMap(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchNodeGetCPUMap body has to be implemented manually */



static int remoteDispatchNodeGetCPUStats(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_node_get_cpu_stats_args *args,
    remote_node_get_cpu_stats_ret *ret);
static int remoteDispatchNodeGetCPUStatsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeGetCPUStats");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeGetCPUStats(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchNodeGetCPUStats body has to be implemented manually */



static int remoteDispatchNodeGetFreeMemory(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_node_get_free_memory_ret *ret);
static int remoteDispatchNodeGetFreeMemoryHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args G_GNUC_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeGetFreeMemory");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeGetFreeMemory(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNodeGetFreeMemory(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_node_get_free_memory_ret *ret)
{
    int rv = -1;
    unsigned long long freeMem;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if ((freeMem = virNodeGetFreeMemory(conn)) == 0)
        goto cleanup;

    ret->freeMem = freeMem;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchNodeGetFreePages(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_node_get_free_pages_args *args,
    remote_node_get_free_pages_ret *ret);
static int remoteDispatchNodeGetFreePagesHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeGetFreePages");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeGetFreePages(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchNodeGetFreePages body has to be implemented manually */



static int remoteDispatchNodeGetInfo(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_node_get_info_ret *ret);
static int remoteDispatchNodeGetInfoHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args G_GNUC_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeGetInfo");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeGetInfo(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNodeGetInfo(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_node_get_info_ret *ret)
{
    int rv = -1;
    virNodeInfo tmp;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (virNodeGetInfo(conn, &tmp) < 0)
        goto cleanup;

    memcpy(ret->model, tmp.model, sizeof(ret->model));
    ret->memory = tmp.memory;
    ret->cpus = tmp.cpus;
    ret->mhz = tmp.mhz;
    ret->nodes = tmp.nodes;
    ret->sockets = tmp.sockets;
    ret->cores = tmp.cores;
    ret->threads = tmp.threads;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchNodeGetMemoryParameters(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_node_get_memory_parameters_args *args,
    remote_node_get_memory_parameters_ret *ret);
static int remoteDispatchNodeGetMemoryParametersHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeGetMemoryParameters");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeGetMemoryParameters(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchNodeGetMemoryParameters body has to be implemented manually */



static int remoteDispatchNodeGetMemoryStats(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_node_get_memory_stats_args *args,
    remote_node_get_memory_stats_ret *ret);
static int remoteDispatchNodeGetMemoryStatsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeGetMemoryStats");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeGetMemoryStats(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchNodeGetMemoryStats body has to be implemented manually */



static int remoteDispatchNodeGetSecurityModel(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_node_get_security_model_ret *ret);
static int remoteDispatchNodeGetSecurityModelHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args G_GNUC_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeGetSecurityModel");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeGetSecurityModel(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchNodeGetSecurityModel body has to be implemented manually */



static int remoteDispatchNodeGetSevInfo(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_node_get_sev_info_args *args,
    remote_node_get_sev_info_ret *ret);
static int remoteDispatchNodeGetSevInfoHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeGetSevInfo");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeGetSevInfo(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchNodeGetSevInfo body has to be implemented manually */



static int remoteDispatchNodeListDevices(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_node_list_devices_args *args,
    remote_node_list_devices_ret *ret);
static int remoteDispatchNodeListDevicesHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeListDevices");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeListDevices(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNodeListDevices(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_node_list_devices_args *args,
    remote_node_list_devices_ret *ret)
{
    int rv = -1;
    char *cap;
    int len;

    virConnectPtr conn = remoteGetNodeDevConn(client);
    if (!conn)
        goto cleanup;

    if (args->maxnames < 0) {
        virReportError(VIR_ERR_RPC,
                       "%s", _("maxnames must be non-negative"));
        goto cleanup;
    }
    if (args->maxnames > REMOTE_NODE_DEVICE_LIST_MAX) {
        virReportError(VIR_ERR_RPC,
                       "%s", _("maxnames > REMOTE_NODE_DEVICE_LIST_MAX"));
        goto cleanup;
    }

    cap = args->cap ? *args->cap : NULL;

    /* Allocate return buffer. */
    ret->names.names_val =
        g_new0(typeof(*ret->names.names_val), args->maxnames);

    if ((len = virNodeListDevices(conn, cap, ret->names.names_val, args->maxnames, args->flags)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    return rv;
}



static int remoteDispatchNodeNumOfDevices(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_node_num_of_devices_args *args,
    remote_node_num_of_devices_ret *ret);
static int remoteDispatchNodeNumOfDevicesHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeNumOfDevices");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeNumOfDevices(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNodeNumOfDevices(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_node_num_of_devices_args *args,
    remote_node_num_of_devices_ret *ret)
{
    int rv = -1;
    char *cap;
    int num;

    virConnectPtr conn = remoteGetNodeDevConn(client);
    if (!conn)
        goto cleanup;

    cap = args->cap ? *args->cap : NULL;

    if ((num = virNodeNumOfDevices(conn, cap, args->flags)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchNodeSetMemoryParameters(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_node_set_memory_parameters_args *args);
static int remoteDispatchNodeSetMemoryParametersHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeSetMemoryParameters");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeSetMemoryParameters(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNodeSetMemoryParameters(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_node_set_memory_parameters_args *args)
{
    int rv = -1;
    virTypedParameterPtr params = NULL;
    int nparams = 0;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (virTypedParamsDeserialize((struct _virTypedParameterRemote *) args->params.params_val,
                                  args->params.params_len,
                                  REMOTE_NODE_MEMORY_PARAMETERS_MAX,
                                  &params,
                                  &nparams) < 0)
        goto cleanup;

    if (virNodeSetMemoryParameters(conn, params, nparams, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virTypedParamsFree(params, nparams);
    return rv;
}



static int remoteDispatchNodeSuspendForDuration(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_node_suspend_for_duration_args *args);
static int remoteDispatchNodeSuspendForDurationHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeSuspendForDuration");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeSuspendForDuration(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNodeSuspendForDuration(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_node_suspend_for_duration_args *args)
{
    int rv = -1;

    virConnectPtr conn = remoteGetHypervisorConn(client);
    if (!conn)
        goto cleanup;

    if (virNodeSuspendForDuration(conn, args->target, args->duration, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchNWFilterBindingCreateXML(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_nwfilter_binding_create_xml_args *args,
    remote_nwfilter_binding_create_xml_ret *ret);
static int remoteDispatchNWFilterBindingCreateXMLHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNWFilterBindingCreateXML");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNWFilterBindingCreateXML(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNWFilterBindingCreateXML(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_nwfilter_binding_create_xml_args *args,
    remote_nwfilter_binding_create_xml_ret *ret)
{
    int rv = -1;
    virNWFilterBindingPtr nwfilter = NULL;

    virConnectPtr conn = remoteGetNWFilterConn(client);
    if (!conn)
        goto cleanup;

    if ((nwfilter = virNWFilterBindingCreateXML(conn, args->xml, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_nwfilter_binding(&ret->nwfilter, nwfilter);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(nwfilter);
    return rv;
}



static int remoteDispatchNWFilterBindingDelete(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_nwfilter_binding_delete_args *args);
static int remoteDispatchNWFilterBindingDeleteHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchNWFilterBindingDelete");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNWFilterBindingDelete(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNWFilterBindingDelete(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_nwfilter_binding_delete_args *args)
{
    int rv = -1;
    virNWFilterBindingPtr nwfilter = NULL;

    virConnectPtr conn = remoteGetNWFilterConn(client);
    if (!conn)
        goto cleanup;

    if (!(nwfilter = get_nonnull_nwfilter_binding(conn, args->nwfilter)))
        goto cleanup;

    if (virNWFilterBindingDelete(nwfilter) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(nwfilter);
    return rv;
}



static int remoteDispatchNWFilterBindingGetXMLDesc(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_nwfilter_binding_get_xml_desc_args *args,
    remote_nwfilter_binding_get_xml_desc_ret *ret);
static int remoteDispatchNWFilterBindingGetXMLDescHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNWFilterBindingGetXMLDesc");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNWFilterBindingGetXMLDesc(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNWFilterBindingGetXMLDesc(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_nwfilter_binding_get_xml_desc_args *args,
    remote_nwfilter_binding_get_xml_desc_ret *ret)
{
    int rv = -1;
    virNWFilterBindingPtr nwfilter = NULL;
    char *xml;

    virConnectPtr conn = remoteGetNWFilterConn(client);
    if (!conn)
        goto cleanup;

    if (!(nwfilter = get_nonnull_nwfilter_binding(conn, args->nwfilter)))
        goto cleanup;

    if ((xml = virNWFilterBindingGetXMLDesc(nwfilter, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(nwfilter);
    return rv;
}



static int remoteDispatchNWFilterBindingLookupByPortDev(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_nwfilter_binding_lookup_by_port_dev_args *args,
    remote_nwfilter_binding_lookup_by_port_dev_ret *ret);
static int remoteDispatchNWFilterBindingLookupByPortDevHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNWFilterBindingLookupByPortDev");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNWFilterBindingLookupByPortDev(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNWFilterBindingLookupByPortDev(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_nwfilter_binding_lookup_by_port_dev_args *args,
    remote_nwfilter_binding_lookup_by_port_dev_ret *ret)
{
    int rv = -1;
    virNWFilterBindingPtr nwfilter = NULL;

    virConnectPtr conn = remoteGetNWFilterConn(client);
    if (!conn)
        goto cleanup;

    if ((nwfilter = virNWFilterBindingLookupByPortDev(conn, args->name)) == NULL)
        goto cleanup;

    make_nonnull_nwfilter_binding(&ret->nwfilter, nwfilter);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(nwfilter);
    return rv;
}



static int remoteDispatchNWFilterDefineXML(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_nwfilter_define_xml_args *args,
    remote_nwfilter_define_xml_ret *ret);
static int remoteDispatchNWFilterDefineXMLHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNWFilterDefineXML");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNWFilterDefineXML(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNWFilterDefineXML(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_nwfilter_define_xml_args *args,
    remote_nwfilter_define_xml_ret *ret)
{
    int rv = -1;
    virNWFilterPtr nwfilter = NULL;

    virConnectPtr conn = remoteGetNWFilterConn(client);
    if (!conn)
        goto cleanup;

    if ((nwfilter = virNWFilterDefineXML(conn, args->xml)) == NULL)
        goto cleanup;

    make_nonnull_nwfilter(&ret->nwfilter, nwfilter);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(nwfilter);
    return rv;
}



static int remoteDispatchNWFilterDefineXMLFlags(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_nwfilter_define_xml_flags_args *args,
    remote_nwfilter_define_xml_flags_ret *ret);
static int remoteDispatchNWFilterDefineXMLFlagsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNWFilterDefineXMLFlags");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNWFilterDefineXMLFlags(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNWFilterDefineXMLFlags(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_nwfilter_define_xml_flags_args *args,
    remote_nwfilter_define_xml_flags_ret *ret)
{
    int rv = -1;
    virNWFilterPtr nwfilter = NULL;

    virConnectPtr conn = remoteGetNWFilterConn(client);
    if (!conn)
        goto cleanup;

    if ((nwfilter = virNWFilterDefineXMLFlags(conn, args->xml, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_nwfilter(&ret->nwfilter, nwfilter);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(nwfilter);
    return rv;
}



static int remoteDispatchNWFilterGetXMLDesc(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_nwfilter_get_xml_desc_args *args,
    remote_nwfilter_get_xml_desc_ret *ret);
static int remoteDispatchNWFilterGetXMLDescHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNWFilterGetXMLDesc");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNWFilterGetXMLDesc(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNWFilterGetXMLDesc(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_nwfilter_get_xml_desc_args *args,
    remote_nwfilter_get_xml_desc_ret *ret)
{
    int rv = -1;
    virNWFilterPtr nwfilter = NULL;
    char *xml;

    virConnectPtr conn = remoteGetNWFilterConn(client);
    if (!conn)
        goto cleanup;

    if (!(nwfilter = get_nonnull_nwfilter(conn, args->nwfilter)))
        goto cleanup;

    if ((xml = virNWFilterGetXMLDesc(nwfilter, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(nwfilter);
    return rv;
}



static int remoteDispatchNWFilterLookupByName(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_nwfilter_lookup_by_name_args *args,
    remote_nwfilter_lookup_by_name_ret *ret);
static int remoteDispatchNWFilterLookupByNameHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNWFilterLookupByName");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNWFilterLookupByName(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNWFilterLookupByName(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_nwfilter_lookup_by_name_args *args,
    remote_nwfilter_lookup_by_name_ret *ret)
{
    int rv = -1;
    virNWFilterPtr nwfilter = NULL;

    virConnectPtr conn = remoteGetNWFilterConn(client);
    if (!conn)
        goto cleanup;

    if ((nwfilter = virNWFilterLookupByName(conn, args->name)) == NULL)
        goto cleanup;

    make_nonnull_nwfilter(&ret->nwfilter, nwfilter);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(nwfilter);
    return rv;
}



static int remoteDispatchNWFilterLookupByUUID(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_nwfilter_lookup_by_uuid_args *args,
    remote_nwfilter_lookup_by_uuid_ret *ret);
static int remoteDispatchNWFilterLookupByUUIDHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNWFilterLookupByUUID");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNWFilterLookupByUUID(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNWFilterLookupByUUID(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_nwfilter_lookup_by_uuid_args *args,
    remote_nwfilter_lookup_by_uuid_ret *ret)
{
    int rv = -1;
    virNWFilterPtr nwfilter = NULL;

    virConnectPtr conn = remoteGetNWFilterConn(client);
    if (!conn)
        goto cleanup;

    if ((nwfilter = virNWFilterLookupByUUID(conn, (unsigned char *) args->uuid)) == NULL)
        goto cleanup;

    make_nonnull_nwfilter(&ret->nwfilter, nwfilter);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(nwfilter);
    return rv;
}



static int remoteDispatchNWFilterUndefine(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_nwfilter_undefine_args *args);
static int remoteDispatchNWFilterUndefineHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchNWFilterUndefine");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNWFilterUndefine(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNWFilterUndefine(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_nwfilter_undefine_args *args)
{
    int rv = -1;
    virNWFilterPtr nwfilter = NULL;

    virConnectPtr conn = remoteGetNWFilterConn(client);
    if (!conn)
        goto cleanup;

    if (!(nwfilter = get_nonnull_nwfilter(conn, args->nwfilter)))
        goto cleanup;

    if (virNWFilterUndefine(nwfilter) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(nwfilter);
    return rv;
}



static int remoteDispatchSecretDefineXML(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_secret_define_xml_args *args,
    remote_secret_define_xml_ret *ret);
static int remoteDispatchSecretDefineXMLHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchSecretDefineXML");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchSecretDefineXML(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchSecretDefineXML(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_secret_define_xml_args *args,
    remote_secret_define_xml_ret *ret)
{
    int rv = -1;
    virSecretPtr secret = NULL;

    virConnectPtr conn = remoteGetSecretConn(client);
    if (!conn)
        goto cleanup;

    if ((secret = virSecretDefineXML(conn, args->xml, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_secret(&ret->secret, secret);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(secret);
    return rv;
}



static int remoteDispatchSecretGetValue(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_secret_get_value_args *args,
    remote_secret_get_value_ret *ret);
static int remoteDispatchSecretGetValueHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchSecretGetValue");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchSecretGetValue(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchSecretGetValue body has to be implemented manually */



static int remoteDispatchSecretGetXMLDesc(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_secret_get_xml_desc_args *args,
    remote_secret_get_xml_desc_ret *ret);
static int remoteDispatchSecretGetXMLDescHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchSecretGetXMLDesc");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchSecretGetXMLDesc(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchSecretGetXMLDesc(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_secret_get_xml_desc_args *args,
    remote_secret_get_xml_desc_ret *ret)
{
    int rv = -1;
    virSecretPtr secret = NULL;
    char *xml;

    virConnectPtr conn = remoteGetSecretConn(client);
    if (!conn)
        goto cleanup;

    if (!(secret = get_nonnull_secret(conn, args->secret)))
        goto cleanup;

    if ((xml = virSecretGetXMLDesc(secret, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(secret);
    return rv;
}



static int remoteDispatchSecretLookupByUsage(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_secret_lookup_by_usage_args *args,
    remote_secret_lookup_by_usage_ret *ret);
static int remoteDispatchSecretLookupByUsageHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchSecretLookupByUsage");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchSecretLookupByUsage(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchSecretLookupByUsage(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_secret_lookup_by_usage_args *args,
    remote_secret_lookup_by_usage_ret *ret)
{
    int rv = -1;
    virSecretPtr secret = NULL;

    virConnectPtr conn = remoteGetSecretConn(client);
    if (!conn)
        goto cleanup;

    if ((secret = virSecretLookupByUsage(conn, args->usageType, args->usageID)) == NULL)
        goto cleanup;

    make_nonnull_secret(&ret->secret, secret);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(secret);
    return rv;
}



static int remoteDispatchSecretLookupByUUID(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_secret_lookup_by_uuid_args *args,
    remote_secret_lookup_by_uuid_ret *ret);
static int remoteDispatchSecretLookupByUUIDHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchSecretLookupByUUID");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchSecretLookupByUUID(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchSecretLookupByUUID(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_secret_lookup_by_uuid_args *args,
    remote_secret_lookup_by_uuid_ret *ret)
{
    int rv = -1;
    virSecretPtr secret = NULL;

    virConnectPtr conn = remoteGetSecretConn(client);
    if (!conn)
        goto cleanup;

    if ((secret = virSecretLookupByUUID(conn, (unsigned char *) args->uuid)) == NULL)
        goto cleanup;

    make_nonnull_secret(&ret->secret, secret);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(secret);
    return rv;
}



static int remoteDispatchSecretSetValue(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_secret_set_value_args *args);
static int remoteDispatchSecretSetValueHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchSecretSetValue");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchSecretSetValue(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchSecretSetValue(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_secret_set_value_args *args)
{
    int rv = -1;
    virSecretPtr secret = NULL;

    virConnectPtr conn = remoteGetSecretConn(client);
    if (!conn)
        goto cleanup;

    if (!(secret = get_nonnull_secret(conn, args->secret)))
        goto cleanup;

    if (virSecretSetValue(secret, (const unsigned char *) args->value.value_val, args->value.value_len, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(secret);
    return rv;
}



static int remoteDispatchSecretUndefine(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_secret_undefine_args *args);
static int remoteDispatchSecretUndefineHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchSecretUndefine");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchSecretUndefine(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchSecretUndefine(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_secret_undefine_args *args)
{
    int rv = -1;
    virSecretPtr secret = NULL;

    virConnectPtr conn = remoteGetSecretConn(client);
    if (!conn)
        goto cleanup;

    if (!(secret = get_nonnull_secret(conn, args->secret)))
        goto cleanup;

    if (virSecretUndefine(secret) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(secret);
    return rv;
}



static int remoteDispatchStoragePoolBuild(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_storage_pool_build_args *args);
static int remoteDispatchStoragePoolBuildHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchStoragePoolBuild");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStoragePoolBuild(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStoragePoolBuild(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_storage_pool_build_args *args)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;

    virConnectPtr conn = remoteGetStorageConn(client);
    if (!conn)
        goto cleanup;

    if (!(pool = get_nonnull_storage_pool(conn, args->pool)))
        goto cleanup;

    if (virStoragePoolBuild(pool, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(pool);
    return rv;
}



static int remoteDispatchStoragePoolCreate(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_storage_pool_create_args *args);
static int remoteDispatchStoragePoolCreateHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchStoragePoolCreate");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStoragePoolCreate(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStoragePoolCreate(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_storage_pool_create_args *args)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;

    virConnectPtr conn = remoteGetStorageConn(client);
    if (!conn)
        goto cleanup;

    if (!(pool = get_nonnull_storage_pool(conn, args->pool)))
        goto cleanup;

    if (virStoragePoolCreate(pool, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(pool);
    return rv;
}



static int remoteDispatchStoragePoolCreateXML(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_storage_pool_create_xml_args *args,
    remote_storage_pool_create_xml_ret *ret);
static int remoteDispatchStoragePoolCreateXMLHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchStoragePoolCreateXML");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStoragePoolCreateXML(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStoragePoolCreateXML(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_storage_pool_create_xml_args *args,
    remote_storage_pool_create_xml_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;

    virConnectPtr conn = remoteGetStorageConn(client);
    if (!conn)
        goto cleanup;

    if ((pool = virStoragePoolCreateXML(conn, args->xml, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_storage_pool(&ret->pool, pool);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(pool);
    return rv;
}



static int remoteDispatchStoragePoolDefineXML(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_storage_pool_define_xml_args *args,
    remote_storage_pool_define_xml_ret *ret);
static int remoteDispatchStoragePoolDefineXMLHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchStoragePoolDefineXML");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStoragePoolDefineXML(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStoragePoolDefineXML(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_storage_pool_define_xml_args *args,
    remote_storage_pool_define_xml_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;

    virConnectPtr conn = remoteGetStorageConn(client);
    if (!conn)
        goto cleanup;

    if ((pool = virStoragePoolDefineXML(conn, args->xml, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_storage_pool(&ret->pool, pool);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(pool);
    return rv;
}



static int remoteDispatchStoragePoolDelete(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_storage_pool_delete_args *args);
static int remoteDispatchStoragePoolDeleteHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchStoragePoolDelete");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStoragePoolDelete(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStoragePoolDelete(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_storage_pool_delete_args *args)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;

    virConnectPtr conn = remoteGetStorageConn(client);
    if (!conn)
        goto cleanup;

    if (!(pool = get_nonnull_storage_pool(conn, args->pool)))
        goto cleanup;

    if (virStoragePoolDelete(pool, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(pool);
    return rv;
}



static int remoteDispatchStoragePoolDestroy(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_storage_pool_destroy_args *args);
static int remoteDispatchStoragePoolDestroyHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchStoragePoolDestroy");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStoragePoolDestroy(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStoragePoolDestroy(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_storage_pool_destroy_args *args)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;

    virConnectPtr conn = remoteGetStorageConn(client);
    if (!conn)
        goto cleanup;

    if (!(pool = get_nonnull_storage_pool(conn, args->pool)))
        goto cleanup;

    if (virStoragePoolDestroy(pool) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(pool);
    return rv;
}



static int remoteDispatchStoragePoolGetAutostart(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_storage_pool_get_autostart_args *args,
    remote_storage_pool_get_autostart_ret *ret);
static int remoteDispatchStoragePoolGetAutostartHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchStoragePoolGetAutostart");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStoragePoolGetAutostart(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStoragePoolGetAutostart(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_storage_pool_get_autostart_args *args,
    remote_storage_pool_get_autostart_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    int autostart;

    virConnectPtr conn = remoteGetStorageConn(client);
    if (!conn)
        goto cleanup;

    if (!(pool = get_nonnull_storage_pool(conn, args->pool)))
        goto cleanup;

    if (virStoragePoolGetAutostart(pool, &autostart) < 0)
        goto cleanup;

    ret->autostart = autostart;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(pool);
    return rv;
}



static int remoteDispatchStoragePoolGetInfo(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_storage_pool_get_info_args *args,
    remote_storage_pool_get_info_ret *ret);
static int remoteDispatchStoragePoolGetInfoHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchStoragePoolGetInfo");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStoragePoolGetInfo(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStoragePoolGetInfo(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_storage_pool_get_info_args *args,
    remote_storage_pool_get_info_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    virStoragePoolInfo tmp;

    virConnectPtr conn = remoteGetStorageConn(client);
    if (!conn)
        goto cleanup;

    if (!(pool = get_nonnull_storage_pool(conn, args->pool)))
        goto cleanup;

    if (virStoragePoolGetInfo(pool, &tmp) < 0)
        goto cleanup;

    ret->state = tmp.state;
    ret->capacity = tmp.capacity;
    ret->allocation = tmp.allocation;
    ret->available = tmp.available;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(pool);
    return rv;
}



static int remoteDispatchStoragePoolGetXMLDesc(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_storage_pool_get_xml_desc_args *args,
    remote_storage_pool_get_xml_desc_ret *ret);
static int remoteDispatchStoragePoolGetXMLDescHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchStoragePoolGetXMLDesc");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStoragePoolGetXMLDesc(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStoragePoolGetXMLDesc(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_storage_pool_get_xml_desc_args *args,
    remote_storage_pool_get_xml_desc_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    char *xml;

    virConnectPtr conn = remoteGetStorageConn(client);
    if (!conn)
        goto cleanup;

    if (!(pool = get_nonnull_storage_pool(conn, args->pool)))
        goto cleanup;

    if ((xml = virStoragePoolGetXMLDesc(pool, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(pool);
    return rv;
}



static int remoteDispatchStoragePoolIsActive(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_storage_pool_is_active_args *args,
    remote_storage_pool_is_active_ret *ret);
static int remoteDispatchStoragePoolIsActiveHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchStoragePoolIsActive");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStoragePoolIsActive(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStoragePoolIsActive(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_storage_pool_is_active_args *args,
    remote_storage_pool_is_active_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    int active;

    virConnectPtr conn = remoteGetStorageConn(client);
    if (!conn)
        goto cleanup;

    if (!(pool = get_nonnull_storage_pool(conn, args->pool)))
        goto cleanup;

    if ((active = virStoragePoolIsActive(pool)) < 0)
        goto cleanup;

    ret->active = active;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(pool);
    return rv;
}



static int remoteDispatchStoragePoolIsPersistent(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_storage_pool_is_persistent_args *args,
    remote_storage_pool_is_persistent_ret *ret);
static int remoteDispatchStoragePoolIsPersistentHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchStoragePoolIsPersistent");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStoragePoolIsPersistent(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStoragePoolIsPersistent(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_storage_pool_is_persistent_args *args,
    remote_storage_pool_is_persistent_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    int persistent;

    virConnectPtr conn = remoteGetStorageConn(client);
    if (!conn)
        goto cleanup;

    if (!(pool = get_nonnull_storage_pool(conn, args->pool)))
        goto cleanup;

    if ((persistent = virStoragePoolIsPersistent(pool)) < 0)
        goto cleanup;

    ret->persistent = persistent;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(pool);
    return rv;
}



static int remoteDispatchStoragePoolListAllVolumes(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_storage_pool_list_all_volumes_args *args,
    remote_storage_pool_list_all_volumes_ret *ret);
static int remoteDispatchStoragePoolListAllVolumesHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchStoragePoolListAllVolumes");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStoragePoolListAllVolumes(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStoragePoolListAllVolumes(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_storage_pool_list_all_volumes_args *args,
    remote_storage_pool_list_all_volumes_ret *ret)
{
    int rv = -1;
    ssize_t i;
    virStoragePoolPtr pool = NULL;
    virStorageVol **result = NULL;
    int nresults = 0;

    virConnectPtr conn = remoteGetStorageConn(client);
    if (!conn)
        goto cleanup;

    if (!(pool = get_nonnull_storage_pool(conn, args->pool)))
        goto cleanup;

    if ((nresults =
            virStoragePoolListAllVolumes(pool,
                                         args->need_results ? &result : NULL,
                                         args->flags)) < 0)
        goto cleanup;

    if (nresults > REMOTE_STORAGE_VOL_LIST_MAX) {
        virReportError(VIR_ERR_INTERNAL_ERROR,
                       _("Too many storage_vols '%1$d' for limit '%2$d'"),
                       nresults, REMOTE_STORAGE_VOL_LIST_MAX);
        goto cleanup;
    }

    if (result && nresults) {
        ret->vols.vols_val =
            g_new0(typeof(*ret->vols.vols_val), nresults);

        ret->vols.vols_len = nresults;
        for (i = 0; i < nresults; i++)
            make_nonnull_storage_vol(ret->vols.vols_val + i, result[i]);
    } else {
        ret->vols.vols_len = 0;
        ret->vols.vols_val = NULL;
    }

    ret->ret = nresults;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(pool);
    if (result) {
        for (i = 0; i < nresults; i++)
            virObjectUnref(result[i]);
    }
    VIR_FREE(result);
    return rv;
}



static int remoteDispatchStoragePoolListVolumes(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_storage_pool_list_volumes_args *args,
    remote_storage_pool_list_volumes_ret *ret);
static int remoteDispatchStoragePoolListVolumesHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchStoragePoolListVolumes");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStoragePoolListVolumes(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStoragePoolListVolumes(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_storage_pool_list_volumes_args *args,
    remote_storage_pool_list_volumes_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    int len;

    virConnectPtr conn = remoteGetStorageConn(client);
    if (!conn)
        goto cleanup;

    if (args->maxnames < 0) {
        virReportError(VIR_ERR_RPC,
                       "%s", _("maxnames must be non-negative"));
        goto cleanup;
    }
    if (args->maxnames > REMOTE_STORAGE_VOL_LIST_MAX) {
        virReportError(VIR_ERR_RPC,
                       "%s", _("maxnames > REMOTE_STORAGE_VOL_LIST_MAX"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(conn, args->pool)))
        goto cleanup;

    /* Allocate return buffer. */
    ret->names.names_val =
        g_new0(typeof(*ret->names.names_val), args->maxnames);

    if ((len = virStoragePoolListVolumes(pool, ret->names.names_val, args->maxnames)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    virObjectUnref(pool);
    return rv;
}



static int remoteDispatchStoragePoolLookupByName(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_storage_pool_lookup_by_name_args *args,
    remote_storage_pool_lookup_by_name_ret *ret);
static int remoteDispatchStoragePoolLookupByNameHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchStoragePoolLookupByName");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStoragePoolLookupByName(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStoragePoolLookupByName(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_storage_pool_lookup_by_name_args *args,
    remote_storage_pool_lookup_by_name_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;

    virConnectPtr conn = remoteGetStorageConn(client);
    if (!conn)
        goto cleanup;

    if ((pool = virStoragePoolLookupByName(conn, args->name)) == NULL)
        goto cleanup;

    make_nonnull_storage_pool(&ret->pool, pool);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(pool);
    return rv;
}



static int remoteDispatchStoragePoolLookupByTargetPath(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_storage_pool_lookup_by_target_path_args *args,
    remote_storage_pool_lookup_by_target_path_ret *ret);
static int remoteDispatchStoragePoolLookupByTargetPathHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchStoragePoolLookupByTargetPath");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStoragePoolLookupByTargetPath(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStoragePoolLookupByTargetPath(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_storage_pool_lookup_by_target_path_args *args,
    remote_storage_pool_lookup_by_target_path_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;

    virConnectPtr conn = remoteGetStorageConn(client);
    if (!conn)
        goto cleanup;

    if ((pool = virStoragePoolLookupByTargetPath(conn, args->path)) == NULL)
        goto cleanup;

    make_nonnull_storage_pool(&ret->pool, pool);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(pool);
    return rv;
}



static int remoteDispatchStoragePoolLookupByUUID(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_storage_pool_lookup_by_uuid_args *args,
    remote_storage_pool_lookup_by_uuid_ret *ret);
static int remoteDispatchStoragePoolLookupByUUIDHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchStoragePoolLookupByUUID");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStoragePoolLookupByUUID(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStoragePoolLookupByUUID(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_storage_pool_lookup_by_uuid_args *args,
    remote_storage_pool_lookup_by_uuid_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;

    virConnectPtr conn = remoteGetStorageConn(client);
    if (!conn)
        goto cleanup;

    if ((pool = virStoragePoolLookupByUUID(conn, (unsigned char *) args->uuid)) == NULL)
        goto cleanup;

    make_nonnull_storage_pool(&ret->pool, pool);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(pool);
    return rv;
}



static int remoteDispatchStoragePoolLookupByVolume(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_storage_pool_lookup_by_volume_args *args,
    remote_storage_pool_lookup_by_volume_ret *ret);
static int remoteDispatchStoragePoolLookupByVolumeHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchStoragePoolLookupByVolume");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStoragePoolLookupByVolume(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStoragePoolLookupByVolume(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_storage_pool_lookup_by_volume_args *args,
    remote_storage_pool_lookup_by_volume_ret *ret)
{
    int rv = -1;
    virStorageVolPtr vol = NULL;
    virStoragePoolPtr pool = NULL;

    virConnectPtr conn = remoteGetStorageConn(client);
    if (!conn)
        goto cleanup;

    if (!(vol = get_nonnull_storage_vol(conn, args->vol)))
        goto cleanup;

    if ((pool = virStoragePoolLookupByVolume(vol)) == NULL)
        goto cleanup;

    make_nonnull_storage_pool(&ret->pool, pool);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(vol);
    virObjectUnref(pool);
    return rv;
}



static int remoteDispatchStoragePoolNumOfVolumes(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_storage_pool_num_of_volumes_args *args,
    remote_storage_pool_num_of_volumes_ret *ret);
static int remoteDispatchStoragePoolNumOfVolumesHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchStoragePoolNumOfVolumes");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStoragePoolNumOfVolumes(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStoragePoolNumOfVolumes(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_storage_pool_num_of_volumes_args *args,
    remote_storage_pool_num_of_volumes_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    int num;

    virConnectPtr conn = remoteGetStorageConn(client);
    if (!conn)
        goto cleanup;

    if (!(pool = get_nonnull_storage_pool(conn, args->pool)))
        goto cleanup;

    if ((num = virStoragePoolNumOfVolumes(pool)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(pool);
    return rv;
}



static int remoteDispatchStoragePoolRefresh(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_storage_pool_refresh_args *args);
static int remoteDispatchStoragePoolRefreshHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchStoragePoolRefresh");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStoragePoolRefresh(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStoragePoolRefresh(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_storage_pool_refresh_args *args)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;

    virConnectPtr conn = remoteGetStorageConn(client);
    if (!conn)
        goto cleanup;

    if (!(pool = get_nonnull_storage_pool(conn, args->pool)))
        goto cleanup;

    if (virStoragePoolRefresh(pool, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(pool);
    return rv;
}



static int remoteDispatchStoragePoolSetAutostart(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_storage_pool_set_autostart_args *args);
static int remoteDispatchStoragePoolSetAutostartHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchStoragePoolSetAutostart");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStoragePoolSetAutostart(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStoragePoolSetAutostart(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_storage_pool_set_autostart_args *args)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;

    virConnectPtr conn = remoteGetStorageConn(client);
    if (!conn)
        goto cleanup;

    if (!(pool = get_nonnull_storage_pool(conn, args->pool)))
        goto cleanup;

    if (virStoragePoolSetAutostart(pool, args->autostart) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(pool);
    return rv;
}



static int remoteDispatchStoragePoolUndefine(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_storage_pool_undefine_args *args);
static int remoteDispatchStoragePoolUndefineHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchStoragePoolUndefine");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStoragePoolUndefine(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStoragePoolUndefine(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_storage_pool_undefine_args *args)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;

    virConnectPtr conn = remoteGetStorageConn(client);
    if (!conn)
        goto cleanup;

    if (!(pool = get_nonnull_storage_pool(conn, args->pool)))
        goto cleanup;

    if (virStoragePoolUndefine(pool) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(pool);
    return rv;
}



static int remoteDispatchStorageVolCreateXML(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_storage_vol_create_xml_args *args,
    remote_storage_vol_create_xml_ret *ret);
static int remoteDispatchStorageVolCreateXMLHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchStorageVolCreateXML");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStorageVolCreateXML(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStorageVolCreateXML(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_storage_vol_create_xml_args *args,
    remote_storage_vol_create_xml_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    virStorageVolPtr vol = NULL;

    virConnectPtr conn = remoteGetStorageConn(client);
    if (!conn)
        goto cleanup;

    if (!(pool = get_nonnull_storage_pool(conn, args->pool)))
        goto cleanup;

    if ((vol = virStorageVolCreateXML(pool, args->xml, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_storage_vol(&ret->vol, vol);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(pool);
    virObjectUnref(vol);
    return rv;
}



static int remoteDispatchStorageVolCreateXMLFrom(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_storage_vol_create_xml_from_args *args,
    remote_storage_vol_create_xml_from_ret *ret);
static int remoteDispatchStorageVolCreateXMLFromHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchStorageVolCreateXMLFrom");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStorageVolCreateXMLFrom(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStorageVolCreateXMLFrom(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_storage_vol_create_xml_from_args *args,
    remote_storage_vol_create_xml_from_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    virStorageVolPtr clonevol = NULL;
    virStorageVolPtr vol = NULL;

    virConnectPtr conn = remoteGetStorageConn(client);
    if (!conn)
        goto cleanup;

    if (!(pool = get_nonnull_storage_pool(conn, args->pool)))
        goto cleanup;

    if (!(clonevol = get_nonnull_storage_vol(conn, args->clonevol)))
        goto cleanup;

    if ((vol = virStorageVolCreateXMLFrom(pool, args->xml, clonevol, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_storage_vol(&ret->vol, vol);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(pool);
    virObjectUnref(clonevol);
    virObjectUnref(vol);
    return rv;
}



static int remoteDispatchStorageVolDelete(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_storage_vol_delete_args *args);
static int remoteDispatchStorageVolDeleteHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchStorageVolDelete");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStorageVolDelete(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStorageVolDelete(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_storage_vol_delete_args *args)
{
    int rv = -1;
    virStorageVolPtr vol = NULL;

    virConnectPtr conn = remoteGetStorageConn(client);
    if (!conn)
        goto cleanup;

    if (!(vol = get_nonnull_storage_vol(conn, args->vol)))
        goto cleanup;

    if (virStorageVolDelete(vol, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(vol);
    return rv;
}



static int remoteDispatchStorageVolDownload(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_storage_vol_download_args *args);
static int remoteDispatchStorageVolDownloadHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchStorageVolDownload");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStorageVolDownload(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStorageVolDownload(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_storage_vol_download_args *args)
{
    int rv = -1;
    virStorageVolPtr vol = NULL;
    virStreamPtr st = NULL;
    daemonClientStream *stream = NULL;
    const bool sparse = args->flags & VIR_STORAGE_VOL_DOWNLOAD_SPARSE_STREAM;

    virConnectPtr conn = remoteGetStorageConn(client);
    if (!conn)
        goto cleanup;

    if (!(vol = get_nonnull_storage_vol(conn, args->vol)))
        goto cleanup;

    if (!(st = virStreamNew(conn, VIR_STREAM_NONBLOCK)))
        goto cleanup;

    if (!(stream = daemonCreateClientStream(client, st, remoteProgram, &msg->header, sparse)))
        goto cleanup;

    if (virStorageVolDownload(vol, st, args->offset, args->length, args->flags) < 0)
        goto cleanup;

    if (daemonAddClientStream(client, stream, true) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        if (stream) {
            virStreamAbort(st);
            daemonFreeClientStream(client, stream);
        } else {
            virObjectUnref(st);
        }
    }
    virObjectUnref(vol);
    return rv;
}



static int remoteDispatchStorageVolGetInfo(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_storage_vol_get_info_args *args,
    remote_storage_vol_get_info_ret *ret);
static int remoteDispatchStorageVolGetInfoHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchStorageVolGetInfo");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStorageVolGetInfo(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStorageVolGetInfo(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_storage_vol_get_info_args *args,
    remote_storage_vol_get_info_ret *ret)
{
    int rv = -1;
    virStorageVolPtr vol = NULL;
    virStorageVolInfo tmp;

    virConnectPtr conn = remoteGetStorageConn(client);
    if (!conn)
        goto cleanup;

    if (!(vol = get_nonnull_storage_vol(conn, args->vol)))
        goto cleanup;

    if (virStorageVolGetInfo(vol, &tmp) < 0)
        goto cleanup;

    ret->type = tmp.type;
    ret->capacity = tmp.capacity;
    ret->allocation = tmp.allocation;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(vol);
    return rv;
}



static int remoteDispatchStorageVolGetInfoFlags(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_storage_vol_get_info_flags_args *args,
    remote_storage_vol_get_info_flags_ret *ret);
static int remoteDispatchStorageVolGetInfoFlagsHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchStorageVolGetInfoFlags");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStorageVolGetInfoFlags(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStorageVolGetInfoFlags(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_storage_vol_get_info_flags_args *args,
    remote_storage_vol_get_info_flags_ret *ret)
{
    int rv = -1;
    virStorageVolPtr vol = NULL;
    virStorageVolInfo tmp;

    virConnectPtr conn = remoteGetStorageConn(client);
    if (!conn)
        goto cleanup;

    if (!(vol = get_nonnull_storage_vol(conn, args->vol)))
        goto cleanup;

    if (virStorageVolGetInfoFlags(vol, &tmp, args->flags) < 0)
        goto cleanup;

    ret->type = tmp.type;
    ret->capacity = tmp.capacity;
    ret->allocation = tmp.allocation;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(vol);
    return rv;
}



static int remoteDispatchStorageVolGetPath(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_storage_vol_get_path_args *args,
    remote_storage_vol_get_path_ret *ret);
static int remoteDispatchStorageVolGetPathHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchStorageVolGetPath");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStorageVolGetPath(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStorageVolGetPath(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_storage_vol_get_path_args *args,
    remote_storage_vol_get_path_ret *ret)
{
    int rv = -1;
    virStorageVolPtr vol = NULL;
    char *name;

    virConnectPtr conn = remoteGetStorageConn(client);
    if (!conn)
        goto cleanup;

    if (!(vol = get_nonnull_storage_vol(conn, args->vol)))
        goto cleanup;

    if ((name = virStorageVolGetPath(vol)) == NULL)
        goto cleanup;

    ret->name = name;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(vol);
    return rv;
}



static int remoteDispatchStorageVolGetXMLDesc(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_storage_vol_get_xml_desc_args *args,
    remote_storage_vol_get_xml_desc_ret *ret);
static int remoteDispatchStorageVolGetXMLDescHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchStorageVolGetXMLDesc");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStorageVolGetXMLDesc(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStorageVolGetXMLDesc(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_storage_vol_get_xml_desc_args *args,
    remote_storage_vol_get_xml_desc_ret *ret)
{
    int rv = -1;
    virStorageVolPtr vol = NULL;
    char *xml;

    virConnectPtr conn = remoteGetStorageConn(client);
    if (!conn)
        goto cleanup;

    if (!(vol = get_nonnull_storage_vol(conn, args->vol)))
        goto cleanup;

    if ((xml = virStorageVolGetXMLDesc(vol, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(vol);
    return rv;
}



static int remoteDispatchStorageVolLookupByKey(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_storage_vol_lookup_by_key_args *args,
    remote_storage_vol_lookup_by_key_ret *ret);
static int remoteDispatchStorageVolLookupByKeyHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchStorageVolLookupByKey");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStorageVolLookupByKey(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStorageVolLookupByKey(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_storage_vol_lookup_by_key_args *args,
    remote_storage_vol_lookup_by_key_ret *ret)
{
    int rv = -1;
    virStorageVolPtr vol = NULL;

    virConnectPtr conn = remoteGetStorageConn(client);
    if (!conn)
        goto cleanup;

    if ((vol = virStorageVolLookupByKey(conn, args->key)) == NULL)
        goto cleanup;

    make_nonnull_storage_vol(&ret->vol, vol);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(vol);
    return rv;
}



static int remoteDispatchStorageVolLookupByName(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_storage_vol_lookup_by_name_args *args,
    remote_storage_vol_lookup_by_name_ret *ret);
static int remoteDispatchStorageVolLookupByNameHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchStorageVolLookupByName");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStorageVolLookupByName(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStorageVolLookupByName(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_storage_vol_lookup_by_name_args *args,
    remote_storage_vol_lookup_by_name_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    virStorageVolPtr vol = NULL;

    virConnectPtr conn = remoteGetStorageConn(client);
    if (!conn)
        goto cleanup;

    if (!(pool = get_nonnull_storage_pool(conn, args->pool)))
        goto cleanup;

    if ((vol = virStorageVolLookupByName(pool, args->name)) == NULL)
        goto cleanup;

    make_nonnull_storage_vol(&ret->vol, vol);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(pool);
    virObjectUnref(vol);
    return rv;
}



static int remoteDispatchStorageVolLookupByPath(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_storage_vol_lookup_by_path_args *args,
    remote_storage_vol_lookup_by_path_ret *ret);
static int remoteDispatchStorageVolLookupByPathHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchStorageVolLookupByPath");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStorageVolLookupByPath(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStorageVolLookupByPath(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_storage_vol_lookup_by_path_args *args,
    remote_storage_vol_lookup_by_path_ret *ret)
{
    int rv = -1;
    virStorageVolPtr vol = NULL;

    virConnectPtr conn = remoteGetStorageConn(client);
    if (!conn)
        goto cleanup;

    if ((vol = virStorageVolLookupByPath(conn, args->path)) == NULL)
        goto cleanup;

    make_nonnull_storage_vol(&ret->vol, vol);

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(vol);
    return rv;
}



static int remoteDispatchStorageVolResize(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_storage_vol_resize_args *args);
static int remoteDispatchStorageVolResizeHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchStorageVolResize");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStorageVolResize(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStorageVolResize(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_storage_vol_resize_args *args)
{
    int rv = -1;
    virStorageVolPtr vol = NULL;

    virConnectPtr conn = remoteGetStorageConn(client);
    if (!conn)
        goto cleanup;

    if (!(vol = get_nonnull_storage_vol(conn, args->vol)))
        goto cleanup;

    if (virStorageVolResize(vol, args->capacity, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(vol);
    return rv;
}



static int remoteDispatchStorageVolUpload(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_storage_vol_upload_args *args);
static int remoteDispatchStorageVolUploadHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchStorageVolUpload");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStorageVolUpload(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStorageVolUpload(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_storage_vol_upload_args *args)
{
    int rv = -1;
    virStorageVolPtr vol = NULL;
    virStreamPtr st = NULL;
    daemonClientStream *stream = NULL;
    const bool sparse = args->flags & VIR_STORAGE_VOL_UPLOAD_SPARSE_STREAM;

    virConnectPtr conn = remoteGetStorageConn(client);
    if (!conn)
        goto cleanup;

    if (!(vol = get_nonnull_storage_vol(conn, args->vol)))
        goto cleanup;

    if (!(st = virStreamNew(conn, VIR_STREAM_NONBLOCK)))
        goto cleanup;

    if (!(stream = daemonCreateClientStream(client, st, remoteProgram, &msg->header, sparse)))
        goto cleanup;

    if (virStorageVolUpload(vol, st, args->offset, args->length, args->flags) < 0)
        goto cleanup;

    if (daemonAddClientStream(client, stream, false) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        if (stream) {
            virStreamAbort(st);
            daemonFreeClientStream(client, stream);
        } else {
            virObjectUnref(st);
        }
    }
    virObjectUnref(vol);
    return rv;
}



static int remoteDispatchStorageVolWipe(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_storage_vol_wipe_args *args);
static int remoteDispatchStorageVolWipeHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchStorageVolWipe");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStorageVolWipe(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStorageVolWipe(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_storage_vol_wipe_args *args)
{
    int rv = -1;
    virStorageVolPtr vol = NULL;

    virConnectPtr conn = remoteGetStorageConn(client);
    if (!conn)
        goto cleanup;

    if (!(vol = get_nonnull_storage_vol(conn, args->vol)))
        goto cleanup;

    if (virStorageVolWipe(vol, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(vol);
    return rv;
}



static int remoteDispatchStorageVolWipePattern(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    remote_storage_vol_wipe_pattern_args *args);
static int remoteDispatchStorageVolWipePatternHelper(
    virNetServer *server,
    virNetServerClient *client,
    virNetMessage *msg,
    struct virNetMessageError *rerr,
    void *args,
    void *ret G_GNUC_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchStorageVolWipePattern");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStorageVolWipePattern(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStorageVolWipePattern(
    virNetServer *server G_GNUC_UNUSED,
    virNetServerClient *client,
    virNetMessage *msg G_GNUC_UNUSED,
    struct virNetMessageError *rerr,
    remote_storage_vol_wipe_pattern_args *args)
{
    int rv = -1;
    virStorageVolPtr vol = NULL;

    virConnectPtr conn = remoteGetStorageConn(client);
    if (!conn)
        goto cleanup;

    if (!(vol = get_nonnull_storage_vol(conn, args->vol)))
        goto cleanup;

    if (virStorageVolWipePattern(vol, args->algorithm, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(vol);
    return rv;
}



virNetServerProgramProc remoteProcs[] = {
{ /* Unused 0 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method ConnectOpen => 1 */
   remoteDispatchConnectOpenHelper,
   sizeof(remote_connect_open_args),
   (xdrproc_t)xdr_remote_connect_open_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method ConnectClose => 2 */
   remoteDispatchConnectCloseHelper,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method ConnectGetType => 3 */
   remoteDispatchConnectGetTypeHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_connect_get_type_ret),
   (xdrproc_t)xdr_remote_connect_get_type_ret,
   true,
   1
},
{ /* Method ConnectGetVersion => 4 */
   remoteDispatchConnectGetVersionHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_connect_get_version_ret),
   (xdrproc_t)xdr_remote_connect_get_version_ret,
   true,
   1
},
{ /* Method ConnectGetMaxVcpus => 5 */
   remoteDispatchConnectGetMaxVcpusHelper,
   sizeof(remote_connect_get_max_vcpus_args),
   (xdrproc_t)xdr_remote_connect_get_max_vcpus_args,
   sizeof(remote_connect_get_max_vcpus_ret),
   (xdrproc_t)xdr_remote_connect_get_max_vcpus_ret,
   true,
   1
},
{ /* Method NodeGetInfo => 6 */
   remoteDispatchNodeGetInfoHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_node_get_info_ret),
   (xdrproc_t)xdr_remote_node_get_info_ret,
   true,
   1
},
{ /* Method ConnectGetCapabilities => 7 */
   remoteDispatchConnectGetCapabilitiesHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_connect_get_capabilities_ret),
   (xdrproc_t)xdr_remote_connect_get_capabilities_ret,
   true,
   0
},
{ /* Method DomainAttachDevice => 8 */
   remoteDispatchDomainAttachDeviceHelper,
   sizeof(remote_domain_attach_device_args),
   (xdrproc_t)xdr_remote_domain_attach_device_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainCreate => 9 */
   remoteDispatchDomainCreateHelper,
   sizeof(remote_domain_create_args),
   (xdrproc_t)xdr_remote_domain_create_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainCreateXML => 10 */
   remoteDispatchDomainCreateXMLHelper,
   sizeof(remote_domain_create_xml_args),
   (xdrproc_t)xdr_remote_domain_create_xml_args,
   sizeof(remote_domain_create_xml_ret),
   (xdrproc_t)xdr_remote_domain_create_xml_ret,
   true,
   0
},
{ /* Method DomainDefineXML => 11 */
   remoteDispatchDomainDefineXMLHelper,
   sizeof(remote_domain_define_xml_args),
   (xdrproc_t)xdr_remote_domain_define_xml_args,
   sizeof(remote_domain_define_xml_ret),
   (xdrproc_t)xdr_remote_domain_define_xml_ret,
   true,
   1
},
{ /* Method DomainDestroy => 12 */
   remoteDispatchDomainDestroyHelper,
   sizeof(remote_domain_destroy_args),
   (xdrproc_t)xdr_remote_domain_destroy_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method DomainDetachDevice => 13 */
   remoteDispatchDomainDetachDeviceHelper,
   sizeof(remote_domain_detach_device_args),
   (xdrproc_t)xdr_remote_domain_detach_device_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainGetXMLDesc => 14 */
   remoteDispatchDomainGetXMLDescHelper,
   sizeof(remote_domain_get_xml_desc_args),
   (xdrproc_t)xdr_remote_domain_get_xml_desc_args,
   sizeof(remote_domain_get_xml_desc_ret),
   (xdrproc_t)xdr_remote_domain_get_xml_desc_ret,
   true,
   0
},
{ /* Method DomainGetAutostart => 15 */
   remoteDispatchDomainGetAutostartHelper,
   sizeof(remote_domain_get_autostart_args),
   (xdrproc_t)xdr_remote_domain_get_autostart_args,
   sizeof(remote_domain_get_autostart_ret),
   (xdrproc_t)xdr_remote_domain_get_autostart_ret,
   true,
   1
},
{ /* Method DomainGetInfo => 16 */
   remoteDispatchDomainGetInfoHelper,
   sizeof(remote_domain_get_info_args),
   (xdrproc_t)xdr_remote_domain_get_info_args,
   sizeof(remote_domain_get_info_ret),
   (xdrproc_t)xdr_remote_domain_get_info_ret,
   true,
   0
},
{ /* Method DomainGetMaxMemory => 17 */
   remoteDispatchDomainGetMaxMemoryHelper,
   sizeof(remote_domain_get_max_memory_args),
   (xdrproc_t)xdr_remote_domain_get_max_memory_args,
   sizeof(remote_domain_get_max_memory_ret),
   (xdrproc_t)xdr_remote_domain_get_max_memory_ret,
   true,
   1
},
{ /* Method DomainGetMaxVcpus => 18 */
   remoteDispatchDomainGetMaxVcpusHelper,
   sizeof(remote_domain_get_max_vcpus_args),
   (xdrproc_t)xdr_remote_domain_get_max_vcpus_args,
   sizeof(remote_domain_get_max_vcpus_ret),
   (xdrproc_t)xdr_remote_domain_get_max_vcpus_ret,
   true,
   1
},
{ /* Method DomainGetOSType => 19 */
   remoteDispatchDomainGetOSTypeHelper,
   sizeof(remote_domain_get_os_type_args),
   (xdrproc_t)xdr_remote_domain_get_os_type_args,
   sizeof(remote_domain_get_os_type_ret),
   (xdrproc_t)xdr_remote_domain_get_os_type_ret,
   true,
   1
},
{ /* Method DomainGetVcpus => 20 */
   remoteDispatchDomainGetVcpusHelper,
   sizeof(remote_domain_get_vcpus_args),
   (xdrproc_t)xdr_remote_domain_get_vcpus_args,
   sizeof(remote_domain_get_vcpus_ret),
   (xdrproc_t)xdr_remote_domain_get_vcpus_ret,
   true,
   1
},
{ /* Method ConnectListDefinedDomains => 21 */
   remoteDispatchConnectListDefinedDomainsHelper,
   sizeof(remote_connect_list_defined_domains_args),
   (xdrproc_t)xdr_remote_connect_list_defined_domains_args,
   sizeof(remote_connect_list_defined_domains_ret),
   (xdrproc_t)xdr_remote_connect_list_defined_domains_ret,
   true,
   1
},
{ /* Method DomainLookupByID => 22 */
   remoteDispatchDomainLookupByIDHelper,
   sizeof(remote_domain_lookup_by_id_args),
   (xdrproc_t)xdr_remote_domain_lookup_by_id_args,
   sizeof(remote_domain_lookup_by_id_ret),
   (xdrproc_t)xdr_remote_domain_lookup_by_id_ret,
   true,
   1
},
{ /* Method DomainLookupByName => 23 */
   remoteDispatchDomainLookupByNameHelper,
   sizeof(remote_domain_lookup_by_name_args),
   (xdrproc_t)xdr_remote_domain_lookup_by_name_args,
   sizeof(remote_domain_lookup_by_name_ret),
   (xdrproc_t)xdr_remote_domain_lookup_by_name_ret,
   true,
   1
},
{ /* Method DomainLookupByUUID => 24 */
   remoteDispatchDomainLookupByUUIDHelper,
   sizeof(remote_domain_lookup_by_uuid_args),
   (xdrproc_t)xdr_remote_domain_lookup_by_uuid_args,
   sizeof(remote_domain_lookup_by_uuid_ret),
   (xdrproc_t)xdr_remote_domain_lookup_by_uuid_ret,
   true,
   1
},
{ /* Method ConnectNumOfDefinedDomains => 25 */
   remoteDispatchConnectNumOfDefinedDomainsHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_connect_num_of_defined_domains_ret),
   (xdrproc_t)xdr_remote_connect_num_of_defined_domains_ret,
   true,
   1
},
{ /* Method DomainPinVcpu => 26 */
   remoteDispatchDomainPinVcpuHelper,
   sizeof(remote_domain_pin_vcpu_args),
   (xdrproc_t)xdr_remote_domain_pin_vcpu_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainReboot => 27 */
   remoteDispatchDomainRebootHelper,
   sizeof(remote_domain_reboot_args),
   (xdrproc_t)xdr_remote_domain_reboot_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainResume => 28 */
   remoteDispatchDomainResumeHelper,
   sizeof(remote_domain_resume_args),
   (xdrproc_t)xdr_remote_domain_resume_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainSetAutostart => 29 */
   remoteDispatchDomainSetAutostartHelper,
   sizeof(remote_domain_set_autostart_args),
   (xdrproc_t)xdr_remote_domain_set_autostart_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method DomainSetMaxMemory => 30 */
   remoteDispatchDomainSetMaxMemoryHelper,
   sizeof(remote_domain_set_max_memory_args),
   (xdrproc_t)xdr_remote_domain_set_max_memory_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method DomainSetMemory => 31 */
   remoteDispatchDomainSetMemoryHelper,
   sizeof(remote_domain_set_memory_args),
   (xdrproc_t)xdr_remote_domain_set_memory_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainSetVcpus => 32 */
   remoteDispatchDomainSetVcpusHelper,
   sizeof(remote_domain_set_vcpus_args),
   (xdrproc_t)xdr_remote_domain_set_vcpus_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainShutdown => 33 */
   remoteDispatchDomainShutdownHelper,
   sizeof(remote_domain_shutdown_args),
   (xdrproc_t)xdr_remote_domain_shutdown_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainSuspend => 34 */
   remoteDispatchDomainSuspendHelper,
   sizeof(remote_domain_suspend_args),
   (xdrproc_t)xdr_remote_domain_suspend_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainUndefine => 35 */
   remoteDispatchDomainUndefineHelper,
   sizeof(remote_domain_undefine_args),
   (xdrproc_t)xdr_remote_domain_undefine_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method ConnectListDefinedNetworks => 36 */
   remoteDispatchConnectListDefinedNetworksHelper,
   sizeof(remote_connect_list_defined_networks_args),
   (xdrproc_t)xdr_remote_connect_list_defined_networks_args,
   sizeof(remote_connect_list_defined_networks_ret),
   (xdrproc_t)xdr_remote_connect_list_defined_networks_ret,
   true,
   1
},
{ /* Method ConnectListDomains => 37 */
   remoteDispatchConnectListDomainsHelper,
   sizeof(remote_connect_list_domains_args),
   (xdrproc_t)xdr_remote_connect_list_domains_args,
   sizeof(remote_connect_list_domains_ret),
   (xdrproc_t)xdr_remote_connect_list_domains_ret,
   true,
   1
},
{ /* Method ConnectListNetworks => 38 */
   remoteDispatchConnectListNetworksHelper,
   sizeof(remote_connect_list_networks_args),
   (xdrproc_t)xdr_remote_connect_list_networks_args,
   sizeof(remote_connect_list_networks_ret),
   (xdrproc_t)xdr_remote_connect_list_networks_ret,
   true,
   1
},
{ /* Method NetworkCreate => 39 */
   remoteDispatchNetworkCreateHelper,
   sizeof(remote_network_create_args),
   (xdrproc_t)xdr_remote_network_create_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method NetworkCreateXML => 40 */
   remoteDispatchNetworkCreateXMLHelper,
   sizeof(remote_network_create_xml_args),
   (xdrproc_t)xdr_remote_network_create_xml_args,
   sizeof(remote_network_create_xml_ret),
   (xdrproc_t)xdr_remote_network_create_xml_ret,
   true,
   0
},
{ /* Method NetworkDefineXML => 41 */
   remoteDispatchNetworkDefineXMLHelper,
   sizeof(remote_network_define_xml_args),
   (xdrproc_t)xdr_remote_network_define_xml_args,
   sizeof(remote_network_define_xml_ret),
   (xdrproc_t)xdr_remote_network_define_xml_ret,
   true,
   1
},
{ /* Method NetworkDestroy => 42 */
   remoteDispatchNetworkDestroyHelper,
   sizeof(remote_network_destroy_args),
   (xdrproc_t)xdr_remote_network_destroy_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method NetworkGetXMLDesc => 43 */
   remoteDispatchNetworkGetXMLDescHelper,
   sizeof(remote_network_get_xml_desc_args),
   (xdrproc_t)xdr_remote_network_get_xml_desc_args,
   sizeof(remote_network_get_xml_desc_ret),
   (xdrproc_t)xdr_remote_network_get_xml_desc_ret,
   true,
   1
},
{ /* Method NetworkGetAutostart => 44 */
   remoteDispatchNetworkGetAutostartHelper,
   sizeof(remote_network_get_autostart_args),
   (xdrproc_t)xdr_remote_network_get_autostart_args,
   sizeof(remote_network_get_autostart_ret),
   (xdrproc_t)xdr_remote_network_get_autostart_ret,
   true,
   1
},
{ /* Method NetworkGetBridgeName => 45 */
   remoteDispatchNetworkGetBridgeNameHelper,
   sizeof(remote_network_get_bridge_name_args),
   (xdrproc_t)xdr_remote_network_get_bridge_name_args,
   sizeof(remote_network_get_bridge_name_ret),
   (xdrproc_t)xdr_remote_network_get_bridge_name_ret,
   true,
   1
},
{ /* Method NetworkLookupByName => 46 */
   remoteDispatchNetworkLookupByNameHelper,
   sizeof(remote_network_lookup_by_name_args),
   (xdrproc_t)xdr_remote_network_lookup_by_name_args,
   sizeof(remote_network_lookup_by_name_ret),
   (xdrproc_t)xdr_remote_network_lookup_by_name_ret,
   true,
   1
},
{ /* Method NetworkLookupByUUID => 47 */
   remoteDispatchNetworkLookupByUUIDHelper,
   sizeof(remote_network_lookup_by_uuid_args),
   (xdrproc_t)xdr_remote_network_lookup_by_uuid_args,
   sizeof(remote_network_lookup_by_uuid_ret),
   (xdrproc_t)xdr_remote_network_lookup_by_uuid_ret,
   true,
   1
},
{ /* Method NetworkSetAutostart => 48 */
   remoteDispatchNetworkSetAutostartHelper,
   sizeof(remote_network_set_autostart_args),
   (xdrproc_t)xdr_remote_network_set_autostart_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method NetworkUndefine => 49 */
   remoteDispatchNetworkUndefineHelper,
   sizeof(remote_network_undefine_args),
   (xdrproc_t)xdr_remote_network_undefine_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method ConnectNumOfDefinedNetworks => 50 */
   remoteDispatchConnectNumOfDefinedNetworksHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_connect_num_of_defined_networks_ret),
   (xdrproc_t)xdr_remote_connect_num_of_defined_networks_ret,
   true,
   1
},
{ /* Method ConnectNumOfDomains => 51 */
   remoteDispatchConnectNumOfDomainsHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_connect_num_of_domains_ret),
   (xdrproc_t)xdr_remote_connect_num_of_domains_ret,
   true,
   1
},
{ /* Method ConnectNumOfNetworks => 52 */
   remoteDispatchConnectNumOfNetworksHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_connect_num_of_networks_ret),
   (xdrproc_t)xdr_remote_connect_num_of_networks_ret,
   true,
   1
},
{ /* Method DomainCoreDump => 53 */
   remoteDispatchDomainCoreDumpHelper,
   sizeof(remote_domain_core_dump_args),
   (xdrproc_t)xdr_remote_domain_core_dump_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainRestore => 54 */
   remoteDispatchDomainRestoreHelper,
   sizeof(remote_domain_restore_args),
   (xdrproc_t)xdr_remote_domain_restore_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainSave => 55 */
   remoteDispatchDomainSaveHelper,
   sizeof(remote_domain_save_args),
   (xdrproc_t)xdr_remote_domain_save_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainGetSchedulerType => 56 */
   remoteDispatchDomainGetSchedulerTypeHelper,
   sizeof(remote_domain_get_scheduler_type_args),
   (xdrproc_t)xdr_remote_domain_get_scheduler_type_args,
   sizeof(remote_domain_get_scheduler_type_ret),
   (xdrproc_t)xdr_remote_domain_get_scheduler_type_ret,
   true,
   0
},
{ /* Method DomainGetSchedulerParameters => 57 */
   remoteDispatchDomainGetSchedulerParametersHelper,
   sizeof(remote_domain_get_scheduler_parameters_args),
   (xdrproc_t)xdr_remote_domain_get_scheduler_parameters_args,
   sizeof(remote_domain_get_scheduler_parameters_ret),
   (xdrproc_t)xdr_remote_domain_get_scheduler_parameters_ret,
   true,
   0
},
{ /* Method DomainSetSchedulerParameters => 58 */
   remoteDispatchDomainSetSchedulerParametersHelper,
   sizeof(remote_domain_set_scheduler_parameters_args),
   (xdrproc_t)xdr_remote_domain_set_scheduler_parameters_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method ConnectGetHostname => 59 */
   remoteDispatchConnectGetHostnameHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_connect_get_hostname_ret),
   (xdrproc_t)xdr_remote_connect_get_hostname_ret,
   true,
   1
},
{ /* Method ConnectSupportsFeature => 60 */
   remoteDispatchConnectSupportsFeatureHelper,
   sizeof(remote_connect_supports_feature_args),
   (xdrproc_t)xdr_remote_connect_supports_feature_args,
   sizeof(remote_connect_supports_feature_ret),
   (xdrproc_t)xdr_remote_connect_supports_feature_ret,
   true,
   1
},
{ /* Method DomainMigratePrepare => 61 */
   remoteDispatchDomainMigratePrepareHelper,
   sizeof(remote_domain_migrate_prepare_args),
   (xdrproc_t)xdr_remote_domain_migrate_prepare_args,
   sizeof(remote_domain_migrate_prepare_ret),
   (xdrproc_t)xdr_remote_domain_migrate_prepare_ret,
   true,
   0
},
{ /* Method DomainMigratePerform => 62 */
   remoteDispatchDomainMigratePerformHelper,
   sizeof(remote_domain_migrate_perform_args),
   (xdrproc_t)xdr_remote_domain_migrate_perform_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainMigrateFinish => 63 */
   remoteDispatchDomainMigrateFinishHelper,
   sizeof(remote_domain_migrate_finish_args),
   (xdrproc_t)xdr_remote_domain_migrate_finish_args,
   sizeof(remote_domain_migrate_finish_ret),
   (xdrproc_t)xdr_remote_domain_migrate_finish_ret,
   true,
   0
},
{ /* Method DomainBlockStats => 64 */
   remoteDispatchDomainBlockStatsHelper,
   sizeof(remote_domain_block_stats_args),
   (xdrproc_t)xdr_remote_domain_block_stats_args,
   sizeof(remote_domain_block_stats_ret),
   (xdrproc_t)xdr_remote_domain_block_stats_ret,
   true,
   0
},
{ /* Method DomainInterfaceStats => 65 */
   remoteDispatchDomainInterfaceStatsHelper,
   sizeof(remote_domain_interface_stats_args),
   (xdrproc_t)xdr_remote_domain_interface_stats_args,
   sizeof(remote_domain_interface_stats_ret),
   (xdrproc_t)xdr_remote_domain_interface_stats_ret,
   true,
   1
},
{ /* Method AuthList => 66 */
   remoteDispatchAuthListHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_auth_list_ret),
   (xdrproc_t)xdr_remote_auth_list_ret,
   true,
   1
},
{ /* Method AuthSaslInit => 67 */
   remoteDispatchAuthSaslInitHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_auth_sasl_init_ret),
   (xdrproc_t)xdr_remote_auth_sasl_init_ret,
   true,
   1
},
{ /* Method AuthSaslStart => 68 */
   remoteDispatchAuthSaslStartHelper,
   sizeof(remote_auth_sasl_start_args),
   (xdrproc_t)xdr_remote_auth_sasl_start_args,
   sizeof(remote_auth_sasl_start_ret),
   (xdrproc_t)xdr_remote_auth_sasl_start_ret,
   true,
   1
},
{ /* Method AuthSaslStep => 69 */
   remoteDispatchAuthSaslStepHelper,
   sizeof(remote_auth_sasl_step_args),
   (xdrproc_t)xdr_remote_auth_sasl_step_args,
   sizeof(remote_auth_sasl_step_ret),
   (xdrproc_t)xdr_remote_auth_sasl_step_ret,
   true,
   1
},
{ /* Method AuthPolkit => 70 */
   remoteDispatchAuthPolkitHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_auth_polkit_ret),
   (xdrproc_t)xdr_remote_auth_polkit_ret,
   true,
   1
},
{ /* Method ConnectNumOfStoragePools => 71 */
   remoteDispatchConnectNumOfStoragePoolsHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_connect_num_of_storage_pools_ret),
   (xdrproc_t)xdr_remote_connect_num_of_storage_pools_ret,
   true,
   1
},
{ /* Method ConnectListStoragePools => 72 */
   remoteDispatchConnectListStoragePoolsHelper,
   sizeof(remote_connect_list_storage_pools_args),
   (xdrproc_t)xdr_remote_connect_list_storage_pools_args,
   sizeof(remote_connect_list_storage_pools_ret),
   (xdrproc_t)xdr_remote_connect_list_storage_pools_ret,
   true,
   1
},
{ /* Method ConnectNumOfDefinedStoragePools => 73 */
   remoteDispatchConnectNumOfDefinedStoragePoolsHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_connect_num_of_defined_storage_pools_ret),
   (xdrproc_t)xdr_remote_connect_num_of_defined_storage_pools_ret,
   true,
   1
},
{ /* Method ConnectListDefinedStoragePools => 74 */
   remoteDispatchConnectListDefinedStoragePoolsHelper,
   sizeof(remote_connect_list_defined_storage_pools_args),
   (xdrproc_t)xdr_remote_connect_list_defined_storage_pools_args,
   sizeof(remote_connect_list_defined_storage_pools_ret),
   (xdrproc_t)xdr_remote_connect_list_defined_storage_pools_ret,
   true,
   1
},
{ /* Method ConnectFindStoragePoolSources => 75 */
   remoteDispatchConnectFindStoragePoolSourcesHelper,
   sizeof(remote_connect_find_storage_pool_sources_args),
   (xdrproc_t)xdr_remote_connect_find_storage_pool_sources_args,
   sizeof(remote_connect_find_storage_pool_sources_ret),
   (xdrproc_t)xdr_remote_connect_find_storage_pool_sources_ret,
   true,
   0
},
{ /* Method StoragePoolCreateXML => 76 */
   remoteDispatchStoragePoolCreateXMLHelper,
   sizeof(remote_storage_pool_create_xml_args),
   (xdrproc_t)xdr_remote_storage_pool_create_xml_args,
   sizeof(remote_storage_pool_create_xml_ret),
   (xdrproc_t)xdr_remote_storage_pool_create_xml_ret,
   true,
   0
},
{ /* Method StoragePoolDefineXML => 77 */
   remoteDispatchStoragePoolDefineXMLHelper,
   sizeof(remote_storage_pool_define_xml_args),
   (xdrproc_t)xdr_remote_storage_pool_define_xml_args,
   sizeof(remote_storage_pool_define_xml_ret),
   (xdrproc_t)xdr_remote_storage_pool_define_xml_ret,
   true,
   1
},
{ /* Method StoragePoolCreate => 78 */
   remoteDispatchStoragePoolCreateHelper,
   sizeof(remote_storage_pool_create_args),
   (xdrproc_t)xdr_remote_storage_pool_create_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method StoragePoolBuild => 79 */
   remoteDispatchStoragePoolBuildHelper,
   sizeof(remote_storage_pool_build_args),
   (xdrproc_t)xdr_remote_storage_pool_build_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method StoragePoolDestroy => 80 */
   remoteDispatchStoragePoolDestroyHelper,
   sizeof(remote_storage_pool_destroy_args),
   (xdrproc_t)xdr_remote_storage_pool_destroy_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method StoragePoolDelete => 81 */
   remoteDispatchStoragePoolDeleteHelper,
   sizeof(remote_storage_pool_delete_args),
   (xdrproc_t)xdr_remote_storage_pool_delete_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method StoragePoolUndefine => 82 */
   remoteDispatchStoragePoolUndefineHelper,
   sizeof(remote_storage_pool_undefine_args),
   (xdrproc_t)xdr_remote_storage_pool_undefine_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method StoragePoolRefresh => 83 */
   remoteDispatchStoragePoolRefreshHelper,
   sizeof(remote_storage_pool_refresh_args),
   (xdrproc_t)xdr_remote_storage_pool_refresh_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method StoragePoolLookupByName => 84 */
   remoteDispatchStoragePoolLookupByNameHelper,
   sizeof(remote_storage_pool_lookup_by_name_args),
   (xdrproc_t)xdr_remote_storage_pool_lookup_by_name_args,
   sizeof(remote_storage_pool_lookup_by_name_ret),
   (xdrproc_t)xdr_remote_storage_pool_lookup_by_name_ret,
   true,
   1
},
{ /* Method StoragePoolLookupByUUID => 85 */
   remoteDispatchStoragePoolLookupByUUIDHelper,
   sizeof(remote_storage_pool_lookup_by_uuid_args),
   (xdrproc_t)xdr_remote_storage_pool_lookup_by_uuid_args,
   sizeof(remote_storage_pool_lookup_by_uuid_ret),
   (xdrproc_t)xdr_remote_storage_pool_lookup_by_uuid_ret,
   true,
   1
},
{ /* Method StoragePoolLookupByVolume => 86 */
   remoteDispatchStoragePoolLookupByVolumeHelper,
   sizeof(remote_storage_pool_lookup_by_volume_args),
   (xdrproc_t)xdr_remote_storage_pool_lookup_by_volume_args,
   sizeof(remote_storage_pool_lookup_by_volume_ret),
   (xdrproc_t)xdr_remote_storage_pool_lookup_by_volume_ret,
   true,
   1
},
{ /* Method StoragePoolGetInfo => 87 */
   remoteDispatchStoragePoolGetInfoHelper,
   sizeof(remote_storage_pool_get_info_args),
   (xdrproc_t)xdr_remote_storage_pool_get_info_args,
   sizeof(remote_storage_pool_get_info_ret),
   (xdrproc_t)xdr_remote_storage_pool_get_info_ret,
   true,
   1
},
{ /* Method StoragePoolGetXMLDesc => 88 */
   remoteDispatchStoragePoolGetXMLDescHelper,
   sizeof(remote_storage_pool_get_xml_desc_args),
   (xdrproc_t)xdr_remote_storage_pool_get_xml_desc_args,
   sizeof(remote_storage_pool_get_xml_desc_ret),
   (xdrproc_t)xdr_remote_storage_pool_get_xml_desc_ret,
   true,
   1
},
{ /* Method StoragePoolGetAutostart => 89 */
   remoteDispatchStoragePoolGetAutostartHelper,
   sizeof(remote_storage_pool_get_autostart_args),
   (xdrproc_t)xdr_remote_storage_pool_get_autostart_args,
   sizeof(remote_storage_pool_get_autostart_ret),
   (xdrproc_t)xdr_remote_storage_pool_get_autostart_ret,
   true,
   1
},
{ /* Method StoragePoolSetAutostart => 90 */
   remoteDispatchStoragePoolSetAutostartHelper,
   sizeof(remote_storage_pool_set_autostart_args),
   (xdrproc_t)xdr_remote_storage_pool_set_autostart_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method StoragePoolNumOfVolumes => 91 */
   remoteDispatchStoragePoolNumOfVolumesHelper,
   sizeof(remote_storage_pool_num_of_volumes_args),
   (xdrproc_t)xdr_remote_storage_pool_num_of_volumes_args,
   sizeof(remote_storage_pool_num_of_volumes_ret),
   (xdrproc_t)xdr_remote_storage_pool_num_of_volumes_ret,
   true,
   1
},
{ /* Method StoragePoolListVolumes => 92 */
   remoteDispatchStoragePoolListVolumesHelper,
   sizeof(remote_storage_pool_list_volumes_args),
   (xdrproc_t)xdr_remote_storage_pool_list_volumes_args,
   sizeof(remote_storage_pool_list_volumes_ret),
   (xdrproc_t)xdr_remote_storage_pool_list_volumes_ret,
   true,
   1
},
{ /* Method StorageVolCreateXML => 93 */
   remoteDispatchStorageVolCreateXMLHelper,
   sizeof(remote_storage_vol_create_xml_args),
   (xdrproc_t)xdr_remote_storage_vol_create_xml_args,
   sizeof(remote_storage_vol_create_xml_ret),
   (xdrproc_t)xdr_remote_storage_vol_create_xml_ret,
   true,
   0
},
{ /* Method StorageVolDelete => 94 */
   remoteDispatchStorageVolDeleteHelper,
   sizeof(remote_storage_vol_delete_args),
   (xdrproc_t)xdr_remote_storage_vol_delete_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method StorageVolLookupByName => 95 */
   remoteDispatchStorageVolLookupByNameHelper,
   sizeof(remote_storage_vol_lookup_by_name_args),
   (xdrproc_t)xdr_remote_storage_vol_lookup_by_name_args,
   sizeof(remote_storage_vol_lookup_by_name_ret),
   (xdrproc_t)xdr_remote_storage_vol_lookup_by_name_ret,
   true,
   1
},
{ /* Method StorageVolLookupByKey => 96 */
   remoteDispatchStorageVolLookupByKeyHelper,
   sizeof(remote_storage_vol_lookup_by_key_args),
   (xdrproc_t)xdr_remote_storage_vol_lookup_by_key_args,
   sizeof(remote_storage_vol_lookup_by_key_ret),
   (xdrproc_t)xdr_remote_storage_vol_lookup_by_key_ret,
   true,
   1
},
{ /* Method StorageVolLookupByPath => 97 */
   remoteDispatchStorageVolLookupByPathHelper,
   sizeof(remote_storage_vol_lookup_by_path_args),
   (xdrproc_t)xdr_remote_storage_vol_lookup_by_path_args,
   sizeof(remote_storage_vol_lookup_by_path_ret),
   (xdrproc_t)xdr_remote_storage_vol_lookup_by_path_ret,
   true,
   1
},
{ /* Method StorageVolGetInfo => 98 */
   remoteDispatchStorageVolGetInfoHelper,
   sizeof(remote_storage_vol_get_info_args),
   (xdrproc_t)xdr_remote_storage_vol_get_info_args,
   sizeof(remote_storage_vol_get_info_ret),
   (xdrproc_t)xdr_remote_storage_vol_get_info_ret,
   true,
   1
},
{ /* Method StorageVolGetXMLDesc => 99 */
   remoteDispatchStorageVolGetXMLDescHelper,
   sizeof(remote_storage_vol_get_xml_desc_args),
   (xdrproc_t)xdr_remote_storage_vol_get_xml_desc_args,
   sizeof(remote_storage_vol_get_xml_desc_ret),
   (xdrproc_t)xdr_remote_storage_vol_get_xml_desc_ret,
   true,
   1
},
{ /* Method StorageVolGetPath => 100 */
   remoteDispatchStorageVolGetPathHelper,
   sizeof(remote_storage_vol_get_path_args),
   (xdrproc_t)xdr_remote_storage_vol_get_path_args,
   sizeof(remote_storage_vol_get_path_ret),
   (xdrproc_t)xdr_remote_storage_vol_get_path_ret,
   true,
   1
},
{ /* Method NodeGetCellsFreeMemory => 101 */
   remoteDispatchNodeGetCellsFreeMemoryHelper,
   sizeof(remote_node_get_cells_free_memory_args),
   (xdrproc_t)xdr_remote_node_get_cells_free_memory_args,
   sizeof(remote_node_get_cells_free_memory_ret),
   (xdrproc_t)xdr_remote_node_get_cells_free_memory_ret,
   true,
   1
},
{ /* Method NodeGetFreeMemory => 102 */
   remoteDispatchNodeGetFreeMemoryHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_node_get_free_memory_ret),
   (xdrproc_t)xdr_remote_node_get_free_memory_ret,
   true,
   1
},
{ /* Method DomainBlockPeek => 103 */
   remoteDispatchDomainBlockPeekHelper,
   sizeof(remote_domain_block_peek_args),
   (xdrproc_t)xdr_remote_domain_block_peek_args,
   sizeof(remote_domain_block_peek_ret),
   (xdrproc_t)xdr_remote_domain_block_peek_ret,
   true,
   0
},
{ /* Method DomainMemoryPeek => 104 */
   remoteDispatchDomainMemoryPeekHelper,
   sizeof(remote_domain_memory_peek_args),
   (xdrproc_t)xdr_remote_domain_memory_peek_args,
   sizeof(remote_domain_memory_peek_ret),
   (xdrproc_t)xdr_remote_domain_memory_peek_ret,
   true,
   0
},
{ /* Method ConnectDomainEventRegister => 105 */
   remoteDispatchConnectDomainEventRegisterHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_connect_domain_event_register_ret),
   (xdrproc_t)xdr_remote_connect_domain_event_register_ret,
   true,
   1
},
{ /* Method ConnectDomainEventDeregister => 106 */
   remoteDispatchConnectDomainEventDeregisterHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_connect_domain_event_deregister_ret),
   (xdrproc_t)xdr_remote_connect_domain_event_deregister_ret,
   true,
   1
},
{ /* Async event DomainEventLifecycle => 107 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainMigratePrepare2 => 108 */
   remoteDispatchDomainMigratePrepare2Helper,
   sizeof(remote_domain_migrate_prepare2_args),
   (xdrproc_t)xdr_remote_domain_migrate_prepare2_args,
   sizeof(remote_domain_migrate_prepare2_ret),
   (xdrproc_t)xdr_remote_domain_migrate_prepare2_ret,
   true,
   0
},
{ /* Method DomainMigrateFinish2 => 109 */
   remoteDispatchDomainMigrateFinish2Helper,
   sizeof(remote_domain_migrate_finish2_args),
   (xdrproc_t)xdr_remote_domain_migrate_finish2_args,
   sizeof(remote_domain_migrate_finish2_ret),
   (xdrproc_t)xdr_remote_domain_migrate_finish2_ret,
   true,
   0
},
{ /* Method ConnectGetURI => 110 */
   remoteDispatchConnectGetURIHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_connect_get_uri_ret),
   (xdrproc_t)xdr_remote_connect_get_uri_ret,
   true,
   1
},
{ /* Method NodeNumOfDevices => 111 */
   remoteDispatchNodeNumOfDevicesHelper,
   sizeof(remote_node_num_of_devices_args),
   (xdrproc_t)xdr_remote_node_num_of_devices_args,
   sizeof(remote_node_num_of_devices_ret),
   (xdrproc_t)xdr_remote_node_num_of_devices_ret,
   true,
   1
},
{ /* Method NodeListDevices => 112 */
   remoteDispatchNodeListDevicesHelper,
   sizeof(remote_node_list_devices_args),
   (xdrproc_t)xdr_remote_node_list_devices_args,
   sizeof(remote_node_list_devices_ret),
   (xdrproc_t)xdr_remote_node_list_devices_ret,
   true,
   1
},
{ /* Method NodeDeviceLookupByName => 113 */
   remoteDispatchNodeDeviceLookupByNameHelper,
   sizeof(remote_node_device_lookup_by_name_args),
   (xdrproc_t)xdr_remote_node_device_lookup_by_name_args,
   sizeof(remote_node_device_lookup_by_name_ret),
   (xdrproc_t)xdr_remote_node_device_lookup_by_name_ret,
   true,
   1
},
{ /* Method NodeDeviceGetXMLDesc => 114 */
   remoteDispatchNodeDeviceGetXMLDescHelper,
   sizeof(remote_node_device_get_xml_desc_args),
   (xdrproc_t)xdr_remote_node_device_get_xml_desc_args,
   sizeof(remote_node_device_get_xml_desc_ret),
   (xdrproc_t)xdr_remote_node_device_get_xml_desc_ret,
   true,
   0
},
{ /* Method NodeDeviceGetParent => 115 */
   remoteDispatchNodeDeviceGetParentHelper,
   sizeof(remote_node_device_get_parent_args),
   (xdrproc_t)xdr_remote_node_device_get_parent_args,
   sizeof(remote_node_device_get_parent_ret),
   (xdrproc_t)xdr_remote_node_device_get_parent_ret,
   true,
   1
},
{ /* Method NodeDeviceNumOfCaps => 116 */
   remoteDispatchNodeDeviceNumOfCapsHelper,
   sizeof(remote_node_device_num_of_caps_args),
   (xdrproc_t)xdr_remote_node_device_num_of_caps_args,
   sizeof(remote_node_device_num_of_caps_ret),
   (xdrproc_t)xdr_remote_node_device_num_of_caps_ret,
   true,
   1
},
{ /* Method NodeDeviceListCaps => 117 */
   remoteDispatchNodeDeviceListCapsHelper,
   sizeof(remote_node_device_list_caps_args),
   (xdrproc_t)xdr_remote_node_device_list_caps_args,
   sizeof(remote_node_device_list_caps_ret),
   (xdrproc_t)xdr_remote_node_device_list_caps_ret,
   true,
   1
},
{ /* Method NodeDeviceDettach => 118 */
   remoteDispatchNodeDeviceDettachHelper,
   sizeof(remote_node_device_dettach_args),
   (xdrproc_t)xdr_remote_node_device_dettach_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method NodeDeviceReAttach => 119 */
   remoteDispatchNodeDeviceReAttachHelper,
   sizeof(remote_node_device_re_attach_args),
   (xdrproc_t)xdr_remote_node_device_re_attach_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method NodeDeviceReset => 120 */
   remoteDispatchNodeDeviceResetHelper,
   sizeof(remote_node_device_reset_args),
   (xdrproc_t)xdr_remote_node_device_reset_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainGetSecurityLabel => 121 */
   remoteDispatchDomainGetSecurityLabelHelper,
   sizeof(remote_domain_get_security_label_args),
   (xdrproc_t)xdr_remote_domain_get_security_label_args,
   sizeof(remote_domain_get_security_label_ret),
   (xdrproc_t)xdr_remote_domain_get_security_label_ret,
   true,
   1
},
{ /* Method NodeGetSecurityModel => 122 */
   remoteDispatchNodeGetSecurityModelHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_node_get_security_model_ret),
   (xdrproc_t)xdr_remote_node_get_security_model_ret,
   true,
   1
},
{ /* Method NodeDeviceCreateXML => 123 */
   remoteDispatchNodeDeviceCreateXMLHelper,
   sizeof(remote_node_device_create_xml_args),
   (xdrproc_t)xdr_remote_node_device_create_xml_args,
   sizeof(remote_node_device_create_xml_ret),
   (xdrproc_t)xdr_remote_node_device_create_xml_ret,
   true,
   0
},
{ /* Method NodeDeviceDestroy => 124 */
   remoteDispatchNodeDeviceDestroyHelper,
   sizeof(remote_node_device_destroy_args),
   (xdrproc_t)xdr_remote_node_device_destroy_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method StorageVolCreateXMLFrom => 125 */
   remoteDispatchStorageVolCreateXMLFromHelper,
   sizeof(remote_storage_vol_create_xml_from_args),
   (xdrproc_t)xdr_remote_storage_vol_create_xml_from_args,
   sizeof(remote_storage_vol_create_xml_from_ret),
   (xdrproc_t)xdr_remote_storage_vol_create_xml_from_ret,
   true,
   0
},
{ /* Method ConnectNumOfInterfaces => 126 */
   remoteDispatchConnectNumOfInterfacesHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_connect_num_of_interfaces_ret),
   (xdrproc_t)xdr_remote_connect_num_of_interfaces_ret,
   true,
   1
},
{ /* Method ConnectListInterfaces => 127 */
   remoteDispatchConnectListInterfacesHelper,
   sizeof(remote_connect_list_interfaces_args),
   (xdrproc_t)xdr_remote_connect_list_interfaces_args,
   sizeof(remote_connect_list_interfaces_ret),
   (xdrproc_t)xdr_remote_connect_list_interfaces_ret,
   true,
   1
},
{ /* Method InterfaceLookupByName => 128 */
   remoteDispatchInterfaceLookupByNameHelper,
   sizeof(remote_interface_lookup_by_name_args),
   (xdrproc_t)xdr_remote_interface_lookup_by_name_args,
   sizeof(remote_interface_lookup_by_name_ret),
   (xdrproc_t)xdr_remote_interface_lookup_by_name_ret,
   true,
   1
},
{ /* Method InterfaceLookupByMACString => 129 */
   remoteDispatchInterfaceLookupByMACStringHelper,
   sizeof(remote_interface_lookup_by_mac_string_args),
   (xdrproc_t)xdr_remote_interface_lookup_by_mac_string_args,
   sizeof(remote_interface_lookup_by_mac_string_ret),
   (xdrproc_t)xdr_remote_interface_lookup_by_mac_string_ret,
   true,
   1
},
{ /* Method InterfaceGetXMLDesc => 130 */
   remoteDispatchInterfaceGetXMLDescHelper,
   sizeof(remote_interface_get_xml_desc_args),
   (xdrproc_t)xdr_remote_interface_get_xml_desc_args,
   sizeof(remote_interface_get_xml_desc_ret),
   (xdrproc_t)xdr_remote_interface_get_xml_desc_ret,
   true,
   0
},
{ /* Method InterfaceDefineXML => 131 */
   remoteDispatchInterfaceDefineXMLHelper,
   sizeof(remote_interface_define_xml_args),
   (xdrproc_t)xdr_remote_interface_define_xml_args,
   sizeof(remote_interface_define_xml_ret),
   (xdrproc_t)xdr_remote_interface_define_xml_ret,
   true,
   1
},
{ /* Method InterfaceUndefine => 132 */
   remoteDispatchInterfaceUndefineHelper,
   sizeof(remote_interface_undefine_args),
   (xdrproc_t)xdr_remote_interface_undefine_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method InterfaceCreate => 133 */
   remoteDispatchInterfaceCreateHelper,
   sizeof(remote_interface_create_args),
   (xdrproc_t)xdr_remote_interface_create_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method InterfaceDestroy => 134 */
   remoteDispatchInterfaceDestroyHelper,
   sizeof(remote_interface_destroy_args),
   (xdrproc_t)xdr_remote_interface_destroy_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method ConnectDomainXMLFromNative => 135 */
   remoteDispatchConnectDomainXMLFromNativeHelper,
   sizeof(remote_connect_domain_xml_from_native_args),
   (xdrproc_t)xdr_remote_connect_domain_xml_from_native_args,
   sizeof(remote_connect_domain_xml_from_native_ret),
   (xdrproc_t)xdr_remote_connect_domain_xml_from_native_ret,
   true,
   0
},
{ /* Method ConnectDomainXMLToNative => 136 */
   remoteDispatchConnectDomainXMLToNativeHelper,
   sizeof(remote_connect_domain_xml_to_native_args),
   (xdrproc_t)xdr_remote_connect_domain_xml_to_native_args,
   sizeof(remote_connect_domain_xml_to_native_ret),
   (xdrproc_t)xdr_remote_connect_domain_xml_to_native_ret,
   true,
   0
},
{ /* Method ConnectNumOfDefinedInterfaces => 137 */
   remoteDispatchConnectNumOfDefinedInterfacesHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_connect_num_of_defined_interfaces_ret),
   (xdrproc_t)xdr_remote_connect_num_of_defined_interfaces_ret,
   true,
   1
},
{ /* Method ConnectListDefinedInterfaces => 138 */
   remoteDispatchConnectListDefinedInterfacesHelper,
   sizeof(remote_connect_list_defined_interfaces_args),
   (xdrproc_t)xdr_remote_connect_list_defined_interfaces_args,
   sizeof(remote_connect_list_defined_interfaces_ret),
   (xdrproc_t)xdr_remote_connect_list_defined_interfaces_ret,
   true,
   1
},
{ /* Method ConnectNumOfSecrets => 139 */
   remoteDispatchConnectNumOfSecretsHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_connect_num_of_secrets_ret),
   (xdrproc_t)xdr_remote_connect_num_of_secrets_ret,
   true,
   1
},
{ /* Method ConnectListSecrets => 140 */
   remoteDispatchConnectListSecretsHelper,
   sizeof(remote_connect_list_secrets_args),
   (xdrproc_t)xdr_remote_connect_list_secrets_args,
   sizeof(remote_connect_list_secrets_ret),
   (xdrproc_t)xdr_remote_connect_list_secrets_ret,
   true,
   1
},
{ /* Method SecretLookupByUUID => 141 */
   remoteDispatchSecretLookupByUUIDHelper,
   sizeof(remote_secret_lookup_by_uuid_args),
   (xdrproc_t)xdr_remote_secret_lookup_by_uuid_args,
   sizeof(remote_secret_lookup_by_uuid_ret),
   (xdrproc_t)xdr_remote_secret_lookup_by_uuid_ret,
   true,
   1
},
{ /* Method SecretDefineXML => 142 */
   remoteDispatchSecretDefineXMLHelper,
   sizeof(remote_secret_define_xml_args),
   (xdrproc_t)xdr_remote_secret_define_xml_args,
   sizeof(remote_secret_define_xml_ret),
   (xdrproc_t)xdr_remote_secret_define_xml_ret,
   true,
   1
},
{ /* Method SecretGetXMLDesc => 143 */
   remoteDispatchSecretGetXMLDescHelper,
   sizeof(remote_secret_get_xml_desc_args),
   (xdrproc_t)xdr_remote_secret_get_xml_desc_args,
   sizeof(remote_secret_get_xml_desc_ret),
   (xdrproc_t)xdr_remote_secret_get_xml_desc_ret,
   true,
   1
},
{ /* Method SecretSetValue => 144 */
   remoteDispatchSecretSetValueHelper,
   sizeof(remote_secret_set_value_args),
   (xdrproc_t)xdr_remote_secret_set_value_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method SecretGetValue => 145 */
   remoteDispatchSecretGetValueHelper,
   sizeof(remote_secret_get_value_args),
   (xdrproc_t)xdr_remote_secret_get_value_args,
   sizeof(remote_secret_get_value_ret),
   (xdrproc_t)xdr_remote_secret_get_value_ret,
   true,
   1
},
{ /* Method SecretUndefine => 146 */
   remoteDispatchSecretUndefineHelper,
   sizeof(remote_secret_undefine_args),
   (xdrproc_t)xdr_remote_secret_undefine_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method SecretLookupByUsage => 147 */
   remoteDispatchSecretLookupByUsageHelper,
   sizeof(remote_secret_lookup_by_usage_args),
   (xdrproc_t)xdr_remote_secret_lookup_by_usage_args,
   sizeof(remote_secret_lookup_by_usage_ret),
   (xdrproc_t)xdr_remote_secret_lookup_by_usage_ret,
   true,
   1
},
{ /* Method DomainMigratePrepareTunnel => 148 */
   remoteDispatchDomainMigratePrepareTunnelHelper,
   sizeof(remote_domain_migrate_prepare_tunnel_args),
   (xdrproc_t)xdr_remote_domain_migrate_prepare_tunnel_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method ConnectIsSecure => 149 */
   remoteDispatchConnectIsSecureHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_connect_is_secure_ret),
   (xdrproc_t)xdr_remote_connect_is_secure_ret,
   true,
   1
},
{ /* Method DomainIsActive => 150 */
   remoteDispatchDomainIsActiveHelper,
   sizeof(remote_domain_is_active_args),
   (xdrproc_t)xdr_remote_domain_is_active_args,
   sizeof(remote_domain_is_active_ret),
   (xdrproc_t)xdr_remote_domain_is_active_ret,
   true,
   1
},
{ /* Method DomainIsPersistent => 151 */
   remoteDispatchDomainIsPersistentHelper,
   sizeof(remote_domain_is_persistent_args),
   (xdrproc_t)xdr_remote_domain_is_persistent_args,
   sizeof(remote_domain_is_persistent_ret),
   (xdrproc_t)xdr_remote_domain_is_persistent_ret,
   true,
   1
},
{ /* Method NetworkIsActive => 152 */
   remoteDispatchNetworkIsActiveHelper,
   sizeof(remote_network_is_active_args),
   (xdrproc_t)xdr_remote_network_is_active_args,
   sizeof(remote_network_is_active_ret),
   (xdrproc_t)xdr_remote_network_is_active_ret,
   true,
   1
},
{ /* Method NetworkIsPersistent => 153 */
   remoteDispatchNetworkIsPersistentHelper,
   sizeof(remote_network_is_persistent_args),
   (xdrproc_t)xdr_remote_network_is_persistent_args,
   sizeof(remote_network_is_persistent_ret),
   (xdrproc_t)xdr_remote_network_is_persistent_ret,
   true,
   1
},
{ /* Method StoragePoolIsActive => 154 */
   remoteDispatchStoragePoolIsActiveHelper,
   sizeof(remote_storage_pool_is_active_args),
   (xdrproc_t)xdr_remote_storage_pool_is_active_args,
   sizeof(remote_storage_pool_is_active_ret),
   (xdrproc_t)xdr_remote_storage_pool_is_active_ret,
   true,
   1
},
{ /* Method StoragePoolIsPersistent => 155 */
   remoteDispatchStoragePoolIsPersistentHelper,
   sizeof(remote_storage_pool_is_persistent_args),
   (xdrproc_t)xdr_remote_storage_pool_is_persistent_args,
   sizeof(remote_storage_pool_is_persistent_ret),
   (xdrproc_t)xdr_remote_storage_pool_is_persistent_ret,
   true,
   1
},
{ /* Method InterfaceIsActive => 156 */
   remoteDispatchInterfaceIsActiveHelper,
   sizeof(remote_interface_is_active_args),
   (xdrproc_t)xdr_remote_interface_is_active_args,
   sizeof(remote_interface_is_active_ret),
   (xdrproc_t)xdr_remote_interface_is_active_ret,
   true,
   1
},
{ /* Method ConnectGetLibVersion => 157 */
   remoteDispatchConnectGetLibVersionHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_connect_get_lib_version_ret),
   (xdrproc_t)xdr_remote_connect_get_lib_version_ret,
   true,
   1
},
{ /* Method ConnectCompareCPU => 158 */
   remoteDispatchConnectCompareCPUHelper,
   sizeof(remote_connect_compare_cpu_args),
   (xdrproc_t)xdr_remote_connect_compare_cpu_args,
   sizeof(remote_connect_compare_cpu_ret),
   (xdrproc_t)xdr_remote_connect_compare_cpu_ret,
   true,
   1
},
{ /* Method DomainMemoryStats => 159 */
   remoteDispatchDomainMemoryStatsHelper,
   sizeof(remote_domain_memory_stats_args),
   (xdrproc_t)xdr_remote_domain_memory_stats_args,
   sizeof(remote_domain_memory_stats_ret),
   (xdrproc_t)xdr_remote_domain_memory_stats_ret,
   true,
   0
},
{ /* Method DomainAttachDeviceFlags => 160 */
   remoteDispatchDomainAttachDeviceFlagsHelper,
   sizeof(remote_domain_attach_device_flags_args),
   (xdrproc_t)xdr_remote_domain_attach_device_flags_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainDetachDeviceFlags => 161 */
   remoteDispatchDomainDetachDeviceFlagsHelper,
   sizeof(remote_domain_detach_device_flags_args),
   (xdrproc_t)xdr_remote_domain_detach_device_flags_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method ConnectBaselineCPU => 162 */
   remoteDispatchConnectBaselineCPUHelper,
   sizeof(remote_connect_baseline_cpu_args),
   (xdrproc_t)xdr_remote_connect_baseline_cpu_args,
   sizeof(remote_connect_baseline_cpu_ret),
   (xdrproc_t)xdr_remote_connect_baseline_cpu_ret,
   true,
   0
},
{ /* Method DomainGetJobInfo => 163 */
   remoteDispatchDomainGetJobInfoHelper,
   sizeof(remote_domain_get_job_info_args),
   (xdrproc_t)xdr_remote_domain_get_job_info_args,
   sizeof(remote_domain_get_job_info_ret),
   (xdrproc_t)xdr_remote_domain_get_job_info_ret,
   true,
   0
},
{ /* Method DomainAbortJob => 164 */
   remoteDispatchDomainAbortJobHelper,
   sizeof(remote_domain_abort_job_args),
   (xdrproc_t)xdr_remote_domain_abort_job_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method StorageVolWipe => 165 */
   remoteDispatchStorageVolWipeHelper,
   sizeof(remote_storage_vol_wipe_args),
   (xdrproc_t)xdr_remote_storage_vol_wipe_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainMigrateSetMaxDowntime => 166 */
   remoteDispatchDomainMigrateSetMaxDowntimeHelper,
   sizeof(remote_domain_migrate_set_max_downtime_args),
   (xdrproc_t)xdr_remote_domain_migrate_set_max_downtime_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method ConnectDomainEventRegisterAny => 167 */
   remoteDispatchConnectDomainEventRegisterAnyHelper,
   sizeof(remote_connect_domain_event_register_any_args),
   (xdrproc_t)xdr_remote_connect_domain_event_register_any_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method ConnectDomainEventDeregisterAny => 168 */
   remoteDispatchConnectDomainEventDeregisterAnyHelper,
   sizeof(remote_connect_domain_event_deregister_any_args),
   (xdrproc_t)xdr_remote_connect_domain_event_deregister_any_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Async event DomainEventReboot => 169 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventRtcChange => 170 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventWatchdog => 171 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventIoError => 172 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventGraphics => 173 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainUpdateDeviceFlags => 174 */
   remoteDispatchDomainUpdateDeviceFlagsHelper,
   sizeof(remote_domain_update_device_flags_args),
   (xdrproc_t)xdr_remote_domain_update_device_flags_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method NWFilterLookupByName => 175 */
   remoteDispatchNWFilterLookupByNameHelper,
   sizeof(remote_nwfilter_lookup_by_name_args),
   (xdrproc_t)xdr_remote_nwfilter_lookup_by_name_args,
   sizeof(remote_nwfilter_lookup_by_name_ret),
   (xdrproc_t)xdr_remote_nwfilter_lookup_by_name_ret,
   true,
   1
},
{ /* Method NWFilterLookupByUUID => 176 */
   remoteDispatchNWFilterLookupByUUIDHelper,
   sizeof(remote_nwfilter_lookup_by_uuid_args),
   (xdrproc_t)xdr_remote_nwfilter_lookup_by_uuid_args,
   sizeof(remote_nwfilter_lookup_by_uuid_ret),
   (xdrproc_t)xdr_remote_nwfilter_lookup_by_uuid_ret,
   true,
   1
},
{ /* Method NWFilterGetXMLDesc => 177 */
   remoteDispatchNWFilterGetXMLDescHelper,
   sizeof(remote_nwfilter_get_xml_desc_args),
   (xdrproc_t)xdr_remote_nwfilter_get_xml_desc_args,
   sizeof(remote_nwfilter_get_xml_desc_ret),
   (xdrproc_t)xdr_remote_nwfilter_get_xml_desc_ret,
   true,
   1
},
{ /* Method ConnectNumOfNWFilters => 178 */
   remoteDispatchConnectNumOfNWFiltersHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_connect_num_of_nwfilters_ret),
   (xdrproc_t)xdr_remote_connect_num_of_nwfilters_ret,
   true,
   1
},
{ /* Method ConnectListNWFilters => 179 */
   remoteDispatchConnectListNWFiltersHelper,
   sizeof(remote_connect_list_nwfilters_args),
   (xdrproc_t)xdr_remote_connect_list_nwfilters_args,
   sizeof(remote_connect_list_nwfilters_ret),
   (xdrproc_t)xdr_remote_connect_list_nwfilters_ret,
   true,
   1
},
{ /* Method NWFilterDefineXML => 180 */
   remoteDispatchNWFilterDefineXMLHelper,
   sizeof(remote_nwfilter_define_xml_args),
   (xdrproc_t)xdr_remote_nwfilter_define_xml_args,
   sizeof(remote_nwfilter_define_xml_ret),
   (xdrproc_t)xdr_remote_nwfilter_define_xml_ret,
   true,
   1
},
{ /* Method NWFilterUndefine => 181 */
   remoteDispatchNWFilterUndefineHelper,
   sizeof(remote_nwfilter_undefine_args),
   (xdrproc_t)xdr_remote_nwfilter_undefine_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method DomainManagedSave => 182 */
   remoteDispatchDomainManagedSaveHelper,
   sizeof(remote_domain_managed_save_args),
   (xdrproc_t)xdr_remote_domain_managed_save_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainHasManagedSaveImage => 183 */
   remoteDispatchDomainHasManagedSaveImageHelper,
   sizeof(remote_domain_has_managed_save_image_args),
   (xdrproc_t)xdr_remote_domain_has_managed_save_image_args,
   sizeof(remote_domain_has_managed_save_image_ret),
   (xdrproc_t)xdr_remote_domain_has_managed_save_image_ret,
   true,
   0
},
{ /* Method DomainManagedSaveRemove => 184 */
   remoteDispatchDomainManagedSaveRemoveHelper,
   sizeof(remote_domain_managed_save_remove_args),
   (xdrproc_t)xdr_remote_domain_managed_save_remove_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainSnapshotCreateXML => 185 */
   remoteDispatchDomainSnapshotCreateXMLHelper,
   sizeof(remote_domain_snapshot_create_xml_args),
   (xdrproc_t)xdr_remote_domain_snapshot_create_xml_args,
   sizeof(remote_domain_snapshot_create_xml_ret),
   (xdrproc_t)xdr_remote_domain_snapshot_create_xml_ret,
   true,
   0
},
{ /* Method DomainSnapshotGetXMLDesc => 186 */
   remoteDispatchDomainSnapshotGetXMLDescHelper,
   sizeof(remote_domain_snapshot_get_xml_desc_args),
   (xdrproc_t)xdr_remote_domain_snapshot_get_xml_desc_args,
   sizeof(remote_domain_snapshot_get_xml_desc_ret),
   (xdrproc_t)xdr_remote_domain_snapshot_get_xml_desc_ret,
   true,
   1
},
{ /* Method DomainSnapshotNum => 187 */
   remoteDispatchDomainSnapshotNumHelper,
   sizeof(remote_domain_snapshot_num_args),
   (xdrproc_t)xdr_remote_domain_snapshot_num_args,
   sizeof(remote_domain_snapshot_num_ret),
   (xdrproc_t)xdr_remote_domain_snapshot_num_ret,
   true,
   1
},
{ /* Method DomainSnapshotListNames => 188 */
   remoteDispatchDomainSnapshotListNamesHelper,
   sizeof(remote_domain_snapshot_list_names_args),
   (xdrproc_t)xdr_remote_domain_snapshot_list_names_args,
   sizeof(remote_domain_snapshot_list_names_ret),
   (xdrproc_t)xdr_remote_domain_snapshot_list_names_ret,
   true,
   1
},
{ /* Method DomainSnapshotLookupByName => 189 */
   remoteDispatchDomainSnapshotLookupByNameHelper,
   sizeof(remote_domain_snapshot_lookup_by_name_args),
   (xdrproc_t)xdr_remote_domain_snapshot_lookup_by_name_args,
   sizeof(remote_domain_snapshot_lookup_by_name_ret),
   (xdrproc_t)xdr_remote_domain_snapshot_lookup_by_name_ret,
   true,
   1
},
{ /* Method DomainHasCurrentSnapshot => 190 */
   remoteDispatchDomainHasCurrentSnapshotHelper,
   sizeof(remote_domain_has_current_snapshot_args),
   (xdrproc_t)xdr_remote_domain_has_current_snapshot_args,
   sizeof(remote_domain_has_current_snapshot_ret),
   (xdrproc_t)xdr_remote_domain_has_current_snapshot_ret,
   true,
   0
},
{ /* Method DomainSnapshotCurrent => 191 */
   remoteDispatchDomainSnapshotCurrentHelper,
   sizeof(remote_domain_snapshot_current_args),
   (xdrproc_t)xdr_remote_domain_snapshot_current_args,
   sizeof(remote_domain_snapshot_current_ret),
   (xdrproc_t)xdr_remote_domain_snapshot_current_ret,
   true,
   0
},
{ /* Method DomainRevertToSnapshot => 192 */
   remoteDispatchDomainRevertToSnapshotHelper,
   sizeof(remote_domain_revert_to_snapshot_args),
   (xdrproc_t)xdr_remote_domain_revert_to_snapshot_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainSnapshotDelete => 193 */
   remoteDispatchDomainSnapshotDeleteHelper,
   sizeof(remote_domain_snapshot_delete_args),
   (xdrproc_t)xdr_remote_domain_snapshot_delete_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainGetBlockInfo => 194 */
   remoteDispatchDomainGetBlockInfoHelper,
   sizeof(remote_domain_get_block_info_args),
   (xdrproc_t)xdr_remote_domain_get_block_info_args,
   sizeof(remote_domain_get_block_info_ret),
   (xdrproc_t)xdr_remote_domain_get_block_info_ret,
   true,
   0
},
{ /* Async event DomainEventIoErrorReason => 195 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainCreateWithFlags => 196 */
   remoteDispatchDomainCreateWithFlagsHelper,
   sizeof(remote_domain_create_with_flags_args),
   (xdrproc_t)xdr_remote_domain_create_with_flags_args,
   sizeof(remote_domain_create_with_flags_ret),
   (xdrproc_t)xdr_remote_domain_create_with_flags_ret,
   true,
   0
},
{ /* Method DomainSetMemoryParameters => 197 */
   remoteDispatchDomainSetMemoryParametersHelper,
   sizeof(remote_domain_set_memory_parameters_args),
   (xdrproc_t)xdr_remote_domain_set_memory_parameters_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainGetMemoryParameters => 198 */
   remoteDispatchDomainGetMemoryParametersHelper,
   sizeof(remote_domain_get_memory_parameters_args),
   (xdrproc_t)xdr_remote_domain_get_memory_parameters_args,
   sizeof(remote_domain_get_memory_parameters_ret),
   (xdrproc_t)xdr_remote_domain_get_memory_parameters_ret,
   true,
   0
},
{ /* Method DomainSetVcpusFlags => 199 */
   remoteDispatchDomainSetVcpusFlagsHelper,
   sizeof(remote_domain_set_vcpus_flags_args),
   (xdrproc_t)xdr_remote_domain_set_vcpus_flags_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainGetVcpusFlags => 200 */
   remoteDispatchDomainGetVcpusFlagsHelper,
   sizeof(remote_domain_get_vcpus_flags_args),
   (xdrproc_t)xdr_remote_domain_get_vcpus_flags_args,
   sizeof(remote_domain_get_vcpus_flags_ret),
   (xdrproc_t)xdr_remote_domain_get_vcpus_flags_ret,
   true,
   0
},
{ /* Method DomainOpenConsole => 201 */
   remoteDispatchDomainOpenConsoleHelper,
   sizeof(remote_domain_open_console_args),
   (xdrproc_t)xdr_remote_domain_open_console_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainIsUpdated => 202 */
   remoteDispatchDomainIsUpdatedHelper,
   sizeof(remote_domain_is_updated_args),
   (xdrproc_t)xdr_remote_domain_is_updated_args,
   sizeof(remote_domain_is_updated_ret),
   (xdrproc_t)xdr_remote_domain_is_updated_ret,
   true,
   1
},
{ /* Method ConnectGetSysinfo => 203 */
   remoteDispatchConnectGetSysinfoHelper,
   sizeof(remote_connect_get_sysinfo_args),
   (xdrproc_t)xdr_remote_connect_get_sysinfo_args,
   sizeof(remote_connect_get_sysinfo_ret),
   (xdrproc_t)xdr_remote_connect_get_sysinfo_ret,
   true,
   1
},
{ /* Method DomainSetMemoryFlags => 204 */
   remoteDispatchDomainSetMemoryFlagsHelper,
   sizeof(remote_domain_set_memory_flags_args),
   (xdrproc_t)xdr_remote_domain_set_memory_flags_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainSetBlkioParameters => 205 */
   remoteDispatchDomainSetBlkioParametersHelper,
   sizeof(remote_domain_set_blkio_parameters_args),
   (xdrproc_t)xdr_remote_domain_set_blkio_parameters_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainGetBlkioParameters => 206 */
   remoteDispatchDomainGetBlkioParametersHelper,
   sizeof(remote_domain_get_blkio_parameters_args),
   (xdrproc_t)xdr_remote_domain_get_blkio_parameters_args,
   sizeof(remote_domain_get_blkio_parameters_ret),
   (xdrproc_t)xdr_remote_domain_get_blkio_parameters_ret,
   true,
   0
},
{ /* Method DomainMigrateSetMaxSpeed => 207 */
   remoteDispatchDomainMigrateSetMaxSpeedHelper,
   sizeof(remote_domain_migrate_set_max_speed_args),
   (xdrproc_t)xdr_remote_domain_migrate_set_max_speed_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method StorageVolUpload => 208 */
   remoteDispatchStorageVolUploadHelper,
   sizeof(remote_storage_vol_upload_args),
   (xdrproc_t)xdr_remote_storage_vol_upload_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method StorageVolDownload => 209 */
   remoteDispatchStorageVolDownloadHelper,
   sizeof(remote_storage_vol_download_args),
   (xdrproc_t)xdr_remote_storage_vol_download_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainInjectNMI => 210 */
   remoteDispatchDomainInjectNMIHelper,
   sizeof(remote_domain_inject_nmi_args),
   (xdrproc_t)xdr_remote_domain_inject_nmi_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainScreenshot => 211 */
   remoteDispatchDomainScreenshotHelper,
   sizeof(remote_domain_screenshot_args),
   (xdrproc_t)xdr_remote_domain_screenshot_args,
   sizeof(remote_domain_screenshot_ret),
   (xdrproc_t)xdr_remote_domain_screenshot_ret,
   true,
   0
},
{ /* Method DomainGetState => 212 */
   remoteDispatchDomainGetStateHelper,
   sizeof(remote_domain_get_state_args),
   (xdrproc_t)xdr_remote_domain_get_state_args,
   sizeof(remote_domain_get_state_ret),
   (xdrproc_t)xdr_remote_domain_get_state_ret,
   true,
   1
},
{ /* Method DomainMigrateBegin3 => 213 */
   remoteDispatchDomainMigrateBegin3Helper,
   sizeof(remote_domain_migrate_begin3_args),
   (xdrproc_t)xdr_remote_domain_migrate_begin3_args,
   sizeof(remote_domain_migrate_begin3_ret),
   (xdrproc_t)xdr_remote_domain_migrate_begin3_ret,
   true,
   0
},
{ /* Method DomainMigratePrepare3 => 214 */
   remoteDispatchDomainMigratePrepare3Helper,
   sizeof(remote_domain_migrate_prepare3_args),
   (xdrproc_t)xdr_remote_domain_migrate_prepare3_args,
   sizeof(remote_domain_migrate_prepare3_ret),
   (xdrproc_t)xdr_remote_domain_migrate_prepare3_ret,
   true,
   0
},
{ /* Method DomainMigratePrepareTunnel3 => 215 */
   remoteDispatchDomainMigratePrepareTunnel3Helper,
   sizeof(remote_domain_migrate_prepare_tunnel3_args),
   (xdrproc_t)xdr_remote_domain_migrate_prepare_tunnel3_args,
   sizeof(remote_domain_migrate_prepare_tunnel3_ret),
   (xdrproc_t)xdr_remote_domain_migrate_prepare_tunnel3_ret,
   true,
   0
},
{ /* Method DomainMigratePerform3 => 216 */
   remoteDispatchDomainMigratePerform3Helper,
   sizeof(remote_domain_migrate_perform3_args),
   (xdrproc_t)xdr_remote_domain_migrate_perform3_args,
   sizeof(remote_domain_migrate_perform3_ret),
   (xdrproc_t)xdr_remote_domain_migrate_perform3_ret,
   true,
   0
},
{ /* Method DomainMigrateFinish3 => 217 */
   remoteDispatchDomainMigrateFinish3Helper,
   sizeof(remote_domain_migrate_finish3_args),
   (xdrproc_t)xdr_remote_domain_migrate_finish3_args,
   sizeof(remote_domain_migrate_finish3_ret),
   (xdrproc_t)xdr_remote_domain_migrate_finish3_ret,
   true,
   0
},
{ /* Method DomainMigrateConfirm3 => 218 */
   remoteDispatchDomainMigrateConfirm3Helper,
   sizeof(remote_domain_migrate_confirm3_args),
   (xdrproc_t)xdr_remote_domain_migrate_confirm3_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainSetSchedulerParametersFlags => 219 */
   remoteDispatchDomainSetSchedulerParametersFlagsHelper,
   sizeof(remote_domain_set_scheduler_parameters_flags_args),
   (xdrproc_t)xdr_remote_domain_set_scheduler_parameters_flags_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method InterfaceChangeBegin => 220 */
   remoteDispatchInterfaceChangeBeginHelper,
   sizeof(remote_interface_change_begin_args),
   (xdrproc_t)xdr_remote_interface_change_begin_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method InterfaceChangeCommit => 221 */
   remoteDispatchInterfaceChangeCommitHelper,
   sizeof(remote_interface_change_commit_args),
   (xdrproc_t)xdr_remote_interface_change_commit_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method InterfaceChangeRollback => 222 */
   remoteDispatchInterfaceChangeRollbackHelper,
   sizeof(remote_interface_change_rollback_args),
   (xdrproc_t)xdr_remote_interface_change_rollback_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainGetSchedulerParametersFlags => 223 */
   remoteDispatchDomainGetSchedulerParametersFlagsHelper,
   sizeof(remote_domain_get_scheduler_parameters_flags_args),
   (xdrproc_t)xdr_remote_domain_get_scheduler_parameters_flags_args,
   sizeof(remote_domain_get_scheduler_parameters_flags_ret),
   (xdrproc_t)xdr_remote_domain_get_scheduler_parameters_flags_ret,
   true,
   0
},
{ /* Async event DomainEventControlError => 224 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainPinVcpuFlags => 225 */
   remoteDispatchDomainPinVcpuFlagsHelper,
   sizeof(remote_domain_pin_vcpu_flags_args),
   (xdrproc_t)xdr_remote_domain_pin_vcpu_flags_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainSendKey => 226 */
   remoteDispatchDomainSendKeyHelper,
   sizeof(remote_domain_send_key_args),
   (xdrproc_t)xdr_remote_domain_send_key_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method NodeGetCPUStats => 227 */
   remoteDispatchNodeGetCPUStatsHelper,
   sizeof(remote_node_get_cpu_stats_args),
   (xdrproc_t)xdr_remote_node_get_cpu_stats_args,
   sizeof(remote_node_get_cpu_stats_ret),
   (xdrproc_t)xdr_remote_node_get_cpu_stats_ret,
   true,
   1
},
{ /* Method NodeGetMemoryStats => 228 */
   remoteDispatchNodeGetMemoryStatsHelper,
   sizeof(remote_node_get_memory_stats_args),
   (xdrproc_t)xdr_remote_node_get_memory_stats_args,
   sizeof(remote_node_get_memory_stats_ret),
   (xdrproc_t)xdr_remote_node_get_memory_stats_ret,
   true,
   1
},
{ /* Method DomainGetControlInfo => 229 */
   remoteDispatchDomainGetControlInfoHelper,
   sizeof(remote_domain_get_control_info_args),
   (xdrproc_t)xdr_remote_domain_get_control_info_args,
   sizeof(remote_domain_get_control_info_ret),
   (xdrproc_t)xdr_remote_domain_get_control_info_ret,
   true,
   1
},
{ /* Method DomainGetVcpuPinInfo => 230 */
   remoteDispatchDomainGetVcpuPinInfoHelper,
   sizeof(remote_domain_get_vcpu_pin_info_args),
   (xdrproc_t)xdr_remote_domain_get_vcpu_pin_info_args,
   sizeof(remote_domain_get_vcpu_pin_info_ret),
   (xdrproc_t)xdr_remote_domain_get_vcpu_pin_info_ret,
   true,
   0
},
{ /* Method DomainUndefineFlags => 231 */
   remoteDispatchDomainUndefineFlagsHelper,
   sizeof(remote_domain_undefine_flags_args),
   (xdrproc_t)xdr_remote_domain_undefine_flags_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method DomainSaveFlags => 232 */
   remoteDispatchDomainSaveFlagsHelper,
   sizeof(remote_domain_save_flags_args),
   (xdrproc_t)xdr_remote_domain_save_flags_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainRestoreFlags => 233 */
   remoteDispatchDomainRestoreFlagsHelper,
   sizeof(remote_domain_restore_flags_args),
   (xdrproc_t)xdr_remote_domain_restore_flags_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainDestroyFlags => 234 */
   remoteDispatchDomainDestroyFlagsHelper,
   sizeof(remote_domain_destroy_flags_args),
   (xdrproc_t)xdr_remote_domain_destroy_flags_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method DomainSaveImageGetXMLDesc => 235 */
   remoteDispatchDomainSaveImageGetXMLDescHelper,
   sizeof(remote_domain_save_image_get_xml_desc_args),
   (xdrproc_t)xdr_remote_domain_save_image_get_xml_desc_args,
   sizeof(remote_domain_save_image_get_xml_desc_ret),
   (xdrproc_t)xdr_remote_domain_save_image_get_xml_desc_ret,
   true,
   1
},
{ /* Method DomainSaveImageDefineXML => 236 */
   remoteDispatchDomainSaveImageDefineXMLHelper,
   sizeof(remote_domain_save_image_define_xml_args),
   (xdrproc_t)xdr_remote_domain_save_image_define_xml_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method DomainBlockJobAbort => 237 */
   remoteDispatchDomainBlockJobAbortHelper,
   sizeof(remote_domain_block_job_abort_args),
   (xdrproc_t)xdr_remote_domain_block_job_abort_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainGetBlockJobInfo => 238 */
   remoteDispatchDomainGetBlockJobInfoHelper,
   sizeof(remote_domain_get_block_job_info_args),
   (xdrproc_t)xdr_remote_domain_get_block_job_info_args,
   sizeof(remote_domain_get_block_job_info_ret),
   (xdrproc_t)xdr_remote_domain_get_block_job_info_ret,
   true,
   0
},
{ /* Method DomainBlockJobSetSpeed => 239 */
   remoteDispatchDomainBlockJobSetSpeedHelper,
   sizeof(remote_domain_block_job_set_speed_args),
   (xdrproc_t)xdr_remote_domain_block_job_set_speed_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainBlockPull => 240 */
   remoteDispatchDomainBlockPullHelper,
   sizeof(remote_domain_block_pull_args),
   (xdrproc_t)xdr_remote_domain_block_pull_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventBlockJob => 241 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainMigrateGetMaxSpeed => 242 */
   remoteDispatchDomainMigrateGetMaxSpeedHelper,
   sizeof(remote_domain_migrate_get_max_speed_args),
   (xdrproc_t)xdr_remote_domain_migrate_get_max_speed_args,
   sizeof(remote_domain_migrate_get_max_speed_ret),
   (xdrproc_t)xdr_remote_domain_migrate_get_max_speed_ret,
   true,
   0
},
{ /* Method DomainBlockStatsFlags => 243 */
   remoteDispatchDomainBlockStatsFlagsHelper,
   sizeof(remote_domain_block_stats_flags_args),
   (xdrproc_t)xdr_remote_domain_block_stats_flags_args,
   sizeof(remote_domain_block_stats_flags_ret),
   (xdrproc_t)xdr_remote_domain_block_stats_flags_ret,
   true,
   0
},
{ /* Method DomainSnapshotGetParent => 244 */
   remoteDispatchDomainSnapshotGetParentHelper,
   sizeof(remote_domain_snapshot_get_parent_args),
   (xdrproc_t)xdr_remote_domain_snapshot_get_parent_args,
   sizeof(remote_domain_snapshot_get_parent_ret),
   (xdrproc_t)xdr_remote_domain_snapshot_get_parent_ret,
   true,
   1
},
{ /* Method DomainReset => 245 */
   remoteDispatchDomainResetHelper,
   sizeof(remote_domain_reset_args),
   (xdrproc_t)xdr_remote_domain_reset_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainSnapshotNumChildren => 246 */
   remoteDispatchDomainSnapshotNumChildrenHelper,
   sizeof(remote_domain_snapshot_num_children_args),
   (xdrproc_t)xdr_remote_domain_snapshot_num_children_args,
   sizeof(remote_domain_snapshot_num_children_ret),
   (xdrproc_t)xdr_remote_domain_snapshot_num_children_ret,
   true,
   1
},
{ /* Method DomainSnapshotListChildrenNames => 247 */
   remoteDispatchDomainSnapshotListChildrenNamesHelper,
   sizeof(remote_domain_snapshot_list_children_names_args),
   (xdrproc_t)xdr_remote_domain_snapshot_list_children_names_args,
   sizeof(remote_domain_snapshot_list_children_names_ret),
   (xdrproc_t)xdr_remote_domain_snapshot_list_children_names_ret,
   true,
   1
},
{ /* Async event DomainEventDiskChange => 248 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainOpenGraphics => 249 */
   remoteDispatchDomainOpenGraphicsHelper,
   sizeof(remote_domain_open_graphics_args),
   (xdrproc_t)xdr_remote_domain_open_graphics_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method NodeSuspendForDuration => 250 */
   remoteDispatchNodeSuspendForDurationHelper,
   sizeof(remote_node_suspend_for_duration_args),
   (xdrproc_t)xdr_remote_node_suspend_for_duration_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainBlockResize => 251 */
   remoteDispatchDomainBlockResizeHelper,
   sizeof(remote_domain_block_resize_args),
   (xdrproc_t)xdr_remote_domain_block_resize_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainSetBlockIoTune => 252 */
   remoteDispatchDomainSetBlockIoTuneHelper,
   sizeof(remote_domain_set_block_io_tune_args),
   (xdrproc_t)xdr_remote_domain_set_block_io_tune_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainGetBlockIoTune => 253 */
   remoteDispatchDomainGetBlockIoTuneHelper,
   sizeof(remote_domain_get_block_io_tune_args),
   (xdrproc_t)xdr_remote_domain_get_block_io_tune_args,
   sizeof(remote_domain_get_block_io_tune_ret),
   (xdrproc_t)xdr_remote_domain_get_block_io_tune_ret,
   true,
   0
},
{ /* Method DomainSetNumaParameters => 254 */
   remoteDispatchDomainSetNumaParametersHelper,
   sizeof(remote_domain_set_numa_parameters_args),
   (xdrproc_t)xdr_remote_domain_set_numa_parameters_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainGetNumaParameters => 255 */
   remoteDispatchDomainGetNumaParametersHelper,
   sizeof(remote_domain_get_numa_parameters_args),
   (xdrproc_t)xdr_remote_domain_get_numa_parameters_args,
   sizeof(remote_domain_get_numa_parameters_ret),
   (xdrproc_t)xdr_remote_domain_get_numa_parameters_ret,
   true,
   0
},
{ /* Method DomainSetInterfaceParameters => 256 */
   remoteDispatchDomainSetInterfaceParametersHelper,
   sizeof(remote_domain_set_interface_parameters_args),
   (xdrproc_t)xdr_remote_domain_set_interface_parameters_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainGetInterfaceParameters => 257 */
   remoteDispatchDomainGetInterfaceParametersHelper,
   sizeof(remote_domain_get_interface_parameters_args),
   (xdrproc_t)xdr_remote_domain_get_interface_parameters_args,
   sizeof(remote_domain_get_interface_parameters_ret),
   (xdrproc_t)xdr_remote_domain_get_interface_parameters_ret,
   true,
   0
},
{ /* Method DomainShutdownFlags => 258 */
   remoteDispatchDomainShutdownFlagsHelper,
   sizeof(remote_domain_shutdown_flags_args),
   (xdrproc_t)xdr_remote_domain_shutdown_flags_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method StorageVolWipePattern => 259 */
   remoteDispatchStorageVolWipePatternHelper,
   sizeof(remote_storage_vol_wipe_pattern_args),
   (xdrproc_t)xdr_remote_storage_vol_wipe_pattern_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method StorageVolResize => 260 */
   remoteDispatchStorageVolResizeHelper,
   sizeof(remote_storage_vol_resize_args),
   (xdrproc_t)xdr_remote_storage_vol_resize_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainPMSuspendForDuration => 261 */
   remoteDispatchDomainPMSuspendForDurationHelper,
   sizeof(remote_domain_pm_suspend_for_duration_args),
   (xdrproc_t)xdr_remote_domain_pm_suspend_for_duration_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainGetCPUStats => 262 */
   remoteDispatchDomainGetCPUStatsHelper,
   sizeof(remote_domain_get_cpu_stats_args),
   (xdrproc_t)xdr_remote_domain_get_cpu_stats_args,
   sizeof(remote_domain_get_cpu_stats_ret),
   (xdrproc_t)xdr_remote_domain_get_cpu_stats_ret,
   true,
   0
},
{ /* Method DomainGetDiskErrors => 263 */
   remoteDispatchDomainGetDiskErrorsHelper,
   sizeof(remote_domain_get_disk_errors_args),
   (xdrproc_t)xdr_remote_domain_get_disk_errors_args,
   sizeof(remote_domain_get_disk_errors_ret),
   (xdrproc_t)xdr_remote_domain_get_disk_errors_ret,
   true,
   0
},
{ /* Method DomainSetMetadata => 264 */
   remoteDispatchDomainSetMetadataHelper,
   sizeof(remote_domain_set_metadata_args),
   (xdrproc_t)xdr_remote_domain_set_metadata_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainGetMetadata => 265 */
   remoteDispatchDomainGetMetadataHelper,
   sizeof(remote_domain_get_metadata_args),
   (xdrproc_t)xdr_remote_domain_get_metadata_args,
   sizeof(remote_domain_get_metadata_ret),
   (xdrproc_t)xdr_remote_domain_get_metadata_ret,
   true,
   0
},
{ /* Method DomainBlockRebase => 266 */
   remoteDispatchDomainBlockRebaseHelper,
   sizeof(remote_domain_block_rebase_args),
   (xdrproc_t)xdr_remote_domain_block_rebase_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainPMWakeup => 267 */
   remoteDispatchDomainPMWakeupHelper,
   sizeof(remote_domain_pm_wakeup_args),
   (xdrproc_t)xdr_remote_domain_pm_wakeup_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventTrayChange => 268 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventPMwakeup => 269 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventPMsuspend => 270 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainSnapshotIsCurrent => 271 */
   remoteDispatchDomainSnapshotIsCurrentHelper,
   sizeof(remote_domain_snapshot_is_current_args),
   (xdrproc_t)xdr_remote_domain_snapshot_is_current_args,
   sizeof(remote_domain_snapshot_is_current_ret),
   (xdrproc_t)xdr_remote_domain_snapshot_is_current_ret,
   true,
   0
},
{ /* Method DomainSnapshotHasMetadata => 272 */
   remoteDispatchDomainSnapshotHasMetadataHelper,
   sizeof(remote_domain_snapshot_has_metadata_args),
   (xdrproc_t)xdr_remote_domain_snapshot_has_metadata_args,
   sizeof(remote_domain_snapshot_has_metadata_ret),
   (xdrproc_t)xdr_remote_domain_snapshot_has_metadata_ret,
   true,
   0
},
{ /* Method ConnectListAllDomains => 273 */
   remoteDispatchConnectListAllDomainsHelper,
   sizeof(remote_connect_list_all_domains_args),
   (xdrproc_t)xdr_remote_connect_list_all_domains_args,
   sizeof(remote_connect_list_all_domains_ret),
   (xdrproc_t)xdr_remote_connect_list_all_domains_ret,
   true,
   1
},
{ /* Method DomainListAllSnapshots => 274 */
   remoteDispatchDomainListAllSnapshotsHelper,
   sizeof(remote_domain_list_all_snapshots_args),
   (xdrproc_t)xdr_remote_domain_list_all_snapshots_args,
   sizeof(remote_domain_list_all_snapshots_ret),
   (xdrproc_t)xdr_remote_domain_list_all_snapshots_ret,
   true,
   1
},
{ /* Method DomainSnapshotListAllChildren => 275 */
   remoteDispatchDomainSnapshotListAllChildrenHelper,
   sizeof(remote_domain_snapshot_list_all_children_args),
   (xdrproc_t)xdr_remote_domain_snapshot_list_all_children_args,
   sizeof(remote_domain_snapshot_list_all_children_ret),
   (xdrproc_t)xdr_remote_domain_snapshot_list_all_children_ret,
   true,
   1
},
{ /* Async event DomainEventBalloonChange => 276 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainGetHostname => 277 */
   remoteDispatchDomainGetHostnameHelper,
   sizeof(remote_domain_get_hostname_args),
   (xdrproc_t)xdr_remote_domain_get_hostname_args,
   sizeof(remote_domain_get_hostname_ret),
   (xdrproc_t)xdr_remote_domain_get_hostname_ret,
   true,
   0
},
{ /* Method DomainGetSecurityLabelList => 278 */
   remoteDispatchDomainGetSecurityLabelListHelper,
   sizeof(remote_domain_get_security_label_list_args),
   (xdrproc_t)xdr_remote_domain_get_security_label_list_args,
   sizeof(remote_domain_get_security_label_list_ret),
   (xdrproc_t)xdr_remote_domain_get_security_label_list_ret,
   true,
   1
},
{ /* Method DomainPinEmulator => 279 */
   remoteDispatchDomainPinEmulatorHelper,
   sizeof(remote_domain_pin_emulator_args),
   (xdrproc_t)xdr_remote_domain_pin_emulator_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainGetEmulatorPinInfo => 280 */
   remoteDispatchDomainGetEmulatorPinInfoHelper,
   sizeof(remote_domain_get_emulator_pin_info_args),
   (xdrproc_t)xdr_remote_domain_get_emulator_pin_info_args,
   sizeof(remote_domain_get_emulator_pin_info_ret),
   (xdrproc_t)xdr_remote_domain_get_emulator_pin_info_ret,
   true,
   0
},
{ /* Method ConnectListAllStoragePools => 281 */
   remoteDispatchConnectListAllStoragePoolsHelper,
   sizeof(remote_connect_list_all_storage_pools_args),
   (xdrproc_t)xdr_remote_connect_list_all_storage_pools_args,
   sizeof(remote_connect_list_all_storage_pools_ret),
   (xdrproc_t)xdr_remote_connect_list_all_storage_pools_ret,
   true,
   1
},
{ /* Method StoragePoolListAllVolumes => 282 */
   remoteDispatchStoragePoolListAllVolumesHelper,
   sizeof(remote_storage_pool_list_all_volumes_args),
   (xdrproc_t)xdr_remote_storage_pool_list_all_volumes_args,
   sizeof(remote_storage_pool_list_all_volumes_ret),
   (xdrproc_t)xdr_remote_storage_pool_list_all_volumes_ret,
   true,
   1
},
{ /* Method ConnectListAllNetworks => 283 */
   remoteDispatchConnectListAllNetworksHelper,
   sizeof(remote_connect_list_all_networks_args),
   (xdrproc_t)xdr_remote_connect_list_all_networks_args,
   sizeof(remote_connect_list_all_networks_ret),
   (xdrproc_t)xdr_remote_connect_list_all_networks_ret,
   true,
   1
},
{ /* Method ConnectListAllInterfaces => 284 */
   remoteDispatchConnectListAllInterfacesHelper,
   sizeof(remote_connect_list_all_interfaces_args),
   (xdrproc_t)xdr_remote_connect_list_all_interfaces_args,
   sizeof(remote_connect_list_all_interfaces_ret),
   (xdrproc_t)xdr_remote_connect_list_all_interfaces_ret,
   true,
   1
},
{ /* Method ConnectListAllNodeDevices => 285 */
   remoteDispatchConnectListAllNodeDevicesHelper,
   sizeof(remote_connect_list_all_node_devices_args),
   (xdrproc_t)xdr_remote_connect_list_all_node_devices_args,
   sizeof(remote_connect_list_all_node_devices_ret),
   (xdrproc_t)xdr_remote_connect_list_all_node_devices_ret,
   true,
   1
},
{ /* Method ConnectListAllNWFilters => 286 */
   remoteDispatchConnectListAllNWFiltersHelper,
   sizeof(remote_connect_list_all_nwfilters_args),
   (xdrproc_t)xdr_remote_connect_list_all_nwfilters_args,
   sizeof(remote_connect_list_all_nwfilters_ret),
   (xdrproc_t)xdr_remote_connect_list_all_nwfilters_ret,
   true,
   1
},
{ /* Method ConnectListAllSecrets => 287 */
   remoteDispatchConnectListAllSecretsHelper,
   sizeof(remote_connect_list_all_secrets_args),
   (xdrproc_t)xdr_remote_connect_list_all_secrets_args,
   sizeof(remote_connect_list_all_secrets_ret),
   (xdrproc_t)xdr_remote_connect_list_all_secrets_ret,
   true,
   1
},
{ /* Method NodeSetMemoryParameters => 288 */
   remoteDispatchNodeSetMemoryParametersHelper,
   sizeof(remote_node_set_memory_parameters_args),
   (xdrproc_t)xdr_remote_node_set_memory_parameters_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method NodeGetMemoryParameters => 289 */
   remoteDispatchNodeGetMemoryParametersHelper,
   sizeof(remote_node_get_memory_parameters_args),
   (xdrproc_t)xdr_remote_node_get_memory_parameters_args,
   sizeof(remote_node_get_memory_parameters_ret),
   (xdrproc_t)xdr_remote_node_get_memory_parameters_ret,
   true,
   0
},
{ /* Method DomainBlockCommit => 290 */
   remoteDispatchDomainBlockCommitHelper,
   sizeof(remote_domain_block_commit_args),
   (xdrproc_t)xdr_remote_domain_block_commit_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method NetworkUpdate => 291 */
   remoteDispatchNetworkUpdateHelper,
   sizeof(remote_network_update_args),
   (xdrproc_t)xdr_remote_network_update_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Async event DomainEventPMsuspendDisk => 292 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method NodeGetCPUMap => 293 */
   remoteDispatchNodeGetCPUMapHelper,
   sizeof(remote_node_get_cpu_map_args),
   (xdrproc_t)xdr_remote_node_get_cpu_map_args,
   sizeof(remote_node_get_cpu_map_ret),
   (xdrproc_t)xdr_remote_node_get_cpu_map_ret,
   true,
   0
},
{ /* Method DomainFSTrim => 294 */
   remoteDispatchDomainFSTrimHelper,
   sizeof(remote_domain_fstrim_args),
   (xdrproc_t)xdr_remote_domain_fstrim_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainSendProcessSignal => 295 */
   remoteDispatchDomainSendProcessSignalHelper,
   sizeof(remote_domain_send_process_signal_args),
   (xdrproc_t)xdr_remote_domain_send_process_signal_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainOpenChannel => 296 */
   remoteDispatchDomainOpenChannelHelper,
   sizeof(remote_domain_open_channel_args),
   (xdrproc_t)xdr_remote_domain_open_channel_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method NodeDeviceLookupSCSIHostByWWN => 297 */
   remoteDispatchNodeDeviceLookupSCSIHostByWWNHelper,
   sizeof(remote_node_device_lookup_scsi_host_by_wwn_args),
   (xdrproc_t)xdr_remote_node_device_lookup_scsi_host_by_wwn_args,
   sizeof(remote_node_device_lookup_scsi_host_by_wwn_ret),
   (xdrproc_t)xdr_remote_node_device_lookup_scsi_host_by_wwn_ret,
   true,
   1
},
{ /* Method DomainGetJobStats => 298 */
   remoteDispatchDomainGetJobStatsHelper,
   sizeof(remote_domain_get_job_stats_args),
   (xdrproc_t)xdr_remote_domain_get_job_stats_args,
   sizeof(remote_domain_get_job_stats_ret),
   (xdrproc_t)xdr_remote_domain_get_job_stats_ret,
   true,
   0
},
{ /* Method DomainMigrateGetCompressionCache => 299 */
   remoteDispatchDomainMigrateGetCompressionCacheHelper,
   sizeof(remote_domain_migrate_get_compression_cache_args),
   (xdrproc_t)xdr_remote_domain_migrate_get_compression_cache_args,
   sizeof(remote_domain_migrate_get_compression_cache_ret),
   (xdrproc_t)xdr_remote_domain_migrate_get_compression_cache_ret,
   true,
   0
},
{ /* Method DomainMigrateSetCompressionCache => 300 */
   remoteDispatchDomainMigrateSetCompressionCacheHelper,
   sizeof(remote_domain_migrate_set_compression_cache_args),
   (xdrproc_t)xdr_remote_domain_migrate_set_compression_cache_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method NodeDeviceDetachFlags => 301 */
   remoteDispatchNodeDeviceDetachFlagsHelper,
   sizeof(remote_node_device_detach_flags_args),
   (xdrproc_t)xdr_remote_node_device_detach_flags_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainMigrateBegin3Params => 302 */
   remoteDispatchDomainMigrateBegin3ParamsHelper,
   sizeof(remote_domain_migrate_begin3_params_args),
   (xdrproc_t)xdr_remote_domain_migrate_begin3_params_args,
   sizeof(remote_domain_migrate_begin3_params_ret),
   (xdrproc_t)xdr_remote_domain_migrate_begin3_params_ret,
   true,
   0
},
{ /* Method DomainMigratePrepare3Params => 303 */
   remoteDispatchDomainMigratePrepare3ParamsHelper,
   sizeof(remote_domain_migrate_prepare3_params_args),
   (xdrproc_t)xdr_remote_domain_migrate_prepare3_params_args,
   sizeof(remote_domain_migrate_prepare3_params_ret),
   (xdrproc_t)xdr_remote_domain_migrate_prepare3_params_ret,
   true,
   0
},
{ /* Method DomainMigratePrepareTunnel3Params => 304 */
   remoteDispatchDomainMigratePrepareTunnel3ParamsHelper,
   sizeof(remote_domain_migrate_prepare_tunnel3_params_args),
   (xdrproc_t)xdr_remote_domain_migrate_prepare_tunnel3_params_args,
   sizeof(remote_domain_migrate_prepare_tunnel3_params_ret),
   (xdrproc_t)xdr_remote_domain_migrate_prepare_tunnel3_params_ret,
   true,
   0
},
{ /* Method DomainMigratePerform3Params => 305 */
   remoteDispatchDomainMigratePerform3ParamsHelper,
   sizeof(remote_domain_migrate_perform3_params_args),
   (xdrproc_t)xdr_remote_domain_migrate_perform3_params_args,
   sizeof(remote_domain_migrate_perform3_params_ret),
   (xdrproc_t)xdr_remote_domain_migrate_perform3_params_ret,
   true,
   0
},
{ /* Method DomainMigrateFinish3Params => 306 */
   remoteDispatchDomainMigrateFinish3ParamsHelper,
   sizeof(remote_domain_migrate_finish3_params_args),
   (xdrproc_t)xdr_remote_domain_migrate_finish3_params_args,
   sizeof(remote_domain_migrate_finish3_params_ret),
   (xdrproc_t)xdr_remote_domain_migrate_finish3_params_ret,
   true,
   0
},
{ /* Method DomainMigrateConfirm3Params => 307 */
   remoteDispatchDomainMigrateConfirm3ParamsHelper,
   sizeof(remote_domain_migrate_confirm3_params_args),
   (xdrproc_t)xdr_remote_domain_migrate_confirm3_params_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainSetMemoryStatsPeriod => 308 */
   remoteDispatchDomainSetMemoryStatsPeriodHelper,
   sizeof(remote_domain_set_memory_stats_period_args),
   (xdrproc_t)xdr_remote_domain_set_memory_stats_period_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainCreateXMLWithFiles => 309 */
   remoteDispatchDomainCreateXMLWithFilesHelper,
   sizeof(remote_domain_create_xml_with_files_args),
   (xdrproc_t)xdr_remote_domain_create_xml_with_files_args,
   sizeof(remote_domain_create_xml_with_files_ret),
   (xdrproc_t)xdr_remote_domain_create_xml_with_files_ret,
   true,
   0
},
{ /* Method DomainCreateWithFiles => 310 */
   remoteDispatchDomainCreateWithFilesHelper,
   sizeof(remote_domain_create_with_files_args),
   (xdrproc_t)xdr_remote_domain_create_with_files_args,
   sizeof(remote_domain_create_with_files_ret),
   (xdrproc_t)xdr_remote_domain_create_with_files_ret,
   true,
   0
},
{ /* Async event DomainEventDeviceRemoved => 311 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method ConnectGetCPUModelNames => 312 */
   remoteDispatchConnectGetCPUModelNamesHelper,
   sizeof(remote_connect_get_cpu_model_names_args),
   (xdrproc_t)xdr_remote_connect_get_cpu_model_names_args,
   sizeof(remote_connect_get_cpu_model_names_ret),
   (xdrproc_t)xdr_remote_connect_get_cpu_model_names_ret,
   true,
   0
},
{ /* Method ConnectNetworkEventRegisterAny => 313 */
   remoteDispatchConnectNetworkEventRegisterAnyHelper,
   sizeof(remote_connect_network_event_register_any_args),
   (xdrproc_t)xdr_remote_connect_network_event_register_any_args,
   sizeof(remote_connect_network_event_register_any_ret),
   (xdrproc_t)xdr_remote_connect_network_event_register_any_ret,
   true,
   1
},
{ /* Method ConnectNetworkEventDeregisterAny => 314 */
   remoteDispatchConnectNetworkEventDeregisterAnyHelper,
   sizeof(remote_connect_network_event_deregister_any_args),
   (xdrproc_t)xdr_remote_connect_network_event_deregister_any_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Async event NetworkEventLifecycle => 315 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method ConnectDomainEventCallbackRegisterAny => 316 */
   remoteDispatchConnectDomainEventCallbackRegisterAnyHelper,
   sizeof(remote_connect_domain_event_callback_register_any_args),
   (xdrproc_t)xdr_remote_connect_domain_event_callback_register_any_args,
   sizeof(remote_connect_domain_event_callback_register_any_ret),
   (xdrproc_t)xdr_remote_connect_domain_event_callback_register_any_ret,
   true,
   1
},
{ /* Method ConnectDomainEventCallbackDeregisterAny => 317 */
   remoteDispatchConnectDomainEventCallbackDeregisterAnyHelper,
   sizeof(remote_connect_domain_event_callback_deregister_any_args),
   (xdrproc_t)xdr_remote_connect_domain_event_callback_deregister_any_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Async event DomainEventCallbackLifecycle => 318 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventCallbackReboot => 319 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventCallbackRtcChange => 320 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventCallbackWatchdog => 321 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventCallbackIoError => 322 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventCallbackGraphics => 323 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventCallbackIoErrorReason => 324 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventCallbackControlError => 325 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventCallbackBlockJob => 326 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventCallbackDiskChange => 327 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventCallbackTrayChange => 328 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventCallbackPMwakeup => 329 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventCallbackPMsuspend => 330 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventCallbackBalloonChange => 331 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventCallbackPMsuspendDisk => 332 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventCallbackDeviceRemoved => 333 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainCoreDumpWithFormat => 334 */
   remoteDispatchDomainCoreDumpWithFormatHelper,
   sizeof(remote_domain_core_dump_with_format_args),
   (xdrproc_t)xdr_remote_domain_core_dump_with_format_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainFSFreeze => 335 */
   remoteDispatchDomainFSFreezeHelper,
   sizeof(remote_domain_fsfreeze_args),
   (xdrproc_t)xdr_remote_domain_fsfreeze_args,
   sizeof(remote_domain_fsfreeze_ret),
   (xdrproc_t)xdr_remote_domain_fsfreeze_ret,
   true,
   0
},
{ /* Method DomainFSThaw => 336 */
   remoteDispatchDomainFSThawHelper,
   sizeof(remote_domain_fsthaw_args),
   (xdrproc_t)xdr_remote_domain_fsthaw_args,
   sizeof(remote_domain_fsthaw_ret),
   (xdrproc_t)xdr_remote_domain_fsthaw_ret,
   true,
   0
},
{ /* Method DomainGetTime => 337 */
   remoteDispatchDomainGetTimeHelper,
   sizeof(remote_domain_get_time_args),
   (xdrproc_t)xdr_remote_domain_get_time_args,
   sizeof(remote_domain_get_time_ret),
   (xdrproc_t)xdr_remote_domain_get_time_ret,
   true,
   0
},
{ /* Method DomainSetTime => 338 */
   remoteDispatchDomainSetTimeHelper,
   sizeof(remote_domain_set_time_args),
   (xdrproc_t)xdr_remote_domain_set_time_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventBlockJob2 => 339 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method NodeGetFreePages => 340 */
   remoteDispatchNodeGetFreePagesHelper,
   sizeof(remote_node_get_free_pages_args),
   (xdrproc_t)xdr_remote_node_get_free_pages_args,
   sizeof(remote_node_get_free_pages_ret),
   (xdrproc_t)xdr_remote_node_get_free_pages_ret,
   true,
   1
},
{ /* Method NetworkGetDHCPLeases => 341 */
   remoteDispatchNetworkGetDHCPLeasesHelper,
   sizeof(remote_network_get_dhcp_leases_args),
   (xdrproc_t)xdr_remote_network_get_dhcp_leases_args,
   sizeof(remote_network_get_dhcp_leases_ret),
   (xdrproc_t)xdr_remote_network_get_dhcp_leases_ret,
   true,
   0
},
{ /* Method ConnectGetDomainCapabilities => 342 */
   remoteDispatchConnectGetDomainCapabilitiesHelper,
   sizeof(remote_connect_get_domain_capabilities_args),
   (xdrproc_t)xdr_remote_connect_get_domain_capabilities_args,
   sizeof(remote_connect_get_domain_capabilities_ret),
   (xdrproc_t)xdr_remote_connect_get_domain_capabilities_ret,
   true,
   0
},
{ /* Method DomainOpenGraphicsFd => 343 */
   remoteDispatchDomainOpenGraphicsFdHelper,
   sizeof(remote_domain_open_graphics_fd_args),
   (xdrproc_t)xdr_remote_domain_open_graphics_fd_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method ConnectGetAllDomainStats => 344 */
   remoteDispatchConnectGetAllDomainStatsHelper,
   sizeof(remote_connect_get_all_domain_stats_args),
   (xdrproc_t)xdr_remote_connect_get_all_domain_stats_args,
   sizeof(remote_connect_get_all_domain_stats_ret),
   (xdrproc_t)xdr_remote_connect_get_all_domain_stats_ret,
   true,
   0
},
{ /* Method DomainBlockCopy => 345 */
   remoteDispatchDomainBlockCopyHelper,
   sizeof(remote_domain_block_copy_args),
   (xdrproc_t)xdr_remote_domain_block_copy_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventCallbackTunable => 346 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method NodeAllocPages => 347 */
   remoteDispatchNodeAllocPagesHelper,
   sizeof(remote_node_alloc_pages_args),
   (xdrproc_t)xdr_remote_node_alloc_pages_args,
   sizeof(remote_node_alloc_pages_ret),
   (xdrproc_t)xdr_remote_node_alloc_pages_ret,
   true,
   0
},
{ /* Async event DomainEventCallbackAgentLifecycle => 348 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainGetFSInfo => 349 */
   remoteDispatchDomainGetFSInfoHelper,
   sizeof(remote_domain_get_fsinfo_args),
   (xdrproc_t)xdr_remote_domain_get_fsinfo_args,
   sizeof(remote_domain_get_fsinfo_ret),
   (xdrproc_t)xdr_remote_domain_get_fsinfo_ret,
   true,
   0
},
{ /* Method DomainDefineXMLFlags => 350 */
   remoteDispatchDomainDefineXMLFlagsHelper,
   sizeof(remote_domain_define_xml_flags_args),
   (xdrproc_t)xdr_remote_domain_define_xml_flags_args,
   sizeof(remote_domain_define_xml_flags_ret),
   (xdrproc_t)xdr_remote_domain_define_xml_flags_ret,
   true,
   1
},
{ /* Method DomainGetIOThreadInfo => 351 */
   remoteDispatchDomainGetIOThreadInfoHelper,
   sizeof(remote_domain_get_iothread_info_args),
   (xdrproc_t)xdr_remote_domain_get_iothread_info_args,
   sizeof(remote_domain_get_iothread_info_ret),
   (xdrproc_t)xdr_remote_domain_get_iothread_info_ret,
   true,
   0
},
{ /* Method DomainPinIOThread => 352 */
   remoteDispatchDomainPinIOThreadHelper,
   sizeof(remote_domain_pin_iothread_args),
   (xdrproc_t)xdr_remote_domain_pin_iothread_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainInterfaceAddresses => 353 */
   remoteDispatchDomainInterfaceAddressesHelper,
   sizeof(remote_domain_interface_addresses_args),
   (xdrproc_t)xdr_remote_domain_interface_addresses_args,
   sizeof(remote_domain_interface_addresses_ret),
   (xdrproc_t)xdr_remote_domain_interface_addresses_ret,
   true,
   0
},
{ /* Async event DomainEventCallbackDeviceAdded => 354 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainAddIOThread => 355 */
   remoteDispatchDomainAddIOThreadHelper,
   sizeof(remote_domain_add_iothread_args),
   (xdrproc_t)xdr_remote_domain_add_iothread_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainDelIOThread => 356 */
   remoteDispatchDomainDelIOThreadHelper,
   sizeof(remote_domain_del_iothread_args),
   (xdrproc_t)xdr_remote_domain_del_iothread_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainSetUserPassword => 357 */
   remoteDispatchDomainSetUserPasswordHelper,
   sizeof(remote_domain_set_user_password_args),
   (xdrproc_t)xdr_remote_domain_set_user_password_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainRename => 358 */
   remoteDispatchDomainRenameHelper,
   sizeof(remote_domain_rename_args),
   (xdrproc_t)xdr_remote_domain_rename_args,
   sizeof(remote_domain_rename_ret),
   (xdrproc_t)xdr_remote_domain_rename_ret,
   true,
   0
},
{ /* Async event DomainEventCallbackMigrationIteration => 359 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method ConnectRegisterCloseCallback => 360 */
   remoteDispatchConnectRegisterCloseCallbackHelper,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method ConnectUnregisterCloseCallback => 361 */
   remoteDispatchConnectUnregisterCloseCallbackHelper,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Async event ConnectEventConnectionClosed => 362 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventCallbackJobCompleted => 363 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainMigrateStartPostCopy => 364 */
   remoteDispatchDomainMigrateStartPostCopyHelper,
   sizeof(remote_domain_migrate_start_post_copy_args),
   (xdrproc_t)xdr_remote_domain_migrate_start_post_copy_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainGetPerfEvents => 365 */
   remoteDispatchDomainGetPerfEventsHelper,
   sizeof(remote_domain_get_perf_events_args),
   (xdrproc_t)xdr_remote_domain_get_perf_events_args,
   sizeof(remote_domain_get_perf_events_ret),
   (xdrproc_t)xdr_remote_domain_get_perf_events_ret,
   true,
   0
},
{ /* Method DomainSetPerfEvents => 366 */
   remoteDispatchDomainSetPerfEventsHelper,
   sizeof(remote_domain_set_perf_events_args),
   (xdrproc_t)xdr_remote_domain_set_perf_events_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventCallbackDeviceRemovalFailed => 367 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method ConnectStoragePoolEventRegisterAny => 368 */
   remoteDispatchConnectStoragePoolEventRegisterAnyHelper,
   sizeof(remote_connect_storage_pool_event_register_any_args),
   (xdrproc_t)xdr_remote_connect_storage_pool_event_register_any_args,
   sizeof(remote_connect_storage_pool_event_register_any_ret),
   (xdrproc_t)xdr_remote_connect_storage_pool_event_register_any_ret,
   true,
   1
},
{ /* Method ConnectStoragePoolEventDeregisterAny => 369 */
   remoteDispatchConnectStoragePoolEventDeregisterAnyHelper,
   sizeof(remote_connect_storage_pool_event_deregister_any_args),
   (xdrproc_t)xdr_remote_connect_storage_pool_event_deregister_any_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Async event StoragePoolEventLifecycle => 370 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainGetGuestVcpus => 371 */
   remoteDispatchDomainGetGuestVcpusHelper,
   sizeof(remote_domain_get_guest_vcpus_args),
   (xdrproc_t)xdr_remote_domain_get_guest_vcpus_args,
   sizeof(remote_domain_get_guest_vcpus_ret),
   (xdrproc_t)xdr_remote_domain_get_guest_vcpus_ret,
   true,
   0
},
{ /* Method DomainSetGuestVcpus => 372 */
   remoteDispatchDomainSetGuestVcpusHelper,
   sizeof(remote_domain_set_guest_vcpus_args),
   (xdrproc_t)xdr_remote_domain_set_guest_vcpus_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event StoragePoolEventRefresh => 373 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method ConnectNodeDeviceEventRegisterAny => 374 */
   remoteDispatchConnectNodeDeviceEventRegisterAnyHelper,
   sizeof(remote_connect_node_device_event_register_any_args),
   (xdrproc_t)xdr_remote_connect_node_device_event_register_any_args,
   sizeof(remote_connect_node_device_event_register_any_ret),
   (xdrproc_t)xdr_remote_connect_node_device_event_register_any_ret,
   true,
   1
},
{ /* Method ConnectNodeDeviceEventDeregisterAny => 375 */
   remoteDispatchConnectNodeDeviceEventDeregisterAnyHelper,
   sizeof(remote_connect_node_device_event_deregister_any_args),
   (xdrproc_t)xdr_remote_connect_node_device_event_deregister_any_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Async event NodeDeviceEventLifecycle => 376 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event NodeDeviceEventUpdate => 377 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method StorageVolGetInfoFlags => 378 */
   remoteDispatchStorageVolGetInfoFlagsHelper,
   sizeof(remote_storage_vol_get_info_flags_args),
   (xdrproc_t)xdr_remote_storage_vol_get_info_flags_args,
   sizeof(remote_storage_vol_get_info_flags_ret),
   (xdrproc_t)xdr_remote_storage_vol_get_info_flags_ret,
   true,
   1
},
{ /* Async event DomainEventCallbackMetadataChange => 379 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method ConnectSecretEventRegisterAny => 380 */
   remoteDispatchConnectSecretEventRegisterAnyHelper,
   sizeof(remote_connect_secret_event_register_any_args),
   (xdrproc_t)xdr_remote_connect_secret_event_register_any_args,
   sizeof(remote_connect_secret_event_register_any_ret),
   (xdrproc_t)xdr_remote_connect_secret_event_register_any_ret,
   true,
   1
},
{ /* Method ConnectSecretEventDeregisterAny => 381 */
   remoteDispatchConnectSecretEventDeregisterAnyHelper,
   sizeof(remote_connect_secret_event_deregister_any_args),
   (xdrproc_t)xdr_remote_connect_secret_event_deregister_any_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Async event SecretEventLifecycle => 382 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event SecretEventValueChanged => 383 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainSetVcpu => 384 */
   remoteDispatchDomainSetVcpuHelper,
   sizeof(remote_domain_set_vcpu_args),
   (xdrproc_t)xdr_remote_domain_set_vcpu_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventBlockThreshold => 385 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainSetBlockThreshold => 386 */
   remoteDispatchDomainSetBlockThresholdHelper,
   sizeof(remote_domain_set_block_threshold_args),
   (xdrproc_t)xdr_remote_domain_set_block_threshold_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainMigrateGetMaxDowntime => 387 */
   remoteDispatchDomainMigrateGetMaxDowntimeHelper,
   sizeof(remote_domain_migrate_get_max_downtime_args),
   (xdrproc_t)xdr_remote_domain_migrate_get_max_downtime_args,
   sizeof(remote_domain_migrate_get_max_downtime_ret),
   (xdrproc_t)xdr_remote_domain_migrate_get_max_downtime_ret,
   true,
   0
},
{ /* Method DomainManagedSaveGetXMLDesc => 388 */
   remoteDispatchDomainManagedSaveGetXMLDescHelper,
   sizeof(remote_domain_managed_save_get_xml_desc_args),
   (xdrproc_t)xdr_remote_domain_managed_save_get_xml_desc_args,
   sizeof(remote_domain_managed_save_get_xml_desc_ret),
   (xdrproc_t)xdr_remote_domain_managed_save_get_xml_desc_ret,
   true,
   0
},
{ /* Method DomainManagedSaveDefineXML => 389 */
   remoteDispatchDomainManagedSaveDefineXMLHelper,
   sizeof(remote_domain_managed_save_define_xml_args),
   (xdrproc_t)xdr_remote_domain_managed_save_define_xml_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainSetLifecycleAction => 390 */
   remoteDispatchDomainSetLifecycleActionHelper,
   sizeof(remote_domain_set_lifecycle_action_args),
   (xdrproc_t)xdr_remote_domain_set_lifecycle_action_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method StoragePoolLookupByTargetPath => 391 */
   remoteDispatchStoragePoolLookupByTargetPathHelper,
   sizeof(remote_storage_pool_lookup_by_target_path_args),
   (xdrproc_t)xdr_remote_storage_pool_lookup_by_target_path_args,
   sizeof(remote_storage_pool_lookup_by_target_path_ret),
   (xdrproc_t)xdr_remote_storage_pool_lookup_by_target_path_ret,
   true,
   1
},
{ /* Method DomainDetachDeviceAlias => 392 */
   remoteDispatchDomainDetachDeviceAliasHelper,
   sizeof(remote_domain_detach_device_alias_args),
   (xdrproc_t)xdr_remote_domain_detach_device_alias_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method ConnectCompareHypervisorCPU => 393 */
   remoteDispatchConnectCompareHypervisorCPUHelper,
   sizeof(remote_connect_compare_hypervisor_cpu_args),
   (xdrproc_t)xdr_remote_connect_compare_hypervisor_cpu_args,
   sizeof(remote_connect_compare_hypervisor_cpu_ret),
   (xdrproc_t)xdr_remote_connect_compare_hypervisor_cpu_ret,
   true,
   0
},
{ /* Method ConnectBaselineHypervisorCPU => 394 */
   remoteDispatchConnectBaselineHypervisorCPUHelper,
   sizeof(remote_connect_baseline_hypervisor_cpu_args),
   (xdrproc_t)xdr_remote_connect_baseline_hypervisor_cpu_args,
   sizeof(remote_connect_baseline_hypervisor_cpu_ret),
   (xdrproc_t)xdr_remote_connect_baseline_hypervisor_cpu_ret,
   true,
   0
},
{ /* Method NodeGetSevInfo => 395 */
   remoteDispatchNodeGetSevInfoHelper,
   sizeof(remote_node_get_sev_info_args),
   (xdrproc_t)xdr_remote_node_get_sev_info_args,
   sizeof(remote_node_get_sev_info_ret),
   (xdrproc_t)xdr_remote_node_get_sev_info_ret,
   true,
   0
},
{ /* Method DomainGetLaunchSecurityInfo => 396 */
   remoteDispatchDomainGetLaunchSecurityInfoHelper,
   sizeof(remote_domain_get_launch_security_info_args),
   (xdrproc_t)xdr_remote_domain_get_launch_security_info_args,
   sizeof(remote_domain_get_launch_security_info_ret),
   (xdrproc_t)xdr_remote_domain_get_launch_security_info_ret,
   true,
   0
},
{ /* Method NWFilterBindingLookupByPortDev => 397 */
   remoteDispatchNWFilterBindingLookupByPortDevHelper,
   sizeof(remote_nwfilter_binding_lookup_by_port_dev_args),
   (xdrproc_t)xdr_remote_nwfilter_binding_lookup_by_port_dev_args,
   sizeof(remote_nwfilter_binding_lookup_by_port_dev_ret),
   (xdrproc_t)xdr_remote_nwfilter_binding_lookup_by_port_dev_ret,
   true,
   1
},
{ /* Method NWFilterBindingGetXMLDesc => 398 */
   remoteDispatchNWFilterBindingGetXMLDescHelper,
   sizeof(remote_nwfilter_binding_get_xml_desc_args),
   (xdrproc_t)xdr_remote_nwfilter_binding_get_xml_desc_args,
   sizeof(remote_nwfilter_binding_get_xml_desc_ret),
   (xdrproc_t)xdr_remote_nwfilter_binding_get_xml_desc_ret,
   true,
   1
},
{ /* Method NWFilterBindingCreateXML => 399 */
   remoteDispatchNWFilterBindingCreateXMLHelper,
   sizeof(remote_nwfilter_binding_create_xml_args),
   (xdrproc_t)xdr_remote_nwfilter_binding_create_xml_args,
   sizeof(remote_nwfilter_binding_create_xml_ret),
   (xdrproc_t)xdr_remote_nwfilter_binding_create_xml_ret,
   true,
   1
},
{ /* Method NWFilterBindingDelete => 400 */
   remoteDispatchNWFilterBindingDeleteHelper,
   sizeof(remote_nwfilter_binding_delete_args),
   (xdrproc_t)xdr_remote_nwfilter_binding_delete_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method ConnectListAllNWFilterBindings => 401 */
   remoteDispatchConnectListAllNWFilterBindingsHelper,
   sizeof(remote_connect_list_all_nwfilter_bindings_args),
   (xdrproc_t)xdr_remote_connect_list_all_nwfilter_bindings_args,
   sizeof(remote_connect_list_all_nwfilter_bindings_ret),
   (xdrproc_t)xdr_remote_connect_list_all_nwfilter_bindings_ret,
   true,
   1
},
{ /* Method DomainSetIOThreadParams => 402 */
   remoteDispatchDomainSetIOThreadParamsHelper,
   sizeof(remote_domain_set_iothread_params_args),
   (xdrproc_t)xdr_remote_domain_set_iothread_params_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method ConnectGetStoragePoolCapabilities => 403 */
   remoteDispatchConnectGetStoragePoolCapabilitiesHelper,
   sizeof(remote_connect_get_storage_pool_capabilities_args),
   (xdrproc_t)xdr_remote_connect_get_storage_pool_capabilities_args,
   sizeof(remote_connect_get_storage_pool_capabilities_ret),
   (xdrproc_t)xdr_remote_connect_get_storage_pool_capabilities_ret,
   true,
   0
},
{ /* Method NetworkListAllPorts => 404 */
   remoteDispatchNetworkListAllPortsHelper,
   sizeof(remote_network_list_all_ports_args),
   (xdrproc_t)xdr_remote_network_list_all_ports_args,
   sizeof(remote_network_list_all_ports_ret),
   (xdrproc_t)xdr_remote_network_list_all_ports_ret,
   true,
   1
},
{ /* Method NetworkPortLookupByUUID => 405 */
   remoteDispatchNetworkPortLookupByUUIDHelper,
   sizeof(remote_network_port_lookup_by_uuid_args),
   (xdrproc_t)xdr_remote_network_port_lookup_by_uuid_args,
   sizeof(remote_network_port_lookup_by_uuid_ret),
   (xdrproc_t)xdr_remote_network_port_lookup_by_uuid_ret,
   true,
   1
},
{ /* Method NetworkPortCreateXML => 406 */
   remoteDispatchNetworkPortCreateXMLHelper,
   sizeof(remote_network_port_create_xml_args),
   (xdrproc_t)xdr_remote_network_port_create_xml_args,
   sizeof(remote_network_port_create_xml_ret),
   (xdrproc_t)xdr_remote_network_port_create_xml_ret,
   true,
   0
},
{ /* Method NetworkPortGetParameters => 407 */
   remoteDispatchNetworkPortGetParametersHelper,
   sizeof(remote_network_port_get_parameters_args),
   (xdrproc_t)xdr_remote_network_port_get_parameters_args,
   sizeof(remote_network_port_get_parameters_ret),
   (xdrproc_t)xdr_remote_network_port_get_parameters_ret,
   true,
   0
},
{ /* Method NetworkPortSetParameters => 408 */
   remoteDispatchNetworkPortSetParametersHelper,
   sizeof(remote_network_port_set_parameters_args),
   (xdrproc_t)xdr_remote_network_port_set_parameters_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method NetworkPortGetXMLDesc => 409 */
   remoteDispatchNetworkPortGetXMLDescHelper,
   sizeof(remote_network_port_get_xml_desc_args),
   (xdrproc_t)xdr_remote_network_port_get_xml_desc_args,
   sizeof(remote_network_port_get_xml_desc_ret),
   (xdrproc_t)xdr_remote_network_port_get_xml_desc_ret,
   true,
   0
},
{ /* Method NetworkPortDelete => 410 */
   remoteDispatchNetworkPortDeleteHelper,
   sizeof(remote_network_port_delete_args),
   (xdrproc_t)xdr_remote_network_port_delete_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainCheckpointCreateXML => 411 */
   remoteDispatchDomainCheckpointCreateXMLHelper,
   sizeof(remote_domain_checkpoint_create_xml_args),
   (xdrproc_t)xdr_remote_domain_checkpoint_create_xml_args,
   sizeof(remote_domain_checkpoint_create_xml_ret),
   (xdrproc_t)xdr_remote_domain_checkpoint_create_xml_ret,
   true,
   0
},
{ /* Method DomainCheckpointGetXMLDesc => 412 */
   remoteDispatchDomainCheckpointGetXMLDescHelper,
   sizeof(remote_domain_checkpoint_get_xml_desc_args),
   (xdrproc_t)xdr_remote_domain_checkpoint_get_xml_desc_args,
   sizeof(remote_domain_checkpoint_get_xml_desc_ret),
   (xdrproc_t)xdr_remote_domain_checkpoint_get_xml_desc_ret,
   true,
   0
},
{ /* Method DomainListAllCheckpoints => 413 */
   remoteDispatchDomainListAllCheckpointsHelper,
   sizeof(remote_domain_list_all_checkpoints_args),
   (xdrproc_t)xdr_remote_domain_list_all_checkpoints_args,
   sizeof(remote_domain_list_all_checkpoints_ret),
   (xdrproc_t)xdr_remote_domain_list_all_checkpoints_ret,
   true,
   1
},
{ /* Method DomainCheckpointListAllChildren => 414 */
   remoteDispatchDomainCheckpointListAllChildrenHelper,
   sizeof(remote_domain_checkpoint_list_all_children_args),
   (xdrproc_t)xdr_remote_domain_checkpoint_list_all_children_args,
   sizeof(remote_domain_checkpoint_list_all_children_ret),
   (xdrproc_t)xdr_remote_domain_checkpoint_list_all_children_ret,
   true,
   1
},
{ /* Method DomainCheckpointLookupByName => 415 */
   remoteDispatchDomainCheckpointLookupByNameHelper,
   sizeof(remote_domain_checkpoint_lookup_by_name_args),
   (xdrproc_t)xdr_remote_domain_checkpoint_lookup_by_name_args,
   sizeof(remote_domain_checkpoint_lookup_by_name_ret),
   (xdrproc_t)xdr_remote_domain_checkpoint_lookup_by_name_ret,
   true,
   1
},
{ /* Method DomainCheckpointGetParent => 416 */
   remoteDispatchDomainCheckpointGetParentHelper,
   sizeof(remote_domain_checkpoint_get_parent_args),
   (xdrproc_t)xdr_remote_domain_checkpoint_get_parent_args,
   sizeof(remote_domain_checkpoint_get_parent_ret),
   (xdrproc_t)xdr_remote_domain_checkpoint_get_parent_ret,
   true,
   1
},
{ /* Method DomainCheckpointDelete => 417 */
   remoteDispatchDomainCheckpointDeleteHelper,
   sizeof(remote_domain_checkpoint_delete_args),
   (xdrproc_t)xdr_remote_domain_checkpoint_delete_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainGetGuestInfo => 418 */
   remoteDispatchDomainGetGuestInfoHelper,
   sizeof(remote_domain_get_guest_info_args),
   (xdrproc_t)xdr_remote_domain_get_guest_info_args,
   sizeof(remote_domain_get_guest_info_ret),
   (xdrproc_t)xdr_remote_domain_get_guest_info_ret,
   true,
   0
},
{ /* Method ConnectSetIdentity => 419 */
   remoteDispatchConnectSetIdentityHelper,
   sizeof(remote_connect_set_identity_args),
   (xdrproc_t)xdr_remote_connect_set_identity_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainAgentSetResponseTimeout => 420 */
   remoteDispatchDomainAgentSetResponseTimeoutHelper,
   sizeof(remote_domain_agent_set_response_timeout_args),
   (xdrproc_t)xdr_remote_domain_agent_set_response_timeout_args,
   sizeof(remote_domain_agent_set_response_timeout_ret),
   (xdrproc_t)xdr_remote_domain_agent_set_response_timeout_ret,
   true,
   0
},
{ /* Method DomainBackupBegin => 421 */
   remoteDispatchDomainBackupBeginHelper,
   sizeof(remote_domain_backup_begin_args),
   (xdrproc_t)xdr_remote_domain_backup_begin_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainBackupGetXMLDesc => 422 */
   remoteDispatchDomainBackupGetXMLDescHelper,
   sizeof(remote_domain_backup_get_xml_desc_args),
   (xdrproc_t)xdr_remote_domain_backup_get_xml_desc_args,
   sizeof(remote_domain_backup_get_xml_desc_ret),
   (xdrproc_t)xdr_remote_domain_backup_get_xml_desc_ret,
   true,
   1
},
{ /* Async event DomainEventMemoryFailure => 423 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainAuthorizedSshKeysGet => 424 */
   remoteDispatchDomainAuthorizedSshKeysGetHelper,
   sizeof(remote_domain_authorized_ssh_keys_get_args),
   (xdrproc_t)xdr_remote_domain_authorized_ssh_keys_get_args,
   sizeof(remote_domain_authorized_ssh_keys_get_ret),
   (xdrproc_t)xdr_remote_domain_authorized_ssh_keys_get_ret,
   true,
   0
},
{ /* Method DomainAuthorizedSshKeysSet => 425 */
   remoteDispatchDomainAuthorizedSshKeysSetHelper,
   sizeof(remote_domain_authorized_ssh_keys_set_args),
   (xdrproc_t)xdr_remote_domain_authorized_ssh_keys_set_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainGetMessages => 426 */
   remoteDispatchDomainGetMessagesHelper,
   sizeof(remote_domain_get_messages_args),
   (xdrproc_t)xdr_remote_domain_get_messages_args,
   sizeof(remote_domain_get_messages_ret),
   (xdrproc_t)xdr_remote_domain_get_messages_ret,
   true,
   0
},
{ /* Method DomainStartDirtyRateCalc => 427 */
   remoteDispatchDomainStartDirtyRateCalcHelper,
   sizeof(remote_domain_start_dirty_rate_calc_args),
   (xdrproc_t)xdr_remote_domain_start_dirty_rate_calc_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method NodeDeviceDefineXML => 428 */
   remoteDispatchNodeDeviceDefineXMLHelper,
   sizeof(remote_node_device_define_xml_args),
   (xdrproc_t)xdr_remote_node_device_define_xml_args,
   sizeof(remote_node_device_define_xml_ret),
   (xdrproc_t)xdr_remote_node_device_define_xml_ret,
   true,
   0
},
{ /* Method NodeDeviceUndefine => 429 */
   remoteDispatchNodeDeviceUndefineHelper,
   sizeof(remote_node_device_undefine_args),
   (xdrproc_t)xdr_remote_node_device_undefine_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method NodeDeviceCreate => 430 */
   remoteDispatchNodeDeviceCreateHelper,
   sizeof(remote_node_device_create_args),
   (xdrproc_t)xdr_remote_node_device_create_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method NWFilterDefineXMLFlags => 431 */
   remoteDispatchNWFilterDefineXMLFlagsHelper,
   sizeof(remote_nwfilter_define_xml_flags_args),
   (xdrproc_t)xdr_remote_nwfilter_define_xml_flags_args,
   sizeof(remote_nwfilter_define_xml_flags_ret),
   (xdrproc_t)xdr_remote_nwfilter_define_xml_flags_ret,
   true,
   1
},
{ /* Method NetworkDefineXMLFlags => 432 */
   remoteDispatchNetworkDefineXMLFlagsHelper,
   sizeof(remote_network_define_xml_flags_args),
   (xdrproc_t)xdr_remote_network_define_xml_flags_args,
   sizeof(remote_network_define_xml_flags_ret),
   (xdrproc_t)xdr_remote_network_define_xml_flags_ret,
   true,
   1
},
{ /* Method NodeDeviceGetAutostart => 433 */
   remoteDispatchNodeDeviceGetAutostartHelper,
   sizeof(remote_node_device_get_autostart_args),
   (xdrproc_t)xdr_remote_node_device_get_autostart_args,
   sizeof(remote_node_device_get_autostart_ret),
   (xdrproc_t)xdr_remote_node_device_get_autostart_ret,
   true,
   1
},
{ /* Method NodeDeviceSetAutostart => 434 */
   remoteDispatchNodeDeviceSetAutostartHelper,
   sizeof(remote_node_device_set_autostart_args),
   (xdrproc_t)xdr_remote_node_device_set_autostart_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method NodeDeviceIsPersistent => 435 */
   remoteDispatchNodeDeviceIsPersistentHelper,
   sizeof(remote_node_device_is_persistent_args),
   (xdrproc_t)xdr_remote_node_device_is_persistent_args,
   sizeof(remote_node_device_is_persistent_ret),
   (xdrproc_t)xdr_remote_node_device_is_persistent_ret,
   true,
   1
},
{ /* Method NodeDeviceIsActive => 436 */
   remoteDispatchNodeDeviceIsActiveHelper,
   sizeof(remote_node_device_is_active_args),
   (xdrproc_t)xdr_remote_node_device_is_active_args,
   sizeof(remote_node_device_is_active_ret),
   (xdrproc_t)xdr_remote_node_device_is_active_ret,
   true,
   1
},
{ /* Method NetworkCreateXMLFlags => 437 */
   remoteDispatchNetworkCreateXMLFlagsHelper,
   sizeof(remote_network_create_xml_flags_args),
   (xdrproc_t)xdr_remote_network_create_xml_flags_args,
   sizeof(remote_network_create_xml_flags_ret),
   (xdrproc_t)xdr_remote_network_create_xml_flags_ret,
   true,
   1
},
{ /* Async event DomainEventMemoryDeviceSizeChange => 438 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainSetLaunchSecurityState => 439 */
   remoteDispatchDomainSetLaunchSecurityStateHelper,
   sizeof(remote_domain_set_launch_security_state_args),
   (xdrproc_t)xdr_remote_domain_set_launch_security_state_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainSaveParams => 440 */
   remoteDispatchDomainSaveParamsHelper,
   sizeof(remote_domain_save_params_args),
   (xdrproc_t)xdr_remote_domain_save_params_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainRestoreParams => 441 */
   remoteDispatchDomainRestoreParamsHelper,
   sizeof(remote_domain_restore_params_args),
   (xdrproc_t)xdr_remote_domain_restore_params_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainAbortJobFlags => 442 */
   remoteDispatchDomainAbortJobFlagsHelper,
   sizeof(remote_domain_abort_job_flags_args),
   (xdrproc_t)xdr_remote_domain_abort_job_flags_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainFdAssociate => 443 */
   remoteDispatchDomainFdAssociateHelper,
   sizeof(remote_domain_fd_associate_args),
   (xdrproc_t)xdr_remote_domain_fd_associate_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method NetworkSetMetadata => 444 */
   remoteDispatchNetworkSetMetadataHelper,
   sizeof(remote_network_set_metadata_args),
   (xdrproc_t)xdr_remote_network_set_metadata_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method NetworkGetMetadata => 445 */
   remoteDispatchNetworkGetMetadataHelper,
   sizeof(remote_network_get_metadata_args),
   (xdrproc_t)xdr_remote_network_get_metadata_args,
   sizeof(remote_network_get_metadata_ret),
   (xdrproc_t)xdr_remote_network_get_metadata_ret,
   true,
   0
},
{ /* Async event NetworkEventCallbackMetadataChange => 446 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method NodeDeviceUpdate => 447 */
   remoteDispatchNodeDeviceUpdateHelper,
   sizeof(remote_node_device_update_args),
   (xdrproc_t)xdr_remote_node_device_update_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method DomainGraphicsReload => 448 */
   remoteDispatchDomainGraphicsReloadHelper,
   sizeof(remote_domain_graphics_reload_args),
   (xdrproc_t)xdr_remote_domain_graphics_reload_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainGetAutostartOnce => 449 */
   remoteDispatchDomainGetAutostartOnceHelper,
   sizeof(remote_domain_get_autostart_once_args),
   (xdrproc_t)xdr_remote_domain_get_autostart_once_args,
   sizeof(remote_domain_get_autostart_once_ret),
   (xdrproc_t)xdr_remote_domain_get_autostart_once_ret,
   true,
   1
},
{ /* Method DomainSetAutostartOnce => 450 */
   remoteDispatchDomainSetAutostartOnceHelper,
   sizeof(remote_domain_set_autostart_once_args),
   (xdrproc_t)xdr_remote_domain_set_autostart_once_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method DomainSetThrottleGroup => 451 */
   remoteDispatchDomainSetThrottleGroupHelper,
   sizeof(remote_domain_set_throttle_group_args),
   (xdrproc_t)xdr_remote_domain_set_throttle_group_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainDelThrottleGroup => 452 */
   remoteDispatchDomainDelThrottleGroupHelper,
   sizeof(remote_domain_del_throttle_group_args),
   (xdrproc_t)xdr_remote_domain_del_throttle_group_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventNicMACChange => 453 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
};
size_t remoteNProcs = G_N_ELEMENTS(remoteProcs);
