
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kcolorcombo_wrapper.h"

// Wrappers providing overrides
#include "kxyselector_wrapper.h"
#include "ktimecombobox_wrapper.h"

// Argument includes
#include <QList>
#include <qabstractitemmodel.h>
#include <qbytearray.h>
#include <qcolor.h>
#include <qcoreevent.h>
#include <qevent.h>
#include <qmetaobject.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpoint.h>
#include <qsize.h>
#include <qstyleoption.h>
#include <qvariant.h>
#include <qwidget.h>

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KColorCombo_Type = nullptr;
static PyTypeObject *Sbk_KColorCombo_TypeF(void)
{
    return _Sbk_KColorCombo_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KColorComboWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KColorComboWrapper::KColorComboWrapper(::QWidget * parent) : KColorCombo(parent)
{
}

void KColorComboWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    KXYSelectorWrapper::sbk_o_actionEvent("KColorCombo", funcName, gil, pyOverride, event);
}

void KColorComboWrapper::changeEvent(::QEvent * e)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::changeEvent(e);
    }
    KXYSelectorWrapper::sbk_o_changeEvent("KColorCombo", funcName, gil, pyOverride, e);
}

void KColorComboWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KColorCombo", funcName, gil, pyOverride, event);
}

void KColorComboWrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_closeEvent("KColorCombo", funcName, gil, pyOverride, event);
}

void KColorComboWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KColorCombo", funcName, gil, pyOverride, signal);
}

void KColorComboWrapper::contextMenuEvent(::QContextMenuEvent * e)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::contextMenuEvent(e);
    }
    KXYSelectorWrapper::sbk_o_contextMenuEvent("KColorCombo", funcName, gil, pyOverride, e);
}

void KColorComboWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KColorCombo", funcName, gil, pyOverride, event);
}

int KColorComboWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return KXYSelectorWrapper::sbk_o_devType("KColorCombo", funcName, gil, pyOverride);
}

void KColorComboWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KColorCombo", funcName, gil, pyOverride, signal);
}

void KColorComboWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragEnterEvent("KColorCombo", funcName, gil, pyOverride, event);
}

void KColorComboWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragLeaveEvent("KColorCombo", funcName, gil, pyOverride, event);
}

void KColorComboWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragMoveEvent("KColorCombo", funcName, gil, pyOverride, event);
}

void KColorComboWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dropEvent("KColorCombo", funcName, gil, pyOverride, event);
}

void KColorComboWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_enterEvent("KColorCombo", funcName, gil, pyOverride, event);
}

bool KColorComboWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::event(event);
    }
    return KXYSelectorWrapper::sbk_o_event("KColorCombo", funcName, gil, pyOverride, event);
}

bool KColorComboWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KColorCombo", funcName, gil, pyOverride, watched, event);
}

void KColorComboWrapper::focusInEvent(::QFocusEvent * e)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::focusInEvent(e);
    }
    KXYSelectorWrapper::sbk_o_focusInEvent("KColorCombo", funcName, gil, pyOverride, e);
}

bool KColorComboWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return KXYSelectorWrapper::sbk_o_focusNextPrevChild("KColorCombo", funcName, gil, pyOverride, next);
}

void KColorComboWrapper::focusOutEvent(::QFocusEvent * e)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::focusOutEvent(e);
    }
    KXYSelectorWrapper::sbk_o_focusOutEvent("KColorCombo", funcName, gil, pyOverride, e);
}

bool KColorComboWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return KXYSelectorWrapper::sbk_o_hasHeightForWidth("KColorCombo", funcName, gil, pyOverride);
}

int KColorComboWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_heightForWidth("KColorCombo", funcName, gil, pyOverride, arg__1);
}

void KColorComboWrapper::hideEvent(::QHideEvent * e)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::hideEvent(e);
    }
    KXYSelectorWrapper::sbk_o_hideEvent("KColorCombo", funcName, gil, pyOverride, e);
}

void KColorComboWrapper::hidePopup()
{
    static const char *funcName = "hidePopup";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::hidePopup();
    }
    KTimeComboBoxWrapper::sbk_o_hidePopup("KColorCombo", funcName, gil, pyOverride);
}

void KColorComboWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    KXYSelectorWrapper::sbk_o_drawContents("KColorCombo", funcName, gil, pyOverride, painter);
}

void KColorComboWrapper::initStyleOption(::QStyleOptionComboBox * option) const
{
    static const char *funcName = "initStyleOption";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::initStyleOption(option);
    }
    KTimeComboBoxWrapper::sbk_o_initStyleOption("KColorCombo", funcName, gil, pyOverride, option);
}

void KColorComboWrapper::inputMethodEvent(::QInputMethodEvent * arg__1)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::inputMethodEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_inputMethodEvent("KColorCombo", funcName, gil, pyOverride, arg__1);
}

::QVariant KColorComboWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::inputMethodQuery(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_inputMethodQuery("KColorCombo", funcName, gil, pyOverride, arg__1);
}

void KColorComboWrapper::keyPressEvent(::QKeyEvent * e)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::keyPressEvent(e);
    }
    KXYSelectorWrapper::sbk_o_keyPressEvent("KColorCombo", funcName, gil, pyOverride, e);
}

void KColorComboWrapper::keyReleaseEvent(::QKeyEvent * e)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::keyReleaseEvent(e);
    }
    KXYSelectorWrapper::sbk_o_keyReleaseEvent("KColorCombo", funcName, gil, pyOverride, e);
}

void KColorComboWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_leaveEvent("KColorCombo", funcName, gil, pyOverride, event);
}

int KColorComboWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_metric("KColorCombo", funcName, gil, pyOverride, arg__1);
}

::QSize KColorComboWrapper::minimumSizeHint() const
{
    static const char *funcName = "minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::minimumSizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KColorCombo", funcName, gil, pyOverride);
}

void KColorComboWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseDoubleClickEvent("KColorCombo", funcName, gil, pyOverride, event);
}

void KColorComboWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseMoveEvent("KColorCombo", funcName, gil, pyOverride, event);
}

void KColorComboWrapper::mousePressEvent(::QMouseEvent * e)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::mousePressEvent(e);
    }
    KXYSelectorWrapper::sbk_o_mousePressEvent("KColorCombo", funcName, gil, pyOverride, e);
}

void KColorComboWrapper::mouseReleaseEvent(::QMouseEvent * e)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::mouseReleaseEvent(e);
    }
    KXYSelectorWrapper::sbk_o_mouseReleaseEvent("KColorCombo", funcName, gil, pyOverride, e);
}

void KColorComboWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_moveEvent("KColorCombo", funcName, gil, pyOverride, event);
}

bool KColorComboWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return KXYSelectorWrapper::sbk_o_nativeEvent("KColorCombo", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * KColorComboWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return KXYSelectorWrapper::sbk_o_paintEngine("KColorCombo", funcName, gil, pyOverride);
}

void KColorComboWrapper::paintEvent(::QPaintEvent * event)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::KColorCombo::paintEvent(event);
    }
    KXYSelectorWrapper::sbk_o_paintEvent("KColorCombo", funcName, gil, pyOverride, event);
}

::QPaintDevice * KColorComboWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return KXYSelectorWrapper::sbk_o_redirected("KColorCombo", funcName, gil, pyOverride, offset);
}

void KColorComboWrapper::resizeEvent(::QResizeEvent * e)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::resizeEvent(e);
    }
    KXYSelectorWrapper::sbk_o_resizeEvent("KColorCombo", funcName, gil, pyOverride, e);
}

void KColorComboWrapper::setModel(::QAbstractItemModel * model)
{
    static const char *funcName = "setModel";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::setModel(model);
    }
    KTimeComboBoxWrapper::sbk_o_setModel("KColorCombo", funcName, gil, pyOverride, model);
}

void KColorComboWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    KXYSelectorWrapper::sbk_o_setVisible("KColorCombo", funcName, gil, pyOverride, visible);
}

::QPainter * KColorComboWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return KXYSelectorWrapper::sbk_o_sharedPainter("KColorCombo", funcName, gil, pyOverride);
}

void KColorComboWrapper::showEvent(::QShowEvent * e)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::showEvent(e);
    }
    KXYSelectorWrapper::sbk_o_showEvent("KColorCombo", funcName, gil, pyOverride, e);
}

void KColorComboWrapper::showPopup()
{
    static const char *funcName = "showPopup";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::showPopup();
    }
    KTimeComboBoxWrapper::sbk_o_hidePopup("KColorCombo", funcName, gil, pyOverride);
}

::QSize KColorComboWrapper::sizeHint() const
{
    static const char *funcName = "sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[47], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::sizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KColorCombo", funcName, gil, pyOverride);
}

void KColorComboWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[48], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    KXYSelectorWrapper::sbk_o_tabletEvent("KColorCombo", funcName, gil, pyOverride, event);
}

void KColorComboWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[49], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KColorCombo", funcName, gil, pyOverride, event);
}

void KColorComboWrapper::wheelEvent(::QWheelEvent * e)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorCombo_TypeF(), gil, funcName, m_PyMethodCache[50], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::wheelEvent(e);
    }
    KXYSelectorWrapper::sbk_o_wheelEvent("KColorCombo", funcName, gil, pyOverride, e);
}

const QMetaObject *KColorComboWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KColorCombo::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KColorComboWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KColorCombo::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KColorComboWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KColorComboWrapper *>(this));
    }
    return KColorCombo::qt_metacast(_clname);
}

KColorComboWrapper::~KColorComboWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KColorCombo_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KColorCombo_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KColorCombo >()))
        return -1;

    KColorComboWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:KColorCombo", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KColorCombo::KColorCombo(QWidget*=)
    if (numArgs == 0) {
        overloadId = 0; // KColorCombo(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KColorCombo(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KColorCombo_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KColorCombo_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KColorCombo_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QWidget *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KColorCombo(QWidget*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KColorComboWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KColorComboWrapper(cppArg0);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KColorCombo >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KColorCombo_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KColorCombo_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KColorComboFunc_color(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KColorCombo *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KColorCombo_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // color()const
        QColor cppResult = const_cast<const ::KColorCombo *>(cppSelf)->color();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KColorComboFunc_colors(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KColorCombo *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KColorCombo_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // colors()const
        QList<QColor> cppResult = const_cast<const ::KColorCombo *>(cppSelf)->colors();
        pyResult = Shiboken::Conversions::copyToPython(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QColor_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KColorComboFunc_isCustomColor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KColorCombo *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KColorCombo_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isCustomColor()const
        bool cppResult = const_cast<const ::KColorCombo *>(cppSelf)->isCustomColor();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KColorComboFunc_paintEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KColorCombo *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KColorCombo_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::paintEvent(QPaintEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintEvent_IDX]), (pyArg)))) {
        overloadId = 0; // paintEvent(QPaintEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "paintEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KColorCombo_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPaintEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // paintEvent(QPaintEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KColorCombo::paintEvent(cppArg0)
                : cppSelf->paintEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KColorComboFunc_setColor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KColorCombo *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KColorCombo_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KColorCombo::setColor(QColor)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), (pyArg)))) {
        overloadId = 0; // setColor(QColor)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setColor", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KColorCombo_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setColor(QColor)
            cppSelf->setColor(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KColorComboFunc_setColors(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KColorCombo *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KColorCombo_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KColorCombo::setColors(QList<QColor>)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QColor_IDX], (pyArg)))) {
        overloadId = 0; // setColors(QList<QColor>)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setColors", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KColorCombo_IDX]);

    // Call function/method
    {
        ::QList<QColor> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setColors(QList<QColor>)
            cppSelf->setColors(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KColorComboFunc_showEmptyList(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KColorCombo *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KColorCombo_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // showEmptyList()
        cppSelf->showEmptyList();
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KColorCombo_PropertyStrings[] = {
    "color::",
    "colors::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KColorCombo_methods[] = {
    {"color", reinterpret_cast<PyCFunction>(Sbk_KColorComboFunc_color), METH_NOARGS, nullptr},
    {"colors", reinterpret_cast<PyCFunction>(Sbk_KColorComboFunc_colors), METH_NOARGS, nullptr},
    {"isCustomColor", reinterpret_cast<PyCFunction>(Sbk_KColorComboFunc_isCustomColor), METH_NOARGS, nullptr},
    {"paintEvent", reinterpret_cast<PyCFunction>(Sbk_KColorComboFunc_paintEvent), METH_O, nullptr},
    {"setColor", reinterpret_cast<PyCFunction>(Sbk_KColorComboFunc_setColor), METH_O, nullptr},
    {"setColors", reinterpret_cast<PyCFunction>(Sbk_KColorComboFunc_setColors), METH_O, nullptr},
    {"showEmptyList", reinterpret_cast<PyCFunction>(Sbk_KColorComboFunc_showEmptyList), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KColorCombo_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KColorCombo *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KColorCombo_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KColorComboWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KColorCombo_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KColorCombo_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_KColorComboSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::KColorCombo *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QComboBox_IDX]))
        return static_cast< ::QComboBox *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KColorCombo_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KColorCombo_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KColorCombo_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KColorCombo_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KColorCombo_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KColorCombo_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KColorCombo_spec = {
    "1:KWidgetsAddons.KColorCombo",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KColorCombo_slots
};

} //extern "C"

static void *Sbk_KColorCombo_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::KColorCombo *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KColorCombo *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::KColorCombo *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KColorCombo_PythonToCpp_KColorCombo_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KColorCombo_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KColorCombo_PythonToCpp_KColorCombo_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KColorCombo_TypeF()))
        return KColorCombo_PythonToCpp_KColorCombo_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KColorCombo_PTR_CppToPython_KColorCombo(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KColorCombo *>(const_cast<void *>(cppIn)), Sbk_KColorCombo_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KColorCombo_SignatureStrings[] = {
    "KWidgetsAddons.KColorCombo(self,parent:PySide6.QtWidgets.QWidget=nullptr,*:KeywordOnly=None,color:QColor=None,colors:QList[PySide6.QtGui.QColor]=None)",
    "KWidgetsAddons.KColorCombo.color(self)->PySide6.QtGui.QColor",
    "KWidgetsAddons.KColorCombo.colors(self)->QList[PySide6.QtGui.QColor]",
    "KWidgetsAddons.KColorCombo.isCustomColor(self)->bool",
    "KWidgetsAddons.KColorCombo.paintEvent(self,event:PySide6.QtGui.QPaintEvent)",
    "KWidgetsAddons.KColorCombo.setColor(self,col:typing.Union[PySide6.QtGui.QColor, QLatin1String, PySide6.QtGui.QRgba64, QVariant, PySide6.QtCore.Qt.GlobalColor, QString, unsigned int])",
    "KWidgetsAddons.KColorCombo.setColors(self,colors:QList[PySide6.QtGui.QColor])",
    "KWidgetsAddons.KColorCombo.showEmptyList(self)",
    nullptr}; // Sentinel
#else
static constexpr size_t KColorCombo_SignatureByteSize = 277;
static constexpr uint8_t KColorCombo_SignatureBytes[277] = {
    0x78, 0xda, 0x8d, 0x92, 0x5f, 0x4b, 0xc3, 0x30, 0x14, 0xc5, 0xdf, 0xf7, 0x29, 0xfa, 0xe8, 0xa4,
    0x06, 0x04, 0xd9, 0x43, 0x60, 0x82, 0x94, 0xb1, 0x87, 0x0e, 0x5d, 0x1d, 0xea, 0x83, 0xec, 0x21,
    0x35, 0xb1, 0x5e, 0x48, 0xef, 0x2d, 0xc9, 0xed, 0x46, 0xbf, 0xbd, 0xfd, 0x63, 0xb7, 0x3a, 0x66,
    0xe7, 0x53, 0x42, 0x38, 0xe7, 0x77, 0x4f, 0x4e, 0x12, 0xbf, 0x81, 0xce, 0x0c, 0xfb, 0x07, 0xad,
    0x09, 0xbd, 0x88, 0x23, 0xb2, 0xe4, 0x22, 0xca, 0x53, 0xba, 0xf2, 0xc6, 0x7e, 0x86, 0x85, 0x72,
    0x06, 0x59, 0xae, 0xab, 0x0d, 0x68, 0x33, 0x13, 0x09, 0xff, 0xe8, 0x45, 0xd2, 0x6d, 0xe6, 0x58,
    0x5a, 0x5b, 0xb0, 0x0b, 0xaf, 0x65, 0x6c, 0xaa, 0x3d, 0x39, 0xfd, 0x84, 0xb6, 0x9a, 0x3f, 0x12,
    0x9a, 0xf0, 0xa3, 0x61, 0xc9, 0xa4, 0x45, 0x0e, 0x4e, 0xbc, 0x4c, 0x56, 0xe0, 0xf9, 0xfd, 0xc8,
    0x5c, 0x96, 0x20, 0x3a, 0xd9, 0xb6, 0xd5, 0x4d, 0x27, 0xf1, 0x9f, 0xb1, 0x44, 0xcb, 0x68, 0xc3,
    0x4d, 0x6f, 0xee, 0xcf, 0x31, 0x2e, 0x9a, 0x7d, 0xef, 0x1e, 0xc9, 0x31, 0x06, 0x01, 0x1f, 0x95,
    0x9e, 0x29, 0x8f, 0x86, 0x49, 0x52, 0x22, 0x3b, 0x66, 0x2a, 0x14, 0x20, 0x2f, 0x76, 0x75, 0x99,
    0x5d, 0xb1, 0x66, 0xf7, 0xbb, 0xd7, 0x76, 0xf6, 0xfa, 0x20, 0x1a, 0xad, 0xc0, 0x1b, 0x3e, 0xce,
    0x6e, 0x4a, 0x95, 0x5c, 0x15, 0x80, 0x99, 0x78, 0x41, 0x20, 0x3c, 0x7b, 0xa1, 0x30, 0x48, 0x56,
    0x8a, 0x01, 0x6f, 0x37, 0xec, 0x6a, 0x65, 0x18, 0x9c, 0x88, 0x9e, 0xb3, 0x54, 0xcd, 0xee, 0x6a,
    0xd5, 0xab, 0x72, 0xa0, 0x90, 0x87, 0x82, 0x88, 0x9c, 0xa9, 0x17, 0xb1, 0xb4, 0x94, 0x2a, 0xdb,
    0xe3, 0x7a, 0x50, 0x89, 0x1e, 0x32, 0x34, 0x3a, 0xa8, 0xa3, 0x6f, 0xff, 0x15, 0xdb, 0x1f, 0x72,
    0x5f, 0xf8, 0x0c, 0xe3, 0xb4, 0x2f, 0xda, 0x2f, 0xf2, 0x82, 0xab, 0xc6, 0xdf, 0xbd, 0xc2, 0xe4,
    0x1b, 0xbe, 0x91, 0x03, 0xec
};
#endif

PyTypeObject *init_KColorCombo(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KColorCombo_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KColorCombo_IDX].type;

    Shiboken::AutoDecRef Sbk_KColorCombo_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QComboBox_IDX]))));

    _Sbk_KColorCombo_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KColorCombo",
        "KColorCombo*",
        &Sbk_KColorCombo_spec,
        &Shiboken::callCppDestructor< KColorCombo >,
        Sbk_KColorCombo_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = Sbk_KColorCombo_TypeF(); // references _Sbk_KColorCombo_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KColorCombo_SignatureStrings);
#else
    InitSignatureBytes(pyType, KColorCombo_SignatureBytes, KColorCombo_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KColorCombo_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KColorCombo_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KColorCombo_PythonToCpp_KColorCombo_PTR,
        is_KColorCombo_PythonToCpp_KColorCombo_PTR_Convertible,
        KColorCombo_PTR_CppToPython_KColorCombo);

    Shiboken::Conversions::registerConverterName(converter, "KColorCombo");
    Shiboken::Conversions::registerConverterName(converter, "KColorCombo*");
    Shiboken::Conversions::registerConverterName(converter, "KColorCombo&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KColorCombo).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KColorComboWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_KColorCombo_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_KColorCombo_TypeF(), &Sbk_KColorComboSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KColorCombo_TypeF(), &Sbk_KColorCombo_typeDiscovery);

    PySide::Signal::registerSignals(pyType, &::KColorCombo::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KColorCombo::staticMetaObject, sizeof(KColorComboWrapper));

    return pyType;
}
