//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/extensions/filters/network/reverse_tunnel/v3/reverse_tunnel.proto

package reverse_tunnelv3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"

	v3 "github.com/envoyproxy/go-control-plane/envoy/config/core/v3"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort

	_ = v3.RequestMethod(0)
)

// Validate checks the field values on Validation with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Validation) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Validation with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in ValidationMultiError, or
// nil if none found.
func (m *Validation) ValidateAll() error {
	return m.validate(true)
}

func (m *Validation) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetNodeIdFormat()) > 1024 {
		err := ValidationValidationError{
			field:  "NodeIdFormat",
			reason: "value length must be at most 1024 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if utf8.RuneCountInString(m.GetClusterIdFormat()) > 1024 {
		err := ValidationValidationError{
			field:  "ClusterIdFormat",
			reason: "value length must be at most 1024 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for EmitDynamicMetadata

	if utf8.RuneCountInString(m.GetDynamicMetadataNamespace()) > 255 {
		err := ValidationValidationError{
			field:  "DynamicMetadataNamespace",
			reason: "value length must be at most 255 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return ValidationMultiError(errors)
	}

	return nil
}

// ValidationMultiError is an error wrapping multiple validation errors
// returned by Validation.ValidateAll() if the designated constraints aren't met.
type ValidationMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ValidationMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ValidationMultiError) AllErrors() []error { return m }

// ValidationValidationError is the validation error returned by
// Validation.Validate if the designated constraints aren't met.
type ValidationValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ValidationValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ValidationValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ValidationValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ValidationValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ValidationValidationError) ErrorName() string { return "ValidationValidationError" }

// Error satisfies the builtin error interface
func (e ValidationValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sValidation.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ValidationValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ValidationValidationError{}

// Validate checks the field values on ReverseTunnel with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *ReverseTunnel) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ReverseTunnel with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in ReverseTunnelMultiError, or
// nil if none found.
func (m *ReverseTunnel) ValidateAll() error {
	return m.validate(true)
}

func (m *ReverseTunnel) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if d := m.GetPingInterval(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = ReverseTunnelValidationError{
				field:  "PingInterval",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			lte := time.Duration(300*time.Second + 0*time.Nanosecond)
			gte := time.Duration(0*time.Second + 1000000*time.Nanosecond)

			if dur < gte || dur > lte {
				err := ReverseTunnelValidationError{
					field:  "PingInterval",
					reason: "value must be inside range [1ms, 5m0s]",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	// no validation rules for AutoCloseConnections

	if m.GetRequestPath() != "" {

		if l := utf8.RuneCountInString(m.GetRequestPath()); l < 1 || l > 255 {
			err := ReverseTunnelValidationError{
				field:  "RequestPath",
				reason: "value length must be between 1 and 255 runes, inclusive",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if _, ok := v3.RequestMethod_name[int32(m.GetRequestMethod())]; !ok {
		err := ReverseTunnelValidationError{
			field:  "RequestMethod",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetValidation()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ReverseTunnelValidationError{
					field:  "Validation",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ReverseTunnelValidationError{
					field:  "Validation",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetValidation()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ReverseTunnelValidationError{
				field:  "Validation",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return ReverseTunnelMultiError(errors)
	}

	return nil
}

// ReverseTunnelMultiError is an error wrapping multiple validation errors
// returned by ReverseTunnel.ValidateAll() if the designated constraints
// aren't met.
type ReverseTunnelMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ReverseTunnelMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ReverseTunnelMultiError) AllErrors() []error { return m }

// ReverseTunnelValidationError is the validation error returned by
// ReverseTunnel.Validate if the designated constraints aren't met.
type ReverseTunnelValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ReverseTunnelValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ReverseTunnelValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ReverseTunnelValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ReverseTunnelValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ReverseTunnelValidationError) ErrorName() string { return "ReverseTunnelValidationError" }

// Error satisfies the builtin error interface
func (e ReverseTunnelValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sReverseTunnel.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ReverseTunnelValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ReverseTunnelValidationError{}
