{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The @PangoAttrInt@ structure is used to represent attributes with
-- an integer or enumeration value.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Pango.Structs.AttrInt
    ( 

-- * Exported types
    AttrInt(..)                             ,
    newZeroAttrInt                          ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveAttrIntMethod                    ,
#endif



 -- * Properties


-- ** attr #attr:attr#
-- | the common portion of the attribute

#if defined(ENABLE_OVERLOADING)
    attrInt_attr                            ,
#endif
    getAttrIntAttr                          ,


-- ** value #attr:value#
-- | the value of the attribute

#if defined(ENABLE_OVERLOADING)
    attrInt_value                           ,
#endif
    getAttrIntValue                         ,
    setAttrIntValue                         ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.Pango.Callbacks as Pango.Callbacks
import {-# SOURCE #-} qualified GI.Pango.Enums as Pango.Enums
import {-# SOURCE #-} qualified GI.Pango.Flags as Pango.Flags
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrClass as Pango.AttrClass
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrColor as Pango.AttrColor
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrFloat as Pango.AttrFloat
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrFontDesc as Pango.AttrFontDesc
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrFontFeatures as Pango.AttrFontFeatures
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrLanguage as Pango.AttrLanguage
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrShape as Pango.AttrShape
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrSize as Pango.AttrSize
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrString as Pango.AttrString
import {-# SOURCE #-} qualified GI.Pango.Structs.Attribute as Pango.Attribute
import {-# SOURCE #-} qualified GI.Pango.Structs.Color as Pango.Color
import {-# SOURCE #-} qualified GI.Pango.Structs.FontDescription as Pango.FontDescription
import {-# SOURCE #-} qualified GI.Pango.Structs.Language as Pango.Language
import {-# SOURCE #-} qualified GI.Pango.Structs.Rectangle as Pango.Rectangle

#else
import {-# SOURCE #-} qualified GI.Pango.Structs.Attribute as Pango.Attribute

#endif

-- | Memory-managed wrapper type.
newtype AttrInt = AttrInt (SP.ManagedPtr AttrInt)
    deriving (Eq)

instance SP.ManagedPtrNewtype AttrInt where
    toManagedPtr (AttrInt p) = p

instance BoxedPtr AttrInt where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 24 >=> B.ManagedPtr.wrapPtr AttrInt)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr AttrInt where
    boxedPtrCalloc = callocBytes 24


-- | Construct a t'AttrInt' struct initialized to zero.
newZeroAttrInt :: MonadIO m => m AttrInt
newZeroAttrInt = liftIO $ boxedPtrCalloc >>= wrapPtr AttrInt

instance tag ~ 'AttrSet => Constructible AttrInt tag where
    new _ attrs = do
        o <- newZeroAttrInt
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@attr@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' attrInt #attr
-- @
getAttrIntAttr :: MonadIO m => AttrInt -> m Pango.Attribute.Attribute
getAttrIntAttr s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 0 :: (Ptr Pango.Attribute.Attribute)
    val' <- (newBoxed Pango.Attribute.Attribute) val
    return val'

#if defined(ENABLE_OVERLOADING)
data AttrIntAttrFieldInfo
instance AttrInfo AttrIntAttrFieldInfo where
    type AttrBaseTypeConstraint AttrIntAttrFieldInfo = (~) AttrInt
    type AttrAllowedOps AttrIntAttrFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint AttrIntAttrFieldInfo = (~) (Ptr Pango.Attribute.Attribute)
    type AttrTransferTypeConstraint AttrIntAttrFieldInfo = (~)(Ptr Pango.Attribute.Attribute)
    type AttrTransferType AttrIntAttrFieldInfo = (Ptr Pango.Attribute.Attribute)
    type AttrGetType AttrIntAttrFieldInfo = Pango.Attribute.Attribute
    type AttrLabel AttrIntAttrFieldInfo = "attr"
    type AttrOrigin AttrIntAttrFieldInfo = AttrInt
    attrGet = getAttrIntAttr
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.AttrInt.attr"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-AttrInt.html#g:attr:attr"
        })

attrInt_attr :: AttrLabelProxy "attr"
attrInt_attr = AttrLabelProxy

#endif


-- | Get the value of the “@value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' attrInt #value
-- @
getAttrIntValue :: MonadIO m => AttrInt -> m Int32
getAttrIntValue s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO Int32
    return val

-- | Set the value of the “@value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' attrInt [ #value 'Data.GI.Base.Attributes.:=' value ]
-- @
setAttrIntValue :: MonadIO m => AttrInt -> Int32 -> m ()
setAttrIntValue s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data AttrIntValueFieldInfo
instance AttrInfo AttrIntValueFieldInfo where
    type AttrBaseTypeConstraint AttrIntValueFieldInfo = (~) AttrInt
    type AttrAllowedOps AttrIntValueFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint AttrIntValueFieldInfo = (~) Int32
    type AttrTransferTypeConstraint AttrIntValueFieldInfo = (~)Int32
    type AttrTransferType AttrIntValueFieldInfo = Int32
    type AttrGetType AttrIntValueFieldInfo = Int32
    type AttrLabel AttrIntValueFieldInfo = "value"
    type AttrOrigin AttrIntValueFieldInfo = AttrInt
    attrGet = getAttrIntValue
    attrSet = setAttrIntValue
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.AttrInt.value"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-AttrInt.html#g:attr:value"
        })

attrInt_value :: AttrLabelProxy "value"
attrInt_value = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList AttrInt
type instance O.AttributeList AttrInt = AttrIntAttributeList
type AttrIntAttributeList = ('[ '("attr", AttrIntAttrFieldInfo), '("value", AttrIntValueFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveAttrIntMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveAttrIntMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveAttrIntMethod t AttrInt, O.OverloadedMethod info AttrInt p) => OL.IsLabel t (AttrInt -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveAttrIntMethod t AttrInt, O.OverloadedMethod info AttrInt p, R.HasField t AttrInt p) => R.HasField t AttrInt p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveAttrIntMethod t AttrInt, O.OverloadedMethodInfo info AttrInt) => OL.IsLabel t (O.MethodProxy info AttrInt) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


