/* db-context.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from db-context.vala, do not modify */

/*
 * Copyright © 2016 Software Freedom Conservancy Inc.
 * Copyright © 2020 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GEARY_DB_CONTEXT_0_PROPERTY,
	GEARY_DB_CONTEXT_LOGGING_PARENT_PROPERTY,
	GEARY_DB_CONTEXT_NUM_PROPERTIES
};
static GParamSpec* geary_db_context_properties[GEARY_DB_CONTEXT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

static gpointer geary_db_context_parent_class = NULL;
gboolean geary_db_context_enable_sql_logging = FALSE;
gboolean geary_db_context_enable_result_logging = FALSE;
static GearyLoggingSourceIface * geary_db_context_geary_logging_source_parent_iface = NULL;

VALA_EXTERN GearyDbDatabase* geary_db_context_get_database (GearyDbContext* self);
VALA_EXTERN GearyDbDatabaseConnection* geary_db_context_get_connection (GearyDbContext* self);
VALA_EXTERN GearyDbStatement* geary_db_context_get_statement (GearyDbContext* self);
VALA_EXTERN GearyDbResult* geary_db_context_get_result (GearyDbContext* self);
static GearyDbDatabase* geary_db_context_real_get_database (GearyDbContext* self);
static GearyDbDatabaseConnection* geary_db_context_real_get_connection (GearyDbContext* self);
VALA_EXTERN GearyDbDatabaseConnection* geary_db_statement_get_connection (GearyDbStatement* self);
static GearyDbStatement* geary_db_context_real_get_statement (GearyDbContext* self);
static GearyDbResult* geary_db_context_real_get_result (GearyDbContext* self);
static GearyLoggingState* geary_db_context_real_to_logging_state (GearyDbContext* self);
VALA_EXTERN gint geary_db_throw_on_error (GearyDbContext* ctx,
                              const gchar* method,
                              gint _result_,
                              const gchar* raw,
                              GError** error);
static void geary_db_context_finalize (GObject * obj);
static GType geary_db_context_get_type_once (void);
static void _vala_geary_db_context_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);

static const gchar*
geary_db_context_real_get_logging_domain (GearyLoggingSource* base)
{
	const gchar* result;
	GearyDbContext* self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_DB_TYPE_CONTEXT, GearyDbContext);
	result = GEARY_DB_CONTEXT_LOGGING_DOMAIN;
	return result;
}

GearyLoggingSource*
geary_db_context_get_logging_parent (GearyDbContext* self)
{
	GearyDbContextClass* _klass_;
	g_return_val_if_fail (GEARY_DB_IS_CONTEXT (self), NULL);
	_klass_ = GEARY_DB_CONTEXT_GET_CLASS (self);
	if (_klass_->get_logging_parent) {
		return _klass_->get_logging_parent (self);
	}
	return NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GearyDbDatabase*
geary_db_context_real_get_database (GearyDbContext* self)
{
	GearyDbDatabase* _tmp0_ = NULL;
	GearyDbDatabaseConnection* _tmp1_;
	GearyDbDatabaseConnection* _tmp2_;
	gboolean _tmp3_;
	GearyDbDatabase* _tmp8_;
	GearyDbDatabase* result;
	_tmp1_ = geary_db_context_get_connection (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ != NULL;
	_g_object_unref0 (_tmp2_);
	if (_tmp3_) {
		GearyDbDatabaseConnection* _tmp4_;
		GearyDbDatabaseConnection* _tmp5_;
		GearyDbDatabase* _tmp6_;
		GearyDbDatabase* _tmp7_;
		_tmp4_ = geary_db_context_get_connection (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = geary_db_connection_get_database (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEARY_DB_TYPE_CONNECTION, GearyDbConnection));
		_tmp7_ = _tmp6_;
		_tmp0_ = _tmp7_;
		_g_object_unref0 (_tmp5_);
	} else {
		_tmp0_ = NULL;
	}
	_tmp8_ = _g_object_ref0 (_tmp0_);
	result = _tmp8_;
	return result;
}

GearyDbDatabase*
geary_db_context_get_database (GearyDbContext* self)
{
	GearyDbContextClass* _klass_;
	g_return_val_if_fail (GEARY_DB_IS_CONTEXT (self), NULL);
	_klass_ = GEARY_DB_CONTEXT_GET_CLASS (self);
	if (_klass_->get_database) {
		return _klass_->get_database (self);
	}
	return NULL;
}

static GearyDbDatabaseConnection*
geary_db_context_real_get_connection (GearyDbContext* self)
{
	GearyDbDatabaseConnection* _tmp0_ = NULL;
	GearyDbStatement* _tmp1_;
	GearyDbStatement* _tmp2_;
	gboolean _tmp3_;
	GearyDbDatabaseConnection* _tmp8_;
	GearyDbDatabaseConnection* result;
	_tmp1_ = geary_db_context_get_statement (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ != NULL;
	_g_object_unref0 (_tmp2_);
	if (_tmp3_) {
		GearyDbStatement* _tmp4_;
		GearyDbStatement* _tmp5_;
		GearyDbDatabaseConnection* _tmp6_;
		GearyDbDatabaseConnection* _tmp7_;
		_tmp4_ = geary_db_context_get_statement (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = geary_db_statement_get_connection (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp0_ = _tmp7_;
		_g_object_unref0 (_tmp5_);
	} else {
		_tmp0_ = NULL;
	}
	_tmp8_ = _g_object_ref0 (_tmp0_);
	result = _tmp8_;
	return result;
}

GearyDbDatabaseConnection*
geary_db_context_get_connection (GearyDbContext* self)
{
	GearyDbContextClass* _klass_;
	g_return_val_if_fail (GEARY_DB_IS_CONTEXT (self), NULL);
	_klass_ = GEARY_DB_CONTEXT_GET_CLASS (self);
	if (_klass_->get_connection) {
		return _klass_->get_connection (self);
	}
	return NULL;
}

static GearyDbStatement*
geary_db_context_real_get_statement (GearyDbContext* self)
{
	GearyDbStatement* _tmp0_ = NULL;
	GearyDbResult* _tmp1_;
	GearyDbResult* _tmp2_;
	gboolean _tmp3_;
	GearyDbStatement* _tmp8_;
	GearyDbStatement* result;
	_tmp1_ = geary_db_context_get_result (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ != NULL;
	_g_object_unref0 (_tmp2_);
	if (_tmp3_) {
		GearyDbResult* _tmp4_;
		GearyDbResult* _tmp5_;
		GearyDbStatement* _tmp6_;
		GearyDbStatement* _tmp7_;
		_tmp4_ = geary_db_context_get_result (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = geary_db_result_get_statement (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp0_ = _tmp7_;
		_g_object_unref0 (_tmp5_);
	} else {
		_tmp0_ = NULL;
	}
	_tmp8_ = _g_object_ref0 (_tmp0_);
	result = _tmp8_;
	return result;
}

GearyDbStatement*
geary_db_context_get_statement (GearyDbContext* self)
{
	GearyDbContextClass* _klass_;
	g_return_val_if_fail (GEARY_DB_IS_CONTEXT (self), NULL);
	_klass_ = GEARY_DB_CONTEXT_GET_CLASS (self);
	if (_klass_->get_statement) {
		return _klass_->get_statement (self);
	}
	return NULL;
}

static GearyDbResult*
geary_db_context_real_get_result (GearyDbContext* self)
{
	GearyDbResult* result;
	result = NULL;
	return result;
}

GearyDbResult*
geary_db_context_get_result (GearyDbContext* self)
{
	GearyDbContextClass* _klass_;
	g_return_val_if_fail (GEARY_DB_IS_CONTEXT (self), NULL);
	_klass_ = GEARY_DB_CONTEXT_GET_CLASS (self);
	if (_klass_->get_result) {
		return _klass_->get_result (self);
	}
	return NULL;
}

/** {@inheritDoc} */
static GearyLoggingState*
geary_db_context_real_to_logging_state (GearyDbContext* self)
{
	g_critical ("Type `%s' does not implement abstract method `geary_db_context_to_logging_state'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GearyLoggingState*
geary_db_context_to_logging_state (GearyDbContext* self)
{
	GearyDbContextClass* _klass_;
	g_return_val_if_fail (GEARY_DB_IS_CONTEXT (self), NULL);
	_klass_ = GEARY_DB_CONTEXT_GET_CLASS (self);
	if (_klass_->to_logging_state) {
		return _klass_->to_logging_state (self);
	}
	return NULL;
}

inline void
geary_db_context_check_elapsed (GearyDbContext* self,
                                const gchar* message,
                                GTimer* timer,
                                GError** error)
{
	gdouble elapsed = 0.0;
	gdouble threshold = 0.0;
	GearyDbDatabaseConnection* _tmp0_;
	GearyDbDatabaseConnection* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gdouble _tmp4_;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (GEARY_DB_IS_CONTEXT (self));
	g_return_if_fail (message != NULL);
	g_return_if_fail (timer != NULL);
	elapsed = g_timer_elapsed (timer, NULL);
	_tmp0_ = geary_db_context_get_connection (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_db_database_connection_get_busy_timeout (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = (_tmp3_ * 1000.0) / 2.0;
	_g_object_unref0 (_tmp1_);
	threshold = _tmp4_;
	if (threshold > ((gdouble) 0)) {
		_tmp5_ = elapsed > threshold;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		geary_logging_source_warning (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "%s: elapsed time: %lfs (>50%)", message, elapsed);
	} else {
		if (elapsed > 1.0) {
			geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "%s: elapsed time: %lfs (>1s)", message, elapsed);
		}
	}
}

inline gint
geary_db_context_throw_on_error (GearyDbContext* self,
                                 const gchar* method,
                                 gint _result_,
                                 const gchar* raw,
                                 GError** error)
{
	gint _tmp0_ = 0;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (GEARY_DB_IS_CONTEXT (self), 0);
	_tmp0_ = geary_db_throw_on_error (self, method, _result_, raw, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
			gint _tmp1_ = -1;
			g_propagate_error (error, _inner_error0_);
			return _tmp1_;
		} else {
			gint _tmp2_ = -1;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp2_;
		}
	}
	result = _tmp0_;
	return result;
}

GearyDbContext*
geary_db_context_construct (GType object_type)
{
	GearyDbContext * self = NULL;
	self = (GearyDbContext*) geary_base_object_construct (object_type);
	return self;
}

static void
geary_db_context_class_init (GearyDbContextClass * klass,
                             gpointer klass_data)
{
	geary_db_context_parent_class = g_type_class_peek_parent (klass);
	((GearyDbContextClass *) klass)->get_database = (GearyDbDatabase* (*) (GearyDbContext*)) geary_db_context_real_get_database;
	((GearyDbContextClass *) klass)->get_connection = (GearyDbDatabaseConnection* (*) (GearyDbContext*)) geary_db_context_real_get_connection;
	((GearyDbContextClass *) klass)->get_statement = (GearyDbStatement* (*) (GearyDbContext*)) geary_db_context_real_get_statement;
	((GearyDbContextClass *) klass)->get_result = (GearyDbResult* (*) (GearyDbContext*)) geary_db_context_real_get_result;
	((GearyDbContextClass *) klass)->to_logging_state = (GearyLoggingState* (*) (GearyDbContext*)) geary_db_context_real_to_logging_state;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_db_context_get_property;
	G_OBJECT_CLASS (klass)->finalize = geary_db_context_finalize;
	/** {@inheritDoc} */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_DB_CONTEXT_LOGGING_PARENT_PROPERTY, geary_db_context_properties[GEARY_DB_CONTEXT_LOGGING_PARENT_PROPERTY] = g_param_spec_object ("logging-parent", "logging-parent", "logging-parent", GEARY_LOGGING_TYPE_SOURCE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_db_context_geary_logging_source_interface_init (GearyLoggingSourceIface * iface,
                                                      gpointer iface_data)
{
	geary_db_context_geary_logging_source_parent_iface = g_type_interface_peek_parent (iface);
	iface->to_logging_state = (GearyLoggingState* (*) (GearyLoggingSource*)) geary_db_context_to_logging_state;
	iface->get_logging_domain = geary_db_context_real_get_logging_domain;
	iface->get_logging_parent = (GearyLoggingSource* (*) (GearyLoggingSource*)) geary_db_context_get_logging_parent;
}

static void
geary_db_context_instance_init (GearyDbContext * self,
                                gpointer klass)
{
}

static void
geary_db_context_finalize (GObject * obj)
{
	GearyDbContext * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_DB_TYPE_CONTEXT, GearyDbContext);
	G_OBJECT_CLASS (geary_db_context_parent_class)->finalize (obj);
}

/**
 * Context allows for an inspector or utility function to determine at runtime what Geary.Db
 * objects are available to it.  Primarily designed for logging, but could be used in other
 * circumstances.
 *
 * Geary.Db's major classes (Database, Connection, Statement, and Result) inherit from Context.
 */
 G_GNUC_NO_INLINE static GType
geary_db_context_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyDbContextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_db_context_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyDbContext), 0, (GInstanceInitFunc) geary_db_context_instance_init, NULL };
	static const GInterfaceInfo geary_logging_source_info = { (GInterfaceInitFunc) geary_db_context_geary_logging_source_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_db_context_type_id;
	geary_db_context_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyDbContext", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	g_type_add_interface_static (geary_db_context_type_id, GEARY_LOGGING_TYPE_SOURCE, &geary_logging_source_info);
	return geary_db_context_type_id;
}

GType
geary_db_context_get_type (void)
{
	static gsize geary_db_context_type_id__once = 0;
	if (g_once_init_enter (&geary_db_context_type_id__once)) {
		GType geary_db_context_type_id;
		geary_db_context_type_id = geary_db_context_get_type_once ();
		g_once_init_leave (&geary_db_context_type_id__once, geary_db_context_type_id);
	}
	return geary_db_context_type_id__once;
}

static void
_vala_geary_db_context_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	GearyDbContext * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_DB_TYPE_CONTEXT, GearyDbContext);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

